<?php

class LineItem {
	public static $lineItemDbTable = "order_line_items";
	public static $zohoIdFieldName = 'zoho_id';

	public $dbId;
	public $zohoId;
	public $code;
	public $name;
	public $deducted;
	public $deductedOnOpenOrders;
	public $deductedOnShipLog;

	public function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		if ($data->dbId) {
			$this->dbId = $data->dbId;
		}
		elseif ($data->id) {
			$this->dbId = $data->id;
		}
		elseif ($data->lineItemId) {
			$this->dbId = $data->lineItemId;
		}
		elseif ($data->line_item_id) {
			$this->dbId = $data->line_item_id;
		}

		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		elseif ($data->zoho_id) {
			$this->zohoId = $data->zoho_id;
		}

		if ($data->code) {
			$this->code = $data->code;
		}

		if ($data->name) {
			$this->name = $data->name;
		}

		if ($data->deducted !== null) {
			$this->deducted = boolval($data->deducted);
		}

		if ($data->deductedOnOpenOrders !== null) {
			$this->deductedOnOpenOrders = boolval($data->deductedOnOpenOrders);;
		}
		elseif ($data->deducted_on_open_orders !== null) {
			$this->deductedOnOpenOrders = boolval($data->deducted_on_open_orders);
		}

		if ($data->deductedOnShipLog !== null) {
			$this->deductedOnShipLog = boolval($data->deductedOnShipLog);
		}
		elseif ($data->deducted_on_ship_log !== null) {
			$this->deductedOnShipLog = boolval($data->deducted_on_ship_log);
		}
	}

	public function getDbId() {
		return $this->dbId;
	}

	public function setDbId($id) {
		$this->dbId = $id;
	}

	public function isDbIdSet() {
		if ($this->getDbId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}
	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getCode() {
		return $this->code;
	}
	public function setCode($code) {
		$this->code = $code;
	}

	public function getName() {
		return $this->name;
	}
	public function setName($name) {
		$this->name = $name;
	}

	public function getDeducted() {
		return $this->deducted;
	}
	public function setDeducted($deducted) {
		$this->deducted = $deducted;
	}

	public function getDeductedOnOpenOrders() {
		return $this->deductedOnOpenOrders;
	}
	public function setDeductedOnOpenOrders($deductedOnOpenOrders) {
		$this->deductedOnOpenOrders = $deductedOnOpenOrders;
	}

	public function getDeductedOnShipLog() {
		return $this->deductedOnShipLog;
	}
	public function setDeductedOnShipLog($deductedOnShipLog) {
		$this->deductedOnShipLog = $deductedOnShipLog;
	}



	public function populateDbId() {
		if ($this->isDbIdSet()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getLineItemDbTable();
		$zohoIdField = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `$zohoIdField`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setDbId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function populateData() {
		if (!$this->isDbIdSet()) {
			return false;
		}
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		foreach ($result as $key => $value) {
			$this->setKeyValue($key, $value);
		}
	}

	public function setKeyValue($key, $value) {
		$zohoIdAliases = array(
			'zohoId',
			'zoho_id',
			'Owner_Id'
		);
		$nameAliases = array(
			'name'
		);
		$codeAliases = array(
			'code'
		);
		$deductedAliases = array(
			'deducted'
		);
		$deductedOnOpenOrdersAliases = array(
			'deductedOnOpenOrders',
			'deducted_on_open_orders'
		);
		$deductedOnShipLogAliases = array(
			'deductedOnShipLog',
			'deducted_on_ship_log'
		);

		if (in_array($key, $zohoIdAliases)) {
			$this->setZohoId($value);
			return true;
		}
		elseif(in_array($key, $nameAliases)) {
			$this->setName($value);
			return true;
		}
		elseif(in_array($key, $codeAliases)) {
			$this->setCode($value);
			return true;
		}
		elseif(in_array($key, $deductedAliases)) {
			$this->setDeducted((bool)$value);
			return true;
		}
		elseif(in_array($key, $deductedOnOpenOrdersAliases)) {
			$this->setDeductedOnOpenOrders((bool)$value);
			return true;
		}
		elseif(in_array($key, $deductedOnShipLogAliases)) {
			$this->setDeductedOnShipLog((bool)$value);
			return true;
		}
		else {
			return false;
		}
	}

	public function generateInsertQuery() {
		$dbTable = self::getLineItemDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$zohoId = $this->getZohoId();
		$name = mysql_real_escape_string($this->getName());
		$code = mysql_real_escape_string($this->getCode());

		$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`, `code`) VALUES ('$zohoId', '$name', '$code') ON DUPLICATE KEY UPDATE `name`='$name', `code`='$code';";

		return $sql;
	}

	public function generateUpdateQuery() {
		$dbTable = self::getLineItemDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();
		$zohoId = $this->getZohoId();
		$name = mysql_real_escape_string($this->getName());
		$code = mysql_real_escape_string($this->getCode());

		$sql = "UPDATE `$dbTable` SET `name`='$name', `code`='$code' WHERE `id`='$id';";

		return $sql;
	}

	public function save() {
		$db = new Database;
		$dbTable = self::getLineItemDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$this->populateDbId();

		if (!$this->isDbIdSet()) {
			$sql = $this->generateInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
		else {
			$sql = $this->generateUpdateQuery();
			$db->db_query($sql, 'update', true);
		}
		return true;
	}

	public static function getLineItemDbTable() {
		return self::$lineItemDbTable;
	}

	public static function getZohoIdFieldName() {
		return self::$zohoIdFieldName;
	}
}


?>
