<?php

class Lead {
	private static $dbTable = 'lead_list';
	private static $zohoIdField = 'zohoId';

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'zohoId' => array('type' => 'string', 'mutable' => true),
		'salutation' => array('type' => 'string', 'mutable' => true),
		'firstName' => array('type' => 'string', 'mutable' => true),
		'lastName' => array('type' => 'string', 'mutable' => true),
		'email' => array('type' => 'string', 'mutable' => true),
		'phoneNumber' => array('type' => 'string', 'mutable' => true),
		'fax' => array('type' => 'string', 'mutable' => true),
		'organization' => array('type' => 'string', 'mutable' => true),
		'title' => array('type' => 'string', 'mutable' => true),
		'leadSource' => array('type' => 'string', 'mutable' => true),
		'addressStreet' => array('type' => 'string', 'mutable' => true),
		'addressCity' => array('type' => 'string', 'mutable' => true),
		'stateId' => array('type' => 'foreignKey', 'mutable' => true),
		'addressCode' => array('type' => 'string', 'mutable' => true),
		'emailOptOut' => array('type' => 'bool', 'mutable' => true),
	);

	private $id;
	private $zohoId = '';

	private $salutation = '';
	private $firstName = '';
	private $lastName = '';
	private $email = '';
	private $phoneNumber = '';
	private $fax = '';
	private $organization = '';
	private $title = '';

	private $addressStreet = '';
	private $addressCity = '';
	private $stateId = '';
	private $addressCode = '';

	private $leadSource = '';

	private $emailOptOut = false;

	public function __construct($data, $populate=false, $fromDb=false) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		if ($data->fromDb) {
			$fromDb = true;
		}

		if ($fromDb) {
			$dbFields = self::getDbFields();

			foreach ($dbFields as $fieldName => $fieldParams) {
				if ($data->$fieldName !== null) {
					$dataStr = $data->$fieldName;
					$dataType = $fieldParams['type'];
					$final = null;
					if ($dataType == 'encrypted') {
						if ($fromDb) {
							$final = EncryptionController::decryptString($dataStr);
						}
						else {
							$final = trim($dataStr);
						}
					}
					elseif ($dataType == 'string') {
						$final = trim($dataStr);
					}
					elseif ($dataType == 'bool') {
						$final = (bool)$dataStr;
					}
					elseif ($dataType == 'foreignKey' && $fieldName == 'accountId') {
						$accountData = array('id' => $dataStr);
						$account = new Account($accountData, $populate);
					}
					else {
						$final = $dataStr;
					}
					if ($final !== null) {
						$this->$fieldName = $final;
					}
				}
			}
		}
		else {

			if ($data->id) {
				$this->id = $data->id;
			}

			if ($data->zohoId) {
				$zohoIdStr = $data->zohoId;
				if (strpos($zohoIdStr, 'zcrm_') !== false) {
					$zohoIdStr = substr($zohoIdStr, strpos($zohoIdStr, '_')+1);
					$data->zohoId = $zohoIdStr;
				}
				$this->zohoId = $data->zohoId;
			}

			if ($data->salutation) {
				$this->salutation = $data->salutation;
			}

			if ($data->firstName) {
				$this->firstName = $data->firstName;
			}

			if ($data->lastName) {
				$this->lastName = $data->lastName;
			}

			if ($data->email) {
				$this->email = $data->email;
			}

			if ($data->phoneNumber) {
				$this->phoneNumber = $data->phoneNumber;
			}

			if ($data->fax) {
				$this->fax = $data->fax;
			}

			if ($data->organization) {
				$this->organization = $data->organization;
			}

			if ($data->title) {
				$this->title = $data->title;
			}

			if ($data->addressStreet) {
				$this->addressStreet = $data->addressStreet;
			}

			if ($data->addressCity) {
				$this->addressCity = $data->addressCity;
			}

			if ($data->addressCode) {
				$this->addressCode = $data->addressCode;
			}

			if ($data->stateId) {
				$this->stateId = $data->stateId;
			}

			if ($data->leadSource) {
				$this->leadSource = $data->leadSource;
			}

			if ($data->emailOptOut) {
				$this->emailOptOut = $data->emailOptOut;
			}
		}
	}

	/* Begin setters/getters */

	public function getId() {
		return $this->id;
	}
	public function setId($id) {
		$this->id = $id;
	}
	public function populateId() {
		if ($this->getId()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getDbTable();
		$zohoIdField = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `$zohoIdField`='$zohoId' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}
	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getSalutation() {
		return $this->salutation;
	}
	public function setSalutation($salutation) {
		$this->salutation = $salutation;
	}

	public function getFirstName() {
		return $this->firstName;
	}
	public function setFirstName($firstName) {
		$this->firstName = $firstName;
	}

	public function getLastName() {
		return $this->lastName;
	}
	public function setLastName($lastName) {
		$this->lastName = $lastName;
	}

	public function getEmail() {
		return $this->email;
	}
	public function setEmail($email) {
		$this->email = $email;
	}

	public function getPhoneNumber() {
		return $this->phoneNumber;
	}
	public function setPhoneNumber($phoneNumber) {
		$this->phoneNumber = $phoneNumber;
	}

	public function getFax() {
		return $this->fax;
	}
	public function setFax($fax) {
		$this->fax = $fax;
	}

	public function getOrganization() {
		return $this->organization;
	}
	public function setOrganization($organization) {
		$this->organization = $organization;
	}

	public function getTitle() {
		return $this->title;
	}
	public function setTitle($title) {
		$this->title = $title;
	}

	public function getAddressStreet() {
		return $this->addressStreet;
	}
	public function setAddressStreet($addressStreet) {
		$this->addressStreet = $addressStreet;
	}

	public function getAddressCity() {
		return $this->addressCity;
	}
	public function setAddressCity($addressCity) {
		$this->addressCity = $addressCity;
	}

	public function getAddressCode() {
		return $this->addressCode;
	}
	public function setAddressCode($addressCode) {
		$this->addressCode = $addressCode;
	}

	public function getAddressState() {
		if ($this->getStateId()) {
			return State::fetchById($this->getStateId())->getAbbreviation();
		}
		else {
			return null;
		}
	}

	public function getStateId() {
		return $this->stateId;
	}
	public function setStateId($stateId) {
		$this->stateId = $stateId;
	}

	public function getLeadSource() {
		return $this->leadSource;
	}
	public function setLeadSource($leadSource) {
		$this->leadSource = $leadSource;
	}

	public function getEmailOptOut() {
		return $this->emailOptOut;
	}
	public function setEmailOptOut($emailOptOut) {
		$this->emailOptOut = (bool)$emailOptOut;
	}

	/* End setters/getters */

	public function save($forceInsert=false) {
		$db = new Database;

		// $this->update();
		// $this->insert();

		// return true;
		if (!$forceInsert && $this->populateId()) {
			return $this->update();
		}
		else {
			return $this->insert();
		}
	}

	private function insert() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$zohoId = $this->getZohoId();

		$dbFields = self::getDbFields();

		$insertFields = array();
		$insertValues = array();
		$duplicateKeyUpdateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];

			$data = $this->$getterName();


			if ($dataType == "foreignKey") {
				if ($data) {
					array_push($insertFields, $fieldName);
					array_push($insertValues, $data);

					$duplicateKeyClause = "`$fieldName`='$data'";
					array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

				}
			}
			elseif ($data !== null) {
				if ($dataType == 'bool') {
					$data = $data ? '1' : '0';
				}
				elseif ($dataType == 'encrypted') {
					$data = EncryptionController::encryptString(trim($data));
				}
				elseif ($dataType == "string") {
					$data = mysql_real_escape_string(trim($data));
				}

				array_push($insertFields, $fieldName);
				array_push($insertValues, $data);

				$duplicateKeyClause = "`$fieldName`='$data'";
				array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

			}
		}

		$fieldsString = implode("`, `", $insertFields);
		$valuesString = implode("', '", $insertValues);
		$duplicateKeyString = implode(", ", $duplicateKeyUpdateClauses);

		$sql = "INSERT INTO `$dbTable`(`$fieldsString`) VALUES ('$valuesString') ON DUPLICATE KEY UPDATE $duplicateKeyString;";

		return $db->db_query($sql, 'insert');
	}

	private function update() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$id = $this->getId();

		$dbFields = self::getDbFields();
		$updateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];
			$isMutable = $fieldParams['mutable'];
			if ($isMutable) {
				$data = $this->$getterName();


				if ($dataType == "foreignKey") {
					if ($data) {
						$updateClause = "`$fieldName`='$data'";

						array_push($updateClauses, $updateClause);

					}
				}
				elseif ($data !== null) {
					if ($dataType == 'bool') {
						$data = $data ? '1' : '0';
					}
					elseif ($dataType == 'encrypted') {
						$data = EncryptionController::encryptString(trim($data));
					}
					elseif ($dataType == "string") {
						$data = mysql_real_escape_string(trim($data));
					}

					$updateClause = "`$fieldName`='$data'";

					array_push($updateClauses, $updateClause);
				}

			}
		}
		$updateClausesString = implode(", ", $updateClauses);

		$sql = "UPDATE `$dbTable` SET $updateClausesString WHERE `id`='$id';";

		return $db->db_query($sql, 'insert', true);

	}


	/**
	 * deprecated
	 */
	public function populateData() {
		$dbTable = self::getDbTable();

		if ($this->populateId()) {
			$db = new Database;
			$id = $this->getId();
			$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";

			$result = $db->db_query($sql, 'select-single', true);


			if ($result) {
				$mutableFields = self::getMutableFields();

				foreach ($mutableFields as $fieldName => $fieldType) {
					if ($result[$fieldName]) {
						$setterName = 'set' . ucfirst($fieldName); // Generate setter name string. eg. if $fieldName is 'firstName' this will generate string 'setFirstName'

						$resultStr = $result[$fieldName];
						if ($fieldType == 'encrypted') {
							$final = EncryptionController::decryptString($resultStr);
						}
						elseif ($fieldType == 'string') {
							$final = trim($resultStr);
						}
						elseif ($fieldType == 'bool') {
							$final = (bool)$resultStr;
						}
						else {
							$final = $resultStr;
						}

						$this->$setterName($final); // Calls the setter for the given field name
					}
				}
				// if successful return true
				return true;
			}
			else {
				// if nothing found return false
				return false;
			}
		}
		else {
			// if cannot populate id return false
			return false;
		}
	}

	public function jsonify() {
		$dbFields = self::getDbFields();

		$jsonData = new stdClass;

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);

			$jsonData->$fieldName = $this->$getterName();
		}

		return $jsonData;
	}

	/* Static functions */

	public static function fetchById($id) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			$result['fromDb'] = true;

			return new Lead($result, true, true);
		}
		else {
			return null;
		}
	}

	public static function fetchByEmail($email) {
		$db = new Database;
		$dbTable = self::getDbTable();

		$sql = "SELECT * FROM `$dbTable` WHERE `email`='$email';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			$result['fromDb'] = true;

			return new Lead($result, true, true);
		}
		else {
			return null;
		}
	}

	public static function fetchByZohoId($zohoId) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$zohoIdFieldName = self::getZohoIdFieldName();

		$sql = "SELECT * FROM `$dbTable` WHERE `$zohoIdFieldName`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			$result['fromDb'] = true;

			return new Lead($result, true, true);
		}
		else {
			return null;
		}
	}

	public static function checkIfExistsByEmail($email) {
		if (!$email) {
			return false;
		}
		$db = new Database;
		$dbTable = self::getDbTable();

		$email = mysql_real_escape_string($email);

		$sql = "SELECT `id` FROM `$dbTable` WHERE `email`='$email';";

		$result = $db->db_query($sql, 'select-single');

		if ($result['id']) {
			return true;
		}
		else {
			return false;
		}

	}


	private static function getDbFields() {
		return self::$dbFields;
	}

	private static function getMutableFields() {
		return self::$mutableFields;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	private static function getZohoIdFieldName() {
		return self::$zohoIdField;
	}

	public static function constructFromCsvImportRow($data) {
		$leadData = new stdClass;

		$leadData->zohoId = substr($data['Record Id'], strpos($data['Record Id'], '_')+1); // formatted in csv like zcrm_835703000020900001, reformats to 835703000020900001

		$leadData->salutation = trim($data['Salutation']);
		$leadData->firstName = trim($data['First Name']);
		$leadData->lastName = trim($data['Last Name']);

		$leadData->email = trim($data['Email']);
		$leadData->phoneNumber = trim($data['Phone']);
		$leadData->fax = trim($data['Fax']);

		if ($leadData->account) {
			$leadData->organization = $leadData->account->getName();
		}
		elseif ($data['Company']) {
			$leadData->organization = trim($data['Company']);
		}
		$leadData->title = trim($data['Title']);

		$leadData->addressStreet = trim($data['Street']);
		$leadData->addressCity = trim($data['City']);
		$leadData->stateId = self::fetchStateId($data['State']);
		$leadData->addressCode = trim($data['Zip Code']);

		$leadData->leadSource = trim($data['Lead Source']);

		$leadData->emailOptOut = (bool)$data['Email Opt Out'];

		$lead = new Lead($leadData);

		return $lead;
	}

	private static function fetchStateId($state) {
		$db = new Database;

		$sql = "SELECT `id` FROM `states` WHERE `abbreviation`='$state' OR `name`='$state' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single');

		if ($result['id']) {
			return $result['id'];
		}
		else {
			return null;
		}
	}
}

?>
