<?php

class Account {
	public static $accountDbTable = "order_accounts";
	public static $zohoIdFieldName = "zoho_id";

	public $dbId;
	public $zohoId;
	public $name;
	private $accountType;
	public $newCustomer;

	private $phoneNumber;
	private $website;
	private $enrollment;
	private $totalSpent;

	// Billing address data
	private $billingStreet;
	private $billingCity;
	private $billingState;
	private $billingCode;
	private $billingStateId;

	// Shipping address data
	private $shippingStreet;
	private $shippingCity;
	private $shippingState;
	private $shippingCode;
	private $shippingStateId;



	private $hasUpdates;

	public function __construct($data, $populate=false) {
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->dbId) {
			$this->dbId = $data->dbId;
		}
		elseif ($data->id) {
			$this->dbId = $data->id;
		}

		// Zoho ID variants - multiple variants to catch multiple implementations in the code.
		if ($data->zohoId) {
			$this->zohoId = $data->zohoId;
		}
		elseif ($data->zoho_id) {
			$this->zohoId = $data->zoho_id;
		}
		elseif ($data->Account_Id) {
			$this->zohoId = $data->Account_Id;
		}

		if ($data->name) {
			$this->name = $data->name;
		}
		elseif($data->Account_Name) {
			$this->name = $data->Account_Name;
		}

		if ($data->accountType) {
			$this->accountType = $data->accountType;
		}

		if ($data->phoneNumber) {
			$this->phoneNumber = $data->phoneNumber;
		}

		if ($data->website) {
			$this->website = $data->website;
		}

		if ($data->enrollment) {
			$this->enrollment = (int)$data->enrollment;
		}

		if ($data->totalSpent) {
			$this->totalSpent = (float)$data->totalSpent;
		}

		if ($data->billingStreet) {
			$this->billingStreet = $data->billingStreet;
		}

		if ($data->billingCity) {
			$this->billingCity = $data->billingCity;
		}

		if ($data->billingState) {
			$this->billingState = $data->billingState;
		}

		if ($data->billingStateId) {
			$this->billingStateId = $data->billingStateId;
		}
		elseif ($this->billingState) {
			$this->billingStateId = State::fetchIdByNameOrAbbreviation($this->billingState);
		}

		if ($data->billingCode) {
			$this->billingCode = $data->billingCode;
		}

		if ($data->shippingStreet) {
			$this->shippingStreet = $data->shippingStreet;
		}

		if ($data->shippingCity) {
			$this->shippingCity = $data->shippingCity;
		}

		if ($data->shippingState) {
			$this->shippingState = $data->shippingState;
		}

		if ($data->shippingStateId) {
			$this->shippingStateId = $data->shippingStateId;
		}
		elseif ($this->shippingState) {
			$this->shippingStateId = State::fetchIdByNameOrAbbreviation($this->shippingState);
		}

		if ($data->shippingCode) {
			$this->shippingCode = $data->shippingCode;
		}

		// New customer parsing
		if ($data->newCustomer !== null) {
			if (is_bool($data->newCustomer)) {
				$this->newCustomer = $data->newCustomer;
			}
			elseif($data->newCustomer === '1' || $data->newCustomer === 1) {
				$this->newCustomer = true;
			}
			elseif ($data->newCustomer === '0' || $data->newCustomer === 0) {
				$this->newCustomer = false;
			}
			else {
				$this->newCustomer = null;
			}
		}
		elseif ($data->new_customer !== null) {
			if (is_bool($data->new_customer)) {
				$this->newCustomer = $data->new_customer;
			}
			elseif($data->new_customer === '1' || $data->new_customer === 1) {
				$this->newCustomer = true;
			}
			elseif ($data->new_customer === '0' || $data->new_customer === 0) {
				$this->newCustomer = false;
			}
			else {
				$this->newCustomer = null;
			}
		}

		$hasUpdates = false;

		if ($populate) {
			$this->populateData();
		}
	}

	public function getDbId() {
		return $this->dbId;
	}
	public function setDbId($id) {
		$this->dbId = $id;
	}

	public function isDbIdSet() {
		if ($this->getDbId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}
	public function setZohoId($zohoId) {
		$this->zohoId = $zohoId;
	}

	public function getName() {
		return $this->name;
	}
	public function setName($name) {
		$this->name = trim($name);
	}

	public function getAccountType() {
		return $this->accountType;
	}
	public function setAccountType($accountType) {
		$this->accountType = trim($accountType);
	}

	public function getPhoneNumber() {
		return $this->phoneNumber;
	}
	public function setPhoneNumber($phoneNumber) {
		$this->phoneNumber = trim($phoneNumber);
	}

	public function getWebsite() {
		return $this->website;
	}
	public function setWebsite($website) {
		$this->website = trim($website);
	}

	public function getEnrollment() {
		return $this->enrollment;
	}
	public function setEnrollment($enrollment) {
		$this->enrollment = (int)$enrollment;
	}

	public function getTotalSpent() {
		return $this->totalSpent;
	}
	public function setTotalSpent($totalSpent) {
		$this->totalSpent = (float)$totalSpent;
	}

	public function getBillingStreet() {
		return $this->billingStreet;
	}
	public function setBillingStreet($billingStreet) {
		$this->billingStreet = trim($billingStreet);
	}

	public function getBillingCity() {
		return $this->billingCity;
	}
	public function setBillingCity($billingCity) {
		$this->billingCity = trim($billingCity);
	}

	public function getBillingState() {
		return $this->billingState;
	}
	public function setBillingState($billingState) {
		$this->billingState = trim($billingState);
	}

	public function getBillingStateId() {
		return $this->billingStateId;
	}
	public function setBillingStateId($billingStateId) {
		$this->billingStateId = $billingStateId;
	}

	public function getBillingCode() {
		return $this->billingCode;
	}
	public function setBillingCode($billingCode) {
		$this->billingCode = trim($billingCode);
	}

	public function getShippingStreet() {
		return $this->shippingStreet;
	}
	public function setShippingStreet($shippingStreet) {
		$this->shippingStreet = trim($shippingStreet);
	}

	public function getShippingCity() {
		return $this->shippingCity;
	}
	public function setShippingCity($shippingCity) {
		$this->shippingCity = trim($shippingCity);
	}

	public function getShippingState() {
		return $this->shippingState;
	}
	public function setShippingState($shippingState) {
		$this->shippingState = trim($shippingState);
	}

	public function getShippingStateId() {
		return $this->shippingStateId;
	}
	public function setShippingStateId($shippingStateId) {
		$this->shippingStateId = $shippingStateId;
	}

	public function getShippingCode() {
		return $this->shippingCode;
	}
	public function setShippingCode($shippingCode) {
		$this->shippingCode = trim($shippingCode);
	}

	public function getIsNewCustomer() {
		return $this->newCustomer;
	}
	public function setIsNewCustomer($newCustomer) {
		$this->newCustomer = (bool)$newCustomer;
	}
	public function isNewCustomerSet() {
		if ($this->getIsNewCustomer() === TRUE || $this->getIsNewCustomer() === FALSE) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getHasUpdates() {
		return $this->hasUpdates;
	}
	public function setHasUpdates($hasUpdates) {
		$this->hasUpdates = (boolean)$hasUpdates;
	}

	public function getHasFullBillingAddress() {
		$billingStreet = $this->getBillingStreet();
		$billingCity = $this->getBillingCity();
		$billingCode = $this->getBillingCode();
		$billingState = $this->getBillingState();
		$billingStateId = $this->getBillingStateId();
		if (!$billingState && $billingStateId) {
			$state = State::fetchById($billingStateId);
			if ($state) {
				$this->setBillingState($state->getAbbreviation);
			}
			$billingState = $this->getBillingState();
		}

		if ($billingStreet && $billingCity && $billingCode && $billingState) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getHasFullShippingAddress() {
		$shippingStreet = $this->getShippingStreet();
		$shippingCity = $this->getShippingCity();
		$shippingCode = $this->getShippingCode();
		$shippingState = $this->getShippingState();
		$shippingStateId = $this->getShippingStateId();
		if (!$shippingState && $shippingStateId) {
			$state = State::fetchById($shippingStateId);
			if ($state) {
				$this->setShippingState($state->getAbbreviation);
			}
			$shippingState = $this->getShippingState();
		}

		if ($shippingStreet && $shippingCity && $shippingCode && $shippingState) {
			return true;
		}
		else {
			return false;
		}
	}

	public function populateDbId() {
		if ($this->isDbIdSet()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getAccountDbTable();
		$zohoIdField = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$dbTable` WHERE `$zohoIdField`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setDbId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function populateData() {
		if (!$this->populateDbId()) {
			return false;
		}
		$db = new Database;

		$dbTable = self::getAccountDbTable();
		$zohoIdFieldName = self::getZohoIdFieldName();
		$id = $this->getDbId();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);
		if ($result[$zohoIdFieldName]) {
			foreach ($result as $key => $value) {
				$this->setKeyValue($key, $value);
			}
			return true;
		}
		else {
			return false;
		}
	}

	public function setKeyValue($key, $value) {
		$zohoIdAliases = array(
			'zohoId',
			'zoho_id',
			'Account_Id'
		);
		$nameAliases = array(
			'name',
			'Account',
			'Account_Name'
		);
		$isNewCustomerAliases = array(
			'newCustomer',
			'new_customer'
		);
		if (in_array($key, $zohoIdAliases)) {
			$this->setZohoId($value);
			return true;
		}
		elseif(in_array($key, $nameAliases)) {
			$this->setName($value);
			return true;
		}
		elseif(in_array($key, $isNewCustomerAliases)) {
			$isNewCustomer = $value == '1' ? true : false;
			$this->setIsNewCustomer($isNewCustomer);
			return true;
		}
		else {
			return false;
		}
	}

	public function populateIsNewCustomer() {
		if ($this->isNewCustomerSet()) {
			return true;
		}
		$this->populateDbId();

		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getAccountDbTable();
		$id = $this->getDbId();

		$sql = "SELECT `new_customer` FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);
		$newCustomer = $result['new_customer'];
		if ($newCustomer == '1') {
			$newCustomer = true;
		}
		else {
			$newCustomer = false;
		}
		$this->setIsNewCustomer($newCustomer);
		return true;
	}

	public function generateAccountInsertQuery() {
		$dbTable = self::getAccountDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$zohoId = $this->getZohoId();
		$name = mysql_real_escape_string($this->getName());
		$accountType = mysql_real_escape_string($this->getAccountType());
		$phoneNumber = mysql_real_escape_string($this->getPhoneNumber());
		$website = mysql_real_escape_string($this->getWebsite());
		$enrollment = $this->getEnrollment();
		$totalSpent = $this->getTotalSpent();
		$billingStreet = mysql_real_escape_string($this->getBillingStreet());
		$billingCity = mysql_real_escape_string($this->getBillingCity());
		$billingState = mysql_real_escape_string($this->getBillingState());
		$billingCode = mysql_real_escape_string($this->getBillingCode());
		$shippingStreet = mysql_real_escape_string($this->getShippingStreet());
		$shippingCity = mysql_real_escape_string($this->getShippingCity());
		$shippingState = mysql_real_escape_string($this->getShippingState());
		$shippingCode = mysql_real_escape_string($this->getShippingCode());

		if ($billingState && $shippingState) {

			$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`, `accountType`, `phoneNumber`, `website`, `enrollment`, `totalSpent`, `billingStreet`, `billingCity`, `billingState`, `billingCode`, `shippingStreet`, `shippingCity`, `shippingState`, `shippingCode`, `billingStateId`, `shippingStateId`)
					VALUES ('$zohoId', '$name', '$accountType', '$phoneNumber', '$website', '$enrollment', '$totalSpent', '$billingStreet', '$billingCity', '$billingState', '$billingCode', '$shippingStreet', '$shippingCity', '$shippingState', '$shippingCode', (SELECT `id` FROM `states` WHERE `name`='$billingState' OR `abbreviation`='$billingState' LIMIT 1), (SELECT `id` FROM `states` WHERE `name`='$shippingState' OR `abbreviation`='$shippingState' LIMIT 1))
					ON DUPLICATE KEY UPDATE `name`='$name', `accountType`='$accountType', `phoneNumber`='$phoneNumber', `website`='$website', `enrollment`='$enrollment', `totalSpent`='$totalSpent', `billingStreet`='$billingStreet', `billingCity`='$billingCity', `billingState`='$billingState', `billingCode`='$billingCode', `shippingStreet`='$shippingStreet', `shippingCity`='$shippingCity', `shippingState`='$shippingState', `shippingCode`='$shippingCode', `billingStateId`=(SELECT `id` FROM `states` WHERE `name`='$billingState' OR `abbreviation`='$billingState' LIMIT 1), `shippingStateId`=(SELECT `id` FROM `states` WHERE `name`='$shippingState' OR `abbreviation`='$shippingState' LIMIT 1);";

		}
		elseif ($billingState) {

			$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`, `accountType`, `phoneNumber`, `website`, `enrollment`, `totalSpent`, `billingStreet`, `billingCity`, `billingState`, `billingCode`, `shippingStreet`, `shippingCity`, `shippingState`, `shippingCode`, `billingStateId`)
					VALUES ('$zohoId', '$name', '$accountType', '$phoneNumber', '$website', '$enrollment', '$totalSpent', '$billingStreet', '$billingCity', '$billingState', '$billingCode', '$shippingStreet', '$shippingCity', '$shippingState', '$shippingCode', (SELECT `id` FROM `states` WHERE `name`='$billingState' OR `abbreviation`='$billingState' LIMIT 1))
					ON DUPLICATE KEY UPDATE `name`='$name', `accountType`='$accountType', `phoneNumber`='$phoneNumber', `website`='$website', `enrollment`='$enrollment', `totalSpent`='$totalSpent', `billingStreet`='$billingStreet', `billingCity`='$billingCity', `billingState`='$billingState', `billingCode`='$billingCode', `shippingStreet`='$shippingStreet', `shippingCity`='$shippingCity', `shippingState`='$shippingState', `shippingCode`='$shippingCode', `billingStateId`=(SELECT `id` FROM `states` WHERE `name`='$billingState' OR `abbreviation`='$billingState' LIMIT 1);";

		}
		elseif ($shippingState) {

			$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`, `accountType`, `phoneNumber`, `website`, `enrollment`, `totalSpent`, `billingStreet`, `billingCity`, `billingState`, `billingCode`, `shippingStreet`, `shippingCity`, `shippingState`, `shippingCode`, `shippingStateId`)
					VALUES ('$zohoId', '$name', '$accountType', '$phoneNumber', '$website', '$enrollment', '$totalSpent', '$billingStreet', '$billingCity', '$billingState', '$billingCode', '$shippingStreet', '$shippingCity', '$shippingState', '$shippingCode', (SELECT `id` FROM `states` WHERE `name`='$shippingState' OR `abbreviation`='$shippingState' LIMIT 1))
					ON DUPLICATE KEY UPDATE `name`='$name', `accountType`='$accountType', `phoneNumber`='$phoneNumber', `website`='$website', `enrollment`='$enrollment', `totalSpent`='$totalSpent', `billingStreet`='$billingStreet', `billingCity`='$billingCity', `billingState`='$billingState', `billingCode`='$billingCode', `shippingStreet`='$shippingStreet', `shippingCity`='$shippingCity', `shippingState`='$shippingState', `shippingCode`='$shippingCode', `shippingStateId`=(SELECT `id` FROM `states` WHERE `name`='$shippingState' OR `abbreviation`='$shippingState' LIMIT 1);";

		}
		else {
			$sql = "INSERT INTO `$dbTable`(`$zohoIdField`, `name`, `accountType`, `phoneNumber`, `website`, `enrollment`, `totalSpent`, `billingStreet`, `billingCity`, `billingState`, `billingCode`, `shippingStreet`, `shippingCity`, `shippingState`, `shippingCode`)
					VALUES ('$zohoId', '$name', '$accountType', '$phoneNumber', '$website', '$enrollment', '$totalSpent', '$billingStreet', '$billingCity', '$billingState', '$billingCode', '$shippingStreet', '$shippingCity', '$shippingState', '$shippingCode')
					ON DUPLICATE KEY UPDATE `name`='$name', `accountType`='$accountType', `phoneNumber`='$phoneNumber', `website`='$website', `enrollment`='$enrollment', `totalSpent`='$totalSpent', `billingStreet`='$billingStreet', `billingCity`='$billingCity', `billingState`='$billingState', `billingCode`='$billingCode', `shippingStreet`='$shippingStreet', `shippingCity`='$shippingCity', `shippingState`='$shippingState', `shippingCode`='$shippingCode';";

		}


		/*
		public $dbId;
		public $zohoId;
		public $name;
		private $accountType;
		public $newCustomer;

		private $phoneNumber;
		private $website;
		private $enrollment;
		private $totalSpent;

		// Billing address data
		private $billingStreet;
		private $billingCity;
		private $billingState;
		private $billingCode;

		// Shipping address data
		private $shippingStreet;
		private $shippingCity;
		private $shippingState;
		private $shippingCode;
		*/

		return $sql;
	}

	public function generateAccountUpdateQuery() {
		$dbTable = self::getAccountDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();
		$zohoId = $this->getZohoId();
		$name = mysql_real_escape_string($this->getName());
		$newCustomer = $this->getIsNewCustomer();

		$sql = "UPDATE `$dbTable` SET `name`='$name', `new_customer`='$newCustomer' WHERE `id`='$id';"; // (`$zohoIdField`, `name`) VALUES ('$zohoId', '$name') ON DUPLICATE KEY UPDATE `name`='$name';";

		return $sql;

		$clauses = array();
		$id = $this->getDbId();

		$zohoId = $this->getZohoId();
		if ($zohoId) {
			$clause = "`$zohoIdField`='$zohoId'";
			array_push($clauses, $clause);
		}
		$name = mysql_real_escape_string($this->getName());
		if ($name) {
			$clause = "`name`='$name'";
			array_push($clauses, $clause);
		}
		$newCustomer = $this->getIsNewCustomer();
		if ($newCustomer !== null) {
			$clause = "`new_customer`='$newCustomer'";
			array_push($clauses, $clause);
		}
		$accountType = mysql_real_escape_string($this->getAccountType());
		if ($accountType) {
			$clause = "`accountType`='$accountType'";
			array_push($clauses, $clause);
		}
		$phoneNumber = mysql_real_escape_string($this->getPhoneNumber());
		if ($phoneNumber) {
			$clause = "`phoneNumber`='$phoneNumber'";
			array_push($clauses, $clause);
		}
		$website = mysql_real_escape_string($this->getWebsite());
		if ($website) {
			$clause = "`website`='$website'";
			array_push($clauses, $clause);
		}
		$enrollment = $this->getEnrollment();
		if ($enrollment) {
			$clause = "`enrollment`='$enrollment'";
			array_push($clauses, $clause);
		}
		$totalSpent = $this->getTotalSpent();
		if ($totalSpent) {
			$clause = "`totalSpent`='$totalSpent'";
			array_push($clauses, $clause);
		}
		$billingStreet = mysql_real_escape_string($this->getBillingStreet());
		if ($billingStreet) {
			$clause = "`billingStreet`='$billingStreet'";
			array_push($clauses, $clause);
		}
		$billingCity = mysql_real_escape_string($this->getBillingCity());
		if ($billingCity) {
			$clause = "`billingCity`='$billingCity'";
			array_push($clauses, $clause);
		}
		$billingState = mysql_real_escape_string($this->getBillingState());
		$billingStateId = $this->getBillingStateId();
		if ($billingStateId) {
			$clause = "`billingStateId`='$billingStateId'";
			array_push($clauses, $clause);
		}
		elseif ($billingState) {
			$clause = "`billingStateId`=(SELECT `id` FROM `states` WHERE `states`.`name`='$billingState' OR `states`.`abbreviation`='$billingState')";
			array_push($clauses, $clause);
		}
		$billingCode = mysql_real_escape_string($this->getBillingCode());
		if ($billingCode) {
			$clause = "`billingCode`='$billingCode'";
			array_push($clauses, $clause);
		}
		$shippingStreet = mysql_real_escape_string($this->getShippingStreet());
		if ($billingStreet) {
			$clause = "`billingStreet`='$billingStreet'";
			array_push($clauses, $clause);
		}
		$shippingCity = mysql_real_escape_string($this->getShippingCity());
		if ($shippingCity) {
			$clause = "`shippingCity`='$shippingCity'";
			array_push($clauses, $clause);
		}
		$shippingState = mysql_real_escape_string($this->getShippingState());
		$shippingStateId = $this->getBillingStateId();
		if ($shippingStateId) {
			$clause = "`shippingStateId`='$shippingStateId'";
			array_push($clauses, $clause);
		}
		elseif ($shippingState) {
			$clause = "`shippingStateId`=(SELECT `id` FROM `states` WHERE `states`.`name`='$shippingState' OR `states`.`abbreviation`='$shippingState')";
			array_push($clauses, $clause);
		}
		$shippingCode = mysql_real_escape_string($this->getShippingCode());
		if ($shippingCode) {
			$clause = "`shippingCode`='$shippingCode'";
			array_push($clauses, $clause);
		}

		$clauseString = implode(", ", $clauses);

		if ($clauseString) {
			$sql = "UPDATE `$dbTable` SET $clauseString WHERE `id`='$id';";
		}
		else {
			$sql = '';
		}
		return $sql;


		/*
		public $dbId;
		public $zohoId;
		public $name;
		private $accountType;
		public $newCustomer;

		private $phoneNumber;
		private $website;
		private $enrollment;
		private $totalSpent;

		// Billing address data
		private $billingStreet;
		private $billingCity;
		private $billingState;
		private $billingCode;

		// Shipping address data
		private $shippingStreet;
		private $shippingCity;
		private $shippingState;
		private $shippingCode;
		*/
	}

	private function generateUpdateNameQuery() {
		$dbTable = self::getAccountDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$id = $this->getDbId();
		$name = mysql_real_escape_string($this->getName());

		$sql = "UPDATE `$dbTable` SET `name`='$name' WHERE `id`='$id';"; // (`$zohoIdField`, `name`) VALUES ('$zohoId', '$name') ON DUPLICATE KEY UPDATE `name`='$name';";

		return $sql;
	}

	public function save($forceInsert=false) {
		$db = new Database;
		$dbTable = self::getAccountDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		if ($forceInsert) {
			$sql = $this->generateAccountInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
			return true;
		}

		$this->populateDbId();

		if (!$this->isDbIdSet()) {
			$sql = $this->generateAccountInsertQuery();
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}

		$sql = $this->generateAccountUpdateQuery();
		if ($sql) {
			$db->db_query($sql, 'update', true);
		}
	}

	public function jsonify() {
		// $dbFields = self::getDbFields();

		$jsonData = new stdClass;

		foreach ($this as $key => $value) {
			$jsonData->$key = $value;
		}

		return $jsonData;
	}

	public static function fetch($dbId) {
		$db = new Database;

		$dbTable = self::getAccountDbTable();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$dbId';";
		$result = $db->db_query($sql, 'select-single', true);
		if ($result['id']) {
			return new Account($result);
		}
		else {
			return false;
		}
	}

	public static function fetchByZohoId($zohoId) {
		$db = new Database;

		$dbTable = self::getAccountDbTable();
		$zohoIdFieldName = self::getZohoIdFieldName();

		$sql = "SELECT * FROM `$dbTable` WHERE `$zohoIdFieldName`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		if ($result['id']) {
			return new Account($result);
		}
		else {
			return false;
		}
	}

	public static function createByZohoRecord(ZCRMRecord $zohoRecord) {
		if (!$zohoRecord) {
			return null;
		}
		$constructorData = array(
			'zohoId' => $zohoRecord->getEntityId(),
			'name' => $zohoRecord->getLookupLabel(),
			'accountType' => $zohoRecord->getFieldValue('Account_Type'),
			'phoneNumber' => $zohoRecord->getFieldValue('Phone'),
			'website' => $zohoRecord->getFieldValue('Website'),
			'enrollment' => $zohoRecord->getFieldValue('Enrollment'),
			'totalSpent' => $zohoRecord->getFieldValue('Total_Spent'),
			'billingStreet' => $zohoRecord->getFieldValue('Billing_Street'),
			'billingCity' => $zohoRecord->getFieldValue('Billing_City'),
			'billingState' => $zohoRecord->getFieldValue('Billing_State'),
			'billingCode' => $zohoRecord->getFieldValue('Billing_Code'),
			'shippingStreet' => $zohoRecord->getFieldValue('Shipping_Street'),
			'shippingCity' => $zohoRecord->getFieldValue('Shipping_City'),
			'shippingState' => $zohoRecord->getFieldValue('Shipping_State'),
			'shippingCode' => $zohoRecord->getFieldValue('Shipping_Code'),
		);

		$account = new Account($constructorData);
		return $account;
	}

	public static function getDbTable() {
		return self::$accountDbTable;
	}

	public static function getAccountDbTable() {
		return self::$accountDbTable;
	}

	public static function getZohoIdFieldName() {
		return self::$zohoIdFieldName;
	}

	public static function getAccountTypes() {
		$db = new Database;

		$dbTable = self::getDbTable();

		$sql = "SELECT DISTINCT `accountType` FROM `$dbTable` WHERE `accountType` IS NOT NULL AND `accountType` != '' ORDER BY `accountType` ASC;";
		$results = $db->db_query($sql, 'select-multiple');

		$resultArray = array();
		foreach ($results as $result) {
			array_push($resultArray, $result['accountType']);
		}

		return $resultArray;
	}

	public static function constructFromCsvImportRow($data) {
		$accountData = new stdClass;
		$accountData->zohoId = substr($data['Record Id'], strpos($data['Record Id'], '_')+1); // formatted in csv like zcrm_835703000020900001, reformats to 835703000020900001
		$accountData->name = trim($data['Account Name']);
		$accountData->accountType = trim($data['Account Type']);
		$accountData->phoneNumber = trim($data['Phone']);
		$accountData->website = trim($data['Website']);
		$accountData->enrollment = trim($data['Enrollment']);
		$accountData->totalSpent = trim($data['Total Spent']);

		$accountData->billingStreet = trim($data['Billing Street']);
		$accountData->billingCity = trim($data['Billing City']);
		$accountData->billingState = trim($data['Billing State']);
		$accountData->billingCode = trim($data['Billing Code']);

		$accountData->shippingStreet = trim($data['Shipping Street']);
		$accountData->shippingCity = trim($data['Shipping City']);
		$accountData->shippingState = trim($data['Shipping State']);
		$accountData->shippingCode = trim($data['Shipping Code']);

		$accountData->newCustomer = false;

		$account = new Account($accountData);

		return $account;
		/*
		public $dbId;
		public $zohoId;
		public $name;
		private $accountType;
		public $newCustomer;

		private $phoneNumber;
		private $website;
		private $enrollment;
		private $totalSpent;

		// Billing address data
		private $billingStreet;
		private $billingCity;
		private $billingState;
		private $billingCode;

		// Shipping address data
		private $shippingStreet;
		private $shippingCity;
		private $shippingState;
		private $shippingCode;
		*/
	}
}

?>
