<?php

/**
 * Class for performing curl operations
 */
class Curl {
	public static function get($url, $headers, $auth=false, $followlocation=false) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,				$url);
		curl_setopt($ch, CURLOPT_USERAGENT,			'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
		$headersOpt = 0;
		if ($headers) {
			$headersOpt = 1;
			curl_setopt($ch, CURLOPT_HTTPHEADER,	$headers);
		}
		if ($auth) {
			curl_setopt($ch, CURLOPT_HTTPAUTH,		CURLAUTH_BASIC);
			curl_setopt($ch, CURLOPT_USERPWD,		$auth);
		}
		if ($followlocation){
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	1);
		}else{
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	0);
		}
		curl_setopt($ch, CURLOPT_VERBOSE,			0);
		curl_setopt($ch, CURLOPT_HEADER,			$headersOpt);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,	1);
		curl_setopt($ch, CURLOPT_FORBID_REUSE,		1);
		curl_setopt($ch, CURLOPT_PORT,				'443');
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,	1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,	0);
		curl_setopt($ch, CURLOPT_TIMEOUT,			30);
		curl_setopt($ch, CURLOPT_HTTPGET, true);
		$response = curl_exec($ch);
		curl_close($ch);
		return urldecode($response);
	}

	public static function post($url, $data, $headers, $user=null, $isBinaryData=false) {
		$curl = curl_init();

		if (is_array($data)) {
			$data = json_encode($data);
		}

		$options = array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $data,
			CURLOPT_HTTPHEADER => $headers,
			CURLOPT_SAFE_UPLOAD => true
		);

		// if ($isBinaryData) {
		// 	$uploadFileMimeType = mime_content_type($data);
		// 	$uploadFilePostKey = 'file';

		// 	$uploadFile = new CURLFile(
		// 		$data,
		// 		$uploadFileMimeType,
		// 		$uploadFilePostKey
		// 	);
		// 	$options[CURLOPT_SAFE_UPLOAD] = true;

		// 	$options[CURLOPT_POSTFIELDS] = [$uploadFilePostKey => $uploadFile];

		// }
		if ($user) {
			$options[CURLOPT_USERPWD] = $user;
		}

		curl_setopt_array($curl, $options);

		$response = curl_exec($curl);
		if ($responseBody === false) {
			echo "CURL Error: " . curl_error($curl);
		}

		$responseCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		/*
		 * 4xx status codes are client errors
		 * 5xx status codes are server errors
		 */
		if ($responseCode >= 400) {
			echo "HTTP Error: " . $responseCode . "\n";
		}


		curl_close($curl);
		return $response;

	}

	public static function put($url, $data) {
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "PUT",
			CURLOPT_POSTFIELDS => json_encode($data),
			CURLOPT_HTTPHEADER => array(
			  "Content-Type: application/json"
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $response;
	}

	public static function delete() {

	}
}

?>
