<?php

class FileExportService {
	private static $pathToFiles = HTML_FOLDER . "tmp/";
	private static $pathToRemoteFiles = 'serveradmin@10.8.0.5:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';


	public static function fileExportTest($mtsNumber='MTS73750') {
		$startDate = "04/15/2021";
		$endDate = "04/26/2021";
		self::zohoOrderExports($startDate, $endDate, true);
		return true;
	}

	public static function zohoOrderExports($startDate, $endDate, $debug=false) {
		global $zohoObj;
		if ($debug) {
			echo "<pre>";
		}
		if (is_string($startDate)) {
			$startDate = new DateTime($startDate);
		}
		if (is_string($endDate)) {
			$endDate = new DateTime($endDate);
		}

		if ($debug) {
			echo "getting zoho records\n";
			$startTime = new DateTime('now', new DateTimeZone('UTC'));
		}
		$records = $zohoObj->getShippedRecordsShippedSinceDate($startDate, $endDate);
		$parsedRecords = $records->parsed;
		if ($debug) {
			$endTime = new DateTime('now', new DateTimeZone('UTC'));
			$diff = $endTime->getTimestamp() - $startTime->getTimestamp();
			echo "got records from zoho. took $diff seconds. count: " . count($parsedRecords) . "\n";
		}

		$currentDate = new DateTime('now', new DateTimeZone('America/Los_Angeles'));
		$timestamp = $currentDate->format('Y-m-d');

		$customerFileName = "$timestamp-customers.csv"; // eg. 2021-04-28-customers.csv
		$orderFileName = "$timestamp-orders.csv"; // eg. 2021-04-28-orders.csv

		echo "filenames: $customerFileName $orderFileName\n";


		if ($debug) {
			echo "building customer CSV\n";
			$startTime = new DateTime('now', new DateTimeZone('UTC'));
		}
		self::buildZohoCustomersCsv($parsedRecords, $customerFileName); // Customer csv
		if ($debug) {
			$endTime = new DateTime('now', new DateTimeZone('UTC'));
			$diff = $endTime->getTimestamp() - $startTime->getTimestamp();
			echo "built customer CSV. took $diff seconds.";
		}
		if ($debug) {
			echo "building order CSV\n";
			$startTime = new DateTime('now', new DateTimeZone('UTC'));
		}
		self::buildZohoOrderCsv($parsedRecords, $orderFileName, $debug); // Order csv
		if ($debug) {
			$endTime = new DateTime('now', new DateTimeZone('UTC'));
			$diff = $endTime->getTimestamp() - $startTime->getTimestamp();
			echo "built order CSV. took $diff seconds.";
		}

		if (!$debug) {
			$customerFileScpOutput = self::sendFileToRemote($customerFileName);
			$orderFileScpOutput = self::sendFileToRemote($orderFileName);
			self::deleteLocalFile($customerFileName);
			self::deleteLocalFile($orderFileName);
		}
	}

	private static function sendFileToRemote($fileName) {
		$localFile = self::getFilePath($fileName);
		$remoteFile = self::getRemoteFilePath($fileName);

		$output = '';

		exec("scp -v $localFile $remoteFile", $output);
		return $output;
	}

	private static function deleteLocalFile($fileName) {
		$localFile = self::getFilePath($fileName);
		return unlink($localFile);
	}

	private static function buildZohoCustomersCsv($records, $fileName) {
		$lines = self::buildZohoCustomersCsvContent($records);
		$filePath = self::getFilePath($fileName);
		$file = fopen($filePath, 'w');

		foreach ($lines as $line) {
			fputcsv($file, $line);
		}
		fclose($file);
	}

	private static function buildZohoOrderCsv($zohoOrders, $fileName, $debug = false) {
		$filePath = self::getFilePath($fileName);
		$file = fopen($filePath, 'w');

		$csvLines = array();
		array_push($csvLines, self::buildZohoOrderCsvHeadLine());
		$allDbLineItems = self::getAllDbLineItems($zohoOrders);



		foreach ($zohoOrders as $zohoOrder) {
			$mtsNumber = $zohoOrder->mtsNumber;
			$dbLineItems = $allDbLineItems[$mtsNumber];
			$zohoLineItems = self::getZohoLineItems($zohoOrder);

			self::getDevicePrices($dbLineItems, $zohoLineItems, $passDebug); // should set device prices

			$zohoOrder->dbLineItems = $dbLineItems;
			$zohoOrder->zohoLineItems = $zohoLineItems;
		}

		if ($debug) {
			echo "<pre>";
			print_r($allDbLineItems);
			echo "</pre>";
		}

		for ($i = 0; $i < 4; $i++) {
			$debugOption = $debug ? 4 : 0;
			$contentLines = self::buildZohoOrderCsvContent($zohoOrders, $allDbLineItems, $i + $debugOption);
			foreach ($contentLines as $line) {
				array_push($csvLines, array_values($line));
			}
		}

		foreach ($csvLines as $line) {
			fputcsv($file, $line);
		}
		fclose($file);
	}

    private static function buildZohoCustomersCsvContent($records) {
        $output = '';

		$lines = array();
		foreach ($records as $record) {
			$line = array(
				'Co./Last Name' => $record->account->getName()
				, 'First Name' => ''
				, 'Card ID' => '*None'
				, 'Card Status' => 'N'
				, 'Currency Code' => ''
				, 'Addr 1 - Line 1' => $record->billingStreet
				, 'Addr 1 - Line 2' => ''
				, 'Addr 1 - Line 3' => ''
				, 'Addr 1 - Line 4' => ''
				, 'Addr 1 - City' => $record->billingCity
				, 'Addr 1 - State' => $record->billingState
				, 'Addr 1 - ZIP Code' => $record->billingCode
				, 'Addr 1 - Country' => ''
				, 'Addr 1 - Phone # 1' => ''
				, 'Addr 1 - Phone # 2' => ''
				, 'Addr 1 - Phone # 3' => ''
				, 'Addr 1 - Fax #' => ''
				, 'Addr 1 - Email' => ''
				, 'Addr 1 - WWW' => ''
				, 'Addr 1 - Contact Name' => ''
				, 'Addr 1 - Salutation' => ''
				, 'Addr 2 - Line 1' => ''
				, 'Addr 2 - Line 2' => ''
				, 'Addr 2 - Line 3' => ''
				, 'Addr 2 - Line 4' => ''
				, 'Addr 2 - City' => ''
				, 'Addr 2 - State' => ''
				, 'Addr 2 - ZIP Code' => ''
				, 'Addr 2 - Country' => ''
				, 'Addr 2 - Phone # 1' => ''
				, 'Addr 2 - Phone # 2' => ''
				, 'Addr 2 - Phone # 3' => ''
				, 'Addr 2 - Fax #' => ''
				, 'Addr 2 - Email' => ''
				, 'Addr 2 - WWW' => ''
				, 'Addr 2 - Contact Name' => ''
				, 'Addr 2 - Salutation' => ''
				, 'Addr 3 - Line 1' => ''
				, 'Addr 3 - Line 2' => ''
				, 'Addr 3 - Line 3' => ''
				, 'Addr 3 - Line 4' => ''
				, 'Addr 3 - City' => ''
				, 'Addr 3 - State' => ''
				, 'Addr 3 - ZIP Code' => ''
				, 'Addr 3 - Country' => ''
				, 'Addr 3 - Phone # 1' => ''
				, 'Addr 3 - Phone # 2' => ''
				, 'Addr 3 - Phone # 3' => ''
				, 'Addr 3 - Fax #' => ''
				, 'Addr 3 - Email' => ''
				, 'Addr 3 - WWW' => ''
				, 'Addr 3 - Contact Name' => ''
				, 'Addr 3 - Salutation' => ''
				, 'Addr 4 - Line 1' => ''
				, 'Addr 4 - Line 2' => ''
				, 'Addr 4 - Line 3' => ''
				, 'Addr 4 - Line 4' => ''
				, 'Addr 4 - City' => ''
				, 'Addr 4 - State' => ''
				, 'Addr 4 - ZIP Code' => ''
				, 'Addr 4 - Country' => ''
				, 'Addr 4 - Phone # 1' => ''
				, 'Addr 4 - Phone # 2' => ''
				, 'Addr 4 - Phone # 3' => ''
				, 'Addr 4 - Fax #' => ''
				, 'Addr 4 - Email' => ''
				, 'Addr 4 - WWW' => ''
				, 'Addr 4 - Contact Name' => ''
				, 'Addr 4 - Salutation' => ''
				, 'Addr 5 - Line 1' => ''
				, 'Addr 5 - Line 2' => ''
				, 'Addr 5 - Line 3' => ''
				, 'Addr 5 - Line 4' => ''
				, 'Addr 5 - City' => ''
				, 'Addr 5 - State' => ''
				, 'Addr 5 - ZIP Code' => ''
				, 'Addr 5 - Country' => ''
				, 'Addr 5 - Phone # 1' => ''
				, 'Addr 5 - Phone # 2' => ''
				, 'Addr 5 - Phone # 3' => ''
				, 'Addr 5 - Fax #' => ''
				, 'Addr 5 - Email' => ''
				, 'Addr 5 - WWW' => ''
				, 'Addr 5 - Contact Name' => ''
				, 'Addr 5 - Salutation' => ''
				, 'Picture' => ''
				, 'Notes' => ''
				, 'Identifiers' => ''
				, 'Custom List 1' => ''
				, 'Custom List 2' => ''
				, 'Custom List 3' => ''
				, 'Custom Field 1' => ''
				, 'Custom Field 2' => ''
				, 'Custom Field 3' => ''
				, 'Billing Rate' => '0'
				, 'Terms - Payment is Due' => '0'
				, '           - Discount Days' => '0'
				, '           - Balance Due Days' => '0'
				, '           - % Discount' => '0'
				, '           - % Monthly Charge' => '0'
				, 'Tax Code' => 'CST'
				, 'Credit Limit' => '0'
				, 'Tax ID No.' => ''
				, 'Volume Discount %' => '0'
				, 'Sales/Purchase Layout' => 'I'
				, 'Price Level' => '0'
				, 'Payment Method' => ''
				, 'Payment Notes' => ''
				, 'Name on Card' => ''
				, 'Last 4 Digits on Card' => ''
				, 'Expiration Date' => ''
				, 'Address (AVS)' => ''
				, 'ZIP (AVS)' => ''
				, 'Credit Card Swiped' => ''
				, 'Account' => ''
				, 'Salesperson' => ''
				, 'Salesperson Card ID' => ''
				, 'Comment' => ''
				, 'Shipping Method' => ''
				, 'Printed Form' => ''
				, 'Freight Tax Code' => '-'
				, 'Receipt Memo' => ''
				, 'Invoice/Purchase Order Delivery' => 'P'
				, 'Record ID' => ''
			);
			$headerLine = array_keys($line);
			array_push($lines, array_values($line));
		}
		array_unshift($lines, $headerLine);
		return $lines;
    }

	/**
	 * Builds header string for the CSV header from an array of strings
	 */
	private static function buildZohoOrderCsvHeadLine($implode=false) {
		$header = array(
			'Co./Last Name'
			, 'First Name'
			, 'Addr 1 - Line 1'
			, 'Addr 1 - Line 2'
			, 'Addr 1 - Line 3'
			, 'Addr 1 - Line 4'
			, 'Invoice #'
			, 'Date'
			, 'Customer PO'
			, 'Ship Via'
			, 'Delivery Status'
			, 'Item Number'
			, 'Quantity'
			, 'Description'
			, 'Price'
			, 'Discount'
			, 'Total'
			, 'Job'
			, 'Comment'
			, 'Journal Memo'
			, 'Salesperson Last Name'
			, 'Salesperson First Name'
			, 'Shipping Date'
			, 'Tax Code'
			, 'Tax Amount'
			, 'Freight Amount'
			, 'Tax on Freight'
			, 'Freight Tax Amount'
			, 'Sale Status'
			, 'Currency Code'
			, 'Exchange Rate'
			, 'Terms - Payment is Due'
			, 'Terms - Payment is Due - Discount Days'
			, 'Terms - Payment is Due - Balance Due'
			, 'Days - % Discount'
			, 'Days - % Monthly'
			, 'Referral Source'
			, 'Amount Paid'
			, 'Payment Method'
			, 'Payment Notes'
			, 'Name on Card'
			, 'Card Number'
			, 'Expiration Date'
			, 'Address(AVS)'
			, 'Zip(AVS)'
			, 'Credit Card Swiped'
			, 'Authorization Code'
			, 'Check Number'
			, 'Category'
			, 'Location ID'
			, 'Card Verification'
			, '(CVV2) Used '
		);
		if ($implode) {
			return implode(',', $header);
		}
		else {
			return $header;
		}
	}

	/**
	 * Builds CSV content
	 */
	private static function buildZohoOrderCsvContent($zohoOrders, $dbLineItemOrders, $options=0) {
		$hardware = false;
		$nopo = false;
		$debug = false;
		if ($options >= 4) {
			$debug = true;
			$options -= 4;
		}
		if ($options >= 2) {
			$nopo = true;
			$options -= 2;
		}
		if ($options >= 1) {
			$hardware = true;
			$options -= 1;
		}

		$output = '';

		// Exclusion arrays
		$excludeExact = array(
			"AL",
			"BH",
			"KH"
		);
		$excludePrefix = array(
			"AL-",
			"BH-",
			"KH-"
		);
		$lines = array();

		foreach ($zohoOrders as $zohoOrder) {
			$accountName = $zohoOrder->account->getName();
			$ownerName = $zohoOrder->owner->getName();

			$mtsNumber = $zohoOrder->mtsNumber;


			$dbLineItems = $zohoOrder->dbLineItems;
			$zohoLineItems = $zohoOrder->zohoLineItems;

			$passDebug = false;
			if ($mtsNumber == 'MTS73683') {
				$passDebug = true;
			}

			// self::getDevicePrices($dbLineItems, $zohoLineItems, $passDebug);

			if ($debug) {
				echo "<pre>";
				echo "====================================\n";
				echo "==============$mtsNumber==============\n";
				echo "============DB Line Items===========\n";
				print_r($dbLineItems);
				echo "===========Zoho Line Items==========\n";
				print_r($zohoLineItems);
				echo "====================================\n";
				echo "====================================\n";
				echo "</pre>";
			}


			$words = explode(" ", $ownerName);
			$acronym = "";

			foreach ($words as $w) {
				$acronym .= $w[0];
			}

			$job = 'X'.$acronym;

			foreach ($dbLineItems as $lineItem) {
				$code = $lineItem->gradedSku;
				$name = $lineItem->machineType;
				$quantity = $lineItem->quantity;
				$total = $lineItem->totalValueAccountedFor;
				$listPrice = $lineItem->listPricePerDevice;

				// Handle hardware renaming
				if ($hardware) {
					$name = $code . ' - ' . $name;
				}
				if ($hardware) {
					$code = 'Hardware';
				}

				// Handle exclusions
				if (in_array($name, $excludeExact) || in_array(substr($name, 0, 3), $excludePrefix)) {
					continue;
				}

				// Build line
				$line = array(
					'"Co./Last Name"' => $accountName
					, '"First Name"' => ''
					, '"Addr 1 - Line 1"' => $accountName
					, '"Addr 1 - Line 2"' => $zohoOrder->billingStreet
					, '"Addr 1 - Line 3"' => $zohoOrder->billingCity . ', ' . $zohoOrder->billingState . ' ' . $zohoOrder->billingCode
					, '"Addr 1 - Line 4"' => ''
					, '"Invoice #"' => $zohoOrder->mtsNumber
					, '"Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Customer PO"' => $nopo?'':$zohoOrder->purchaseOrder
					, '"Ship Via"' => $zohoOrder->shipMethod
					, '"Delivery Status"' => ''
					, '"Item Number"' => $code
					, '"Quantity"' => $quantity
					, '"Description"' => $name
					, '"Price"' => $listPrice
					, '"Discount"' => $lineItem->discount
					, '"Total"' => $total
					, '"Job"' => $job
					, '"Comment"' => ''
					, '"Journal Memo"' => 'Sale ' . $accountName
					, '"Salesperson Last Name"' => substr($ownerName,  strpos($ownerName, ' ')+1)
					, '"Salesperson First Name"' => substr($ownerName, 0, strpos($ownerName, ' '))
					, '"Shipping Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Tax Code"' => $zohoOrder->tax>0?'CST':''
					, '"Tax Amount"' => $zohoOrder->tax
					, '"Freight Amount"' => '' // TODO
					, '"Tax on Freight"' => ''
					, '"Freight Tax Amount"' => ''
					, '"Sale Status"' => 'O'
					, '"Currency Code"' => ''
					, '"Exchange Rate"' => ''
					, '"Terms - Payment is Due"' => '2'
					, '"Terms - Payment is Due - Discount Days"' => ''
					, '"Terms - Payment is Due - Balance Due"' => '30'
					, '"Days - % Discount"' => ''
					, '"Days - % Monthly"' => ''
					, '"Referral Source"' => 'MTS'
					, '"Amount Paid"' => ''
					, '"Payment Method"' => ''
					, '"Payment Notes"' => ''
					, '"Name on Card"' => ''
					, '"Card Number"' => ''
					, '"Expiration Date"' => ''
					, '"Address(AVS)"' => ''
					, '"Zip(AVS)"' => ''
					, '"Credit Card Swiped"' => ''
					, '"Authorization Code"' => ''
					, '"Check Number"' => ''
					, '"Category"' => ''
					, '"Location ID"' => ''
					, '"Card Verification"' => ''
					, '"(CVV2) Used "' => ''
				);
				$output .= '"' . implode('","', $line) . '"' . "\n";
				array_push($lines, $line);
			}

			foreach ($zohoLineItems as $lineItem) {
				if ($lineItem->fulfilled) {
					continue;
				}
				$code = $lineItem->gradedSku;
				$name = $lineItem->machineType;
				$quantity = $lineItem->desiredQuantity;
				$total = $lineItem->desiredValue;
				$listPrice = $lineItem->listPricePerDevice;

				// Handle hardware renaming
				if ($hardware) {
					$name = $code . ' - ' . $name;
				}
				if ($hardware) {
					$code = 'Hardware';
				}

				// Handle exclusions
				if (in_array($name, $excludeExact) || in_array(substr($name, 0, 3), $excludePrefix)) {
					continue;
				}

				// Build line
				$line = array(
					'"Co./Last Name"' => $accountName
					, '"First Name"' => ''
					, '"Addr 1 - Line 1"' => $accountName
					, '"Addr 1 - Line 2"' => $zohoOrder->billingStreet
					, '"Addr 1 - Line 3"' => $zohoOrder->billingCity . ', ' . $zohoOrder->billingState . ' ' . $zohoOrder->billingCode
					, '"Addr 1 - Line 4"' => ''
					, '"Invoice #"' => $zohoOrder->mtsNumber
					, '"Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Customer PO"' => $nopo?'':$zohoOrder->purchaseOrder
					, '"Ship Via"' => $zohoOrder->shipMethod
					, '"Delivery Status"' => ''
					, '"Item Number"' => $code
					, '"Quantity"' => $quantity
					, '"Description"' => $name
					, '"Price"' => $listPrice
					, '"Discount"' => $lineItem->discount
					, '"Total"' => $total
					, '"Job"' => $job
					, '"Comment"' => ''
					, '"Journal Memo"' => 'Sale ' . $accountName
					, '"Salesperson Last Name"' => substr($ownerName,  strpos($ownerName, ' ')+1)
					, '"Salesperson First Name"' => substr($ownerName, 0, strpos($ownerName, ' '))
					, '"Shipping Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Tax Code"' => $zohoOrder->tax>0?'CST':''
					, '"Tax Amount"' => $zohoOrder->tax
					, '"Freight Amount"' => '' // TODO
					, '"Tax on Freight"' => ''
					, '"Freight Tax Amount"' => ''
					, '"Sale Status"' => 'O'
					, '"Currency Code"' => ''
					, '"Exchange Rate"' => ''
					, '"Terms - Payment is Due"' => '2'
					, '"Terms - Payment is Due - Discount Days"' => ''
					, '"Terms - Payment is Due - Balance Due"' => '30'
					, '"Days - % Discount"' => ''
					, '"Days - % Monthly"' => ''
					, '"Referral Source"' => 'MTS'
					, '"Amount Paid"' => ''
					, '"Payment Method"' => ''
					, '"Payment Notes"' => ''
					, '"Name on Card"' => ''
					, '"Card Number"' => ''
					, '"Expiration Date"' => ''
					, '"Address(AVS)"' => ''
					, '"Zip(AVS)"' => ''
					, '"Credit Card Swiped"' => ''
					, '"Authorization Code"' => ''
					, '"Check Number"' => ''
					, '"Category"' => ''
					, '"Location ID"' => ''
					, '"Card Verification"' => ''
					, '"(CVV2) Used "' => ''
				);
				$output .= '"' . implode('","', $line) . '"' . "\n";
				array_push($lines, $line);
			}

			foreach ($zohoOrder->lineItems as $lineItem) {
				continue; // to bypass
				$code = $lineItem->code;
				$name = $lineItem->name;

				// Handle exclusions
				if (in_array($name, $excludeExact) || in_array(substr($name, 0, 3), $excludePrefix)) {
					continue;
				}

				// Build line
				$line = array(
					'"Co./Last Name"' => $accountName
					, '"First Name"' => ''
					, '"Addr 1 - Line 1"' => $accountName
					, '"Addr 1 - Line 2"' => $zohoOrder->billingStreet
					, '"Addr 1 - Line 3"' => $zohoOrder->billingCity . ', ' . $zohoOrder->billingState . ' ' . $zohoOrder->billingCode
					, '"Addr 1 - Line 4"' => ''
					, '"Invoice #"' => $zohoOrder->mtsNumber
					, '"Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Customer PO"' => $nopo?'':$zohoOrder->purchaseOrder
					, '"Ship Via"' => $zohoOrder->shipMethod
					, '"Delivery Status"' => ''
					, '"Item Number"' => $hardware?'Hardware':$lineItem->code // TODO replace with sku calculated for actually sent devices if exists
					, '"Quantity"' => $lineItem->quantity
					, '"Description"' => $lineItem->name // TODO if Hardware concatenate sku and description (code and name)
					, '"Price"' => $lineItem->listPrice
					, '"Discount"' => $lineItem->discount
					, '"Total"' => $lineItem->totalAfterDiscount
					, '"Job"' => $job
					, '"Comment"' => ''
					, '"Journal Memo"' => 'Sale ' . $accountName
					, '"Salesperson Last Name"' => substr($ownerName,  strpos($ownerName, ' ')+1)
					, '"Salesperson First Name"' => substr($ownerName, 0, strpos($ownerName, ' '))
					, '"Shipping Date"' => $zohoOrder->shipDate->format('m/d/y')
					, '"Tax Code"' => $zohoOrder->tax>0?'CST':''
					, '"Tax Amount"' => $zohoOrder->tax
					, '"Freight Amount"' => '' // TODO
					, '"Tax on Freight"' => ''
					, '"Freight Tax Amount"' => ''
					, '"Sale Status"' => 'O'
					, '"Currency Code"' => ''
					, '"Exchange Rate"' => ''
					, '"Terms - Payment is Due"' => '2'
					, '"Terms - Payment is Due - Discount Days"' => ''
					, '"Terms - Payment is Due - Balance Due"' => '30'
					, '"Days - % Discount"' => ''
					, '"Days - % Monthly"' => ''
					, '"Referral Source"' => 'MTS'
					, '"Amount Paid"' => ''
					, '"Payment Method"' => ''
					, '"Payment Notes"' => ''
					, '"Name on Card"' => ''
					, '"Card Number"' => ''
					, '"Expiration Date"' => ''
					, '"Address(AVS)"' => ''
					, '"Zip(AVS)"' => ''
					, '"Credit Card Swiped"' => ''
					, '"Authorization Code"' => ''
					, '"Check Number"' => ''
					, '"Category"' => ''
					, '"Location ID"' => ''
					, '"Card Verification"' => ''
					, '"(CVV2) Used "' => ''
				);
				$output .= '"' . implode('","', $line) . '"' . "\n";
				array_push($lines, $line);

			}

			$output .= self::buildBlankCsvLine(count($line)) . "\n";
			array_push($lines, self::buildBlankCsvLine(count($line)));
		}
		// fclose($file);
		// return $output;
		return $lines;
	}

	private static function buildBlankCsvLine($numCells=0, $implode=false) {
		$blankLine = array();
		for ($i = 0; $i < $numCells; $i++) {
			array_push($blankLine, '');
		}
		if ($implode) {
			return '"' . implode('","', $blankLine) . '"';
		}
		else {
			return $blankLine;
		}
	}

	private static function getFilePath($fileName) {
		return self::getPathToFiles() . $fileName;
	}

	private static function getRemoteFilePath($fileName) {
		return self::getPathToRemoteFiles() . $fileName;
	}

	private static function getPathToFiles() {
		return self::$pathToFiles;
	}

	private static function getPathToRemoteFiles() {
		return self::$pathToRemoteFiles;
	}

	private static function getDevicePrices(&$dbLineItems, &$zohoLineItems, $debug=false) {
		// MTS73683 - orders to check
		// MTS73707
		// MTS73715


		// First run - start with db line items, search zoho line items by zoho ids.
		foreach ($dbLineItems as $dbLineItem) {

			$isSecondStock = $dbLineItem->isSecondStock;

			$hasQuantity = $dbLineItem->quantity;

			$availableQuantity = $dbLineItem->quantity;

			$totalValue = 0;

			$desiredQuantity = 0;

			// First, get the zoho ids and put them in variables
			$firstStockIndividualZohoId = $dbLineItem->zohoIds->firstStock->individual;
			$firstStockTenpackZohoId = $dbLineItem->zohoIds->firstStock->tenpack;

			$secondStockIndividualZohoId = $dbLineItem->zohoIds->secondStock->individual;
			$secondStockTenpackZohoId = $dbLineItem->zohoIds->secondStock->tenpack;

			if ($debug) {
				echo "<h2>Checking device prices for $dbLineItem->gradedSku, first run, starting with db line items</h2>";
				if ($isSecondStock) {
					echo "<h3>Is second stock</h3>";
				}
				else {
					echo "<h3>Is NOT second stock</h3>";
				}
				echo "<h3>Zoho IDs:</h3>";
				echo "<h4>First stock individual: $firstStockIndividualZohoId</h4>";

				echo "<h4>First stock tenpack: $firstStockTenpackZohoId</h4>";

				echo "<h4>Second stock individual: $secondStockIndividualZohoId</h4>";

				echo "<h4>Second stock tenpack: $secondStockTenpackZohoId</h4>";
			}

			// If second stock, check second stock IDs first
			if ($isSecondStock) {
				// If individual zoho ID exists, check that first
				if ($secondStockIndividualZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$secondStockIndividualZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$secondStockIndividualZohoId], $dbLineItem, $availableQuantity);
					}
				}
				// Then check for ten packs
				if ($secondStockTenpackZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$secondStockTenpackZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$secondStockTenpackZohoId], $dbLineItem, $availableQuantity);
					}
				}

				// After checking for second stock ids, check for first stock.
				// If individual zoho ID exists, check that first
				if ($firstStockIndividualZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$firstStockIndividualZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$firstStockIndividualZohoId], $dbLineItem, $availableQuantity);
					}
				}
				// Then check for ten packs
				if ($firstStockTenpackZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$firstStockTenpackZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$firstStockTenpackZohoId], $dbLineItem, $availableQuantity);
					}
				}
			}
			else { // If first stock, check first stock IDs first
				// If individual zoho ID exists, check that first
				if ($firstStockIndividualZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$firstStockIndividualZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$firstStockIndividualZohoId], $dbLineItem, $availableQuantity);
					}
				}
				// Then check for ten packs
				if ($firstStockTenpackZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$firstStockTenpackZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$firstStockTenpackZohoId], $dbLineItem, $availableQuantity);
					}
				}

				// After checking for first stock ids, check for second stock.
				// If individual zoho ID exists, check that first
				if ($secondStockIndividualZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$secondStockIndividualZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$secondStockIndividualZohoId], $dbLineItem, $availableQuantity);
					}
				}
				// Then check for ten packs
				if ($secondStockTenpackZohoId && $availableQuantity > 0) {
					// Check if it is in the zoho line items
					if ($zohoLineItems[$secondStockTenpackZohoId]) {
						$availableQuantity = self::handleDbZohoLineItemRelationship($zohoLineItems[$secondStockTenpackZohoId], $dbLineItem, $availableQuantity);
					}
				}
			}
		}
		// Second run - iterate over zoho line items, finding unfulfilled line items, and checking db for matching skus
		foreach ($zohoLineItems as $zohoLineItem) {
			if ($zohoLineItem->fulfilled) {
				continue;
			}

			$zohoItemBaseSku = $zohoLineItem->baseSku;
			$zohoItemSecondStockSku = $zohoItemBaseSku . "-D";

			$isSecondStock = $zohoLineItem->isSecondStock;

			// $hasQuantity = $zohoLineItem->quantity;

			$desiredQuantity = $zohoLineItem->desiredQuantity;

			$totalValue = 0;

			$desiredQuantity = 0;

			// If second stock, look for second stock sku first
			if ($isSecondStock) {
				if ($dbLineItems[$zohoItemSecondStockSku]) {
					self::handleDbZohoLineItemRelationship($zohoLineItem, $dbLineItems[$zohoItemSecondStockSku]);
				}
				if ($dbLineItems[$zohoItemBaseSku]) {
					self::handleDbZohoLineItemRelationship($zohoLineItem, $dbLineItems[$zohoItemBaseSku]);
				}

			}
			else { // If first stock, look for first stock sku first
				if ($dbLineItems[$zohoItemBaseSku]) {
					self::handleDbZohoLineItemRelationship($zohoLineItem, $dbLineItems[$zohoItemBaseSku]);
				}
				if ($dbLineItems[$zohoItemSecondStockSku]) {
					self::handleDbZohoLineItemRelationship($zohoLineItem, $dbLineItems[$zohoItemSecondStockSku]);
				}
			}
		}

		// Third run - iterate over db line items again to see if there are any with unaccounted-for items.
		// If so, iterate over unfulfilled zoho line items to see if there are any exact numerical matches.
		foreach ($dbLineItems as $dbLineItem) {
			// First calculate quantity unaccounted for by subtracting db quantity by accounted-for quantity
			$quantityUnaccountedFor = $dbLineItem->quantity - $dbLineItem->quantityAccountedFor;
			if ($quantityUnaccountedFor > 0) {
				// If any unaccounted for, loop over zoho line items
				foreach($zohoLineItems as $zohoLineItem) {
					if ($zohoLineItem->fulfilled) {
						// If the line item is already fulfilled, move onto the next
						continue;
					}
					// Get zoho line item's desired quantity
					$desiredQuantity = $zohoLineItem->desiredQuantity;
					$lineItemPrice = $zohoLineItem->listPricePerDevice;

					if ($quantityUnaccountedFor == $desiredQuantity) {
						// Check if the number sought is same as the number available.
						// If so, use its line item value and mark as fulfilled.

						$dbLineItem->totalValueAccountedFor += $quantityUnaccountedFor * $lineItemPrice;

						$zohoLineItem->fulfilled = true;
						$zohoLineItem->desiredQuantity = 0;
						$dbLineItem->listPricePerDevice = $lineItemPrice;
						$dbLineItem->quantityAccountedFor += $quantityUnaccountedFor;
						$quantityUnaccountedFor = 0;
					}
				}
			}
		}
	}

	private static function handleDbZohoLineItemRelationship(&$zohoLineItem, &$dbLineItem, $availableQuantity) {
		$availableQuantity = $dbLineItem->quantity - $dbLineItem->quantityAccountedFor;
		if ($availableQuantity == 0) {
			return 0;
		}
		if ($zohoLineItem->zohoId == '835703000030006177') {
			echo "<pre>";
			print_r($zohoLineItem);
			echo "</pre>";
		}
		// If not yet fulfilled, perform quantity checks
		if (!$zohoLineItem->fulfilled) {
			$listPricePerDevice = $zohoLineItem->listPricePerDevice;
			$dbLineItem->listPricePerDevice = $zohoLineItem->listPricePerDevice; // Set the db line item price to the zoho line item price
			$desiredQuantity = $zohoLineItem->desiredQuantity;

			// If there are more available than the line item desires
			// subtracted desired from available and set desired to
			// zero and mark zoho line item fulfilled
			if ($availableQuantity >= $desiredQuantity) {
				$availableQuantity -= $desiredQuantity;
				$zohoLineItem->desiredQuantity = 0;
				$zohoLineItem->desiredValue = 0;
				$zohoLineItem->fulfilled = true;

				$dbLineItem->quantityAccountedFor += $desiredQuantity;
				$dbLineItem->totalValueAccountedFor += $desiredQuantity * $listPricePerDevice;
			}
			elseif ($desiredQuantity > $availableQuantity) {
				// Else if available quantity less than desired quantity,
				// subtract available quantity from desired quantity
				$zohoLineItem->desiredQuantity -= $availableQuantity;
				$zohoLineItem->desiredValue -= $availableQuantity * $listPricePerDevice;


				$dbLineItem->totalValueAccountedFor += $availableQuantity * $listPricePerDevice;
				$dbLineItem->quantityAccountedFor += $availableQuantity;
				$availableQuantity = 0;

			}
		}
		if ($zohoLineItem->zohoId == '835703000030006177') {
			echo "<pre>";
			print_r($zohoLineItem);
			echo "</pre>";
		}

		return $availableQuantity;
	}

	private static function getZohoLineItems($zohoOrder) {
		// Exclusion arrays
		$excludeExact = array(
			"AL",
			"BH",
			"KH"
		);
		$excludePrefix = array(
			"AL-",
			"BH-",
			"KH-"
		);

		$zohoLineItems = array();
		foreach ($zohoOrder->lineItems as $zohoLineItem) {
			$sku = $zohoLineItem->code;
			$machineDescription = $zohoLineItem->name;
			if (in_array($sku, $excludeExact) || in_array($machineDescription, $excludeExact)) {
				continue;
			}
			if (in_array(substr($sku, 0, 3), $excludePrefix) || in_array(substr($machineDescription, 0, 3), $excludePrefix)) {
				continue;
			}

			$isSecondStock = self::determineIfZohoCodeSecondStock($sku);
			$isTenPack = self::determineIfZohoItemTenPack($zohoLineItem);
			$quantity = (int)$zohoLineItem->quantity;
			if ($isTenPack) {
				$quantity = $quantity * 10;
			}

			$listPrice = $zohoLineItem->listPrice;
			$discount = $zohoLineItem->discount;
			$totalAfterDiscount = $zohoLineItem->totalAfterDiscount;

			$listPricePerDevice = $isTenPack ? $listPrice / 10: $listPrice;
			$totalAfterDiscountPerDevice = $totalAfterDiscount / $quantity;


			$grade = $isSecondStock ? 'C' : 'A';

			$lineItem = new stdClass;
			$lineItem->zohoId = $zohoLineItem->zohoId;
			$lineItem->zohoCode = $sku;
			$lineItem->zohoName = $machineDescription;
			$lineItem->baseSku = self::getBaseSkuFromZohoCode($sku);
			$lineItem->gradedSku = self::convertToGradedSku($lineItem->baseSku, $grade);
			$lineItem->isSecondStock = $isSecondStock;
			$lineItem->isTenPack = $isTenPack;
			$lineItem->machineType = $machineDescription;
			$lineItem->quantity = $quantity;
			$lineItem->listPrice = $listPrice;
			$lineItem->discount = $discount;
			$lineItem->totalAfterDiscount = $totalAfterDiscount;
			$lineItem->listPricePerDevice = $listPricePerDevice;
			$lineItem->totalAfterDiscountPerDevice = $totalAfterDiscountPerDevice;

			$lineItem->desiredQuantity = $quantity;
			$lineItem->desiredValue = $totalAfterDiscount;
			$lineItem->fulfilled = false;

			$zohoLineItems[$lineItem->zohoId] = $lineItem;
		}

		return $zohoLineItems;
	}

	private static function getAllDbLineItems($zohoOrders) {
		$mtsNumbers = self::getAllMtsNumbers($zohoOrders);

		$orders = array();

		if (count($mtsNumbers) > 0) {
			$mtsNumberString = implode("', '", $mtsNumbers);

			$db = new Database;

			$sql = "SELECT COUNT(dso.oID) AS deviceCount, dso.asset, dso.`machineType`, dso.grade, dso.mts_number AS mtsNumber, mzi.*
					FROM ds_orders AS dso
					LEFT JOIN machine_order_number AS mon ON dso.asset = mon.order_number
					LEFT JOIN machine_zoho_ids AS mzi ON mon.order_number_id = mzi.machine_order_number_id
					WHERE dso.mts_number IN ('$mtsNumberString')
					GROUP BY mtsNumber, dso.asset, dso.grade
					ORDER BY mtsNumber ASC;";

			$results = $db->db_query($sql, 'select-multiple', true);

			foreach ($results as $result) {
				$resultObj = (object)$result;
				$mtsNumber = $resultObj->mtsNumber;
				$asset = $resultObj->asset;
				$grade = $resultObj->grade;
				$quantity = (int)$resultObj->deviceCount;
				$baseSku = self::convertToBaseSku($asset);
				$gradedSku = self::convertToGradedSku($asset, $grade);

				if ($orders[$mtsNumber] == null) {
					$orders[$mtsNumber] = array();
				}


				if ($orders[$mtsNumber][$gradedSku] == null) {
					$zohoIds = new stdClass;
					$zohoIds->firstStock = new stdClass;
					$zohoIds->secondStock = new stdClass;
					$zohoIds->firstStock->individual = $resultObj->first_stock_zoho_id_individual;
					$zohoIds->firstStock->tenpack = $resultObj->first_stock_zoho_id_tenpack;
					$zohoIds->secondStock->individual = $resultObj->second_stock_zoho_id_individual;
					$zohoIds->secondStock->tenpack = $resultObj->second_stock_zoho_id_tenpack;

					$lineItem = new stdClass;
					$lineItem->baseSku = $baseSku;
					$lineItem->gradedSku = $gradedSku;
					$lineItem->isSecondStock = $grade != 'A' && $grade != 'B' ? true : false;
					$lineItem->machineType = $resultObj->machineType;
					$lineItem->quantity = (int)$resultObj->deviceCount;
					$lineItem->quantityAccountedFor = 0;
					$lineItem->zohoIds = $zohoIds;
					$lineItem->listPrice = 0;
					$lineItem->discount = 0;
					$lineItem->totalAfterDiscount = 0;
					$lineItem->listPricePerDevice = 0;
					$lineItem->totalAfterDiscountPerDevice = 0;
					$lineItem->totalValueAccountedFor = 0;
				}
				else {
					$orders[$mtsNumber][$gradedSku]->quantity += $quantity;
				}


				$orders[$mtsNumber][$lineItem->gradedSku] = $lineItem;
			}
		}
		return $orders;
	}

	private static function getAllMtsNumbers($zohoOrders) {
		$mtsNumbers = array();

		foreach ($zohoOrders as $zohoOrder) {
			$mtsNumber = $zohoOrder->mtsNumber;
			array_push($mtsNumbers, $mtsNumber);
		}

		return $mtsNumbers;
	}

	private static function getDbLineItems($mtsNumber) {
		$db = new Database;
		$sql = "SELECT COUNT(dso.oID) AS deviceCount, dso.asset, dso.`machineType`, dso.grade, dso.mts_number
				FROM ds_orders AS dso
				WHERE dso.mts_number = '$mtsNumber'
				GROUP BY dso.mts_number, dso.asset, dso.grade
				ORDER BY asset ASC;";

		$results = $db->db_query($sql, 'select-multiple',true);

		$dbLineItems = array();
		foreach ($results as $result) {
			$resultObj = (object)$result;
			$asset = $resultObj->asset;
			$grade = $resultObj->grade;

			$lineItem = new stdClass;
			$lineItem->baseSku = self::convertToBaseSku($asset);
			$lineItem->gradedSku = self::convertToGradedSku($asset, $grade);
			$lineItem->isSecondStock = $grade != 'A' && $grade != 'B' ? true : false;
			$lineItem->machineType = $resultObj->machineType;
			$lineItem->quantity = $resultObj->deviceCount;


			$dbLineItems[$lineItem->gradedSku] = $lineItem;
		}

		return $dbLineItems;
	}

	private static function convertToBaseSku($asset) {
		$asset = trim($asset);
		if (preg_match('/(-\d{1,3}\/\d{2,4})$/', $asset)) {
			$asset = substr($asset, 0, strrpos($asset, '-'));
		}
		return $asset;
	}

	private static function convertToGradedSku($asset, $grade) {
		$asset = self::convertToBaseSku($asset);
		if ($grade != 'A' && $grade != 'B') {
			$asset .= "-D";
		}
		return $asset;
	}

	private static function determineIfZohoCodeSecondStock($zohoCode) {
		$isSecondStock = false;
		$secondStockPattern = "/(\/[A,B]-[C-D]$)|(2nd)|(Second)/i";
		if (preg_match($secondStockPattern, $zohoCode)) {
			$isSecondStock = true;
		}
		return $isSecondStock;
		// $secondStockStrings = array(
		// 	'2nd stock',
		// 	'second stock',
		// 	'-c',
		// 	'-d',
		// );

		// foreach ($secondStockStrings as $ssString) {
		// 	$pos = strpos(strtolower($zohoCode), strtolower($ssString));
		// 	if ($pos !== false) {
		// 		$isSecondStock = true;
		// 		return true;
		// 	}
		// }
		// return $isSecondStock;
	}

	private static function determineIfZohoItemTenPack($lineItem) {
		$zohoCode = $lineItem->code;
		$zohoName = $lineItem->name;

		$isTenPack = false;
		$tenPackPattern = "/((10|ten)(-| )?pack)/i";
		if (preg_match($tenPackPattern, $zohoCode)) {
			$isTenPack = true;
		}
		elseif (preg_match($tenPackPattern, $zohoName)) {
			$isTenPack = true;
		}
		return $isTenPack;
		// $tenPackStrings = array(
		// 	'10 pack',
		// 	'10-pack',
		// 	'ten pack',
		// 	'ten-pack',
		// );

		// foreach ($tenPackStrings as $tpString) {
		// 	$pos = strpos(strtolower($zohoCode), strtolower($ssString));
		// 	if ($pos !== false) {
		// 		$isTenPack = true;
		// 		return true;
		// 	}
		// }
		// return $isTenPack;
	}

	private static function getBaseSkuFromZohoCode($zohoCode) {
		// MJVM2LL/A-C 10-pack
		if (strpos($zohoCode, ' ') !== false) {
			$zohoCode = substr($zohoCode, 0, strpos($zohoCode, ' '));
		}
		// MJVM2LL/A-C

		// Pattern to find special suffixes
		$pattern = '/(\/[A,B]-(\d{1,4}-)?[A-D])$/';
		$length = strlen($zohoCode);
		$found = preg_match($pattern, $zohoCode, $matches, PREG_OFFSET_CAPTURE);
		if ($found) {
			$offset = $matches[0][1] + 2;
			$zohoCode = substr($zohoCode, 0, $offset);
		}
		return $zohoCode;
	}
}

?>
