<?php

class EncryptionService {
	private static $key = "5077BAFA2D65C09624198FF1FC10461FB5B5CCDB33D9C23205D8F3BC933643D9";
	private static $method = "aes-256-cbc";



	public static function encryptString($plaintext) {
		$key = self::getKey();
		$cipher = self::getCipher();

		$ivlen = openssl_cipher_iv_length($cipher);
		$iv = openssl_random_pseudo_bytes($ivlen);

		$ciphertextRaw = openssl_encrypt($plaintext, $cipher, $key, $options=OPENSSL_RAW_DATA, $iv);
		$hmac = hash_hmac('sha256', $ciphertextRaw, $key, $asBinary=true);

		$ciphertext = base64_encode( $iv.$hmac.$ciphertextRaw );

		return $ciphertext;
	}

	public static function decryptString($ciphertext) {
		$key = self::getKey();
		$cipher = self::getCipher();

		$c = base64_decode($ciphertext);

		$ivlen = openssl_cipher_iv_length($cipher);
		$iv = substr($c, 0, $ivlen);

		$hmac = substr($c, $ivlen, $sha2len=32);
		$ciphertextRaw = substr($c, $ivlen+$sha2len);

		$originalPlaintext = openssl_decrypt($ciphertextRaw, $cipher, $key, $options=OPENSSL_RAW_DATA, $iv);
		$calcmac = hash_hmac('sha256', $ciphertextRaw, $key, $asBinary=true);

		if (hash_equals($hmac, $calcmac))//PHP 5.6+ timing attack safe comparison
		{
			return $originalPlaintext;
		}
		else {
			return '';
		}
	}

	public static function getCipher() {
		return self::$method;
	}

	private static function getKey() {
		return self::$key;
	}
}

?>
