<?php

class EmailListService {

	public static function getContactByEmailAddress($email) {
		return EmailListContact::fetchByEmailAddress($email);
	}

	public static function getContactById($id) {
		$contact = EmailListContact::getById($id);

		return $contact;
	}

	public static function emailListImport($zohoLeadFile='all') {
		echo "<pre>";
		if ($_GET['zohoLeadFile']) {
			$zohoLeadFile = $_GET['zohoLeadFile'];
		}
		if ($zohoLeadFile == 'all') {
			$zohoLeadFiles = array(
				'zohoLeads1.csv',
				'zohoLeads2.csv',
				'zohoLeads3.csv',
				'zohoLeads4.csv',
			);
		}
		else {
			if (substr($zohoLeadFile, -4) != '.csv') {
				$zohoLeadFile .= '.csv';
			}
			$zohoLeadFiles = array($zohoLeadFile);
		}
		$zohoContactFiles = array(
			'zohoContacts.csv'
		);
		$constantContactFiles = array(
			'constantContact.csv'
		);

		$emailList = array();

		$zohoLeads = array();
		$zohoContacts = array();
		$constantContacts = array();

		$masterList = array();
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		echo "Starting Zoho Leads import $currentTimeFormatted\n";
		foreach ($zohoLeadFiles as $fileName) {
			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Starting $fileName import $currentTimeFormatted\n";

			self::zohoLeadsCsvGetData($fileName, $zohoLeads, $emailList);

			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Finished $fileName import $currentTimeFormatted\n";
		}
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		$zohoLeadCount = count($zohoLeads);
		echo "Finished $zohoLeadCount Zoho Leads import $currentTimeFormatted\n";
		echo "Starting Zoho Contacts import $currentTimeFormatted\n";
		foreach ($zohoContactFiles as $fileName) {
			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Starting $fileName import $currentTimeFormatted\n";

			self::zohoContactsCsvGetData($fileName, $zohoContacts, $emailList);

			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Finished $fileName import $currentTimeFormatted\n";
		}
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		$zohoContactCount = count($zohoContacts);
		echo "Finished $zohoContactCount Zoho Contacts import $currentTimeFormatted\n";
		echo "Starting Constant Contacts import $currentTimeFormatted\n";
		foreach ($constantContactFiles as $fileName) {
			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Starting $fileName import $currentTimeFormatted\n";

			self::constantContactsCsvGetData($fileName, $constantContacts, $emailList);

			$currentTime = new DateTime('now', new DateTimeZone('UTC'));
			$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
			echo "Finished $fileName import $currentTimeFormatted\n";
		}
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		$constantContactCount = count($constantContacts);
		echo "Finished $constantContactCount Constant Contacts import $currentTimeFormatted\n";


		echo "Starting arranging email list $currentTimeFormatted\n";
		$emailList = array_unique($emailList);
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		$emailListCount = count($emailList);
		echo "Finished arranging $emailListCount unique emails $currentTimeFormatted\n";


		echo "Starting building and saving EmailContact items $currentTimeFormatted\n";
		foreach ($emailList as $email) {
			$masterListItemData = array();
			$masterListItemData['emailAddress'] = $email;
			$masterListItemData['emailOptOut'] = false;

			$zohoLead = $zohoLeads[$email];
			$zohoContact = $zohoContacts[$email];
			$constantContact = $constantContacts[$email];

			$masterListItemData['zohoLead'] = $zohoLead;
			$masterListItemData['zohoContact'] = $zohoContact;
			$masterListItemData['constantContact'] = $constantContact;

			$emailListContact = new EmailListContact($masterListItemData);

			$emailListContact->save();
			array_push($masterList, $emailListContact);
		}
		$currentTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentTimeFormatted = $currentTime->format(DATE_ISO8601);
		$emailListCount = count($emailList);
		echo "Finished building and saving EmailContact items $currentTimeFormatted\n";
		echo "</pre>";
	}

	private static function zohoLeadsCsvGetData($csvName='zohoLeads1.csv', &$zohoLeads=array(), &$emailList=array()) {
		$fileName = HTML_FOLDER . "classes/EmailList/import/" . $csvName;

		$row = 0;
		$headRowIndex = 0;

		$headRow = null;

		if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 16000, ",")) !== FALSE) {
				// $num = count($data);
				// echo "<p> $num fields in line $row: <br /></p>\n";

				if ($row == $headRowIndex) {
					$headRow = self::buildHeadArrayFromCsvRow($data);
				}
				else {
					$leadDataRow = self::buildAssociativeArrayFromCsvRowAndHeadArray($data, $headRow);

					$lead = Lead::constructFromCsvImportRow($leadDataRow);
					$email = trim($lead->getEmail());
					$zohoLeads[$email] = $lead;
					array_push($emailList, $email);
				}
				$row++;
			}
			fclose($handle);
		}
		else {
			echo "<p>Failed to open zoho leads handle</p>";
		}

		return $zohoLeads;
	}

	private static function zohoContactsCsvGetData($csvName='zohoContacts.csv', &$zohoContacts=array(), &$emailList) {

		$fileName = HTML_FOLDER . "classes/EmailList/import/" . $csvName;

		$row = 0;
		$headRowIndex = 0;

		$headRow = null;

		if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 16000, ",")) !== FALSE) {
				if ($row == $headRowIndex) {
					$headRow = self::buildHeadArrayFromCsvRow($data);

				}
				else {
					$contactDataRow = self::buildAssociativeArrayFromCsvRowAndHeadArray($data, $headRow);

					$contact = Contact::constructFromCsvImportRow($contactDataRow);
					$emailAddress = trim($contact->getEmail());
					$zohoContacts[$emailAddress] = $contact;
					array_push($emailList, $emailAddress);

				}

				$row++;
			}
			fclose($handle);
		}
		else {
			echo "<p>Failed to open handle</p>";
		}

		return $zohoContacts;
	}

	private static function constantContactsCsvGetData($csvName = "constantContact.csv", &$constantContacts=array(), &$emailList) {

		$fileName = HTML_FOLDER . "classes/EmailList/import/" . $csvName;

		$row = 0;
		$headRowIndex = 0;

		$headRow = null;

		if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 16000, ",")) !== FALSE) {
				// $num = count($data);
				// echo "<p> $num fields in line $row: <br /></p>\n";

				if ($row == $headRowIndex) {
					$headRow = self::buildHeadArrayFromCsvRow($data);

				}
				else {
					$contactDataRow = self::buildAssociativeArrayFromCsvRowAndHeadArray($data, $headRow);
					$contact = ConstantContact::constructFromCsvImportRow($contactDataRow);
					$email = trim($contact->getEmail());
					$constantContacts[$email] = $contact;
					array_push($emailList, $email);

					// array_push($contacts, $contact);
				}

				// $contact = new Contact($contactData);
				$row++;
			}
			fclose($handle);
		}
		else {
			echo "<p>Failed to open handle</p>";
		}

		return $constantContacts;
	}

	public static function leadsCsvImport($csvName='zohoLeads1.csv') {

		$fileName = HTML_FOLDER . "classes/EmailList/import/" . $csvName;

		$row = 0;
		$headRowIndex = 0;

		$headRow = null;

		if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 16000, ",")) !== FALSE) {
				// $num = count($data);
				// echo "<p> $num fields in line $row: <br /></p>\n";

				if ($row == $headRowIndex) {
					$headRow = self::buildHeadArrayFromCsvRow($data);
				}
				else {
					$leadDataRow = self::buildAssociativeArrayFromCsvRowAndHeadArray($data, $headRow);

					$lead = Lead::constructFromCsvImportRow($leadDataRow);
					$lead->save(true);

					// echo "<pre>";
					// print_r($lead);
					// echo "</pre>";
					// array_push($leads, $lead);
				}

				// $lead = new Lead($leadData);
				$row++;

				// if ($num > 100) {
				// 	return true;
				// }
			}
			fclose($handle);
		}
		else {
			echo "<p>Failed to open handle</p>";
		}
	}

	public static function accountCsvImport() {
		$csvName = 'zohoAccounts.csv';

		$fileName = HTML_FOLDER . "classes/EmailList/import/" . $csvName;

		$row = 0;
		$headRowIndex = 0;

		$headRow = null;

		if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 8000, ",")) !== FALSE) {
				// $num = count($data);
				// echo "<p> $num fields in line $row: <br /></p>\n";

				if ($row == $headRowIndex) {
					$headRow = self::buildHeadArrayFromCsvRow($data);

				}
				else {
					$accountDataRow = self::buildAssociativeArrayFromCsvRowAndHeadArray($data, $headRow);
					$account = Account::constructFromCsvImportRow($accountDataRow);
					$account->save(true);

					echo "<pre>";
					print_r($account);
					echo "</pre>";
					array_push($accounts, $account);
				}

				// $account = new Account($accountData);
				$row++;
			}
			fclose($handle);
		}
		else {
			echo "<p>Failed to open handle</p>";
		}

	}

	public static function consolidateContacts() {
		$db = new Database;

		$zohoLeadListTable = Lead::getDbTable();
		$zohoContactListTable = Contact::getDbTable();
		$constantContactListTable = ConstantContact::getDbTable();

		// get zoho contact list
		$sql = "SELECT `id`, `email` FROM `$zohoContactListTable` ORDER BY `zohoId`;";
		$results = $db->db_query($sql, 'select-multiple');
		$contactListArrayById = array();
		$contactListArrayByEmail = array();
		foreach ($results as $result) {
			$id = $result['id'];
			$email = $result['email'];
			$contactListArrayById[$id] = $email;
			if ($email) {
				$contactListArrayByEmail[$email] = $id;
			}
		}

		// get constant contact list
		$sql = "SELECT `id`, `email` FROM `$constantContactListTable` WHERE `email` != '' AND `email` IS NOT NULL ORDER BY `email` ASC;";
		$results = $db->db_query($sql, 'select-multiple');
		$constantContactListArrayById = array();
		$constantContactListArrayByEmail = array();
		foreach ($results as $result) {
			$id = $result['id'];
			$email = $result['email'];
			$constantContactListArrayById[$id] = $email;
			if ($email) {
				$constantContactListArrayByEmail[$email] = $id;
			}
		}

		// get zoho lead list
		$sql = "SELECT `id`, `email` FROM `$zohoLeadListTable` ORDER BY `zohoId`;";
		$results = $db->db_query($sql, 'select-multiple');
		$leadListArrayById = array();
		$leadListArrayByEmail = array();
		foreach ($results as $result) {
			$id = $result['id'];
			$email = $result['email'];
			$leadListArrayById[$id] = $email;
			if ($email) {
				$leadListArrayByEmail[$email] = $id;
			}
		}

		// iterate over leads
		foreach ($leadListArrayById as $leadListId => $leadListEmail) {
			// instantiate contact id variables
			$zohoContactId = null;
			$constantContactId = null;

			// check if zoho contact list has email
			if ($contactListArrayByEmail[$leadListEmail]) {
				// if so, store in variable
				$zohoContactId = $contactListArrayByEmail[$leadListEmail];
				// since id is accounted for, remove it from list of ids
				unset($contactListArrayById[$zohoContactId]);
			}

			// check if constant contact list has email
			if ($constantContactListArrayByEmail[$leadListEmail]) {
				// if so, store in variable
				$constantContactId = $constantContactListArrayByEmail[$leadListEmail];
				// since id is accounted for, remove it from list of ids
				unset($constantContactListArrayById[$constantContactId]);
			}

			// build data generic class
			$consolidatedData = new stdClass;
			$consolidatedData->zohoLeadId = $leadListId;
			$consolidatedData->zohoContactId = $zohoContactId;
			$consolidatedData->constantContactId = $constantContactId;
			$consolidatedData->emailAddress = $leadListEmail;

			// instantiate new instance of ConsolidatedContact with data
			$consolidatedContact = new ConsolidatedContact($consolidatedData);
			// save
			$consolidatedContact->save();
		}

		// iterate over zoho contacts
		foreach ($contactListArrayById as $zohoContactId => $zohoContactEmail) {
			// instantiate lead/constant contact id variables
			$zohoLeadId = null;
			$constantContactId = null;

			// check if zoho lead list has email
			if ($leadListArrayByEmail[$zohoContactEmail]) {
				// if so, store in variable
				$zohoLeadId = $leadListArrayByEmail[$zohoContactEmail];
				// since id is accounted for, remove it from list of ids
				unset($leadListArrayById[$zohoLeadId]);
			}

			// check if constant contact list has email
			if ($constantContactListArrayByEmail[$zohoContactEmail]) {
				// if so, store in variable
				$constantContactId = $constantContactListArrayByEmail[$zohoContactEmail];
				// since id is accounted for, remove it from list of ids
				unset($constantContactListArrayById[$constantContactId]);
			}

			// build data generic class
			$consolidatedData = new stdClass;
			$consolidatedData->zohoLeadId = $zohoLeadId;
			$consolidatedData->zohoContactId = $zohoContactId;
			$consolidatedData->constantContactId = $constantContactId;
			$consolidatedData->emailAddress = $zohoContactEmail;

			// instantiate new instance of ConsolidatedContact with data
			$consolidatedContact = new ConsolidatedContact($consolidatedData);
			// save
			$consolidatedContact->save();
		}

		// iterate over constant contacts
		foreach ($constantContactListArrayById as $constantContactId => $constantContactEmail) {
			// instantiate zoho lead/contact id variables
			$zohoLeadId = null;
			$zohoContactId = null;

			// check if zoho lead list has email
			if ($leadListArrayByEmail[$constantContactEmail]) {
				// if so, store in variable
				$zohoLeadId = $leadListArrayByEmail[$constantContactEmail];
				// since id is accounted for, remove it from list of ids
				unset($leadListArrayById[$zohoLeadId]);
			}

			// check if constant contact list has email
			if ($contactListArrayByEmail[$constantContactEmail]) {
				// if so, store in variable
				$zohoContactId = $contactListArrayByEmail[$constantContactEmail];
				// since id is accounted for, remove it from list of ids
				unset($contactListArrayById[$zohoContactId]);
			}

			// build data generic class
			$consolidatedData = new stdClass;
			$consolidatedData->zohoLeadId = $zohoLeadId;
			$consolidatedData->zohoContactId = $zohoContactId;
			$consolidatedData->constantContactId = $constantContactId;
			$consolidatedData->emailAddress = $constantContactEmail;

			// instantiate new instance of ConsolidatedContact with data
			$consolidatedContact = new ConsolidatedContact($consolidatedData);
			// save
			$consolidatedContact->save();
		}
	}

	private static function buildHeadArrayFromCsvRow($csvRow) {
		$headArray = array();
		foreach ($csvRow as $cellValue) {
			array_push($headArray, $cellValue);
		}
		return $headArray;
	}

	private static function buildAssociativeArrayFromCsvRowAndHeadArray($csvRow, &$headArray) {
		$csvArray = array();
		$length = count($headArray);
		for ($i = 0; $i < $length; $i++) {
			$headerName = $headArray[$i];
			$csvVal = $csvRow[$i];
			$csvArray[$headerName] = $csvVal;
		}

		return $csvArray;
	}

	private static function buildSearchString($searchParams) {
		if ($searchParams['state'] != '0') {
			unset($searchParams['region']);
		}
		elseif ($searchParams['region'] != '0') {
			unset($searchParams['state']);
		}

		$searchClauses = array();

		foreach ($searchParams as $key => $value) {
			$escapedValue = mysql_real_escape_string($value);

			$searchClause = '';

			if ($key == "firstName" || $key == "lastName" || $key == "leadSource" || $key == "title") {
				$searchClause = "(el.zl_$key LIKE '$value%' OR el.zc_$key LIKE '$value%' OR el.cc_$key LIKE '$value%')";
			}
			elseif ($key == "organization") {
				$searchClause = "(el.zl_organization LIKE '$value%' OR el.cc_organization LIKE '$value%' OR oa.name LIKE '$value%')";
			}
			elseif ($key == "enrollment" || $key == "totalSpent") {
				if ((int)$escapedValue > 0) {

					$comparator = $searchParams[$key . "_comparator"];
					if ($comparator == 'greater_than') {
						$searchClause = "oa.`$key` >= '$escapedValue'";
					}
					elseif ($comparator == "less_than") {
						$searchClause = "(oa.`$key` <= '$escapedValue' AND oa.`$key` IS NOT NULL)";
					}
					array_push($zohoAccountsSearchClauses, $clause);
				}
			}
			elseif ($key == 'accountType') {
				$searchClause = "oa.accountType = '$escapedValue'";
			}
			elseif ($key == "city") {
				$searchClause = "(el.zl_addressCity LIKE '$escapedValue%' OR el.zc_addressCity LIKE '$escapedValue%' OR (oa.billingCity LIKE '$escapedValue%' OR oa.shippingCity LIKE '$escapedValue%'))";
			}
			elseif ($key == "code") {
				$searchClause = "(el.zl_addressCode LIKE '$escapedValue%' OR el.zc_addressCode LIKE '$escapedValue%' OR (oa.billingCode LIKE '$escapedValue%' OR oa.shippingCode LIKE '$escapedValue%'))";
			}
			elseif ($key == "state" && $escapedValue != "0") {
				$searchClause = "(el.zl_stateId='$escapedValue' OR el.zc_stateId='$escapedValue' OR oa.billingStateId ='$escapedValue' OR oa.shippingStateId='$escapedValue')";
			}
			elseif ($key == "region" && $escapedValue != "0") {
				$searchClause = "(el.zl_stateId IN ( SELECT * FROM ( SELECT `id` FROM `states` WHERE `region_id`='$escapedValue' ) AS zl_state_subquery ) OR
								el.zc_stateId IN ( SELECT * FROM ( SELECT `id` FROM `states` WHERE `region_id`='$escapedValue' ) AS zc_state_subquery ) OR
								oa.billingStateId IN ( SELECT * FROM ( SELECT `id` FROM `states` WHERE `region_id`='$escapedValue' ) AS oa_billingstate_subquery ) OR
								oa.shippingStateId IN ( SELECT * FROM ( SELECT `id` FROM `states` WHERE `region_id`='$escapedValue' ) AS oa_shippingstate_subquery ))";
			}
			elseif ($key == "email") {
				$searchClause = "el.emailAddress LIKE '$escapedValue%'";
			}
			elseif ($key == "emailDomain") {
				$searchClause = "el.emailAddress LIKE '%$escapedValue'";
			}
			elseif ($value != '0' && ($key == "emailOptOut" || $key == "zohoLeadExists" || $key == "zohoContactExists" || $key == "constantContactExists")) {
				$trueValue = (int)$escapedValue - 1;
				$searchClause = "el.$key = '$trueValue'";
			}

			if ($searchClause && strlen($searchClause) > 0) {
				array_push($searchClauses, $searchClause);

			}
		}

		$searchString = implode(' AND ', $searchClauses);

		return $searchString;
	}

	private static function buildOrderString($sortBy, $sortOrder) {
		$orderString = 'ORDER BY el.id ASC';
		if ($sortBy && $sortBy != '') {
			$sortSubstring = '';
			$sortOrder = strtoupper($sortOrder); // ASC or DESC

			/*

				city : new ColumnDefinition('City', 'city', {isSortable: true}),
				state : new ColumnDefinition('State', 'state', {isSortable: true}),
			*/
			if ($sortBy == 'emailAddress') {
				$sortSubstring = 'el.emailAddress';
			}
			elseif ($sortBy == 'emailOptOut') {
				$sorbSubstring = 'el.emailOptOut';
			}
			elseif ($sortBy == 'name') {
				$sortSubstring = "el.zl_firstName, el.zl_lastName, el.zc_firstName, el.zc_lastName, el.cc_firstName, el.cc_lastName";
			}
			elseif ($sortBy == 'organization') {
				$sortSubstring = "account_name, el.zl_organization, el.cc_organization";
			}
			elseif ($sortBy == 'title') {
				$sortSubstring = "el.zl_title, el.zc_title, el.cc_title";
			}
			elseif ($sortBy == 'leadSource') {
				$sortSubstring = "el.zl_leadSource, el.zc_leadSource, el.cc_leadSource";
			}
			elseif ($sortBy == 'accountType') {
				$sortSubstring = "account_accountType";
			}
			elseif ($sortBy == 'enrollment') {
				$sortSubstring = "account_enrollment";
			}
			elseif ($sortBy == 'totalSpent') {
				$sortSubstring = "account_totalSpent";
			}
			elseif ($sortBy == 'onZohoLeads') {
				$sortSubstring = "zohoLeadExists";
			}
			elseif ($sortBy == 'onZohoContacts') {
				$sortSubstring = "zohoContactExists";
			}
			elseif ($sortBy == 'onConstantContact') {
				$sortSubstring = "constantContactExists";
			}
			elseif ($sortBy == "city") {
				$sortSubstring = "account_billingCity, account_shippingCity, el.zc_addressCity, el.zl_addressCity";
			}
			elseif ($sortBy == "state") {
				$sortSubstring = "account_billingStateId, account_shippingStateId, el.zc_addressState, el.zl_addressState";
			}

			if ($sortSubstring) {
				$orderString = "ORDER BY $sortSubstring $sortOrder";
			}
		}
		return $orderString;
	}

	public static function fetchList($searchParams, &$metadata=null, $limit=25000, $offset=0) {
		$searchString = self::buildSearchString($searchParams);

		$limitString = '';
		$offsetString = '';

		$orderString = self::buildOrderString($searchParams['sortBy'], $searchParams['sortOrder']);

		if ($searchString) {
			$searchString = "WHERE " . $searchString;
		}
		if ($limit != 0) {
			$limitString = "LIMIT $limit";
			if ($offset != 0) {
				$offsetString = "OFFSET $offset";
			}
		}

		$sql = "SELECT el.*,
					oa.id AS account_id,
					oa.name AS account_name,
					oa.zoho_id AS account_zohoId,
					oa.phoneNumber AS account_phoneNumber,
					oa.website AS account_website,
					oa.accountType AS account_accountType,
					oa.enrollment AS account_enrollment,
					oa.totalSpent AS account_totalSpent,
					oa.billingStreet AS account_billingStreet,
					oa.billingCity AS account_billingCity,
					oa.billingCode AS account_billingCode,
					oa.billingStateId AS account_billingStateId,
					oa.shippingStreet AS account_shippingStreet,
					oa.shippingCity AS account_shippingCity,
					oa.shippingCode AS account_shippingCode,
					oa.shippingStateId AS account_shippingStateId
				FROM email_master_list AS el
				LEFT JOIN order_accounts AS oa ON el.zc_accountId = oa.id
				$searchString
				$orderString $limitString $offsetString;";

		$metadata->query = $sql;

		$db = new Database;

		$results = $db->db_query($sql, 'select-multiple', true);

		$contacts = array();

		foreach ($results as $result) {
			$emailListContact = new EmailListContact($result, true);

			array_push($contacts, $emailListContact);
		}
		return $contacts;
	}

	/**
	 * Fetch the total number of matches with a given search parameter
	 */
	public static function getCountWithSearchParams($searchParams) {
		$searchString = self::buildSearchString($searchParams);
		if ($searchString) {
			$searchString = "WHERE " . $searchString;
		}

		$db = new Database;

		$contactCount = 0;
		$sql = "SELECT COUNT(el.id) AS contactCount
				FROM email_master_list AS el
				LEFT JOIN order_accounts AS oa ON el.zc_accountId = oa.id
				$searchString;";

		$result = $db->db_query($sql, 'select-single', true);

		if ($result['contactCount']) {
			$contactCount = (int)$result['contactCount'];
		}

		return $contactCount;
	}

	public static function updateAccounts($debug=false, $browser=false) {
		global $zohoObj;

		if ($debug) {
			$timestamp = Utility::getCurrentTimestamp();
			if ($browser) {
				echo "<h2>Beginning Zoho Account fetch</h2><p>Start time: $timestamp</p>";
			}
			else {
				echo "====Beginning Zoho Account fetch====\nStart time: $timestamp\n";
			}
		}

		$accounts = $zohoObj->getAccountsModifiedSinceDate();
		if ($debug) {
			$accountCount = count($accounts);
			$timestamp = Utility::getCurrentTimestamp();
			echo "<p>Fetched $accountCount Accounts, completed $timestamp</p>";
		}
		foreach ($accounts as $account) {
			try {
				$account->save();
			}
			catch (Exception $e) {
				echo "<p>";
				echo $e->getMessage();
				echo "</p>";
			}
		}
	}

	public static function updateZohoLeads($debug=false, $browser=false) {
		global $zohoObj;

		if ($debug) {
			$timestamp = Utility::getCurrentTimestamp();
			if ($browser) {
				echo "<h2>Beginning Zoho Lead fetch</h2><p>Start time: $timestamp</p>";
			}
			else {
				echo "====Beginning Zoho Lead fetch====\nStart time: $timestamp\n";
			}
		}

		$leads = $zohoObj->getLeadsModifiedSinceDate();
		if ($debug) {
			$leadCount = count($leads);
			$timestamp = Utility::getCurrentTimestamp();
			$outputStr = "Fetched $leadCount Leads, completed $timestamp";
			if ($browser) {
				echo "<p>$outputStr</p>";
			}
			else {
				echo "$outputStr\n";
			}
		}
		foreach ($leads as $lead) {
			$emailAddress = $lead->getEmail();
			$emailListContact = EmailListContact::getByEmailAddress($emailAddress);
			if ($emailListContact) {
				$emailListContact->setZohoLead($lead);
			}
			else {
				$emailListContactData = new stdClass;
				$emailListContactData->emailAddress = $emailAddress;
				$emailListContactData->zohoLead = $lead;
				$emailListContact = new EmailListContact($emailListContactData);
			}
			$emailListContact->save();
		}
	}

	public static function updateZohoContacts($debug=false, $browser=false) {
		global $zohoObj;

		if ($debug) {
			$timestamp = Utility::getCurrentTimestamp();
			if ($browser) {
				echo "<h2>Beginning Zoho Contact fetch</h2><p>Start time: $timestamp</p>";
			}
			else {
				echo "====Beginning Zoho Contact fetch====\nStart time: $timestamp\n";
			}
		}

		$contacts = $zohoObj->getContactsModifiedSinceDate();
		if ($debug) {
			$contactCount = count($contacts);
			$timestamp = Utility::getCurrentTimestamp();
			$outputStr = "Fetched $contactCount Contacts, completed $timestamp";
			if ($browser) {
				echo "<p>$outputStr</p>";
			}
			else {
				echo "$outputStr\n";
			}
		}
		foreach ($contacts as $contact) {
			$emailAddress = $contact->getEmail();
			$emailListContact = EmailListContact::getByEmailAddress($emailAddress);
			if ($emailListContact) {
				$emailListContact->setZohoContact($contact);
			}
			else {
				$emailListContactData = new stdClass;
				$emailListContactData->emailAddress = $emailAddress;
				$emailListContactData->zohoContact = $contact;
				$emailListContact = new EmailListContact($emailListContactData);
			}
			$emailListContact->save();
		}
	}

	public static function updateConstantContact($debug=false, $browser=false) {
		require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");

		if ($debug) {
			$timestamp = Utility::getCurrentTimestamp();
			if ($browser) {
				echo "<h2>Beginning Constant Contact fetch</h2><p>Start time: $timestamp</p>";
			}
			else {
				echo "====Beginning Constant Contact fetch====\nStart time: $timestamp\n";
			}
		}


		$parameters = array();
		$parameters['updated_after'] = date('Y-m-d', time() - (2 * 30 * 24 * 60 * 60)); // two months ago
		$parameters['limit'] = 500;

		$contacts = ConstantContactAPI::getContactsCollection($parameters);
		if ($debug) {
			$contactCount = count($contacts);
			$timestamp = Utility::getCurrentTimestamp();
			$outputStr = "Fetched $contactCount Constant Contacts, completed $timestamp";
			if ($browser) {
				echo "<p>$outputStr</p>";
			}
			else {
				echo "$outputStr\n";
			}
		}

		foreach ($contacts as $contact) {
			$emailAddress = $contact->email_address->address;
			$emailOptOut = true;
			if ($contact->email_address->permission_to_send == 'explicit' || $contact->email_address->permission_to_send == 'implicit') {
				$emailOptOut = false;
			}
			$firstName = $contact->first_name;
			$lastName = $contact->last_name;
			$title = $contact->job_title;
			$organization = $contact->company_name;

			$dbContact = EmailListContact::getByEmailAddress($emailAddress);
			if ($dbContact) {
				$changed = false;

				$existingEmailOptOut = $dbContact->getEmailOptOut();

				if ($emailOptOut == true && $emailOptOut !== $existingEmailOptOut) {
					$changed = true;
					$dbContact->setEmailOptOut($emailOptOut);
				}

				if ($dbContact->getConstantContact()) {
					$existingFirstName = $dbContact->getConstantContact()->getFirstName();
					$existingLastName = $dbContact->getConstantContact()->getLastName();
					$existingTitle = $dbContact->getConstantContact()->getTitle();
					$existingOrganization = $dbContact->getConstantContact()->getOrganization();
					if ($existingFirstName != $firstName && $firstName != '') {
						$changed = true;
						$dbContact->getConstantContact()->setFirstName($firstName);
					}
					if ($existingLastName != $lastName && $lastName != '') {
						$changed = true;
						$dbContact->getConstantContact()->setLastName($lastName);
					}
					if ($existingTitle != $title && $title != '') {
						$changed = true;
						$dbContact->getConstantContact()->setTitle($title);
					}
					if ($existingOrganization != $organization && $organization != '') {
						$changed = true;
						$dbContact->getConstantContact()->setOrganization($organization);
					}
				}
				else {
					$constantContactData = array(
						'email' => $emailAddress,
						'firstName' => $firstName,
						'lastName' => $lastName,
						'title' => $title,
						'organization' => $organization,
					);
					$constantContact = new ConstantContact($constantContactData);
					$dbContact->setConstantContact($constantContact);
					$changed = true;
				}
				if ($changed) {
					$dbContact->save();
				}
			}
			else {
				$constantContactData = array(
					'email' => $emailAddress,
					'firstName' => $firstName,
					'lastName' => $lastName,
					'title' => $title,
					'organization' => $organization,
				);
				$constantContact = new ConstantContact($constantContactData);
				$newContactData = array(
					'emailAddress' => $emailAddress,
					'emailOptOut' => $emailOptOut,
					'constantContact' => $constantContact
				);
				$newContact = new EmailListContact($newContactData);
				$newContact->save();
			}
		}


	}

	private static function performConsolidatedSearch($emailSearchClauses, $zohoLeadResults, $zohoContactResults, $constantContactResults, $zohoContactRequired=false, &$metadata=null) {
		$requiredSearchClauses = array();
		$optionalSearchClauses = array();


		foreach ($emailSearchClauses as $emailSearchClause) {
			array_push($requiredSearchClauses, $emailSearchClause);
		}

		if (count($zohoContactResults) > 0) {
			$zohoContactString = "`zohoContactId` IN ('" . implode($zohoContactResults, "', '") . "')";
			if ($zohoContactRequired) {
				array_push($requiredSearchClauses, $zohoContactString);
			}
			else {
				array_push($optionalSearchClauses, $zohoContactString);
			}
		}


		// Handle optional clauses. If zoho contact is required, bypass other foreign key checks
		if (count($zohoLeadResults) > 0 && !$zohoContactRequired) {
			$zohoLeadString = "`zohoLeadId` IN ('" . implode($zohoLeadResults, "', '") . "')";
			array_push($optionalSearchClauses, $zohoLeadString);
		}

		if (count($constantContactResults) > 0 && !$zohoContactRequired) {
			$constantContactString = "`constantContactId` IN ('" . implode($constantContactResults, "', '") . "')";
			array_push($optionalSearchClauses, $constantContactString);
		}


		$searchString = ''; // Build search string
		if (count($requiredSearchClauses) > 0) {
			// If there are any required clauses, use that
			$searchString .= implode($requiredSearchClauses, " AND ");
			// examples:
			// `email` LIKE 'foo%' AND `email` LIKE '%bar' AND `zohoContactId` IN ('1', '2', '3')
			// `email` LIKE 'foo%'
			// `zohoContactId` IN ('1', '2', '3')
		}
		if (count($optionalSearchClauses) > 0) {
			if ($searchString) {
				$searchString .= " AND ";
				// example: `email` LIKE 'foo%' AND
			}
			$searchString .= "(" . implode($optionalSearchClauses, " OR ") . ")";
			// examples:
			// (`zohoLeadId` IN ('1', '2', '3') OR `constantContactId` IN ('4', '5', '6'))
			// `email` LIKE 'foo%' AND (`zohoLeadId` IN ('2', '7', '69') OR `constantContactId IN ('5'))
		}

		$consolidatedContacts = array();
		if ($searchString) {
			$db = new Database;
			$dbTable = ConsolidatedContact::getDbTable();

			$sql = "SELECT * FROM `$dbTable` WHERE $searchString ORDER BY `id` ASC;";
			if ($metadata !== null) {
				$metadata->consolidatedContactSearchQuery = $sql;
			}
			$results = $db->db_query($sql, "select-multiple");

			foreach ($results as $result) {
				array_push($consolidatedContacts, $result);
			}
		}
		else {
			$db = new Database;
			$dbTable = ConsolidatedContact::getDbTable();
			$sql = "SELECT * FROM `$dbTable` ORDER BY `id` ASC;";
			if ($metadata !== null) {
				$metadata->consolidatedContactSearchQuery = $sql;
			}
			$results = $db->db_query($sql, 'select-multiple');

			foreach ($results as $result) {
				array_push($consolidatedContacts, $result);
			}
		}
		return $consolidatedContacts;
	}

	private static function performZohoAccountSearch($searchClauses, &$metadata=null) {
		$db = new Database;
		$dbTable = Account::getDbTable();

		$searchString = implode($searchClauses, " AND ");

		$sql = "SELECT `id` FROM `$dbTable` WHERE $searchString;";
		if ($metadata !== null) {
			$metadata->zohoAccountSearchQuery = $sql;
		}
		$results = $db->db_query($sql, 'select-multiple');

		$idList = array();
		foreach ($results as $result) {
			array_push($idList, $result['id']);
		}
		return $idList;
	}

	private static function performZohoLeadSearch($searchClauses, &$metadata=null) {
		$db = new Database;
		$dbTable = Lead::getDbTable();

		$searchString = implode($searchClauses, " AND ");

		$sql = "SELECT `id` FROM `$dbTable` WHERE $searchString;";
		if ($metadata !== null) {
			$metadata->zohoLeadSearchQuery = $sql;
		}
		$results = $db->db_query($sql, 'select-multiple');

		$idList = array();
		foreach ($results as $result) {
			array_push($idList, $result['id']);
		}
		return $idList;
	}

	private static function performZohoContactSearch($searchClauses, &$metadata=null) {
		$db = new Database;
		$dbTable = Contact::getDbTable();

		$searchString = implode($searchClauses, " AND ");

		$sql = "SELECT `id` FROM `$dbTable` WHERE $searchString;";
		if ($metadata !== null) {
			$metadata->zohoContactSearchQuery = $sql;
		}
		$results = $db->db_query($sql, 'select-multiple');

		$idList = array();
		foreach ($results as $result) {
			array_push($idList, $result['id']);
		}
		return $idList;
	}

	private static function performConstantContactSearch($searchClauses, &$metadata=null) {
		$db = new Database;
		$dbTable = ConstantContact::getDbTable();

		$searchString = implode($searchClauses, " AND ");

		$sql = "SELECT `id` FROM `$dbTable` WHERE $searchString;";
		if ($metadata !== null) {
			$metadata->constantContactSearchQuery = $sql;
		}
		$results = $db->db_query($sql, 'select-multiple');

		$idList = array();
		foreach ($results as $result) {
			array_push($idList, $result['id']);
		}
		return $idList;
	}

}

?>
