<?php

class EmailListController {
	public static function renderPage() {
		$admin = new Admin;
		$title = "Email List";
		$template = file_get_contents(HTML_FOLDER . "templates/emailList/emailList.html");

		$stateOptionArray = State::getOptionArrayForAllStates();
		$regionOptionArray = Region::getOptionArrayForAllRegions();
		$allOption = "<option value='0'>All</option>";

		$regionOptions = $allOption . implode("\n", $regionOptionArray);
		$allStateOptions = $allOption . implode("\n", $stateOptionArray);

		$contactModal = file_get_contents(HTML_FOLDER . "templates/emailList/contactModal.html");

		$scripts = '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/emailList/contactModal.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/emailList/emailList.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/emailList/datasets/ConsolidatedContact.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/emailList/datasets/ConstantContact.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/generic/datasets/Account.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/generic/datasets/State.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/generic/datasets/Region.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/generic/datasets/ZohoLead.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/generic/datasets/ZohoContact.js" type="text/javascript"></script>';
		$templateElements = array(
			'SCRIPTS' => $scripts,
			'STATES' => $allStateOptions,
			'REGIONS' => $regionOptions,
			'CONTACT_MODAL' => $contactModal,
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function getContactsList($searchParameters=null) {
		if ($searchParameters === null) {
			$searchParameters = new stdClass;
		}
		if (!$searchParameters->limit || $searchParameters->limit <= 0) {
			$searchParameters->limit = 100;
		}
		elseif ($searchParameters->limit > 250) {
			$searchParameters->limit = 250;
		}

		if (!$searchParameters->offset) {
			$searchParameters->offset = 0;
		}

		$searchParameters->orderBy = 'emailAddress';
		$searchParameters->sequence = 'ASC';
	}

	public static function exportList($searchParams) {
		// Set per-query limit
		$limit = 10000;
		// Get the total count of matches
		$totalCount = EmailListService::getCountWithSearchParams($searchParams);
		// Get the total number of pages from the limit
		$totalPages = ceil($totalCount / $limit);
		// Build the head row for the first pass on the array
		$headRow = array(
			"Email Address",
			"Email Opt Out",
			"Zoho Lead: Salutation",
			"Zoho Lead: First Name",
			"Zoho Lead: Last Name",
			"Zoho Lead: Phone Number",
			"Zoho Lead: Fax",
			"Zoho Lead: Organization",
			"Zoho Lead: Title",
			"Zoho Lead: Lead Source",
			"Zoho Lead: Address Street",
			"Zoho Lead: Address City",
			"Zoho Lead: Address Code",
			"Zoho Lead: Address State",
			"Zoho Contact: Salutation",
			"Zoho Contact: First Name",
			"Zoho Contact: Last Name",
			"Zoho Contact: Phone Number",
			"Zoho Contact: Fax",
			"Zoho Contact: Organization",
			"Zoho Contact: Title",
			"Zoho Contact: Lead Source",
			"Zoho Contact: Address Street",
			"Zoho Contact: Address City",
			"Zoho Contact: Address Code",
			"Zoho Contact: Address State",
			"Constant Contact: First Name",
			"Constant Contact: Last Name",
			"Constant Contact: Organization",
			"Constant Contact: Title",
			"Constant Contact: Tags",
			"Constant Contact: Email Lists",
			"Constant Contact: Notes",
			"Constant Contact: Lead Source",
		);
		$data = array();
		array_push($data, $headRow);

		// Instantiate the CSV with fresh datetimes
		$currentDate = new DateTime('now', new DateTimeZone('America/Los_Angeles'));
		$timestamp = $currentDate->format('YmdHis');
		$fileName = "emailListExport-$timestamp.csv";
		$csvPaths = CsvBuilder::buildCsv($data, $fileName);
		unset($data[0]);

		$totalProcessed = 0;

		for ($i = 0; $i < $totalPages; $i++) {
			// Set the page to be equal to $i
			$page = $i;

			// Fetch the list of contacts, with the assigned limit and page
			$offset = $limit * $page;
			$metadata = new stdClass;
			$contacts = EmailListService::fetchList($searchParams, $metadata, $limit, $offset);

			unset($metadata);

			// Iterate over the contacts
			foreach ($contacts as $contact) {
				// Get csv row from the contact
				$csvRow = $contact->getCsvRow();
				// push the row into data array
				array_push($data, $csvRow);
				unset($contact);
				$totalProcessed++;
			}
			// When finished, purge the contacts from memory
			unset($contacts);

			// Add the data rows to csv
			CsvBuilder::addToCsv($data, $fileName);

			// Clean up by purging data array from memory to free up space
			unset($data);
			$data = array();
		}

		return $csvPaths->relative;
	}

	public static function fetchList($searchParams, $limit=1000, $page=0) {
		$metadata = new stdClass;
		$offset = $limit * $page;
		$emailListContacts = EmailListService::fetchList($searchParams, $metadata, $limit, $offset);

		$resultObj = new stdClass;
		$resultObj->metadata = $metadata;

		// $resultObj->baseConsolidatedContacts = $consolidatedContacts;
		$resultObj->processedContacts = array();
		$resultObj->totalCount = EmailListService::getCountWithSearchParams($searchParams);

		$processedCount = 0;
		foreach($emailListContacts as $contact) {
			if ($processedCount >= $limit) {
				break;
			}
			// $consolidatedContact = new ConsolidatedContact($consolidatedContactData, true);
			array_push($resultObj->processedContacts, $contact->jsonify());
			$processedCount++;
		}

		return $resultObj;

		// $db = new Database;

		// $dbTable = ConsolidatedContact::getDbTable();
		// $sql = "SELECT * FROM `$dbTable` WHERE zohoLeadId IS NOT NULL AND zohoContactId IS NOT NULL AND constantContactId IS NOT NULL ORDER BY emailAddress ASC LIMIT $limit OFFSET $offset;";
		// $results = $db->db_query($sql, 'select-multiple');
		// $contacts = array();
		// foreach ($results as $result) {
		// 	$contact = new ConsolidatedContact($result, true);
		// 	// echo print_r($contact);
		// 	array_push($contacts, $contact->jsonify());
		// }
		// return $contacts;
	}

	public static function updateEmailList($debug=false, $browser=false) {
		self::updateAccounts($debug, $browser);
		self::updateZohoLeads($debug, $browser);
		self::updateZohoContacts($debug, $browser);
		self::updateConstantContact($debug, $browser);
	}

	public static function updateConstantContact($debug=false, $browser=false) {
		require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");
		EmailListService::updateConstantContact($debug, $browser);
	}

	public static function updateAccounts($debug=false, $browser=false) {
		EmailListService::updateAccounts($debug, $browser);
	}

	public static function updateZohoContacts($debug=false, $browser=false) {
		EmailListService::updateZohoContacts($debug, $browser);
	}

	public static function updateZohoLeads($debug=false, $browser=false) {
		EmailListService::updateZohoLeads($debug, $browser);
	}

	public static function getDataByEmailAddress($emailAddress) {
		$contact = EmailListService::getContactByEmailAddress($emailAddress);
		if ($contact) {
			echo "<pre>";
			print_r($contact);
			echo "</pre>";
		}
		else {
			echo "<p>No contact found with email $emailAddress</p>";
		}
	}

	public static function getContactById($id) {
		$contact = EmailListService::getContactById($id);
		$contact->conformSourcesExist();
		if ($contact) {
			echo "<pre>";
			print_r($contact);
			print_r($contact->jsonify());
			echo "</pre>";

			$contact->save();
		}
		else {
			echo "<p>No contact found with ID $id</p>";
		}
	}

	public static function emailListImport() {
		EmailListService::emailListImport();
	}

	public static function constantContactCsvImport() {
		EmailListService::constantContactCsvImport();
	}

	public static function contactsCsvImport() {
		EmailListService::contactsCsvImport();
	}

	public static function leadsCsvImport() {
		EmailListService::leadsCsvImport();
	}

	public static function accountCsvImport() {
		EmailListService::accountCsvImport();
	}

	public static function consolidateContacts() {
		EmailListService::consolidateContacts();
	}
}

?>
