<?php


class EmailListContact {
	private static $dbTable = 'email_master_list';

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'emailAddress' => array('type' => 'string', 'mutable' => false),
		'emailOptOut' => array('type' => 'boolean', 'mutable' => true),
		'zl_zohoId' => array('type' => 'string', 'mutable' => true),
		'zl_salutation' => array('type' => 'string', 'mutable' => true),
		'zl_firstName' => array('type' => 'string', 'mutable' => true),
		'zl_lastName' => array('type' => 'string', 'mutable' => true),
		'zl_phoneNumber' => array('type' => 'string', 'mutable' => true),
		'zl_fax' => array('type' => 'string', 'mutable' => true),
		'zl_organization' => array('type' => 'string', 'mutable' => true),
		'zl_title' => array('type' => 'string', 'mutable' => true),
		'zl_leadSource' => array('type' => 'string', 'mutable' => true),
		'zl_addressStreet' => array('type' => 'string', 'mutable' => true),
		'zl_addressCity' => array('type' => 'string', 'mutable' => true),
		'zl_addressCode' => array('type' => 'string', 'mutable' => true),
		'zl_addressState' => array('type' => 'string', 'mutable' => true),
		'zl_stateId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'State'),
		'zc_zohoId' => array('type' => 'string', 'mutable' => true),
		'zc_salutation' => array('type' => 'string', 'mutable' => true),
		'zc_firstName' => array('type' => 'string', 'mutable' => true),
		'zc_lastName' => array('type' => 'string', 'mutable' => true),
		'zc_phoneNumber' => array('type' => 'string', 'mutable' => true),
		'zc_fax' => array('type' => 'string', 'mutable' => true),
		'zc_title' => array('type' => 'string', 'mutable' => true),
		'zc_leadSource' => array('type' => 'string', 'mutable' => true),
		'zc_addressStreet' => array('type' => 'string', 'mutable' => true),
		'zc_addressCity' => array('type' => 'string', 'mutable' => true),
		'zc_addressCode' => array('type' => 'string', 'mutable' => true),
		'zc_addressState' => array('type' => 'string', 'mutable' => true),
		'zc_stateId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'State'),
		'zc_accountId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'Account'),
		'cc_firstName' => array('type' => 'string', 'mutable' => true),
		'cc_lastName' => array('type' => 'string', 'mutable' => true),
		'cc_organization' => array('type' => 'string', 'mutable' => true),
		'cc_title' => array('type' => 'string', 'mutable' => true),
		'cc_tags' => array('type' => 'string', 'mutable' => true),
		'cc_emailLists' => array('type' => 'string', 'mutable' => true),
		'cc_notes' => array('type' => 'string', 'mutable' => true),
		'cc_leadSource' => array('type' => 'string', 'mutable' => true),
		'zohoLeadExists' => array('type' => 'boolean', 'mutable' => true),
		'zohoContactExists' => array('type' => 'boolean', 'mutable' => true),
		'constantContactExists' => array('type' => 'boolean', 'mutable' => true),
	);

	private $id;
	private $emailAddress;
	private $emailOptOut;

	private $zohoLead;
	private $zohoContact;
	private $constantContact;

	private $zohoLeadExists;
	private $zohoContactExists;
	private $constantContactExists;

	public function __construct($data, $fromDb=false) {
		if ($fromDb) {
			$constructorData = (object)self::createConstructorData($data);;
		}
		else {
			if (is_array($data)) {
				$constructorData = (object)$data;
			}
			else {
				$constructorData = $data;
			}
		}

		if ($constructorData->id) {
			$this->id = $constructorData->id;
		}

		if ($constructorData->emailAddress) {
			$this->emailAddress = $constructorData->emailAddress;
		}

		if ($constructorData->emailOptOut !== null) {
			$this->emailOptOut = (bool)$constructorData->emailOptOut;
		}

		if ($constructorData->zohoLead) {
			if ($constructorData->zohoLead instanceof Lead) {
				$this->zohoLead = $constructorData->zohoLead;
			}
			else {
				$leadData = $constructorData->zohoLead;
				$this->zohoLead = new Lead($leadData);
			}
		}

		if ($constructorData->zohoContact) {
			if ($constructorData->zohoContact instanceof Contact) {
				$this->zohoContact = $constructorData->zohoContact;
			}
			else {
				$leadData = $constructorData->zohoContact;
				$this->zohoContact = new Contact($leadData);
			}
		}

		if ($constructorData->constantContact) {
			if ($constructorData->constantContact instanceof ConstantContact) {
				$this->constantContact = $constructorData->constantContact;
			}
			else {
				$leadData = $constructorData->constantContact;
				$this->constantContact = new ConstantContact($leadData);
			}
		}
		if ($fromDb) {
			$this->zohoLeadExists = $constructorData->zohoLeadExists;
			$this->zohoContactExists = $constructorData->zohoContactExists;
			$this->constantContactExists = $constructorData->constantContactExists;
		}
		else {
			$this->conformZohoLeadExists();
			$this->conformZohoContactExists();
			$this->conformConstantContactExists();
		}

		$this->conformEmailOptOut();

		return $this;
	}

	public function getId() {
		return $this->id;
	}
	public function setId($id) {
		$this->id = $id;
	}
	/**
	 * Populates ID from database, using email as key. Returns true if successful, false if not.
	 */
	public function populateId() {
		if ($this->getId()) {
			return true;
		}
		$db = new Database;

		$dbTable = self::getDbTable();
		$emailAddress = mysql_real_escape_string($this->getEmailAddress());
		if (!$emailAddress) {
			return false;
		}

		$sql = "SELECT `id` FROM `$dbTable` WHERE `emailAddress`='$emailAddress' LIMIT 1;";

		$result = $db->db_query($sql, 'select-single');

		if ($result['id']) {
			$id = $result['id'];
			$this->setId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoLead() {
		return $this->zohoLead;
	}
	public function setZohoLead($zohoLead) {
		$this->zohoLead = $zohoLead;
		$this->conformZohoLeadExists();
		$this->conformEmailOptOut();
	}

	public function getZohoContact() {
		return $this->zohoContact;
	}
	public function setZohoContact($zohoContact) {
		$this->zohoContact = $zohoContact;
		$this->conformZohoContactExists();
		$this->conformEmailOptOut();
	}

	public function getConstantContact() {
		return $this->constantContact;
	}
	public function setConstantContact($constantContact) {
		$this->constantContact = $constantContact;
		$this->conformConstantContactExists();
	}

	public function getEmailOptOut() {
		return $this->emailOptOut;
	}
	public function setEmailOptOut($emailOptOut) {
		$this->emailOptOut = $emailOptOut;
	}
	public function conformEmailOptOut() {
		if ($this->getZohoLead()) {
			if ($this->getZohoLead()->getEmailOptOut() == true) {
				$this->setEmailOptOut(true);
			}
		}
		if ($this->getZohoContact()) {
			if ($this->getZohoContact()->getEmailOptOut() == true) {
				$this->setEmailOptOut(true);
			}
		}
	}

	public function getEmailAddress() {
		return $this->emailAddress;
	}
	public function setEmailAddress($emailAddress) {
		$this->emailAddress = $emailAddress;
	}

	public function getZohoLeadExists() {
		return $this->zohoLeadExists;
	}
	public function setZohoLeadExists() {
		$this->zohoLeadExists = true;
	}
	public function conformZohoLeadExists() {
		if ($this->getZohoLead()) {
			$this->zohoLeadExists = true;
		}
		else {
			$this->zohoLeadExists = false;
		}
	}

	public function getZohoContactExists() {
		return $this->zohoContactExists;
	}
	public function setZohoContactExists() {
		$this->zohoContactExists = true;
	}
	public function conformZohoContactExists() {
		if ($this->getZohoContact()) {
			$this->zohoContactExists = true;
		}
		else {
			$this->zohoContactExists = false;
		}
	}

	public function getConstantContactExists() {
		return $this->constantContactExists;
	}
	public function setConstantContactExists() {
		$this->constantContactExists = true;
	}
	public function conformConstantContactExists() {
		if ($this->getConstantContact()) {
			$this->constantContactExists = true;
		}
		else {
			$this->constantContactExists = false;
		}
	}

	public function conformSourcesExist() {
		$this->conformZohoLeadExists();
		$this->conformZohoContactExists();
		$this->conformConstantContactExists();
	}

	public function getZohoLeadId() {
		if ($this->getZohoLead()) {
			return $this->getZohoLead()->getId();
		}
		else {
			return null;
		}
	}

	public function getZohoContactId() {
		if ($this->getZohoContact()) {
			return $this->getZohoContact()->getId();
		}
		else {
			return null;
		}
	}

	public function getConstantContactId() {
		if ($this->getConstantContact()) {
			return $this->getConstantContact()->getId();
		}
		else {
			return null;
		}
	}

	public function save($forceInsert=false) {
		if ($this->populateId()) {
			return $this->update();
		}
		else {
			return $this->insert();
		}
	}

	private function insert() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$dbFields = self::getDbFields();

		$insertFields = array();
		$insertValues = array();
		$duplicateKeyUpdateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			if ($fieldName == "id") {
				continue;
			}
			$dataType = $fieldParams['type'];
			$isMutable = $fieldParams['mutable'];

			if (strpos($fieldName, '_') == 2) {
				$fieldNamePrefix = substr($fieldName, 0, 3);
				$fieldNameReal = substr($fieldName, 3);
				$getterName = "get" . ucfirst($fieldNameReal);
				if ($fieldNamePrefix == "zl_") {
					if ($this->getZohoLead()) {
						$data = $this->getZohoLead()->$getterName();
						if ($data || $data === false) {
							if ($dataType == 'string') {
								$data = mysql_real_escape_string($data);
							}
							array_push($insertFields, $fieldName);
							array_push($insertValues, $data);

							if ($isMutable) {
								$duplicateKeyClause = "`$fieldName`='$data'";
								array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);
							}
						}
					}
				}
				elseif ($fieldNamePrefix == "zc_") {
					if ($this->getZohoContact()) {
						$data = $this->getZohoContact()->$getterName();
						if ($data || $data === false) {
							if ($dataType == 'string') {
								$data = mysql_real_escape_string($data);
							}
							array_push($insertFields, $fieldName);
							array_push($insertValues, $data);

							if ($isMutable) {
								$duplicateKeyClause = "`$fieldName`='$data'";
								array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);
							}
						}
					}
				}
				elseif ($fieldNamePrefix == "cc_") {
					if ($this->getConstantContact()) {
						$data = $this->getConstantContact()->$getterName();
						if ($data || $data === false) {
							if ($dataType == 'string') {
								$data = mysql_real_escape_string($data);
							}
							array_push($insertFields, $fieldName);
							array_push($insertValues, $data);

							if ($isMutable) {
								$duplicateKeyClause = "`$fieldName`='$data'";
								array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);
							}
						}
					}
				}
			}
			else {
				$getterName = "get" . ucfirst($fieldName);
				$data = $this->$getterName();
				if ($dataType == 'string') {
					$data = mysql_real_escape_string($data);
				}
				array_push($insertFields, $fieldName);
				array_push($insertValues, $data);

				if ($isMutable) {
					$duplicateKeyClause = "`$fieldName`='$data'";
					array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);
				}
			}
		}

		$fieldsString = implode("`, `", $insertFields);
		$valuesString = implode("', '", $insertValues);
		$duplicateKeyString = implode(", ", $duplicateKeyUpdateClauses);

		$sql = "INSERT INTO `$dbTable`(`$fieldsString`) VALUES ('$valuesString') ON DUPLICATE KEY UPDATE $duplicateKeyString;";

		return $db->db_query($sql, 'insert', true);
	}

	private function update() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$id = $this->getId();

		$existingContact = self::getById($id);

		$dbFields = self::getDbFields();
		$updateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$isMutable = $fieldParams['mutable'];
			if (!$isMutable) {
				continue;
			}
			$dataType = $fieldParams['type'];

			$changedData = false;

			if (strpos($fieldName, '_') == 2) {
				$fieldNamePrefix = substr($fieldName, 0, 3);
				$fieldNameReal = substr($fieldName, 3);
				$getterName = "get" . ucfirst($fieldNameReal);
				if ($fieldNamePrefix == "zl_") {
					if ($this->getZohoLead()) {
						if ($existingContact->getZohoLead()) {
							$existingData = $existingContact->getZohoLead()->$getterName();

							$newData = $this->getZohoLead()->$getterName();

							if ($newData != $existingData) {
								$changedData = true;

								if (!$newData && $newData !== false) {
									$updateClase = "`$fieldName`=NULL";
								}
								else {
									if ($dataType == 'string') {
										$newData = mysql_real_escape_string($newData);
									}
									elseif ($dataType == "boolean") {
										$newData = $newData == true ? '1' : '0';
									}

									$updateClause = "`$fieldName`='$newData'";
									array_push($updateClauses, $updateClause);
								}
							}
						}
						else {
							$changedData = true;
							$newData = $this->getZohoLead()->$getterName();

							if (!$newData && $newData !== false) {
								$updateClase = "`$fieldName`=NULL";
							}
							else {
								if ($dataType == 'string') {
									$newData = mysql_real_escape_string($newData);
								}
								elseif ($dataType == "boolean") {
									$newData = $newData == true ? '1' : '0';
								}

								$updateClause = "`$fieldName`='$newData'";
								array_push($updateClauses, $updateClause);
							}
						}
					}
				}
				elseif ($fieldNamePrefix == "zc_") {
					if ($this->getZohoContact()) {
						if ($existingContact->getZohoContact()) {
							$existingData = $existingContact->getZohoContact()->$getterName();

							$newData = $this->getZohoContact()->$getterName();

							if ($newData != $existingData) {
								$changedData = true;

								if (!$newData && $newData !== false) {
									$updateClase = "`$fieldName`=NULL";
								}
								else {
									if ($dataType == 'string') {
										$newData = mysql_real_escape_string($newData);
									}
									elseif ($dataType == "boolean") {
										$newData = $newData == true ? '1' : '0';
									}

									$updateClause = "`$fieldName`='$newData'";
									array_push($updateClauses, $updateClause);
								}
							}
						}
						else {
							$changedData = true;
							$newData = $this->getZohoContact()->$getterName();

							if (!$newData && $newData !== false) {
								$updateClase = "`$fieldName`=NULL";
							}
							else {
								if ($dataType == 'string') {
									$newData = mysql_real_escape_string($newData);
								}
								elseif ($dataType == "boolean") {
									$newData = $newData == true ? '1' : '0';
								}

								$updateClause = "`$fieldName`='$newData'";
								array_push($updateClauses, $updateClause);
							}
						}
					}
				}
				elseif ($fieldNamePrefix == "cc_") {
					if ($this->getConstantContact()) {
						if ($existingContact->getConstantContact()) {
							$existingData = $existingContact->getConstantContact()->$getterName();

							$newData = $this->getConstantContact()->$getterName();

							if ($newData != $existingData) {
								$changedData = true;

								if (!$newData && $newData !== false) {
									$updateClase = "`$fieldName`=NULL";
								}
								else {
									if ($dataType == 'string') {
										$newData = mysql_real_escape_string($newData);
									}
									elseif ($dataType == "boolean") {
										$newData = $newData == true ? '1' : '0';
									}

									$updateClause = "`$fieldName`='$newData'";
									array_push($updateClauses, $updateClause);
								}
							}
						}
						else {
							$changedData = true;
							$newData = $this->getConstantContact()->$getterName();

							if (!$newData && $newData !== false) {
								$updateClase = "`$fieldName`=NULL";
							}
							else {
								if ($dataType == 'string') {
									$newData = mysql_real_escape_string($newData);
								}
								elseif ($dataType == "boolean") {
									$newData = $newData == true ? '1' : '0';
								}

								$updateClause = "`$fieldName`='$newData'";
								array_push($updateClauses, $updateClause);
							}
						}
					}
				}
			}
			else {
				$getterName = "get" . ucfirst($fieldName);
				$existingData = $existingContact->$getterName();
				$newData = $this->$getterName();

				if ($newData != $existingData) {
					if (!$newData && $newData !== false) {
						$updateClase = "`$fieldName`=NULL";
					}
					else {
						if ($dataType == 'string') {
							$newData = mysql_real_escape_string($newData);
						}
						elseif ($dataType == "boolean") {
							$newData = $newData == true ? '1' : '0';
						}

						$updateClause = "`$fieldName`='$newData'";
						array_push($updateClauses, $updateClause);
					}
				}
			}
		}
		$updateClausesString = implode(", ", $updateClauses);

		if (strlen($updateClausesString) > 1) {
			$sql = "UPDATE `$dbTable` SET $updateClausesString WHERE `id`='$id';";


			return $db->db_query($sql, 'insert', true);
		}
		else {
			return false;
		}
	}

	private function updateOld() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$id = $this->getId();

		$dbFields = self::getDbFields();
		$updateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];
			$isMutable = $fieldParams['mutable'];
			if ($isMutable) {
				$data = $this->$getterName();


				if ($dataType == "foreignKey") {
					if ($data) {
						$updateClause = "`$fieldName`='$data'";

						array_push($updateClauses, $updateClause);

					}
				}
				elseif ($data !== null) {
					if ($dataType == 'bool') {
						$data = $data ? '1' : '0';
					}
					elseif ($dataType == 'encrypted') {
						$data = EncryptionController::encryptString(trim($data));
					}
					elseif ($dataType == "string") {
						$data = mysql_real_escape_string(trim($data));
					}

					$updateClause = "`$fieldName`='$data'";

					array_push($updateClauses, $updateClause);
				}

			}
		}
		$updateClausesString = implode(", ", $updateClauses);

		$sql = "UPDATE `$dbTable` SET $updateClausesString WHERE `id`='$id';";


		return $db->db_query($sql, 'insert', true);
	}

	public function jsonify() {
		$dbFields = self::getDbFields();


		$jsonData = new stdClass;
		$jsonData->id = $this->getId();
		$jsonData->emailOptOut = $this->getEmailOptOut();
		$jsonData->emailAddress = $this->getEmailAddress();
		$jsonData->zohoLeadExists = $this->getZohoLeadExists();
		$jsonData->zohoContactExists = $this->getZohoContactExists();
		$jsonData->constantContactExists = $this->getConstantContactExists();
		if ($this->getZohoLead() !== null) {
			$jsonData->zohoLead = $this->getZohoLead()->jsonify();
		}
		if ($this->getZohoContact() !== null) {
			$jsonData->zohoContact = $this->getZohoContact()->jsonify();
		}
		if ($this->getConstantContact() !== null) {
			$jsonData->constantContact = $this->getConstantContact()->jsonify();
		}


		return $jsonData;
	}

	public function getCsvRow() {
		$row = array(
			$this->getEmailAddress(),
			$this->getEmailOptOut(),
		);
		if ($this->getZohoLead()) {
			array_push($row, $this->getZohoLead()->getSalutation());
			array_push($row, $this->getZohoLead()->getFirstName());
			array_push($row, $this->getZohoLead()->getLastName());
			array_push($row, $this->getZohoLead()->getPhoneNumber());
			array_push($row, $this->getZohoLead()->getFax());
			array_push($row, $this->getZohoLead()->getOrganization());
			array_push($row, $this->getZohoLead()->getTitle());
			array_push($row, $this->getZohoLead()->getLeadSource());
			array_push($row, $this->getZohoLead()->getAddressStreet());
			array_push($row, $this->getZohoLead()->getAddressCity());
			array_push($row, $this->getZohoLead()->getAddressCode());
			array_push($row, $this->getZohoLead()->getAddressState());
		}
		else {
			for($i = 0; $i < 12; $i++) {
				array_push($row, '');
			}
		}
		if ($this->getZohoContact()) {
			array_push($row, $this->getZohoContact()->getSalutation());
			array_push($row, $this->getZohoContact()->getFirstName());
			array_push($row, $this->getZohoContact()->getLastName());
			array_push($row, $this->getZohoContact()->getPhoneNumber());
			array_push($row, $this->getZohoContact()->getFax());
			array_push($row, $this->getZohoContact()->getOrganization());
			array_push($row, $this->getZohoContact()->getTitle());
			array_push($row, $this->getZohoContact()->getLeadSource());
			array_push($row, $this->getZohoContact()->getAddressStreet());
			array_push($row, $this->getZohoContact()->getAddressCity());
			array_push($row, $this->getZohoContact()->getAddressCode());
			array_push($row, $this->getZohoContact()->getAddressState());
		}
		else {
			for($i = 0; $i < 12; $i++) {
				array_push($row, '');
			}
		}
		if ($this->getConstantContact()) {
			array_push($row, $this->getConstantContact()->getFirstName());
			array_push($row, $this->getConstantContact()->getLastName());
			array_push($row, $this->getConstantContact()->getOrganization());
			array_push($row, $this->getConstantContact()->getTitle());
			array_push($row, $this->getConstantContact()->getTags());
			array_push($row, $this->getConstantContact()->getEmailLists());
			array_push($row, $this->getConstantContact()->getNotes());
			array_push($row, $this->getConstantContact()->getLeadSource());
		}
		else {
			for($i = 0; $i < 8; $i++) {
				array_push($row, '');
			}
		}
		return $row;
	}

	private static function createConstructorData($dbData) {
		$constructorData = array();
		if ($dbData['zohoLeadExists']) {
			$constructorData['zohoLead'] = array(
				'email' => $dbData['emailAddress']
			);
		}
		if ($dbData['zohoContactExists']) {
			$constructorData['zohoContact'] = array(
				'email' => $dbData['emailAddress']
			);
		}
		if ($dbData['constantContactExists']) {
			$constructorData['constantContact'] = array(
				'email' => $dbData['emailAddress']
			);
		}
		foreach ($dbData as $key => $value) {
			if ($value == null) {
				continue;
			}
			$keyFirstThree = substr($key, 0, 3);
			if ($keyFirstThree == "zl_") {
				$keyReal = substr($key, 3);
				if (!is_array($constructorData['zohoLead'])) {
					$constructorData['zohoLead'] == array();
				}
				$constructorData['zohoLead'][$keyReal] = $value;
			}
			elseif ($keyFirstThree == "zc_") {
				$keyReal = substr($key, 3);
				if (!is_array($constructorData['zohoContact'])) {
					$constructorData['zohoContact'] == array();
				}
				$constructorData['zohoContact'][$keyReal] = $value;

			}
			elseif ($keyFirstThree == "cc_") {
				$keyReal = substr($key, 3);
				if (!is_array($constructorData['constantContact'])) {
					$constructorData['constantContact'] == array();
				}
				$constructorData['constantContact'][$keyReal] = $value;
			}
			elseif (substr($key, 0, 8) == 'account_') {
				$keyReal = substr($key, 8);
				if (!is_array($constructorData['zohoContact'])) {
					$constructorData['zohoContact'] == array();
				}
				if (!is_array($constructorData['zohoContact']['accountData'])) {
					$constructorData['zohoContact']['accountData'] == array();
				}
				$constructorData['zohoContact']['accountData'][$keyReal] = $value;
			}
			else {
				$constructorData[$key] = $value;
			}
		}
		return $constructorData;
	}

	public static function getById($id) {
		$db = new Database;


		$dbTable = self::getDbTable();

		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			return new EmailListContact($result, true);
		}
	}

	public static function getByEmailAddress($emailAddress) {
		$db = new Database;

		$dbTable = self::getDbTable();
		$emailAddress = mysql_real_escape_string($emailAddress);

		$sql = "SELECT * FROM `$dbTable` WHERE `emailAddress`='$emailAddress';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			return new EmailListContact($result, true);
		}
		else {
			return null;
		}
	}

	public static function getEmailAddressById($id) {
		$db = new Database;

		$dbTable = self::getDbTable();

		$sql = "SELECT `emailAddress` FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single');

		if ($result['emailAddress']) {
			return $result['emailAddress'];
		}
	}


	private static function getDbFields() {
		return self::$dbFields;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}
}
?>
