<?php

class ConstantContact {
	private static $dbTable = 'constant_contacts';

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'email' => array('type' => 'string', 'mutable' => true),
		'firstName' => array('type' => 'string', 'mutable' => true),
		'lastName' => array('type' => 'string', 'mutable' => true),
		'organization' => array('type' => 'string', 'mutable' => true),
		'title' => array('type' => 'string', 'mutable' => true),
		'tags' => array('type' => 'string', 'mutable' => true),
		'emailLists' => array('type' => 'string', 'mutable' => true),
		'notes' => array('type' => 'string', 'mutable' => true),
		'leadSource' => array('type' => 'string', 'mutable' => true),
	);

	private $id;

	private $email = '';
	private $firstName = '';
	private $lastName = '';
	private $organization = '';
	private $title = '';

	private $tags = '';
	private $emailLists = '';
	private $notes = '';

	private $leadSource = '';

	public function __construct($data, $populate=false, $fromDb=false) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		if ($data->fromDb) {
			$fromDb = true;
		}

		if ($fromDb) {
			$dbFields = self::getDbFields();

			foreach ($dbFields as $fieldName => $fieldParams) {
				if ($data->$fieldName !== null) {
					$dataStr = $data->$fieldName;
					$dataType = $fieldParams['type'];
					$final = null;
					if ($dataType == 'string') {
						$final = trim($dataStr);
					}
					else {
						$final = $dataStr;
					}
					if ($final !== null) {
						$this->$fieldName = $final;
					}
				}
			}
		}

		if ($data->id) {
			$this->id = $data->id;
		}

		if ($data->email) {
			$this->email = $data->email;
		}

		if ($data->firstName) {
			$this->firstName = $data->firstName;
		}

		if ($data->lastName) {
			$this->lastName = $data->lastName;
		}

		if ($data->organization) {
			$this->organization = $data->organization;
		}

		if ($data->title) {
			$this->title = $data->title;
		}

		if ($data->tags) {
			$this->tags = $data->tags;
		}

		if ($data->emailLists) {
			$this->emailLists = $data->emailLists;
		}

		if ($data->notes) {
			$this->notes = $data->notes;
		}

		if ($data->leadSource) {
			$this->leadSource = $data->leadSource;
		}
	}

	/* Begin setters/getters */

	public function getId() {
		return $this->id;
	}
	public function setId($id) {
		$this->id = $id;
	}
	public function populateId() {
		if ($this->getId()) {
			return true;
		}
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = self::getDbTable();
		$email = mysql_real_escape_string($this->getEmail());

		$sql = "SELECT `id` FROM `$dbTable` WHERE `email`='$email' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function getFirstName() {
		return $this->firstName;
	}
	public function setFirstName($firstName) {
		$this->firstName = $firstName;
	}

	public function getLastName() {
		return $this->lastName;
	}
	public function setLastName($lastName) {
		$this->lastName = $lastName;
	}

	public function getEmail() {
		return $this->email;
	}
	public function setEmail($email) {
		$this->email = $email;
	}

	public function getOrganization() {
		return $this->organization;
	}
	public function setOrganization($organization) {
		$this->organization = $organization;
	}

	public function getTitle() {
		return $this->title;
	}
	public function setTitle($title) {
		$this->title = $title;
	}

	public function getTags() {
		return $this->tags;
	}
	public function setTags($tags) {
		$this->tags = $tags;
	}

	public function getEmailLists() {
		return $this->emailLists;
	}
	public function setEmailLists($emailLists) {
		$this->emailLists = $emailLists;
	}

	public function getNotes() {
		return $this->notes;
	}
	public function setNotes($notes) {
		$this->notes = $notes;
	}

	public function getLeadSource() {
		return $this->leadSource;
	}
	public function setLeadSource($leadSource) {
		$this->leadSource = $leadSource;
	}


	/* End setters/getters */

	public function save($forceInsert=false) {
		$db = new Database;

		if (!$forceInsert && $this->populateId()) {
			return $this->update();
		}
		else {
			return $this->insert();
		}
	}

	private function insert() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$dbFields = self::getDbFields();

		$insertFields = array();
		$insertValues = array();
		$duplicateKeyUpdateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];

			$data = $this->$getterName();


			if ($dataType == "foreignKey") {
				if ($data) {
					array_push($insertFields, $fieldName);
					array_push($insertValues, $data);

					$duplicateKeyClause = "`$fieldName`='$data'";
					array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

				}
			}
			elseif ($data !== null) {
				if ($dataType == 'bool') {
					$data = $data ? '1' : '0';
				}
				elseif ($dataType == 'encrypted') {
					$data = EncryptionController::encryptString(trim($data));
				}
				elseif ($dataType == "string") {
					$data = mysql_real_escape_string(trim($data));
				}

				array_push($insertFields, $fieldName);
				array_push($insertValues, $data);

				$duplicateKeyClause = "`$fieldName`='$data'";
				array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

			}
		}

		$fieldsString = implode("`, `", $insertFields);
		$valuesString = implode("', '", $insertValues);
		$duplicateKeyString = implode(", ", $duplicateKeyUpdateClauses);

		$sql = "INSERT INTO `$dbTable`(`$fieldsString`) VALUES ('$valuesString') ON DUPLICATE KEY UPDATE $duplicateKeyString;";

		echo "<pre>$sql\n</pre>";

		return $db->db_query($sql, 'insert', true);
	}

	private function update() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$id = $this->getId();

		$dbFields = self::getDbFields();
		$updateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];
			$isMutable = $fieldParams['mutable'];
			if ($isMutable) {
				$data = $this->$getterName();


				if ($dataType == "foreignKey") {
					if ($data) {
						$updateClause = "`$fieldName`='$data'";

						array_push($updateClauses, $updateClause);

					}
				}
				elseif ($data !== null) {
					if ($dataType == 'bool') {
						$data = $data ? '1' : '0';
					}
					elseif ($dataType == 'encrypted') {
						$data = EncryptionController::encryptString(trim($data));
					}
					elseif ($dataType == "string") {
						$data = mysql_real_escape_string(trim($data));
					}

					$updateClause = "`$fieldName`='$data'";

					array_push($updateClauses, $updateClause);
				}

			}
		}
		$updateClausesString = implode(", ", $updateClauses);

		$sql = "UPDATE `$dbTable` SET $updateClausesString WHERE `id`='$id';";

		echo "<pre>$sql\n</pre>";

		return $db->db_query($sql, 'insert', true);

	}

	public function jsonify() {
		$dbFields = self::getDbFields();

		$jsonData = new stdClass;

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);

			$jsonData->$fieldName = $this->$getterName();
		}

		return $jsonData;
	}


	/* Static functions */

	public static function fetchById($id) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$sql = "SELECT * FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			$result['fromDb'] = true;

			return new ConstantContact($result, true, true);
		}
		else {
			return null;
		}
	}

	public static function fetchByEmail($email) {
		$db = new Database;
		$dbTable = self::getDbTable();
		$email = mysql_real_escape_string($email);
		$sql = "SELECT * FROM `$dbTable` WHERE `email`='$email';";
		$results = $db->db_query($sql, 'select-multiple', true);

		$contacts = array();

		if ($results[0]['id']) {
			foreach ($results as $result) {
				$result['fromDb'] = true;

				$contact = new Contact($result, true, true);

				array_push($contacts, $contact);
			}
		}

		return $contacts;
	}

	public static function checkIfExistsByEmail($email) {
		if (!$email) {
			return false;
		}
		$db = new Database;
		$dbTable = self::getDbTable();

		$email = mysql_real_escape_string($email);

		$sql = "SELECT `id` FROM `$dbTable` WHERE `email`='$email';";

		$result = $db->db_query($sql, 'select-single');

		if ($result['id']) {
			return true;
		}
		else {
			return false;
		}

	}


	private static function getDbFields() {
		return self::$dbFields;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}

	public static function constructFromCsvImportRow($data) {
		$contactData = new stdClass;

		$contactData->email = trim($data['Email address']);
		$contactData->firstName = trim($data['First name']);
		$contactData->lastName = trim($data['Last name']);

		$contactData->organization = trim($data['Company']);
		$contactData->title = trim($data['Job title']);
		$contactData->tags = trim($data['Tags']);
		$contactData->emailLists = trim($data['Email Lists']);
		$contactData->notes = trim($data['Notes']);
		$contactData->leadSource = trim($data['Source Name']);

		$contact = new ConstantContact($contactData);

		return $contact;
	}

	private static function fetchStateId($state) {
		$db = new Database;

		$sql = "SELECT `id` FROM `states` WHERE `abbreviation`='$state' OR `name`='$state' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single');

		if ($result['id']) {
			return $result['id'];
		}
		else {
			return null;
		}
	}
}

?>
