<?php


class ConsolidatedContact {
	private static $dbTable = 'consolidated_contact_list';

	private static $dbFields = array(
		'id' => array('type' => 'primary', 'mutable' => false),
		'zohoLeadId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'Lead'),
		'zohoContactId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'Contact'),
		'constantContactId' => array('type' => 'foreignKey', 'mutable' => true, 'class' => 'ConstantContact'),
		'emailAddress' => array('type' => 'string', 'mutable' => true)
	);

	private $id;

	private $zohoLead;
	private $zohoContact;
	private $constantContact;
	private $emailAddress;

	public function __construct($data, $populate=false) {
		if (is_array($data)) {
			$data = (object)$data;
		}
		if ($data->id) {
			$this->id = $data->id;
		}

		if ($data->zohoLead) {
			$this->zohoLead = $data->zohoLead;
		}
		elseif ($data->zohoLeadId) {
			if ($populate) {
				$this->zohoLead = Lead::fetchById($data->zohoLeadId);
			}
			else {
				$leadData = array('id' => $data->zohoLeadId);
				$this->zohoLead = new Lead($leadData, $populate);
			}
		}

		if ($data->zohoContact) {
			$this->zohoContact = $data->zohoContact;
		}
		elseif ($data->zohoContactId) {
			// $this->zohoContact = new Contact($contactData, $populate);
			if ($populate) {
				$this->zohoContact = Contact::fetchById($data->zohoContactId);
			}
			else {
				$contactData = array('id' => $data->zohoContactId);
				$this->zohoContact = new Contact($contactData, $populate);
			}
		}

		if ($data->constantContact) {
			$this->constantContact = $data->constantContact;
		}
		elseif ($data->constantContactId) {
			// $constantContactData = array('id' => $data->constantContactId);
			// $this->constantContact = new ConstantContact($constantContactData, $populate);
			if ($populate) {
				$this->constantContact = ConstantContact::fetchById($data->constantContactId);
			}
			else {
				$contactData = array('id' => $data->constantContactId);
				$this->constantContact = new ConstantContact($contactData, $populate);
			}
		}

		if ($data->emailAddress) {
			$this->emailAddress = $data->emailAddress;
		}
		elseif ($populate && $this->getId()) {
			$this->emailAddress = self::getEmailAddressById($this->getId());
		}
	}

	public function getId() {
		return $this->id;
	}
	public function setId($id) {
		$this->id = $id;
	}

	public function getZohoLead() {
		return $this->zohoLead;
	}
	public function setZohoLead($zohoLead) {
		$this->zohoLead = $zohoLead;
	}

	public function getZohoContact() {
		return $this->zohoContact;
	}
	public function setZohoContact($zohoContact) {
		$this->zohoContact = $zohoContact;
	}

	public function getConstantContact() {
		return $this->constantContact;
	}
	public function setConstantContact($constantContact) {
		$this->constantContact = $constantContact;
	}

	public function getEmailAddress() {
		return $this->emailAddress;
	}
	public function setEmailAddress($emailAddress) {
		$this->emailAddress = $emailAddress;
	}

	public function getZohoLeadId() {
		if ($this->getZohoLead()) {
			return $this->getZohoLead()->getId();
		}
		else {
			return null;
		}
	}

	public function getZohoContactId() {
		if ($this->getZohoContact()) {
			return $this->getZohoContact()->getId();
		}
		else {
			return null;
		}
	}

	public function getConstantContactId() {
		if ($this->getConstantContact()) {
			return $this->getConstantContact()->getId();
		}
		else {
			return null;
		}
	}

	public function save($forceInsert=false) {
		$db = new Database;

		if ($this->getId()) {
			return $this->update();
		}
		else {
			return $this->insert();
		}
	}

	private function insert() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$dbFields = self::getDbFields();

		$insertFields = array();
		$insertValues = array();
		$duplicateKeyUpdateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];

			$data = $this->$getterName();


			if ($dataType == "foreignKey") {
				if ($data) {
					array_push($insertFields, $fieldName);
					array_push($insertValues, $data);

					$duplicateKeyClause = "`$fieldName`='$data'";
					array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

				}
			}
			elseif ($data !== null) {
				if ($dataType == 'bool') {
					$data = $data ? '1' : '0';
				}
				elseif ($dataType == 'encrypted') {
					$data = EncryptionController::encryptString(trim($data));
				}
				elseif ($dataType == "string") {
					$data = mysql_real_escape_string(trim($data));
				}

				array_push($insertFields, $fieldName);
				array_push($insertValues, $data);

				$duplicateKeyClause = "`$fieldName`='$data'";
				array_push($duplicateKeyUpdateClauses, $duplicateKeyClause);

			}
		}

		$fieldsString = implode("`, `", $insertFields);
		$valuesString = implode("', '", $insertValues);
		$duplicateKeyString = implode(", ", $duplicateKeyUpdateClauses);

		$sql = "INSERT INTO `$dbTable`(`$fieldsString`) VALUES ('$valuesString') ON DUPLICATE KEY UPDATE $duplicateKeyString;";


		return $db->db_query($sql, 'insert', true);
	}

	private function update() {
		$db = new Database;
		$dbTable = self::getDbTable();

		$id = $this->getId();

		$dbFields = self::getDbFields();
		$updateClauses = array();

		foreach ($dbFields as $fieldName => $fieldParams) {
			$getterName = "get" . ucfirst($fieldName);
			$setterName = "set" . ucfirst($fieldName);

			$dataType = $fieldParams['type'];
			$isMutable = $fieldParams['mutable'];
			if ($isMutable) {
				$data = $this->$getterName();


				if ($dataType == "foreignKey") {
					if ($data) {
						$updateClause = "`$fieldName`='$data'";

						array_push($updateClauses, $updateClause);

					}
				}
				elseif ($data !== null) {
					if ($dataType == 'bool') {
						$data = $data ? '1' : '0';
					}
					elseif ($dataType == 'encrypted') {
						$data = EncryptionController::encryptString(trim($data));
					}
					elseif ($dataType == "string") {
						$data = mysql_real_escape_string(trim($data));
					}

					$updateClause = "`$fieldName`='$data'";

					array_push($updateClauses, $updateClause);
				}

			}
		}
		$updateClausesString = implode(", ", $updateClauses);

		$sql = "UPDATE `$dbTable` SET $updateClausesString WHERE `id`='$id';";


		return $db->db_query($sql, 'insert', true);
	}

	public function jsonify() {
		$dbFields = self::getDbFields();


		$jsonData = new stdClass;
		$jsonData->id = $this->getId();
		$jsonData->emailAddress = $this->getEmailAddress();
		if ($this->getZohoLead() !== null) {
			$jsonData->zohoLead = $this->getZohoLead()->jsonify();
		}
		if ($this->getZohoContact() !== null) {
			$jsonData->zohoContact = $this->getZohoContact()->jsonify();
		}
		if ($this->getConstantContact() !== null) {
			$jsonData->constantContact = $this->getConstantContact()->jsonify();
		}


		return $jsonData;
	}

	public static function getByEmailAddress($emailAddress) {
		$db = new Database;

		$dbTable = self::getDbTable();
		$emailAddress = mysql_real_escape_string($emailAddress);

		$sql = "SELECT * FROM `$dbTable` WHERE `emailAddress`='$emailAddress';";
		$result = $db->db_query($sql, 'select-single', true);

		if ($result['id']) {
			return new ConsolidatedContact($result, true);
		}
	}

	public static function getEmailAddressById($id) {
		$db = new Database;

		$dbTable = self::getDbTable();

		$sql = "SELECT `emailAddress` FROM `$dbTable` WHERE `id`='$id';";
		$result = $db->db_query($sql, 'select-single');

		if ($result['emailAddress']) {
			return $result['emailAddress'];
		}
	}


	private static function getDbFields() {
		return self::$dbFields;
	}

	public static function getDbTable() {
		return self::$dbTable;
	}
}
?>
