<?php

require_once(HTML_FOLDER . 'classes/Email/EmailService.php');
class EmailController {
	public static $justinEmail = array('name' => "Justin Sanderson", 'address' => 'j.sanderson@techtoschool.com');
	public static $robertEmail = array('name' => "Robert Baker", 'address' => 'r.baker@techtoschool.com');
	public static $devEmail = array('name' => "Michael Kemper", 'address' => 'm.kemper@techtoschool.com');

	public static function smtpTestEmail() {
		EmailService::sendSmtpTestEmail();
	}

	public static function shipNotificationTest() {
		$params = new stdClass;
		$params->ownerName = "Michael Kemper";
		$params->ownerEmail = "m.kemper@techtoschool.com";
		$params->contactName = "Test Recipient";
		$params->contactEmail = "test@techtoschool.com";

		$params->mtsNumber = "MTS12345";

		$params->shipDate = "2021-03-17";
		$params->purchaseOrder = "294386498";
		$params->shipMethod = "UPS Ground";
		$params->trackingNumber1 = "1Z1234567654345";
		$params->trackingNumber2 = "1Z2353264362425";
		$params->trackingNumber3 = "1Z9875549256235";
		$params->trackingNumber4 = "1Z1237408495404";
		$params->trackingNumber5 = "1Z9052378053109";

		$params->serialNumbers = "TESTTESTDFHW TEST0001F8TV TEST1541DF8V";

		$params->accountOwner = $params->ownerName;

		if (strpos($params->contactName, ' ') !== false) {
			$params->firstName = substr($params->contactName, 0, strpos($params->contactName, ' '));
		}
		else {
			$params->firstName = $params->contactName;
		}

		$success = self::sendShipNotificationEmail($params);
		if ($success) {
			echo "<h4>Mail reports success</h4>";
		}
		else {
			echo "<h4>Mail reports failure</h4>";
		}

		echo "<h3>" . (string)$success . "</h3>";
	}

	public static function shipNotificationLiveTest($zohoRecord, $contactDetails, $printDebugData=false) {
		if ($_GET['debug']=='yes') {
			$printDebugData = true;
		}

		$params = new stdClass;
		$params->ownerEmail = $contactDetails->owner->email;
		$params->ownerName = $contactDetails->owner->fullName;

		$params->contactEmail = $contactDetails->contact->email;
		$params->contactFullName = $contactDetails->contact->fullName;
		$params->contactFirstName = $contactDetails->contact->firstName;

		$params->mtsNumber = $zohoRecord['invoice']['MTS_Quote_Number'];
		$mtsNumber = $zohoRecord['invoice']['MTS_Quote_Number'];

		$params->purchaseOrder = $zohoRecord['invoice']['Purchase_Order'];
		$serialNumbers = $zohoRecord['invoice']['Serial_Number'];
		$params->serialNumbers = $serialNumbers;

		$rawShipDate = $zohoRecord['shipping']['Ship_Date'];
		$params->shipDate = EmailService::convertToHumanReadableDate($rawShipDate);
		$params->shipMethod = $zohoRecord['shipping']['Ship_Method'];
		$params->trackingNumber1 = $zohoRecord['shipping']['Tracking_Number_1'];
		$params->trackingNumber2 = $zohoRecord['shipping']['Tracking_Number_2'];
		$params->trackingNumber3 = $zohoRecord['shipping']['Tracking_Number_3'];
		$params->trackingNumber4 = $zohoRecord['shipping']['Tracking_Number_4'];
		$params->trackingNumber5 = $zohoRecord['shipping']['Tracking_Number_5'];

		$params->accountOwner = $params->ownerName;

		$params->debugData = '';

		if ($printDebugData) {
			echo "<pre>";
			print_r($params);
			echo "</pre>";
		}

		return self::sendShipNotificationEmail($params, $printDebugData);
	}

	public static function sendShipNotificationEmail($params, $debug=false) {
		$subject = $params->mtsNumber . ' Shipped';
		$emailTemplate = file_get_contents(HTML_FOLDER . "templates/email/shipNotification.html");
		if ($debug) {
			$debugText = "====DEBUG DATA FOLLOWS====\n";
			foreach ($params as $key=>$value) {
				$debugText .= "$key : $value \n";
			}
			$debugText .= "====DEBUG DATA ENDS====\n";
			$params->debugData = $debugText;
		}
		$emailBody = $emailTemplate;
		foreach ($params as $key => $value) {
			$emailBody = str_replace('${'.$key.'}', $value, $emailBody);
		}
		$emailBody = preg_replace("/(\${.*})/", '', $emailBody);

		$cc = array();

		$bcc = array();

		$emailParams = new stdClass;
		$emailParams->subject = $subject;
		$emailParams->body = $emailBody;
		$emailParams->fromName = $params->ownerName;
		$emailParams->fromEmail = $params->ownerEmail;
		$emailParams->fromString = "$params->ownerName <$params->ownerEmail>";
		$emailParams->to = '';
		$emailParams->cc = '';
		$emailParams->bcc = '';

		$emailResults = new stdClass;

		$emailParams->toName = self::$devEmail['name'];
		$emailParams->toEmail = self::$devEmail['address'];
		$emailResults->dev = self::sendEmail($emailParams);
		$emailParams->toName = self::$justinEmail['name'];
		$emailParams->toEmail = self::$justinEmail['address'];
		$emailResults->justin = self::sendEmail($emailParams);
		$emailParams->toName = self::$robertEmail['name'];
		$emailParams->toEmail = self::$robertEmail['address'];
		$emailResults->robert = self::sendEmail($emailParams);


		// // $emailResults->contact = self::sendEmail($subject, $emailBody, $from, $contactEmailStr);
		// // $emailResults->owner = self::sendEmail($subject, $emailBody, $from, $ownerEmailStr);
		// $emailResults->justin = self::sendEmail($subject, $emailBody, $from, self::$justinEmail);
		// $emailResults->robert = self::sendEmail($subject, $emailBody, $from, self::$robertEmail);
		// $emailResults->dev = self::sendEmail($subject, $emailBody, $from, array(self::$devEmail));

		return $emailResults;
	}

	public static function sendEmail($data) {
		return EmailService::sendEmail($data);
	}

	public static function sendEmailFake($subject='', $txt='', $from='', $to=array(), $cc=array(), $bcc=array()) {
		return EmailService::sendEmailFake($subject, $txt, $from, $to, $cc, $bcc);
	}
}

?>
