<?php

class DropshipService {
	public static function getInventoryCount() {
		$db = new Database;
		$sql = "SELECT
				mon.order_number,
				mon.order_number_id,
				mon.ram,
				mon.storage,
				mon.first_stock_pricing,
				mon.second_stock_pricing,
				mon.first_stock_ten_pack_pricing,
				mon.second_stock_ten_pack_pricing,
				mon.limited_to_inventory,
				mon.color,
				mon.active AS tts_active,
				mon.special_order,
				ml.machine_id,
				ml.machine_description,
				ml.processor AS ml_processor,
				ml.processor_speed AS ml_processor_speed,
				mon.processor AS mon_processor,
				mon.processor_speed AS mon_processor_speed,
				mon.device_condition AS device_condition,
				mon.touchscreen AS touchscreen,
				mon.auto_update_expiration,
				mon.dropship,
				mon.dropship_quantity,
				mon.dropship_cost,
				mon.dropship_description,
				ml.upgradeable,
				ml.latest_os,
				mzi.first_stock_zoho_id_individual,
				mzi.second_stock_zoho_id_individual,
				mzi.first_stock_zoho_id_tenpack,
				mzi.second_stock_zoho_id_tenpack,
				msi.first_stock_inventory_item_id,
				msi.second_stock_inventory_item_id
				FROM machine_order_number AS mon
				LEFT JOIN machine_lookup AS ml ON ml.machine_id = mon.machine_id
				LEFT JOIN machine_zoho_ids AS mzi ON mzi.machine_order_number_id = mon.order_number_id
				LEFT JOIN machine_shopify_ids AS msi ON msi.machine_order_number_id = mon.order_number_id
				WHERE mon.order_number IS NOT NULL
				AND mon.order_number != ''
				AND mon.dropship = '1'
				GROUP BY mon.order_number_id
				ORDER BY mon.order_number_id ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);

		$assets = array();
		// $counts = self::getAllOrderNumbersCurrentStock();
		// print_r($counts);
		// $inbounds = self::getAllOrderNumberIdsInbound();
		if ($_GET['debug'] == 'yes') {
			echo "<pre>";
			print_r($inbounds);
			echo "</pre>";
		}
		// print_r($inbounds);
		// $demands = self::getAllOrderNumberIdsDemand();
		// print_r($demands);
		foreach ($results as $result) {
			$asset = new DropshipAsset($result);
			$orderNumberId = $asset->getMachineOrderNumberId();
			// if ($counts[$orderNumberId]) {
			// 	$asset->setCounts($counts[$orderNumberId]);
			// }
			// if ($inbounds[$orderNumberId]) {
			// 	$asset->setInbound($inbounds[$orderNumberId]);
			// }
			// if ($demands[$orderNumberId]) {
			// 	$asset->setDemands($demands[$orderNumberId]);
			// }
			array_push($assets, $asset);
		}
		return $assets;
	}
}

?>
