<?php


class DropshipController {
	public static function inventoryPage() {
		$admin = new Admin;
		$title = "DropShip Inventory";
		$page_heading = "Dropship Inventory";
		$asset_modal = file_get_contents('templates/inventory/asset_modal.html');
		$template = DROPSHIP_INVENTORY;
		$scripts = '<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/dropship/asset_modal.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/dropship/datasets/Asset.js" type="text/javascript"></script>
					<script src="__CDN_JAVASCRIPT__javascript/dropship/dropshipInventoryController.js" type="text/javascript"></script>';
		$templateElements = array(
			'MODAL' => $asset_modal,
			'PAGE_HEADING' => $page_heading,
			'CURRENT_PAGE' => $page,
			'SCRIPTS' => $scripts
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function fileUploadPage() {
		$admin = new Admin;
		$title = "Dropship File Upload";
		$template = file_get_contents("templates/dropship/dropship_file_upload.html");
		$templateElements = array();
		return $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function uploadResultPage($updatedSkuString, $newSkuString) {
		$admin = new Admin;
		$title = "Dropship Upload Results";
		$template = file_get_contents("templates/dropship/dropship_upload_results.html");
		$templateElements = array(
			"UPDATED_SKUS" => $updatedSkuString,
			"NEW_SKUS" => $newSkuString
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));

	}

	public static function getInventoryCount($status) {
		$assets = DropshipService::getInventoryCount();
		return $assets;
	}

	public static function getStatuses() {
		$statuses = DropshipService::getAllStatuses();
		return $statuses;
	}

	public static function ingestInventoryTest() {
		require_once(HTML_FOLDER . 'classes/SimpleXLSX/SimpleXLSX.php');

		$parsedBook = SimpleXLSX::parse(HTML_FOLDER . "classes/Dropship/test/Nov15 Inventory.xlsx");
		// echo count($parsedBook->sheetNames());

		$sheets = array();

		$html = "";
		for ($i = 0; $i < count($parsedBook->sheetNames()); $i++) {
			$sheetName = $parsedBook->sheetName($i);

			$sheet = array(
				"name" => $sheetName,
				"assets" => array()
			);
			$rows = $parsedBook->rows($i);

			$headRow = $rows[0];

			for ($j = 1; $j < count($rows); $j++) {
				$row = $rows[$j];
				$rowData = array();
				for ($x = 0; $x < count($row); $x++) {
					$rowData[$headRow[$x]] = trim($row[$x]);
				}
				$rowData = (object)$rowData;
				if ($rowData->Sku) {
					$sheet['assets'][$rowData->Sku] = $rowData;
				}
			}
			$sheets[$sheetName] = (object)$sheet;

		}
		$sheets = (object)$sheets;
		echo "<pre>";
		print_r($sheets->Chromebooks);
		echo "</pre>";

		self::processChromebooksSheetData($sheets->Chromebooks);

		// echo $html;

		// $html = "";

		// echo SimpleXLSX::parse(HTML_FOLDER . "classes/Dropship/test/Nov15 Inventory.xlsx")->toHTML();
	}

	public static function ingestInventorySheet() {
		require_once(HTML_FOLDER . 'classes/SimpleXLSX/SimpleXLSX.php');

		if ($_FILES['filedrop']['error'] == UPLOAD_ERR_OK) {
		}               //checks for errors
		else {
			echo "Error!";
			print_r($_FILES['filedrop']['error']);
			exit;
		}
		if (is_uploaded_file($_FILES['filedrop']['tmp_name'])) { //checks that file is uploaded
		}

		$parsedBook = SimpleXLSX::parse($_FILES['filedrop']['tmp_name'], false, true);
		if (!$parsedBook) {
			echo $_FILES['filedrop']['tmp_name'];
			echo SimpleXLSX::parseError();
			exit;
		}
		// echo count($parsedBook->sheetNames());

		$sheets = array();

		for ($i = 0; $i < count($parsedBook->sheetNames()); $i++) {
			$sheetName = $parsedBook->sheetName($i);

			$sheet = array(
				"name" => $sheetName,
				"assets" => array()
			);
			$rows = $parsedBook->rows($i);

			$headRow = $rows[0];

			for ($j = 1; $j < count($rows); $j++) {
				$row = $rows[$j];
				$rowData = array();
				for ($x = 0; $x < count($row); $x++) {
					$rowData[$headRow[$x]] = $row[$x];
				}
				$rowData = (object)$rowData;
				if ($rowData->Sku) {
					$sheet['assets'][$rowData->Sku] = $rowData;
				}
			}
			$sheets[$sheetName] = (object)$sheet;

		}
		$sheets = (object)$sheets;
		$chromebookSheetData = self::processChromebooksSheetData($sheets->Chromebooks);
		$updatedSkuString = "";
		$newSkuString = "";

		foreach ($chromebookSheetData->updated as $assetData) {
			$orderNumberId = $assetData->orderNumberId;
			$sku = $assetData->sku;
			$quantity = $assetData->quantity;
			$cost = $assetData->cost;

			$str = "<tr><td><a href='" . CONTROLLER . "?m=order_number_edit&order_number_id=$orderNumberId' target='_blank'>$sku</a></td><td>$quantity</td><td>\$$cost</td></tr>";

			$updatedSkuString .= $str;
		}

		foreach ($chromebookSheetData->new as $assetData) {
			$orderNumberId = $assetData->orderNumberId;
			$sku = $assetData->sku;
			$description = $assetData->description;
			$quantity = $assetData->quantity;
			$cost = $assetData->cost;

			$str = "<tr><td><a href='" . CONTROLLER . "?m=order_number_edit&order_number_id=$orderNumberId' target='_blank'>$sku</a></td><td>$description</td><td>$quantity</td><td>\$$cost</td></tr>";

			$newSkuString .= $str;
		}

		self::uploadResultPage($updatedSkuString, $newSkuString);
	}

	private static function processChromebooksSheetData($sheet) {
		$db = new Database;

		$assets = $sheet->assets;

		$newArrivalMachineName = "Dropship New Arrival";

		$sql = "SELECT `machine_id` FROM `machine_lookup` WHERE `machine_description`='$newArrivalMachineName';";
		$result = $db->db_query($sql, "select-single", true);
		$machineId = $result['machine_id'];

		$newSkus = array();
		$updatedSkus = array();
		foreach ($assets as $asset) {
			$sku = $asset->Sku;
			$quantity = $asset->QTY;
			$offer = ceil($asset->Offer);
			$description = $asset->ProductName;
			$escapedDescription = mysql_real_escape_string($description);

			$sql = "SELECT mon.order_number_id, mon.order_number
					FROM machine_order_number AS mon
					WHERE mon.order_number = '$sku';";

			$result = $db->db_query($sql, "select-single", true);

			if ($result['order_number_id']) {
				$id = $result['order_number_id'];
				$sql = "UPDATE machine_order_number SET dropship_description='$escapedDescription', dropship='1', dropship_quantity='$quantity', dropship_cost='$offer' WHERE order_number_id='$id';";
				$db->db_query($sql, "update", true);

				$updatedSku = array(
					"orderNumberId" => $result['order_number_id'],
					"sku" => $sku,
					"quantity" => $quantity,
					"cost" => $offer
				);
				array_push($updatedSkus, (object)$updatedSku);
			}
			else {

				$parsedDescriptionData = self::parseDescription($description);

				$ram = $parsedDescriptionData->ram;
				$processor = $parsedDescriptionData->processor;
				$processorSpeed = $parsedDescriptionData->processorSpeed;
				$storage = $parsedDescriptionData->storage;

				$sql = "INSERT INTO `machine_order_number`(`order_number`, `machine_id`, `dropship_description`, `dropship`, `dropship_quantity`, `dropship_cost`, `ram`, `processor`, `processor_speed`, `storage`) VALUES ('$sku', '$machineId', '$escapedDescription','1', '$quantity', '$offer', '$ram', '$processor', '$processorSpeed', '$storage');";
				$db->db_query($sql, "insert", true);

				$sql = "SELECT mon.order_number_id
						FROM machine_order_number AS mon
						WHERE mon.order_number = '$sku';";

				$result = $db->db_query($sql, "select-single", true);

				$newSku = array(
					"orderNumberId" => $result['order_number_id'],
					"sku" => $sku,
					"description" => $description,
					"quantity" => $quantity,
					"cost" => $offer
				);
				array_push($newSkus, (object)$newSku);
			}
		}

		$data = array(
			"updated" => $updatedSkus,
			"new" => $newSkus
		);
		return (object)$data;
	}

	private static function parseDescription($description) {
		// Lenovo 14E 14" FHD Chromebook - AMD Core A4-9120C 1.6GHz - 4GB RAM - 32GB eMMC - Webcam - Chrome OS - Mineral Gray
		// Company Model Description - Processor Processor Speed - RAM - Storage - Other

		$components = explode(" - ", $description);
		// echo "<pre>";
		// print_r($components);
		// echo "</pre>";



		$processor = "";
		$processorSpeed = '';

		$ram = "";

		$storage = "";

		foreach ($components as $component) {
			if (!$processorSpeed) {
				if (strpos($component, " 1.") !== FALSE) {
					$processor = trim(substr($component, 0, strpos($component, " 1.")));
					$processorSpeed = substr($component, strpos($component, " 1.")+1, 3) . " GHz";
				}
				else if (strpos($component, " 2.") !== FALSE) {
					$processor = trim(substr($component, 0, strpos($component, " 2.")));
					$processorSpeed = substr($component, strpos($component, " 2.")+1, 3) . " GHz";
				}
				else if (strpos($component, " 3.") !== FALSE) {
					$processor = trim(substr($component, 0, strpos($component, " 3.")));
					$processorSpeed = substr($component, strpos($component, " 3.")+1, 3) . " GHz";
				}
				else if (strpos($component, " 4.") !== FALSE) {
					$processor = trim(substr($component, 0, strpos($component, " 4.")));
					$processorSpeed = substr($component, strpos($component, " 4.")+1, 3) . " GHz";
				}
			}
			if (!$ram) {
				if (strpos($component, " RAM") !== FALSE) {
					$ram = trim(substr($component, 0, strpos($component, " RAM")));
				}
				else if (strpos($component, " memory") !== FALSE) {
					$ram = trim(substr($component, 0, strpos($component, " memory")));
				}
				else if (strpos($component, " Memory") !== FALSE) {
					$ram = trim(substr($component, 0, strpos($component, " Memory")));
				}
			}
			if (!$storage) {
				if (strpos($component, " eMMC") !== FALSE) {
					$storage = trim(substr($component, strpos($component, " ",strpos($component, " eMMC")-5), 5));
				}
				else if (strpos($component, " EMMC") !== FALSE) {
					$storage = trim(substr($component, strpos($component, " ",strpos($component, " EMMC")-5), 5));
				}
			}
		}

		$data = array(
			"description" => $description,
			"name" => $components[0],
			"processor" => $processor,
			"processorSpeed" => $processorSpeed,
			"ram" => $ram,
			"storage" => $storage
		);



		// $company = substr($description, 0, strpos($description, " "));

		return (object)$data;


	}

	private static function processNewArrivalsData($sheet) {

	}
}


?>
