<?php

class DropshipAsset {
	public $machineOrderNumberId;
	public $machineOrderNumber;
	public $machineId;
	public $machineDescription;
	public $machineType;

	public $ttsActive;
	public $specialOrder;
	public $autoUpdateExpiration;
	public $limitedToInventory;
	public $deviceCondition;

	public $dropship;
	public $dropshipQuantity;
	public $dropshipCost;

	public $ram;
	public $storage;
	public $processor;
	public $processorSpeed;
	public $touchscreen;
	public $color;

	public $itemCounts;
	public $demand;
	public $inbound;

	public $pricing;
	public $zohoIds;
	public $shopifyIds;

	public function __construct($data) {
		// Parse asset data
		$this->machineOrderNumber = $data['order_number'];
		$this->machineOrderNumberId = $data['order_number_id'];
		$this->ram = $data['ram'];
		$this->storage = $data['storage'];

		// Prioritize order number level processor and speed if exists; else machine level processor and speed
		if ($data['mon_processor']) {
			$this->processor = $data['mon_processor'];
		}
		elseif ($data['ml_processor']) {
			$this->processor = $data['ml_processor'];
		}
		if ($data['mon_processor_speed']) {
			$this->processorSpeed = $data['mon_processor_speed'];
		}
		elseif ($data['ml_processor_speed']) {
			$this->processorSpeed = $data['ml_processor_speed'];
		}

		$this->deviceCondition = $data['device_condition'];
		$this->touchscreen = $data['touchscreen'] == '1' ? true : false;
		$this->limitedToInventory = $data['limited_to_inventory'] == '1' ? true : false;
		$this->dropship = $data['dropship'] == '1' ? true : false;
		$this->dropshipQuantity = $data['dropship_quantity'];
		$this->dropshipCost = $data['dropship_cost'];
		$this->dropshipDescription = $data['dropship_description'];
		$this->color = $data['color'];
		$this->ttsActive = $data['tts_active'] == '1' ? true : false;
		$this->specialOrder = $data['special_order'] == '1' ? true : false;
		$this->machineId = $data['machine_id'];
		$this->machineDescription = $data['machine_description'];
		$this->machineType = $this->determineMachineType();
		$this->autoUpdateExpiration = $data['auto_update_expiration'];
		$this->latestOs = $data['latest_os'];
		$this->upgradeable = $data['upgradeable'];

		// Parse demand
		$this->demand = new stdClass;
		$this->demand->firstStock = (int)$data['first_stock_demand'] ? (int)$data['first_stock_demand'] : 0;
		$this->demand->secondStock = (int)$data['second_stock_demand'] ? (int)$data['second_stock_demand'] : 0;

		// Parse inbound
		$this->inbound = (int)$data['inbound'] ? (int)$data['inbound'] : 0;

		// Parse item counts
		$this->itemCounts = new stdClass;
		$this->itemCounts->total = (int)$data['item_count'] ? (int)$data['item_count'] : 0;
		$this->itemCounts->aGrade = (int)$data['a_grade_count'] ? (int)$data['a_grade_count'] : 0;
		$this->itemCounts->bGrade = (int)$data['b_grade_count'] ? (int)$data['b_grade_count'] : 0;
		$this->itemCounts->cGrade = (int)$data['c_grade_count'] ? (int)$data['c_grade_count'] : 0;
		$this->itemCounts->dGrade = (int)$data['d_grade_count'] ? (int)$data['d_grade_count'] : 0;
		$this->itemCounts->fGrade = (int)$data['f_grade_count'] ? (int)$data['f_grade_count'] : 0;
		$this->itemCounts->engraved = (int)$data['engraved_count'] ? (int)$data['engraved_count'] : 0;

		// Parse prices
		$this->pricing = new stdClass;
		$this->pricing->firstStock = new stdClass;
		$this->pricing->firstStock->individual = (float)$data['first_stock_pricing'] ? (float)$data['first_stock_pricing'] : 0.0;
		$this->pricing->firstStock->tenpack = (float)$data['first_stock_ten_pack_pricing'] ? (float)$data['first_stock_ten_pack_pricing'] : 0.0;
		$this->pricing->secondStock = new stdClass;
		$this->pricing->secondStock->individual = (float)$data['second_stock_pricing'] ? (float)$data['second_stock_pricing'] : 0.0;
		$this->pricing->secondStock->tenpack = (float)$data['second_stock_ten_pack_pricing'] ? (float)$data['second_stock_ten_pack_pricing'] : 0.0;

		// Parse Zoho IDs
		$this->zohoIds = new stdClass;
		$this->zohoIds->firstStock = new stdClass;
		$this->zohoIds->firstStock->individual = $data['first_stock_zoho_id_individual'];
		$this->zohoIds->firstStock->tenpack = $data['first_stock_zoho_id_tenpack'];
		$this->zohoIds->secondStock = new stdClass;
		$this->zohoIds->secondStock->individual = $data['second_stock_zoho_id_individual'];
		$this->zohoIds->secondStock->tenpack = $data['second_stock_zoho_id_tenpack'];

		// Parse shopify IDs
		$this->shopifyIds = new stdClass;
		$this->shopifyIds->firstStock = $data['first_stock_inventory_item_id'];
		$this->shopifyIds->secondStock = $data['second_stock_inventory_item_id'];
	}

	public function getMachineOrderNumberId() {
		return $this->machineOrderNumberId;
	}

	public function getMachineDescription() {
		return $this->machineDescription;
	}

	public function setTotalCount($count) {
		$this->itemCounts->total = $count;
	}

	public function setAGradeCount($count) {
		$this->itemCounts->aGrade = $count;
	}

	public function setBGradeCount($count) {
		$this->itemCounts->bGrade = $count;
	}

	public function setCGradeCount($count) {
		$this->itemCounts->cGrade = $count;
	}

	public function setDGradeCount($count) {
		$this->itemCounts->dGrade = $count;
	}

	public function setFGradeCount($count) {
		$this->itemCounts->fGrade = $count;
	}

	public function setCounts($counts) {
		$this->setTotalCount($counts->itemCount);
		$this->setAGradeCount($counts->aGradeCount);
		$this->setBGradeCount($counts->bGradeCount);
		$this->setCGradeCount($counts->cGradeCount);
		$this->setDGradeCount($counts->dGradeCount);
		$this->setFGradeCount($counts->fGradeCount);
	}

	public function setFirstStockDemand($demand) {
		$this->demand->firstStock = $demand;
	}

	public function setSecondStockDemand($demand) {
		$this->demand->secondStock = $demand;
	}

	public function setDemands($demands) {
		$this->setFirstStockDemand($demands->firstStock);
		$this->setSecondStockDemand($demands->secondStock);
	}

	public function setInbound($inbound) {
		$this->inbound = $inbound;
	}

	private function determineMachineType() {
		$machineType = 'other';

		if (strpos(strtolower($this->getMachineDescription()), 'ipad') !== false) {
			$machineType = 'ipad';
		}
		elseif (strpos(strtolower($this->getMachineDescription()), 'imac') !== false) {
			$machineType = 'imac';
		}
		elseif (strpos(strtolower($this->getMachineDescription()), 'macbook') !== false) {
			$machineType = 'macbook';
		}
		elseif (strpos(strtolower($this->getMachineDescription()), 'chromebook') !== false) {
			$machineType = 'chromebook';
		}

		return $machineType;
	}
}

?>
