<?php
require_once(HTML_FOLDER . "class_database.php");

class Deductions {

	public static function renderDeductionsPage() {
		$admin = new Admin;
		$templateElements = array(
			'LOADING_MODAL' => LOADING_MODAL,
			'SCRIPTS' => 	'<script src="__CDN_JAVASCRIPT__javascript/deductions/DeductionsPage.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/deductions/DeductedItem.js" type="text/javascript"></script>'
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(DEDUCTIONS_PAGE, $templateElements), "TITLE" => "Deducted SKUs"));
	}

	public static function getDeductedSkus() {
		$db = new Database; // Instantiate DB for queries

		// Construct object to organize returned data
		$returnData = new stdClass;
		$returnData->metadata = new stdClass;
		$returnData->openOrderDeductions = array();
		$returnData->shipLogDeductions = array();

		// Build query to get open order deductions
		$sql = "SELECT `id`, `zoho_id`, `name`, `code` FROM `order_line_items` WHERE `deducted_on_open_orders`='1';";
		// Save query in metadata
		$returnData->metadata->openOrderDeductionsQuery = $sql;
		// Run query
		$results = $db->db_query($sql, 'select-multiple', true);

		// Iterate over results and put into open order deductions array
		foreach ($results as $result) {
			$deduction = new stdClass;
			$deduction->id = $result['id'];
			$deduction->zoho_id = $result['zoho_id'];
			$deduction->name = $result['name'];
			$deduction->code = $result['code'];
			$deduction->view = "open";
			array_push($returnData->openOrderDeductions, $deduction);
		}

		// Build query to get ship log deductions
		$sql = "SELECT `id`, `zoho_id`, `name`, `code` FROM `order_line_items` WHERE `deducted_on_ship_log`='1';";
		// Save query in metadata
		$returnData->metadata->shipLogDeductionsQuery = $sql;
		// Run query
		$results = $db->db_query($sql, 'select-multiple', true);

		// Iterate over results and put into ship log deductions array
		foreach ($results as $result) {
			$deduction = new stdClass;
			$deduction->id = $result['id'];
			$deduction->zoho_id = $result['zoho_id'];
			$deduction->name = $result['name'];
			$deduction->code = $result['code'];
			$deduction->view = "shipped";
			array_push($returnData->shipLogDeductions, $deduction);
		}

		// Return data
		return $returnData;
	}

	public static function addToDeductions($module, $view, $id, $channel='') {
		$response = new stdClass;
		if ($module == 'tts') {
			$query = self::addToTtsDeductions($view, $id);
			$response->query = $query;
			return json_encode($response);
		}
	}

	private static function addToTtsDeductions($view, $id) {
		$db = new Database;
		if ($view == 'shipped') {
			$sql = "UPDATE `order_line_items` SET `deducted_on_ship_log`='1' WHERE `zoho_id`='$id' OR `id`='$id';";
		}
		elseif ($view == 'open') {
			$sql = "UPDATE `order_line_items` SET `deducted_on_open_orders`='1' WHERE `zoho_id`='$id' OR `id`='$id';";
		}
		$result = $db->db_query($sql, 'update', true);
		return $sql;
	}

	public static function removeFromDeductions($view, $id) {
		$db = new Database;

		$response = new stdClass;
		if ($view == 'shipped') {
			$sql = "UPDATE `order_line_items` SET `deducted_on_ship_log`='0' WHERE `id`='$id';";
		}
		elseif ($view == 'open') {
			$sql = "UPDATE `order_line_items` SET `deducted_on_open_orders`='0' WHERE `id`='$id';";
		}
		$response->query = $sql;
		$result = $db->db_query($sql, 'update', true);
		return $sql;
 	}
}
