<?php

class CsvBuilder {
	public static function buildCsv($data, $fileName=null) {
		if (!$fileName) {
			$currentDate = new DateTime('now', new DateTimeZone('America/Los_Angeles'));
			$timestamp = $currentDate->format('YmdHis');
			$fileName = "newfile-$timestamp.csv";
		}
		elseif (substr($fileName, -4) != '.csv') {
			$fileName = $fileName . ".csv";
		}
		$fullPath = HTML_FOLDER . "exports/csv/" . $fileName;
		$relativePath = "exports/csv/" . $fileName;
		$paths = array(
			'relative' => $relativePath,
			'full' => $fullPath
		);
		$paths = (object)$paths;
		$handle = fopen($fullPath, 'w');
		chmod($fullPath, 0777);

		foreach ($data as $line) {
			if (is_string($line)) {
				$line = explode(',', $line);
			}
			fputcsv($handle, $line);
		}

		fclose($handle);

		return $paths;
	}

	public static function addToCsv($data, $filename) {
		if (!$filename) {
			throw new Exception('Filename is required.');
		}
		elseif (substr($filename, -4) != '.csv') {
			$filename = $filename . ".csv";
		}
		$fullPath = HTML_FOLDER . "exports/csv/" . $filename;
		$relativePath = "exports/csv/" . $filename;
		$paths = array(
			'filename' => $filename,
			'relative' => $relativePath,
			'full' => $fullPath
		);
		$paths = (object)$paths;
		$handle = fopen($fullPath, 'a');
		chmod($fullPath, 0777);

		foreach ($data as $line) {
			fputcsv($handle, $line);
		}

		fclose($handle);

		return $paths;

	}
}

?>
