<?php

class CheckoutController {
	public static function renderFreightCarrierPage() {
		$admin = new Admin;
		$title = "Freight Carriers";
		$templateElements = array(
			"SCRIPTS" =>	'<script src="__CDN_JAVASCRIPT__javascript/ecomm/freightCarrierEdit.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/ecomm/Datasets/FreightCarrier.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(FREIGHT_CARRIERS, $templateElements), "TITLE" => $title));
	}

	public static function getFreightCarriers() {
		return json_encode(CheckoutService::getFreightCarriers());
	}

	public static function saveFreightCarriers($carriersData) {
		$results = array();
		foreach($carriersData as $data) {
			$result = self::saveFreightCarrier($data);
			array_push($results, $result);
		}
		return $results;
	}

	public static function saveFreightCarrier($data) {
		return CheckoutService::saveFreightCarrier($data);
	}

	public static function deleteFreightCarrier($id) {
		return CheckoutService::deleteFreightCarrier($id);
	}
}

?>
