<?php

require_once(HTML_FOLDER . "classes/Generic/Datasets/LineItem.php");
class BuybackLineItem extends LineItem {
	private static $joinTable = "buyback_line_items";


	public $description;
	public $quantity;
	public $total;

	public function __construct($data) {
		if (is_array($data)) {
			$data = (object)$data;
		}

		parent::__construct($data);
		$this->description = $data->description;
		$this->quantity = (int)$data->quantity;
		$this->total = (float)$data->total;
	}

	public function getDescription() {
		return $this->description;
	}

	public function getQuantity() {
		return $this->quantity;
	}

	public function getTotal() {
		return $this->total;
	}

	public function generateBuybackLineItemsInsertQuery($buybackDbId=null, $buybackZohoId=null) {
		$joinTable = self::getBuybackLineItemJoinTable();


		$hasDbId = $this->populateDbId();
		if (!$hasDbId) {
			return false;
		}

		$lineItemId = $this->getDbId();
		$quantity = $this->getQuantity();
		$description = mysql_real_escape_string($this->getDescription());

		if ($buybackDbId) {
			$buybackIdValueString = "'$buybackDbId'";
		}
		elseif ($buybackZohoId) {
			$buybackTable = Buyback::getBuybacksDbTable();
			$buybackTableZohoIdField = Buyback::getZohoIdFieldName();

			$buybackIdValueString = "(SELECT `id` FROM `$buybackTable` WHERE `$buybackTableZohoIdField`='$buybackZohoId')";
		}
		else {
			return false;
		}
		$sql = "INSERT INTO `$joinTable`(`buyback_id`, `line_item_id`, `quantity`, `description`) VALUES ($buybackIdValueString, '$lineItemId', '$quantity', '$description') ON DUPLICATE KEY UPDATE `quantity`='$quantity', `description`='$description';";
		return $sql;
	}

	public static function getBuybackLineItemJoinTable() {
		return self::$joinTable;
	}

	public static function generateBuybacksLineItemsDeleteQuery($zohoId) {
		$joinTable = self::getBuybackLineItemJoinTable();

		$query = "DELETE FROM `$joinTable` WHERE `buyback_id` = (SELECT `id` FROM `buybacks` WHERE `zoho_id`='$zohoId');";

		return $query;
	}
}

?>
