<?php


require_once(HTML_FOLDER . "classes/Generic/Datasets/Account.php");
require_once(HTML_FOLDER . 'classes/Buybacks/Datasets/BuybackLineItem.php');
require_once(HTML_FOLDER . 'classes/Buybacks/Datasets/BuybackStatus.php');
class Buyback {
	public static $buybackDbTable = "buybacks";
	public static $zohoIdFieldName = 'zohoId';

	public $dbId;
	public $zohoId;
	public $mtsNumber;
	public $subject;
	public $notes;
	public $fx;
	public $gd;
	public $zohoStatus;
	public $subtotal;
	public $createdDateTime;
	public $account;
	public $lineItems;

	public function __construct($data, $fromDb=false) {
		if ($fromDb) {
			$accountData = new stdClass;
			$accountData->dbId = $data->accountDbId;
			$accountData->zohoId = $data->accountZohoId;
			$accountData->name = $data->accountName;

			$statusData = new stdClass;
			$statusData->dbId = $data->statusDbId;
			$statusData->status = $data->statusName;
			$statusData->identifier = $data->statusIdentifier;

			$this->dbId = $data->dbId;
			$this->zohoId = $data->zohoId;
			$this->mtsNumber = $data->mtsNumber;
			$this->subject = $data->subject;
			$this->notes = $data->notes;
			$this->fx = $data->fx == '1' ? true : false;
			$this->gd = $data->gd == '1' ? true : false;
			$this->zohoStatus = $data->zohoStatus;
			$this->subtotal = $data->subtotal;
			$this->createdDateTime = $data->createdDateTime;
			$this->status = new BuybackStatus($statusData);
			$this->account = new Account($accountData);
			$this->lineItems = array();
		}
		else {
			$buybackData = $data->buyback;
			$accountData = $data->account;
			$lineItemData = $data->lineItems;

			$this->dbId = $buybackData->dbId;
			$this->zohoId = $buybackData->zohoId;
			$this->account = new Account($accountData);
			$this->mtsNumber = $buybackData->mtsNumber;
			$this->subject = $buybackData->subject;
			$this->zohoStatus = $buybackData->status;
			$this->subtotal = $buybackData->subtotal;
			$this->createdDateTime = $buybackData->createdDate;
			$this->lineItems = array();
			foreach ($lineItemData as $lineItemObj) {
				array_push($this->lineItems, new BuybackLineItem($lineItemObj));
			}
		}
	}

	public function getDbId() {
		return $this->dbId;
	}

	public function setDbId($dbId) {
		$this->dbId = $dbId;
	}

	public function isDbIdSet() {
		if ($this->getDbId()) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getZohoId() {
		return $this->zohoId;
	}

	public function getAccount() {
		return $this->account;
	}

	public function getMtsNumber() {
		return $this->mtsNumber;
	}

	public function getSubject() {
		return $this->subject;
	}

	public function getZohoStatus() {
		return $this->zohoStatus;
	}

	public function getSubtotal() {
		return $this->subtotal;
	}

	public function getCreatedDateTime() {
		return $this->createdDateTime;
	}

	public function getLineItems() {
		return $this->lineItems;
	}

	public function addLineItem($data) {
		array_push($this->lineItems, new BuybackLineItem($data));
	}

	public function populateDbId() {
		if ($this->isDbIdSet()) {
			return true;
		}

		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$buybacksTable = self::getBuybacksDbTable();
		$zohoIdFieldName = self::getZohoIdFieldName();
		$zohoId = $this->getZohoId();

		$sql = "SELECT `id` FROM `$buybacksTable` WHERE `$zohoIdFieldName`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		if ($id) {
			$this->setDbId($id);
			return true;
		}
		else {
			return false;
		}
	}

	public function generateBuybacksTableInsertQuery() {
		$buybackDbTable = self::getBuybacksDbTable();
		$buybackZohoIdFieldName = self::getZohoIdFieldName();

		$accountDbTable = Account::getAccountDbTable();
		$accountZohoIdFieldName = Account::getZohoIdFieldName();

		$zohoId = $this->getZohoId();
		$mtsNumber = $this->getMtsNumber();
		$subject = mysql_real_escape_string($this->getSubject());
		$zohoStatus = mysql_real_escape_string($this->getZohoStatus());
		$subtotal = $this->getSubtotal();
		$createdDateTime = $this->getCreatedDateTime();

		$accountZohoId = $this->getAccount()->getZohoId();


		$sql = "INSERT INTO `$buybackDbTable`(`$buybackZohoIdFieldName`, `mtsNumber`, `subject`, `zohoStatus`, `subtotal`, `createdDateTime`, `accountId`) VALUES ('$zohoId', '$mtsNumber', '$subject', '$zohoStatus', '$subtotal', '$createdDateTime', (SELECT `id` FROM `$accountDbTable` WHERE `$accountZohoIdFieldName`='$accountZohoId')) ON DUPLICATE KEY UPDATE `mtsNumber`='$mtsNumber', `subject`='$subject', `zohoStatus`='$zohoStatus', `subtotal`='$subtotal', `accountId`=(SELECT `id` FROM `$accountDbTable` WHERE `$accountZohoIdFieldName`='$accountZohoId');";

		return $sql;
	}

	public function generateBuybacksLineItemsDeleteQuery() {
		$zohoId = $this->getZohoId();

		$query = BuybackLineItem::generateBuybacksLineItemsDeleteQuery($zohoId);

		return $query;
	}

	public function generateBuybackLineItemsInsertQueries() {
		$hasDbId = $this->populateDbId();
		if (!$hasDbId) {
			return false;
		}

		$buybackId = $this->getDbId();

		$lineItems = $this->getLineItems();

		$queries = array();

		foreach ($lineItems as $lineItem) {
			$sql = $lineItem->generateBuybackLineItemsInsertQuery($buybackId);
			if ($sql) {
				array_push($queries, $sql);
			}
		}
		return $queries;
	}

	public static function getBuybacksDbTable() {
		return self::$buybackDbTable;
	}

	public static function getZohoIdFieldName() {
		return self::$zohoIdFieldName;
	}

	public static function generateMarkOldBuybacksInactiveQuery($zohoIds) {
		$buybacksTable = self::getBuybacksDbTable();
		$zohoIdField = self::getZohoIdFieldName();

		$zohoIdString = implode("', '", $zohoIds);

		$sql = "UPDATE `$buybacksTable` SET `active`='0' WHERE `$zohoIdField` NOT IN ('$zohoIdString');";
		return $sql;
	}
}

?>
