<?php

require_once(HTML_FOLDER . "classes/Generic/Datasets/Account.php");
require_once(HTML_FOLDER . "classes/Generic/Datasets/LineItem.php");
class BuybacksService {

	public static function getActiveBuybacksFromZoho() {
		global $zohoObj;
		$activeBuybacks = $zohoObj->getActiveBuybacks();
		return $activeBuybacks;
	}

	public static function getActiveBuybacks() {
		$db = new Database;

		$buybackDbTable = Buyback::getBuybacksDbTable();
		$buybackZohoIdField = Buyback::getZohoIdFieldName();

		$lineItemsDbTable = LineItem::getLineItemDbTable();
		$lineItemsZohoIdField = LineItem::getZohoIdFieldName();

		$accountsDbTable = Account::getAccountDbTable();
		$accountsZohoIdField = Account::getZohoIdFieldName();

		$buybackStatusDbTable = BuybackStatus::getBuybackStatusesDbTable();

		$buybackLineItemsJoinTable = BuybackLineItem::getBuybackLineItemJoinTable();


		$sql = "SELECT
					bb.`id` AS bb_dbId,
					bb.`$buybackZohoIdField` AS bb_zohoId,
					bb.mtsNumber AS bb_mtsNumber,
					bb.`subject` AS bb_subject,
					bb.`notes` AS bb_notes,
					bb.`fx` AS bb_fx,
					bb.`gd` AS bb_gd,
					bb.`zohoStatus` AS bb_zohoStatus,
					bb.createdDateTime AS bb_createdDateTime,
					bs.id AS bs_dbId,
					bs.status AS bs_statusName,
					bs.identifier AS bs_statusIdentifier,
					oa.id AS oa_dbId,
					oa.`$accountsZohoIdField` AS oa_zohoId,
					oa.name AS oa_name, oll.id AS li_dbId,
					oll.`$lineItemsZohoIdField` AS li_zohoId,
					oll.name AS li_name,
					oll.code AS li_code,
					bbll.quantity AS li_quantity,
					bbll.description AS li_description
				FROM `$buybackDbTable` AS bb
				LEFT JOIN `$buybackStatusDbTable` AS bs ON bb.statusId = bs.id
				LEFT JOIN `$accountsDbTable` AS oa ON bb.accountId = oa.id
				LEFT JOIN `$buybackLineItemsJoinTable` AS bbll ON bb.id = bbll.buyback_id
				LEFT JOIN `$lineItemsDbTable` AS oll ON bbll.line_item_id = oll.id
				WHERE bb.active='1';";

		$results = $db->db_query($sql, 'select-multiple', true);

		if ($_GET['debug'] == 'yes') {
			// echo "<pre>";
			// print_r($results);
			// echo "</pre>";
		}

		$buybacks = array();
		foreach ($results as $result) {
			$buybackZohoId = $result['bb_zohoId'];

			if (!$buybacks[$buybackZohoId]) {
				$bbData = new stdClass;
				$bbData->dbId = $result['bb_dbId'];
				$bbData->zohoId = $result['bb_zohoId'];
				$bbData->mtsNumber = $result['bb_mtsNumber'];
				$bbData->subject = $result['bb_subject'];
				$bbData->notes = $result['bb_notes'];
				$bbData->fx = $result['bb_fx'];
				$bbData->gd = $result['bb_gd'];
				$bbData->zohoStatus = $result['bb_zohoStatus'];
				$bbData->createdDateTime = $result['bb_createdDateTime'];
				$bbData->accountDbId = $result['oa_dbId'];
				$bbData->accountZohoId = $result['oa_zohoId'];
				$bbData->accountName = $result['oa_name'];
				$bbData->statusDbId = $result['bs_dbId'];
				$bbData->statusName = $result['bs_statusName'];
				$bbData->statusIdentifier = $result['bs_statusIdentifier'];
				$buybacks[$buybackZohoId] = new Buyback($bbData, true);
			}

			$lineItemData = new stdClass;
			$lineItemData->dbId = $result['li_dbId'];
			$lineItemData->zohoId = $result['li_zohoId'];
			$lineItemData->name = $result['li_name'];
			$lineItemData->code = $result['li_code'];
			$lineItemData->description = $result['li_description'];
			$lineItemData->quantity = $result['li_quantity'];

			$currentBuyback = $buybacks[$buybackZohoId];
			$currentBuyback->addLineItem($lineItemData);

			$buybacks[$buybackZohoId] = $currentBuyback;
		}

		$buybacks = array_values($buybacks);

		if ($_GET['debug'] == 'yes') {
			echo "<pre>";
			print_r($buybacks);
			echo "</pre>";
		}

		return $buybacks;
	}

	public static function parseDbResults($results) {
		$rawBuybackData = array();

	}

	public static function getBuybackStatuses() {
		$db = new Database;
		$sql = "SELECT * FROM `buyback_statuses` ORDER BY `id` ASC;";
		$results = $db->db_query($sql, 'select-multiple', true);
		$statuses = array();
		foreach ($results as $result) {
			$result = (object)$result;
			array_push($statuses, new BuybackStatus($result));
		}
		return $statuses;
	}

	public static function parseActiveBuybackRecords($records) {
		$lineItems = self::getDistinctLineItemsFromRecords($records);
		$accounts = self::getDistinctAccountsFromRecords($records);
		$buybacks = self::parseActiveBuybacks($records);
		echo "<pre>";
		print_r($buybacks);
		echo "</pre>";

		$parsedData = new stdClass;
		$parsedData->lineItems = $lineItems;
		$parsedData->accounts = $accounts;
		$parsedData->buybacks = $buybacks;

		return $parsedData;
	}

	public static function parseActiveBuybacks($activeBuybacks) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$buybacks = array();
		foreach ($activeBuybacks as $recordData) {
			$buyback = new Buyback ($recordData);
			array_push($buybacks, $buyback);
		}

		return $buybacks;
	}

	public static function performBuybackInsertions($buybacks) {
		foreach ($buybacks as $buyback) {
			self::insertIntoBuybacksTable($buyback);
			// self::deleteBuybackLineItems($buyback);
			self::insertIntoBuybackLineItemsTable($buyback);
		}
	}

	public static function markOldBuybacksInactive($buybacks) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$zohoIds = array();
		foreach ($buybacks as $buyback) {
			$zohoId = $buyback->getZohoId();
			array_push($zohoIds, $zohoId);
		}
		$sql = Buyback::generateMarkOldBuybacksInactiveQuery($zohoIds);
		$db->db_query($sql, 'update', true);
	}

	private static function insertIntoBuybacksTable($buyback) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$dbTable = Buyback::getBuybacksDbTable();

		$db->resetAutoIncrement($dbTable);
		$buybacksTableInsertQuery = $buyback->generateBuybacksTableInsertQuery();
		echo "<pre>";
		echo "$buybacksTableInsertQuery\n";
		echo "</pre>";
		$db->db_query($buybacksTableInsertQuery, "insert", true);
		$db->resetAutoIncrement($dbTable);

	}

	private static function deleteBuybackLineItems($buyback) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$buybacksLineItemsDeleteQuery = $buyback->generateBuybacksLineItemsDeleteQuery();
		echo "<pre>";
		echo "$buybacksLineItemsDeleteQuery\n";
		echo "</pre>";
		$db->db_query($buybacksLineItemsDeleteQuery, "insert", true);
	}

	private static function insertIntoBuybackLineItemsTable($buyback) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$buybacksLineItemsInsertQueries = $buyback->generateBuybackLineItemsInsertQueries();
		foreach ($buybacksLineItemsInsertQueries as $buybacksLineItemsInsertQuery) {
			echo "<pre>";
			echo "$buybacksLineItemsInsertQuery\n";
			echo "</pre>";
			$db->db_query($buybacksLineItemsInsertQuery, "insert", true);
		}
	}

	public static function getBuybackDatabaseId($zohoId) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$buybacksTable = Buyback::getBuybacksDbTable();

		$sql = "SELECT `id` FROM `$buybacksTable` WHERE `zohoId`='$zohoId';";
		$result = $db->db_query($sql, 'select-single', true);
		$id = $result['id'];
		return $id;
	}

	/* Account functions start */

	public static function getDistinctAccountsFromRecords($records) {
		$accounts = array();
		foreach ($records as $record) {
			$recordAccount = $record->account;
			$accountZohoId = $recordAccount->zohoId;
			$accountName = $recordAccount->name;
			if (!$accounts[$accountZohoId]) {
				$accountData = new stdClass;
				$accountData->zohoId = $accountZohoId;
				$accountData->name = $accountName;
				$account = new Account($accountData);

				$accounts[$accountZohoId] = $account;
			}
		}
		return $accounts;
	}

	public static function getExistingAccountsFromZohoIdList($zohoIds) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = Account::getAccountDbTable();

		$zohoIdString = implode("', '", $zohoIds);

		$sql = "SELECT * FROM `$dbTable` WHERE `zoho_id` IN ('$zohoIdString');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$accounts = array();
		foreach ($results as $result) {
			$account = new Account($result);

			$accounts[$account->zoho_id] = $account;
		}
		return $accounts;
	}

	public static function getNewOrModifiedAccounts($passedAccounts) {
		$existingAccounts = self::getExistingAccountsFromZohoIdList(array_keys($passedAccounts));

		$newOrModifiedAccounts = array();

		foreach ($passedAccounts as $passedAccount) {
			$zohoId = $passedAccount->getZohoId();;
			$name = $passedAccount->getName();

			if (!$existingAccounts[$zohoId]) {
				$newOrModifiedAccounts[$zohoId] = $passedAccount;
			}
			else {
				$existingAccount = $existingAccounts[$zohoId];
				if ($name != $existingAccount->getName()) {
					$newOrModifiedAccounts[$zohoId] = $passedAccount;
				}
			}
		}

		return $newOrModifiedAccounts;
	}

	public static function insertAccountsIntoDatabase($accounts) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;
		$dbTable = Account::getAccountDbTable();

		$db->resetAutoIncrement($dbTable);
		foreach ($accounts as $account) {
			$sql = $account->generateAccountInsertQuery();
			echo "<pre>";
			echo "$sql\n";
			echo "<pre>";
			$db->db_query($sql, 'insert', true);
			$db->resetAutoIncrement($dbTable);
		}
	}

	/* Account functions end */

	/* Line Item Functions start */

	public static function getDistinctLineItemsFromRecords($records) {
		$lineItems = array();
		foreach ($records as $record) {
			$recordLineItems = $record->lineItems;
			foreach ($recordLineItems as $recordLineItem) {
				$itemZohoId = $recordLineItem->zohoId;
				$itemCode = $recordLineItem->code;
				$itemName = $recordLineItem->name;
				if (!$lineItems[$itemZohoId]) {
					$itemData = new stdClass;
					$itemData->zohoId = $itemZohoId;
					$itemData->code = $itemCode;
					$itemData->name = $itemName;

					$lineItem = new LineItem($itemData);

					$lineItems[$itemZohoId] = $lineItem;
				}
			}
		}
		return $lineItems;
	}

	public static function getExistingLineItemsFromZohoIdList($zohoIds) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$dbTable = LineItem::getLineItemDbTable();

		$zohoIdString = implode("', '", $zohoIds);


		$sql = "SELECT `zoho_id`, `name`, `code` FROM `$dbTable` WHERE `zoho_id` IN ('$zohoIdString');";
		$results = $db->db_query($sql, 'select-multiple', true);
		$lineItems = array();
		foreach ($results as $result) {
			$lineItem = new LineItem($result);
			$lineItems[$lineItem->zohoId] = $lineItem;
		}
		return $lineItems;
	}

	public static function getNewOrModifiedLineItems($passedLineItems) {
		$existingLineItems = self::getExistingLineItemsFromZohoIdList(array_keys($passedLineItems));

		$newOrModifiedLineItems = array();

		foreach ($passedLineItems as $passedLineItem) {
			$zohoId = $passedLineItem->getZohoId();
			$name = $passedLineItem->getName();
			$code = $passedLineItem->getCode();

			if (!$existingLineItems[$zohoId]) {
				$newOrModifiedLineItems[$zohoId] = $passedLineItem;
			}
			else {
				$existingLineItem = $existingLineItems[$zohoId];
				if ($name != $existingLineItem->getName() || $code != $existingLineItem->getCode()) {
					$newOrModifiedLineItems[$zohoId] = $passedLineItem;
				}
			}
		}

		return $newOrModifiedLineItems;
	}

	public static function insertLineItemsIntoDatabase($lineItems) {
		require_once(HTML_FOLDER . "class_database.php");
		$db = new Database;

		$lineItemTable = LineItem::getLineItemDbTable();
		$db->resetAutoIncrement($lineItemTable);

		foreach ($lineItems as $lineItem) {
			$lineItem->save();

			// $sql = $lineItem->generateLineItemInsertQuery();

			// $db->db_query($sql, 'insert', true);
			// $db->resetAutoIncrement($lineItemTable);
		}
	}

	/* Line Item Functions end */

	public static function saveBuybackChanges($data) {
		$db = new Database;
		$dbId = $data->dbId;
		$notes = mysql_real_escape_string($data->fields->notes);
		$statusId = $data->fields->statusId;
		$fx = $data->fields->fx;
		$gd = $data->fields->gd;

		$buybackDbTable = Buyback::getBuybacksDbTable();

		if ($statusId) {
			$sql = "UPDATE `$buybackDbTable` SET `statusId`='$statusId', `notes`='$notes', `fx`='$fx', `gd`='$gd' WHERE `id`='$dbId';";
		}
		else {
			$sql = "UPDATE `$buybackDbTable` SET `notes`='$notes', `fx`='$fx', `gd`='$gd' WHERE `id`='$dbId';";
		}
		return $db->db_query($sql, 'update');
	}
}

?>
