<?php

require_once(HTML_FOLDER . 'classes/Buybacks/Datasets/Buyback.php');
require_once(HTML_FOLDER . 'classes/Buybacks/Datasets/BuybackLineItem.php');
require_once(HTML_FOLDER . 'classes/Buybacks/BuybacksService.php');
class BuybacksController {

	public static function buybacksDashboard() {
		$admin = new Admin;
		$title = "Active Buybacks";
		$templateElements = array(
			"SCRIPTS" => 	/* IMPORT_JQUERY .
							IMPORT_JQUERY_UI . */
							'<script src="__CDN_JAVASCRIPT__javascript/column_definition/column_definition.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/datasets/LineItem.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/datasets/Status.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/datasets/Account.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/datasets/Buyback.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/pageElements/TableTemplate.js" type="text/javascript"></script>
							<script src="__CDN_JAVASCRIPT__javascript/buybacks/buybacksDashboardController.js" type="text/javascript"></script>'
		);

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse(BUYBACKS_DASHBOARD, $templateElements), "TITLE" => $title));
	}

	public static function getActiveBuybacks() {

		$activeBuybacks = BuybacksService::getActiveBuybacks();
		$buybackStatuses = BuybacksService::getBuybackStatuses();
		$returnData = new stdClass;
		$returnData->activeBuybacks = $activeBuybacks;
		$returnData->statuses = $buybackStatuses;
		return $returnData;
	}

	public static function refreshActiveBuybacks() {
		$debug = false;
		if ($_GET['debug']=='yes') {
			$debug = true;
		}
		$activeBuybackRecords = BuybacksService::getActiveBuybacksFromZoho();

		$parsedRecords = BuybacksService::parseActiveBuybackRecords($activeBuybackRecords);

		$accounts = BuybacksService::getNewOrModifiedAccounts($parsedRecords->accounts);
		$lineItems = BuybacksService::getNewOrModifiedLineItems($parsedRecords->lineItems);
		$buybacks = $parsedRecords->buybacks;

		if ($debug) {
			echo "<pre>";
			echo "======= BUYBACKS ========\n";
			print_r($buybacks);
			echo "======= LINEITEMS ========\n";
			print_r($lineItems);
			echo "======= ACCOUNTS ========\n";
			print_r($accounts);
			echo "======= QUERIES ========\n";
			echo "</pre>";
		}
		if ($lineItems && count($lineItems) > 0) {
			BuybacksService::insertLineItemsIntoDatabase($lineItems);
		}
		if ($accounts && count($accounts) > 0) {
			BuybacksService::insertAccountsIntoDatabase($accounts);
		}
		BuybacksService::performBuybackInsertions($buybacks);
		BuybacksService::markOldBuybacksInactive($buybacks);
	}

	public static function saveBuybackChanges($buybackData) {
		try {
			BuybacksService::saveBuybackChanges($buybackData);
			return true;
		}
		catch (Exception $e) {
			return false;
		}
	}
}

?>
