<?php

use chillerlan\QRCode\Output\QRImage;
use chillerlan\QRCode\Output\QRMarkup;
use chillerlan\QRCode\Output\QRMarkupOptions;
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

class AuthenticationService {
	private static $title = "TTS Backend";
	private static $keepAlive = 10 * 60; // 10 minutes

	public static function generateSecretKeyTest() {
		$google2fa = new PragmaRX\Google2FA\Google2FA();

		$userSecret = $google2fa->generateSecretKey();


		$title = "techtoschool.com";
		$usernameOrEmail = "m.kemper";

		$qrCodeData = $google2fa->getQRCodeUrl(
			$title,
			$usernameOrEmail,
			$userSecret
		);



		echo '<img src="'.(new QRCode($qrCodeData, new QRImage))->output().'" />';

	}

	public static function validateCode($username, $code) {
		$userSecret = self::retrieveSecretKey($username);

		$google2fa = new PragmaRX\Google2FA\Google2FA();

		$valid = $google2fa->verifyKey($userSecret, $code);


		return $valid;
	}

	public static function generateQrCode($username) {
		return self::generateQrCodeImage(self::generateQrCodeUrl($username));
	}

	public static function generateQrCodeImage($qrCodeUrl) {
		return '<img src="'.(new QRCode($qrCodeUrl, new QRImage))->output().'" />';
	}

	public static function generateQrCodeUrl($username) {
		$google2fa = new PragmaRX\Google2FA\Google2FA();

		$title = self::$title;

		$secretKey = self::retrieveSecretKey($username);

		if (!$secretKey) {
			$secretKey = self::generateSecretKey();
			self::saveSecretKeyToDb($username, $secretKey);
		}

		$qrCodeUrl = $google2fa->getQRCodeUrl(
			$title,
			$username,
			$secretKey
		);

		return $qrCodeUrl;
	}

	private static function retrieveSecretKey($username) {
		$db = new Database;

		$sql = "SELECT `2faSecretKey` FROM `ds_admins` WHERE `aUser`='$username' LIMIT 1;";

		$result = $db->db_query($sql, 'select-single');
		if ($result['2faSecretKey']) {
			return EncryptionController::decryptString($result['2faSecretKey']);
		}
		else {
			return null;
		}
	}

	private static function saveSecretKeyToDb($username, $secretKey) {
		$db = new Database;

		$encryptedKey = mysql_real_escape_string(EncryptionController::encryptString($secretKey));

		$sql = "UPDATE `ds_admins` SET `2faSecretKey`='$encryptedKey' WHERE `aUser`='$username';";
		$db->db_query($sql, 'update');
	}

	private static function generateSecretKey() {
		$google2fa = new PragmaRX\Google2FA\Google2FA();

		$userSecret = $google2fa->generateSecretKey();

		return $userSecret;

		// $username = $_SESSION['aUser'];
		// $title = "TTS Backend";

		// $qrCodeData = $google2fa->getQRCodeUrl(
		// 	$title,
		// 	$username,
		// 	$userSecret
		// );
	}

	public static function checkIfAuthCurrent() {
		$authTime = $_SESSION['2fa'];

		if (!$authTime) {
			return false;
		}

		$keepAliveTime = self::$keepAlive;
		$diff = time() - $authTime;
		if ($diff < $keepAliveTime) {
			return true;
		}
		else {
			return false;
		}
	}

	public static function checkIfUserHasAccess($action, $userString) {
		$escapedAction = mysql_real_escape_string($action);
		$escapedUserString = mysql_real_escape_string($action);
		$actionIsModule = self::checkIfActionIsModule($action);

		if ($actionIsModule) {
			$db = new Database;

			$adminDbTable = 'ds_admins';
			$moduleDbTable = 'module';
			$joinTable = 'ds_admin_modules';

			$sql = "SELECT dsam.ds_admin_modules_id AS moduleId FROM `$adminDbTable` AS dsa LEFT JOIN `$joinTable` AS dsam ON dsa.aID = dsam.aID LEFT JOIN `$moduleDbTable` AS mods ON dsam.module_id = mods.module_id WHERE dsa.aString = '$escapedUserString' AND mods.module_method = '$escapedAction';";

			$result = $db->db_query($sql, 'select-single');

			if ($result['moduleId']) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return true;
		}
	}

	private static function checkIfActionIsModule($action) {
		$escapedAction = mysql_real_escape_string($action);
		$moduleDbTable = 'module';

		$db = new Database;

		$sql = "SELECT `module_id` FROM `module` WHERE `module_method`='$escapedAction';";

		$result = $db->db_query($sql, 'select-single');

		if ($result['module_id']) {
			return true;
		}
		else {
			return false;
		}
	}
}

?>
