<?php

class AuthenticationController {
	public static function checkIfActionRequiresAuth($action) {
		$db = new Database;
		$dbTable = 'module';

		$sql = "SELECT `requires_2fa` FROM `$dbTable` WHERE `module_method`='$action';";
		$result = $db->db_query($sql, 'select-single', true);
		if ($result['requires_2fa'] && $result['requires_2fa'] == '1') {
			return true;
		}
		else {
			return false;
		}
	}

	public static function checkIfCurrentUserHasAccess($action) {
		$userString = $_SESSION['xdigiSHOPadmin'];
		return AuthenticationService::checkIfUserHasAccess($action, $userString);
	}

	public static function renderQrCodePage() {
		$admin = new Admin;
		$title = "QR Code";
		$template = file_get_contents(HTML_FOLDER . "templates/2fa/qrCodePage.html");
		$scripts = '<script src="__CDN_JAVASCRIPT__javascript/2fa/qrCodePage.js" type="text/javascript"></script>';
		$qrCode = self::generateQrCode();
		$templateElements = array(
			'QRCODE' => $qrCode,
			'SCRIPTS' => $scripts
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function renderValidationPage() {
		$admin = new Admin;
		$title = "Auth Validation";
		$template = file_get_contents(HTML_FOLDER . "templates/2fa/validation.html");
		$scripts = '<script src="__CDN_JAVASCRIPT__javascript/2fa/validation.js" type="text/javascript"></script>';
		// $qrCode = self::generateQrCode();
		$templateElements = array(
			// 'QRCODE' => $qrCode,
			'SCRIPTS' => $scripts
		);
		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function generateSecretKeyTest() {
		AuthenticationService::generateSecretKeyTest();
	}

	public static function generateQrCode() {
		$allowedUsers = array(
			'm.kemper',
			'justin',
			'robert'
		);
		$username = $_SESSION['aUser'];
		if (in_array($username, $allowedUsers)) {
			return AuthenticationService::generateQrCode($username);
		}
		else {
			return '';
		}
	}

	public static function checkIfAuthCurrent() {
		return AuthenticationService::checkIfAuthCurrent();
	}

	public static function validateKey($username, $code) {
		return AuthenticationService::validateCode($username, $code);
	}
}

?>
