<?php

class AuditService {
	public static function getSkuByIdentifier($configCode) {
		$db = new Database;

		$sql = "SELECT mon.order_number AS sku FROM product_model AS pm LEFT JOIN machine_order_number AS mon ON pm.order_number_id = mon.order_number_id WHERE pm.configCode = '$configCode' LIMIT 1;";
		$result = $db->db_query($sql, 'select-single', true);
		$sku = $result['sku'];
		return $sku;
	}

	public static function verifyPoNumber($poNumber) {
		$db = new Database;

		$sql = "SELECT `order_id` FROM `po_orders` WHERE `order_number`='$poNumber' AND `status_id` IN ('1', '2');";
		echo $sql;
		$result = $db->db_query($sql, 'select-single', true);
		$orderId = $result['order_id'];
		return $orderId;
	}

	public static function deviceReceivingSubmit($data) {
		$submitStart = microtime(true);

		$admin = new Admin;
		$configCode = $data->configCode;
		$poNumber = $data->poNumber;
		$ssd = $data->ssd;
		$ram = $data->ram;
		$serialNumbers = $data->serialNumbers;
		if ($data->printer != 'DNP') {
			$printer = constant($data->printer);
		}
		else {
			$printer = 'DNP';
		}
		$grade = 'A';
		$machineInfoQuery = "SELECT mon.order_number, ml.machine_description FROM product_model AS pm LEFT JOIN machine_order_number AS mon ON pm.order_number_id = mon.order_number_id LEFT JOIN machine_lookup AS ml ON mon.machine_id = ml.machine_id WHERE pm.configCode = '$configCode' LIMIT 1;";
		$machineInfo = $admin->db_query($machineInfoQuery, 'select-single', false);


		foreach ($serialNumbers as $serialNumber) {
			$serialStart = microtime(true);
			$auditData = array(
				'serialNumber' => $serialNumber,
				'poNumber' => $poNumber,
				'os_version' => 'Other',
				'ram_1' => $ram,
				'hd_1' => $ssd,
				'machineType' => $machineInfo['machine_description'],
				'order_number' => $machineInfo['order_number'],
				'identifier' => $configCode,
				'cStatus' => STATUS_REFURB_AUDITED,
				'grade' => $grade
			);
			// print_r($auditData);
			$oNum = $admin->parse_audit_response($auditData);

			$printData = $admin->db_select_single('ds_orders', '*', array('serialNumber' => trim($serialNumber)));

			if ($printer != 'DNP') {
				$admin->print_retail_label($printData,$printer,1);
			}

			$serialEnd = microtime(true);
			$serialInterval = ($serialEnd - $serialStart);
			echo "Total time to insert $oNum ($serialNumber): $serialInterval sec\n";
		}

		$submitEnd = microtime(true);
		$submitInterval = ($submitEnd - $submitStart);
		echo "Total submit time: $submitInterval sec\n";
	}
}

?>
