<?php

ini_set("memory_limit","1000M");
ini_set('max_execution_time', 7200); //5 minutes
require './invoice_lib/vendor/autoload.php';

class zohoinvoice {

    private $organization_id;
    private $access_token;
    private $auth_token;

    public function __construct($token,$org_id) 
    {
        $this->organization_id = $org_id;
        $this->auth_token = $token;
        ZBooksRestClient::initialize();
        $this->access_token= (new ZBOOKSConfigUtil())->BooksgetAccessToken();
//        $oAuthClient = BooksZohoOAuth::getClientInstance();
//        print_r($oAuthClient);
//        $grantToken = "1000.0adb430e854b724e1d0f34fe48168e8e.6c19a712e94ad57a4815f9740322ef0d";
//        echo "new tokens<br>/n";
//        $oAuthTokens = $oAuthClient->generateAccessToken($grantToken);
//        print_r($oAuthTokens);

    }

    
    public function check_existing_contact($email)
    {
        $url = "https://invoice.zoho.com/api/v3/contacts?organization_id=".$this->organization_id."&email=".$email;
        $response = $this->zoho_get($url);
                
        $jd = json_decode($response,true);
        
        if(!isset($jd['contacts'][0]['contact_id']))
        {
//            echo "Contact Record does not already exist";
            return false;
        }
        else
        {
//            echo "Contact Record already exist";
            return $jd['contacts'][0]['contact_id'];
        }

    }
    
    public function insert_contact($account)
    {
        $url = "https://invoice.zoho.com/api/v3/contacts?organization_id=".$this->organization_id;
        
        $json = 'JSONString={
                "contact_name": "'.$account->account_name.'",
                "company_name": "'.$account->school_district_name.'",
                "payment_terms": 30,
                "payment_terms_label": "Net 30",
                "billing_address": {
                  "address": "'.$account->address.'",
                  "city": "'.$account->city.'",
                  "state": "'.$account->state.'",
                  "zip": "'.$account->zip.'",
                  "fax": "'.$account->fax.'"
                },
                "shipping_address": {
                  "address": "'.str_replace("null","",$account->ship_street).'",
                  "city": "'.str_replace("null","",$account->ship_city).'",
                  "state": "'.str_replace("null","",$account->ship_state).'",
                  "zip": "'.str_replace("null","",$account->ship_code).'"            
                      },
                "contact_persons": [
                  {
                    "salutation": "'.$account->title.'",
                    "first_name": "'.$account->fname.'",
                    "last_name": "'.$account->lname.'",
                    "email": "'.$account->email.'",
                    "phone": "'.$account->phone.'",
                    "is_primary_contact": true
                  }
                ],
              }';
//        print_r($json);
        $response = $this->zoho_post($url,$json);
//        print_r($response);
        $jd = json_decode($response,true);
        if($jd['message'] == 'The contact has been added.')
        {
//            echo "Contact inserted<br>";
            return $jd['contact']['contact_id'];
        }
        else 
        {
//            echo "Contact not inserted<br>";
            return false;
        }
    }
    
    public function get_primary_contact_id($id)
    {
        $url = "https://invoice.zoho.com/api/v3/contacts/".$id."?organization_id=".$this->organization_id;
        $response = $this->zoho_get($url);
        
        $jd = json_decode($response,true);
        if(!isset($jd['contact']['primary_contact_id']))
        {
//            echo "Record primary contact not found";
            return false;
        }
        else
        {
//            echo "Record primary contact found" . $jd['contact']['primary_contact_id'];
            return $jd['contact']['primary_contact_id'];
        }
   
    }
    
    public function check_existing_item($code)
    {

        $url = "https://invoice.zoho.com/api/v3/items?organization_id=".$this->organization_id."&name=".urlencode($code);
//        echo $url;
        $response = $this->zoho_get($url);
        $jd = json_decode($response,true);
//        print_r($jd);
        if(!isset($jd['items'][0]['item_id']))
        {
//            echo "Item Record does not already exist " . $code . "<br>";
            return false;
        }
        else
        {
//            echo "Item Record already exist";
            return $jd['items'][0]['item_id'];
        }

    }
        
    public function insert_item($item)
    {
        $url = "https://invoice.zoho.com/api/v3/items?organization_id=".$this->organization_id; 
        $name = str_replace('"','\"',$item->name);
        $name = str_replace('/','\/',$name);
        $name = str_replace('&','%26',$name);
        $name = str_replace('(','%28',$name);
        $name = str_replace(')','%29',$name);
        $code = str_replace('"','\"',$item->code);
        $code = str_replace('/','\/',$code);
        $code = str_replace('&','%26',$code);
        $code = str_replace('(','%28',$code);
        $code = str_replace(')','%29',$code);

        $json = 'JSONString={
                    "name": "'.$code.'",
                    "description": "'.$name.'",
                    "rate": '.$item->unit_price.',
                        }';
//         print_r($json);
        $response = $this->zoho_post($url,$json);
//        print_r($response);
        $jd = json_decode($response,true);
        if($jd['message'] == 'The item has been added.')
        {
            return $jd['item']['item_id'];
        }
        else 
        {
            return false;
        }
         
    }
    
    public function get_product_string($line_items)
    {
        
        $product_string = '';
        foreach($line_items as $product)
        {
            
            $invoice_item_id = $this->check_existing_item($product->code);
            
            if(!$invoice_item_id)
            {
                $invoice_item_id = $this->insert_item($product);
            }
            
            $name = str_replace('"','\"',$product->name);
            $name = str_replace('/','\/',$name);
            $name = str_replace('&','%26',$name);
            $name = str_replace('(','%28',$name);
            $name = str_replace(')','%29',$name);
            $code = str_replace('"','\"',$product->code);
            $code = str_replace('/','\/',$code);
            $code = str_replace('&','%26',$code);
            $code = str_replace('(','%28',$code);
            $code = str_replace(')','%29',$code);
            
            $product_string .= '{
              "item_id": '.$invoice_item_id.',
              "name": "'.$code.'",
              "description": "'.$name.'",
              "rate": '.$product->list_price.',
              "quantity": '.$product->quantity.',
              "discount": '.$product->discount.'
            },';
//              "description": "'.$name.'",
 
        }
        return $product_string;
    }
    
    public function get_currencies()
    {
        $url = "https://invoice.zoho.com/api/v3/settings/currencies?organization_id=".$this->organization_id;
        $response = $this->zoho_get($url);
        
        $jd = json_decode($response,true);
//        print_r($jd);
        if(!isset($jd['currencies']))
        {
            
        }
        
    }

    
    public function activate_contact($contact_id)
    {
        $url = "https://invoice.zoho.com/api/v3/contacts/".$contact_id."/active?organization_id=".$this->organization_id;
        $response = $this->zoho_post($url,'');
//        print_r($response);
    }
    
    
    
    public function insert_invoice($contact_id,$zohoinvoice_primary_contact,$invoice,$line_items)
    {
        $url = "https://invoice.zoho.com/api/v3/invoices?organization_id=".$this->organization_id; 
        $json = 'JSONString={
                "customer_id": '.$contact_id.',
                "contact_persons": ["'.$zohoinvoice_primary_contact.'"],    
                "invoice_number": '.$invoice->mts_quote_number.',
                "date": "'.$invoice->ship_date.'",
                "payment_terms": 30,
                "payment_terms_label": "Net 30",
                "discount": '.$invoice->discount.',
                "is_discount_before_tax": true,
                "salesperson_name": '.$invoice->invoice_owner.',
                "custom_fields": [
                  {
                    "index": 2,
                    "value":  "'.$invoice->purchase_order.'"
                  }
                ],
                "line_items": [
                  '.$line_items.'
                ],
                "terms": "Terms and conditions apply",
                "shipping_charge": 0.00,
                "adjustment": '.$invoice->adjustment.'
                        }';
//        print_r($json);
        $response = $this->zoho_post($url,$json);
        print_r($response);
        $jd = json_decode($response,true);
        if($jd['message'] == 'The invoice has been created.')
        {
            return $jd['invoice']['invoice_id'];
        }
        else 
        {
            return false;
        }        
    }
    
    public function upload_documents($attachments,$invoice_id)
    {
        try{

//            $apiResponse=ZCRMModule::getInstance('Invoices')->getRecord($invoice_id); 
            $record = ZBooksRecord::getInstance("invoices", $invoice_id);
//            $record=$apiResponse->getData();
//            print_r($record);
        }
        catch (ZCRMException $e)
        {
        print_r($e);    
        }
                
//        print_r($record);
        foreach($attachments as $local_filename => $attachment_filename) 
        {
            if(is_file($local_filename)) 
            {
                try
                {                    
                    $entityResponse=$record->uploadAttachment(realpath($local_filename));
                    unlink($local_filename);
                }
                catch (ZCRMException $e)
                {
                print_r($e);    
                }
                
            }
        }
    }

    
    public function upload_documents_old($attachments,$invoice_id)
    {
        $url = "https://invoice.zoho.com/api/v3/invoices/".$invoice_id."/attachment?organization_id=".$this->organization_id;
        echo $url;
        foreach($attachments as $local_filename => $attachment_filename) 
        {
            if(is_file($local_filename)) 
            {
                echo realpath($local_filename);
                    $fileSize = filesize($local_filename);

                        $cFile = '@' . realpath($local_filename);
			$postfields = array('attachment'=> $cFile);
				

//                    $postfields = array("file" => "@".realpath($local_filename));
                    $headers = array("Content-Type: multipart/form-data","Authorization: Zoho-oauthtoken ".$this->access_token);
                    $ch = curl_init($url);
                    $options = array(
                        CURLOPT_HEADER => false,
                        CURLOPT_POST => 1,
                        CURLOPT_HTTPHEADER => $headers,
                        CURLOPT_POSTFIELDS => $postfields,
                        CURLOPT_INFILESIZE => $fileSize,
                        CURLOPT_RETURNTRANSFER => true,                        
                        CURLOPT_SSL_VERIFYPEER => false,
                        CURLOPT_SSL_VERIFYHOST => false
                    ); // cURL options
                    curl_setopt_array($ch, $options);
                    $result=curl_exec($ch);
//                    print_r($result);
//                unlink($local_filename);
                
            }
        }
    }
    
    public function zoho_post($url,$xml)
    {
        $headers = array("Authorization: Zoho-oauthtoken ".$this->access_token);
        $ch = curl_init($url);
        $options = array(
            CURLOPT_HEADER => false,
            CURLOPT_POST => 1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POSTFIELDS => $xml,
            CURLOPT_RETURNTRANSFER => true,                        
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_HTTPAUTH => CURLAUTH_ANY,
            CURLOPT_CAINFO => getcwd() . '/web'

        ); // cURL options
        curl_setopt_array($ch, $options);
        $result=curl_exec($ch);
        curl_close($ch);
        return $result;
                
    }
    
    
    public function zoho_get($url)
    {        
        $headers = array("Authorization: Zoho-oauthtoken ".$this->access_token);
        $ch = curl_init($url);
        $options = array(
            CURLOPT_HEADER => false,
            CURLOPT_POST => 0,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,                        
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_HTTPAUTH => CURLAUTH_ANY,
            CURLOPT_CAINFO => getcwd() . '/web'
        ); // cURL options
        curl_setopt_array($ch, $options);
        $result=curl_exec($ch);
        curl_close($ch);
//        print_r($result);
        return $result;
        
    }
    
}
?>