<?php

ini_set("memory_limit","1000M");
ini_set('max_execution_time', 72000); //5 minutes
require 'crm_lib/vendor/autoload.php';

class Zoho {

    private $account_id;
	private $contact_id;
	private $deductionPattern = "/(tax|shipping$)/i";

    public function __construct()
    {
        $configuration =array(
            // "client_id"=>'1000.DBOZ7DJ6R7T1OX1UMKCIS33W11JYTH',
            "client_id"=>'1000.2J5BH99EBCUACYNC1S5XSXFNFML4RD',
            // "client_secret"=>'44368e5a4d840a6731e0432807a046bd7d2008d0d6',
            "client_secret"=>'275cff96a8b250b441c599293fe9a906b1c0c1ef40',
            "redirect_uri"=>'https://macservice.local/callback.php',
            // "currentUserEmail"=>'j.sanderson@mactoschool.com',
            "currentUserEmail"=>'developer@techtoschool.com',
            // "token_persistence_path"=>"/Applications/XAMPP/xamppfiles/htdocs/crm_lib/tokens",
            "token_persistence_path"=>"C:/wamp64/www/techtoschool-macservice/crm_lib/tokens",
            "access_type"=>'offline'
        );
		if (MODE == 'DEV') {
			ZCRMRestClient::initialize($configuration);
		}
		else {
			ZCRMRestClient::initialize();
		}
        /* $oAuthClient = ZohoOAuth::getClientInstance();
        // $grantToken = "1000.9289134dec7d4b680011ccda93a07876.73cb67efc50e6580c6218ba26c0a2289";
        $grantToken = "1000.3f96353ec8d3cc628618938e93df0199.837198d5a0607f6d1c3accdfefd6aa08";
        $oAuthTokens = $oAuthClient->generateAccessToken($grantToken);
        print_r($oAuthTokens);exit; */
        // $this->get_all_users();
    }

    public function getSearchRecords()
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("(((Status:equals:PO received) OR (Status:equals:Waiting for PO)))",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data
        //        print_r($records);
        $contacts = array();
            foreach($records as $record)
            {
                $contact = $record->getFieldValue('Contact_Name');
                if($contact != null)
                {
                    $contacts[] = $contact->getEntityId();
                }
            }
        //            print_r($contacts);
            return $contacts;
          }
          catch(ZCRMException $e)
          {
            echo $e->getMessage();
            echo $e->getExceptionCode();
            echo $e->getCode();
          }
    }

	public function getShippedRecordsShippedSinceDate($startDate, $endDate=null) {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$modifiedDate = $startDate->format('Y-m-d');
			$headers['if-modified-since'] = $modifiedDate . "T00:00:00Z";

			$cvId = "835703000075761019"; // Custom view for shipped invoices. See https://crm.zoho.com/crm/org26161413/tab/Invoices/custom-view/835703000075761019/list

			// Gets record response from API. Sort by ship date, descending. Passes header ensuring only grabs items modified after the given date.
            $response = $module->getRecords($cvId, 'Ship_Date', 'desc',null,null,$headers);

			$records = $response->getData();

			$parsedRecords = array(); // Instantiate array to hold parsed records

			foreach ($records as $rawRecord) {

				$shipDate = new DateTime($rawRecord->getFieldValue('Ship_Date'), new DateTimeZone('America/Los_Angeles'));
				if ($startDate > $shipDate) {
					continue;
				}
				if ($endDate !== null && $shipDate > $endDate) {
					continue;
				}

				// Process account data.
				$accountData = $rawRecord->getFieldValue('Account_Name');
				$account = new stdClass;
				if ($accountData) {
					$account->zohoId = $accountData->getEntityId();
					$account->name = $accountData->getLookupLabel();
				}
				else {
					// Default to blank if no data.
					$account->zohoId = '';
					$account->name = '';
				}
				$account = new Account($account);

				// Process contact data.
				$contactData = $rawRecord->getFieldValue('Contact_Name');
				$contact = new stdClass;
				if ($contactData) {
					$contact->zohoId = $contactData->getEntityId();
					$contact->name = $contactData->getLookupLabel();
				}
				else {
					// Default to blank if no data.
					$contact->zohoId = '';
					$contact->name = '';
				}

				// Process potential data.
				$potentialData = $rawRecord->getFieldValue('Potential_Name');
				$potential = new stdClass;
				if ($potentialData) {
					$potential->zohoId = $potentialData->getEntityId();
					$potential->name = $potentialData->getLookupLabel();
				}
				else {
					// Default to blank if no data.
					$potential->zohoId = '';
					$potential->name = '';
				}

				// Process owner data.
				$ownerData = $rawRecord->getOwner();
				$owner = new stdClass;
				$owner->zohoId = $ownerData->getId();
				$owner->name = $ownerData->getName();
				$owner = new Salesperson($owner);

				// Process record data.
				$record = new stdClass;
				$record->zohoId = $rawRecord->getEntityId();
				$record->mtsNumber = $rawRecord->getFieldValue('MTS_Quote_Number');
				$record->subject = $rawRecord->getFieldValue('Subject');
				$record->purchaseOrder = $rawRecord->getFieldValue('Purchase_Order');
				$record->status = $rawRecord->getFieldValue('Status');
				$record->shipDate = new DateTime($rawRecord->getFieldValue('Ship_Date'), new DateTimeZone('America/Los_Angeles'));
				$record->createdTime = $rawRecord->getCreatedTime();
				$record->modifiedTime = $rawRecord->getModifiedTime();

				// Financial data
				$record->subtotal = $rawRecord->getFieldValue('Sub_Total');
				$record->tax = $rawRecord->getFieldValue('Tax');
				$record->adjustment = $rawRecord->getFieldValue('Adjustment');
				$record->grandTotal = $rawRecord->getFieldValue('Grand_Total');
				$record->discount = $rawRecord->getFieldValue('Discount');

				// Billing address data
				$record->billingStreet = $rawRecord->getFieldValue('Billing_Street');
				$record->billingCity = $rawRecord->getFieldValue('Billing_City');
				$record->billingState = $rawRecord->getFieldValue('Billing_State');
				$record->billingCode = $rawRecord->getFieldValue('Billing_Code');

				// Shipment data
				$record->trackingNumbers = array(
					$rawRecord->getFieldValue('Tracking_Number_1'),
					$rawRecord->getFieldValue('Tracking_Number_2'),
					$rawRecord->getFieldValue('Tracking_Number_3'),
					$rawRecord->getFieldValue('Tracking_Number_4'),
					$rawRecord->getFieldValue('Tracking_Number_5')
				);
				$record->shipMethod = $rawRecord->getFieldValue('Ship_Method');
				$record->paid = $rawRecord->getFieldValue('Paid');
				$record->serialNumbers = $rawRecord->getFieldValue('Serial_Number');
				$record->apDataPresent = $rawRecord->getFieldValue('AP_Data_Present');
				$record->invoiced = $rawRecord->getFieldValue('Invoiced');
				$record->tips = $rawRecord->getFieldValue('TIPS');

				$record->account = $account;
				$record->contact = $contact;
				$record->potential = $potential;
				$record->owner = $owner;

				// Parse line items
				$rawLineItems = $rawRecord->getLineItems();
				$parsedLineItems = array();
				foreach ($rawLineItems as $rawLineItem) {
					$product = $rawLineItem->getProduct();

					$lineItem = new stdClass;
					$lineItem->zohoId = $product->getEntityId();
					$lineItem->name = $product->getLookupLabel();
					$lineItem->code = $product->getFieldValue('Product_Code');

					$lineItem->description = $rawLineItem->getDescription();
					$lineItem->quantity = $rawLineItem->getQuantity();
					$lineItem->listPrice = $rawLineItem->getListPrice();
					$lineItem->total = $rawLineItem->getTotal();
					$lineItem->discount = $rawLineItem->getDiscount();
					$lineItem->totalAfterDiscount = $rawLineItem->getTotalAfterDiscount();
					$lineItem->netTotal = $rawLineItem->getNetTotal();
					$lineItem->tax = $rawLineItem->getTaxAmount();
					$lineItem->lineTax = $rawLineItem->getTaxAmount();

					array_push($parsedLineItems, $lineItem);
				}

				$record->lineItems = $parsedLineItems;

			// //                            echo "PID:".$item['Product Id']."</br>";

			// 		$apiResponse_product = ZCRMModule::getInstance('Products')->getRecord($item['Product Id']);
			// 		$product_record = $apiResponse_product->getData();
			// 		$unit_price = $product_record->getFieldValue('Unit_Price');
			// 		$qunatity_in_stock = $product_record->getFieldValue('Qty_in_Stock');
			// 		$product_code = $product_record->getFieldValue('Product_Code');
			// 		$item['Product Name'] = $product_record->getFieldValue('Product_Name');
			// 		if($item['Product Name'] == 'SHIPPING')
			// 		{
			// 			 $item['Shipping']   = $line_item->getTotal();
			// 		}

			// 		$item['Unit Price'] = $unit_price;
			// 		$item['Quantity'] = $line_item->getQuantity();
			// 		$item['Quantity in Stock'] = $qunatity_in_stock;
			// 		$item['Total'] = $line_item->getTotal();
			// 		$item['Discount'] = $line_item->getDiscount();
			// 		$item['Total After Discount'] = $line_item->getTotalAfterDiscount();
			// 		$item['List Price'] = $line_item->getListPrice();
			// 		$item['Net Total'] = $line_item->getNetTotal();
			// 		$item['Tax'] = $line_item->getTaxAmount();
			// 		$item['Line Tax'] = $line_item->getTaxAmount();

			// 		if (!in_array($item['Product Name'], $exclude))
			// 		{

			// 			if ($arg != 'hardware'){
			// 				if ($product_code != '' && $product_code != null){
			// 					$item['Item Number'] = $product_code;
			// 				}else{
			// 					$item['Item Number'] = 'Hardware';
			// 				}
			// 			}else{
			// 				$item['Item Number'] = 'Hardware';
			// 			}

			// 			if ($item['Product Name'] != 'SHIPPING')
			// 			{
			// 				$po_products[] = $item;
			// 			}

			// 		}

			// 		if (isset($item['Shipping'])){
			// 			$po_products[0]['Freight'] =  $item['Shipping'];
			// 			unset($item['Shipping']);
			// 		}

			// 	}

				array_push($parsedRecords, $record);
			}

			$returnData = new stdClass;
			$returnData->raw = $records;
			$returnData->parsed = $parsedRecords;
			return $returnData;

		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getAccountsModifiedSinceDate($modifiedDate=null) {
		try {
			if (!$modifiedDate) {
				// If no modified date passed, default to 2 months ago (2 months * 30 days * 24 hours * 60 minutes * 60 seconds)
				$modifiedDate = date('Y-m-d', time() - (2 * 30 * 24 * 60 * 60));
			}
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Accounts");
			$headers['if-modified-since'] = $modifiedDate . "T00:00:00Z";

			// Instantiate arrays to hold parsed contacts and accounts
			$parsedContacts = array();
			$parsedAccounts = array();

			$pageNumber = 1; // Start on the first page
			$hasMore = true; // Start assuming records exist

			$iterations = 0;
			$totalSoFar = 0;
			while ($hasMore) {
				$iterations++;
				// Gets record response from API.
				$response = $module->getRecords(null, null, null, 1, 200, $headers);
				// Get info
				$info = $response->getInfo();
				$totalSoFar += $info->getRecordCount();
				// Get data
				$rawAccounts = $response->getData();

				// Iterate over records
				foreach ($rawAccounts as $rawAccount) {
					$accountData = new stdClass;
					$accountData->zohoId = $rawAccount->getEntityId();
					$accountData->name = $rawAccount->getFieldValue('Account_Name');
					$accountData->accountType = $rawAccount->getFieldValue('Account_Type');
					$accountData->phoneNumber = $rawAccount->getFieldValue('Phone');
					$accountData->website = $rawAccount->getFieldValue('Website');
					$accountData->enrollment = $rawAccount->getFieldValue('Enrollment');
					$accountData->totalSpent = $rawAccount->getFieldValue('Total_Spent');
					$accountData->billingStreet = $rawAccount->getFieldValue('Billing_Street');
					$accountData->billingCity = $rawAccount->getFieldValue('Billing_City');
					$accountData->billingCode = $rawAccount->getFieldValue('Billing_Code');
					$accountData->billingState = $rawAccount->getFieldValue('Billing_State');
					$accountData->shippingStreet = $rawAccount->getFieldValue('Shipping_Street');
					$accountData->shippingCity = $rawAccount->getFieldValue('Shipping_City');
					$accountData->shippingCode = $rawAccount->getFieldValue('Shipping_Code');
					$accountData->shippingState = $rawAccount->getFieldValue('Shipping_State');

					$account = new Account($accountData);

					array_push($parsedAccounts, $account);
					if ($iterations >= 100) {
						break;
					}
				}


				// Check if there are more records to fetch
				$hasMore = $info->getMoreRecords();
				$pageNumber = $info->getPageNo() + 1;
			}

			return $parsedAccounts;

		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}

	}

	public function getLeadsModifiedSinceDate($modifiedDate=null) {
		try {
			if (!$modifiedDate) {
				// If no modified date passed, default to 2 months ago (2 months * 30 days * 24 hours * 60 minutes * 60 seconds)
				$modifiedDate = date('Y-m-d', time() - (2 * 30 * 24 * 60 * 60));
			}
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Leads");
			$headers['if-modified-since'] = $modifiedDate . "T00:00:00Z";

			// Instantiate array to hold parsed leads
			$parsedLeads = array();

			$pageNumber = 1; // Start on the first page
			$hasMore = true; // Start assuming records exist

			$iterations = 0;
			$totalSoFar = 0;
			while ($hasMore) {
				$iterations++;
				// Gets record response from API.
				$response = $module->getRecords(null, null, null, $pageNumber, 2000, $headers);
				// Get info
				$info = $response->getInfo();
				$totalSoFar += $info->getRecordCount();
				// Get data
				$rawLeads = $response->getData();
				$rawLeadCount = count($rawLeads);

				// Iterate over records
				foreach ($rawLeads as $rawLead) {

					$leadData = new stdClass;
					$leadData->zohoId = $rawLead->getEntityId();
					$leadData->email = $rawLead->getFieldValue('Email');
					$leadData->salutation = $rawLead->getFieldValue('Salutation');
					$leadData->firstName = $rawLead->getFieldValue('First_Name');
					$leadData->lastName = $rawLead->getFieldValue('Last_Name');
					$leadData->phoneNumber = $rawLead->getFieldValue('Phone');
					$leadData->fax = $rawLead->getFieldValue('Fax');
					$leadData->organization = $rawLead->getFieldValue('Company');
					$leadData->title = $rawLead->getFieldValue('Title');
					$leadData->leadSource = $rawLead->getFieldValue('Lead_Source');
					$leadData->addressStreet = $rawLead->getFieldValue('Street');
					$leadData->addressCity = $rawLead->getFieldValue('City');
					$leadData->addressCode = $rawLead->getFieldValue('Zip_Code');
					$leadData->addressState = $rawLead->getFieldValue('State');
					$leadData->emailOptOut = (bool)$rawLead->getFieldValue('Email_Opt_Out');

					$lead = new Lead($leadData);
					array_push($parsedLeads, $lead);
				}
				$leadArrayCount = count($parsedLeads);


				// Check if there are more records to fetch
				$hasMore = $info->getMoreRecords();
				$pageNumber = $info->getPageNo() + 1;
				if ($iterations >= 1000) {
					// Failsafe to stop runaway loops
					break;
				}
			}

			return $parsedLeads;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getContactsModifiedSinceDate($modifiedDate=null) {
		try {
			if (!$modifiedDate) {
				// If no modified date passed, default to 2 months ago (2 months * 30 days * 24 hours * 60 minutes * 60 seconds)
				$modifiedDate = date('Y-m-d', time() - (2 * 30 * 24 * 60 * 60));
			}
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Contacts");
			$headers['if-modified-since'] = $modifiedDate . "T00:00:00Z";

			// Instantiate array to hold parsed contacts
			$parsedContacts = array();

			$pageNumber = 1; // Start on the first page
			$hasMore = true; // Start assuming records exist

			$iterations = 0;
			$totalSoFar = 0;
			while ($hasMore) {
				$iterations++;
				// Gets record response from API.
				$response = $module->getRecords(null, null, null, $pageNumber, 200, $headers);
				// Get info
				$info = $response->getInfo();
				$totalSoFar += $info->getRecordCount();
				// Get data
				$rawContacts = $response->getData();
				$rawContactCount = count($rawContacts);

				// Iterate over records
				foreach ($rawContacts as $rawContact) {
					$rawAccount = $rawContact->getFieldValue('Account_Name');

					$contactData = new stdClass;
					$contactData->zohoId = $rawContact->getEntityId();
					$contactData->email = $rawContact->getFieldValue('Email');
					$contactData->salutation = $rawContact->getFieldValue('Salutation');
					$contactData->firstName = $rawContact->getFieldValue('First_Name');
					$contactData->lastName = $rawContact->getFieldValue('Last_Name');
					$contactData->phoneNumber = $rawContact->getFieldValue('Phone');
					$contactData->fax = $rawContact->getFieldValue('Fax');
					$contactData->title = $rawContact->getFieldValue('Title');
					$contactData->leadSource = $rawContact->getFieldValue('Lead_Source');
					$contactData->addressStreet = $rawContact->getFieldValue('Mailing_Street');
					$contactData->addressCity = $rawContact->getFieldValue('Mailing_City');
					$contactData->addressCode = $rawContact->getFieldValue('Mailing_Zip');
					$contactData->addressState = $rawContact->getFieldValue('Mailing_State');
					$contactData->emailOptOut = (bool)$rawContact->getFieldValue('Email_Opt_Out');
					if ($rawAccount) {
						$contactData->accountZohoId = $rawAccount->getEntityId();
					}
					$contact = new Contact($contactData);
					if ($contact->getAccount()) {
						$contact->getAccount()->populateDbId();
					}
					array_push($parsedContacts, $contact);
				}
				$contactArrayCount = count($parsedContacts);


				// Check if there are more records to fetch
				$hasMore = $info->getMoreRecords();
				$pageNumber = $info->getPageNo() + 1;
				if ($iterations >= 100) {
					// Failsafe to stop runaway loops
					break;
				}
			}

			return $parsedContacts;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

    public function searchRecords_cron($modified_date,$exclude,$arg){

            $moduleIns = ZCRMRestClient::getInstance()->getModuleInstance("Invoices"); // To get module instance
            $headers['if-modified-since'] = $modified_date . "T00:00:00Z";
            //CRM custom view ID that only display shipped invoices 835703000075761019
            $response = $moduleIns->getRecords("835703000075761019", null, null,1,200,$headers); // to get the records($param_map - parameter map,$header_map - header map
            //            print_r($response);
            $records = $response->getData(); // To get response data
            //            echo "Total Count:" . count($records). "<br>";
            $zoho_items = array();
            try {
                foreach ($records as $record) {

                        $record_data    = array();
                        $record_data['INVOICEID']               = $record->getEntityId();
            //                        echo "Invoice ID:" . $record_data['INVOICEID']  . "</br>";
                        $record_data['Subject']                 = $record->getFieldValue('Subject');
                        $record_data['Purchase Order']          = $record->getFieldValue('Purchase_Order');

                        $record_data['Status']                 = $record->getFieldValue('Status');

                        $account        = $record->getFieldValue('Account_Name');
                        if($account != null && $account != false && $account != "")
                        {
                                $account_id     = $account->getEntityId();
                                $account_name   = $account->getLookupLabel();
                        }
                        else
                        {
                            $account_id     = '';
                            $account_name   = '';
                        }


                        $record_data['ACCOUNTID']                 = $account_id;
                        $record_data['Account Name']              = $account_name;

                        $owner = $record->getOwner();
                        $record_data['SMOWNERID']                 = $owner->getId();
                        $record_data['Invoice Owner']             = $owner->getName();

                        $record_data['Created Time']              = $record->getCreatedTime();
                        $record_data['Modified Time']             = $record->getModifiedTime();
                //                        echo "Modified Time:" . $record_data['Modified Time']  . "</br>";

                    $record_data['Sub Total'] = $record->getFieldValue('Sub_Total');
                    $record_data['Tax'] = $record->getFieldValue('Tax');
                    $record_data['Adjustment'] = $record->getFieldValue('Adjustment');
                    $record_data['Grand Total'] = $record->getFieldValue('Grand_Total');
                    $record_data['Discount'] = $record->getFieldValue('Discount');

                    $record_data['Billing Street'] = $record->getFieldValue('Billing_Street');
                    $record_data['Billing City'] = $record->getFieldValue('Billing_City');
                    $record_data['Billing State'] = $record->getFieldValue('Billing_State');
                    $record_data['Billing Code'] = $record->getFieldValue('Billing_Code');


                    $contact                        = $record->getFieldValue('Contact_Name');
                    if($contact != null)
                    {
                        $record_data['CONTACTID']       = $contact->getEntityId();
                        $record_data['Contact Name']    = $contact->getLookupLabel();
                    }
                    else
                    {
                        $record_data['CONTACTID']       = '';
                        $record_data['Contact Name']    = '';

                    }

                    $record_data['MTS Quote Number'] = $record->getFieldValue('MTS_Quote_Number');
                    $record_data['Ship Date'] = $record->getFieldValue('Ship_Date');

                    $record_data['Tracking Number 1'] = $record->getFieldValue('Tracking_Number_1');
                    $record_data['Serial Number'] = $record->getFieldValue('Serial_Number');
                    $record_data['Ship Method'] = $record->getFieldValue('Ship_Method');
                    $record_data['Paid'] = $record->getFieldValue('Paid');
                    $record_data['AP Data Present'] = $record->getFieldValue('AP_Data_Present');
                    $record_data['Invoiced'] = $record->getFieldValue('Invoiced');
                    $record_data['TIPS'] = $record->getFieldValue('TIPS');

                    $potential = $record->getFieldValue("Potential_Name");
                    if($potential != null)
                    {
                        $record_data['Potential Name_ID'] = $potential->getEntityId();
                        $record_data['Potential Name'] = $potential->getLookupLabel();
                    }

                    $line_items = $record->getLineItems();
                    $po_products = array();

                        foreach ($line_items as $line_item)
                        {

                            $item = array();

                            $item['Product Id'] = $line_item->getProduct()->getEntityId();
                    //                            echo "PID:".$item['Product Id']."</br>";

                            $apiResponse_product = ZCRMModule::getInstance('Products')->getRecord($item['Product Id']);
                            $product_record = $apiResponse_product->getData();
                            $unit_price = $product_record->getFieldValue('Unit_Price');
                            $qunatity_in_stock = $product_record->getFieldValue('Qty_in_Stock');
                            $product_code = $product_record->getFieldValue('Product_Code');
                            $item['Product Name'] = $product_record->getFieldValue('Product_Name');
                            if($item['Product Name'] == 'SHIPPING')
                            {
                                 $item['Shipping']   = $line_item->getTotal();
                            }

                            $item['Unit Price'] = $unit_price;
                            $item['Quantity'] = $line_item->getQuantity();
                            $item['Quantity in Stock'] = $qunatity_in_stock;
                            $item['Total'] = $line_item->getTotal();
                            $item['Discount'] = $line_item->getDiscount();
                            $item['Total After Discount'] = $line_item->getTotalAfterDiscount();
                            $item['List Price'] = $line_item->getListPrice();
                            $item['Net Total'] = $line_item->getNetTotal();
                            $item['Tax'] = $line_item->getTaxAmount();
                            $item['Line Tax'] = $line_item->getTaxAmount();

                            if (!in_array($item['Product Name'], $exclude))
                            {

                                if ($arg != 'hardware'){
                                    if ($product_code != '' && $product_code != null){
                                        $item['Item Number'] = $product_code;
                                    }else{
                                        $item['Item Number'] = 'Hardware';
                                    }
                                }else{
                                    $item['Item Number'] = 'Hardware';
                                }

                                if ($item['Product Name'] != 'SHIPPING')
                                {
                                    $po_products[] = $item;
                                }

                            }

                            if (isset($item['Shipping'])){
                                $po_products[0]['Freight'] =  $item['Shipping'];
                                unset($item['Shipping']);
                            }

                        }

                    $record_data['Product Details'] = $po_products;
                    unset($po_products);


                    $zoho_items[] = $record_data;
                //                    print_r($record_data);
                }
                //                print_r($zoho_items);
                return $zoho_items;
            } catch (ZCRMException $ex) {
                echo $ex->getMessage(); // To get ZCRMException error message
                echo $ex->getExceptionCode(); // To get ZCRMException error code
                echo $ex->getFile(); // To get the file name that throws the Exception
            }
    }

    public function searchRecords_api($MTSQuoteNo)
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("(MTS_Quote_Number:equals:".$MTSQuoteNo.")",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data
            return $records;
          }
          catch(ZCRMException $e)
          {
            echo $e->getMessage();
            echo $e->getExceptionCode();
            echo $e->getCode();
          }
	}

	public function searchInvoiceByMTSNumber($MtsNumber) {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$response = $module->searchRecordsByCriteria("(MTS_Quote_Number:equals:$MtsNumber)", 1, 200);
			$rawRecords = $response->getData();
			$processedRecords = array();
			foreach ($rawRecords as $rawRecord) {
				array_push($processedRecords, $this->processRecord($rawRecord));
			}
			$records = new stdClass;
			$records->processed = $processedRecords;
			$records->raw = $rawRecords;

			return $records;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function searchInvoiceByField($field, $value) {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$response = $module->searchRecordsByCriteria("($field:starts_with:$value)", 1, 200);
			$records = $response->getData();
			foreach ($records as $record) {
				echo "<pre>";
				print_r($record);
				echo "</pre>";
			}
			return $records;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}


    public function update_record_admin($MTSQuoteNo,$status)
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("(MTS_Quote_Number:equals:".$MTSQuoteNo.")",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data

            foreach ($records as $record)
            {
                $invoice_id               = $record->getEntityId();
        //                print_r($invoice_id);
                $record = ZCRMRecord::getInstance("Invoices", $invoice_id);
                $record->setFieldValue("Status",$status);
                $records[] = $record;

                try
                {
                    $trigger = array("workflow");
                    $entityResponse=$record->update($trigger);
                }
                catch (ZCRMException $e)
                {
                    print_r($e);
                }

            }
        }
        catch(ZCRMException $e)
        {
          echo $e->getMessage();
          echo $e->getExceptionCode();
          echo $e->getCode();
        }
    }

    public function update_record_admin_2($MTSQuoteNo,$status,$temple_date)
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("(MTS_Quote_Number:equals:".$MTSQuoteNo.")",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data

            foreach ($records as $record)
            {
                $invoice_id               = $record->getEntityId();
                $notes               = $record->getFieldValue('Notes');
                $notes .= ' Arrival Date: '. $temple_date;

        //                print_r($invoice_id);
                $record = ZCRMRecord::getInstance("Invoices", $invoice_id);
                $record->setFieldValue("Status",$status);
                $record->setFieldValue("Notes",$notes);
                $records[] = $record;

                try
                {
                    $trigger = array("workflow");
                    $entityResponse=$record->update($trigger);
                }
                catch (ZCRMException $e)
                {
                    print_r($e);
                }

            }
        }
        catch(ZCRMException $e)
        {
          echo $e->getMessage();
          echo $e->getExceptionCode();
          echo $e->getCode();
        }
    }

    public function update_record_admin_3($MTSQuoteNo,$key_val)
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("(MTS_Quote_Number:equals:".$MTSQuoteNo.")",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data

            foreach ($records as $record)
            {
                $invoice_id               = $record->getEntityId();

        //                print_r($invoice_id);
                $record = ZCRMRecord::getInstance("Invoices", $invoice_id);
                foreach ($key_val as $key => $value) {
                    $record->setFieldValue($key,$value);
                }
                $records[] = $record;

                try
                {
                    $trigger = array("workflow");
                    $entityResponse=$record->update($trigger);
                }
                catch (ZCRMException $e)
                {
                    print_r($e);
                }

            }
        }
        catch(ZCRMException $e)
        {
          echo $e->getMessage();
          echo $e->getExceptionCode();
          echo $e->getCode();
        }
    }

    public function update_record_admin_4($zoho_id,$key_val)
    {
        $record = ZCRMRecord::getInstance("Invoices", $zoho_id);

        foreach ($key_val as $key => $value) {
            $record->setFieldValue($key,$value);
        }
        $records[] = $record;

        try
        {
            $trigger = array("workflow");
            $entityResponse=$record->update($trigger);
        }
        catch (ZCRMException $e)
        {
            print_r($e);
        }

    }

    public function getRecordById_cron($zoho_id)
    {
                $record_data = array();
        try{

        $apiResponse=ZCRMModule::getInstance('Contacts')->getRecord($zoho_id); // 410405000001519001 - Lead Id
        $record=$apiResponse->getData();
        //        print_r($record);



        $record_data['cEmail'] = $record->getFieldValue('Email');
        $record_data['cPhone'] = $record->getFieldValue('Phone');
        $record_data['cPhone2'] = $record->getFieldValue('Other_Phone');

        $account        = $record->getFieldValue('Account_Name');
        if($account != null && $account != false && $account != "")
        {
                $account_id     = $account->getEntityId();
                $account_name   = $account->getLookupLabel();
        }
        else
        {
            $account_id     = '';
            $account_name   = '';
        }
        $record_data['cShipCompany'] = $account_name;
        $record_data['cShipFname'] = $record->getFieldValue('First_Name');
        $record_data['cShipLname'] = $record->getFieldValue('Last_Name');
        $record_data['cShipAddress1'] = $record->getFieldValue('Mailing_Street');
        $record_data['cShipCity'] = $record->getFieldValue('Mailing_City');
        $record_data['cShipState'] = $record->getFieldValue('Mailing_State');
        $record_data['cShipZip'] = $record->getFieldValue('Mailing_Zip');
        $record_data['cShipCountry'] =  'US';
        $record_data['cBillCompany'] = $account_name;
        $record_data['cBillFname'] = $record->getFieldValue('First_Name');
        $record_data['cBillLname'] = $record->getFieldValue('Last_Name');
        $record_data['cBillAddress1'] = $record->getFieldValue('Mailing_Street');
        $record_data['cBillCity'] = $record->getFieldValue('Mailing_City');
        $record_data['cBillState'] = $record->getFieldValue('Mailing_State');
        $record_data['cBillZip'] = $record->getFieldValue('Mailing_Zip');
        $record_data['cBillCountry'] =  'US';

        $record_data['zoho_contactid'] = $zoho_id;
        $record_data['educational'] = "Y";
        $record_data['billEqualShip'] = "Y"  ;


        return $record_data;

        }
        catch (ZCRMException $e)
        {
        print_r($e);
        }

    }

    public function getRecords($from,$to,$modified_date)
    {
        $moduleIns = ZCRMRestClient::getInstance()->getModuleInstance("Leads"); // To get module instance
        $headers['if-modified-since'] = $modified_date;
        $response = $moduleIns->getRecords(null, null, null,$from,$to,$headers); // to get the records($param_map - parameter map,$header_map - header map
        $records = $response->getData(); // To get response data
        $zoho_items = array();
        try {
            foreach ($records as $record) {

                    $record_data    = array();
                    $record_data['LEADID']               = $record->getEntityId();
        //                        echo "LEAD ID:" . $record_data['LEADID']  . "</br>";
                    $record_data['Company']              = $record->getFieldValue('Company');
                    $record_data['First_Name']           = $record->getFieldValue('First_Name');
                    $record_data['Last_Name']            = $record->getFieldValue('Last_Name');


                    $record_data['Designation']          = $record->getFieldValue('Designation');
                    $record_data['Email']                = $record->getFieldValue('Email');
                    $record_data['Phone']                = $record->getFieldValue('Phone');
                    $record_data['Fax']                  = $record->getFieldValue('Fax');
                    $record_data['Mobile']               = $record->getFieldValue('Mobile');
                    $record_data['Website']              = $record->getFieldValue('Website');
                    $record_data['Lead_Source Name']     = $record->getFieldValue('Lead_Source');
                    $record_data['No_of_Employees']      = $record->getFieldValue('No_of_Employees');
                    $record_data['Campaign_Status1']     = $record->getFieldValue('Campaign_Status1');

                    $modified_by                        = $record->getModifiedBy();
                    $record_data['Modified_By_ID']      = $modified_by->getId();
                    $record_data['Modified_By_Name']    = $modified_by->getName();
                    $record_data['Modified_Time']       = $record->getModifiedTime();
                    $record_data['Created_Time']        = $record->getCreatedTime();

                    $record_data['Street']              = $record->getFieldValue('Street');
                    $record_data['City']                = $record->getFieldValue('City');
                    $record_data['State']               = $record->getFieldValue('State');
                    $record_data['Zip_Code']            = $record->getFieldValue('Zip_Code');
                    $record_data['Description']         = $record->getFieldValue('Description');
                    $record_data['Email_Opt_Out'] = $record->getFieldValue('Email_Opt_Out');
                    $record_data['Salutation'] = $record->getFieldValue('Salutation');
                    $record_data['Secondary_Email'] = $record->getFieldValue('Secondary_Email');
                    $record_data['Last_Activity_Time'] = $record->getLastActivityTime();
                    $record_data['Recontact_Buy'] = $record->getFieldValue('Recontact_Buy');
                    $record_data['Recontact_Sell'] = $record->getFieldValue('Recontact_Sell');
                    $record_data['Referred_By'] = $record->getFieldValue('Referred_By');
                    $record_data['How_did_you_hear_about_us'] = $record->getFieldValue('How_did_you_hear_about_us');
                    $record_data['to_1'] = $record->getFieldValue('to_1');
                    $record_data['Purchased'] = $record->getFieldValue('Purchased');

                $zoho_items[] = $record_data;
        //                    print_r($record_data);
            }
        //            print_r($zoho_items);
            return $zoho_items;
            } catch (ZCRMException $ex) {
                echo $ex->getMessage(); // To get ZCRMException error message
                echo $ex->getExceptionCode(); // To get ZCRMException error code
                echo $ex->getFile(); // To get the file name that throws the Exception
            }

    }

    public function insertRecords($leads)
    {
        $trigger = array("workflow");
        $records = [];
        $rec_counter = 1;
        foreach ($leads as $zoho_array) {


        $record=ZCRMRecord::getInstance("Leads",null);


        $record->setFieldValue("Company",$zoho_array['Company']);
        $record->setFieldValue("First_Name",$zoho_array['First_Name']);
        $record->setFieldValue("Last_Name",$zoho_array['Last_Name']);
        $record->setFieldValue("Designation",$zoho_array['Designation']);
        $record->setFieldValue("Email",$zoho_array['Email']);
        $record->setFieldValue("Phone",$zoho_array['Phone']);
        $record->setFieldValue("Fax",$zoho_array['Fax']);
        $record->setFieldValue("Mobile",$zoho_array['Mobile']);
        $record->setFieldValue("Website",$zoho_array['Website']);
        $record->setFieldValue("Lead_Source",$zoho_array['Lead_Source']);
        $record->setFieldValue("Lead_Status",$zoho_array['Lead_Status']);
        $record->setFieldValue("No_of_Employees",$zoho_array['No_of_Employees']);
        $record->setFieldValue("Campaign_Status1",$zoho_array['Campaign_Status1']);
        $record->setFieldValue("Modified_By_Name",$zoho_array['Modified_By_Name']);
        $record->setFieldValue("Modified_Time",$zoho_array['Modified_Time']);
        $record->setFieldValue("Street",$zoho_array['Street']);
        $record->setFieldValue("City",$zoho_array['City']);
        $record->setFieldValue("State",$zoho_array['State']);
        $record->setFieldValue("Zip_Code",$zoho_array['Zip_Code']);
        $record->setFieldValue("Description",$zoho_array['Description']);
        $record->setFieldValue("Email_Opt_Out",$zoho_array['Email_Opt_Out']);
        $record->setFieldValue("Salutation",$zoho_array['Salutation']);
        $record->setFieldValue("Secondary_Email",$zoho_array['Secondary_Email']);
        $record->setFieldValue("Last_Activity_Time",$zoho_array['Last_Activity_Time']);
        $record->setFieldValue("Recontact_Buy",$zoho_array['Recontact_Buy']);
        $record->setFieldValue("Recontact_Sell",$zoho_array['Recontact_Sell']);
        $record->setFieldValue("Referred_By",$zoho_array['Referred_By']);
        $record->setFieldValue("How_did_you_hear_about_us",$zoho_array['How_did_you_hear_about_us']);
        $record->setFieldValue("to_1",$zoho_array['to_1']);
        $record->setFieldValue("Purchased",$zoho_array['Purchased']);

        $records[] = $record;
        $rec_counter++;

        if($rec_counter == 100)
        {

            $rec_counter = 0; //Reset Record Counter
            try{
                $zcrmModuleIns = ZCRMModule::getInstance("Leads");
                $bulkAPIResponse=$zcrmModuleIns->createRecords($records,$trigger); // $recordsArray - array of ZCRMRecord instances filled with required data for creation.
                $entityResponses = $bulkAPIResponse->getEntityResponses();
                }
                catch (ZCRMException $e)
                {
                print_r($e);
                }

        }

        }
        //        $recordsArray['Account_Owner'] = $this->get_owner_id($account->account_email);
        //        $recordsArray['Account_Name'] = $account->account_fname;
        //        $recordsArray['Phone'] = $account->account_phone;
        if($rec_counter > 0)
        {

            try{
            $zcrmModuleIns = ZCRMModule::getInstance("Leads");
            $bulkAPIResponse=$zcrmModuleIns->createRecords($records,$trigger); // $recordsArray - array of ZCRMRecord instances filled with required data for creation.
            $entityResponses = $bulkAPIResponse->getEntityResponses();
            }
            catch (ZCRMException $e)
            {
            print_r($e);
            }
        }
    }

    public function updateRecords($leads)
    {
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Leads"); //to get the instance of the module
        $trigger = array("workflow");
        $records = [];
        $rec_counter = 1;
        foreach ($leads as $zoho_array) {


        $record = ZCRMRecord::getInstance("Leads",$zoho_array['LEADID']);
        $record->setFieldValue("Company",$zoho_array['Company']);
        $record->setFieldValue("First_Name",$zoho_array['First_Name']);
        $record->setFieldValue("Last_Name",$zoho_array['Last_Name']);
        $record->setFieldValue("Designation",$zoho_array['Designation']);
        $record->setFieldValue("Email",$zoho_array['Email']);
        $record->setFieldValue("Phone",$zoho_array['Phone']);
        $record->setFieldValue("Fax",$zoho_array['Fax']);
        $record->setFieldValue("Mobile",$zoho_array['Mobile']);
        $record->setFieldValue("Website",$zoho_array['Website']);
        $record->setFieldValue("Lead_Source",$zoho_array['Lead_Source']);
        $record->setFieldValue("Lead_Status",$zoho_array['Lead_Status']);
        $record->setFieldValue("No_of_Employees",$zoho_array['No_of_Employees']);
        $record->setFieldValue("Campaign_Status1",$zoho_array['Campaign_Status1']);
        $record->setFieldValue("Modified_By_Name",$zoho_array['Modified_By_Name']);
        $record->setFieldValue("Modified_Time",$zoho_array['Modified_Time']);
        $record->setFieldValue("Street",$zoho_array['Street']);
        $record->setFieldValue("City",$zoho_array['City']);
        $record->setFieldValue("State",$zoho_array['State']);
        $record->setFieldValue("Zip_Code",$zoho_array['Zip_Code']);
        $record->setFieldValue("Description",$zoho_array['Description']);
        $record->setFieldValue("Email_Opt_Out",$zoho_array['Email_Opt_Out']);
        $record->setFieldValue("Salutation",$zoho_array['Salutation']);
        $record->setFieldValue("Secondary_Email",$zoho_array['Secondary_Email']);
        $record->setFieldValue("Last_Activity_Time",$zoho_array['Last_Activity_Time']);
        $record->setFieldValue("Recontact_Buy",$zoho_array['Recontact_Buy']);
        $record->setFieldValue("Recontact_Sell",$zoho_array['Recontact_Sell']);
        $record->setFieldValue("Referred_By",$zoho_array['Referred_By']);
        $record->setFieldValue("How_did_you_hear_about_us",$zoho_array['How_did_you_hear_about_us']);
        $record->setFieldValue("to_1",$zoho_array['to_1']);
        $record->setFieldValue("Purchased",$zoho_array['Purchased']);

        $records[] = $record;
        $rec_counter++;

        if($rec_counter == 100)
        {

            $rec_counter = 0; //Reset Record Counter
            try{
                $responseIn=$moduleIns->updateRecords($records); //updating the records
                $entityResponses = $bulkAPIResponse->getEntityResponses();
                }
                catch (ZCRMException $e)
                {
                print_r($e);
                }

        }

        }
        //        $recordsArray['Account_Owner'] = $this->get_owner_id($account->account_email);
        //        $recordsArray['Account_Name'] = $account->account_fname;
        //        $recordsArray['Phone'] = $account->account_phone;
        if($rec_counter > 0)
        {

            try{
                $responseIn=$moduleIns->updateRecords($records); //updating the records
                $entityResponses = $bulkAPIResponse->getEntityResponses();
            }
            catch (ZCRMException $e)
            {
            print_r($e);
            }
        }
    }

	public function getAccountAndContactDataByAccountName($accountName) {
		try {
			$contactModuleInstance = ZCRMRestClient::getInstance()->getModuleInstance("Contacts");
			$contactResponse = $contactModuleInstance->getSearchRecordsByCriteria("((Account_Name:equals:".$this->escapeString($account_name)."))",1,200);
			$contactRecords = $contactResponse->getData();

			$accountModuleInstance = ZCRMRestClient::getInstance()->getModuleInstance("Accounts");
			$accountResponse = $accountModuleInstance->getSearchRecordsByCriteria("((Account_Name:equals:".$this->escapeString($account_name)."))",1,200);
			$accountRecords = $accountResponse->getData();
		}
		catch (ZCRMException $e) {

		}
	}

    public function getSearchRecords_Contacts($account_name)
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Contacts");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("((Account_Name:equals:".$this->escapeString($account_name)."))",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data
        //        print_r($records);
        //        $contacts = array();
            foreach($records as $record)
            {
                $contact = array();
                $contact['first_name'] = $record->getFieldValue('First_Name');
                $contact['last_name'] = $record->getFieldValue('Last_Name');
                $contact['email'] = $record->getFieldValue('Email');
                $contact['phone'] = $record->getFieldValue('Phone');
                $contact['street'] = $record->getFieldValue('Mailing_Street');
                $contact['city'] = $record->getFieldValue('Mailing_City');
                $contact['state'] = $record->getFieldValue('Mailing_State');
                $contact['zip'] = $record->getFieldValue('Mailing_Zip');
                return $contact;
            }
        //            print_r($contacts);
          }
          catch(ZCRMException $e)
          {
            // echo $e->getMessage();
            // echo $e->getExceptionCode();
            // echo $e->getCode();
          }
    }

	public function getOpenInvoices() {
		try {
			$searchConditions = "((Status:starts_with:BB - 1.) OR (Status:starts_with:BB - 2) OR (Status:starts_with:BB - 3) OR (Status:starts_with:BB - 4) OR (Status:starts_with:BB - 5))";
			$moduleIns = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$response = $moduleIns->searchRecordsByCriteria($searchConditions, 1, 200);

			$records = $response->getData();

			$invoices = array();
			foreach ($records as $record) {
				$accountRawData = $record->getFieldValue('Account_Name');
				if ($accountRawData) {
					$accountData = array(
						'zohoId' => $accountRawData->getEntityId(),
						'name' => $accountRawData->getLookupLabel(),
					);
				}
				echo "<pre>";
				print_r($accountRawData);
				echo "</pre>";
			}
		}
		catch(ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}

	}

    public function getSearchRecords_BB($cond) {
        try{
            $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
            $response=$moduleIns->searchRecordsByCriteria($cond,1,200);  //To get module records that match the criteria

            $records=$response->getData();  //To get response data
            $invoices = array();
            foreach($records as $record)
            {
                $invoice = array();
                $invoice['Invoice_Id']          = $record->getEntityId();
                $invoice['MTS_Quote_Number']    = $record->getFieldValue('MTS_Quote_Number');
                $account                        = $record->getFieldValue('Account_Name');
                if($account != null && $account != false && $account != "")
                {
                        $account_id     = $account->getEntityId();
                        $account_name   = $account->getLookupLabel();
                }
                else
                {
                    $account_id     = '';
                    $account_name   = '';
                }


                $invoice['ACCOUNTID']                 = $account_id;
                $invoice['Account_Name']              = $account_name;

                $invoice['Status']          = $record->getFieldValue('Status');
                $invoice['Subject']         = $record->getFieldValue('Subject');
                $invoice['Billing_State']   = $record->getFieldValue('Billing_State');
                $invoices[] = $invoice;
            }
            return $invoices;
        }
        catch(ZCRMException $e)
        {
            echo $e->getMessage();
            echo $e->getExceptionCode();
            echo $e->getCode();
        }
	}

	public function getSearchRecordsProducts() {
		try {
			$moduleIns = ZCRMRestClient::getInstance()->getModuleInstance('Invoices');
			$response = $moduleIns->searchRecordsByCriteria("((Status:starts_with:PO received) OR (Status:starts_with:Credit Card))");

			$records = $response->getData();
			$invoices = array();
			foreach ($records as $record) {
				$status = $record->getFieldValue('Status');
				if ($status != 'PO Received - WFS') {
					$recordData = $this->processRecord($record);
					$invoice = $recordData['invoice'];
					array_push($invoices, $invoice);
				}
			}
			return $invoices;

		} catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

    public function getSearchRecords_checkout_form()
    {
        try{
        $moduleIns=ZCRMRestClient::getInstance()->getModuleInstance("Invoices");  //To get module instance
        $response=$moduleIns->searchRecordsByCriteria("((Status:equals:PO) OR (Status:equals:Wire Received - Waiting for Shipping))",1,200);  //To get module records that match the criteria
        $records=$response->getData();  //To get response data
        //        print_r($records);
            $invoices = array();
            foreach($records as $record)
            {
                $invoice = array();
                $invoice['MTS_Quote_Number']    = $record->getFieldValue('MTS_Quote_Number');
                $account                        = $record->getFieldValue('Account_Name');
                if($account != null && $account != false && $account != "")
                {
                        $account_id     = $account->getEntityId();
                        $account_name   = $account->getLookupLabel();
                }
                else
                {
                    $account_id     = '';
                    $account_name   = '';
                }


                $invoice['ACCOUNTID']                 = $account_id;
                $invoice['Account_Name']              = $account_name;

                $invoice['Status']          = $record->getFieldValue('Status');
                $invoice['Subject']         = $record->getFieldValue('Subject');
                $invoice['Billing_State']   = $record->getFieldValue('Billing_State');
                $invoices[] = $invoice;
            }
                return $invoices;
        //            print_r($contacts);
          }
          catch(ZCRMException $e)
          {
            echo $e->getMessage();
            echo $e->getExceptionCode();
            echo $e->getCode();
          }
	}

	public function getAllShippedInvoices($startPage=1, $numPages=10) {
		try {
			$moduleInstance = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$perPage = 200; // 200
			// $maxPages = 100; // 3
			$i = 0;
			$data = array();
			$invoices = array();
			$accounts = array();
			$salespersons = array();
			$lineItems = array();
			$shippingData = array();
			while($i < $numPages && count($invoices) % 200 == 0) {
				$response = $moduleInstance->searchRecordsByCriteria("((Status:equals:Shipped))",$i+$startPage, $perPage);
				$records = $response->getData();
				foreach($records as $record) {
					$recordData = $this->processRecord($record);
					foreach ($recordData['lineItems'] as $lineItem) {
						$lineItems[$lineItem['id']] = $lineItem;
					}
					$account = $recordData['account'];
					$accounts[$account['Account_Id']] = $account;
					$salesperson = $recordData['salesperson'];
					$salespersons[$salesperson['Owner_Id']] = $salesperson;
					$invoice = $recordData['invoice'];
					$shipping = $recordData['shipping'];
					$shippingData[$invoice['Invoice_Id']] = $shipping;
					array_push($invoices, $invoice);
				}
				if ($i == $numPages) {
					return array(
						'invoices' => $invoices,
						'accounts' => $accounts,
						'salespersons' => $salespersons,
						'lineItems' => $lineItems,
						'shipping' => $shippingData
					);
				}
				$i++;
			}
			return array(
				'invoices' => $invoices,
				'accounts' => $accounts,
				'salespersons' => $salespersons,
				'lineItems' => $lineItems,
				'shipping' => $shippingData
			);
		} catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getRecordIdByMtsNumber($mtsNumber) {
		$records = $this->searchInvoiceByMTSNumber($mtsNumber);
		$record = $records->raw[0];
		return $record->getEntityId();
	}

	public function getShippedRecordData($zoho_id) {
		try {
			$moduleInstance = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");

			$record = $moduleInstance->getRecord($zoho_id)->getData();// ZCRMRecord::getInstance("Invoices", $zoho_id);
			$id = $record->getEntityId();
			$subject = $record->getFieldValue('Subject');
			$accountData = $record->getFieldValue('Account_Name');
			$products = $record->getLineItems();
			$productArray = array();
			$lineItems = array();
			$taxAdjustment = 0.0;

			$recordData = $this->processRecord($record);
			foreach ($recordData['lineItems'] as $lineItem) {
				$lineItems[$lineItem['id']] = array('id' => $lineItem['id'], 'name' => $lineItem['name']);
			}

			$account = $recordData['account'];
			$salesperson = $recordData['salesperson'];
			$contact = $recordData['contact'];
			$invoice = $recordData['invoice'];
			$shipping = $recordData['shipping'];
			return array(
				'invoice' => $invoice,
				'account' => $account,
				'salesperson' => $salesperson,
				'contact' => $contact,
				'lineItems' => $lineItems,
				'shipping' => $shipping
			);
		} catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function updateProductPrice($zoho_id, $price) {
		try {
			$moduleInstance = ZCRMRestClient::getInstance()->getModuleInstance("Products");

			$record = $moduleInstance->getRecord($zoho_id)->getData();
			$id = $record->getEntityId();
			$unitPrice = $record->getFieldValue('Unit_Price');
			$recordData = array(
				'id' => $id,
				'oldPrice' => $unitPrice,
				'newPrice' => $price
			);
			if ($price != $unitPrice) {
				$record->setFieldValue('Unit_Price', $price);
				$apiResponse = $record->update();
				$recordData['responseStatus'] = $apiResponse->getStatus();
			}
			return $recordData;
		} catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getOpenQuotes() {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Quotes");

			$page = 1;
			$moreRecords = true;
			$processedRecords = array();
			while ($moreRecords) {
				$response = $module->searchRecordsByCriteria("(((Quote_Stage:equals:Buyback - Pending Approval) OR (Quote_Stage:equals:Buyback - RFB)))", $page, 200);
				$records = $response->getData();
				$moreRecords = $response->getInfo()->getMoreRecords();
				foreach ($records as $record) {
					array_push($processedRecords, $this->processRecord($record));
				}
				$page++;
			}

			return $processedRecords;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getActiveBuybacks() {
		$buybackStatuses = array(
			'BB - 1.',
			'BB - 2.',
			'BB - 3.',
			'BB - 4.',
			'BB - 5.',
			'BB - 6.',
			'BB - 7.',
		);
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Invoices");
			$processedRecords = array();
			$rawRecords = array();
			foreach ($buybackStatuses as $status) {
				$page = 1;
				$moreRecords = true;
				while ($moreRecords) {
					try {
						$response = $module->searchRecordsByCriteria("(Status:starts_with:$status)", $page, 200);
						$records = $response->getData();
						$moreRecords = $response->getInfo()->getMoreRecords();
						foreach ($records as $record) {
							array_push($processedRecords, $this->processActiveBuyback($record));
							array_push($rawRecords, $record);
						}
						$page++;
					}
					catch (ZCRMException $e) {
						if ($e->getCode() != 204) {
							echo $e->getMessage();
							echo "\n";
							echo $e->getExceptionCode();
							echo "\n";
							echo $e->getCode();
							echo "\n";
						}
						$moreRecords = false;
					}
				}
			}
			return $processedRecords;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getCreatedPurchaseOrders() {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Purchase_Orders");

			$page = 1;
			$moreRecords = true;
			$processedRecords = array();
			while ($moreRecords) {
				$response = $module->searchRecordsByCriteria("(Status:equals:Created)", $page, 200);
				$records = $response->getData();
				$moreRecords = $response->getInfo()->getMoreRecords();
				foreach ($records as $record) {
					array_push($processedRecords, $this->processPurchaseOrder($record));
				}
				$page++;
			}

			return $processedRecords;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getPurchaseOrdersByQuery($statusQuery) {
		try {
			$module = ZCRMRestClient::getInstance()->getModuleInstance("Purchase_Orders");

			$page = 1;
			$moreRecords = true;
			$processedRecords = array();
			while ($moreRecords) {
				$response = $module->searchRecordsByCriteria($statusQuery, $page, 200);
				$records = $response->getData();
				$moreRecords = $response->getInfo()->getMoreRecords();
				foreach ($records as $record) {
					array_push($processedRecords, $this->processPurchaseOrder($record));
				}
				$page++;
			}
			return $processedRecords;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getDetailsForShipNotificationEmail($contactZohoId, $salesZohoId) {
		$userData = $this->getUserDetails($salesZohoId);
		$contactData = $this->getContactDetails($contactZohoId);

		$contact = $contactData->contact;
		$owner = $userData->user;
		$shipNotificationData = new stdClass;
		$shipNotificationData->owner = $owner;
		$shipNotificationData->contact = $contact;

		return $shipNotificationData;
	}

	public function getInvoiceAccountAndContactDetails($zohoId) {
		$invoice = $this->getInvoiceDetails($zohoId);
		$contactData = $invoice->getFieldValue("Contact_Name");
		$accountData = $invoice->getFieldValue("Account_Name");

		if ($contactData) {
			$contactZohoId = $contactData->getEntityId();
		}
		if ($accountData) {
			$accountZohoId = $accountData->getEntityId();
		}

		if ($contactZohoId) {
			$contact = $this->getContactDetailsNew($contactZohoId);
		}
		else {
			$contact = null;
		}

		if ($accountZohoId) {
			$account = $this->getAccountDetails($accountZohoId);
		}
		else {
			$account = null;
		}

		$returnData = new stdClass;

		$returnData->invoice = $invoice;
		if ($contact) {
			$returnData->contact = Contact::createByZohoRecord($contact);
		}
		else {
			$returnData->contact = null;
		}
		if ($account) {
			$returnData->account = Account::createByZohoRecord($account);
		}
		else {
			$returnData->account = null;
		}
		return $returnData;
	}

	public function getInvoiceDetails($zohoId) {
		try {
			$record = ZCRMModule::getInstance("Invoices")->getRecord($zohoId)->getData();

			return $record;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getContactDetailsNew($zohoId) {
		try {
			$record=ZCRMModule::getInstance('Contacts')->getRecord($zohoId)->getData();

			return $record;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getAccountDetails($zohoId) {
		try {
			$record=ZCRMModule::getInstance('Accounts')->getRecord($zohoId)->getData();

			return $record;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getUserDetails($zohoId) {
		try {

			$orgIns = ZCRMRestClient::getOrganizationInstance(); // to get the organization instance
			$responseIns=$orgIns->getUser($zohoId);//to get the user
			$userInstance=$responseIns->getData();//to get the user data in form ZCRMUser instance


			$user = new stdClass;
			$user->id = $userInstance->getId();
			$user->fullName = $userInstance->getFullName();
			$user->email = $userInstance->getEmail();

			$data = new stdClass;
			$data->user = $user;
			$data->rawRecord = $userInstance;

			return $data;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	public function getContactDetails($zohoId) {
		try {
			$apiResponse=ZCRMModule::getInstance('Contacts')->getRecord($zohoId);
			$record=$apiResponse->getData();

			$contact = new stdClass;
			$contact->id = $record->getEntityId();
			$contact->firstName = $record->getFieldValue('First_Name');
			$contact->fullName = $record->getFieldValue('Full_Name');
			$contact->email = $record->getFieldValue('Email');

			$data = new stdClass;
			$data->contact = $contact;
			$data->rawRecord = $record;

			return $data;
		}
		catch (ZCRMException $e) {
			echo $e->getMessage();
			echo $e->getExceptionCode();
			echo $e->getCode();
		}
	}

	private function processActiveBuyback(ZCRMRecord $activeBuyback) {
		$accountData = $activeBuyback->getFieldValue('Account_Name');
		$accountId = $accountData->getEntityId();
		$accountName = $accountData->getLookupLabel();

		$account = new stdClass;
		$account->zohoId = $accountId;
		$account->name = $accountName;

		$buybackZohoId = $activeBuyback->getEntityId();
		$buybackSubject = $activeBuyback->getFieldValue('Subject');
		$buybackStatus = $activeBuyback->getFieldValue('Status');
		$buybackNumber = $activeBuyback->getFieldValue('MTS_Quote_Number');
		$buybackSubtotal = (float)$activeBuyback->getFieldValue('Sub_Total');
		$buybackDateCreated = $activeBuyback->getCreatedTime();

		$products = $activeBuyback->getLineItems();

		$lineItems = array();

		foreach ($products as $product) {
			$productInfo = (object)$this->processProduct($product);
			if ($productInfo->id) {
				$productInfo->zohoId = $productInfo->id;
				unset($productInfo->id);
			}
			array_push($lineItems, $productInfo);
		}

		$buyback = new stdClass;
		$buyback->zohoId = $buybackZohoId;
		$buyback->subject = $buybackSubject;
		$buyback->status = $buybackStatus;
		$buyback->mtsNumber = $buybackNumber;
		$buyback->subtotal = $buybackSubtotal;
		$buyback->createdDate = DateTime::createFromFormat(DATE_ATOM, $buybackDateCreated)->format('Y-m-d H:i:s');

		$recordData = new stdClass;
		$recordData->buyback = $buyback;
		$recordData->account = $account;
		$recordData->lineItems = $lineItems;

		return $recordData;
	}

	private function processPurchaseOrder(ZCRMRecord $purchaseOrder) {

		$vendorData = $purchaseOrder->getFieldValue('Vendor_Name');
		$vendorId = $vendorData->getEntityId();
		$vendorName = $vendorData->getLookupLabel();

		$vendor = new stdClass;
		$vendor->zohoId = $vendorId;
		$vendor->name = $vendorName;
		$orderZohoId = $purchaseOrder->getEntityId();
		$orderSubject = $purchaseOrder->getFieldValue('Subject');
		$orderNumber = $purchaseOrder->getFieldValue('Purchase_Order_Number');
		$vendorOrderNumber = $purchaseOrder->getFieldValue('Vendor_Order_Number');
		$mtsNumber = $purchaseOrder->getFieldValue('MTS_Number');
		$trackingNumber = $purchaseOrder->getFieldValue('Tracking_Number');
		$status = $purchaseOrder->getFieldValue('Status');
		$createdTime = $purchaseOrder->getCreatedTime();
		$orderSubtotal = (float)$purchaseOrder->getFieldValue('Sub_Total');
		$orderDate = $purchaseOrder->getFieldValue('PO_Date');

		$products = $purchaseOrder->getLineItems();
		$productArray = array();

		foreach ($products as $product) {
			$productInfo = (object)$this->processProduct($product);
			if ($productInfo->id) {
				$productInfo->zohoId = $productInfo->id;
				unset($productInfo->id);
			}
			array_push($productArray, $productInfo);
		}

		$order = new stdClass;
		$order->zohoId = $orderZohoId;
		$order->subject = $orderSubject;
		$order->poNumber = $orderNumber;
		$order->subtotal = $orderSubtotal;
		$order->date = $orderDate;
		$order->vendorOrderNumber = $vendorOrderNumber;
		$order->mtsNumber = $mtsNumber;
		$order->trackingNumber = $trackingNumber;
		$order->status = $status;
		$order->createdTime = $createdTime;

		$recordData = new stdClass;
		$recordData->order = $order;
		$recordData->vendor = $vendor;
		$recordData->lineItems = $productArray;
		$recordData->receivedItems = PurchaseOrdersController::getReceivedItems($orderNumber);
		return $recordData;
	}

	private function processRecord($record) {
		$deductionPattern = $this->deductionPattern;
		$badCodePattern = "/^\d{5}$/";
		$accountData = $record->getFieldValue('Account_Name');
		$contactData = $record->getFieldValue('Contact_Name');
		$contactId = '';
		if ($contactData) {
			$contactId = $contactData->getEntityId();
		}
		$products = $record->getLineItems();
		$productArray = array();
		$deduction = 0.0;
		$state = $record->getFieldValue('Shipping_State');
		if (!$state) {
			$state = $record->getFieldValue('Billing_State');
		}
		foreach ($products as $product) {
			$productInfo = $this->processProduct($product);
			if (preg_match($deductionPattern, $productInfo['name'])) {
				$deduction += (float)$productInfo['total'];
			}
			array_push($productArray, $productInfo);
		}
		$account = array(
			'Account_Id' => $accountData->getEntityId(),
			'Account_Name' => $accountData->getLookupLabel()
		);
		$salesperson = array(
			'Owner_Id' => $record->getOwner()->getId(),
			'Owner' => $record->getOwner()->getName()
		);
		$contact = array(
			'Contact_Id' => $contactId
		);
		$invoice = array(
			'Invoice_Id' => $record->getEntityId(),
			'MTS_Quote_Number' => $record->getFieldValue('MTS_Quote_Number'),
			'Purchase_Order' => $record->getFieldValue('Purchase_Order'),
			'Serial_Number' => $record->getFieldValue('Serial_Number'),
			'AP_Data_Present' => $record->getFieldValue('AP_Data_Present'),
			'Account_Id' => $accountData->getEntityId(),
			'Account_Name' => $accountData->getLookupLabel(),
			'Subject' => $record->getFieldValue('Subject'),
			'Owner' => $record->getOwner()->getName(),
			'Owner_Id' => $record->getOwner()->getId(),
			'Created_Time' => $record->getCreatedTime(),
			'Status' => $record->getFieldValue('Status'),
			'State' => $state,
			'Products' => $productArray,
			'Total' => $record->getFieldValue('Sub_Total'),
			'Deduction' => $deduction
		);
		$shipping = array(
			'Invoice_Id' => $invoice['Invoice_Id'],
			'Ship_Date' => $record->getFieldValue('Ship_Date'),
			'Ship_Method' => $record->getFieldValue('Ship_Method'),
			'Tracking_Number_1' => $record->getFieldValue('Tracking_Number_1'),
			'Tracking_Number_2' => $record->getFieldValue('Tracking_Number_2'),
			'Tracking_Number_3' => $record->getFieldValue('Tracking_Number_3'),
			'Tracking_Number_4' => $record->getFieldValue('Tracking_Number_4'),
			'Tracking_Number_5' => $record->getFieldValue('Tracking_Number_5')
		);
		if ($record->getFieldValue('Quote_Stage')) {
			$invoice['Quote_Stage'] = $record->getFieldValue('Quote_Stage');
		}
		$recordData = array(
			'account' => $account,
			'contact' => $contact,
			'salesperson' => $salesperson,
			'shipping' => $shipping,
			'invoice' => $invoice,
			'lineItems' => $productArray
		);
		return $recordData;
	}

	private function processProduct($product) {

		// Put product info into variables
		$total = (float)$product->getTotal();
		$productId = $product->getProduct()->getEntityId();
		$productCode = $product->getProduct()->getFieldValue('Product_Code');
		$productName = $product->getProduct()->getLookupLabel();
		$productDescription = $product->getDescription();
		$productQuantity = $product->getQuantity();

		$productInfo = array(
			'id' => $productId,
			'code' => $productCode,
			'name' => $productName,
			'description' => $productDescription,
			'quantity' => $productQuantity,
			'total' => $total
		);

		return $productInfo;
	}

	private function escapeString($string) {
		$toEscape = array('(', ')', ',');
		$escapedStrings = array("\(", "\)", "\,");
		$string = str_replace($toEscape, $escapedStrings, $string);
		return $string;
	}
}
?>
