<?php

class Wufoo extends Database {
    
    //send request via curl to Wufoo API
    function communicate($parameters) {
        
        $curl = curl_init(WUFOO_URL.$parameters);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_USERPWD, WUFOO_API_KEY);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);                          
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);                           
        curl_setopt($curl, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');

        $response = curl_exec($curl);
        $resultStatus = curl_getinfo($curl);

        //return resultset
        if($resultStatus['http_code'] == 200) {
            return @simplexml_load_string($response);
        } else {
            return @simplexml_load_string($resultStatus);
        }

    }
    
    //parse formHash and filter
    function get_entries($formHash,$filter){
        
        $str_filter = '';
        
        if(is_array($filter)){
            
            foreach ($filter as $k => $v){
                $str_filter .= $k.'='.$v;
            }
        }
        
        //build parameter string
        if ($str_filter != ''){
            $parameters = $formHash.'/entries.xml?system=true&pageStart=0&pageSize=100&'.$str_filter;
        }else{
            $parameters = $formHash.'/entries.xml?system=true&pageStart=0&pageSize=100';
        }
        
        $response = $this->communicate($parameters);
        
        return $response;
        
    }
    
    //get records from standard quote request form
    function get_quotes($filter){
        
        return $this->get_entries('z7x1w3', $filter);
        
    }
    
    //get records from mobile quote request form
    function get_mobile_quotes($filter){
        
        return $this->get_entries('m7p8p5', $filter);
        
    }
    
    //get records from facebook quote request form
    function get_facebook_quotes($filter){
        
        return $this->get_entries('m7p7s5', $filter);
        
    }
    
    //get records from mobile order form
    function get_mobile_orders($filter){
        
        return $this->get_entries('m7p8k9', $filter);
        
    }
    
}

?>
