<?php

class Ups extends Database {

	# TXRX XML REQUESTS WITH UPS - RETURNS RESPONSE OBJECT
	function communicate($xml, $script) {
		$xmlr = $this->tx_rx_curl(UPS_SERVER . $script, '', $xml);
		$this->write_file(UPS_LABEL_PATH . $script . 'Request.xml', 'w', $xml);
		$this->write_file(UPS_LABEL_PATH . $script . 'Response.xml', 'w', $xmlr);
		return @simplexml_load_string($xmlr);
	}

	# SEND SHIP LABEL EMAIL - RETURNS BOOL
	function email_label($data, $email, $tracking) {
		global $orderObj;
		$label_file = UPS_LABEL_PATH . $tracking . '.pdf';
                $to = array(
                    'address1' => $data['cShipAddress1'], 
                    'address2' => '', 
                    'city' => $data['cShipCity'], 
                    'state' => $data['cShipState'], 
                    'zip' => $data['cShipZip'], 
                    'country' => 'US'
                    );
		$drop_offs = $this->get_dropoff_locations($to);
                return $this->send_email($email
			, $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $data)
			, $orderObj->parse_order(SHIP_RMA_SUBJECT, $data)
			, $orderObj->parse_order(SHIP_RMA_BODY, $data, array('FILE' => basename($label_file),'DROP_OFFS' => $drop_offs))
			, 'text/html'
			, array($label_file)
		);
	}

	# GETS SHIP METHODS FOR A ZIP - RETURNS HTML
	function get_shipmethods($submitted, $cSession) {
		global $warehouse_info;
		$output = '';
		if ($result = $this->verify_address(array('cShipZip' => $submitted['cShipZip']), true)) {

			# COMM FAILURE SOFT FAIL
			if ($result === 1010) {
				return $this->parse_shipmethods($cSession, array(
					'GND' => array(
						'City' => $submitted['cShipCity'], 'State' => $submitted['cShipState']
						, 'Zip' => $submitted['cShipZip'], 'Days' => '[TBD]'
					)
					, '1DA' => array(
						'City' => $submitted['cShipCity'], 'State' => $submitted['cShipState']
						, 'Zip' => $submitted['cShipZip'], 'Days' => '[TBD]'
					)
				), $submitted['cShipService']);

			# VALIDATED ZIPCODE			
			} else if ($data = $this->transit($warehouse_info, array(
						'cShipCity'			=> '' . $result[0]->Address->City
						, 'cShipState'		=> '' . $result[0]->Address->StateProvinceCode
						, 'cShipZip'		=> '' . $result[0]->PostalCodeLowEnd
						, 'cShipCountry'	=> 'US'
					), 3
				)
			) {
				return $this->parse_shipmethods(
					$cSession, $data, $submitted['cShipService'], '' . $result[0]->Address->StateProvinceCode
				);
			}
		}
                return '<span class="error">' . ADDRESS_ERROR . '</span>'.$this->parse_shipmethods($cSession, array(
                        'GND' => array(
                                'City' => $submitted['cShipCity'], 'State' => $submitted['cShipState']
                                , 'Zip' => $submitted['cShipZip'], 'Days' => '[TBD]'
                        )
                        , '1DA' => array(
                                'City' => $submitted['cShipCity'], 'State' => $submitted['cShipState']
                                , 'Zip' => $submitted['cShipZip'], 'Days' => '[TBD]'
                        )
                ), $submitted['cShipService']);
		return '<span class="error">' . ADDRESS_ERROR . '</span>';
	}

	# PARSES SHIP METHOD TEMPLATE - RETURNS HTML
	function parse_shipmethods($cSession, $data, $selected, $state) {
		global $ship_methods, $cartObj;
		$output = '';
		$i = 0;
		$category = $cartObj->get_largest_physical_category($cSession);
		foreach ($ship_methods as $key => $val) {
			if (in_array($val['ups_code2'], array_keys($data)) && is_array($val[$category])) {
				$i++;
				$spacer = '';
				$checked = '';
				if ($selected == $key) {
					$checked = ' checked="checked"';
				}
				if ($i > 1 && $val[$category]['header']) {
					$spacer = '<br /><br />';	
				}
				if (!strstr($key, 'RMA')) {
					$price = '$' . round($val[$category]['price']);
					if ($price == '$0') {
						$price = 'FREE';
					}

					# HACK FOR HI+AK ZIPCODES, REMOVE 1-DAY OPTION, OVERRIDE PRICE
					if (in_array($state, array('HI', 'AK'))) {
						if ($val['ups_code2'] == '1DA') {
							continue;
						} else if ($val['ups_code2'] == '2DA') {
							$price = '$79';
						}
					}
					$type = 'round';
					if (stristr($key, 'self')) {
						$type = 'self';
					}
                                        $date = $this->format_date('misc_4', $data[$val['ups_code2']]['Date']);
					$output .= $this->parse(SHIP_METHOD, array(
							'HEADER'	=> $spacer . $val[$category]['header']
							, 'ID'		=> $key
							, 'CHECKED'	=> $checked
							, 'PRICE'	=> $price
							, 'NAME'	=> $val[$category]['title']
							, 'CAPTION'	=> $val[$category]['caption']
							, 'DATE'	=> $this->parse(
								$val[$category]['date'], array('DATE' => ($date == '' ? 'TBA' : $date))
							)
							, 'DETAILS'	=> $val['details']
						)
					);
				}
			}
		}
		return $output;
	}

	# CREATES UPS SHIPMENT - RETURNS TRACKING AND LABEL
	function ship(
		$data, $from, $to, $method, $weight, $update_field, $returnship=false
		, $confirmation=false, $notifications=false, $saturday=false, $squareTrade=false, $printlabel=true
	) {
		global $orderObj;
		$errors = array();
		if ($squareTrade) {
			$from['cPhone'] = $from['cFax'];
			$to['cPhone'] = $to['cFax'];
		}

		# SEND SHIPPING REQUEST
		$xml = $this->get_ship_xml(
			$data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday
		);
		if ($response1 = $this->communicate($xml, 'ShipConfirm')) {
			if ($response1->Response->ResponseStatusCode == '1'
				&& $tracking = $response1->ShipmentIdentificationNumber) {

				# SEND ACCEPTANCE REQUEST
				$xml = $this->get_accept_xml($response1->ShipmentDigest, $data['oNum']);
				if ($response2 = $this->communicate($xml, 'ShipAccept')) {
					if ($response2->Response->ResponseStatusCode == '1') {

						# SAVE SHIP LABEL AND HTML TO FILES
						if ($gif2 = base64_decode(str_replace(
									' ', '+', $response2->ShipmentResults->PackageResults->LabelImage->GraphicImage
								)
							)
						) {
							$imageFileBase = UPS_LABEL_PATH . $tracking;
							$this->write_file($imageFileBase . '.gif', 'wb', $gif2);
							system('/usr/bin/convert ' . $imageFileBase . '.gif -rotate 90 -density 203 -monochrome ' . $imageFileBase . '.pdf', $retval);
                                                        if ($printlabel){
                                                            # PRINT ONLY IN PRODUCTION MODE AND NON RMA
                                                            if (MODE == 'PROD' && $returnship != 'RZ') {
                                                                    $this->send_printer(UPS_LABEL_PRINTER, $imageFileBase . '.pdf');
                                                            }
                                                        }
						}
						if ($html2 = base64_decode(str_replace(
									' ', '+', $response2->ShipmentResults->PackageResults->LabelImage->HTMLImage
								)
							)
						) {
							$this->write_file(UPS_LABEL_PATH . $tracking . '.html', 'w', $html2);
						}
						if ($html2 = base64_decode(str_replace(' ', '+',
							$response2->ShipmentResults->ControlLogReceipt->GraphicImage))) {
							$this->write_file(UPS_LABEL_PATH . $tracking . '.control.html', 'w', $html2);
						}

						# SAVE TRACKING
						$this->db_update('ds_orders', 'oNum', $data['oNum'], array($update_field => $tracking));
						$orderObj->insert_log($data['oNum'], 'shipment_created', 'Shipment Created: ' . $tracking);
						return $tracking;

					# ERROR CONDITIONS
					} else {
						$errors[] = 'UPS Communication 4: ' . $response2->Response->Error->ErrorDescription;
					}
				} else {
					$errors[] = 'UPS Communication 3: Momentarily unable to communicate.';
				}
			} else {
				$errors[] = 'UPS Communication 2: ' . $response1->Response->Error->ErrorDescription;
			}
		} else {
			$errors[] = 'UPS Communication 1: Momentarily unable to communicate.';
		}
		if ($errors) {
			$orderObj->insert_log($data['oNum'], 'shipment_error', 'Shipment Error: ' . implode(' ', $errors));
			return $errors;
		}
		return false;
	}

	# GETS UPS TRACKING INFO FOR TRACKING NUMBER - RETURNS HTML
	function track($track) {
		if (substr($track, 0, 2) == '1Z') {
			if ($parse = $this->track_data($track)) {
				return $this->parse(UPS_TRACKING, $parse);
			}
		}
		return false;
	}

	# GETS UPS PROOF OF DELIVERY SIGNATURE
	function track_signature($track, $oNum) {
		if ($response = $this->communicate($this->get_track_xml($track, $oNum, 8), 'Track')) {
			if ($response->Response->ResponseStatusCode == '1') {
				echo ' | ' . $response->Shipment->Package->Activity->ActivityLocation->SignedForByName;
				return array(
					str_replace(
						' ', '+', '' . $response->Shipment->Package->Activity->ActivityLocation->HTMLImage
					)
					, str_replace(
						' ', '+', '' . $response->Shipment->Package->Activity->ActivityLocation->SignatureImage->GraphicImage
					)
				);
			}
		}
		return false;
	}

	# GETS UPS TRACKING INFO FOR TRACKING NUMBER - RETURNS ARRAY
	function track_data($track) {
		if ($response = $this->communicate($this->get_track_xml($track), 'Track')) {
			if ($response->Response->ResponseStatusCode == '1') {
				$scheduled = '[no data]';
				if ($response->Shipment->ScheduledDeliveryDate) {
					$deliv = $this->format_date('misc_3', $response->Shipment->ScheduledDeliveryDate);
					$scheduled = $deliv . ' ' . $response->Shipment->ScheduledDeliveryTime;
				} else if ($response->Shipment->Package->RescheduledDeliveryDate) {
					$deliv = $this->format_date('misc_3', $response->Shipment->Package->RescheduledDeliveryDate);
					$scheduled = $deliv . ' ' . $response->Shipment->Package->RescheduledDeliveryTime;
				}
				$act_date = strtotime($response->Shipment->Package->Activity->Date);
				$ship_to = implode(' ', array(
					$response->Shipment->ShipTo->Address->AddressLine1
					, $response->Shipment->ShipTo->Address->AddressLine2
					, $response->Shipment->ShipTo->Address->City
					, $response->Shipment->ShipTo->Address->StateProvinceCode
				));
				$re_route = implode(' ', array(
					$response->Shipment->Package->Reroute->Address->AddressLine1
					, $response->Shipment->Package->Reroute->Address->AddressLine2
					, $response->Shipment->Package->Reroute->Address->City
					, $response->Shipment->Package->Reroute->Address->StateProvinceCode
				));
				$act_addy = implode(' ', array(
					$response->Shipment->Package->Activity->ActivityLocation->Address->AddressLine1
					, $response->Shipment->Package->Activity->ActivityLocation->Address->AddressLine2
					, $response->Shipment->Package->Activity->ActivityLocation->Address->City
					, $response->Shipment->Package->Activity->ActivityLocation->Address->StateProvinceCode
				));
				$parse = array(
					'TRACKING'		=> $track
					, 'METHOD'		=> $response->Shipment->Service->Description
					, 'SCHEDULED'	=> $scheduled
					, 'SHIP_TO'		=> $ship_to
					, 'RE_ROUTE'	=> $re_route
					, 'ACT_DATE'	=> $this->format_date('templ_date', $act_date) . ' '
									. $response->Shipment->Package->Activity->Shipment->Package->Activity->Time
					, 'ACT_DESC'	=> $response->Shipment->Package->Activity->Status->StatusType->Description
					, 'ACT_ADDY'	=> $act_addy
				);
				return $parse;
			}
		}
		return false;
	}

	# GETS UPS SHIP TIMES BETWEEN ADDRESSES - RETURNS ARRAY
	function transit($from, $to, $weight) {
		if ($response = $this->communicate($this->get_transit_xml($from, $to, $weight), 'TimeInTransit')) {
			if ($response->Response->ResponseStatusCode == '1') {
				$output = array();
				foreach ($response->TransitResponse->ServiceSummary as $service) {
					$output['' . $service->Service->Code] = array(
						'City'		=> '' . $response->TransitResponse->TransitTo->AddressArtifactFormat->PoliticalDivision2
						, 'State'	=> '' . $response->TransitResponse->TransitTo->AddressArtifactFormat->PoliticalDivision1
						, 'Zip'		=> '' . $response->TransitResponse->TransitTo->AddressArtifactFormat->PostcodePrimaryLow
						, 'Days'	=> '' . $service->EstimatedArrival->BusinessTransitDays
						, 'Date'	=> '' . $service->EstimatedArrival->Date
					);
				}
				return $output;
			}
		}
	}

	# VERIFIES ADDRESS - RETURNS NUM MATCHES, OR TRUE UPON COMM ERROR
	function verify_address($data, $return=false) {
		$xml = $this->get_AV_xml($data);
		if ($response = $this->communicate($xml, 'AV')) {
			if ($response->Response->ResponseStatusCode == '1') {
				$results = $response->AddressValidationResult;
				if ($return) {
					return $results;
				}

				# NOT RETURNING RESULTS - CHECK SCORE OF 1.0 FOR RESULT 1
				if (is_array($results)) {
					$results = $results[0];
				}
				if ($results->Quality < 1) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return 1010;
		}
		return true;
	}

	# VOIDS A UPS SHIPMENT - RETURNS BOOL OR ERROR
	function void_tracking($oNum, $tracking) {
		global $orderObj;
		$xml = $this->get_void_xml($oNum, $tracking);
		if ($response = $this->communicate($xml, 'Void')) {
			if ($response->Response->ResponseStatusCode == '1') {
				$orderObj->insert_log($oNum, 'shipment_voided', 'Shipment Voided: ' . $tracking);
				return true;
			} else {
				return (string)$response->Response->Error->ErrorDescription;
			}
		}
		return false;
	}

	# BUILDS UPS ADDRESS VERIFY XML
	function get_AV_xml($data) {
		$name = $data['cShipFname'] . ' ' . $data['cShipLname'];
		return '<?xml version="1.0"?>'
			. '<AccessRequest>'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0"?>'
			. '<AddressValidationRequest>'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $name . '</CustomerContext>'
						. '<XpciVersion>1.0</XpciVersion>'
					. '</TransactionReference>'
					. '<RequestAction>AV</RequestAction>'
				. '</Request>'
				. '<Address>'
					. '<AddressLine1>' . $data['cShipAddress1'] . '</AddressLine1>'
					. '<AddressLine2>' . $data['cShipAddress2'] . '</AddressLine2>'
					. '<City>' . $data['cShipCity'] . '</City>'
					. '<StateProvinceCode>' . $data['cShipState'] . '</StateProvinceCode>'
					. '<PostalCode>' . $data['cShipZip'] . '</PostalCode>'
					. '<CountryCode>' . $data['cShipCountry'] . '</CountryCode>'
				. '</Address>'
			. '</AddressValidationRequest>';
	}

	# BUILDS TRACKING OR SIGNATURE TRACKING REQUEST XML
	function get_track_xml($tracking, $oNum='', $request=1) {
		global $warehouse_info;
		return '<?xml version="1.0"?>'
			. '<AccessRequest xml:lang="en-US">'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0"?>'
			. '<TrackRequest xml:lang="en-US">'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $oNum . '</CustomerContext>'
						. '<XpciVersion>1.0</XpciVersion>'
					. '</TransactionReference>'
					. '<RequestAction>Track</RequestAction>'
					. '<RequestOption>' . $request . '</RequestOption>'
				. '</Request>'
				. '<TrackingNumber>' . $tracking . '</TrackingNumber>'
				. '<ShipmentType><Code>01</Code></ShipmentType>'
				. '<ShipperAccountInfo>'
					. '<PostalCode>' . $warehouse_info['cShipZip'] . '</PostalCode>'
					. '<CountryCode>' . $warehouse_info['cShipCountry'] . '</CountryCode>'
				. '</ShipperAccountInfo>'
			. '</TrackRequest>';
	}

	# BUILDS UPS SHIPMENT VOID XML
	function get_void_xml($oNum, $tracking) {
		return '<?xml version="1.0"?>'
			. '<AccessRequest xml:lang="en-US">'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0"?>'
			. '<VoidShipmentRequest>'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $oNum . '</CustomerContext>'
						. '<XpciVersion>1.0</XpciVersion>'
					. '</TransactionReference>'
					. '<RequestAction>1</RequestAction>'
					. '<RequestOption>1</RequestOption>'
				. '</Request>'
				. '<ExpandedVoidShipment>'
					. '<ShipmentIdentificationNumber>' . $tracking . '</ShipmentIdentificationNumber>'
				. '</ExpandedVoidShipment>'
			. '</VoidShipmentRequest>';
	}

	# BUILDS UPS SHIPMENT ACCEPT XML
	function get_accept_xml($digest, $oNum) {
		return '<?xml version="1.0"?>'
			. '<AccessRequest>'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0"?>'
			. '<ShipmentAcceptRequest>'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $oNum . '</CustomerContext>'
					. '</TransactionReference>'
					. '<RequestAction>ShipAccept</RequestAction>'
					. '<RequestOption>1</RequestOption>'
				. '</Request>'
				. '<ShipmentDigest>' . str_replace(' ', '+', $digest) . '</ShipmentDigest>'
			. '</ShipmentAcceptRequest>';
	}

	# BUILDS TIME IN TRANSIT XML
	function get_transit_xml($from, $to, $weight) {
                //ensure that if time is after 18:30 server time extra day gets added to shipment
                if (intval($this->format_date('hour') == 18)){
                    if (intval($this->format_date('minute') >= 30)){
                        $offset = 1;
                    }   
                }elseif(intval($this->format_date('hour') > 18)){
                    $offset = 1;
                }else{
                    $offset = false;
                }
		return '<?xml version="1.0"?>'
			. '<AccessRequest>'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0"?>'
			. '<TimeInTransitRequest>'
				. '<Request>'
					. '<RequestAction>TimeInTransit</RequestAction>'
				. '</Request>'
				. '<TransitFrom>'
					. '<AddressArtifactFormat>'
						. '<PoliticalDivision2>' . $from['cShipCity'] . '</PoliticalDivision2>'
						. '<PoliticalDivision1>' . $from['cShipState'] . '</PoliticalDivision1>'
						. '<CountryCode>' . $from['cShipCountry'] . '</CountryCode>'
						. '<PostalCodePrimaryLow>' . $from['cShipZip'] . '</PostalCodePrimaryLow>'
					. '</AddressArtifactFormat>'
				. '</TransitFrom>'
				. '<TransitTo>'
					. '<AddressArtifactFormat>'
						. '<PoliticalDivision2>' . $to['cShipCity'] . '</PoliticalDivision2>'
						. '<PoliticalDivision1>' . $to['cShipState'] . '</PoliticalDivision1>'
						. '<CountryCode>' . $to['cShipCountry'] . '</CountryCode>'
						. '<PostalCodePrimaryLow>' . $to['cShipZip'] . '</PostalCodePrimaryLow>'
					. '</AddressArtifactFormat>'
				. '</TransitTo>'
				. '<PickupDate>' . $this->format_date('ups',time(),$offset) . '</PickupDate>'
				. '<ShipmentWeight>'
					. '<UnitOfMeasurement>'
						. '<Code>LBS</Code>'
					. '</UnitOfMeasurement>'
					. '<Weight>' . $weight . '</Weight>'
				. '</ShipmentWeight>'
				. '<MaximumListSize>1</MaximumListSize>'
			. '</TimeInTransitRequest>';
	}

	# BUILDS UPS SHIPPING REQUEST XML
	function get_ship_xml(
		$data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured=false
	) {
		$serviceoptions = '';
		$returncode = '';
		$packageoptions = '';
		if ($notifications || $saturday) {
			$serviceoptions = '<ShipmentServiceOptions>';
			if ($saturday) {
				$serviceoptions .= '<SaturdayDelivery/>';
			}
			if ($notifications) {
				$serviceoptions .= '<Notification><NotificationCode>7</NotificationCode><EMailMessage><EMailAddress>' . $to['email'] . '</EMailAddress></EMailMessage></Notification>';
			}
			$serviceoptions .= '</ShipmentServiceOptions>';
		}
		if ($returnship) {
			$returncode .= '<BarCodeIndicator>' . $data['oNum'] . '</BarCodeIndicator><Code>' . $returnship . '</Code>';
		} else {
			$returncode .= '<BarCodeIndicator>' . $data['oNum'] . '</BarCodeIndicator><Code>IK</Code>';
		}
		if ($insured || $confirmation) {
			$packageoptions = '<PackageServiceOptions>';
			if ($confirmation) {
				$packageoptions .= '<DeliveryConfirmation><DCISType>2</DCISType></DeliveryConfirmation>';
			}
			if ($insured) {
				$packageoptions .= '<InsuredValue><MonetaryValue>' . $insured . '</MonetaryValue></InsuredValue>';
			}
			$packageoptions .= '</PackageServiceOptions>';
		}
		return $this->get_ship_xml_helper(
			$data['oNum']
			, $returnship ? '<ReturnService><Code>9</Code></ReturnService>' : ''
			, $to['company'] ? '<CompanyName>' . $to['company'] . '</CompanyName>' : ''
			, $from['company'] ? '<CompanyName>' . $from['company'] . '</CompanyName>' : ''
			, $serviceoptions, $returncode, $packageoptions, $to, $from, $method, $weight
		);
	}

	# GOOGLE CHECKOUT SHIPPING - RETURN XML
	function get_ship_xml_helper(
		$oNum, $returnship, $tocompany, $fromcompany, $serviceoptions
		, $returncode, $packageoptions, $to, $from, $method, $weight
	) {
		global $warehouse_info, $cartObj, $ship_methods, $ship_dimensions_from_weight;
		$category = $cartObj->get_largest_physical_category($oNum, true);
		$ship_dimensions = explode('x', $ship_dimensions_from_weight[$ship_methods[$method['name']][$category][$weight]]);
		return '<?xml version="1.0" ?>'
			. '<AccessRequest xml:lang="en-US">'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0" ?>'
			. '<ShipmentConfirmRequest>'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $oNum . '</CustomerContext>'
						. '<XpciVersion>1.0001</XpciVersion>'
					. '</TransactionReference>'
					. '<RequestAction>ShipConfirm</RequestAction>'
					. '<RequestOption>validate</RequestOption>'
				. '</Request>'
				. '<Shipment>'
					. $returnship
					. '<Shipper>'
						. '<Name>' . $warehouse_info['cShipCompany'] . '</Name>'
						. '<PhoneNumber>' . $warehouse_info['cPhone'] . '</PhoneNumber>'
						. '<ShipperNumber>' . UPS_SHIPPER . '</ShipperNumber>'
						. '<TaxIdentificationNumber>' . UPS_TAX_ID . '</TaxIdentificationNumber>'
						. '<Address>'
							. '<AddressLine1>' . $warehouse_info['cShipAddress1'] . '</AddressLine1>'
							. '<AddressLine2>' . $warehouse_info['cShipAddress2'] . '</AddressLine2>'
							. '<City>' . $warehouse_info['cShipCity'] . '</City>'
							. '<StateProvinceCode>' . $warehouse_info['cShipState'] . '</StateProvinceCode>'
							. '<PostalCode>' . $warehouse_info['cShipZip'] . '</PostalCode>'
							. '<PostcodeExtendedLow></PostcodeExtendedLow>'
							. '<CountryCode>' . $warehouse_info['cShipCountry'] . '</CountryCode>'
						. '</Address>'
					. '</Shipper>'
					. '<ShipTo>'
						. $tocompany
						. '<AttentionName>' . $to['name'] . '</AttentionName>'
						. '<PhoneNumber>' . $to['phone'] . '</PhoneNumber>'
						. '<Address>'
							. '<AddressLine1>' . $to['address1'] . '</AddressLine1>'
							. '<AddressLine2>' . $to['address2'] . '</AddressLine2>'
							. '<City>' . $to['city'] . '</City>'
							. '<StateProvinceCode>' . $to['state'] . '</StateProvinceCode>'
							. '<PostalCode>' . $to['zip'] . '</PostalCode>'
							. '<CountryCode>' . $to['country'] . '</CountryCode>'
						. '</Address>'
					. '</ShipTo>'
					. '<ShipFrom>'
						. $fromcompany
						. '<PhoneNumber>' . $from['phone'] . '</PhoneNumber>'
						. '<Address>'
							. '<AddressLine1>' . $from['address1'] . '</AddressLine1>'
							. '<AddressLine2>' . $to['address2'] . '</AddressLine2>'
							. '<City>' . $from['city'] . '</City>'
							. '<StateProvinceCode>' . $from['state'] . '</StateProvinceCode>'
							. '<PostalCode>' . $from['zip'] . '</PostalCode>'
							. '<CountryCode>' . $from['country'] . '</CountryCode>'
						. '</Address>'
					. '</ShipFrom>'
					. '<PaymentInformation>'
						. '<Prepaid>'
							. '<BillShipper><AccountNumber>' . UPS_SHIPPER . '</AccountNumber></BillShipper>'
						. '</Prepaid>'
					. '</PaymentInformation>'
					. '<Service>'
						. '<Code>' . $method['code'] . '</Code>'
						. '<Description>' . $ship_methods[$method['name']][$category]['title'] . '</Description>'
					. '</Service>'
					. $serviceoptions
					. '<Package>'
						. '<PackagingType>'
							. '<Code>02</Code>'
							. '<Description>Customer Supplied</Description>'
						. '</PackagingType>'
						. '<Dimensions>'
							. '<UnitOfMeasurement><Code>IN</Code></UnitOfMeasurement>'
							. '<Length>' . $ship_dimensions[0] . '</Length>'
							. '<Width>' . $ship_dimensions[1] . '</Width>'
							. '<Height>' . $ship_dimensions[2] . '</Height>'
						. '</Dimensions>'
						. '<Description>ACCT</Description>'
						. '<ReferenceNumber><Code>00</Code><Value>Package</Value></ReferenceNumber>'
						. '<PackageWeight><UnitOfMeasurement/><Weight>' . $ship_methods[$method['name']][$category][$weight] . '</Weight></PackageWeight>'
						. '<ReferenceNumber>'
							. $returncode
							. '<Value>' . $oNum . '</Value>'
						. '</ReferenceNumber>'
						. '<AdditionalHandling>0</AdditionalHandling>'
						. $packageoptions
					. '</Package>'
				. '</Shipment>'
				. '<LabelSpecification>'
					. '<LabelPrintMethod>'
						. '<Code>GIF</Code>'
						. '<Description>gif file</Description>'
					. '</LabelPrintMethod>'
					. '<HTTPUserAgent>Mozilla/4.5</HTTPUserAgent>'
					. '<LabelImageFormat><Code>GIF</Code><Description>gif</Description></LabelImageFormat>'
				. '</LabelSpecification>'
			. '</ShipmentConfirmRequest>';
	}
        
        function get_locator_xml($to){
            
            $doc = new DOMDocument();
            
            $doc->formatOutput = true;
            
            //create AccessRequest
            $AccessRequest = $doc->createElement('AccessRequest');
            $AccessRequest->setAttribute('xml:lang', 'en-US');
            
            $AccessLicenseNumber = $doc->createElement('AccessLicenseNumber', UPS_LOCATOR_KEY);
            $AccessRequest->appendChild($AccessLicenseNumber);
            
            $UserId = $doc->createElement('UserId', UPS_USER);
            $AccessRequest->appendChild($UserId);
            
            $Password = $doc->createElement('Password', UPS_PASSW);
            $AccessRequest->appendChild($Password);
            
            $doc->appendChild($AccessRequest);
                       
            $AccessRequestXML = $doc->saveXML();
            
            $doc = new DOMDocument();
            
            $doc->formatOutput = true;
            
            //create LocatorRequest
            $LocatorRequest = $doc->createElement('LocatorRequest');
            
            $Request = $doc->createElement('Request');

            $RequestAction = $doc->createElement('RequestAction', 'Locator');
            $Request->appendChild($RequestAction);

            $RequestOption = $doc->createElement('RequestOption', '1');
            $Request->appendChild($RequestOption);

            $TransactionReference = $doc->createElement('TransactionReference');

            $CustomerContext = $doc->createElement('CustomerContext');
            $TransactionReference->appendChild($CustomerContext);

            $XpciVersion = $doc->createElement('XpciVersion', '1.0014');
            $TransactionReference->appendChild($XpciVersion);

            $Request->appendChild($TransactionReference);
            
            $LocatorRequest->appendChild($Request);
            
            $OriginAddress = $doc->createElement('OriginAddress');
            
            $AddressKeyFormat = $doc->createElement('AddressKeyFormat');
            
            $AddressLine = $doc->createElement('AddressLine', $to['address1']);
            $AddressKeyFormat->appendChild($AddressLine);
            
            $PoliticalDivision3 = $doc->createElement('PoliticalDivision3', $to['address2']);
            $AddressKeyFormat->appendChild($PoliticalDivision3);
            
            $PoliticalDivision2 = $doc->createElement('PoliticalDivision2', $to['city']);
            $AddressKeyFormat->appendChild($PoliticalDivision2);
            
            $PoliticalDivision1 = $doc->createElement('PoliticalDivision1', $to['state']);
            $AddressKeyFormat->appendChild($PoliticalDivision1);
            
            $PostcodePrimaryLow = $doc->createElement('PostcodePrimaryLow', $to['zip']);
            $AddressKeyFormat->appendChild($PostcodePrimaryLow);
            
            $CountryCode = $doc->createElement('CountryCode', $to['country']);
            $AddressKeyFormat->appendChild($CountryCode);
            
            $OriginAddress->appendChild($AddressKeyFormat);
            
            $LocatorRequest->appendChild($OriginAddress);
            
            $Translate = $doc->createElement('Translate');
            
            $LanguageCode = $doc->createElement('LanguageCode', 'ENG');
            $Translate->appendChild($LanguageCode);
            
            $LocatorRequest->appendChild($Translate);
            
            $UnitOfMeasurement = $doc->createElement('UnitOfMeasurement');
            
            $Code = $doc->createElement('Code', 'MI');
            $UnitOfMeasurement->appendChild($Code);
            
            $LocatorRequest->appendChild($UnitOfMeasurement);
            
            $LocationSearchCriteria = $doc->createElement('LocationSearchCriteria');
            
            $SearchOption = $doc->createElement('SearchOption');
            
            $OptionType = $doc->createElement('OptionType');
            
            $Code = $doc->createElement('Code', '05');
            
            $OptionType->appendChild($Code);
            $SearchOption->appendChild(($OptionType));
            
            $OptionCode = $doc->createElement('OptionCode');
            
            $Code = $doc->createElement('Code', '01');
            
            $OptionCode->appendChild($Code);
            
            $SearchOption->appendChild(($OptionCode));
            
            $OptionCode = $doc->createElement('OptionCode');
            
            $Code = $doc->createElement('Code', '02');
            
            $OptionCode->appendChild($Code);
            
            $SearchOption->appendChild(($OptionCode));
            
            $LocationSearchCriteria->appendChild($SearchOption);
            $LocatorRequest->appendChild($LocationSearchCriteria);
            
            $doc->appendChild($LocatorRequest);
            
            $LocatorRequestXML = $doc->saveXML();
            
            $xml = $AccessRequestXML . $LocatorRequestXML;
            
            $xmlr = $this->tx_rx_curl(UPS_SERVER . 'Locator', '', $xml);
            
            //return XML
            return @simplexml_load_string($xmlr);
            
        }
        
        function get_dropoff_locations($to){
            
            //get the locator xml
            $locator = $this->get_locator_xml($to);
            
            $output = '<p>Here are some UPS droppoff locations near you:</p>';
            
            $output .= '<table>';
            
            $i = 1;

            //generate the row data and marker data
            foreach ($locator->SearchResults->DropLocation as $Droplocation){

                $output .= '<tr><td>';
                $output .= $i.'. '.$Droplocation->AddressKeyFormat->ConsigneeName;
                $output .= ' '.$Droplocation->AddressKeyFormat->AddressLine;
                $output .= ' '.$Droplocation->AddressKeyFormat->PoliticalDivision2;
                $output .= ' '.$Droplocation->AddressKeyFormat->PoliticalDivision1;
                $output .= ' '.$Droplocation->AddressKeyFormat->PostcodePrimaryLow;
                $output .= '</td><td>';
                $output .= $Droplocation->PhoneNumber;
                $output .= '</td></tr>';

                $markers .= '&markers=color:blue%7Clabel:'.$i.'%7C'.$Droplocation->Geocode->Latitude.','.$Droplocation->Geocode->Longitude;

                $i++;
            }
            
            $output .= '</table>';

            $output .= '<table><tr><td>';

            $output .= '<img src="http://maps.googleapis.com/maps/api/staticmap?size=300x300&sensor=false&scale=1'.$markers.'" />';
            
            $output .= '</td></tr></table>';
            
            //return HTML
            return $output;
            
        }
        
        # BUILDS UPS SHIPPING REQUEST XML
	function get_ship_confirm_xml(
		$data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured=false, $add_boxes, $ref1, $ref2, $packagetype='02',$packagedescription='Customer Supplied'
	) {
		$serviceoptions = '';
		$returncode = '';
		$packageoptions = '';
		if ($notifications || $saturday) {
			$serviceoptions = '<ShipmentServiceOptions>';
			if ($saturday) {
				$serviceoptions .= '<SaturdayDelivery/>';
			}
			if ($notifications) {
				$serviceoptions .= '<Notification><NotificationCode>7</NotificationCode><EMailMessage><EMailAddress>' . $to['email'] . '</EMailAddress></EMailMessage></Notification>';
			}
			$serviceoptions .= '</ShipmentServiceOptions>';
		}
		if ($returnship) {
			$returncode .= '<BarCodeIndicator>' . $data['oNum'] . '</BarCodeIndicator><Code>' . $returnship . '</Code>';
		} else {
			$returncode .= '<Code>IK</Code>';
		}
		if ($insured || $confirmation) {
			$packageoptions = '<PackageServiceOptions>';
			if ($confirmation) {
				$packageoptions .= '<DeliveryConfirmation><DCISType>'.$confirmation.'</DCISType></DeliveryConfirmation>';
			}
			if ($insured) {
				$packageoptions .= '<InsuredValue><MonetaryValue>' . $insured . '</MonetaryValue></InsuredValue>';
			}
			$packageoptions .= '</PackageServiceOptions>';
		}
                $packages = 1 + (int)$add_boxes;
		$xml = $this->get_ship_confirm_xml_helper(
			$data['oNum']
			, $returnship ? '<ReturnService><Code>'.$returnship.'</Code></ReturnService>' : ''
			, $to['company'] ? '<CompanyName>' . $to['company'] . '</CompanyName>' : ''
			, $from['company'] ? '<CompanyName>' . $from['company'] . '</CompanyName>' : ''
			, $serviceoptions, $returncode, $packageoptions, $to, $from, $method, $weight, $packages, $ref1, $ref2, $packagetype, $packagedescription
		);
                
                return $xml;
                
	}

	# GOOGLE CHECKOUT SHIPPING - RETURN XML
	function get_ship_confirm_xml_helper(
		$oNum, $returnship, $tocompany, $fromcompany, $serviceoptions
		, $returncode, $packageoptions, $to, $from, $method, $weight, $packages, $ref1, $ref2, $packagetype, $packagedescription
	) {
		global $warehouse_info, $cartObj, $ship_methods, $ship_dimensions_from_weight;
		//$category = $cartObj->get_largest_physical_category($oNum, true);
		//$ship_dimensions = explode('x', $ship_dimensions_from_weight[$ship_methods[$method['name']][$category][$weight]]);
		$return = '<?xml version="1.0" ?>'
			. '<AccessRequest xml:lang="en-US">'
				. '<AccessLicenseNumber>' . UPS_ACCESS_KEY . '</AccessLicenseNumber>'
				. '<UserId>' . UPS_USER . '</UserId>'
				. '<Password>' . UPS_PASSW . '</Password>'
			. '</AccessRequest>'
			. '<?xml version="1.0" ?>'
			. '<ShipmentConfirmRequest>'
				. '<Request>'
					. '<TransactionReference>'
						. '<CustomerContext>' . $oNum . '</CustomerContext>'
						. '<XpciVersion>1.0001</XpciVersion>'
					. '</TransactionReference>'
					. '<RequestAction>ShipConfirm</RequestAction>'
					. '<RequestOption>validate</RequestOption>'
				. '</Request>'
				. '<Shipment>'
					. $returnship
					. '<Shipper>'
						. '<Name>' . $warehouse_info['cShipCompany'] . '</Name>'
						. '<PhoneNumber>' . $warehouse_info['cPhone'] . '</PhoneNumber>'
						. '<ShipperNumber>' . UPS_SHIPPER . '</ShipperNumber>'
						. '<TaxIdentificationNumber>' . UPS_TAX_ID . '</TaxIdentificationNumber>'
						. '<Address>'
							. '<AddressLine1>' . $warehouse_info['cShipAddress1'] . '</AddressLine1>'
							. '<AddressLine2>' . $warehouse_info['cShipAddress2'] . '</AddressLine2>'
							. '<City>' . $warehouse_info['cShipCity'] . '</City>'
							. '<StateProvinceCode>' . $warehouse_info['cShipState'] . '</StateProvinceCode>'
							. '<PostalCode>' . $warehouse_info['cShipZip'] . '</PostalCode>'
							. '<PostcodeExtendedLow></PostcodeExtendedLow>'
							. '<CountryCode>' . $warehouse_info['cShipCountry'] . '</CountryCode>'
						. '</Address>'
					. '</Shipper>'
					. '<ShipTo>'
						. $tocompany
						. '<AttentionName>' . $to['name'] . '</AttentionName>'
						. '<PhoneNumber>' . $to['phone'] . '</PhoneNumber>'
						. '<Address>'
							. '<AddressLine1>' . $to['address1'] . '</AddressLine1>'
							. '<AddressLine2>' . $to['address2'] . '</AddressLine2>'
                                                        . '<AddressLine3>' . $to['address3'] . '</AddressLine3>'
							. '<City>' . $to['city'] . '</City>'
							. '<StateProvinceCode>' . $to['state'] . '</StateProvinceCode>'
							. '<PostalCode>' . $to['zip'] . '</PostalCode>'
							. '<CountryCode>' . $to['country'] . '</CountryCode>'
						. '</Address>'
					. '</ShipTo>'
					. '<ShipFrom>'
						. $fromcompany
						. '<PhoneNumber>' . $from['phone'] . '</PhoneNumber>'
						. '<Address>'
							. '<AddressLine1>' . $from['address1'] . '</AddressLine1>'
							. '<AddressLine2>' . $to['address2'] . '</AddressLine2>'
							. '<City>' . $from['city'] . '</City>'
							. '<StateProvinceCode>' . $from['state'] . '</StateProvinceCode>'
							. '<PostalCode>' . $from['zip'] . '</PostalCode>'
							. '<CountryCode>' . $from['country'] . '</CountryCode>'
						. '</Address>'
					. '</ShipFrom>'
					. '<PaymentInformation>'
						. '<Prepaid>'
							. '<BillShipper><AccountNumber>' . UPS_SHIPPER . '</AccountNumber></BillShipper>'
						. '</Prepaid>'
					. '</PaymentInformation>'
					. '<Service>'
						. '<Code>' . $method . '</Code>'
						. '<Description>' . $method . '</Description>'
					. '</Service>'
					. $serviceoptions;
                                for($i=1;$i<=$packages;$i++){    
					$return .= '<Package>'
						. '<PackagingType>'
							. '<Code>' . $packagetype .'</Code>'
							. '<Description>' .$packagedescription. '</Description>'
						. '</PackagingType>'
						. '<Description>ACCT</Description>'
						. '<PackageWeight><UnitOfMeasurement/><Weight>' . $weight . '</Weight></PackageWeight>'
                                                . '<ReferenceNumber>'
							. '<Code>00</Code>'
							. '<Value>' . $ref1 . '</Value>'
						. '</ReferenceNumber>'
                                                . '<ReferenceNumber>'
							. '<Code>00</Code>'
							. '<Value>' . $ref2 . '</Value>'
						. '</ReferenceNumber>'
						. '<AdditionalHandling>0</AdditionalHandling>'
						. $packageoptions
					. '</Package>';
                                }
				$return .= '</Shipment>'
				. '<LabelSpecification>'
					. '<LabelPrintMethod>'
						. '<Code>GIF</Code>'
						. '<Description>gif file</Description>'
					. '</LabelPrintMethod>'
					. '<HTTPUserAgent>Mozilla/4.5</HTTPUserAgent>'
					. '<LabelImageFormat><Code>GIF</Code><Description>gif</Description></LabelImageFormat>'
				. '</LabelSpecification>'
			. '</ShipmentConfirmRequest>';
                                
                return $return;
	}
        
        function ship_worldship(
		$data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured=false, $add_boxes, $ref1, $ref2, $print=true, $tries=0, $packagetype='02',$packagedescription='Customer Supplied'
	) {
		global $orderObj;
		/*$errors = array();
                $return = array();*/
                $result = array();
                
                $tries++;

		# SEND SHIPPING REQUEST
		$xml = $this->get_ship_confirm_xml(
			$data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured=false, $add_boxes, $ref1, $ref2, $packagetype, $packagedescription
		);
		if ($response1 = $this->communicate($xml, 'ShipConfirm')) {
			if ($response1->Response->ResponseStatusCode == '1'
				&& $tracking = $response1->ShipmentIdentificationNumber) {

				# SEND ACCEPTANCE REQUEST
				$xml = $this->get_accept_xml($response1->ShipmentDigest, 'Worldship');
				if ($response2 = $this->communicate($xml, 'ShipAccept')) {
					if ($response2->Response->ResponseStatusCode == '1') {
                                            
                                            $i = 0;
                                            foreach ($response2->ShipmentResults->PackageResults as $PackageResults){
                                                
                                                $tracking = $PackageResults->TrackingNumber;
                                                
                                                # SAVE SHIP LABEL AND HTML TO FILES
						if ($gif2 = base64_decode(str_replace(
									' ', '+', $PackageResults->LabelImage->GraphicImage
								)
							)
						) {
							$imageFileBase = UPS_LABEL_PATH . $tracking;
							$this->write_file($imageFileBase . '.gif', 'wb', $gif2);
							system('/usr/bin/convert ' . $imageFileBase . '.gif -rotate 90 -density 203 -monochrome ' . $imageFileBase . '.pdf', $retval);
                                                        
                                                        if ($_SESSION['large_printer_id']){
                                                            $large_printer_id = $_SESSION['large_printer_id'];
                                                        }else{
                                                            $large_printer_id = 1;
                                                        }
                                                        
                                                        $large_printer = $this->db_select_single('large_printers', '*', array('large_printer_id' => $large_printer_id));

							# PRINT ONLY IN PRODUCTION MODE AND NON RMA
							if (MODE == 'PROD' && $returnship != 'RZ' && $print) {
                                                                /*if ($from['company'] == 'SourcePlus'){
                                                                    $this->send_printer(ZEBRA_SOURCEPLUS_LARGE_PRINTER, $imageFileBase . '.pdf');
                                                                }else{
                                                                    $this->send_printer(UPS_LABEL_PRINTER, $imageFileBase . '.pdf');
                                                                }*/
                                                                $this->send_printer(constant($large_printer['large_printer_queue']), $imageFileBase . '.pdf');
                                                        }
								
						}
						if ($html2 = base64_decode(str_replace(
									' ', '+', $PackageResults->LabelImage->HTMLImage
								)
							)
						) {
							$this->write_file(UPS_LABEL_PATH . $tracking . '.html', 'w', $html2);
						}
						if ($html2 = base64_decode(str_replace(' ', '+',
							$response2->ShipmentResults->ControlLogReceipt->GraphicImage))) {
							$this->write_file(UPS_LABEL_PATH . $tracking . '.control.html', 'w', $html2);
						}
                                                
                                                $result[$i]['status'] = 'Success';
                                                $result[$i]['tracking'] = $tracking;
                                                $result[$i]['total_charge'] = $response1->ShipmentCharges->TotalCharges->MonetaryValue;
                                                
                                                $i++;
                                                
                                            }
                                                
                                            return $result;

					# ERROR CONDITIONS
					} else {
						$result['error'] = 'UPS Communication 4: ' . $response2->Response->Error->ErrorDescription;
					}
				} else {
                                        if ($tries < 5){
                                            $this->ship_worldship(
                                                $data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured, $add_boxes, $ref1, $ref2, $print, $tries
                                            );
                                            exit;
                                        }
					$result['error'] = 'UPS Communication 3: Momentarily unable to communicate.';
				}
			} else {
				$result['error'] = 'UPS Communication 2: ' . $response1->Response->Error->ErrorDescription;
			}
		} else {
                        if ($tries < 5){
                            $this->ship_worldship(
                                $data, $from, $to, $method, $weight, $returnship, $confirmation, $notifications, $saturday, $insured, $add_boxes, $ref1, $ref2, $print, $tries
                            );
                            exit;
                        }
			$result['error'] = 'UPS Communication 1: Momentarily unable to communicate.';
		}
		if ($result['error']) {
                    $orderObj->insert_log($data['oNum'], 'shipment_error', 'Shipment Error: ' . $result['error']);
                    $result['status'] = 'Fail';
                    return $result;
		}
                
                $result['error'] = 'Unspecified error encountered.';
                $result['status'] = 'Fail';
                
		return $result;
	}
}

?>
