<?php

/**
 * Description of class_timesheet
 *
 * @author jeffpaff
 */
class Timesheet extends Database {

    var $pto_multiplier = .0213;

    /**
     * $pay_period(
     *          period_name,
     *          period_start_date,
     *          period_end_date,
     *          period_pay_date
     * )
     * 
     * @param array $pay_period array as specified above
     * 
     * returns boolean
     * 
     */
    function add_pay_period($pay_period = array()) {

        if ($this->db_insert('ts_pay_period', $pay_period)) {

            $start_date = $this->format_date('db_date', strtotime($pay_period['period_start_date']));
            $end_date = $this->format_date('db_date', strtotime($pay_period['period_end_date']));

            $sql = 'call fill_calendar("' . $start_date . '","' . $end_date . '")';

            $this->db_query($sql, 'stored-proc');

            return true;
        } else {
            return false;
        }
    }

    /**
     * $pay_period(
     *          period_id
     *          period_name,
     *          period_start_date,
     *          period_end_date,
     *          period_pay_date
     * )
     * 
     * @param array $pay_period array as specified above
     * 
     * returns boolean
     * 
     */
    function update_pay_period($period_id, $pay_period = array()) {

        if ($ts_timesheet = $this->db_select_multiple('ts_timesheet', '*', array('period_id' => $period_id))) {

            return false;
        }

        $update = $this->db_update('ts_pay_period', 'period_id', $period_id, $pay_period);

        if ($update !== false) {

            $start_date = $this->format_date('db_date', strtotime($pay_period['period_start_date']));
            $end_date = $this->format_date('db_date', strtotime($pay_period['period_end_date']));

            $sql = 'call fill_calendar("' . $start_date . '","' . $end_date . '")';

            $this->db_query($sql, 'stored-proc');

            return true;
        } else {
            return false;
        }
    }

    function delete_pay_period($period_id) {

        if ($ts_timesheet = $this->db_select_multiple('ts_timesheet', '*', array('period_id' => $period_id))) {

            return false;
        } else {
            $this->db_delete('ts_pay_period', 'period_id', $period_id);

            return true;
        }
    }

    function create_timesheet($aid, $period_id) {

        if (!$timesheet = $this->db_select_single('ts_timesheet', '*', array('timesheet_aid' => $aid, 'period_id' => $period_id))) {

            $pay_period = $this->db_select_single('ts_pay_period', 'period_start_date,period_end_date', array('period_id' => $period_id));

            $timesheet_id = $this->db_insert('ts_timesheet', array('timesheet_aid' => $aid, 'period_id' => $period_id, 'timesheet_submitted' => '0'));

            $calendar = $this->db_select_multiple(
                    'ts_calendar'
                    , 'ts_date'
                    , array()
                    , 'where ts_date between "' . $pay_period['period_start_date'] . '" and "' . $pay_period['period_end_date'] . '"'
            );

            foreach ($calendar as $row) {

                $data = array(
                    'timesheet_id' => $timesheet_id
                    , 'timesheet_detail_date' => $row['ts_date']
                );

                $this->db_insert('ts_timesheet_detail', $data);
            }

            return $timesheet_id;
        } else {

            return false;
        }
    }

    function update_timesheet($timesheet_detail_id, $data) {


        $this->db_update('ts_timesheet_detail', 'timesheet_detail_id', $timesheet_detail_id, $data);
    }

    function submit_timesheet($timesheet_id) {

        $timesheet = $this->db_select_single('ts_timesheet', '*', array('timesheet_id' => $timesheet_id));

        $pay_period = $this->db_select_single('ts_pay_period', '*', array('period_id' => $timesheet['period_id']));

        if ($last_pay_period = $this->db_select_single('ts_pay_period', '*', array(), 'where period_start_date < "' . $pay_period['period_start_date'] . '" order by period_start_date desc limit 0,1')) {

            if ($last_timesheet = $this->db_select_single('ts_timesheet', '*', array('timesheet_aid' => $timesheet['timesheet_aid'], 'period_id' => $last_pay_period['period_id']))) {
                $last_pto = (float) $last_timesheet['timesheet_pto_total'];
            }
        } else {
            $last_pto = 0;
        }

        //$last_timesheet = $this->db_select_single('ts_timesheet', '*', array('timesheet_aid' => $timesheet['timesheet_aid'], 'period_id' => $last_pay_period['period_id']));

        $hours = $this->db_select_single(
                'ts_timesheet_detail', 'sum(timesheet_detail_hours + timesheet_detail_overtime) hours, sum(timesheet_detail_pto) pto', array('timesheet_id' => $timesheet_id)
        );

        $pto = (float) $hours['hours'] * $this->pto_multiplier;

        //$pto = $pto - $hours['pto'] + $last_pto;

        $this->db_update('ts_timesheet', 'timesheet_id', $timesheet_id, array('timesheet_submitted' => '1', 'timesheet_pto_total' => $pto));
    }

    function generate_spreadsheet($period_id) {

        //get timesheet records
        if ($timesheet = $this->db_select_multiple(
                'ts_timesheet_detail td', 'da.aUser,
                     da.aID,
                     pp.period_name, 
                     ts.timesheet_submitted,
                     ts.period_id,
                     ts.timesheet_pto_total pto_total,
                     date_format(td.timesheet_detail_date,"%e-%b") td_date, 
                     date_format(td.timesheet_detail_date,"%W") td_day, 
                     date_format(td.timesheet_detail_start_time,"%H:%i") td_start,
                     date_format(td.timesheet_detail_end_time,"%H:%i") td_end,
                     td.timesheet_detail_hours td_hours,
                     td.timesheet_detail_overtime td_overtime,
                     td.timesheet_detail_pto td_pto', array('ts.period_id' => $period_id, 'da.aTimesheet' => 'Y'), 'order by da.aUser, td.timesheet_detail_date', array(
            'ts_timesheet ts on ts.timesheet_id = td.timesheet_id',
            'ds_admins da on da.aID = ts.timesheet_aid',
            'ts_pay_period pp on pp.period_id = ts.period_id'
                )
        )) {

            $dates = array();

            //generate initial date row
            foreach ($timesheet as $row) {

                if (!in_array($row['td_day'] . '<br />' . $row['td_date'], $dates)) {
                    $dates[] = $row['td_day'] . '<br />' . $row['td_date'];
                }
            }

            //create table
            $output .= '<table style="padding:0px;" cellpadding="1" cellspacing="0"><tr><td style="border:1px;border-style:solid;">User</td><td style="border-bottom: 1px solid black;border-top: 1px solid black;border-right: 1px solid black;" width="70px"></td>';

            foreach ($dates as $row) {
                $output .= '<td style="border-bottom: 1px solid black;border-top: 1px solid black;border-right: 1px solid black;" width="70px">' . $row . '</td>';
            }

            $output .= '<td style="border-bottom: 1px solid black;border-top: 1px solid black;border-right: 1px solid black;" width="70px">
                                <strong>Total</strong>
                            </td>
                            <td style="border-bottom: 1px solid black;border-top: 1px solid black;border-right: 1px solid black;" width="70px">
                                <strong>Accumulated<br /> PTO</strong>
                            </tr>';

            $i = 0;

            $count = 0;

            //generate timesheet records
            foreach ($timesheet as $row) {

                if ($i == 0) {
                    $start .= '<tr>';
                    $start .= '<td style="border-left: 1px solid black;" width="70px"><a href="' . CONTROLLER . '?m=timesheet&aid=' . $row['aID'] . '&period_id=' . $row['period_id'] . '">' . $row['aUser'] . '</a></td>';
                    $start .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px">Start</td>';
                    $end .= '<tr>';
                    $end .= '<td style="border-left: 1px solid black;" width="70px"></td>';
                    $end .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px">Finish</td>';
                    $hours .= '<tr>';
                    $hours .= '<td style="border-left: 1px solid black;" width="70px"></td>';
                    $hours .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px">Hours</td>';
                    $overtime .= '<tr>';
                    $overtime .= '<td style="border-left: 1px solid black;" width="70px"></td>';
                    $overtime .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px">Overtime</td>';
                    $pto .= '<tr>';
                    $pto .= '<td style="border-left: 1px solid black;" width="70px"></td>';
                    $pto .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px">PTO</td>';
                    $total .= '<tr>';
                    $total .= '<td style="border-left: 1px solid black;border-bottom: 1px solid black;" width="70px">' . ($row['timesheet_submitted'] == 1 ? '<font color="green">Submitted</font>' : '') . '</td>';
                    $total .= '<td style="border-bottom: 1px solid black;border-left: 1px solid black;border-right: 1px solid black;" width="70px"><strong>Total</strong></td>';
                }

                $start .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . ($row['td_start'] == '00:00' ? '' : $row['td_start']) . '</td>';
                $end .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . ($row['td_end'] == '00:00' ? '' : $row['td_end']) . '</td>';
                $hours .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . ($row['td_hours'] == '0' ? '' : $row['td_hours']) . '</td>';
                $overtime .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . ($row['td_overtime'] == '0' ? '' : $row['td_overtime']) . '</td>';
                $pto .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . ($row['td_pto'] == '0' ? '' : $row['td_pto']) . '</td>';

                $sum = 0;

                $sum = $row['td_hours'] + $row['td_overtime'] + $row['td_pto'];

                $hours_total += $row['td_hours'];
                $overtime_total += $row['td_overtime'];
                $pto_total += $row['td_pto'];
                $total_total += $sum;

                $total .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;"><strong>' . ($sum == 0 ? '' : $sum) . '</strong></td>';

                $i++;

                if ($i == count($dates)) {
                    $i = 0;
                    $start .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;"></td><td style="border-right: 1px solid black;"></td></tr>';
                    $end .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;"></td><td style="border-right: 1px solid black;"></tr>';
                    $hours .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . $hours_total . '</td><td style="border-right: 1px solid black;"></tr>';
                    $overtime .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . $overtime_total . '</td><td style="border-right: 1px solid black;"></tr>';
                    $pto .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;">' . $pto_total . '</td><td style="border-right: 1px solid black;border-bottom: 1px solid black;"></tr>';
                    $total .= '<td style="border-right: 1px solid black;border-bottom: 1px solid black;"><strong>' . $total_total . '</strong></td><td style="border-right: 1px solid black;border-bottom: 1px solid black;"><strong>' . ($row['pto_total'] == 0 ? '' : $row['pto_total']) . '</strong></tr>';

                    $output .= $start;
                    $output .= $end;
                    $output .= $hours;
                    $output .= $overtime;
                    $output .= $pto;
                    $output .= $total;

                    if ($count + 1 != count($timesheet)) {
                        $output .= '<tr><td style="border-right: 1px solid black;border-bottom: 1px solid black;border-left: 1px solid black;background-color:LightGray;" colspan="' . (count($dates) + 4) . '">&nbsp;</td></tr>';
                    }
                    $start = '';
                    $end = '';
                    $hours = '';
                    $overtime = '';
                    $pto = '';
                    $total = '';

                    $hours_total = 0;
                    $overtime_total = 0;
                    $pto_total = 0;
                    $total_total = 0;
                }

                $count++;
            }

            $output .= '</table>';
        } else {//no records for pay period
            $output = '<p><strong>No time sheets currently exist for the selected pay period.</strong></p>';
        }
        
        return $output;
    }

}

?>
