<?php

class Squaretrade extends Framework {

	# SQUARETRADE CLAIM ID FINDER - RETURNS #
	function get_squaretrade_id($data) {
		$claim = false;
		$claim1 = explode("\n", $data);
		foreach ($claim1 as $claim2) {
			if (stristr($claim2, 'claim id: ')) {
				return substr($claim2, 10, 10);
			}
		}
		return $claim;
	}

	# SQUARETRADE - SENDS EMAIL FROM PARSED INTEGRATION VAR ARRAY - RETURNS BOOL
	function send_squaretrade_email($odata, $data) {
		global $orderObj;
		$body = '';
		foreach ($data as $key => $val) {
			$body .= $key . ' : [' . $val . ']' . "\n";
		}
		if ($this->send_email(
				SQUARETRADE_TO_EMAIL
				, $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $odata)
				, 'Email Type : [' . $data['Email Type'] . '] ST Case ID : [' . $data['ST Case ID'] . ']'
				, $body
				, 'text/plain'
			)
		) {
			return true;
		}
		return false;
	}

	# SQUARETRADE INTEGRATION
	function squaretrade_integration($action, $oNum, $data) {
		global $ship_methods;
		$data = array_merge($data, array('oNum' => $oNum));
		if (!$claim = $this->get_squaretrade_id($data['problem'])) {
			$this->error_page(
				'Unable to find the claim number from the problem description field.<br />'
				. 'It should be located at the very beginning of Admin Notes as Claim ID: 0000123456.'
			);
		}

		# SENDS EMAIL
		switch ($action) {
			case 'NEW-ORDER':
				$parse = array(
					'Email Type'			=> 'ClaimReceived'
					, 'ST Case ID'			=> '#' . $claim
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
			case STATUS_SHIP_1:
				$parse = array(
					'Email Type'			=> 'BoxOut'
					, 'ST Case ID'			=> '#' . $claim
					, 'Tracking Number'		=> $data['ship_tracking_id']
					, 'UPS Method'			=> $ship_methods[$data['cShipService']]['ups_name']
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
			case STATUS_READY:
				$parse = array(
					'Email Type'			=> 'FacilityReceipt'
					, 'ST Case ID'			=> '#' . $claim
					, 'Tracking Number'		=> $data['ship_tracking_id2']
					, 'Shipping/Handling Cost'	=> $data['cShipping']
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
			case 'TECH-NOTE-ADDED':
				$parse = array(
					'Email Type'			=> 'AuditCompleted'
					, 'ST Case ID'			=> '#' . $claim
					, 'AuditReason'			=> 'Failed'
					, 'AuditReasonFailure'		=> $data['nNote']
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
			case STATUS_SHIP_2:
				$parse = array(
					'Email Type'			=> 'ClaimCompleted'
					, 'ST Case ID'			=> '#' . $claim
					, 'Labor Cost'			=> '0.00'
					, 'Parts Cost'			=> round($data['cSubTotal'] - $data['cDiscount'], 2)
					, 'Shipping/Handling Cost'	=> $data['cShipping']
					, 'Shipping Date'		=> $this->format_date('templ_date')
					, 'Tracking Number'		=> $data['ship_tracking_id3']
					, 'UPS Method'			=> $ship_methods[$data['cShipService']]['ups_name']
					, 'Tax Cost'			=> round($data['cTax'], 2)
					, 'RepairDetail'		=> $data['cShipInstruct']
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
			case STATUS_UNABLE:
				$parse = array(
					'Email Type'			=> 'ClaimBER'
					, 'ST Case ID'			=> '#' . $claim
					, 'Labor Cost'			=> '10.00'
					, 'Shipping/Handling Cost'	=> $data['cShipping']
					, 'Reason'			=> $data['nNote']
				);
				return $this->send_squaretrade_email($data, $parse);
			break;
		}
		return false;
	}
}

?>
