<?php

class SocialNet extends Framework {

	# GEO RSS FEED - RETURNS XML
	function geo_rss($title, $self, $alt, $data) {
		$o = '<?xml version="1.0" encoding="utf-8" standalone="yes"?>'
			. '<feed xmlns="http://www.w3.org/2005/Atom" xmlns:geo="http://www.w3.org/2003/01/geo/wgs84_pos#" xmlns:georss="http://www.georss.org/georss">'
				. '<id>' . $self . '</id><updated>' . $this->format_date('atom') . '</updated><title>' . $title . '</title>'
				. '<link rel="self" href="' . $self . '" />'
				. '<link rel="alternate" type="text/html" href="' . $alt . '"/>'
				. '<generator uri="http://www.php.net/">PHP</generator>';
		foreach ($data as $i => $row) {
			$o .= "\n" . '<entry>'
					. '<id>' . $self . '&amp;view=' . ($i + 1) . '</id>'
					. '<title>' . $row['TITLE'] . '</title>'
					. '<updated>' . $this->format_date('atom', $row['UPDATED']) . '</updated>'
					. '<content type="html">' . $row['HTML'] . '</content>'
					. '<author><name>' . $row['AUTHOR'] . '</name></author>'
					. '<georss:point>' . $row['LATITUDE'] . ' ' . $row['LONGITUDE'] . '</georss:point>'
					. '<geo:lat>' . $row['LATITUDE'] . '</geo:lat><geo:long>' . $row['LONGITUDE'] . '</geo:long>'
				. '</entry>';
		}
		return $o . '</feed>';
	}

	# BUILDS RSS 2.0 FEED - RETURNS XML
	function rss_2_0($title, $articles) {
		$o = '<?xml version="1.0"?><rss version="2.0">'
			. "<channel><title>$title</title><description>$title</description>";
		foreach ($articles as $article) {
			$o .= '<item>' . "<title>${article['TITLE']}</title><description>${article['DESC']}</description>";
			if ($link = $article['LINK']) {
				$o .= "<link>$link</link>";
			}
			$o .= '</item>';
		}
		$o .= '</channel></rss>';
		return $o;
	}

	# CONVERT ARRAY INTO RSS - OUTPUTS RSS
	function rss_feedbacks($feedbacks, $format='') {
		global $custObj;
		$data = array();
		foreach ($feedbacks as $row) {
			if ($coords = $custObj->get_coordinates_from_zip($row['cBillZip'])) {
				switch($format) {
					case 'map':
						$data[] = array(
							'TITLE'			=> $row['cBillFname'] . ' from ' . $row['cBillCity'] . ', ' . $row['cBillState']
							, 'UPDATED'		=> $row['stamp']
							, 'HTML'		=> htmlspecialchars($row['machineType'] . '<br />' . $row['content'])
							, 'AUTHOR'		=> $row['cBillFname'] . ' from ' . $row['cBillCity'] . ', ' . $row['cBillState'] . ' on ' . $row['stamp']
							, 'LATITUDE'	=> $coords[0]
							, 'LONGITUDE'	=> $coords[1]
						);
					break;
					default:
						$data[] = array(
							'TITLE'			=> substr(eregi_replace("[^0-9a-z +-;:.,'!?/]", '', strip_tags($row['content'])), 0, 250)
							, 'UPDATED'		=> $row['stamp']
							, 'HTML'		=> htmlspecialchars($row['machineType'] . '<br />' . $row['content'])
							, 'AUTHOR'		=> $row['cBillFname'] . ' from ' . $row['cBillCity'] . ', ' . $row['cBillState'] . ' on ' . $row['stamp']
							, 'LATITUDE'	=> $coords[0]
							, 'LONGITUDE'	=> $coords[1]
						);
				}
			}
		}
		return $this->geo_rss(
			SITE_NAME . ' Customer Testimonials', SITE_URL . 'service_controller.php?m=testimonials_map_xml'
			, SITE_URL . 'cart_controller.php?m=testimonials', $data
		);
	}

	# TWITTER API FUNCTIONS FOLLOW - NEEDS OAUTH CONNECTION AND CHANGES TO ORDER FORM
	/*
	function twitter_send($url, $aParameters=array(), $authenticate=false, $usePost=true) {
		$url = TWITTER_API_URL .'/'. $url;
		if (!empty($aParameters) && !$usePost) {
			$queryString = '';
			foreach ($aParameters as $key => $value) {
				$queryString .= '&'. $key .'='. urlencode(utf8_encode($value));
			}
			$queryString = trim($queryString, '&');
			$url .= '?'. $queryString;
		}
		$credentials = false;
		if ($authenticate) {
			$credentials = TWITTER_USER . ':' . TWITTER_PASS;
		}
		$response = explode('<?xml', $this->tx_rx_curl($url, 'Expect:', $aParameters, $credentials));
		$xml = @simplexml_load_string('<?xml' . $response[1]);
		if ($xml == false) {
			return false;
		}
		return $xml;
	}
	function twitter_direct($id, $text) {
		if (strlen($text) > 140) { $text = substr($text, 0, 137) . '...'; }
		return $this->twitter_send('direct_messages/new.xml', array('user' => $id, 'text' => $text), true);
	}
	function twitter_createFriendship($id, $follow=true) {
		$aParameters = array('id' => $id);
		if ($follow) { $aParameters['follow'] = $follow; }
		return $this->twitter_send('friendships/create/'. urlencode($id) .'.xml', $aParameters, true);
	}
	*/
}

?>