<?php

class Search extends Database {
    # BUILDS CHECKBOXES FOR EXPORT SELECTION FROM ARRAY - RETURNS HTML

    function checkboxes($results) {
        $checkboxes = '';
        $split = round(sizeof($results) / 4);
        for ($i = 0; $i < sizeof($results); $i++) {
            if (in_array($i, array($split, $split * 2, $split * 3))) {
                $checkboxes .= '</td><td><br /> </td><td valign="top" class="small" nowrap="nowrap">';
            }
            $checkboxes .= '<input type="checkbox" name="exportList[]" value="' . $results[$i] . '" checked>' . $results[$i] . '<br />' . "\n";
        }
        return $checkboxes;
    }

    # DISPLAY RESULTS - RETURNS HTML

    function display($search, $query, $qString, $results, $youSearched) {
        global $orderObj, $custObj, $adminObj;
        $output = '
			<p><p>Showing <strong>' . number_format(sizeof($results)) . '</strong> results, most recent
			first for: <strong><i>' . implode(', ', $youSearched) . '</i></strong><p>
		';
        switch ($search) {
            case 'orders':
                if (sizeof($results) == 1) {
                    $data = $orderObj->get_data($results[0]);
                    $this->goToURL(CONTROLLER . '?m=order_detail&oNum=' . $data['oNum']);
                }
                if ($action != 'export_orders' && $adminObj->is_super()) {
                    $parse = array(
                        'QUERY' => htmlspecialchars($query)
                        , 'C_STATUS' => $qString['cStatus']
                        , 'FROM_DATE' => $qString['fromDate']
                        , 'TO_DATE' => $qString['toDate']
                        , 'DATE_TYPE' => $qString['dt']
                    );
                    $output .= $this->parse(ORDER_EXPORT_LINKS, $parse);
                }
                return $output . $this->display_orders($results);
                break;
            case 'customers':
                if (sizeof($results) == 1) {
                    $data = $custObj->get_data($results[0]);
                    $this->goToURL(CONTROLLER . '?m=customer_detail&cString=' . $data['cString']);
                }
                return $output . $this->display_cards($results);
                break;
            case 'notes':
                rsort($results, SORT_NUMERIC);
                return $output . $this->display_notes($results, true);
                break;
        }
    }

    # DISPLAYS CUSTOMER INFO/LINKS - RETURNS HTML

    function display_cards($data) {
        global $custObj;
        $output = '
			<table width="95%" align="center" cellpadding="0" cellspacing="0">
				<tr>
					<td class="subheading1">Email</td>
					<td class="subheading1" colspan="3">Ship To</td>
					<td class="subheading1" colspan="3">Bill To</td>
					<td class="subheading1">Phone</td>
				</tr>
		';
        foreach ($data as $cID) {
            if ($data2 = $custObj->get_data($cID)) {
                $output .= '
					<tr>
						<td class="small">
							<a href="?m=customer_detail&cString=' . $data2['cString'] . '">'
                        . $data2['cEmail'] . '</a>&nbsp;&nbsp;
						</td>
						<td class="small">' . $data2['cShipCompany'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cShipFname'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cShipLname'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cBillCompany'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cBillFname'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cBillLname'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['cPhone'] . '&nbsp;&nbsp;</td>
					</tr>
					<tr>
						<td colspan="6" height="7"></td>
					</tr>
				';
            }
        }
        return $output . '</table>' . "\n";
    }

    # SHOW DEFAULT PAGE - RETURNS HTML

    function display_default() {
        global $adminObj;
        $total = 0;
        $o = '';
        $counts = $this->get_order_status_counts();
        foreach ($counts as $count) {
            $o .= '
				<tr>
					<td class="small" nowrap="nowrap">
						<a href="' . CONTROLLER . '?m=search&s=orders&cStatus='
                    . str_replace(' ', '+', $count['cStatus']) . '">' . $count['cStatus'] . '</a>
					</td>
					<td><br /></td>
					<td class="small" align="right">' . number_format($count['quantity']) . '</td>
				</tr>
			';
            $total += $count['quantity'];
        }

        $educational = $this->get_educational_count();

        $o .= '
                        <tr>
                                <td class="small" nowrap="nowrap">
                                        <a href="' . CONTROLLER . '?m=search&s=orders&cStatus=Education">Education</a>
                                </td>
                                <td><br /></td>
                                <td class="small" align="right">' . number_format($educational['quantity']) . '</td>
                        </tr>
                ';

        $results = array();
        $links = '';
        list($results, $youSearched) = $this->run('orders', '', '', '', $this->format_date('db_date'));
        if ($results) {
            $links = $this->display_orders($results, false);
        }

        # GET RECEIVED TODAY DATA
        $ups = 0;
        $fedex = 0;
        $dhl = 0;
        $usps = 0;
        $out = 0;
        if ($rows = $this->db_select_multiple(
                'nl_received_today', '*', array('day' => $this->format_date('db_date'))
                )
        ) {
            foreach ($rows as $row) {
                switch ($row['carrier']) {
                    case 'ups':
                        $ups += $row['quantity'];
                        break;
                    case 'fedex':
                        $fedex += $row['quantity'];
                        break;
                    case 'dhl':
                        $dhl += $row['quantity'];
                        break;
                    case 'usps':
                        $usps += $row['quantity'];
                        break;
                    case 'out':
                        $out += $row['quantity'];
                        break;
                }
            }
        }

        # OUTPUT
        return $this->parse(
                        DEFAULT_PAGE_NEW
                        , array(
                    'TOTAL' => number_format($total)
                    , 'STATII' => $o
                    , 'TODAYS' => sizeof($results)
                    , 'ORDERS' => $links
                    , 'R_UPS' => $ups
                    , 'R_FEDEX' => $fedex
                    , 'R_DHL' => $dhl
                    , 'R_USPS' => $usps
                    , 'R_TOTAL' => ($ups + $fedex + $dhl + $usps)
                    , 'S_OUT' => $out
                    , 'SUPER_ADMIN' => $adminObj->is_super() ? SUPER_ADMIN_BUTTONS : ''
                        )
        );

        return false;
    }

    # DISPLAYS ORDER NOTES/LINKS - RETURNS HTML

    function display_notes($data, $showOrderNum) {
        global $orderObj;
        $output = '
			<table width="95%" align="center" cellpadding="0" cellspacing="0">
				<tr>
		';
        if ($showOrderNum) {
            $output .= '<td class="subheading1">Order</td>';
        }
        $output .= '
				<td class="subheading1">Date</td>
				<td class="subheading1" colspan="2">Sent?</td>
				<td class="subheading1">Note</td>
			</tr>
		';
        foreach ($data as $nID) {
            if ($data2 = $orderObj->get_note($nID)) {
                $output .= '<tr>';
                if ($showOrderNum) {
                    $output .= '
						<td class="small" valign="top">
							<a href="?m=order_detail&oNum=' . $data2['oNumber'] . '">'
                            . $data2['oNumber'] . '</a>&nbsp;&nbsp;
						</td>
					';
                }
                $output .= '
						<td class="small" valign="top" nowrap="nowrap">' . $this->format_date('templ_full', $data2['nDate']) . '&nbsp;&nbsp;</td>
						<td class="small" valign="top">' . $data2['nUserName'] . '&nbsp;&nbsp;</td>
						<td class="small" valign="top">' . $data2['nSent'] . '&nbsp;&nbsp;</td>
						<td class="small">' . $data2['nNote'] . '&nbsp;&nbsp;</td>
					</tr>
					<tr>
						<td colspan="5" height="7"></td>
					</tr>
				';
            }
        }
        return $output . '</table>' . "\n";
    }

    # CONVERTS ARRAY TO ORDER LINKS WITH DATA - RETURNS HTML

    function display_orders($data, $status_updates = true) {
        global $orderObj, $dd_data;

        if ($status_updates) {
            $output = '
                            <script type="text/javascript">

                            function setchkSelect(obj){
                                var field = document.update_status[\'chkSelect[]\'];
                                if (obj.checked){
                                    for (i = 0; i < field.length; i++){
                                            field[i].checked = true ;
                                    }
                                }else{
                                    for (i = 0; i < field.length; i++){
                                            field[i].checked = false ;
                                    }
                                }
                            }
                            </script>
                            <form method="post" name="update_status" action="admin_controller.php?m=update_status">

                            <table width="95%" align="center" cellpadding="0" cellspacing="5">
                                    <tr>
                                            <td></td>
                                            <td><strong>New status:</strong></td>
                                            <td colspan="2"><select id="cboStatus" name="cboStatus">' . $dd_data['STATII'] . '</select>
                                            <input type="submit" value="Update selected" /></td>
                                            <td colspan="4"></td>
                                    </tr>

                                    <tr>
                                            <td class="subheading1"><input type="checkbox" id="checkall" name="checkall" onclick="setchkSelect(this);" /></td>
                                            <td class="subheading1">Order</td>
                                            <td class="subheading1">Status</td>
                                            <td class="subheading1">Created</td>
                                            <td class="subheading1">Shipping</td>
                                            <td class="subheading1" nowrap="nowrap">Ship To</td>
                                            <td class="subheading1" nowrap="nowrap">Bill To</td>
                                            <td class="subheading1">Total</td>
                                    </tr>
                    ';
        } else {
            $output = '
                            <table width="95%" align="center" cellpadding="0" cellspacing="5">

                                    <tr>
                                            <td class="subheading1">Order</td>
                                            <td class="subheading1">Status</td>
                                            <td class="subheading1">Created</td>
                                            <td class="subheading1">Shipping</td>
                                            <td class="subheading1" nowrap="nowrap">Ship To</td>
                                            <td class="subheading1" nowrap="nowrap">Bill To</td>
                                            <td class="subheading1">Total</td>
                                    </tr>
                    ';
        }
        foreach ($data as $oID) {
            if (!$data2 = $this->db_select_single(
                    'ds_orders o'
                    , 'time,o.oNum,cDate,cStatus,cShipService,cBillFname,cBillLname,cShipFname,cShipLname,cTotal'
                    , array()
                    , 'left join ds_order_logs l on l.oNum = o.oNum '
                    . 'where details = "Order Created" and o.oID = ' . $this->qualify_value($oID)
                    )
            ) {
                $data2 = $orderObj->get_data($oID);
            }
            if ($created = $data2['time']) {
                $created = $this->format_date('templ_full', $created);
            } else {
                $created = $this->format_date('templ_full', $data2['cDate']);
            }
            if ($data2['cStatus'] == 'Void') {
                $data2['cStatus'] = '<span class="error">' . $data2['cStatus'] . '</span>';
            }

            if ($status_updates) {
                $checkcol = '<td><input type="checkbox" id="chkSelect[]" name="chkSelect[]" value="' . $data2['oNum'] . '" /></td>';
            } else {
                $checkcol = '';
            }

            $output .= '
				<tr>
                                        ' . $checkcol . '
					<td class="small" valign="top"><a href="?m=order_detail&oNum=' . $data2['oNum'] . '">' . $data2['oNum'] . '</a>&nbsp;&nbsp;</td>
					<td class="small" valign="top" nowrap="nowrap">' . $data2['cStatus'] . '&nbsp;&nbsp;</td>
					<td class="small" valign="top" nowrap="nowrap">' . $created . '&nbsp;&nbsp;</td>
					<td class="small" valign="top" nowrap="nowrap">' . $data2['cShipService'] . '&nbsp;&nbsp;</td>
					<td class="small" valign="top" nowrap="nowrap">' . $data2['cShipFname'] . ' ' . $data2['cShipLname'] . '&nbsp;&nbsp;</td>
					<td class="small" valign="top" nowrap="nowrap">' . $data2['cBillFname'] . ' ' . $data2['cBillLname'] . '&nbsp;&nbsp;</td>
					<td class="small" valign="top" align="right">$' . $data2['cTotal'] . '&nbsp;&nbsp;</td>
				</tr>
			';
        }
        return $output . '</table>' . ($status_updates ? '</form>' : '') . "\n";
    }

    # CONVERTS ARRAY TO ORDER LINKS FOR ACCT - RETURNS HTML

    function display_orders_account($data) {
        global $orderObj;
        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
				<tr>
					<td style="font-size: 10pt;">Order</td>
					<td style="font-size: 10pt;">Date</td>
					<td style="font-size: 10pt;">Status</td>
					<td style="font-size: 10pt;">Service Note</td>
					<td style="font-size: 10pt;">Machine</td>
					<td style="font-size: 10pt;">Total</td>
					<td style="font-size: 10pt;">Completed</td>
				</tr>
		';
        foreach ($data as $oNum) {
            if ($data2 = $orderObj->get_data($oNum)) {
                $completed = '';
                if ($data2['dateCompleted']) {
                    $completed = $this->format_date('templ_date', $data2['dateCompleted']);
                }
                $output .= '
					<tr>
						<td class="small" valign="top"><a href="?m=account&oNum=' . $oNum . '">' . $oNum . '</a>&nbsp;&nbsp;</td>
						<td class="small" valign="top" nowrap="nowrap">' . $this->format_date('templ_date', $data2['cDate']) . '&nbsp;&nbsp;</td>
						<td class="small" valign="top" nowrap="nowrap">' . $data2['cStatus'] . '&nbsp;&nbsp;</td>
						<td class="small" valign="top">' . $data2['cShipInstruct'] . '&nbsp;&nbsp;</td>
						<td class="small" valign="top">' . $data2['machineType'] . ' ' . $data2['serialNumber'] . '&nbsp;&nbsp;</td>
						<td class="small" valign="top" align="right">$' . $data2['cTotal'] . '&nbsp;&nbsp;</td>
						<td class="small" valign="top" nowrap="nowrap">' . $completed . '</td>
					</tr>
				';
            }
        }
        return $output . '</table>' . "\n";
    }

    # HELPER FOR ORDERS EXPORT - CART ITEM ROWS

    function export_cart_item($data, $row, $tax, $tax_rate, $line, $hardware=false) {

        # CALC DISCOUNT
        $discount = 0;
        if ($discount2 = $this->db_select_single(
                'ds_coupons c', '*'
                , array('cpCode' => $data['cpCode'], 'cp.pID' => $row['pID']), ''
                , array('ds_coupon_products cp on c.cpID = cp.cpID')
                )
        ) {
            $discount2 = $discount2['cpDiscount'];
            if (strchr($discount2, '%')) {
                $discount = str_replace('%', '', $discount2);
                $discount /= 100;
                $discount *= $row['pPrice'];
            }
        }

        # CALC TAX
        $tax_amt = 0;
        if ($tax2 = $tax) {
            $tax_amt = round($row['pPrice'] * $row['pQty'] * $tax_rate, 2);
            if ($tax_amt <= 0) {
                $tax2 = '';
            }
        }

        # DIAGNOSTIC PNUM
        if (stristr($row['pNum'], 'free diagnostic')) {
            $row['pNum'] = 111;
        }

        # OUTPUT
        $line['Item Number'] = $hardware?'Hardware':$row['pNum'];
        $line['Quantity'] = $row['pQty'];
        $line['Description'] = $row['pName'];
        $line['Price'] = $row['pPrice'];
        $line['Discount'] = $discount;
        $line['Tax Code'] = $tax2;
        $line['Tax Amount'] = $tax_amt;
        $line['Total'] = $row['pPrice'] * $row['pQty'];
        return $line;
    }

    # EXPORT CUSTOMERS CSV TO DOWNLOAD - RETURNS BOOL

    function export_customers($oNums, $fileprefix, $returnData = false) {
        $output = '';
        if ($rows = $this->db_select_multiple(
                'ds_orders', '*', array()
                , 'where oID in ("' . implode('","', $oNums) . '") group by customer_id'
                )
        ) {
            foreach ($rows as $data) {
                $cname = '';
                $fname = $data['cBillFname'];
                $lname = $data['cBillLname'];
                if (trim($data['cBillCompany']) != '') {
                    $cname = $data['cBillFname'] . ' ' . $data['cBillLname'];
                    $lname = $data['cBillCompany'];
                    $fname = '';
                }
                $line = array(
                    'Co./Last Name' => $lname
                    , 'First Name' => $fname
                    , 'Card ID' => '*None'
                    , 'Card Status' => 'N'
                    , 'Currency Code' => ''
                    , 'Addr 1 - Line 1' => $data['cBillAddress1']
                    , 'Addr 1 - Line 2' => $data['cBillAddress2']
                    , 'Addr 1 - Line 3' => ''
                    , 'Addr 1 - Line 4' => ''
                    , 'Addr 1 - City' => $data['cBillCity']
                    , 'Addr 1 - State' => $data['cBillState']
                    , 'Addr 1 - ZIP Code' => $data['cBillZip']
                    , 'Addr 1 - Country' => ''
                    , 'Addr 1 - Phone # 1' => $data['cPhone']
                    , 'Addr 1 - Phone # 2' => $data['cFax']
                    , 'Addr 1 - Phone # 3' => ''
                    , 'Addr 1 - Fax #' => ''
                    , 'Addr 1 - Email' => $data['cEmail']
                    , 'Addr 1 - WWW' => ''
                    , 'Addr 1 - Contact Name' => $cname
                    , 'Addr 1 - Salutation' => ''
                    , 'Addr 2 - Line 1' => ''
                    , 'Addr 2 - Line 2' => ''
                    , 'Addr 2 - Line 3' => ''
                    , 'Addr 2 - Line 4' => ''
                    , 'Addr 2 - City' => ''
                    , 'Addr 2 - State' => ''
                    , 'Addr 2 - ZIP Code' => ''
                    , 'Addr 2 - Country' => ''
                    , 'Addr 2 - Phone # 1' => ''
                    , 'Addr 2 - Phone # 2' => ''
                    , 'Addr 2 - Phone # 3' => ''
                    , 'Addr 2 - Fax #' => ''
                    , 'Addr 2 - Email' => ''
                    , 'Addr 2 - WWW' => ''
                    , 'Addr 2 - Contact Name' => ''
                    , 'Addr 2 - Salutation' => ''
                    , 'Addr 3 - Line 1' => ''
                    , 'Addr 3 - Line 2' => ''
                    , 'Addr 3 - Line 3' => ''
                    , 'Addr 3 - Line 4' => ''
                    , 'Addr 3 - City' => ''
                    , 'Addr 3 - State' => ''
                    , 'Addr 3 - ZIP Code' => ''
                    , 'Addr 3 - Country' => ''
                    , 'Addr 3 - Phone # 1' => ''
                    , 'Addr 3 - Phone # 2' => ''
                    , 'Addr 3 - Phone # 3' => ''
                    , 'Addr 3 - Fax #' => ''
                    , 'Addr 3 - Email' => ''
                    , 'Addr 3 - WWW' => ''
                    , 'Addr 3 - Contact Name' => ''
                    , 'Addr 3 - Salutation' => ''
                    , 'Addr 4 - Line 1' => ''
                    , 'Addr 4 - Line 2' => ''
                    , 'Addr 4 - Line 3' => ''
                    , 'Addr 4 - Line 4' => ''
                    , 'Addr 4 - City' => ''
                    , 'Addr 4 - State' => ''
                    , 'Addr 4 - ZIP Code' => ''
                    , 'Addr 4 - Country' => ''
                    , 'Addr 4 - Phone # 1' => ''
                    , 'Addr 4 - Phone # 2' => ''
                    , 'Addr 4 - Phone # 3' => ''
                    , 'Addr 4 - Fax #' => ''
                    , 'Addr 4 - Email' => ''
                    , 'Addr 4 - WWW' => ''
                    , 'Addr 4 - Contact Name' => ''
                    , 'Addr 4 - Salutation' => ''
                    , 'Addr 5 - Line 1' => ''
                    , 'Addr 5 - Line 2' => ''
                    , 'Addr 5 - Line 3' => ''
                    , 'Addr 5 - Line 4' => ''
                    , 'Addr 5 - City' => ''
                    , 'Addr 5 - State' => ''
                    , 'Addr 5 - ZIP Code' => ''
                    , 'Addr 5 - Country' => ''
                    , 'Addr 5 - Phone # 1' => ''
                    , 'Addr 5 - Phone # 2' => ''
                    , 'Addr 5 - Phone # 3' => ''
                    , 'Addr 5 - Fax #' => ''
                    , 'Addr 5 - Email' => ''
                    , 'Addr 5 - WWW' => ''
                    , 'Addr 5 - Contact Name' => ''
                    , 'Addr 5 - Salutation' => ''
                    , 'Picture' => ''
                    , 'Notes' => ''
                    , 'Identifiers' => ''
                    , 'Custom List 1' => ''
                    , 'Custom List 2' => ''
                    , 'Custom List 3' => ''
                    , 'Custom Field 1' => ''
                    , 'Custom Field 2' => ''
                    , 'Custom Field 3' => ''
                    , 'Billing Rate' => '0'
                    , 'Terms - Payment is Due' => '0'
                    , '           - Discount Days' => '0'
                    , '           - Balance Due Days' => '0'
                    , '           - % Discount' => '0'
                    , '           - % Monthly Charge' => '0'
                    , 'Tax Code' => 'CST'
                    , 'Credit Limit' => '0'
                    , 'Tax ID No.' => ''
                    , 'Volume Discount %' => '0'
                    , 'Sales/Purchase Layout' => 'I'
                    , 'Price Level' => '0'
                    , 'Payment Method' => ''
                    , 'Payment Notes' => ''
                    , 'Name on Card' => ''
                    , 'Last 4 Digits on Card' => ''
                    , 'Expiration Date' => ''
                    , 'Address (AVS)' => ''
                    , 'ZIP (AVS)' => ''
                    , 'Credit Card Swiped' => ''
                    , 'Account' => ''
                    , 'Salesperson' => ''
                    , 'Salesperson Card ID' => ''
                    , 'Comment' => ''
                    , 'Shipping Method' => ''
                    , 'Printed Form' => ''
                    , 'Freight Tax Code' => '-'
                    , 'Receipt Memo' => ''
                    , 'Invoice/Purchase Order Delivery' => 'P'
                    , 'Record ID' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
            }
        }

        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , $fileprefix . 'customer.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    # EXPORT ORDERS CSV TO DOWNLOAD - RETURNS BOOL

    function export_orders($oNums, $fileprefix, $returnData = false,$nopo = false,$hardware = false,$spinclude = true) {
        global $ship_methods, $custObj, $machine_translations;
        $output = '';
        if ($rows = $this->db_select_multiple(
                'ds_orders', '*', array()
                , 'where oID in ("' . implode('","', $oNums) . '") order by dateCompleted desc'
                )
        ) {
            foreach ($rows as $data) {
                if (substr($data['oNum'], 0,2) != 'SP' || $spinclude){
                    $fname = $data['cBillFname'];
                    $lname = $data['cBillLname'];
                    $name = $data['cBillFname'] . ' ' . $data['cBillLname'];
                    if (trim($data['cBillCompany']) != '') {
                        $name = $data['cBillCompany'] . ' (ATTN: ' . $data['cBillFname'] . ' ' . $data['cBillLname'] . ')';
                        $lname = $data['cBillCompany'];
                        $fname = '';
                    }
                    $tax = '';
                    if ($data['cShipState'] == 'CA') {
                        $tax = 'CST';
                        $tax_rate = 0.0875;
                    }
                    $payment = '';
                    if ($data['payment_method'] == 'Purchase Order') {
                        $payment_due = $custObj->get_perm_terms($data['customer_id']);
                        $payment_paid = 0;
                    } else {
                        $payment_due = 0;
                        $payment_paid = $data['cTotal'];
                        switch ($data['ccType']) {
                            case 'Visa':
                                $payment = 'VMC';
                                break;
                            case 'Master Card':
                                $payment = 'VMC';
                                break;
                            case 'American Express':
                                $payment = 'AMEX';
                                break;
                        }
                    }
                    $line = array(
                        'Co./Last Name' => $lname
                        , 'First Name' => $fname
                        , 'Addr 1 - Line 1' => $name
                        , 'Addr 1 - Line 2' => $data['cBillAddress1'] . ' ' . $data['cBillAddress2']
                        , 'Addr 1 - Line 3' => $data['cBillCity'] . ',' . $data['cBillState'] . ' ' . $data['cBillZip']
                        , 'Addr 1 - Line 4' => ''
                        , 'Invoice #' => $data['oNum']
                        , 'Date' => $data['dateCompleted']
                        , 'Customer PO' => $nopo?$data['poNumber']:''
                        , 'Ship Via' => $ship_methods[$data['cShipService']]['MYOB_name']
                        , 'Delivery Status' => ''
                        , 'Item Number' => '' # FILLED IN BELOW, PUT HERE FOR PLACEHOLDER
                        , 'Quantity' => '' # DITTO
                        , 'Description' => '' # DITTO
                        , 'Price' => '' # DITTO
                        , 'Discount' => '' # DITTO
                        , 'Total' => '' # DITTO
                        , 'Job' => ''
                        , 'Comment' => $data['activation_lock']==1?'Activation Lock':''
                        , 'Journal Memo' => 'Sale ' . $data['cBillLname'] . ',' . $data['cBillFname']
                        , 'Salesperson Last Name' => 'A'
                        , 'Salesperson First Name' => 'I'
                        , 'Shipping Date' => ''
                        , 'Tax Code' => $tax # FILLED IN BELOW, PUT HERE FOR PLACEHOLDER
                        , 'Tax Amount' => ''   # DITTO
                        , 'Freight Amount' => $data['cShipping']
                        , 'Tax on Freight' => ''
                        , 'Freight Tax Amount' => ''
                        , 'Sale Status' => 'O'
                        , 'Currency Code' => ''
                        , 'Exchange Rate' => ''
                        , 'Terms - Payment is Due' => $payment_due
                        , 'Terms - Payment is Due - Discount Days' => ''
                        , 'Terms - Payment is Due - Balance Due' => ''
                        , 'Days - % Discount' => ''
                        , 'Days - % Monthly' => ''
                        , 'Referral Source' => $data['cHow']
                        , 'Amount Paid' => $payment_paid
                        , 'Payment Method' => $payment
                        , 'Payment Notes' => ''
                        , 'Name on Card' => ''
                        , 'Card Number' => ''
                        , 'Expiration Date' => ''
                        , 'Address(AVS)' => ''
                        , 'Zip(AVS)' => ''
                        , 'Credit Card Swiped' => ''
                        , 'Authorization Code' => ''
                        , 'Check Number' => ''
                        , 'Category' => ''
                        , 'Location ID' => ''
                        , 'Card Verification' => ''
                        , '(CVV2) Used ' => ''
                    );

                    # FIND CART ITEMS AND MAKE A RECORD FOR EACH ONE
                    if ($data2 = $this->db_select_multiple('ds_carts', '*', array('oNum' => $data['oNum']))) {
                        $i = 0;
                        foreach ($data2 as $row) {

                            # HANDLE KITS BY SPLITTING INTO TWO
                            if (strstr($row['pNum'], ' KIT')) {
                                $row['pNum'] = str_replace(' KIT', '', $row['pNum']);
                                $row['pPrice'] /= 2;
                                $line = $this->export_cart_item($data, $row, $tax, $tax_rate, $line, $hardware);
                                $output .= '"' . implode('","', $line) . '"' . "\n";
                            }

                            # CALL HELPER FUNCTION FOR CART ITEM EXPORT
                            $line = $this->export_cart_item($data, $row, $tax, $tax_rate, $line, $hardware);
                            $output .= '"' . implode('","', $line) . '"' . "\n";

                        }

                        # GET MYOB MACHINE TYPE MAPPING
                        $sql = '
                                                    select myob_sku from nl_sku_mappings
                                                    where ds_sku = ' . $this->qualify_value($data['machineType']) . '
                                            ';
                        if ($row = $this->db_select_single(
                                'nl_sku_mappings', 'myob_sku', array('ds_sku' => $data['machineType'])
                                )
                        ) {
                            $line['Item Number'] = $hardware?'Hardware':$row['myob_sku'];
                            $line['Quantity'] = 1;
                            $line['Description'] = $this->str_replace_from_array($data['machineType'], $machine_translations)
                                    . ' ' . $data['processorSpeed'] . ' SN# ' . $data['serialNumber'];
                            $line['Price'] = 0;
                            $line['Discount'] = 0;
                            $line['Tax Code'] = '';
                            $line['Tax Amount'] = 0;
                            $line['Total'] = 0;
                            $output .= '"' . implode('","', $line) . '"' . "\n";
                        }
                    }
                    $output .= "\n";
                } # END ORDERS LOOP
            }
        }
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , $fileprefix . 'order.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    function export_ebay_orders($date,$include_sku=true) {
        $output = '';

        $rows = $this->db_select_multiple(
            'ebay_orders', '*', array()
            , 'where ship_date = "'.$this->format_date('db_date',$date).'"'
            );

        if ($rows) {
            foreach ($rows as $data) {

                $line = array(
                    'Co./Last Name' => $data['user_name']
                    , 'First Name' => ''
                    , 'Addr 1 - Line 1' => $data['user_name']
                    , 'Addr 1 - Line 2' => $data['street1'] . ',' . $data['street2']
                    , 'Addr 1 - Line 3' => $data['city'] . ',' . $data['state'] . ' ' . $data['zip']
                    , 'Addr 1 - Line 4' => ''
                    , 'Invoice #' => 'SPE'.str_pad($data['record_number'],5,'0',STR_PAD_LEFT)
                    , 'Date' => $data['payment_date']
                    , 'Customer PO' => ''
                    , 'Ship Via' => 'UPS Ground'
                    , 'Delivery Status' => ''
                    , 'Item Number' => $include_sku?$data['sku']:"Hardware"
                    , 'Quantity' => $data['quantity']
                    , 'Description' => $data['item']
                    , 'Price' => $data['price']
                    , 'Discount' => '0'
                    , 'Total' => $data['total_value']
                    , 'Job' => 'XSB'
                    , 'Comment' => ''
                    , 'Journal Memo' => 'Sale ' . $data['user_name']
                    , 'Salesperson Last Name' => 'Bui'
                    , 'Salesperson First Name' => 'Si'
                    , 'Shipping Date' => ''
                    , 'Tax Code' => $data['tax']>0?'CST':''
                    , 'Tax Amount' => $data['tax']
                    , 'Freight Amount' => ''
                    , 'Tax on Freight' => ''
                    , 'Freight Tax Amount' => ''
                    , 'Sale Status' => 'O'
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Terms - Payment is Due' => '0'
                    , 'Terms - Payment is Due - Discount Days' => ''
                    , 'Terms - Payment is Due - Balance Due' => ''
                    , 'Days - % Discount' => ''
                    , 'Days - % Monthly' => ''
                    , 'Referral Source' => 'Sourceplus'
                    , 'Amount Paid' => $data['total_value']
                    , 'Payment Method' => 'PayPal - Sourceplus'
                    , 'Payment Notes' => ''
                    , 'Name on Card' => ''
                    , 'Card Number' => ''
                    , 'Expiration Date' => ''
                    , 'Address(AVS)' => ''
                    , 'Zip(AVS)' => ''
                    , 'Credit Card Swiped' => ''
                    , 'Authorization Code' => ''
                    , 'Check Number' => ''
                    , 'Category' => ''
                    , 'Location ID' => ''
                    , 'Card Verification' => ''
                    , '(CVV2) Used ' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
                $output .= "\n";
            } # END ORDERS LOOP
        }

        if ($output != ""){
            return implode(',', array_keys($line)) . "\n" . $output;
        }else{
            return $output;
        }
    }

    function export_ebay_customers($date) {
        $output = '';
        $rows = $this->db_select_multiple(
            'ebay_orders', '*', array()
            , 'where ship_date = "'.$this->format_date('db_date',$date).'"'
            );

        if ($rows) {
            foreach ($rows as $data) {

                $line = array(
                    'Co./Last Name' => $data['user_name']
                    , 'First Name' => ''
                    , 'Card ID' => '*None'
                    , 'Card Status' => 'N'
                    , 'Currency Code' => ''
                    , 'Addr 1 - Line 1' => $data['street1']
                    , 'Addr 1 - Line 2' => $data['street2']
                    , 'Addr 1 - Line 3' => ''
                    , 'Addr 1 - Line 4' => ''
                    , 'Addr 1 - City' => $data['city']
                    , 'Addr 1 - State' => $data['state']
                    , 'Addr 1 - ZIP Code' => $data['zip']
                    , 'Addr 1 - Country' => ''
                    , 'Addr 1 - Phone # 1' => $data['cPhone']
                    , 'Addr 1 - Phone # 2' => $data['cFax']
                    , 'Addr 1 - Phone # 3' => $data['phone']
                    , 'Addr 1 - Fax #' => ''
                    , 'Addr 1 - Email' => $data['email']
                    , 'Addr 1 - WWW' => ''
                    , 'Addr 1 - Contact Name' => ''
                    , 'Addr 1 - Salutation' => ''
                    , 'Addr 2 - Line 1' => ''
                    , 'Addr 2 - Line 2' => ''
                    , 'Addr 2 - Line 3' => ''
                    , 'Addr 2 - Line 4' => ''
                    , 'Addr 2 - City' => ''
                    , 'Addr 2 - State' => ''
                    , 'Addr 2 - ZIP Code' => ''
                    , 'Addr 2 - Country' => ''
                    , 'Addr 2 - Phone # 1' => ''
                    , 'Addr 2 - Phone # 2' => ''
                    , 'Addr 2 - Phone # 3' => ''
                    , 'Addr 2 - Fax #' => ''
                    , 'Addr 2 - Email' => ''
                    , 'Addr 2 - WWW' => ''
                    , 'Addr 2 - Contact Name' => ''
                    , 'Addr 2 - Salutation' => ''
                    , 'Addr 3 - Line 1' => ''
                    , 'Addr 3 - Line 2' => ''
                    , 'Addr 3 - Line 3' => ''
                    , 'Addr 3 - Line 4' => ''
                    , 'Addr 3 - City' => ''
                    , 'Addr 3 - State' => ''
                    , 'Addr 3 - ZIP Code' => ''
                    , 'Addr 3 - Country' => ''
                    , 'Addr 3 - Phone # 1' => ''
                    , 'Addr 3 - Phone # 2' => ''
                    , 'Addr 3 - Phone # 3' => ''
                    , 'Addr 3 - Fax #' => ''
                    , 'Addr 3 - Email' => ''
                    , 'Addr 3 - WWW' => ''
                    , 'Addr 3 - Contact Name' => ''
                    , 'Addr 3 - Salutation' => ''
                    , 'Addr 4 - Line 1' => ''
                    , 'Addr 4 - Line 2' => ''
                    , 'Addr 4 - Line 3' => ''
                    , 'Addr 4 - Line 4' => ''
                    , 'Addr 4 - City' => ''
                    , 'Addr 4 - State' => ''
                    , 'Addr 4 - ZIP Code' => ''
                    , 'Addr 4 - Country' => ''
                    , 'Addr 4 - Phone # 1' => ''
                    , 'Addr 4 - Phone # 2' => ''
                    , 'Addr 4 - Phone # 3' => ''
                    , 'Addr 4 - Fax #' => ''
                    , 'Addr 4 - Email' => ''
                    , 'Addr 4 - WWW' => ''
                    , 'Addr 4 - Contact Name' => ''
                    , 'Addr 4 - Salutation' => ''
                    , 'Addr 5 - Line 1' => ''
                    , 'Addr 5 - Line 2' => ''
                    , 'Addr 5 - Line 3' => ''
                    , 'Addr 5 - Line 4' => ''
                    , 'Addr 5 - City' => ''
                    , 'Addr 5 - State' => ''
                    , 'Addr 5 - ZIP Code' => ''
                    , 'Addr 5 - Country' => ''
                    , 'Addr 5 - Phone # 1' => ''
                    , 'Addr 5 - Phone # 2' => ''
                    , 'Addr 5 - Phone # 3' => ''
                    , 'Addr 5 - Fax #' => ''
                    , 'Addr 5 - Email' => ''
                    , 'Addr 5 - WWW' => ''
                    , 'Addr 5 - Contact Name' => ''
                    , 'Addr 5 - Salutation' => ''
                    , 'Picture' => ''
                    , 'Notes' => ''
                    , 'Identifiers' => ''
                    , 'Custom List 1' => ''
                    , 'Custom List 2' => ''
                    , 'Custom List 3' => ''
                    , 'Custom Field 1' => ''
                    , 'Custom Field 2' => ''
                    , 'Custom Field 3' => ''
                    , 'Billing Rate' => '0'
                    , 'Terms - Payment is Due' => '0'
                    , '           - Discount Days' => '0'
                    , '           - Balance Due Days' => '0'
                    , '           - % Discount' => '0'
                    , '           - % Monthly Charge' => '0'
                    , 'Tax Code' => 'CST'
                    , 'Credit Limit' => '0'
                    , 'Tax ID No.' => ''
                    , 'Volume Discount %' => '0'
                    , 'Sales/Purchase Layout' => 'I'
                    , 'Price Level' => '0'
                    , 'Payment Method' => ''
                    , 'Payment Notes' => ''
                    , 'Name on Card' => ''
                    , 'Last 4 Digits on Card' => ''
                    , 'Expiration Date' => ''
                    , 'Address (AVS)' => ''
                    , 'ZIP (AVS)' => ''
                    , 'Credit Card Swiped' => ''
                    , 'Account' => ''
                    , 'Salesperson' => ''
                    , 'Salesperson Card ID' => ''
                    , 'Comment' => ''
                    , 'Shipping Method' => ''
                    , 'Printed Form' => ''
                    , 'Freight Tax Code' => '-'
                    , 'Receipt Memo' => ''
                    , 'Invoice/Purchase Order Delivery' => 'P'
                    , 'Record ID' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
            }
        }
        if ($output != ""){
            return implode(',', array_keys($line)) . "\n" . $output;
        }else{
            return $output;
        }
    }

    function export_paypal_journal() {
        $output = '';

        $accountno = '61630';

        $record = $this->db_select_single(
            'ebay_orders', 'max(paypal_journal_number)', array()
            );

        if (is_null($record[0])){
            $paypal_journal_number = 5100;
        }else{
            $paypal_journal_number = $record[0] + 1;
        }

        $rows = $this->db_select_multiple(
            'ebay_orders', '*', array()
            , 'where paypal_journal_number is null'
            );

        if ($rows) {
            foreach ($rows as $data) {

                $line = array(
                    'Journal Number' => 'GJ'.  str_pad((string)$paypal_journal_number, 6,'0',STR_PAD_LEFT)
                    , 'Date' => date('m/d/y',  strtotime($data['payment_date']))
                    , 'Memo' => 'PSP - '.$data['user_name']
                    , 'Account Number' => $accountno
                    , 'Debit Amount' => $data['fee']
                    , 'Credit Amount' => ''
                    , 'Job' => ''
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Allocation Memo' => ''
                    , 'Category' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
                $line = array(
                    'Journal Number' => 'GJ'.  str_pad((string)$paypal_journal_number, 6,'0',STR_PAD_LEFT)
                    , 'Date' => date('m/d/y',  strtotime($data['payment_date']))
                    , 'Memo' => 'PSP - '.$data['user_name']
                    , 'Account Number' => '11160'
                    , 'Debit Amount' => ''
                    , 'Credit Amount' => $data['fee']
                    , 'Job' => ''
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Allocation Memo' => ''
                    , 'Category' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n\n";
            } # END ORDERS LOOP
        }

        $this->db_query('update ebay_orders set paypal_journal_number = '.$paypal_journal_number.' where paypal_journal_number is null', 'update');

        if ($output != ""){
            return implode(',', array_keys($line)) . "\n" . $output;
        }else{
            return $output;
        }
    }

    function export_paypal_payments($rows,$csvexists=true) {
        $output = '';

        $accountno = '61638';

        $record = $this->db_select_single(
            'ebay_orders', 'max(paypal_journal_number)', array()
            );


        $paypal_journal_number = $record[0];



        if ($rows) {
            foreach ($rows as $data) {

                $line = array(
                    'Journal Number' => 'GJ'.  str_pad((string)$paypal_journal_number, 6,'0',STR_PAD_LEFT)
                    , 'Date' => date('m/d/y',  strtotime($data['payment_date']))
                    , 'Memo' => 'PMS - '.$data['user_name']
                    , 'Account Number' => $accountno
                    , 'Debit Amount' => $data['fee']
                    , 'Credit Amount' => ''
                    , 'Job' => ''
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Allocation Memo' => ''
                    , 'Category' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
                $line = array(
                    'Journal Number' => 'GJ'.  str_pad((string)$paypal_journal_number, 6,'0',STR_PAD_LEFT)
                    , 'Date' => date('m/d/y',  strtotime($data['payment_date']))
                    , 'Memo' => 'PMS - '.$data['user_name']
                    , 'Account Number' => '11160'
                    , 'Debit Amount' => ''
                    , 'Credit Amount' => $data['fee']
                    , 'Job' => ''
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Allocation Memo' => ''
                    , 'Category' => ''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n\n";
            } # END ORDERS LOOP
        }

        if ($output != ""){
            if ($csvexists){
                return $output;
            }else{
                return implode(',', array_keys($line)) . "\n" . $output;
            }
        }else{
            return $output;
        }
    }

    function export_zoho_orders($zoho_data,$hardware=false,$nopo=false) {

        $output = '';
        $invoiceno = '';

        //prefixes to be stripped out
        $prefixes = array('KH-','BH-','AL-');

        foreach ($zoho_data as $data) {

            $words = explode(" ", $data['Invoice Owner']);
            $acronym = "";

            foreach ($words as $w) {
              $acronym .= $w[0];
            }

            $data['Job'] = 'X'.$acronym;

            foreach ($data['Product Details'] as $detail){

                $exclude = false;

                //remove records with prefixes
                foreach ($prefixes as $prefix){
                    if (strpos($detail['Item Number'], $prefix) !== false){
                        $exclude = true;
                    }
                }

                if (strpos(strtoupper($detail['Item Number']), 'CASE') !== false){
                    $exclude = true;
                }

                if ($detail['Item Number'] == '(BN)'){
                    $exclude = true;
                }

                if (!$exclude){

                    //strip out (2)
                    if (strpos($detail['Item Number'], '(2)') !== false){
                        $detail['Item Number'] = substr($detail['Item Number'],4);
                    }

                    //strip out (10-PACK) and recalculate quantity and price
                    if (strpos($detail['Item Number'], '(10-PACK)') !== false){
                        $detail['Item Number'] = str_replace(' (10-PACK)', '', $detail['Item Number']);
                        $detail['Quantity'] = (int)$detail['Quantity']*10;
                        $detail['Unit Price'] = (float)$detail['Unit Price']/10;
                    }

                    //strip out (2nd stock, 10-PACK) and recalculate quantity and price
                    if (strpos($detail['Item Number'], '(2nd stock, 10-PACK)') !== false){
                        $detail['Item Number'] = str_replace(' (2nd stock, 10-PACK)', '', $detail['Item Number']);
                        $detail['Quantity'] = (int)$detail['Quantity']*10;
                        $detail['Unit Price'] = (float)$detail['Unit Price']/10;
                    }

                    //strip out (*GB)
                    if (strpos($detail['Item Number'], 'GB)') !== false){
                        $detail['Item Number'] = substr($detail['Item Number'],0, strpos($detail['Item Number'],' '));
                    }

                    //strip out (2nd Stock) and replace with -D
                    $detail['Item Number'] = str_replace(' (2nd stock)', '-D', $detail['Item Number']);

                    $line = array(
                        'Co./Last Name' => $data['Account Name']
                        , 'First Name' => ''
                        , 'Addr 1 - Line 1' => $data['Account Name']
                        , 'Addr 1 - Line 2' => $data['Billing Street']
                        , 'Addr 1 - Line 3' => $data['Billing City'] . ', ' . $data['Billing State'] . ' ' . $data['Billing Code']
                        , 'Addr 1 - Line 4' => ''
                        , 'Invoice #' => $data['MTS Quote Number']
                        , 'Date' => $data['Ship Date']
                        , 'Customer PO' => $nopo?'':$data['Purchase Order']
                        , 'Ship Via' => $data['Ship Method']
                        , 'Delivery Status' => ''
                        , 'Item Number' => $hardware?'Hardware':$detail['Item Number']
                        , 'Quantity' => $detail['Quantity']
                        , 'Description' => str_replace(",", "",$detail['Product Name'])
                        , 'Price' => $detail['Unit Price']
                        , 'Discount' => $detail['Discount']
                        , 'Total' => $detail['Total After Discount']
                        , 'Job' => $data['Job']
                        , 'Comment' => ''
                        , 'Journal Memo' => 'Sale ' . $data['Account Name']
                        , 'Salesperson Last Name' => substr($data['Invoice Owner'],  strpos($data['Invoice Owner'], ' ')+1)
                        , 'Salesperson First Name' => substr($data['Invoice Owner'], 0, strpos($data['Invoice Owner'], ' '))
                        , 'Shipping Date' => $data['Ship Date']
                        , 'Tax Code' => $data['Tax']>0?'CST':''
                        , 'Tax Amount' => $data['Tax']
                        , 'Freight Amount' => $detail['Freight']
                        , 'Tax on Freight' => ''
                        , 'Freight Tax Amount' => ''
                        , 'Sale Status' => 'O'
                        , 'Currency Code' => ''
                        , 'Exchange Rate' => ''
                        , 'Terms - Payment is Due' => '2'
                        , 'Terms - Payment is Due - Discount Days' => ''
                        , 'Terms - Payment is Due - Balance Due' => '30'
                        , 'Days - % Discount' => ''
                        , 'Days - % Monthly' => ''
                        , 'Referral Source' => 'MTS'
                        , 'Amount Paid' => ''
                        , 'Payment Method' => ''
                        , 'Payment Notes' => ''
                        , 'Name on Card' => ''
                        , 'Card Number' => ''
                        , 'Expiration Date' => ''
                        , 'Address(AVS)' => ''
                        , 'Zip(AVS)' => ''
                        , 'Credit Card Swiped' => ''
                        , 'Authorization Code' => ''
                        , 'Check Number' => ''
                        , 'Category' => ''
                        , 'Location ID' => ''
                        , 'Card Verification' => ''
                        , '(CVV2) Used ' => ''
                    );
                    $output .= '"' . implode('","', $line) . '"' . "\n";
                    if ($invoiceno != $data['MTS Quote Number']){
                        $sql = 'SELECT DISTINCT dsc.pName, dsc.pNum, COUNT(dsc.cID) AS pQty
                                    FROM ds_orders dso
                                    LEFT JOIN ds_carts dsc ON dsc.oNum = dso.oNum
                                    WHERE dso.mts_number = "'.$invoiceno.'"
                                    AND pNum <> "Free Diagnostic"
                                    GROUP BY dsc.pName, dsc.pNum, dso.oNum';
                        $data2 = $this->db_query($sql, 'select-multiple');
                        $invoiceno = $data['MTS Quote Number'];
                        if ($data2) {
                            $i = 0;
                            foreach ($data2 as $row) {

                                # HANDLE KITS BY SPLITTING INTO TWO
                                if (strstr($row['pNum'], ' KIT')) {
                                    $row['pNum'] = str_replace(' KIT', '', $row['pNum']);
                                    $row['pPrice'] /= 2;
                                    $line = $this->export_cart_item($data, $row, 0, 0, $line, $hardware);
                                    $output .= '"' . implode('","', $line) . '"' . "\n";
                                }

                                # CALL HELPER FUNCTION FOR CART ITEM EXPORT
                                $line = $this->export_cart_item($data, $row, 0, 0, $line, $hardware);
                                $output .= '"' . implode('","', $line) . '"' . "\n";

                            }
                        }
                    }
                }

            }
            $output .= "\n";

        }

        if ($output != ""){
            return implode(',', array_keys($line)) . "\n" . $output;
        }else{
            return $output;
        }
    }

    function export_zoho_customers($zoho_data) {
        $output = '';

        foreach ($zoho_data as $data) {

            $line = array(
                'Co./Last Name' => $data['Account Name']
                , 'First Name' => ''
                , 'Card ID' => '*None'
                , 'Card Status' => 'N'
                , 'Currency Code' => ''
                , 'Addr 1 - Line 1' => $data['Billing Street']
                , 'Addr 1 - Line 2' => $data['street2']
                , 'Addr 1 - Line 3' => ''
                , 'Addr 1 - Line 4' => ''
                , 'Addr 1 - City' => $data['Billing City']
                , 'Addr 1 - State' => $data['Billing State']
                , 'Addr 1 - ZIP Code' => $data['Billing Code']
                , 'Addr 1 - Country' => ''
                , 'Addr 1 - Phone # 1' => $data['cPhone']
                , 'Addr 1 - Phone # 2' => $data['cFax']
                , 'Addr 1 - Phone # 3' => $data['phone']
                , 'Addr 1 - Fax #' => ''
                , 'Addr 1 - Email' => $data['email']
                , 'Addr 1 - WWW' => ''
                , 'Addr 1 - Contact Name' => ''
                , 'Addr 1 - Salutation' => ''
                , 'Addr 2 - Line 1' => ''
                , 'Addr 2 - Line 2' => ''
                , 'Addr 2 - Line 3' => ''
                , 'Addr 2 - Line 4' => ''
                , 'Addr 2 - City' => ''
                , 'Addr 2 - State' => ''
                , 'Addr 2 - ZIP Code' => ''
                , 'Addr 2 - Country' => ''
                , 'Addr 2 - Phone # 1' => ''
                , 'Addr 2 - Phone # 2' => ''
                , 'Addr 2 - Phone # 3' => ''
                , 'Addr 2 - Fax #' => ''
                , 'Addr 2 - Email' => ''
                , 'Addr 2 - WWW' => ''
                , 'Addr 2 - Contact Name' => ''
                , 'Addr 2 - Salutation' => ''
                , 'Addr 3 - Line 1' => ''
                , 'Addr 3 - Line 2' => ''
                , 'Addr 3 - Line 3' => ''
                , 'Addr 3 - Line 4' => ''
                , 'Addr 3 - City' => ''
                , 'Addr 3 - State' => ''
                , 'Addr 3 - ZIP Code' => ''
                , 'Addr 3 - Country' => ''
                , 'Addr 3 - Phone # 1' => ''
                , 'Addr 3 - Phone # 2' => ''
                , 'Addr 3 - Phone # 3' => ''
                , 'Addr 3 - Fax #' => ''
                , 'Addr 3 - Email' => ''
                , 'Addr 3 - WWW' => ''
                , 'Addr 3 - Contact Name' => ''
                , 'Addr 3 - Salutation' => ''
                , 'Addr 4 - Line 1' => ''
                , 'Addr 4 - Line 2' => ''
                , 'Addr 4 - Line 3' => ''
                , 'Addr 4 - Line 4' => ''
                , 'Addr 4 - City' => ''
                , 'Addr 4 - State' => ''
                , 'Addr 4 - ZIP Code' => ''
                , 'Addr 4 - Country' => ''
                , 'Addr 4 - Phone # 1' => ''
                , 'Addr 4 - Phone # 2' => ''
                , 'Addr 4 - Phone # 3' => ''
                , 'Addr 4 - Fax #' => ''
                , 'Addr 4 - Email' => ''
                , 'Addr 4 - WWW' => ''
                , 'Addr 4 - Contact Name' => ''
                , 'Addr 4 - Salutation' => ''
                , 'Addr 5 - Line 1' => ''
                , 'Addr 5 - Line 2' => ''
                , 'Addr 5 - Line 3' => ''
                , 'Addr 5 - Line 4' => ''
                , 'Addr 5 - City' => ''
                , 'Addr 5 - State' => ''
                , 'Addr 5 - ZIP Code' => ''
                , 'Addr 5 - Country' => ''
                , 'Addr 5 - Phone # 1' => ''
                , 'Addr 5 - Phone # 2' => ''
                , 'Addr 5 - Phone # 3' => ''
                , 'Addr 5 - Fax #' => ''
                , 'Addr 5 - Email' => ''
                , 'Addr 5 - WWW' => ''
                , 'Addr 5 - Contact Name' => ''
                , 'Addr 5 - Salutation' => ''
                , 'Picture' => ''
                , 'Notes' => ''
                , 'Identifiers' => ''
                , 'Custom List 1' => ''
                , 'Custom List 2' => ''
                , 'Custom List 3' => ''
                , 'Custom Field 1' => ''
                , 'Custom Field 2' => ''
                , 'Custom Field 3' => ''
                , 'Billing Rate' => '0'
                , 'Terms - Payment is Due' => '0'
                , '           - Discount Days' => '0'
                , '           - Balance Due Days' => '0'
                , '           - % Discount' => '0'
                , '           - % Monthly Charge' => '0'
                , 'Tax Code' => 'CST'
                , 'Credit Limit' => '0'
                , 'Tax ID No.' => ''
                , 'Volume Discount %' => '0'
                , 'Sales/Purchase Layout' => 'I'
                , 'Price Level' => '0'
                , 'Payment Method' => ''
                , 'Payment Notes' => ''
                , 'Name on Card' => ''
                , 'Last 4 Digits on Card' => ''
                , 'Expiration Date' => ''
                , 'Address (AVS)' => ''
                , 'ZIP (AVS)' => ''
                , 'Credit Card Swiped' => ''
                , 'Account' => ''
                , 'Salesperson' => ''
                , 'Salesperson Card ID' => ''
                , 'Comment' => ''
                , 'Shipping Method' => ''
                , 'Printed Form' => ''
                , 'Freight Tax Code' => '-'
                , 'Receipt Memo' => ''
                , 'Invoice/Purchase Order Delivery' => 'P'
                , 'Record ID' => ''
            );
            $output .= '"' . implode('","', $line) . '"' . "\n";
        }

        if ($output != ""){
            return implode(',', array_keys($line)) . "\n" . $output;
        }else{
            return $output;
        }
    }

    function export_details($oNums, $returnData = false) {

        global $hdvolumes, $ramvolumes;

        $output = '';
        /*if ($rows = $this->db_select_multiple(
                'ds_orders', '*,CASE WHEN LOCATE("School/PO#",cShipInstruct) > 0 THEN SUBSTR(cShipInstruct,LOCATE("School/PO#",cShipInstruct)+12) ELSE "" END AS PONumber', array(), 'where oID in ("' . implode('","', $oNums) . '") order by is_ipad, oNum'
                )*/
        $rows = $this->db_select_multiple('ds_orders', '*', array(), 'where oID in ("' . implode('","', $oNums) . '") order by is_ipad, oNum');
        if ($rows) {
            foreach ($rows as $data) {

                $sql = "SELECT
                            CASE
                                WHEN dso.grade_at_audit = 'A' THEN poi.price_a
                                WHEN dso.grade_at_audit = 'B' THEN poi.price_b
                                WHEN dso.grade_at_audit = 'C' THEN poi.price_c
                                WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
                                WHEN dso.grade_at_audit = 'F' THEN poi.price_f
                            END AS cost
                            FROM po_items poi
                            LEFT JOIN po_orders por ON por.order_id = poi.order_id
                            LEFT JOIN ds_orders dso ON dso.poNumber = por.order_number
                            WHERE dso.oNum = '{$data['oNum']}' AND poi.order_number = '{$data['asset']}'";

                $cost = $this->db_query($sql, 'select-single');

                $hdtotal = 0;
                $hdstr = '';

                if ($data['hd_1'] != '') {
                    $hdtotal = (int) $hdvolumes[$data['hd_1']];
                }

                if ($data['hd_2'] != '') {
                    $hdtotal += (int) $hdvolumes[$data['hd_2']];
                }

                if ($hdtotal > 0){
                    if ($hdtotal < 1024) {
                        $hdstr = $hdtotal . 'GB';
                    } else {
                        $hdstr = round((float) ($hdtotal / 1024), 1) . 'TB';
                    }
                }

                $ramtotal = 0;
                $ramstr = '';

                if ($data['ram_1'] != '') {
                    $ramtotal = (int) $ramvolumes[$data['ram_1']];
                }

                if ($data['ram_2'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_2']];
                }

                if ($data['ram_3'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_3']];
                }

                if ($data['ram_4'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_4']];
                }

                if ($ramtotal > 0){
                    if ($ramtotal < 1024) {
                        $ramstr = $ramtotal . 'MB';
                    } else {
                        $ramstr = round((float) ($ramtotal / 1024), 1) . 'GB';
                    }
                }

                $digistr = '';
                $casestr = '';

                if ($data['digitizer_scratch']){
                    $digiarray[] = 'Scratch';
                }

                if ($data['digitizer_crack']){
                    $digiarray[] = 'Crack';
                }

                $digistr = implode(', ', $digiarray);

                unset($digiarray);

                if ($data['case_scratch']){
                    $casearray[] = 'Scratch';
                }

                if ($data['case_crack']){
                    $casearray[] = 'Crack';
                }

                if ($data['case_dent']){
                    $casearray[] = 'Dent';
                }

                $casestr = implode(', ', $casearray);

                unset($casearray);

                $cosmeticstr = '';

                if ($data['top_case']){
                    $cosmeticarr[] = 'Top Case';
                }

                if ($data['display_housing']){
                    $cosmeticarr[] = 'Display Housing';
                }

                if ($data['bottom_case']){
                    $cosmeticarr[] = 'Bottom Case';
                }

                if ($data['refurb_keys']){
                    $cosmeticarr[] = 'Missing Keys';
                }

                if ($data['hinge']){
                    $cosmeticarr[] = 'Hinge';
                }

                if ($data['scratch']){
                    $cosmeticarr[] = 'Heavy Scratches';
                }

                if ($data['marking']){
                    $cosmeticarr[] = 'Permanent Markings';
                }

                $cosmeticstr = implode(', ', $cosmeticarr);

                unset($cosmeticarr);

                $line = array(
                'Order #' => $data['oNum']
                , 'Serial Number' => $data['serialNumber']
                , 'Machine' => $data['machineType']
                , 'Asset #' => $data['asset']
                , 'PO#' => $data['poNumber']
                , 'Grade' => $data['grade']
                , 'Grade At Audit' => $data['grade_at_audit']
                , 'Cost' => $cost['cost']
                , 'Hard Drive' => $hdstr
                , 'RAM' => $ramstr
                , 'Notes' => $data['refurb_notes']
                , 'Optical' => $data['optical']=='pass'?'Pass':($data['optical']=='fail'?'Fail':($data['optical']=='na'?'N/A':''))
                , 'LCD' => $data['lcd']=='pass'?'Pass':($data['lcd']=='fail'?'Fail':($data['lcd']=='na'?'N/A':''))
                , 'Glass' => $data['glass']=='pass'?'Pass':($data['glass']=='fail'?'Fail':($data['glass']=='na'?'N/A':''))
                , 'Ethernet' => $data['enet']=='pass'?'Pass':($data['enet']=='fail'?'Fail':($data['enet']=='na'?'N/A':''))
                , 'Wifi' => $data['is_ipad']?'':$data['wifi']=='pass'?'Pass':($data['wifi']=='fail'?'Fail':($data['wifi']=='na'?'N/A':''))
                , 'Speakers' => $data['speakers']=='pass'?'Pass':($data['speakers']=='fail'?'Fail':($data['speakers']=='na'?'N/A':''))
                , 'Battery' => $data['battery']=='pass'?'Pass':($data['battery']=='fail'?'Fail':($data['battery']=='na'?'N/A':''))
                , 'Cycles' => $data['battery_cycles']
                , 'mAh' => $data['battery_mah']
                , 'iSight' => $data['isight']=='pass'?'Pass':($data['isight']=='fail'?'Fail':($data['isight']=='na'?'N/A':''))
                , 'Cosmetic issues' => $cosmeticstr
                , 'iPad' => $data['is_ipad']?'Yes':''
                , 'Capacity' => $data['capacity']
                , 'Digitizer' => $digistr
                , 'Case' => $casestr
                , 'Home' => $data['home_button']=='pass'?'Pass':($data['home_button']=='fail'?'Fail':($data['home_button']=='na'?'N/A':''))
                , 'Volume' => $data['volume']=='pass'?'Pass':($data['volume']=='fail'?'Fail':($data['volume']=='na'?'N/A':''))
                , 'Activation Lock' => $data['activation_lock']==1?'Yes':''
                , 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
                , 'Audit Summary' => $data['audit_summary']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , 'orders_details.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    function export_bb_report(){

        $output = '';

        $sql = 'SELECT pa.account_name, po.order_number AS po_number, DATE_FORMAT(po.date_received,"%m/%d/%Y") AS date_received, pi.order_number, pi.quantity, ps.status_description, DATE_FORMAT(po.expected_ship_date,"%m/%d/%Y") AS expected_ship_date
                FROM po_orders po
                LEFT JOIN po_accounts pa ON pa.account_id = po.account_id
                LEFT JOIN po_items pi ON pi.order_id = po.order_id
                LEFT JOIN po_status ps ON ps.status_id = po.status_id
                WHERE po.status_id IN (1,2) AND po.payment_sent_date IS NULL
                ORDER BY po.order_number';

        $rows = $this->db_query($sql, 'select-multiple');

        if ($rows) {
            foreach ($rows as $data) {

              $line = array(
                'School Name' => $data['account_name']
                , 'MTS Number' => $data['po_number']
                , 'Date Received' => $data['date_received']
                , 'SKU' => $data['order_number']
                , 'Quantity' => $data['quantity']
                , 'Status' => $data['status_description']
                , 'Expected Ship Date' => $data['expected_ship_date']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }

        if ($output) {
            $this->send_file_to_browser(
                    implode(',', array_keys($line)) . "\n" . $output
                    , 'bb_report.csv'
            );
        }
    }

    function export_bb_inventory(){

        $output = '';

        $sql = 'SELECT pa.account_name, po.order_number AS po_number, DATE_FORMAT(po.date_received,"%m/%d/%Y") AS date_received, pi.order_number, pi.quantity, ps.status_description, DATE_FORMAT(po.expected_ship_date,"%m/%d/%Y") AS expected_ship_date
                FROM po_orders po
                LEFT JOIN po_accounts pa ON pa.account_id = po.account_id
                LEFT JOIN po_items pi ON pi.order_id = po.order_id
                LEFT JOIN po_status ps ON ps.status_id = po.status_id
                WHERE po.status_id = 2 OR (po.status_id = 3 AND po.payment_sent_date IS NULL)
                ORDER BY po.order_number';

        $rows = $this->db_query($sql, 'select-multiple');

        if ($rows) {
            foreach ($rows as $data) {

              $line = array(
                'School Name' => $data['account_name']
                , 'MTS Number' => $data['po_number']
                , 'Date Received' => $data['date_received']
                , 'SKU' => $data['order_number']
                , 'Quantity' => $data['quantity']
                , 'Status' => $data['status_description']
                , 'Expected Ship Date' => $data['expected_ship_date']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }

        if ($output) {
            $this->send_file_to_browser(
                    implode(',', array_keys($line)) . "\n" . $output
                    , 'bb_inventory.csv'
            );
        }
    }

    function export_bb_detail($poNumber, $returnData = false) {

        global $hdvolumes, $ramvolumes;

        $output = '';
        /*if ($rows = $this->db_select_multiple(
                'ds_orders', '*,CASE WHEN LOCATE("School/PO#",cShipInstruct) > 0 THEN SUBSTR(cShipInstruct,LOCATE("School/PO#",cShipInstruct)+12) ELSE "" END AS PONumber', array(), 'where oID in ("' . implode('","', $oNums) . '") order by is_ipad, oNum'
                )*/
        $rows = $this->db_select_multiple('ds_orders', '*', array('poNumber' => $poNumber), 'order by is_ipad, oNum');
        if ($rows) {
            foreach ($rows as $data) {
				$asset = $this->getRealSku($data['asset']);

                $sql = "SELECT
                            CASE
                                WHEN dso.grade_at_audit = 'A' THEN poi.price_a
                                WHEN dso.grade_at_audit = 'B' THEN poi.price_b
                                WHEN dso.grade_at_audit = 'C' THEN poi.price_c
                                WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
                                WHEN dso.grade_at_audit = 'F' THEN poi.price_f
                            END AS cost
                            FROM po_items poi
                            LEFT JOIN po_orders por ON por.order_id = poi.order_id
                            LEFT JOIN ds_orders dso ON dso.poNumber = por.order_number
                            WHERE dso.oNum = '{$data['oNum']}' AND poi.order_number = '$asset'";

                $cost = $this->db_query($sql, 'select-single');

                $hdtotal = 0;
                $hdstr = '';

                if ($data['hd_1'] != '') {
                    $hdtotal = (int) $hdvolumes[$data['hd_1']];
                }

                if ($data['hd_2'] != '') {
                    $hdtotal += (int) $hdvolumes[$data['hd_2']];
                }

                if ($hdtotal > 0){
                    if ($hdtotal < 1024) {
                        $hdstr = $hdtotal . 'GB';
                    } else {
                        $hdstr = round((float) ($hdtotal / 1024), 1) . 'TB';
                    }
                }

                $ramtotal = 0;
                $ramstr = '';

                if ($data['ram_1'] != '') {
                    $ramtotal = (int) $ramvolumes[$data['ram_1']];
                }

                if ($data['ram_2'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_2']];
                }

                if ($data['ram_3'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_3']];
                }

                if ($data['ram_4'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_4']];
                }

                if ($ramtotal > 0){
                    if ($ramtotal < 1024) {
                        $ramstr = $ramtotal . 'MB';
                    } else {
                        $ramstr = round((float) ($ramtotal / 1024), 1) . 'GB';
                    }
                }

                $digistr = '';
                $casestr = '';

                if ($data['digitizer_scratch']){
                    $digiarray[] = 'Scratch';
                }

                if ($data['digitizer_crack']){
                    $digiarray[] = 'Crack';
                }

                $digistr = implode(', ', $digiarray);

                unset($digiarray);

                if ($data['case_scratch']){
                    $casearray[] = 'Scratch';
                }

                if ($data['case_crack']){
                    $casearray[] = 'Crack';
                }

                if ($data['case_dent']){
                    $casearray[] = 'Dent';
                }

                $casestr = implode(', ', $casearray);

                unset($casearray);

                $cosmeticstr = '';

                if ($data['top_case']){
                    $cosmeticarr[] = 'Top Case';
                }

                if ($data['display_housing']){
                    $cosmeticarr[] = 'Display Housing';
                }

                if ($data['bottom_case']){
                    $cosmeticarr[] = 'Bottom Case';
                }

                if ($data['refurb_keys']){
                    $cosmeticarr[] = 'Missing Keys';
                }

                if ($data['hinge']){
                    $cosmeticarr[] = 'Hinge';
                }

                if ($data['scratch']){
                    $cosmeticarr[] = 'Heavy Scratches';
                }

                if ($data['marking']){
                    $cosmeticarr[] = 'Permanent Markings';
                }

                $cosmeticstr = implode(', ', $cosmeticarr);

                unset($cosmeticarr);

                $line = array(
                'Order #' => $data['oNum']
                , 'Serial Number' => $data['serialNumber']
                , 'Machine' => $data['machineType']
                , 'Asset #' => $data['asset']
                , 'PO#' => $data['poNumber']
                , 'Grade' => $data['grade']
                , 'Grade At Audit' => $data['grade_at_audit']
                , 'Hard Drive' => $hdstr
                , 'RAM' => $ramstr
                , 'Notes' => $data['refurb_notes']
                , 'Optical' => $data['optical']=='pass'?'Pass':($data['optical']=='fail'?'Fail':($data['optical']=='na'?'N/A':''))
                , 'LCD' => $data['lcd']=='pass'?'Pass':($data['lcd']=='fail'?'Fail':($data['lcd']=='na'?'N/A':''))
                , 'Glass' => $data['glass']=='pass'?'Pass':($data['glass']=='fail'?'Fail':($data['glass']=='na'?'N/A':''))
                , 'Ethernet' => $data['enet']=='pass'?'Pass':($data['enet']=='fail'?'Fail':($data['enet']=='na'?'N/A':''))
                , 'Wifi' => $data['is_ipad']?'':$data['wifi']=='pass'?'Pass':($data['wifi']=='fail'?'Fail':($data['wifi']=='na'?'N/A':''))
                , 'Speakers' => $data['speakers']=='pass'?'Pass':($data['speakers']=='fail'?'Fail':($data['speakers']=='na'?'N/A':''))
                , 'Battery' => $data['battery']=='pass'?'Pass':($data['battery']=='fail'?'Fail':($data['battery']=='na'?'N/A':''))
                , 'Cycles' => $data['battery_cycles']
                , 'mAh' => $data['battery_mah']
                , 'iSight' => $data['isight']=='pass'?'Pass':($data['isight']=='fail'?'Fail':($data['isight']=='na'?'N/A':''))
                , 'Cosmetic issues' => $cosmeticstr
                , 'iPad' => $data['is_ipad']?'Yes':''
                , 'Capacity' => $data['capacity']
                , 'Digitizer' => $digistr
                , 'Case' => $casestr
                , 'Home' => $data['home_button']=='pass'?'Pass':($data['home_button']=='fail'?'Fail':($data['home_button']=='na'?'N/A':''))
                , 'Volume' => $data['volume']=='pass'?'Pass':($data['volume']=='fail'?'Fail':($data['volume']=='na'?'N/A':''))
                , 'Activation Lock' => $data['activation_lock']==1?'Yes':''
                , 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
                , 'Audit Summary' => $data['audit_summary']
                , 'Cost' => $cost['cost']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , 'orders_details.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    function export_bb_locks($poNumber, $returnData = false) {

        $output = '';

        $sql = 'SELECT DISTINCT dso.serialNumber, ml.machine_description, dso.activation_lock, dso.mdm_lock, dso.audit_activation_lock, dso.audit_mdm_lock
            FROM ds_orders dso
            LEFT JOIN machine_order_number mon ON mon.order_number = dso.asset
            LEFT JOIN machine_lookup ml ON ml.machine_id = mon.machine_id
            WHERE dso.poNumber = "'.$poNumber.'" AND (dso.mdm_lock = 1 OR dso.activation_lock = 1 OR dso.audit_mdm_lock = 1 OR dso.audit_activation_lock = 1)  AND mon.enabled = 1';

        $rows = $this->db_query($sql, 'select-multiple');
        if ($rows) {
            foreach ($rows as $data) {

                $line = array(
                'Serial Number' => $data['serialNumber']
                , 'Machine' => $data['machine_description']
                , 'Activation Lock' => $data['activation_lock']==1?'Yes':''
                , 'Activation Lock At Audit' => $data['audit_activation_lock']==1?'Yes':''
                , 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
                , 'MDM Lock At Audit' => $data['audit_mdm_lock']==1?'Yes':''
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , $poNumber.'_locked_devices.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    function audit_export($oNums, $returnData = false) {

        global $hdvolumes, $ramvolumes;

        $output = '';
        /*if ($rows = $this->db_select_multiple(
                'ds_orders', '*,CASE WHEN LOCATE("School/PO#",cShipInstruct) > 0 THEN SUBSTR(cShipInstruct,LOCATE("School/PO#",cShipInstruct)+12) ELSE "" END AS PONumber', array(), 'where oID in ("' . implode('","', $oNums) . '") order by is_ipad, oNum'
                )*/
        $rows = $this->db_select_multiple('ds_orders', '*', array(), 'where oID in ("' . implode('","', $oNums) . '") order by is_ipad, oNum');
        if ($rows) {
            foreach ($rows as $data) {

                $hdtotal = 0;
                $hdstr = '';

                if ($data['hd_1'] != '') {
                    $hdtotal = (int) $hdvolumes[$data['hd_1']];
                }

                if ($data['hd_2'] != '') {
                    $hdtotal += (int) $hdvolumes[$data['hd_2']];
                }

                if ($hdtotal > 0){
                    if ($hdtotal < 1024) {
                        $hdstr = $hdtotal . 'GB';
                    } else {
                        $hdstr = round((float) ($hdtotal / 1024), 1) . 'TB';
                    }
                }

                $ramtotal = 0;
                $ramstr = '';

                if ($data['ram_1'] != '') {
                    $ramtotal = (int) $ramvolumes[$data['ram_1']];
                }

                if ($data['ram_2'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_2']];
                }

                if ($data['ram_3'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_3']];
                }

                if ($data['ram_4'] != '') {
                    $ramtotal += (int) $ramvolumes[$data['ram_4']];
                }

                if ($ramtotal > 0){
                    if ($ramtotal < 1024) {
                        $ramstr = $ramtotal . 'MB';
                    } else {
                        $ramstr = round((float) ($ramtotal / 1024), 1) . 'GB';
                    }
                }

                $digistr = '';
                $casestr = '';

                if ($data['digitizer_scratch']){
                    $digiarray[] = 'Scratch';
                }

                if ($data['digitizer_crack']){
                    $digiarray[] = 'Crack';
                }

                $digistr = implode(', ', $digiarray);

                unset($digiarray);

                if ($data['case_scratch']){
                    $casearray[] = 'Scratch';
                }

                if ($data['case_crack']){
                    $casearray[] = 'Crack';
                }

                if ($data['case_dent']){
                    $casearray[] = 'Dent';
                }

                $casestr = implode(', ', $casearray);

                unset($casearray);

                $cosmeticstr = '';

                if ($data['top_case']){
                    $cosmeticarr[] = 'Top Case';
                }

                if ($data['display_housing']){
                    $cosmeticarr[] = 'Display Housing';
                }

                if ($data['bottom_case']){
                    $cosmeticarr[] = 'Bottom Case';
                }

                if ($data['refurb_keys']){
                    $cosmeticarr[] = 'Missing Keys';
                }

                if ($data['hinge']){
                    $cosmeticarr[] = 'Hinge';
                }

                if ($data['scratch']){
                    $cosmeticarr[] = 'Heavy Scratches';
                }

                if ($data['marking']){
                    $cosmeticarr[] = 'Permanent Markings';
                }

                $cosmeticstr = implode(', ', $cosmeticarr);

                unset($cosmeticarr);

                $line = array(
                'Order #' => $data['oNum']
                , 'Serial Number' => $data['serialNumber']
                , 'Model' => $data['asset']
                , 'Audit Comments' => $data['audit_summary']
                , 'Hard Drive' => $data['is_ipad']==1?$data['capacity']:$hdstr
                , 'RAM' => $ramstr
                , 'Grade' => $data['grade']
                , 'Price' => ''
                , 'Additional Comments' => $data['refurb_notes']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";

            }
        }
        //if not returning data
        if (!$returnData) {
            # SEND TO BROWSER FOR DOWNLOAD
            if ($output) {
                $this->send_file_to_browser(
                        implode(',', array_keys($line)) . "\n" . $output
                        , 'audit_export.csv'
                );
            }
            return false;
        } else {
            return implode(',', array_keys($line)) . "\n" . $output;
        }
    }

    function export_refurb($poNumber) {

        $output = '';
        if ($rows = $this->db_select_multiple(
                'ds_orders', '*', array(), 'where poNumber = "' . $poNumber . '" order by oNum'
                )
        ) {
            foreach ($rows as $data) {

                $line = array(
                    'Order #' => $data['oNum']
                    , 'Serial Number' => $data['serialNumber']
                    , 'Machine' => $data['machineType']
                    , 'Asset #' => $data['asset']
                    , 'PO#' => $data['poNumber']
                    , 'Condition' => $data['problem']
                    , 'Grade' => $data['grade']
                );
                $output .= '"' . implode('","', $line) . '"' . "\n";
            }
        }

        return implode(',', array_keys($line)) . "\n" . $output;
    }

    function export_apple_parts($startdate, $enddate) {

        $output = '';
        $sql = "select concat('" . ORDER_NUMBER_PREFIX . "',oID) as oID, date_format(gsx_order_date,'%m/%d/%Y') as gsx_order_date, partNumber, quantity, netPrice
                    from gsx_orders
                    join gsx_orders_parts on gsx_orders_parts.gsx_id = gsx_orders.gsx_id
                    where gsx_order_date between '{$startdate}' and '{$enddate}'
                    union
                    select concat('ST',lpad(convert(gsx_stock_order.gsx_stock_id,char(3)),4,'0')) as oID,
                    date_format(order_date,'%m/%d/%Y') as gsx_order_date, partNumber, quantity, stockPrice as netPrice
                    from gsx_stock_order
                    join gsx_stock_order_parts on gsx_stock_order_parts.gsx_stock_id = gsx_stock_order.gsx_stock_id
                    where order_date between '{$startdate}' and '{$enddate}' and confirmationNumber is not null";

        if ($rows = $this->db_query($sql, 'select-multiple'))

        /* if ($rows = $this->db_select_multiple(
          'gsx_orders', "concat('".ORDER_NUMBER_PREFIX."',oID) as oID, date_format(gsx_order_date,'%m/%d/%Y') as gsx_order_date, partNumber, quantity, netPrice",
          array(),
          "where gsx_order_date between '{$startdate}' and '{$enddate}'",
          array('gsx_orders_parts on gsx_orders_parts.gsx_id = gsx_orders.gsx_id')
          )
          ) */ {
            $current_order = '';
            foreach ($rows as $data) {
                $line = array(
                    'Co./Last Name' => CO_NAME
                    , 'First Name' => ''
                    , 'Addr 1 - Line 1' => ADDR_1
                    , '           - Line 2' => ADDR_2
                    , '           - Line 3' => ADDR_3
                    , '           - Line 4' => ''
                    , 'Purchase #' => $data['oID']
                    , 'Date' => $data['gsx_order_date']
                    , 'Vendor Invoice #' => ''
                    , 'Ship Via' => ''
                    , 'Delivery Status' => 'P'
                    , 'Item Number' => ($data['netPrice'] == 0 ? 'A' . $data['partNumber'] : $data['partNumber'])
                    , 'Quantity' => $data['quantity']
                    , 'Description' => ''
                    , 'Price' => $data['netPrice']
                    , 'Discount' => '0'
                    , 'Total' => $data['netPrice'] * $data['quantity']
                    , 'Job' => ''
                    , 'Comment' => ''
                    , 'Journal Memo' => JOURNAL_MEMO
                    , 'Shipping Date' => ''
                    , 'Tax Code' => ''
                    , 'Tax Amount' => '0.00'
                    , 'Import Duty' => '0.00'
                    , 'Freight Amount' => ($data['netPrice'] == 0 ? '' : FREIGHT_AMOUNT)
                    , 'Tax on Freight' => ''
                    , 'Freight Tax Amount' => '0.00'
                    , 'Freight Import Duty Amount' => '0.00'
                    , 'Purchase Status' => ($data['netPrice'] == 0 ? 'B' : 'O')
                    , 'Currency Code' => ''
                    , 'Exchange Rate' => ''
                    , 'Terms - Payment is Due' => '2'
                    , '           - Discount Days' => '0'
                    , '           - Balance Due Days' => '1'
                    , '           - % Discount' => '0'
                    , 'Amount Paid' => '0.00'
                    , 'Category' => ''
                    , 'Order' => ($data['quantity'] == 1 ? ($data['netPrice'] == 0 ? '0' : '1') : $data['quantity'])
                    , 'Received' => '0'
                    , 'Billed' => ($data['netPrice'] == 0 ? '1' : '')
                    , 'Location ID' => LOCATION_ID
                    , 'Card ID' => CARD_ID
                    , 'Record ID' => ''
                );

                if ($current_order != '' && $current_order != $data['oID']) {
                    $output .= "\n";
                }
                $output .= '"' . implode('","', $line) . '"' . "\n";
                $current_order = $data['oID'];
            }
            return implode(',', array_keys($line)) . "\n" . $output;
        } else {
            return false;
        }
    }

    function export_apple_items($startdate, $enddate) {

        $output = '';
        $sql = "select partNumber, netPrice, pPrice, pName
                    from gsx_orders
                    join gsx_orders_parts on gsx_orders_parts.gsx_id = gsx_orders.gsx_id
                    join ds_products on (ds_products.pNum = gsx_orders_parts.partNumber or ds_products.pNum = concat('A',gsx_orders_parts.partNumber)) and (ds_products.pPrice = gsx_orders_parts.netPrice or (ds_products.pPrice > 0 and gsx_orders_parts.netPrice > 0))
                    where gsx_order_date between '{$startdate}' and '{$enddate}'
                    union
                    select partNumber, stockPrice as netPrice, pPrice, pName
                    from gsx_stock_order
                    join gsx_stock_order_parts on gsx_stock_order_parts.gsx_stock_id = gsx_stock_order.gsx_stock_id
                    join ds_products on (ds_products.pNum = gsx_stock_order_parts.partNumber or ds_products.pNum = concat('A',gsx_stock_order_parts.partNumber)) and (ds_products.pPrice = gsx_stock_order_parts.stockPrice or (ds_products.pPrice  > 0 and gsx_stock_order_parts.stockPrice > 0))
                    where order_date between '{$startdate}' and '{$enddate}' and confirmationNumber is not null";

        if ($rows = $this->db_query($sql, 'select-multiple')) {
            foreach ($rows as $data) {
                $line = array(
                    'Item Number' => ($data['netPrice'] == 0 ? 'A' . $data['partNumber'] : $data['partNumber']),
                    'Item Name' => substr($data['pName'], 0, 30),
                    'Buy' => 'B',
                    'Sell' => 'S',
                    'Inventory' => 'I',
                    'Asset Acct' => '11300',
                    'Income Acct' => '42100',
                    'Expense/COS Acct' => '51100',
                    'Item Picture' => '',
                    'Description' => $data['pName'],
                    'Use Desc. On Sale' => 'X',
                    'Custom List 1' => 'Service Parts',
                    'Custom List 2' => '',
                    'Custom List 3' => ($data['netPrice'] == 0 ? 'AppleCare' : ''),
                    'Custom Field 1' => '',
                    'Custom Field 2' => '',
                    'Custom Field 3' => '',
                    'Primary Vendor' => '',
                    'Vendor Item Number' => '',
                    'Tax When Bought' => '',
                    'Buy Unit Measure' => '',
                    '# Items/Buy Unit' => '1',
                    'Reorder Quantity' => '0',
                    'Minimum Level' => '0',
                    'Selling Price' => ($data['netPrice'] == 0 ? 0 : $data['pPrice']),
                    'Sell Unit Measure' => '',
                    'Tax When Sold' => 'T',
                    '# Items/Sell Unit' => '1',
                    'Quantity Break 1' => '0',
                    'Quantity Break 2' => '0',
                    'Quantity Break 3' => '0',
                    'Quantity Break 4' => '0',
                    'Quantity Break 5' => '0',
                    '"Price Level A, Qty Break 1"' => '0',
                    '"Price Level B, Qty Break 1"' => '0',
                    '"Price Level C, Qty Break 1' => '0',
                    '"Price Level D, Qty Break 1"' => '0',
                    '"Price Level E, Qty Break 1"' => '0',
                    '"Price Level F, Qty Break 1"' => '0',
                    '"Price Level A, Qty Break 2"' => '0',
                    '"Price Level B, Qty Break 2"' => '0',
                    '"Price Level C, Qty Break 2"' => '0',
                    '"Price Level D, Qty Break 2"' => '0',
                    '"Price Level E, Qty Break 2"' => '0',
                    '"Price Level F, Qty Break 2"' => '0',
                    '"Price Level A, Qty Break 3"' => '0',
                    '"Price Level B, Qty Break 3"' => '0',
                    '"Price Level C, Qty Break 3"' => '0',
                    '"Price Level D, Qty Break 3"' => '0',
                    '"Price Level E, Qty Break 3"' => '0',
                    '"Price Level F, Qty Break 3"' => '0',
                    '"Price Level A, Qty Break 4"' => '0',
                    '"Price Level B, Qty Break 4"' => '0',
                    '"Price Level C, Qty Break 4"' => '0',
                    '"Price Level D, Qty Break 4"' => '0',
                    '"Price Level E, Qty Break 4"' => '0',
                    '"Price Level F, Qty Break 4"' => '0',
                    '"Price Level A, Qty Break 5"' => '0',
                    '"Price Level B, Qty Break 5"' => '0',
                    '"Price Level C, Qty Break 5"' => '0',
                    '"Price Level D, Qty Break 5"' => '0',
                    '"Price Level E, Qty Break 5"' => '0',
                    '"Price Level F, Qty Break 5"' => '0',
                    'Inactive Item' => 'N',
                    'Standard Cost' => '0.00',
                    'Default Ship/Sell Location' => '',
                    'Default Recvd/Auto Location' => '',
                    'Brand' => '',
                    'Weight' => '0',
                    'Unit of Weight' => 'Pound',
                    'Web Description' => '',
                    'Sold in Web Store' => 'N',
                    'Web Store Price' => ($data['netPrice'] == 0 ? 0 : $data['pPrice'])
                );

                $output .= '"' . implode('","', $line) . '"' . "\n";
            }
            return implode(',', array_keys($line)) . "\n" . $output;
        } else {
            return false;
        }
    }

    # GETS ORDER STATUS QUANTITIES - RETURNS ARRAY

    function get_order_status_counts() {
        global $order_statii;
        $data = array();
        foreach (array_keys($order_statii) as $status) {
            $row = $this->db_select_single('ds_orders', 'count(oID)', array('cStatus' => $status));
            $data[] = array('cStatus' => $status, 'quantity' => $row[0]);
        }
        return $data;
    }

    function get_educational_count() {

        $sql = "select count(oID) as quantity from ds_orders
                join ds_customers on ds_orders.customer_id = ds_customers.cString
                    where ds_customers.educational = 'Y'
                    and cStatus not in('" . VOID . "','" . STAUS_UNABLE . "','" . STATUS_DELIVERED . "','" . STATUS_REPAIRS_DECLINED . "','" . STATUS_COMPLETE . "','" . STATUS_SHIP_2 . "','" . STATUS_WALKIN_COMPLETE . "')";

        $data = $this->db_query($sql, 'select-single');

        return $data;
    }

    # ADD ONTO RECEIVING DAILY TALLY

    function insert_receiving($day, $carrier, $qty) {
        return $this->db_insert('nl_received_today', array(
                    'day' => $day, 'carrier' => $carrier, 'quantity' => $qty
                        )
        );
    }

    # PROCESSES SEARCH SUBMISSION - RETURNS ARRAY

    function run($search, $query, $cStatus = '', $toDate = '', $fromDate = '', $dateType = 'cDate') {
		global $orders_search_fields;

        # CHECK FOR SEARCH CRITERIA
        $other = array();
        $youSearched = array();
        if ($query) {
            $youSearched[] = '&quot;' . $query . '&quot;';
        }

        # PERFORM SEARCH
        switch ($search) {
			case 'orders':
                if ($cStatus) {
                    $other[] = 'and cStatus = ' . $this->qualify_value($cStatus) . ' ';
                    $youSearched[] = $cStatus;
                } else {
                    if (substr($query, 0,2) != 'MS'){
                        $other[] = 'and cStatus != "Void" ';
                    }
					$youSearched[] = $cStatus;
                }
                if ($cStatus == 'Education') {
                    $other = implode(' ', $other);
                    if ($youSearched) {
                        $sql = "select oID from ds_orders
                                                join ds_customers on ds_orders.customer_id = ds_customers.cString
                                                where ds_customers.educational = 'Y'
                                                and cStatus not in('" . VOID . "','" . STAUS_UNABLE . "','" . STATUS_DELIVERED . "','" . STATUS_REPAIRS_DECLINED . "','" . STATUS_COMPLETE . "','" . STATUS_SHIP_2 . "','" . STATUS_WALKIN_COMPLETE . "')
                                                order by oID desc limit 0, 250";
                        $data = $this->db_query($sql, 'select-multiple');
                    }

                    foreach ($data as $row) {
                        $results[] = $row['oID'];
                    }
                } else {
                    if ($fromDate) {
                        if ($toDate) {
                            $other[] = 'and ' . $dateType . ' between from_unixtime(' . strtotime($fromDate)
                                    . ') and from_unixtime(' . strtotime($toDate) . ') ';
                            $youSearched[] = $fromDate . ' to ' . $toDate . ' (' . $dateType . ')';
                        } else {
                            $other[] = 'and ' . $dateType . ' >= from_unixtime(' . strtotime($fromDate) . ')';
                            $youSearched[] = $fromDate . ' forward' . ' (' . $dateType . ')';
                        }
                    }
                    $other = implode(' ', $other);
                    if ($youSearched) {
                        if (!$cStatus && !$fromDate && strlen($query) < 3) {
                            $this->error_page('Please use 3 or more digits in your search query.');
						}
                        $results = $this->search_records('ds_orders', $query, $orders_search_fields, 'oID', $other);
                    }
				}
                break;
            case 'customers':
                list($fields, $field_sizes) = $this->get_table_fields('ds_customers');
                $results = $this->search_records('ds_customers', $query, $fields, 'cID');
                break;
            case 'notes':
                list($fields, $field_sizes) = $this->get_table_fields('ds_order_notes');
                $results = $this->search_records('ds_order_notes', $query, $fields, 'nID');
                break;
        }
        if ($results) {
            $results = array_unique($results);
            return array($results, $youSearched);
        }
        return false;
    }

    # SEARCHES CC NUMBERS FOR QUERY - RETURNS ARRAY

    function search_cc_num($query) {
        $results = array();
        if ($rows = $this->db_select_multiple('ds_orders', 'oNum, ccNum')) {
            foreach ($rows as $row) {
                if (strstr($this->md5_decrypt($row['ccNum'], CC_SALT), $query)) {
                    $results[] = $row['oNum'];
                }
            }
        }
        return $results;
    }

    # SEARCHES ORDER RECORDS - RETURNS ARRAY

    function search_records($table, $query, $field, $get, $other = '') {
        $results = array();
        if ($query && is_array($field)) {
            $field = implode(' like ' . $this->qualify_value($query, 'WILD') . ' or ', $field);
        }
        if ($query) {
            $other .= '
				and (
					' . $field . ' like ' . $this->qualify_value($query, 'WILD') . '
				)
			';
        }
        if ($data = $this->db_select_multiple(
                $table, $get, array()
                , 'where 1=1 ' . $other . ' order by ' . $get . ' desc limit 0,' . MAX_SEARCH_RESULTS
                )
        ) {
            foreach ($data as $row) {
                $results[] = $row[$get];
            }
        }

        # ALSO CHECK FOR FIRST+LAST NAME MATCHES
        if (in_array($table, array('ds_orders', 'ds_customers'))) {
            if ($query) {
                if ($data = $this->db_select_multiple(
                        $table, $get, array()
                        , 'where concat(cShipFname, " ", cShipLname) like ' . $this->qualify_value($query, 'WILD') . ' '
                        . 'or concat(cBillFname, " ", cBillLname) like ' . $this->qualify_value($query, 'WILD')
                        )
                ) {
                    foreach ($data as $row) {
                        $results[] = $row[$get];
                    }
                }
            }
        }

        # ALSO CHECK FOR CC NUM MATCHES
        if ($table == 'ds_orders' && is_numeric($query)) {
            $results = array_merge($this->search_cc_num($query), $results);
        }
        return $results;
    }

    function display_parts($data) {

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
				<tr>
					<td class="subheading1" nowrap="nowrap">Part Number</td>
					<td class="subheading1">Description</td>
					<td class="subheading1" nowrap="nowrap">Original Part Number</td>
					<td class="subheading1">Exchange</td>
					<td class="subheading1">Stock</td>
					<td class="subheading1" nowrap="nowrap">Part Type</td>
					<td class="subheading1" nowrap="nowrap">Labor Tier</td>
                                        <td class="subheading1" nowrap="nowrap">Component Code</td>
                                        <td class="subheading1" nowrap="nowrap">Commodity Type</td>
                                        <td class="subheading1">eeeCode</td>
				</tr>
		';
        foreach ($data as $row) {

            $output .= '
                        <tr>
                            <td nowrap="nowrap">' . $row['partNumber'] . '</td>
                            <td nowrap="nowrap">' . $row['partDescription'] . '</td>
                            <td>' . $row['originalPartNumber'] . '</td>
                            <td align="right">' . money_format('%i', $row['exchangePrice']) . '</td>
                            <td align="right">' . money_format('%i', $row['stockPrice']) . '&nbsp;</td>
                            <td nowrap="nowrap">' . $row['partType'] . '</td>
                            <td>' . $row['laborTier'] . '</td>
                            <td>' . $row['componentCode'] . '</td>
                            <td>' . $row['commodityType'] . '</td>
                            <td>' . $row['eeeCode'] . '</td>
                        </tr>';
        }
        return $output . '</table>' . "\n";
    }

    function display_parts_mini($data, $machine_id) {

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
				<tr>
					<td class="subheading1" nowrap="nowrap">Part Number</td>
					<td class="subheading1">Description</td>
					<td class="subheading1">Exchange</td>
					<td class="subheading1">Stock</td>
				</tr>
		';
        foreach ($data as $row) {

            $output .= '
                        <tr>
                            <td nowrap="nowrap"><a href="' . CONTROLLER . '?m=view_item&pID=' . $row['pID'] . '&machine_id=' . $machine_id . '">' . $row['pNum'] . '</a></td>
                            <td nowrap="nowrap">' . $row['pName'] . '</td>
                            <td align="right">' . money_format('%i', $row['exchangePrice']) . '</td>
                            <td align="right">' . money_format('%i', $row['pPrice']) . '&nbsp;</td>
                        </tr>';
        }
        return $output . '</table>' . "\n";
    }

    function display_serial_lookup($data, $sort = '', $order = '') {

        $headers_array = array(
            'serialNumber' => 'Serial Number'
            , 'productDescription' => 'Machine Type'
            , 'configDescription' => 'Config Description'
            , 'warrantyStatus' => 'Warranty Status'
            , 'coverageStartDate' => 'Coverage Start Date'
            , 'coverageEndDate' => 'Coverage End Date'
            , 'daysRemaining' => 'Days Remaining'
        );

        foreach ($headers_array as $k => $v) {

            if ($k == $sort) {
                $headers .= '<td class="subheading1" onclick="sortResult(\'' . $k . '\',\'' . $order . '\');"><a href="#">' . $v . ' ' . ($order == 'asc' ? '&or;' : '&and;') . '</a></td>' . "\n";
            } else {
                $headers .= '<td class="subheading1" onclick="sortResult(\'' . $k . '\',\'asc\');"><a href="#">' . $v . '</a></td>' . "\n";
            }
        }

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr><td colspan="7" align="right"><input type="button" id="export" name="export" value="Export" onclick="exportRecords();"/></td></tr>
				<tr>' . $headers . '</tr>
		';

        foreach ($data as $row) {

            $output .= '
                        <tr>
                            <td>' . $row['serialNumber'] . '</td>
                            <td>' . $row['productDescription'] . '</td>
                            <td>' . $row['configDescription'] . '</td>
                            <td>' . $row['warrantyStatus'] . '</td>
                            <td>' . $row['coverageStartDate'] . '</td>
                            <td>' . $row['coverageEndDate'] . '</td>
                            <td>' . $row['daysRemaining'] . '</td>
                        </tr>';
        }

        $output .= '</table>' . "\n";

        $output .= '<form method="POST" id="seriallookup" name="seriallookup" action="' . CONTROLLER . '?m=mass_serial_lookup">';

        foreach ($data as $row) {

            $output .= '
                            <input type="hidden" id="serialNumber[]" name="serialNumber[]" value="' . $row['serialNumber'] . '" />
                            <input type="hidden" id="productDescription[]" name="productDescription[]" value="' . $row['productDescription'] . '" />
                            <input type="hidden" id="configDescription[]" name="configDescription[]" value="' . $row['configDescription'] . '" />
                            <input type="hidden" id="warrantyStatus[]" name="warrantyStatus[]" value="' . $row['warrantyStatus'] . '" />
                            <input type="hidden" id="coverageStartDate[]" name="coverageStartDate[]" value="' . $row['coverageStartDate'] . '" />
                            <input type="hidden" id="coverageEndDate[]" name="coverageEndDate[]" value="' . $row['coverageEndDate'] . '" />
                            <input type="hidden" id="daysRemaining[]" name="daysRemaining[]" value="' . $row['daysRemaining'] . '" />';
        }

        $output .= '
                        </form>
                        <script type="text/javascript">
                            function sortResult(field,order){
                                document.forms["seriallookup"].action = "' . CONTROLLER . '?m=mass_serial_lookup&sort="+field+"&order="+order;
                                document.forms["seriallookup"].submit();
                            }

                            function exportRecords(){
                                document.forms["seriallookup"].action = "' . CONTROLLER . '?m=serial_lookup_export";
                                document.forms["seriallookup"].submit();
                            }
                        </script>
                        ';

        return $output;
    }

    function worldship_log($filter = '', $sort = 'ship_date', $order = 'desc') {

        $where = 'where (void is null or void != "1")';

        if ($filter != '') {
            $where .= ' and (tracking_no like "%' . $filter . '%" or ref1 like "%' . $filter . '%" or ref2 like "%' . $filter . '%" or ship_to like "%' . $filter . '%")';
        }

        $sql = 'select *
                        from
                        (
                        select ups_shipments.*,ups_service.internal_description ups_service_desc,ups_package_type.internal_description package_type_old, shipping_boxes.name package_type_new
                        from ups_shipments
                        left join ups_service on ups_service.ups_service_code = ups_shipments.service
						left join ups_package_type on ups_package_type.ups_package_type_id = ups_shipments.packagetype
						left join shipping_boxes on shipping_boxes.id = ups_shipments.package_type_id
                        ' . $where . '
                        order by ship_date desc
                        limit 0,100
                        ) as subq
                        order by ' . $sort . ' ' . $order;

        $data = $this->db_query($sql, 'select-multiple');

        if ($order == 'desc') {
            $order = 'asc';
        } else {
            $order = 'desc';
        }

        $headers_array = array(
            'tracking_no' => 'Tracking #'
            , 'ship_date' => 'Ship Date'
            , 'ship_to' => 'Ship To'
            , 'city' => 'City'
            , 'state' => 'State'
            , 'ref1' => 'Ref 1'
            , 'ref2' => 'Ref 2'
            , 'ups_service_desc' => 'Service'
            , 'package_type' => 'Package Type'
            , 'weight' => 'Weight'
            , 'total_charge' => 'Total Charge'
        );

        foreach ($headers_array as $k => $v) {

            if ($k == $sort) {
                $headers .= '<td class="subheading1" onclick="sortResult(\'' . $k . '\',\'' . $order . '\');"><a href="#">' . $v . ' ' . ($order == 'asc' ? '&or;' : '&and;') . '</a></td>' . "\n";
            } else {
                $headers .= '<td class="subheading1" onclick="sortResult(\'' . $k . '\',\'asc\');"><a href="#">' . $v . '</a></td>' . "\n";
            }
        }

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr>
                                    <td colspan="2">
                                    <form name="worldshipLog" id="worldshipLog" method="POST">
                                        <input type="text" id="searchtext" name="searchtext" style="width:200px;" value="' . $filter . '"/>
                                        <input type="submit" id="search" name="search" value="Search" />
                                        <input type="button" id="clear" name="clear" value="Clear" onclick="clearForm();"/>
                                    </form>
                                    </td>
                                </tr>
                                <tr>' . $headers . '</tr>
		';

        foreach ($data as $row) {

            if ($row['void'] == '1') {
                $color = 'red';
            } else {
                $color = 'black';
			}
			$packageType = $row['package_type_new'] ? $row['package_type_new'] : $row['package_type_old'];
			$row['package_type'] = $row['package_type_new'] ? $row['package_type_new'] : $row['package_type_old'];

            $output .= '
                        <tr>
                            <td><a href="' . CONTROLLER . '?m=worldship_detail&tracking_no=' . $row['tracking_no'] . '&searchtext=' . $filter . '">' . $row['tracking_no'] . '</a></td>
                            <td><font color="' . $color . '">' . $row['ship_date'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['ship_to'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['city'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['state'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['ref1'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['ref2'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['ups_service_desc'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['package_type'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['weight'] . '</font></td>
                            <td><font color="' . $color . '">' . $row['total_charge'] . '</font></td>
                        </tr>';
        }

        $output .= '</table>' . "\n";

        $output .= '
                        <script type="text/javascript">
                            function sortResult(field,order){
                                var searchtext = document.getElementById("searchtext").value;
                                var searchfilter = "";
                                if (searchtext != ""){
                                    searchfilter = "&searchtext="+searchtext;
                                }
                                this.document.location.href = "' . CONTROLLER . '?m=worldship_log&sort="+field+"&order="+order+searchfilter;
                            }
                            function clearForm(){
                                this.document.location.href = "' . CONTROLLER . '?m=worldship_log";
                            }
                        </script>
                        ';

        return $output;
    }

    function export_parts($data) {

        $output = '';

        $output = '"Part Number","Description","Original Part Number","Exchange","Stock","Part Type","Labor Tier","Component Code","Commodity Type","eeeCode"';

        foreach ($data as $row) {
            $output .= "\n";
            $output .= '"' . $row['partNumber'] . '",';
            $output .= '"' . str_replace('"', '""', $row['partDescription']) . '",';
            $output .= '"' . $row['originalPartNumber'] . '",';
            $output .= '"' . money_format('%i', $row['exchangePrice']) . '",';
            $output .= '"' . money_format('%i', $row['stockPrice']) . '",';
            $output .= '"' . $row['partType'] . '",';
            $output .= '"' . $row['laborTier'] . '",';
            $output .= '"' . $row['componentCode'] . '",';
            $output .= '"' . $row['commodityType'] . '",';
            $output .= '"' . $row['eeeCode'] . '"';
        }

        return $output;
    }

    function display_repair_lookup($sort = '', $order = '') {

        //set time zone and get timestamp from xml file
        date_default_timezone_set('America/Los_Angeles');

        $lastupdate = date("F d Y H:i", filemtime(HTML_FOLDER . 'xml/repair_lookup.xml'));

        //get latest data from xml created by cron job
        $data = simplexml_load_file(HTML_FOLDER . 'xml/repair_lookup.xml');

        $repairs = $data->Body->RepairLookupResponse->RepairLookupResponse;

        //flip sort order
        if ($order == 'desc') {
            $order = 'asc';
        } else {
            $order = 'desc';
        }

        //array of headers
        $headers_array = array(
            'repairConfirmationNumber' => 'Confirmation Number'
            , 'createdOn' => 'Created On'
            , 'customerName' => 'Customer Name'
            , 'purchaseOrderNumber' => 'PO Number'
            , 'repairNumber' => 'Repair Number'
            , 'repairType' => 'Repair Type'
            , 'repairStatus' => 'Repair Status'
        );

        //build headers
        foreach ($headers_array as $k => $v) {

            if ($k == $sort) {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=open_repairs&sort=' . $k . '&order=' . $order . '">' . $v . ' ' . ($order == 'asc' ? '&or;' : '&and;') . '</a></td>' . "\n";
            } else {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=open_repairs&sort=' . $k . '&order=asc">' . $v . '</a></td>' . "\n";
            }
        }

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr>' . $headers . '</tr>
		';

        $i = 0;

        //build initial data array
        foreach ($repairs->lookupResponseData as $row) {


            $record[$i]['repairConfirmationNumber'] = $row->repairConfirmationNumber;
            $record[$i]['createdOn'] = $row->createdOn;
            $record[$i]['customerName'] = $row->customerName;
            $record[$i]['purchaseOrderNumber'] = $row->purchaseOrderNumber;
            $record[$i]['repairNumber'] = $row->repairNumber;
            $record[$i]['repairType'] = $row->repairType;
            $record[$i]['repairStatus'] = $row->repairStatus;

            $i++;
        }

        //flip array for sorting purposes
        foreach ($record as $row) {
            $outrecord['repairConfirmationNumber'][] = (string) $row['repairConfirmationNumber'];
            $outrecord['createdOn'][] = (string) $row['createdOn'];
            $outrecord['customerName'][] = (string) $row['customerName'];
            $outrecord['purchaseOrderNumber'][] = (string) $row['purchaseOrderNumber'];
            $outrecord['repairNumber'][] = (string) $row['repairNumber'];
            $outrecord['repairType'][] = (string) $row['repairType'];
            $outrecord['repairStatus'][] = (string) $row['repairStatus'];
        }

        $sortArray = $outrecord[$sort];

        //sort column
        if ($order == 'desc') {
            asort($sortArray);
        } else {
            arsort($sortArray);
        }

        //build array based on sort column
        foreach (array_keys($sortArray) as $k) {
            $repair_lookup[] = array(
                'repairConfirmationNumber' => $outrecord['repairConfirmationNumber'][$k]
                , 'createdOn' => $outrecord['createdOn'][$k]
                , 'customerName' => $outrecord['customerName'][$k]
                , 'purchaseOrderNumber' => $outrecord['purchaseOrderNumber'][$k]
                , 'repairNumber' => $outrecord['repairNumber'][$k]
                , 'repairType' => $outrecord['repairType'][$k]
                , 'repairStatus' => $outrecord['repairStatus'][$k]
            );
        }

        //build grid
        foreach ($repair_lookup as $row) {

            $output .= '
                        <tr>
                            <td>' . $row['repairConfirmationNumber'] . '</td>
                            <td>' . $row['createdOn'] . '</td>
                            <td>' . $row['customerName'] . '</td>
                            <td>' . $row['purchaseOrderNumber'] . '</td>
                            <td>' . $row['repairNumber'] . '</td>
                            <td>' . $row['repairType'] . '</td>
                            <td>' . $row['repairStatus'] . '</td>
                        </tr>';
        }

        $output .= '<tr><td colspan="7">&nbsp;</td</tr><tr><td colspan="7" align="left"><strong>Last updated: ' . $lastupdate . '</strong></td></tr>';

        $output .= '</table>' . "\n";

        return $output;
    }

    function display_users($sort = 'aUser', $order = 'desc') {

        if ($_GET['sort']) {
            $sort = $_GET['sort'];
        } else {
            $sort = 'aUser';
        }

        if ($_GET['order']) {
            $order = $_GET['order'];
        } else {
            $order = 'asc';
        }

        $data = $this->db_select_multiple(
                'ds_admins', 'aID, aString, aUser, aFname, aLname, aEmail, aPermType, aReports, aTimesheet, aPayroll, aAuditOnly', array(), 'order by ' . $sort . ' ' . $order
        );

        if ($order == 'desc') {
            $order = 'asc';
        } else {
            $order = 'desc';
        }

        $headers_array = array(
            'aUser' => 'User Name'
            , 'aFname' => 'First name'
            , 'aLname' => 'Last Name'
            , 'aEmail' => 'Email'
            , 'aPermType' => 'Super User'
            , 'aReports' => 'Payflow View'
            , 'aTimesheet' => 'Timesheet'
            , 'aPayroll' => 'Payroll'
            , 'aAuditOnly' => 'Audit Only'
        );

        foreach ($headers_array as $k => $v) {

            if ($k == $sort) {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=edit_users&sort=' . $k . '&order=' . $order . '">' . $v . ' ' . ($order == 'asc' ? '&or;' : '&and;') . '</a></td>' . "\n";
            } else {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=edit_users&sort=' . $k . '&order=asc">' . $v . '</a></td>' . "\n";
            }
        }

        $output = '
                        <form method="POST" id="adduser" name="adduser" action="' . CONTROLLER . '?m=add_user">
                        <table width="100%" align="right" cellpadding="0" cellspacing="5">
                            <tr>
                                <td align="right"><input type="submit" id="add" name="add" value="Add" /></td>
                            </tr>
                        </table>
                        </form>
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr>' . $headers . '</tr>
		';

        foreach ($data as $row) {

            $output .= '
                        <tr>
                            <td><a href="' . CONTROLLER . '?m=user_detail&aString=' . $row['aString'] . '">' . $row['aUser'] . '</a></td>
                            <td>' . $row['aFname'] . '</td>
                            <td>' . $row['aLname'] . '</td>
                            <td>' . $row['aEmail'] . '</td>
                            <td>' . ($row['aPermType'] == 'S' ? 'Yes' : 'No') . '</td>
                            <td>' . ($row['aReports'] == 'Y' ? 'Yes' : 'No') . '</td>
                            <td>' . ($row['aTimesheet'] == 'Y' ? 'Yes' : 'No') . '</td>
                            <td>' . ($row['aPayroll'] == 'Y' ? 'Yes' : 'No') . '</td>
                            <td>' . ($row['aAuditOnly'] == 'Y' ? 'Yes' : 'No') . '</td>
                        </tr>';
        }

        $output .= '</table>' . "\n";

        return $output;
    }

    function display_machines($sort = 'aUser', $order = 'desc') {

        if ($_GET['sort']) {
            $sort = $_GET['sort'];
        } else {
            $sort = 'ml.machine_description';
        }

        if ($_GET['order']) {
            $order = $_GET['order'];
        } else {
            $order = 'asc';
        }

        $sql = 'select mon.order_number_id, mon.order_number, ml.machine_id, ml.machine_description, ml.model_identifier, ml.processor, ml.introduced
                    from machine_lookup ml
                    left join machine_order_number mon on ml.machine_id = mon.machine_id
                    where ml.enabled = true
                    and mon.enabled = true
                    order by ' . $sort . ' ' . $order;

        $data = $this->db_query($sql, 'select-multiple');

        if ($order == 'desc') {
            $order = 'asc';
        } else {
            $order = 'desc';
        }

        $headers_array = array(
            'mon.order_number' => 'Order Number'
            , 'ml.machine_description' => 'Machine'
            , 'ml.model_identifier' => 'Model Identifier'
            , 'ml.model_number' => 'Model Number'
            , 'ml.processor' => 'Processor'
            , 'ml.introduced' => 'Introduced'
        );

        foreach ($headers_array as $k => $v) {

            if ($k == $sort) {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=machine_database&sort=' . $k . '&order=' . $order . '">' . $v . ' ' . ($order == 'asc' ? '&or;' : '&and;') . '</a></td>' . "\n";
            } else {
                $headers .= '<td class="subheading1"><a href="' . CONTROLLER . '?m=machine_database&sort=' . $k . '&order=asc">' . $v . '</a></td>' . "\n";
            }
        }

        $output = '
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <form method="POST" id="adduser" name="adduser" action="' . CONTROLLER . '?m=find_machine">
                                <tr>
                                    <td colspan="4">Serial # <input type="text" id="serialNumber" name="serialNumber" style="width:200px;" /> <input type="submit" id="search" name="search" value="Search" /></td>
                                    <td colspan="2" align="right">
                                        <input type="submit" id="addmachine" name="addmachine" value="Add Machine" />
                                        <input type="submit" id="addorder" name="addorder" value="Add Order Number" />
                                    </td>
                                </tr>
                                <tr>' . $headers . '</tr>
		';

        foreach ($data as $row) {

            $output .= '
                        <tr>';
            if ($row['order_number_id']) {
                $output .= '<td><a href="' . CONTROLLER . '?m=order_number_edit&order_number_id=' . $row['order_number_id'] . '">' . $row['order_number'] . '</a></td>';
            } else {
                $output .= '<td><a href="' . CONTROLLER . '?m=order_number_edit&machine_id=' . $row['machine_id'] . '">Add</a></td>';
            }
            $output .= '<td><a href="' . CONTROLLER . '?m=machine_detail&machine_id=' . $row['machine_id'] . '">' . $row['machine_description'] . '</a></td>
                            <td>' . $row['model_identifier'] . '</td>
                            <td>' . $row['model_number'] . '</td>
                            <td>' . $row['processor'] . '</td>
                            <td>' . $row['introduced'] . '</td>
                        </tr>';
        }

        $output .= '</table>' . "\n";

        return $output;
    }

    function display_pay_periods() {

        $data = $this->db_select_multiple('ts_pay_period', '*', array(), 'order by period_start_date desc limit 0,20');

        $output = '
                        <form method="POST" id="adduser" name="adduser" action="' . CONTROLLER . '?m=pay_period_edit">
                        <table width="100%" align="right" cellpadding="0" cellspacing="5">
                            <tr>
                                <td align="right"><input type="submit" id="add" name="add" value="Add" /></td>
                            </tr>
                        </table>
                        </form>
			<table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr>
                                    <td class="subheading1">Name</td>
                                    <td class="subheading1">Start Date</td>
                                    <td class="subheading1">End Date</td>
                                    <td class="subheading1">Pay Date</td>
                                </tr>
		';

        foreach ($data as $row) {

            $output .= '
                    <tr>
                        <td><a href="' . CONTROLLER . '?m=pay_period_edit&period_id=' . $row['period_id'] . '">' . $row['period_name'] . '</a></td>
                        <td>' . $row['period_start_date'] . '</td>
                        <td>' . $row['period_end_date'] . '</td>
                        <td>' . $row['period_pay_date'] . '</td>
                    </tr>';
        }

        $output .= '</table>' . "\n";

        return $output;
    }

    function display_po_numbers(){

        $data = $this->db_select_multiple('po_numbers', '*',array(),'order by po_number');

        $headers .= '<td class="subheading1">PO Number</td>' . "\n";

        $output = '
                        <form method="POST" id="add_po_number" name="add_po_number" action="' . CONTROLLER . '?m=add_po_number">
                        <table width="100%" align="center" cellpadding="0" cellspacing="5">
                                <tr>' . $headers . '</tr>
		';

        foreach ($data as $row) {

            $output .= '
                        <tr>
                            <td>' . $row['po_number'] . '
                            &nbsp;<a href="' . CONTROLLER . '?m=po_number_delete&po_number_id=' . $row['po_number_id'] . '">Delete</a></td>
                        </tr>';
        }

        $output .= '
                    <tr>
                        <td><input type="text" id="po_number" name="po_number" class="borderless" />&nbsp;<input type="submit" id="add" name="add" value="Add" /></td>
                    </tr>
                ';


        $output .= '</table></form>' . "\n";

        return $output;


	}

	function massOrderAuditExport($orderNumbers, $returnData = false) {
        global $hdvolumes, $ramvolumes;
		$exportOrders = $this->getONumsFromSerials($orderNumbers);

		$oNums = implode("', '", $exportOrders);
		$sql =
			"SELECT
				dso.*,
				IFNULL(
					(SELECT
						CASE
							WHEN dso.grade_at_audit = 'A' THEN poi.price_a
							WHEN dso.grade_at_audit = 'B' THEN poi.price_b
							WHEN dso.grade_at_audit = 'C' THEN poi.price_c
							WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
							WHEN dso.grade_at_audit = 'F' THEN poi.price_f
							END
						FROM po_items AS poi
						WHERE poi.order_id =
							(SELECT por.order_id
							FROM po_orders AS por
							WHERE por.order_number = dso.poNumber LIMIT 1)
						AND poi.order_number = IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) LIMIT 1), 0) AS `cost`
			FROM ds_orders AS dso
			WHERE dso.oNum IN ('$oNums')
			ORDER BY is_ipad, oNum;
			";
		$rows = $this->db_query($sql, 'select-multiple', true);

		$hasiPads = false;
		$hasOthers = false;

		if ($rows) {
			foreach ($rows as $data) {
				if ($data['is_ipad'] == 1) {
					$hasiPads = true;
				}
				else {
					$hasOthers = true;
				}

				$cost = $data['cost'];

				$hdtotal = 0;
				$hdstr = '';

				if ($data['hd_1'] != '') {
					$hdtotal = (int) $hdvolumes[$data['hd_1']];
				}

				if ($data['hd_2'] != '') {
					$hdtotal += (int) $hdvolumes[$data['hd_2']];
				}

				if ($hdtotal > 0){
					if ($hdtotal < 1024) {
						$hdstr = $hdtotal . 'GB';
					} else {
						$hdstr = round((float) ($hdtotal / 1024), 1) . 'TB';
					}
				}

				$ramtotal = 0;
				$ramstr = '';

				if ($data['ram_1'] != '') {
					$ramtotal = (int) $ramvolumes[$data['ram_1']];
				}

				if ($data['ram_2'] != '') {
					$ramtotal += (int) $ramvolumes[$data['ram_2']];
				}

				if ($data['ram_3'] != '') {
					$ramtotal += (int) $ramvolumes[$data['ram_3']];
				}

				if ($data['ram_4'] != '') {
					$ramtotal += (int) $ramvolumes[$data['ram_4']];
				}

				if ($ramtotal > 0){
					if ($ramtotal < 1024) {
						$ramstr = $ramtotal . 'MB';
					} else {
						$ramstr = round((float) ($ramtotal / 1024), 1) . 'GB';
					}
				}

				$digistr = '';
				$casestr = '';

				if ($data['digitizer_scratch']){
					$digiarray[] = 'Scratch';
				}

				if ($data['digitizer_crack']){
					$digiarray[] = 'Crack';
				}

				$digistr = implode(', ', $digiarray);

				unset($digiarray);

				if ($data['case_scratch']){
					$casearray[] = 'Scratch';
				}

				if ($data['case_crack']){
					$casearray[] = 'Crack';
				}

				if ($data['case_dent']){
					$casearray[] = 'Dent';
				}

				$casestr = implode(', ', $casearray);

				unset($casearray);

				$cosmeticstr = '';

				if ($data['top_case']){
					$cosmeticarr[] = 'Top Case';
				}

				if ($data['display_housing']){
					$cosmeticarr[] = 'Display Housing';
				}

				if ($data['bottom_case']){
					$cosmeticarr[] = 'Bottom Case';
				}

				if ($data['refurb_keys']){
					$cosmeticarr[] = 'Missing Keys';
				}

				if ($data['hinge']){
					$cosmeticarr[] = 'Hinge';
				}

				if ($data['scratch']){
					$cosmeticarr[] = 'Heavy Scratches';
				}

				if ($data['marking']){
					$cosmeticarr[] = 'Permanent Markings';
				}

				$cosmeticstr = implode(', ', $cosmeticarr);

				unset($cosmeticarr);

				$noiPadLine = array(
					'Serial Number' => $data['serialNumber']
					, 'Device Type' => $data['machineType']
					, 'SKU' => $data['asset']
					, 'Hard Drive' => $hdstr
					, 'RAM' => $ramstr
					, 'Notes' => $data['refurb_notes']
					, 'Optical' => $data['optical']=='pass'?'Pass':($data['optical']=='fail'?'Fail':($data['optical']=='na'?'N/A':''))
					, 'LCD' => $data['lcd']=='pass'?'Pass':($data['lcd']=='fail'?'Fail':($data['lcd']=='na'?'N/A':''))
					, 'Glass' => $data['glass']=='pass'?'Pass':($data['glass']=='fail'?'Fail':($data['glass']=='na'?'N/A':''))
					, 'Ethernet' => $data['enet']=='pass'?'Pass':($data['enet']=='fail'?'Fail':($data['enet']=='na'?'N/A':''))
					, 'Wifi' => $data['is_ipad']?'':$data['wifi']=='pass'?'Pass':($data['wifi']=='fail'?'Fail':($data['wifi']=='na'?'N/A':''))
					, 'Speakers' => $data['speakers']=='pass'?'Pass':($data['speakers']=='fail'?'Fail':($data['speakers']=='na'?'N/A':''))
					, 'Battery' => $data['battery']=='pass'?'Pass':($data['battery']=='fail'?'Fail':($data['battery']=='na'?'N/A':''))
					, 'Cycles' => $data['battery_cycles']
					, 'mAh' => $data['battery_mah']
					, 'iSight' => $data['isight']=='pass'?'Pass':($data['isight']=='fail'?'Fail':($data['isight']=='na'?'N/A':''))
					, 'Cosmetic issues' => $cosmeticstr
					, 'Activation Lock' => $data['activation_lock']==1?'Yes':''
					, 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
					, 'Audit Summary' => $data['audit_summary']
				);
				$noiPadOutput .= '"' . implode('","', $noiPadLine) . '"' . "\n";

				$noOthersLine = array(
					'Serial Number' => $data['serialNumber']
					, 'Device Type' => $data['machineType']
					, 'SKU' => $data['asset']
					, 'iPad' => $data['is_ipad']?'Yes':''
					, 'Capacity' => $data['capacity']
					, 'Digitizer' => $digistr
					, 'Case' => $casestr
					, 'Home' => $data['home_button']=='pass'?'Pass':($data['home_button']=='fail'?'Fail':($data['home_button']=='na'?'N/A':''))
					, 'Volume' => $data['volume']=='pass'?'Pass':($data['volume']=='fail'?'Fail':($data['volume']=='na'?'N/A':''))
					, 'Activation Lock' => $data['activation_lock']==1?'Yes':''
					, 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
					, 'Audit Summary' => $data['audit_summary']
				);
				$noOthersOutput .= '"' . implode('","', $noOthersLine) . '"' . "\n";

				$allLine = array(
				'Serial Number' => $data['serialNumber']
				, 'Device Type' => $data['machineType']
				, 'SKU' => $data['asset']
				, 'Hard Drive' => $hdstr
				, 'RAM' => $ramstr
				, 'Notes' => $data['refurb_notes']
				, 'Optical' => $data['optical']=='pass'?'Pass':($data['optical']=='fail'?'Fail':($data['optical']=='na'?'N/A':''))
				, 'LCD' => $data['lcd']=='pass'?'Pass':($data['lcd']=='fail'?'Fail':($data['lcd']=='na'?'N/A':''))
				, 'Glass' => $data['glass']=='pass'?'Pass':($data['glass']=='fail'?'Fail':($data['glass']=='na'?'N/A':''))
				, 'Ethernet' => $data['enet']=='pass'?'Pass':($data['enet']=='fail'?'Fail':($data['enet']=='na'?'N/A':''))
				, 'Wifi' => $data['is_ipad']?'':$data['wifi']=='pass'?'Pass':($data['wifi']=='fail'?'Fail':($data['wifi']=='na'?'N/A':''))
				, 'Speakers' => $data['speakers']=='pass'?'Pass':($data['speakers']=='fail'?'Fail':($data['speakers']=='na'?'N/A':''))
				, 'Battery' => $data['battery']=='pass'?'Pass':($data['battery']=='fail'?'Fail':($data['battery']=='na'?'N/A':''))
				, 'Cycles' => $data['battery_cycles']
				, 'mAh' => $data['battery_mah']
				, 'iSight' => $data['isight']=='pass'?'Pass':($data['isight']=='fail'?'Fail':($data['isight']=='na'?'N/A':''))
				, 'Cosmetic issues' => $cosmeticstr
				, 'iPad' => $data['is_ipad']?'Yes':''
				, 'Capacity' => $data['capacity']
				, 'Digitizer' => $digistr
				, 'Case' => $casestr
				, 'Home' => $data['home_button']=='pass'?'Pass':($data['home_button']=='fail'?'Fail':($data['home_button']=='na'?'N/A':''))
				, 'Volume' => $data['volume']=='pass'?'Pass':($data['volume']=='fail'?'Fail':($data['volume']=='na'?'N/A':''))
				, 'Activation Lock' => $data['activation_lock']==1?'Yes':''
				, 'MDM Lock' => $data['mdm_lock']==1?'Yes':''
				, 'Audit Summary' => $data['audit_summary']
				);
				$allOutput .= '"' . implode('","', $allLine) . '"' . "\n";

			}
		}

		//if not returning data
		if (!$returnData) {
			# SEND TO BROWSER FOR DOWNLOAD
			if (!$hasiPads && $noiPadOutput) {
				$this->send_file_to_browser(
						implode(',', array_keys($noiPadLine)) . "\n" . $noiPadOutput
						, 'audit_orders_details.csv'
				);
			}
			elseif (!$hasOthers && $noOthersOutput) {
				$this->send_file_to_browser(
						implode(',', array_keys($noOthersLine)) . "\n" . $noOthersOutput
						, 'audit_orders_details.csv'
				);
			}
			elseif ($hasiPads && $hasOthers && $allOutput) {
				$this->send_file_to_browser(
						implode(',', array_keys($allLine)) . "\n" . $allOutput
						, 'audit_orders_details.csv'
				);
			}
			if ($output) {
				$this->send_file_to_browser(
						implode(',', array_keys($line)) . "\n" . $output
						, 'audit_orders_details.csv'
				);
			}
			return false;
		} else {
			return implode(',', array_keys($line)) . "\n" . $output;
		}

	}

	function getONumsFromSerials($orderNumbers) {
		$spNumPattern = '/^(SP\d{6})$/';
		$serialNumbers = array();
		$exportOrders = array();
		for ($i = 0; $i < count($orderNumbers); $i++) {
			if (!preg_match($spNumPattern, strtoupper(trim($orderNumbers[$i])))) {
				array_push($serialNumbers, strtoupper(trim($orderNumbers[$i])));
			}
			else {
				array_push($exportOrders, strtoupper(trim($orderNumbers[$i])));
			}
		}
		if (count($serialNumbers) > 0) {
			$glue = "', '";
			$sql = "SELECT dso.oNum FROM ds_orders AS dso WHERE dso.serialNumber IN ('";
			$sql .= implode($glue, $serialNumbers);
			$sql .= "');";
			$moreOrders = $this->db_query($sql, 'select-multiple', true);
		}
		foreach ($moreOrders as $order) {
			array_push($exportOrders, $order['oNum']);
		}
		return $exportOrders;
	}

}

?>
