<?php

class Payment extends Database {
    
        function payflowpro_report($date){
            
            //create report
            $doc = new DOMDocument();
            
            //build xml
            $doc->formatOutput = true;
            
            $reportingEngineRequest = $doc->createElement('reportingEngineRequest');
            
            $authRequest = $doc->createElement('authRequest');
            
            $user = $doc->createElement('user', MERCH_USER);
            $authRequest->appendChild($user);
            
            $vendor = $doc->createElement('vendor', MERCH_USER);
            $authRequest->appendChild($vendor);
            
            $partner = $doc->createElement('partner', MERCH_PARTNER);
            $authRequest->appendChild($partner);
            
            $password = $doc->createElement('password', MERCH_PASS);
            $authRequest->appendChild($password);
            
            $reportingEngineRequest->appendChild($authRequest);
            
            $runReportRequest = $doc->createElement('runReportRequest');
            
            $reportName = $doc->createElement('reportName', 'DailyActivityReport');
            $runReportRequest->appendChild($reportName);
            
            $reportParam = $doc->createElement('reportParam');
            
            $paramName = $doc->createElement('paramName', 'report_date');
            $reportParam->appendChild($paramName);
            
            $paramValue = $doc->createElement('paramValue', $date);
            $reportParam->appendChild($paramValue);
            
            $runReportRequest->appendChild($reportParam);
            
            $reportParam = $doc->createElement('reportParam');
            
            $paramName = $doc->createElement('paramName', 'timezone');
            $reportParam->appendChild($paramName);
            
            $paramValue = $doc->createElement('paramValue', 'GMT-08:00');
            $reportParam->appendChild($paramValue);
            
            $runReportRequest->appendChild($reportParam);
            
            $runReportRequest->appendChild($reportParam);
            
            $pageSize = $doc->createElement('pageSize', '50');
            $runReportRequest->appendChild($pageSize);
            
            $reportingEngineRequest->appendChild($runReportRequest);
            
            $doc->appendChild($reportingEngineRequest);
            
            $xml = $doc->saveXML();
            
            //send xml to reporting system
            $response = $this->tx_rx_curl('https://payments-reports.paypal.com/reportingengine', '', $xml);
            
            $retxml= @simplexml_load_string($response);
            
            $runReportResponse = (array)$retxml->runReportResponse;
            
            $id = $runReportResponse['reportId'];
            
            
            //get report data
            $doc = new DOMDocument();
            
            //build xml
            $doc->formatOutput = true;
            
            $reportingEngineRequest = $doc->createElement('reportingEngineRequest');
            
            $authRequest = $doc->createElement('authRequest');
            
            $user = $doc->createElement('user', MERCH_USER);
            $authRequest->appendChild($user);
            
            $vendor = $doc->createElement('vendor', MERCH_USER);
            $authRequest->appendChild($vendor);
            
            $partner = $doc->createElement('partner', MERCH_PARTNER);
            $authRequest->appendChild($partner);
            
            $password = $doc->createElement('password', MERCH_PASS);
            $authRequest->appendChild($password);
            
            $reportingEngineRequest->appendChild($authRequest);
            
            $getDataRequest = $doc->createElement('getDataRequest');
            
            $reportId = $doc->createElement('reportId', $id);
            $getDataRequest->appendChild($reportId);
            
            $pageNum = $doc->createElement('pageNum', '1');
            $getDataRequest->appendChild($pageNum);
            
            $reportingEngineRequest->appendChild($getDataRequest);
            
            $doc->appendChild($reportingEngineRequest);
            
            $xml = $doc->saveXML();
            
            //send xml to reporting system
            $response = $this->tx_rx_curl('https://payments-reports.paypal.com/reportingengine', '', $xml);
            
            $retxml= @simplexml_load_string($response);
            
            $rows = $retxml->getDataResponse->reportDataRow;
            
            //delete any existing records for day
            $this->db_query('delete from payflow_daily_activity where r_time like "'.$date.'%"','delete');
            
            //write records to db
            foreach ($retxml->getDataResponse->reportDataRow as $row){
                
                $data = array(
                    'transaction_id'    =>  $row->columnData[0]->data,
                    'r_time'            =>  $row->columnData[1]->data,
                    'r_type'            =>  $row->columnData[2]->data,
                    'tender_type'       =>  $row->columnData[3]->data,
                    'account_number'    =>  $row->columnData[4]->data,
                    'expires'           =>  $row->columnData[5]->data,
                    'amount'            =>  (float)$row->columnData[6]->data/100,
                    'result_code'       =>  $row->columnData[7]->data,
                    'response_msg'      =>  $row->columnData[8]->data,
                    'comment1'          =>  $row->columnData[9]->data,
                    'comment2'          =>  $row->columnData[10]->data,
                    'client_ip'         =>  $row->columnData[11]->data,
                    'authcode'          =>  $row->columnData[12]->data,
                    'avs_street_match'  =>  $row->columnData[13]->data,
                    'avs_zip_match'     =>  $row->columnData[14]->data,
                    'currency_symbol'   =>  $row->columnData[15]->data
                );
                
                $this->db_insert('payflow_daily_activity', $data);
            }
            
        }

	# PAYPAL PAYFLOW PRO COMM - RETURNS ARRAY
	function payflowpro_comm($type, $params, $data) {
		global $payflowpro_reject_responses;
		$headers = array(
			'Content-Type: text/namevalue'
			, 'X-VPS-Timeout: 30'
			, 'X-VPS-VIT-OS-Name: Linux'
			, 'X-VPS-VIT-OS-Version: RHEL 4'
			, 'X-VPS-VIT-Client-Type: PHP/cURL'
			, 'X-VPS-VIT-Client-Version: ' . VERSION
			, 'X-VPS-VIT-Client-Architecture: x86'
			, 'X-VPS-VIT-Integration-Product: Custom'
			, 'X-VPS-VIT-Integration-Version: ' . VERSION
			, 'X-VPS-Request-ID: ' . md5($params['ACCT']. '1.00' . $this->format_date('misc_2') . '1')
		);
		$params = array_merge($params, array(
				'VERSION'		=> 51
				, 'TENDER'		=> 'C'
				, 'USER'		=> MERCH_USER
				, 'PWD'			=> MERCH_PASS
				, 'VENDOR'		=> MERCH_USER
				, 'PARTNER'		=> MERCH_PARTNER
				, 'VERBOSITY'	=> 'MEDIUM'
			)
		);
		if (!$response = $this->tx_rx_curl(GATEWAY, $headers, $params)) {
			return array(false, array('ERROR: Unable to communicate with Payment Service.  Please try again momentarily.'));
		}
		$response = explode('&', $response);
		$responses = array();
		foreach ($response as $i => $nvp) {
			$nvp = explode('=', $nvp);
			$responses[$nvp[0]] = $nvp[1];
			$responses[$i] = $nvp[1];
		}

		# DETERMINE DISPOSITION, BASED ON RESPONSE CODE AND AUTH VS. CAPTURE
		$pass = false;
		switch ($type) {
			case 'A': //Authorization
				if (!in_array($responses[0], array_keys($payflowpro_reject_responses))) {
					$pass = true;
					if ($responses[0]) {
						$this->send_email(
							ORDERS_FROM, ORDERS_FROM, 'Authorization Soft Fail: ' . $data['cEmail']
							, $responses['RESPMSG'], 'text/plain'
						);
					}
				}
			break;
                        case 'AI': //Internal authorization
                            if ($responses['AVSADDR'] == 'Y' && $responses['AVSZIP'] == 'Y' && $responses['CVV2MATCH'] == 'Y'){
                                $pass = true;
                            }
                        break;
			case 'S': //Sale
				if ($responses['RESPMSG'] == 'Approved') {
					$pass = true;
				}
			break;
		}

		# HANDLE ERRORS
		if (!$pass) {
			$cc_error = array();
			$cc_error[] = '* Credit card error: ' . $payflowpro_reject_responses[$responses[0]];
			if ($responses['AVSADDR'] == 'N' || $responses['AVSZIP'] == 'N') {
				$cc_error[] = '* Address Verification Failed';
			}
			if ($responses['CVV2MATCH'] == 'N') {
				$cc_error[] = '* Card Verification Value was incorrect';
			}
			return array($pass, $cc_error);
		}
		return array($pass, $responses['PNREF']);
	}

	# PAYPAL PAYFLOW PRO PAYMENT - RETURNS BOOL
	function payflowpro_service($submitted, $note='', $type='A', $amt=1) {
		if (MODE != 'PROD') {
			//$note = MODE . '-' . $note;
		}
		if ($submitted['ccExpMonth'] && $submitted['ccExpYear']) {
			$submitted['ccExp'] = $submitted['ccExpMonth'] . $submitted['ccExpYear'];
		}
                if ($_SESSION['ccNum']){
                    $ccNum = $_SESSION['ccNum'];
                }else{
                    $ccNum = $submitted['ccNum'];
                }
		$params = array(
			'METHOD'		=> 'DoDirectPayment'
			, 'TRXTYPE'		=> substr($type,0,1)
			, 'ACCT'		=> $ccNum
			, 'EXPDATE'		=> $submitted['ccExp']
			, 'CVV2'		=> $submitted['CVV2']
			, 'AMT'			=> $amt
			, 'NAME'		=> $submitted['ccName']
			, 'STREET'		=> $submitted['cBillAddress1']
			, 'CITY'		=> $submitted['cBillCity']
			, 'STATE'		=> $submitted['cBillState']
			, 'ZIP'			=> $submitted['cBillZip']
			, 'COMMENT1'	=> $note
		);
		return $this->payflowpro_comm($type, $params, $submitted);
	}

	# PAYPAL EXPRESS CHECKOUT COMM - RETURNS ARRAY
	function paypal_express_comm($params) {
		$params = array_merge($params, array(
				'USER'			=> PAYPAL_USER
				, 'PWD'			=> PAYPAL_PASS
				, 'SIGNATURE'	=> PAYPAL_SIGNATURE
				, 'VERSION'		=> 51
				, 'VERBOSITY'	=> 'MEDIUM'
			)
		);
		$httpResponseAr = $this->tx_rx_curl(PAYPAL_API, false, $params);
		$httpResponseAr = explode('&', $httpResponseAr);
		$httpParsedResponseAr = array();
		foreach ($httpResponseAr as $i => $value) {
			$tmpAr = explode('=', $value);
			if(sizeof($tmpAr) > 1) {
				$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
			}
		}
		if ((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr)) {
			exit('Invalid HTTP Response for POST request.');
		}
		return $httpParsedResponseAr;
	}

	# PAYPAL EXPRESS CHECKOUT PAYMENT
	function paypal_service($oNum, $data, $token, $payerID) {
		global $orderObj;
		if ($token && $payerID) {
			$params = array(
				'METHOD'			=> 'DoExpressCheckoutPayment'
				, 'PAYMENTACTION'	=> 'Sale'
				, 'CURRENCYCODE'	=> 'USD'
				, 'AMT'				=> $data['cTotal']
				, 'TOKEN'			=> urlencode(htmlspecialchars($token))
				, 'PAYERID'			=> urlencode(htmlspecialchars($payerID))
			);
			if ($result = $this->paypal_express_comm($params)) {
				if ($result['PAYMENTSTATUS'] == 'Completed') {
					$data['payment_method'] = 'PayPal';
					$data['ccType'] = 'PayPal';
					$orderObj->payment_service_received($oNum, $result['TRANSACTIONID'], $data);
				} else {
					return '<p class="error"><br />Error: PayPal reports: '
						. $result['L_LONGMESSAGE0'] . $result['PENDINGREASON'];
				}
			}
		} else {
			$params = array(
				'METHOD'			=> 'SetExpressCheckout'
				, 'PAYMENTACTION'	=> 'Sale'
				, 'CURRENCYCODE'	=> 'USD'
				, 'AMT'				=> $data['cTotal']
				, 'RETURNURL'		=> SITE_SURL . CONTROLLER . '?m=account_paypal_service&oNum=' . $oNum
				, 'CANCELURL'		=> SITE_SURL . CONTROLLER . '?m=account&oNum=' . $oNum
			);
			if ($result = $this->paypal_express_comm($params)) {
				header('Location: ' . PAYPAL_URL . $result["TOKEN"]);
				exit;
			}
		}
	}

	# GOOGLE CHECKOUT / ORDER CREATION
	function google_checkout($cSession, $submitted) {
		global $cartObj, $orderObj;
		if ($oNum = $orderObj->create($cSession, 'af66a146302d815ddfb24ef80ecf0998', array(
					'cEmail'			=> 'google-checkout@myservice.com'
					, 'cBillFname'		=> 'Google'
					, 'cBillLname'		=> 'Checkout'
					, 'cShipFname'		=> 'Google'
					, 'cShipLname'		=> 'Checkout'
					, 'problem'			=> implode("\n\nMachine: ", $submitted['problem'])
					, 'ccType'			=> 'Google Checkout'
					, 'payment_method'	=> 'Google Checkout'
					, 'cDate'			=> $this->format_date('db_date')
				), $cartObj->get_pricing($cSession, 'af66a146302d815ddfb24ef80ecf0998'), '', ORDER_NUM_PREFIX
			)
		) {
			if ($response = $this->tx_rx_curl(
					GOOGLE_API, false, $this->google_checkout_xml($oNum, $cartObj->get_data($oNum), $cSession)
				)
			) {
				if ($resultObj = simplexml_load_string($response)) {
					if ($url = $resultObj->{'redirect-url'}) {
						$_SESSION['destroyme'] = 10;
						$this->goToUrl($url);
						exit;
					}
					return '<p class="error"><br />' . $resultObj->{'error-message'} . '</p>';
				}
			}
			return '<p class="error"><br />Failed to communicate with Google Checkout service.</p>';
		}
	}

	# GOOGLE CHECKOUT INCOMING WEB SERVICE (NOTIFICATIONS)
	function google_service_incoming($xml) {
		global $orderObj, $cartObj, $custObj, $ship_methods;
		$xObj = @simplexml_load_string($xml);
		$gNum = '' . $xObj->{'google-order-number'};
		$this->send_email('amber@macservice.com', ERROR_LOG_EMAIL, 'GC: ' . $gNum, $xml, 'text/plain');

		# ASYNCHRONOUS NEW ORDER NOTIFICATION - UPDATE THE SKELETON ORDER
		if (strstr($xml, '<new-order-notification ')) {
			if ($oNum = '' . $xObj->{'shopping-cart'}->{'merchant-private-data'}->oNum) {
				$data = $orderObj->get_data($oNum);
				if ($data['cStatus'] == STATUS_PENDING) {
					$data = array(
						'google_order_num'	=> $gNum
						, 'problem'			=> $data['problem']
						, 'cShipService'	=> '' . $xObj->{'order-adjustment'}->shipping->{'flat-rate-shipping-adjustment'}->{'shipping-name'}
						, 'cEmail'			=> '' . $xObj->{'buyer-billing-address'}->email
						, 'cStatus'			=> $ship_methods['' . $xObj->{'order-adjustment'}->shipping->{'flat-rate-shipping-adjustment'}->{'shipping-name'}]['order-status']
						, 'cBillCompany'	=> '' . $xObj->{'buyer-billing-address'}->{'company-name'}
						, 'cBillFname'		=> $this->split_names('' . $xObj->{'buyer-billing-address'}->{'contact-name'}, 'first')
						, 'cBillLname'		=> $this->split_names('' . $xObj->{'buyer-billing-address'}->{'contact-name'}, 'last')
						, 'cPhone'			=> '' . $xObj->{'buyer-billing-address'}->phone
						, 'cBillAddress1'	=> '' . $xObj->{'buyer-billing-address'}->address1
						, 'cBillAddress2'	=> '' . $xObj->{'buyer-billing-address'}->address2
						, 'cBillCity'		=> '' . $xObj->{'buyer-billing-address'}->city
						, 'cBillState'		=> '' . $xObj->{'buyer-billing-address'}->region
						, 'cBillZip'		=> '' . $xObj->{'buyer-billing-address'}->{'postal-code'}
						, 'cBillCountry'	=> '' . $xObj->{'buyer-billing-address'}->{'country-code'}
						, 'cShipCompany'	=> '' . $xObj->{'buyer-shipping-address'}->{'company-name'}
						, 'cShipEmail'		=> '' . $xObj->{'buyer-shipping-address'}->email
						, 'cShipFname'		=> $this->split_names('' . $xObj->{'buyer-shipping-address'}->{'contact-name'}, 'first')
						, 'cShipLname'		=> $this->split_names('' . $xObj->{'buyer-shipping-address'}->{'contact-name'}, 'last')
						, 'cShipAddress1'	=> '' . $xObj->{'buyer-shipping-address'}->address1
						, 'cShipAddress2'	=> '' . $xObj->{'buyer-shipping-address'}->address2
						, 'cShipCity'		=> '' . $xObj->{'buyer-shipping-address'}->city
						, 'cShipState'		=> '' . $xObj->{'buyer-shipping-address'}->region
						, 'cShipZip'		=> '' . $xObj->{'buyer-shipping-address'}->{'postal-code'}
						, 'cShipCountry'	=> '' . $xObj->{'buyer-shipping-address'}->{'country-code'}
					);
					$data = array_merge($data, $cartObj->get_pricing($oNum, $data['customer_id'], $data));
					if ('' . $xObj->{'buyer-marketing-preferences'}->{'email-allowed'} != 'false') {
						$custObj->subscribe($data['cEmail']);
					}
					if (!$customer = $custObj->get_data($data['cEmail'])) {
						if ($custObj->insert($this->createUniqueKey(), $data)) {
							$customer = $custObj->get_data($data['cEmail']);
						}
					}
					$data['customer_id'] = $customer['cString'];
					$this->db_update('ds_orders', 'oNum', $oNum, $data);
					$orderObj->resend('Receipt', $oNum, $customer['cString'], $data);
					if (stristr($data['cShipService'], 'round trip')) {
						list ($track1, $track2, $error) = $orderObj->box_ship($data, $oNum, false);
					}
				}
			}

		# ASYNCRONOUS CHARGE COMPLETE NOTIFICATION, CLOSEOUT ORDER
		} else if (strstr($xml, '<charge-amount-notification ')) {
			$data = $orderObj->get_data_google($gNum);
			$charged = '' . $xObj->{'total-charge-amount'};
			if ($charged == $data['cTotal']) {
				$data['payment_method'] = 'Google Checkout';
				$data['ccType'] = 'Google Checkout';
				$orderObj->payment_service_received($data['oNum'], $gNum, $data, false);
			}
		}
		$this->google_service_incoming_receipt('' . $xObj->attributes()->{'serial-number'});
	}

	# GOOGLE CHECKOUT INCOMING WEB SERVICE RECEIVED HANDSHAKE
	function google_service_incoming_receipt($serial) {		
		header('HTTP/1.0 200 OK');
		die('<?xml version="1.0" encoding="UTF-8"?><notification-acknowledgment '
			. 'xmlns="http://checkout.google.com/schema/2" serial-number="' . $serial . '">'
		);
	}

	# SENDS GOOGLE CHARGE REQUEST
	function google_charge($gNum, $amt) {
		return $this->tx_rx_curl(GOOGLE_API2, false, $this->google_charge_xml($gNum, $amt));
	}

	# GOOGLE CHARGE ORDER REQUEST - RETURNS XML
	function google_charge_xml($gNum, $amt) {
		return '
			<?xml version="1.0" encoding="UTF-8"?>
			<charge-order xmlns="http://checkout.google.com/schema/2" google-order-number="' . $gNum . '">
				<amount currency="USD">' . $amt . '</amount>
			</charge-order>
		';
	}

	# GOOGLE CHECKOUT PAYMENT (ORDER) REQUEST - RETURNS XML
	function google_checkout_xml($oNum, $items, $cSession) {
		global $ship_methods, $cartObj;
		$category = $cartObj->get_largest_physical_category($cSession);
		$o = '
			<?xml version="1.0" encoding="UTF-8"?>
			<checkout-shopping-cart xmlns="http://checkout.google.com/schema/2">
				<shopping-cart>
					<merchant-private-data>
						<oNum>' . $oNum . '</oNum>
					</merchant-private-data>
					<items>';
		foreach ($items as $item) {
			$o .= '
						<item>
							<item-name>' . $item['pNum'] . '</item-name>
							<item-description>' . $item['pName'] . '</item-description>
							<unit-price currency="USD">' . $item['pPrice'] . '</unit-price>
							<quantity>' . $item['pQty'] . '</quantity>
						</item>';
		}
		$o .= '
					</items>
				</shopping-cart>
				<checkout-flow-support>
					<merchant-checkout-flow-support>
						<tax-tables>
							<default-tax-table>
								<tax-rules>
									<default-tax-rule>
										<shipping-taxed>false</shipping-taxed>
										<rate>0.0825</rate>
										<tax-area><us-state-area><state>CA</state></us-state-area></tax-area>
									</default-tax-rule>
								</tax-rules>
							</default-tax-table>
						</tax-tables>
						<shipping-methods>';
		foreach ($ship_methods as $method => $sdata) {
			if ($sdata[$category]['price']) {
				$o .= '
							<flat-rate-shipping name="' . $method . '">
								<price currency="USD">' . $sdata[$category]['price'] . '</price>
								<shipping-restrictions>
									<allow-us-po-box>false</allow-us-po-box>
									<allowed-areas>
										<us-country-area country-area="' . $sdata['google_range'] . '"/>
									</allowed-areas>
								</shipping-restrictions>
							</flat-rate-shipping>';
			}
		}
		$o .= '
						</shipping-methods>
					</merchant-checkout-flow-support>
				</checkout-flow-support>
			</checkout-shopping-cart>
		';
		return $o;
	}
}

?>
