<?php

class Order extends Database {

	# AUTO LOADS CC DATA INTO SESSION
	function Order() {
		if ($ccNum = $_POST['ccNum']) {
			if (!strchr($ccNum, 'x')) {
				$ccNum = ereg_replace("[^0-9]", '', $ccNum);
				$_SESSION['ccNum'] = $ccNum;
				$_POST['ccNum'] = $this->obfuscate_num($ccNum, 4);
			}
		}
	}

	# FOR ROUNDTRIP ORDERS, CREATES SHIPMENTS, EMAILS FAILURES - RETURNS TRACKING
	function box_ship($submitted, $oNum, $squareTrade=false, $saturday=false) {
		global $warehouse_info, $upsObj;
		$subject = array();
		list($cust_addr, $method) = $this->get_ship_address($submitted, $squareTrade);
		$submitted['oNum'] = $oNum;
		list($warehouse, $retval) = $this->get_ship_address($warehouse_info, $squareTrade);
		$tracking1 = $upsObj->ship(
			$submitted, $warehouse, $cust_addr,$method, 'weight_empty', 'ship_tracking_id', false, false, false, $saturday, $squareTrade
		);
		$tracking2 = $upsObj->ship(
			$submitted, $cust_addr, $warehouse, $method, 'weight_full', 'ship_tracking_id2', 'IK', false, false, false, $squareTrade
		);
		if ($tracking1) {
			if (is_array($tracking1)) {
				$subject[] = 'UPS ERROR: box ' . $oNum . ': ' . $tracking1[0];
				$this->send_email(ORDERS_FROM, ORDERS_FROM, $subject[sizeof($subject)-1], $tracking1[0]);
				$this->db_update('ds_orders', 'oNum', $oNum, array('cShipInstruct' => $tracking1[0]));
				$tracking1 = false;
			} else {
				$submitted['ship_tracking_id'] = $tracking1;
				$submitted['cStatus'] = STATUS_SHIP_1;
			}
		}
		if ($tracking2) {
			if (is_array($tracking2)) {
				$subject[] = 'UPS ERROR: return ' . $oNum . ': ' . $tracking2[0];
				$this->send_email(ORDERS_FROM, ORDERS_FROM, $subject[sizeof($subject)-1], $tracking2[0]);
				$this->db_update('ds_orders', 'oNum', $oNum, array('cShipInstruct' => $tracking2[0]));
				$tracking2 = false;
			} else {
				$submitted['ship_tracking_id2'] = $tracking2;
			}
		}
		if ($tracking1 && $tracking2) {
			$this->update_status($oNum, STATUS_SHIP_1, $submitted, $squareTrade);
			$this->db_update(
				'ds_orders', 'oNum', $oNum
				, array('ship_tracking_id' => $tracking1, 'ship_tracking_id2' => $tracking2)
			);
		}
		return array($tracking1, $tracking2, implode('<br />', $subject));
	}

	# ONE TIME DISCOUNT CODE CHECKER - RETURNS BOOL
	function check_discount_code($cpCode, $subtotal) {

		# CHECK CODE FORMAT
		if (!$cpCode || strlen($cpCode) != 8 || is_numeric($cpCode)) {
			return 0;
		}

		# CHECK TO ENSURE ONE TIME USAGE
		if ($this->db_select_single('ds_orders', '*', array('cpCode' => $cpCode))) {
			return 0;
		}

		# CHECK IF TELL-A-FRIEND CODE
		if (substr($cpCode, 0, 2) == 'TF') {
			return '25.00';
		}

		# CHECK IF RETURN CUSTOMER CODE
		$oID = substr($cpCode, 0, 6);
		if (!is_numeric($oID)) {
			return 0;
		}
		if ($data = $this->get_data($oID)) {
			if (
				substr($cpCode, 6, 1) == strtoupper(substr($data['cBillLname'], 1, 1))
				&& substr($cpCode, 7, 1) == substr($data['cBillAddress1'], 1, 1)
			) {
				return $subtotal * 0.1;
			}
		}
		return 0;
	}

	# ORDER COMPLETE PROCESS - RETURNS TRACKING
	function closeout($data, $oNum, $squareTrade=false) {
		global $warehouse_info, $upsObj;

		# MAKE ORDER STATUS AND DATE COMPL UPDATES
		$this->db_update(
			'ds_orders', 'oNum', $oNum, array('dateCompleted' => $this->format_date('db_date'))
		);
		$data['dateCompleted'] = $this->format_date('db_date');

		# MAKE UPS SHIPMENT
		list($to, $method) = $this->get_ship_address($data, $squareTrade);
		$ship_data = array_merge($data, array('oNum' => $oNum));
		list($from, $retval) = $this->get_ship_address($warehouse_info, $squareTrade);
		if ($tracking = $upsObj->ship(
				$ship_data, $from, $to, $method, 'weight_full', 'ship_tracking_id3', false, true, true,
				($data['sat_deliv'] == 'Y'), $squareTrade
			)
		) {
			if (is_array($tracking)) {
				return array(false, $tracking);
			} else {
				$data['ship_tracking_id3'] = $tracking;

				# NON SQUARETRADE, PRINT PACKING SLIP
				if (MODE == 'PROD' && !$squareTrade) {
					$this->print_slip($oNum, SLIP_PRINTER, 'packing');
				}
				$this->update_status($oNum, STATUS_SHIP_2, $data, $squareTrade);
				return array(true, $tracking);
			}
		}
	}

	function confirm($submitted, $cSession, $customer) {
		global $cartObj, $custObj, $upsObj, $page_titles;
		$notice = '';

		# HANDLE HI/AK CUSTOMERS SHIPPING METHODS
		if (in_array($submitted['cShipState'], array('HI', 'AK'))) {
			if (stristr($submitted['cShipService'][0], 'self')) {
				$submitted['cShipService'][0] = SHIP_SELF_2DAY;
			} else {
				$submitted['cShipService'][0] = SHIP_ROUND_2DAY;
			}
			$notice = AK_HI_LIMITED_SHIPPING;
		}

		# GO TO CART IF NO CART DATA (PREVENTS CLICKING BACK FROM ORDER COMPLETE)
		if (!$pricing = $cartObj->get_pricing($cSession, $customer['cString'], $submitted)) {
			$this->goToURL(CONTROLLER);
		}
		if (!$data = $cartObj->get_data($cSession, $pricing)) {
			$this->goToURL(CONTROLLER);
		}
		$message = array();

		# ATTEMPT TO IDENTIFY OR CREATE NEW CUSTOMER ACCOUNT
		if ($customer2 = $custObj->find($submitted['cEmail'], $submitted['cPass'], '', $submitted)) {
			$customer = $custObj->get_data($customer2);
			$body = $this->parse_order_confirm($submitted, $data, $pricing, $submitted['terms'], $notice);

		# PASSWORD CONFLICT CUSTOMER - EMAIL FORGOT PASSWORD
		} else {
			$custObj->email_password($submitted['cEmail'], ORDER_NUM_PREFIX);
			$message[] = PASSWORD_CONFLICT;
		}

		# HANDLE ERROR CONDITIONS
		if ($message) {
			echo $this->parse(
				TEMPLATE, array(
					'TITLE' => $page_titles['Account'], 'AREA' => 'Checkout', 'BODY' => $cartObj->show(
						$cSession, $customer2, $submitted, 2, implode('<br /><br />* ', $message)
					)
				)
			);
			exit;
		}

		# IDENTIFY CART FOR FUTURE ABANDONMENT CHECKS
		$customer['cString'] = ($customer['cString']) ? $customer['cString'] : $_COOKIE['customerID'];
		$this->db_update('ds_carts', 'cSession', $cSession, array('cString' => $customer['cString']));

		# OUTPUT ORDER CONFIRMATION
		echo $this->parse(
			TEMPLATE, array(
				'TITLE' => $page_titles['Checkout'], 'AREA' => 'Checkout', 'BODY' => $body
			)
		);
	}

	# CREATES ORDER, SETS NUMBER, LOGS, UPDATES CART - RETURNS BOOL
	function create($cSession, $customer_id, $submitted, $pricing, $transid, $prefix) {
		global $ship_methods;

		# MAKE ORDER RECORD
		if ($oID = $this->insert(
				$cSession, $customer_id, $submitted, $pricing, $transid, $ship_methods[$submitted['cShipService']]['order-status']
			)
		) {
			$oNum = $prefix . $oID;
			$this->insert_log($oNum, 'order_created');

			# SET ORDER NUMBER ON ORDER AND CART ITEM RECORDS
			if ($this->db_update('ds_orders', 'oID', $oID, array('oNum' => $oNum))) {
				$this->db_update('ds_carts', 'cSession', $cSession, array('oNum' => $oNum));
				return $oNum;
			}
		}
		return false;
	}

	# CREATES AND ORDER AND TRANSFERS TO ADMIN DETAIL - DOES NOT SEND EMAIL OR DO BOX PROCESSING
	# USED FOR ADMIN CREATE RMA AND NEW INVOICE PRE-ORDERING STEPS ONLY
	function create_from_cust($data, $cString, $shipping, $prefix, $note='', $rma='') {
		global $cartObj, $custObj;
		$cart_sess = $this->createUniqueKey();
		$updates = '';
		$order = $custObj->get_most_recent_cc($cString);
		if (!$order) {
			$updates = '<p>Unable to find recent CC for this customer, leaving empty.';
		}
		if ($cartObj->insert($cart_sess, 6, 1, '')) {
			$order_data = array(
				'problem'			=> $note
				, 'cShipService'	=> $shipping
				, 'oRMA'			=> $rma
				, 'cEmail'			=> $data['cEmail']
				, 'cPhone'			=> $data['cPhone']
				, 'cFax'			=> $data['cFax']
				, 'cShipFname'		=> $data['cShipFname']
				, 'cShipLname'		=> $data['cShipLname']
				, 'cShipEmail'		=> $data['cShipEmail']
				, 'cShipCompany'	=> $data['cShipCompany']
				, 'cShipAddress1'	=> $data['cShipAddress1']
				, 'cShipAddress2'	=> $data['cShipAddress2']
				, 'cShipCity'		=> $data['cShipCity']
				, 'cShipState'		=> $data['cShipState']
				, 'cShipZip'		=> $data['cShipZip']
				, 'cShipCountry'	=> $data['cShipCountry']
				, 'cBillFname'		=> $data['cBillFname']
				, 'cBillLname'		=> $data['cBillLname']
				, 'cBillCompany'	=> $data['cBillCompany']
				, 'cBillAddress1'	=> $data['cBillAddress1']
				, 'cBillAddress2'	=> $data['cBillAddress2']
				, 'cBillCity'		=> $data['cBillCity']
				, 'cBillState'		=> $data['cBillState']
				, 'cBillZip'		=> $data['cBillZip']
				, 'cBillCountry'	=> $data['cBillCountry']
				, 'ccType'			=> $order['ccType']
				, 'ccName'			=> $order['ccName']
				, 'ccExp'			=> $order['ccExp']
				, 'CVV2'			=> $order['CVV2']
				, 'payment_method'	=> $order['payment_method']
			);
			if ($oNum = $this->create($cart_sess, $cString, $order_data, array(), '', $prefix)) {
				// if ($prefix == REFURB_PREFIX){
					return $oNum;
				// }
				// else {
				// 	$this->error_page('
				// 		<p>' . $updates . '
				// 		<p><font color="black">Redirecting to New Invoice . . .</font>
				// 		<script type="text/javascript">setTimeout("window.location.href=\'' . CONTROLLER . '?m=order_detail&oNum=' . $oNum . '\'", 2000);</script>
				// 	');
				// }
			}
		}
	}

	# CREATES ORDERS FROM ARRAYS, RUNS BOX PROCESSING AND CONFIRMATION EMAIL
	function create_multiple($cString, $data, $cSessions, $prefix, $transID='') {
		global $cartObj, $warehouse_info, $upsObj;
		$cart_data = array();
		$submitted = array();
		$oNums = array();
		$output = '';
		list($warehouse, $retval) = $this->get_ship_address($warehouse_info, ($cString == SQUARETRADE_CUST_ID));
		for ($i = 0; $i < sizeof($data['problem']); $i++) {
			if ($data['problem'][$i]) {
				$order_data = array_merge($data, array(
						'problem' => $data['problem'][$i], 'cpCode' => $data['cpCode'][$i]
						, 'cShipService' => $data['cShipService'][$i], 'cDate' => $this->format_date('db_date')
					)
				);
				if ($pricing = $cartObj->get_pricing($cSessions[$i], $cString, $order_data)) {
					if ($oNum = $this->create($cSessions[$i], $cString, $order_data, $pricing, $transID, $prefix)) {
						$oNums[] = $oNum;
						$cart_data[] = $cartObj->get_data($cSessions[$i], $pricing);
						$submitted[] = array_merge($order_data, $pricing, array('oNum' => $oNum));
						$output .= '<p>Successfully added new order: ' . $oNum;

						# ROUND TRIP
						if (stristr($data['cShipService'][$i], 'round trip')) {
							list ($track1, $track2, $error) = $this->box_ship(
								$order_data, $oNum, ($cString == SQUARETRADE_CUST_ID)
							);
							if (!$track1 || !$track2) {
								$output .= '<p class="error">' . $error;
							}

						# EXPRESS SELF BOX MAILED
						} else if (stristr($data['cShipService'][$i], 'express')) {
							list($from, $method) = $this->get_ship_address(
								array_merge($order_data, $pricing, array('oNum' => $oNum))
								, ($cString == SQUARETRADE_CUST_ID)
							);
							if ($tracking = $upsObj->ship(
									array_merge($order_data, $pricing, array('oNum' => $oNum))
									, $from, $warehouse, $method, 'weight_full'
									, 'ship_tracking_id2', 'IK', false, false, false, ($cString == SQUARETRADE_CUST_ID),false
								)
							) {
								if (!is_array($tracking)) {
									$submitted['ship_tracking_id2'] = $tracking;
									$upsObj->email_label(
										array_merge($order_data, $pricing, array('oNum' => $oNum))
										, $order_data['cShipEmail'], $tracking
									);
								}
							}
						}
					}
				}
			}
		}
		if ($cart_data) {
			$body = $this->receipt($cart_data, $submitted, $oNums, ($cString == SQUARETRADE_CUST_ID), true, true);
		}
		return array($oNums, $body, $output);
	}

	# ORDER DETAIL LOGIC - MY ACCOUNT AREA - RETURNS HTML
	function detail($oNum, $customer, $data, $updates) {
		global $order_statii;
		if (!$history1 = $this->get_history($oNum)) {
			$history = '<tr><td colspan="2">[none]</td></tr>';
		} else {
			$history = '';
			foreach ($history1 as $val) {
				$history .= '
					<tr>
						<td style="font-size: 10pt;" width="150">' . $this->format_date('templ_full', $val['time']) . '</td>
						<td style="font-size: 10pt;" width="*">' . $val['details'] . '</td>
					</tr>
				';
			}
		}
		if (!$notes1 = $this->get_notes($oNum)) {
			$notes = '<tr><td colspan="2">[none]</td></tr>';
		} else {
			$notes = '';
			foreach ($notes1 as $val) {
				$notes .= '
					<tr>
						<td style="font-size: 10pt;" width="150">' . $this->format_date('templ_full', $val['nDate']) . '</td>
						<td style="font-size: 10pt;" width="*">' . $val['nNote'] . '</td>
					</tr>
				';
			}
		}
                $problem = '<tr><td style="font-size: 10pt;">'.$data['problem'].'<td><tr>';
		$payment = '';
		if ($data['cStatus'] == STATUS_PAYMENT) {
			$payment = $this->parse_order(PAYMENT_SERVICE_LINKS, $data);
		}
		return $this->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 1))
			. $updates . $this->parse_order(VIEW_ORDER_ACCT, $data, array(
				'HISTORY' => $history
				, 'NOTES' => $notes
                                , 'PROBLEM' => $problem
				, 'STATUS' => $order_statii[$data['cStatus']]
				, 'PAYMENT' => $payment
				, 'ONUM' => $oNum
			), 'complete'
		);
	}

	# DETERMINES IF ORDER IS PRE-APPROVED - RETURNS BOOL
	function determine_approval($oNum, $data) {
		global $cartObj, $diagnostic_pids;
		$approval = true;
		if ($data['oRMA'] == 'Y' || $data['customer_id'] == SQUARETRADE_CUST_ID) {
			$approval = false;
		} else if ($cart_rows = $cartObj->get_data($oNum)) {
			$cart = $cartObj->parse_cart_template($cart_rows, 'checkin', $data, CART_VIEW_BODY_SMALL);
			foreach ($cart_rows as $item) {
				if (in_array($item['pID'], $diagnostic_pids) && $item['pQty'] > 0) {
					$approval = false;
				} else {
					$approval = true;
					break;
				}
			}
		}
		return $approval;
	}

        function determine_previous($oNum,$serialNumber){
            $previous = false;
            $data = $this->db_select_single('ds_orders','oID', array(), "where oNum != '{$oNum}' and serialNumber = '{$serialNumber}'" );
            if($data['oID']){
                $previous = true;
            }else{
                $previous = false;
            }
            return $previous;
        }

	# CHARGE FAIL EMAIL - ONLY SEND ON FIRST OCCURRENCE
	function email_charge_fail($oNum, $data) {
		global $searchObj;
		$send = true;
		if ($notes = $searchObj->run('notes', $oNum)) {
			$notes = $notes[0];
			foreach ($notes as $nID) {
				if ($note = $this->get_note($nID)) {
					if ($note['nNote'] == CHARGE_FAIL_MSG) {
						$send = false;
						break;
					}
				}
			}
		}
		if ($send) {
			$data['nNote'] = CHARGE_FAIL_MSG;
			$output .= $this->insert_note(
				$oNum, $data, 'Y', $_SESSION['aUser'], ($data['customer_id'] == SQUARETRADE_CUST_ID)
			);
		}
	}

	# SENDS ORDER STATUS SMS WELCOME EMAIL - RETURNS BOOL
	function email_sms($oNum, $data) {
		$data['oNum'] = $oNum;
		return ($this->send_email(
				$data['cEmail']
				, $this->parse_order('__ORDERS_FROM_EMAIL__', $data)
				, $this->parse_order(ORDER_SMS_SUBJECT, $data)
				, $this->parse_order(SMS_WELCOME, $data)
			)
		);
	}

	# SEND MESSAGE(S) FOR ORDER STATUS CHANGE - RETURNS BOOL
	function email_status($oNum, $data, $squareTrade) {
		global $status_change_emails, $status_email_subjects, $admin_status_change_notice, $cartObj, $sqrtObj;
		$data['oNum'] = $oNum;
		$subStatus = '';
		$cart_html = '';

                //don't send emails for refurb orders
                if (substr($oNum, 0,2) == REFURB_PREFIX){
                    return false;
                }

		# HANDLE SQUARETRADE
		if ($squareTrade) {
			if ($sqrtObj->squaretrade_integration($data['cStatus'], $oNum, $data)) {
				return 'Successfully sent SquareTrade integration email.';
			}
			return false;
		}

		# LOCATE POSSIBLE ADMIN ALERTS FOR THE NEW STATUS
		if ($alert_to = $admin_status_change_notice[$data['cStatus'] . $subStatus]) {
			$this->send_email(
				$alert_to, $this->parse_order('__ORDERS_FROM_EMAIL__', $data)
				, $oNum . ' set to ' . strtoupper($data['cStatus']), '', 'text/plain'
			);
		}

		# LOCATE POSSIBLE SMS ALERTS FOR THE NEW STATUS
		$this->sms_status($oNum, $data);

		# GET STATUS EMAIL DATA
		$cart = $cartObj->get_data($oNum);
		$from = $this->parse_order('__ORDERS_FROM_EMAIL__', $data);
		switch ($data['cStatus']) {
			case STATUS_READY:
				$approval = $this->determine_approval($oNum, $data);
				$subStatus = 1;
				if ($approval) {
					$subStatus = 2;
				}
				$cart_item_status_desc = $cartObj->get_item_status_description(STATUS_READY, $cart);
			break;
			case STATUS_SHIP_2:
				list($cart_html, $pids) = $cartObj->parse_cart_template($cart, 'complete', $data);
			break;
			case STATUS_PAYMENT:
				if ($arg = $_SESSION['aEmail']) {
					$from = $arg;
				}
				$subStatus = 1;
				if (in_array($data['payment_method'], array('PayPal', 'Google Checkout'))) {
					$subStatus = 2;
				}
				$data['nStatus'] = 'internal';
				$data['nNote'] = STATUS_PAYMENT;
				$this->insert_note($oNum, $data, 'N', $_SESSION['aUser'], $squareTrade);
		}

		# LOCATE EMAIL TEMPLATE BASED ON STATUS
		if ($template = $status_change_emails[$data['cStatus'] . $subStatus]) {
			$data['oNum'] = $oNum;

			//check if email is disabled and if so suppress email send and return false
			$disabled_emails = $this->disabled_emails($data['oNum']);

			if (is_array($disabled_emails)){
				foreach ($disabled_emails as $disabled){
					if ($disabled == 'ORDER_PROCESS'){
						$email_templ = constant('ORDER_PROCESS1_EMAIL');
						if ($email_templ == $template){
							return false;
						}
						$email_templ = constant('ORDER_PROCESS2_EMAIL');
						if ($email_templ == $template){
							return false;
						}
					}else{
						$email_templ = constant($disabled);
						if ($email_templ == $template){
							return false;
						}
					}
				}
			}

			// return (
			// 		$this->send_email($data['cEmail'], $from
			// 		, $this->parse_order(ORDER_STATUS_SUBJECT . $status_email_subjects[$data['cStatus'] . $subStatus], $data)
			// 		, $this->parse_order($template, $data, array('CART' => $cart_html, 'CART_ITEM_STATUS_DESC' => $cart_item_status_desc))
			// 	)
			// );
		}
		return false;
	}

	# POST ORDER COMPLETE ACTIONS
	function follow($cString, $submitted) {
		global $socialObj, $orderObj;
		if ($arg = $submitted['cHow']) {
			$this->db_update('ds_orders', 'oNum', $submitted['oNum'], array('cHow' => $arg));
		}
		/*
		if ($arg = $submitted['twitter']) {
			if ($arg != 'your twitter account') {
				if ($this->db_update('ds_customers', 'cString', $cString, array('twitter_id' => $arg))) {
					$socialObj->twitter_createFriendship($arg, false);
				}
				echo '<p>Added Twitter<sup>TM</sup> relationship.  Please approve us in your Twitter<sup>TM</sup>.</p>';
			}
		}
		*/
		if ($submitted['sms'] == "true") {
			$data = $this->get_data($submitted['oNum']);
			$this->db_update('ds_orders', 'oNum', $submitted['oNum'], array('cPhoneSms' => 'Y'));
			$this->email_sms($submitted['oNum'], $data);
			echo '<p>Added SMS text message updates to your order.  You will receive an email with further instructions.</p>';
		}
		if ($arg = $submitted['cPass']) {
			if ($arg != 'create a password') {
				$this->db_update('ds_customers', 'cString', $cString, array('cPass' => md5($arg)));
				echo '<p>Successfully changed your account password.</p>';
			}
		}
		if ($submitted['Website'] || $submitted['Checkout'] || $submitted['Comments']) {
			$this->send_email(
				SUPPORT_FROM, SUPPORT_FROM, 'Website Feedback', $this->parse(WEBSITE_FEEDBACK, array(
						'SITE' => $submitted['Website'], 'CART' => $submitted['Checkout'], 'OTHER' => $submitted['Comments']
					)
				), 'text/plain'
			);
			echo '<p>Your feedback has been received.  Thank you.</p>';
		}
		echo '<br />';
	}

	# FIND AND EMAIL THE ADMIN WHO SET THE AWAITING PAYMENT STATUS
	function get_admin_who_set_payment_status($oNum) {
		if ($admin = $this->db_select_single(
				'ds_order_notes n', 'aEmail', array(
					'oNumber' => $oNum, nNote => STATUS_PAYMENT
				), '', array('ds_admins a on n.nUserName = a.aUser')
			)
		) {
			return $admin['aEmail'];
		}
		return false;
	}

	# GETS ALL DATA FOR ORDER - RETURNS ARRAY
	function get_data($oNum, $fields=array('*'), $load_cc=false) { # LOADS CC INTO SESSION
		$data = $this->db_select_single(
			'ds_orders', implode(',', $fields), array()
			, 'where oNum = ' . $this->qualify_value($oNum) . ' or oID = ' . $this->qualify_value($oNum)
		);
		$data['ccNum'] = $this->md5_decrypt($data['ccNum'], CC_SALT);
		if ($load_cc) {
			$_SESSION['ccNum'] = $data['ccNum'];
		}
		$data['ccNum'] = $this->obfuscate_num($data['ccNum'], 4);
		return $data;
	}

	# GETS ORDER INFO FROM GOOGLE ORDER NUMBER - RETURNS ARRAY
	function get_data_google($gNum) {
		return $this->db_select_multiple('ds_orders', '*', array('google_order_num' => $gNum));
	}

	function get_last_order_num($customer_id, $cString) {
		if ($cString) {
			$customer_id = $cString;
		} else if (!$customer_id) {
			return 'MS';
		}
		$row = $this->db_select_single(
			'ds_orders', 'oNum', array('customer_id' => $customer_id), 'order by oID desc limit 1'
		);
		return $row['oNum'];
	}

	# GET ORDER NOTE DATA FROM NOTE ID - RETURNS ARRAY
	function get_note($nID) {
		return $this->db_select_single('ds_order_notes', '*', array('nID' => $nID));
	}

	# GET ORDER NOTE DATA FROM NOTE ID - RETURNS ARRAY
	function get_notes($oNum) {
		return $this->db_select_multiple(
			'ds_order_notes', 'nDate, nNote', array('oNumber' => $oNum, 'nStatus' => 'external')
		);
	}

	# BUILDS SHIPPING ADDRESS ARRAY FROM SUBMIT DATA - RETURNS ARRAY
	function get_ship_address($data, $squareTrade=false) {
		global $ship_methods, $warehouse_info;
		$to = array(
			'phone'			=> ereg_replace("[^0-9]", '', $data['cPhone'])
			, 'address1'	=> $data['cShipAddress1']
			, 'address2'	=> $data['cShipAddress2']
			, 'city'		=> $data['cShipCity']
			, 'state'		=> $data['cShipState']
			, 'zip'			=> $data['cShipZip']
			, 'country'		=> $data['cShipCountry']
			, 'email'		=> $data['cShipEmail']
		);
		$to['name'] = $data['cShipFname'] . ' ' . $data['cShipLname'];
		$data['cShipCompany'] = trim($data['cShipCompany']);
		if ($data['cShipCompany']) {
			$to['company'] = ereg_replace("[^0-9a-zA-Z ]", '', substr($data['cShipCompany'], 0, 35));
		} else {
			$to['company'] = '[Non-Commercial]';
		}
		if ($squareTrade && $data['cShipCompany'] == $warehouse_info['cShipCompany']) {
			$to['company'] = 'SquareTrade Warranty Service';
		}
		$method = array(
			'title'		=> $ship_methods[$data['cShipService']]['ups_name']
			, 'code'	=> $ship_methods[$data['cShipService']]['ups_code']
			, 'name'	=> $data['cShipService']
		);
		return array($to, $method);
	}

	function get_ship_date() {
		if (in_array($this->format_date('day'), array('Sat', 'Sun')) || $this->format_date('hour') > 17) {
			return 'during our next business day';
		}
		return 'today, ' . $this->format_date('templ_date') . ',';
	}

	function get_sms_numbers($data) {
		$send = array();
		if ($data['cPhoneSms'] == 'Y') {
			$send[] = ereg_replace("[^0-9]", '', $data['cPhone']);
		}
		if ($data['cFaxSms'] == 'Y') {
			$send[] = ereg_replace("[^0-9]", '', $data['cFax']);
		}
		return implode('|', $send);
	}

	# GET TRACKING NUMS FOR ORDER - RETURNS TRACKING
	function get_tracking($oNum) {
		if ($row = $this->db_select_single(
				'ds_orders', 'ship_tracking_id, ship_tracking_id2, ship_tracking_id3'
				, array('oNum' => $oNum)
			)
		) {
			$tracking = array();
			if ($row['ship_tracking_id']) {
				$tracking['ship_tracking_id'] = $row['ship_tracking_id'];
			}
			if ($row['ship_tracking_id2']) {
				$tracking['ship_tracking_id2'] = $row['ship_tracking_id2'];
			}
			if ($row['ship_tracking_id3']) {
				$tracking['ship_tracking_id3'] = $row['ship_tracking_id3'];
			}
			if ($tracking) {
				return $tracking;
			}
		}
		return false;
	}

	# GET ORDER LOG HISTORY - RETURNS ARRAY
	function get_history($oNum) {
		return $this->db_select_multiple('ds_order_logs', 'time, details, userName', array('oNum' => $oNum));
	}

	# MAKES ORDER RECORD IN DB
	function insert($cSession, $customer_id, $submitted, $pricing, $transid, $status) {
		$exp = '';
		if ($submitted['ccExpMonth'] && $submitted['ccExpYear']) {
			$submitted['ccExp'] = $this->format_date('db_date', mktime(0, 0, 0, $submitted['ccExpMonth'], 1, $submitted['ccExpYear']));
		}
		if (!$status) {
			$status = STATUS_PENDING;
		}
		$ccNum = '';
		if ($_SESSION['ccNum'] && $submitted['payment_method'] == 'Credit Card') {
			$ccNum = $this->md5_encrypt($_SESSION['ccNum'], CC_SALT);
		}
		if (!$submitted['cShipEmail']) {
			$submitted['cShipEmail'] = $submitted['cEmail'];
		}
		$data = array(
			'cpCode'			=> $submitted['cpCode']
			, 'cBillCompany'	=> $submitted['cBillCompany']
			, 'cBillFname'		=> $submitted['cBillFname']
			, 'cBillLname'		=> $submitted['cBillLname']
			, 'cEmail'			=> $submitted['cEmail']
			, 'cPhone'			=> $submitted['cPhone']
			, 'cFax'			=> $submitted['cFax']
			, 'cBillAddress1'	=> $submitted['cBillAddress1']
			, 'cBillAddress2'	=> $submitted['cBillAddress2']
			, 'cBillCity'		=> $submitted['cBillCity']
			, 'cBillState'		=> $submitted['cBillState']
			, 'cBillZip'		=> $submitted['cBillZip']
			, 'cBillCountry'	=> $submitted['cBillCountry']
			, 'cShipCompany'	=> $submitted['cShipCompany']
			, 'cShipFname'		=> $submitted['cShipFname']
			, 'cShipLname'		=> $submitted['cShipLname']
			, 'cShipAddress1'	=> $submitted['cShipAddress1']
			, 'cShipAddress2'	=> $submitted['cShipAddress2']
			, 'cShipCity'		=> $submitted['cShipCity']
			, 'cShipState'		=> $submitted['cShipState']
			, 'cShipZip'		=> $submitted['cShipZip']
			, 'cShipCountry'	=> $submitted['cShipCountry']
			, 'cShipEmail'		=> $submitted['cShipEmail']
			, 'cHow'			=> $submitted['cHow']
			, 'payment_method'	=> $submitted['payment_method']
			, 'ccType'			=> $submitted['ccType']
			, 'ccName'			=> $submitted['ccName']
			, 'cShipService'	=> $submitted['cShipService']
			, 'CVV2'			=> $submitted['CVV2']
			, 'problem'			=> $submitted['problem']
			, 'approval'		=> $submitted['approval']
			, 'ccExp'			=> $submitted['ccExp']
			, 'cStatus'			=> $status
			, 'customer_id'		=> $customer_id
			, 'cID'				=> $cSession
			, 'cDate'			=> $this->format_date('db_date')
			, 'remote_addr'		=> $_SERVER['REMOTE_ADDR']
			, 'remote_host'		=> $_SERVER['REMOTE_HOST']
			, 'ccNum'			=> $ccNum
			, 'cSubTotal'		=> $pricing['cSubTotal']
			, 'cShipping'		=> $pricing['cShipping']
			, 'cDiscount'		=> $pricing['cDiscount']
			, 'cTax'			=> $pricing['cTax']
			, 'cTotal'			=> $pricing['cTotal']
			, 'gateway_transaction_id' => $transid
			, 'ship_tracking_id2' => $submitted['ship_tracking_id2']
			, 'cShipInstruct'	=> $submitted['cShipInstruct']
			, 'oRMA'			=> $submitted['oRMA']
			, 'cPhoneSms'		=> $submitted['cPhoneSms']
			, 'cFaxSms'			=> $submitted['cFaxSms']
		);
		return $this->db_insert('ds_orders', $data, false);
	}

	# ADD ORDER LOG ENTRY - RETURNS BOOL
	function insert_log($oNum, $type, $detail='') {
		switch ($type) {
			case 'order_status_changed':
				$details = 'Order Status Changed to ' . $detail;
				break;
			case 'order_created':
				$details = 'Order Created' . $detail;
				break;
			case 'order_marked_paid':
				$details = 'Order Marked as Paid' . $detail;
				break;
			case 'order_billing_changed':
				$details = 'Billing Info Changed: ' . $detail;
				break;
			case 'order_shipping_changed':
				$details = 'Shipping Info Changed' . $detail;
				break;
			case 'order_external_note_created':
				$details = 'External Note Created' . $detail;
				break;
			default:
				$details = $detail;
		}
                if($_SESSION['aUser']){
                    $userName = $_SESSION['aUser'];
                }else{
                    $userName = '';
                }
		$data = array(
			'oNum'		=> $oNum
			, 'time'	=> date('Y-m-d H:i:s')
			, 'details'	=> $details
			, 'type'	=> $type
                        , 'userName'    => $userName
		);
		return $this->db_insert('ds_order_logs', $data);
	}

	# ADD ORDER NOTE - RETURNS BOOL
	function insert_note($oNum, $submitted, $sent='N', $user='customer', $squareTrade=false, $physicalDamage=false) {
		global $sqrtObj;
		$submitted = array_merge($submitted, array('oNum' => $oNum));
		$data2 = array(
			'nDate'			=> time()
			, 'nStatus'		=> $submitted['nStatus']
			, 'nNote'		=> $submitted['nNote']
			, 'nSent'		=> $sent
			, 'oNumber'		=> $oNum
			, 'nUserName'	=> $user
		);
		if ($this->db_insert('ds_order_notes', $data2)) {
			if ($sent == 'Y') {
				$this->insert_log($oNum, 'order_external_note_created');

				# SQUARETRADE INTEGRATION - TECH NOTE
				if ($squareTrade) {
					if ($physicalDamage) {
						if ($sqrtObj->squaretrade_integration('TECH-NOTE-ADDED', $oNum, $submitted)) {
							return '<p>Successfully added SquareTrade tech note.';
						}
					}

				# NON SQUARETRADE TECH NOTE
				} else {

					//check if email is disabled and if so suppress email send
					$disabled_emails = $this->disabled_emails($oNum);

					$sendemail = true;

					if (is_array($disabled_emails)){
						foreach ($disabled_emails as $disabled){

							$email_templ = constant($disabled);
							if ($email_templ == $submitted['nNote']){
								$sendemail = false;
							}

						}
					}

					if ($sendemail){
						$parse = array('NOTE' => nl2br($submitted['nNote']), 'WHOM' => ucwords($user));
						if ($this->send_email($submitted['cEmail']
										, $this->parse_order('__ORDERS_FROM_EMAIL__', $submitted)
										, $this->parse_order(ORDER_NOTE_SUBJECT, $submitted)
										, $this->parse_order(ORDER_NOTE_EMAIL, $submitted, $parse)
								)
						) {

								# IF CUSTOMER ADDING THE NOTE, SEND ADMIN COPY
								if ($user == 'customer') {
										$this->send_email(ORDERS_FROM, ORDERS_FROM
												, $this->parse_order(ORDER_NOTE_SUBJECT, $submitted)
												, $this->parse_order(ORDER_NOTE_EMAIL, $submitted, $parse)
										);
								}
								return '<p>Successfully emailed order note to the customer.';
						}
					}
				}
			}
		}
		return false;
	}

	# MARKS ORDER PAID - RETURNS BOOL
	function mark_paid($oNum) {
		if ($this->db_update('ds_orders', 'oNum', $oNum, array('paid' => 'Y'))) {
			$this->insert_log($oNum, 'order_marked_paid');
			return true;
		}
		return false;
	}

	# GETS CREATE MULTIPLE ORDERS ROWS - RETURNS HTML
	function parse_create_mult_orders($cString, $num, $cart_sess, $problem, $coupon, $shipping) {
		global $ship_methods, $cartObj;
		$add_order_rows = '';
		for ($i = 0; $i < $num; $i++) {
			$cart = '';
			if (!$cart_sess || !$key = $cart_sess[$i]) {
				$key = $this->createUniqueKey();
				$cart .= 'Free Diagnostic will be included.';
			}
			$cart .= '<input type="hidden" name="cart_sess[]" value="' . $key . '">'
				. $cartObj->show_admin($key, $i,true,true,true);
			$parse = array(
				'CART_ITEMS'		=> $cart
				, 'PROBLEM'			=> $problem[$i]
				, 'COUPON'			=> $coupon[$i]
				, 'SHIP_METHODS'	=> $this->arrayToHtmlSelectOptions(array_keys($ship_methods), false, $shipping[$i])
                                , 'PROBLEM'             => 'Machine '. ($i+1) .' of '. $num .'. Symptoms to be included with machine.'
			);
			$add_order_rows .= $this->parse(ADD_ORDER_ROW, $parse);
		}
		if ($num > 0) {
			return $this->parse(CREATE_MULT_ON, array('ADD_ORDER_ROW' => $add_order_rows));
		} else {
			return $this->parse(CREATE_MULT_OFF, array('C_STRING' => $cString));
		}
	}

	# PARSES TEMPLATES WITH ORDER DATA - RETURNS HTML
	function parse_order($templ, $input, $additional=array(), $step='') {
		global $ship_methods, $site_data_emails, $cartObj, $machine_translations, $upsObj, $warehouse_info;
		$category = $cartObj->get_largest_physical_category($input['customer_id']);
		if (!is_array($input)) {
			$input = array();
		}

		# FOR MULTI-ORDERS COLLAPSE ARRAYS
		if (is_array($input['cShipService'])) {
			$input['cShipService'] = $input['cShipService'][0];
		}
		if (is_array($input['problem'])) {
			if ($input['problem'][1]) {
				$input['problem'] = $input['problem'][0] . "\n\n[plus additional machines]";
			} else {
				$input['problem'] = $input['problem'][0];
			}
		}
		if (is_array($input['cpCode'])) {
			$input['cpCode'] = $input['cpCode'][0];
		}

		# VARIABLE DATA
		$input['dateCompleted']
			= $this->format_date('templ_date', $input['dateCompleted']);
		$input['dateMachineReceived']
			= $this->format_date('templ_date', $input['dateMachineReceived']);
		$input['cDate']
			= $this->format_date('templ_date', $input['cDate']);
		$input['datePartsExpected']
			= $this->format_date('templ_date', $input['datePartsExpected']);
		$input['machineType'] = $this->str_replace_from_array(
			$input['machineType'], $machine_translations, '[machine unspecified]'
		);
		if (!$input['oNum']) {
			$input['oNum'] = $this->get_last_order_num($input['customer_id'], $input['cString']);
		}
		$site_name_email = $site_data_emails[substr($input['oNum'], 0, 2)]['name'];
		$site_phone_email = $site_data_emails[substr($input['oNum'], 0, 2)]['phone'];
		$shipping_time = $this->parse(
			$ship_methods[$input['cShipService']][$category]['message'], array('SITE_NAME_EMAIL' => $site_name_email)
		);
		if (strstr($shipping_time, '__DAYS__')) {
			$result = $upsObj->transit($warehouse_info, $input, 'weight_full');
			if (!$days = $result[$ship_methods[$input['cShipService']]['ups_code2']]['Days']) {
				$days = '2-6';
			}
			$shipping_time = $this->parse(
				$shipping_time, array('DAYS' => $days)
			);
		} else if (strstr($shipping_time, '__DATE__')) {
			$result = $upsObj->transit($warehouse_info, $input, 'weight_empty');
			if (!$date = $result[$ship_methods[$input['cShipService']]['ups_code2']]['Date']) {
				$date = '2-6 business days';
			} else {
				$date = $this->format_date('misc_3', $date);
			}
			$shipping_time = $this->parse(
				$shipping_time, array('DATE' => $date)
			);
		}
		$payment = $input['ccType'];
		if ($input['payment_method'] == 'Credit Card') {
			$payment .= '<br /><br />Last 4: ' . substr($input['ccNum'], strlen($input['ccNum']) - 4, 4);
		}

		# PARSE LIST
		$parse = array(
			'ONUM'				=> $input['oNum']
			, 'PROBLEM'			=> $input['problem']
			, 'SITE_NAME_EMAIL'	=> $site_name_email
			, 'SITE_PHONE_EMAIL'=> $site_phone_email
			, 'SITE_URL_EMAIL'	=> $site_data_emails[substr($input['oNum'], 0, 2)]['url']
			, 'DESCRIPTION_EMAIL' => $site_data_emails[substr($input['oNum'], 0, 2)]['problem']
			, 'ORDERS_FROM_EMAIL' => $site_data_emails[substr($input['oNum'], 0, 2)]['orders']
			, 'INFO_FROM_EMAIL'	=> $site_data_emails[substr($input['oNum'], 0, 2)]['info']
			, 'NAME'			=> $input['cBillFname'] . ' ' . $input['cBillLname']
			, 'DATE'			=> $input['cDate']
			, 'DATE_C'			=> $input['dateCompleted']
			, 'DATE_R'			=> $input['dateMachineReceived']
			, 'DATE_P'			=> $input['datePartsExpected']
			, 'DATE_L'			=> $this->format_date('templ_date', $input['cDate'], 60)
			, 'TODAY'			=> $this->format_date('templ_date')
			, 'TIME'			=> $this->format_date('templ_time')
			, 'SHIP'			=> $input['cShipService']
			, 'TRACK_1'			=> $input['ship_tracking_id']
			, 'TRACK_2'			=> $input['ship_tracking_id2']
			, 'TRACK_3'			=> $input['ship_tracking_id3']
			, 'SUBTOTAL'		=> number_format($input['cSubTotal'], 2)
			, 'DISCOUNT'		=> number_format($input['cDiscount'], 2)
			, 'TAX'				=> number_format($input['cTax'], 2)
			, 'SHIPPING'		=> number_format($input['cShipping'], 2)
			, 'TOTAL'			=> number_format($input['cTotal'], 2)
			, 'SERIAL'			=> strtoupper($input['serialNumber'])
			, 'ASSET'			=> $input['asset']
			, 'MACH'			=> $input['machineType']
			, 'SPEED'			=> $input['processorSpeed']
			, 'PAYMENT'			=> $input['payment_method']
			, 'SHIP_TO' 		=> '
				' . $input['cShipCompany'] . '
				' . $input['cShipFname'] . ' ' . $input['cShipLname'] . '<br />
				' . $input['cShipAddress1'] . ' ' . $input['cShipAddress2'] . '<br />
				' . $input['cShipCity'] . ', ' . $input['cShipState'] . ' ' . $input['cShipZip']
			, 'BILL_TO' 		=> '
				' . $input['cBillCompany'] . '
				' . $input['cBillFname'] . ' ' . $input['cBillLname'] . '<br />
				' . $input['cBillAddress1'] . ' ' . $input['cBillAddress2'] . '<br />
				' . $input['cBillCity'] . ', ' . $input['cBillState'] . ' ' . $input['cBillZip']
			, 'SHIPPING_TIME'	=> $shipping_time
			, 'SHIPPING_DATA'	=> $input['cShipService'] . '<p>' . $shipping_time
			, 'SHIPPING_INST'	=> $this->parse(
				$ship_methods[$input['cShipService']]['instructions']
				, array('SITE_NAME_EMAIL' => strtoupper($site_name_email), 'ONUM' => $input['oNum'])
			)
			, 'PAYMENT_DATA'	=> $payment
			, 'WAREHOUSE_TIME'	=> $this->get_ship_date()
			, 'ADMIN_NOTES'		=> $input['cShipInstruct']
			, 'SHIP_COMPANY'	=> $input['cShipCompany']
			, 'SHIP_FIRST'		=> $input['cShipFname']
			, 'SHIP_LAST'		=> $input['cShipLname']
			, 'SHIP_ADDRESS1'	=> $input['cShipAddress1']
			, 'SHIP_ADDRESS2'	=> $input['cShipAddress2']
			, 'SHIP_CITY'		=> $input['cShipCity']
			, 'SHIP_ZIP'		=> $input['cShipZip']
			, 'SHIP_STATE'		=> $input['cShipState']
			, 'SHIP_COUNTRY'	=> $input['cShipCountry']
			, 'SHIP_EMAIL'		=> $input['cShipEmail']
			, 'BILL_COMPANY'	=> $input['cBillCompany']
			, 'BILL_FIRST'		=> $input['cBillFname']
			, 'BILL_LAST'		=> $input['cBillLname']
			, 'BILL_ADDRESS1'	=> $input['cBillAddress1']
			, 'BILL_ADDRESS2'	=> $input['cBillAddress2']
			, 'BILL_CITY'		=> $input['cBillCity']
			, 'BILL_ZIP'		=> $input['cBillZip']
			, 'BILL_STATE'		=> $input['cBillState']
			, 'BILL_COUNTRY'	=> $input['cBillCountry']
			, 'EMAIL'			=> $input['cEmail']
			, 'PHONE'			=> $input['cPhone']
			, 'FAX'				=> $input['cFax']
			, 'CC_TYPE'			=> $input['ccType']
			, 'CC_NUMBER'		=> $input['ccNum']
			, 'CC_MONTH'		=> $input['ccExpMonth']
			, 'CC_YEAR'			=> $input['ccExpYear']
			, 'CC_NAME'			=> $input['ccName']
			, 'CC_CVV'			=> $input['CVV2']
			, 'COUPON_CODE'		=> $input['cpCode']
			, 'HOW_HEAR'		=> $input['cHow']
			, 'PASS'			=> $input['cPass']
			, 'C_SESSION'		=> $input['cSession']
		);
		$parse = array_merge($parse, $additional);
		foreach ($parse as $key => $val) {
			$templ = str_replace('__' . $key . '__', $val, $templ);
		}

		# CART AND SUMMARY DATA FOR PACKING SLIP, CHECKIN SLIP, AND STATUS UPDATE
		if (strstr($templ, '__SUMMARY__')) {
			$templ2 = ORDER_SUMMARY;
			if (in_array($step, array('packing', 'checkin', 'diag'))) {
				$templ2 = ORDER_SUMMARY_SMALL;
			}
			$templ = $this->parse($templ, array('SUMMARY' => $this->parse_order_summary($input, $step, $templ2)));
		}
		if (strstr($templ, '__CART__')) {
			$templ2 = CART_VIEW_BODY;
			if (in_array($step, array('packing', 'checkin', 'diag'))) {
				$templ2 = CART_VIEW_BODY_SMALL;
			}
			if ($cart_rows = $cartObj->get_data($input['oNum'])) {
				$cart = $cartObj->parse_cart_template($cart_rows, $step, $input, $templ2);
			} else if ($cart_rows = $cartObj->get_data($input['cSession'])) {
				$cart = $cartObj->parse_cart_template($cart_rows, $step, $input, $templ2);
			} else {
				$cart = array('<div style="border:1px solid #ccc;border-bottom:0;padding:0px 0 0px 0px;font-weight:bold;font-size:10pt;"></div>');
			}
			$templ = $this->parse($templ, array('CART' => $cart[0]));
		}
		return $templ;
	}

	function parse_order_completed($data, $cSession, $cString, $summary) {
		global $page_titles, $cartObj;
		$data = array_merge($cartObj->get_pricing($cSession, $cString, $data), $data);
		return $this->parse(
			TEMPLATE, array(
				'TITLE' => $page_titles['Checkout'], 'AREA' => 'Checkout'
				, 'BODY' => $this->parse_order(ORDER_COMPLETE, $data, array('SUMMARY' => $summary))
			)
		);
	}

	function parse_order_summary($data, $step, $template=ORDER_SUMMARY) {
		if ($step == 'confirm') {
			$template = ORDER_SUMMARY_VERIFY;
		}
		return $this->parse_order($template, $data);
	}

	# PARSES ORDER CONFIRM TEMPLATE - RETURNS HTML
	function parse_order_confirm($data, $cart_data, $pricing, $terms='', $notice='') {
		global $cartObj;
		list($cart_html, $pids) = $cartObj->parse_cart_template($cart_data, 'confirm', $pricing);
		if ($notice) {
			$notice = '<p class="error">' . $notice . '</p>';
		}
		$additional_machines = $this->make_hidden_fields(array('problem' => array_splice($data['problem'], 1)));
		$parse = array(
			'HIDDEN_FIELDS'		=> $this->make_hidden_fields($data, array(), array('problem'))
			, 'TERMS'			=> $terms
			, 'BODY'			=> $this->parse_order_summary($data, 'confirm') . $cart_html . $additional_machines
			, 'FIELDS'			=> $this->make_hidden_fields($data)
			, 'MESSAGE'			=> $notice
		);
		return $this->parse(ORDER_VERIFY, $parse);
	}

	# READS ORDER FORM TEMPLATE - RETURNS HTML
	function parse_order_form($cSession, $customer, $cart_html, $upsell_html, $submitted, $show_panel, $message, $cc_error) {
		global $cartObj, $default_ship_method;
		$category = $cartObj->get_largest_physical_category($cSession);
		$show_login1 = '';
		$show_login2 = 'none';
		if ($customer && $customer['cEmail'] && $customer['cPass']) {
			$show_login1 = '<p><font color="darkgreen"><strong>You are currently logged in as ' . $customer['cEmail'] . '</strong></font>'
				. ' <a href="javascript:document.order.action.value=\'sign_out\';document.order.submit();">log out</a>';
			$submitted['cEmail'] = $customer['cEmail'];
			$submitted['cPass'] = $customer['cPass'];
		} else if ($submitted['email']) {
			$show_login2 = 'block';
		} else {
			$show_login2 = 'block';
		}
		if ($submitted['payment_method'] == '') {
			$submitted['payment_method'] = 'Credit Card';
		}
		$parse = array (
			'SHOW_LOGIN1'	=> $show_login1
			, 'SHOW_LOGIN2'	=> $show_login2
			, 'SHOW_CART'	=> $cart_html
			, 'SHOW_UPSELL'	=> $upsell_html
			, 'SHOW_PANEL'	=> $show_panel
			, 'MESSAGE'		=> $message
			, 'HAS_MESSAGE'	=> isset($message) ? 'true' : 'false'
			, 'CC_MESSAGE'	=> implode('<br />', $cc_error)
		);

		# DEFAULT SHIP SERVICE
		if (!$submitted['cShipService']) {
			$parse['SHIP'] = $default_ship_method[$category];
		}
		$templ = $this->parse(CART_ORDER_FORM, array('FORM_FIELDS' => CART_ORDER_FORM_FIELDS));

		# HANDLE MULTIPLE PROBLEM DESCRIPTIONS
		$i = -1;
		if (is_array($submitted['problem'])) {
			foreach ($submitted['problem'] as $problem) {
				if ($problem) {
					$templ = $this->str_replace_once('__PROBLEM__', $problem, $templ);
					$templ = str_replace('cp' . $i . '" style="display:none;', 'cp' . $i, $templ);
					$i++;
				} else {
					$templ = $this->str_replace_once('__PROBLEM__', '', $templ);
				}
			}
			if ($i > 0) {
				$templ = str_replace('cp0t', 'cp0t" style="display:none;', $templ);
				$templ = str_replace('cp' . $i . 't" style="display:none;', 'cp' . $i . 't', $templ);
			}
		}
		return $this->parse_order($templ, $submitted, $parse);
	}

	# PAYMENT FAILURE RETURNS TO CART - RETURNS HTML
	function parse_payment_fail($cSession, $customer, $submitted, $trans_data) {
		global $page_titles, $cartObj;
		echo $this->parse(
			TEMPLATE, array(
				'TITLE' => $page_titles['Checkout'], 'AREA' => 'Checkout', 'BODY' => $cartObj->show(
					$cSession, $customer, $submitted, 4, '', $trans_data
				)
			)
		);
	}

	# PAYMENT SERVICE COMPLETED PROCESS
	function payment_service_received($oNum, $transID, $data, $redirect=true) {
		$this->db_update(
			'ds_orders', 'oNum', $oNum, array(
				'payment_method' => $data['payment_method'], 'ccType' => $data['ccType']
			)
		);
		$this->mark_paid($oNum);
		$note = 'Payment Service (' . $data['payment_method'] . ') Received: ' . $oNum . ' : ' . $transID;
		$this->insert_note($oNum, array('nNote' => $note));
		$this->closeout($data, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID));
		if ($admin = $this->get_admin_who_set_payment_status($oNum)) {
			$this->send_email(SUPPORT_FROM, ORDERS_FROM, $note, '');
		}
		if ($redirect) {
			$this->goToUrl(CONTROLLER . '?m=account&transID=' . $transID . '&oNum=' . $oNum);
		}
	}

	# SENDS CHECKIN OR PACKING SLIP TO PRINTER - RETURNS BOOL
	function print_slip($oNum, $printer, $type, $viewonly=false) {
		global $cartObj;
		if (!$data = $this->get_data($oNum)) {
			$this->error_page(MISSING_RESULTS);
		}
		switch ($type) {
			case 'packing':
				$to_write = $this->parse_order(PACKING_SLIP, $data, array(), 'packing');
				break;
			case 'checkin':
				$approval = $this->determine_approval($oNum, $data);
                                if ($data['serialNumber'] != ''){
                                    $isprevious = $this->determine_previous($data['oNum'], $data['serialNumber']);
                                }else{
                                    $isprevious = false;
                                }
				$rma = 'checkbox-unchecked.gif';
				$disks = 'checkbox-unchecked.gif';
				$adapter = 'checkbox-unchecked.gif';
				$approved = 'checkbox-unchecked.gif';
				$warranty = 'checkbox-unchecked.gif';
                                $previous = 'checkbox-unchecked.gif';
				if ($data['oRMA'] == 'Y') { $rma = 'checkbox.gif'; }
				if ($data['oACAdapter'] == 'Y') { $adapter = 'checkbox.gif'; }
				if ($data['oOSDisks'] == 'Y') { $disks = 'checkbox.gif'; }
				if ($data['oWarranty'] == 'Y') { $warranty = 'checkbox.gif'; }
				if ($approval) { $approved = 'checkbox.gif'; }
                                if ($isprevious) { $previous = 'checkbox.gif'; }
				$parse = array(
					'RMA_CHECKED'			=> $rma
					, 'ADAPTER_CHECKED'		=> $adapter
					, 'DISKS_CHECKED'		=> $disks
					, 'APPROVE_CHECKED'		=> $approved
					, 'WARRANTY_CHECKED'	=> $warranty
                                        , 'PREVIOUS_CHECKED'            => $previous
				);
				$to_write = $this->parse_order(CHECKIN_SLIP, $data, $parse, 'checkin');
				break;
                        case 'diag':
				$approval = $this->determine_approval($oNum, $data);
                                if ($data['serialNumber'] != ''){
                                    $isprevious = $this->determine_previous($data['oNum'], $data['serialNumber']);
                                }else{
                                    $isprevious = false;
                                }
				$rma = 'checkbox-unchecked.gif';
				$disks = 'checkbox-unchecked.gif';
				$adapter = 'checkbox-unchecked.gif';
				$approved = 'checkbox-unchecked.gif';
				$warranty = 'checkbox-unchecked.gif';
                                $previous = 'checkbox-unchecked.gif';
				if ($data['oRMA'] == 'Y') { $rma = 'checkbox.gif'; }
				if ($data['oACAdapter'] == 'Y') { $adapter = 'checkbox.gif'; }
				if ($data['oOSDisks'] == 'Y') { $disks = 'checkbox.gif'; }
				if ($data['oWarranty'] == 'Y') { $warranty = 'checkbox.gif'; }
				if ($approval) { $approved = 'checkbox.gif'; }
                                if ($isprevious) { $previous = 'checkbox.gif'; }
				$parse = array(
					'RMA_CHECKED'			=> $rma
					, 'ADAPTER_CHECKED'		=> $adapter
					, 'DISKS_CHECKED'		=> $disks
					, 'APPROVE_CHECKED'		=> $approved
					, 'WARRANTY_CHECKED'	=> $warranty
                                        , 'PREVIOUS_CHECKED'            => $previous
				);
				$to_write = $this->parse_order(DIAG_SLIP, $data, $parse, 'diag');
				break;

		}
		if ($viewonly) {
			echo $to_write;
			exit;
		}
		$filenameBase = LABEL_TEMP_DIR . $type . '_' . $oNum;
		if ($this->write_file($filenameBase . '.html', 'w', $to_write)) {
//			system('perl /usr/local/bin/html2ps -r ' . HTML_FOLDER .  ' ' . $filenameBase . '.html > ' . $filenameBase . '.ps', $retval);
			system('perl /usr/bin/html2ps -r ' . HTML_FOLDER .  ' ' . $filenameBase . '.html > ' . $filenameBase . '.ps', $retval);
			if ($this->send_printer($printer, $filenameBase . '.ps')) {
                            unlink($filenameBase.'.html');
                            unlink($filenameBase.'.ps');
                            return true;
			}
		}
                unlink($filenameBase.'.html');
                unlink($filenameBase.'.ps');
		return false;
	}

	# GETS ORDER RECEIPT, SENDS EMAIL - RETURNS HTML
	function receipt($carts, $data, $oNums, $squareTrade, $send_bcc=true, $send=true) {
		global $sqrtObj, $cartObj;
		$body = '';

		# DETERMINE NUMBER OF ORDERS, IF MULTI-ORDER
		$multi_order = false;
		if (sizeof($oNums) > 1) {
			$multi_order = true;
		}

		# LOOP THROUGH ORDER CART SETS
		for ($i = 0; $i < sizeof($carts); $i++) {
			$data[$i]['oNum'] = $oNums[$i];

			# GET SUMMARY AND CART HTML FOR EMAIL BODY
			$summary_html = $this->parse_order_summary($data[$i], 'complete');
			list($cart_html, $pids) = $cartObj->parse_cart_template($carts[$i], 'confirm', $data[$i]);

			# FOR MULTI-ORDERS, PUT ORDER NUMBER BEFORE EACH ORDER LISTING
			if ($multi_order) {
				$body .= '<p>Order: <strong>' . $oNums[$i] . '</strong>';
			}
			$body .= $summary_html . $cart_html;

			# IF ON PRODUCTION AND NOT PREVENTED, SEND BCC EMAIL FOR EACH ORDER INDIVIDUALLY
			if ($send_bcc && (MODE == 'PROD' || $squareTrade)) {
				$this->send_email(
					ORDERS_CONF_BCC
					, $this->parse_order('__ORDERS_FROM_EMAIL__', $data[$i])
					, $this->parse_order(ORDER_CONF_SUBJECT, $data[$i])
					, $this->parse_order(
						ORDER_COMPL_EMAIL, $data[$i], array('ONUM' => $oNums[$i], 'BODY' => $summary_html . $cart_html)
					)
				);
			}
		}

		# SEND IF TOGGLED
		if ($send) {

			# HANDLE SQUARETRADE INTEGRATION
			if ($squareTrade) {
				$i = 0;
				foreach ($carts as $cart) {
					if ($sqrtObj->squaretrade_integration('NEW-ORDER', $oNums[$i], $data[$i])) {
						return '<p>Successfully sent SquareTrade integration email.';
					}
					$i++;
				}

			# NON-SQUARETRADE
			} else {
				$oNum = $oNums[0];
				if ($multi_order) {
					$oNum = $oNums[0]. '-' . $oNums[sizeof($oNums) - 1];
				}
				$this->send_email(
					$data[0]['cEmail']
					, $this->parse_order('__ORDERS_FROM_EMAIL__', $data[0], array('ONUM' => $oNum))
					, $this->parse_order(ORDER_CONF_SUBJECT, $data[0], array('ONUM' => $oNum))
					, $this->parse_order(ORDER_COMPL_EMAIL, $data[0], array('ONUM' => $oNum, 'BODY' => $body))
				);
			}
		}
		return $body;
	}

	# RE-SENDS EMAIL BASED ON TYPE SPECIFIED - RETURNS HTML
	function resend($type, $oNum, $cString, $data, $send_bcc=true) {
		global $cartObj, $custObj, $upsObj;
		$data['oNum'] = $oNum;
		switch($type) {
			case 'Receipt':
				if ($pricing = $cartObj->get_pricing($oNum, $cString, $data)) {
					if ($cart = $cartObj->get_data($oNum, $pricing)) {
						if ($this->receipt(
								array($cart), array($data), array($oNum)
								, ($cString == SQUARETRADE_CUST_ID), $send_bcc, true
							)
						) {
							return '<p>' . EMAIL_SENT;
						}
					}
				}
			break;
			case 'New Customer':
				if ($custObj->email_welcome($data)) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'Password Remind':
				if ($custObj->email_password($data['cEmail'])) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'RMA Ship Label':
				if ($upsObj->email_label($data, $data['cEmail'], $data['ship_tracking_id2'])) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'Status Based':
				if ($this->email_status(
						$oNum, $data, ($cString == SQUARETRADE_CUST_ID)
					)
				) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'Return Label':
				if ($upsObj->email_label($data, $data['cShipEmail'], $data['ship_tracking_id2'])) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'Order Status SMS Instructions':
				if ($this->email_sms($oNum, $data)) {
					return '<p>' . EMAIL_SENT;
				}
			break;
			case 'Order Status SMS Text':
				if ($result = $this->sms_status($oNum, $data)) {
					return '<p>' . EMAIL_SENT;
				}
			break;
		}
	}

	# DETERMINE WHICH PHONE NUMBERS ARE SMS ENABLED - RETURNS STRING
	# SEND ORDER STATUS SMS TEXT
	function sms_status($oNum, $data) {
		global $status_change_sms, $socialObj, $custObj;
		$data['oNum'] = $oNum;

		# DETERMINE IF ORDER STATUS HAS ALERT
		if ($sms = $status_change_sms[$data['cStatus']]) {
			$msg = $this->parse_order($sms, $data);

			# DETERMINE IF ORDER HAS SOCIAL NETWORKING ALERTING
			if ($customer = $custObj->get_data($data['customer_id'])) {
				/*
				if ($arg = $customer['twitter_id']) {
					$socialObj->twitter_direct($arg, $msg);
				}
				*/
			}

			# DETERMINE IF ORDER HAS VALID SMS ALERTING
			if ($send = $this->get_sms_numbers($data)) {
				$this->send_sms_eztexting($send, $msg);
			}
		}
	}

	# SUBMITTING AN ORDER THROUGH CHECKOUT
	function submit($submitted, $cSession, $customer) {
		global $custObj, $cartObj, $pmtObj, $required_order_confirm, $diagnostic_pids, $mailchimpObj;

		# MANAGE EMAIL SUBSCRIPTION REQUEST
		if ($submitted['subscribe'] && $submitted['cEmail']) {
			$custObj->subscribe($submitted['cEmail']);

                        //subscribe user to mailchimp

                        //parse address
                        /*$address = array(
                            'addr1' =>  $submitted['cBillAddress1'],
                            'addr2' =>  $submitted['cBillAddress2'],
                            'city'  =>  $submitted['cBillCity'],
                            'state' =>  $submitted['cBillState'],
                            'zip'   =>  $submitted['cBillZip']
                        );*/

                        //parse phone number for mailchimp expected format (NPA) NXX-LINE to NPA-NXX-LINE
                        $phone = str_replace(array('(',')',' '), array('','','-'), $submitted['cPhone']);

                        $merg_vars = array(
                            'FNAME'     =>  $submitted['cBillFname'],
                            'LNAME'     =>  $submitted['cBillLname'],
                            'PHONE'     =>  $phone,
                            'COMPANY'   =>  $submitted['cBillCompany'],
                            'CITY'      =>  $submitted['cBillCity'],
                            'STATE'     =>  $submitted['cBillState'],
                            'ZIP'       =>  $submitted['cBillZip']
                        );

                        //add to mailchimp general list
                        $mailchimpObj->subscribe_general_list($submitted['cEmail'],$merg_vars);
		}

		# PHP FIELD TWEAKS AND VALIDATION
		if ($submitted['payment_method'] == '') {
			$submitted['payment_method'] = $submitted['ccType'];
		}
		if (!$submitted['cShipEmail']) {
			$submitted['cShipEmail'] = $submitted['cEmail'];
		}
		$submitted['ccName'] = $submitted['cBillFname'] . ' ' . $submitted['cBillLname'];
		if ($fields = $this->validate($submitted, $required_order_confirm)) {
			$this->error_page(str_replace('__FIELDS__', implode('<br />* ', $fields), VALIDATION_ERROR), 2);
		} else {

			# GO TO CART IF NO CUST/CART DATA (ALSO PREVENTS CLICKING BACK FROM ORDER COMPLETE)
			if (!$customer) {
				$this->goToURL(CONTROLLER);
			}
			if (!$pricing = $cartObj->get_pricing($cSession, $customer['cString'], $submitted)) {
				$this->goToURL(CONTROLLER);
			}

			# PROCESS PAYMENT, REDIRECT BACK UPON FAIL
			$trans_data = '';
			if ($submitted['payment_method'] == 'Credit Card') {
				list($trans_bool, $trans_data) = $pmtObj->payflowpro_service($submitted, $submitted['ccName']);
				if (!$trans_bool) {
					$this->parse_payment_fail($cSession, $customer, $submitted, $trans_data);
					exit;
				}
			}

			# FOR MULTI-ORDERS CREATE ARRAY OF ORDER SESSIONS
			$cSessions = array($cSession);
			$i = 0;
			foreach ($submitted['problem'] as $problem) {
				if ($problem) {
					$cSession = $this->createUniqueKey();
					array_push($cSessions, $cSession);
					$cartObj->insert($cSession, $diagnostic_pids[0], 1);
					$i++;
				}
			}

			# ADD "X OF Y" ONTO PROBLEM DESCRIPTION OF MULTI-ORDERS
			if ($i > 1) {
				for ($j = 0; $j < sizeof($submitted['problem']); $j++) {
					if ($submitted['problem'][$j]) {
						$k = $j + 1;
						$submitted['problem'][$j] = "Machine $k of $i\n" . $submitted['problem'][$j];
						$submitted['cpCode'][$j] = $submitted['cpCode'][0];
						$submitted['cShipService'][$j] = $submitted['cShipService'][0];
					}
				}
			}

			# CREATE ORDER, SET NUMBER, LOGS, UPDATES CART, EMAILS CONFIRMATION
			list($oNums, $body, $output) = $this->create_multiple(
				$customer['cString'], $submitted, $cSessions, ORDER_NUM_PREFIX, $trans_data
			);

			# SEND SMS SUBSCRIPTION INSTRUCTIONS
			if ($submitted['cPhoneSms'] || $submitted['cFaxSms']) {
				$this->email_sms($oNums[0], $submitted);
			}
			return array($oNums, $body);
		}
	}

	# COMPARES POST DATA TO INPUT ARRAY, HANDLES SPECIAL FIELDS, UPDATES DATABASE - RETURNS ARRAY
	function update($oNum, $messages, $data, $acceptable_fields, $submitted, $authorize=false) {
		global $orders_field_titles, $date_fields, $pmtObj, $credit_card_fields, $cc_types;
		if ($submitted['ccExp']) {
			$submitted['ccExpMonth'] = substr($submitted['ccExp'], 0, 2);
			$submitted['ccExpYear'] = substr($submitted['ccExp'], 2, 2);
			$submitted['ccExp'] = $this->format_date(
				'db_date', substr($submitted['ccExp'], 0, 2) . '/01/' . substr($submitted['ccExp'], 2, 2)
			);
		} else {
			$submitted['ccExp'] = '0000-00-00';
		}

		# DETERMINE WHICH ORDER FIELDS HAVE BEEN UPDATED
		$changed_fields = $this->determine_which_updated($data, $submitted, $acceptable_fields);

                //Create zoho invoice if criteria match
                if (in_array('cStatus',$changed_fields) && ($submitted['cStatus'] == 'Walk-in Complete' || $submitted['cStatus'] == 'Walk-in Complete') && ($submitted['payment_method'] == 'Purchase Order')){
                    $this->create_zoho_invoice($oNum);
                }

		# AUTHORIZE CARD CHANGES
		if ($authorize) {
			list($trans_bool, $trans_data) = $pmtObj->payflowpro_service($submitted, $oNum);
			if (!$trans_bool) {
				$messages .= '<p class="error">Error saving Payment Information: ' . implode('<br />', $trans_data) . '</p>';
			}
		}

		# UPDATE CHANGED FIELDS IN THE DATABASE AND IN RAM
		$newdata = array();
		foreach ($changed_fields as $changed_field) {

			# ONLY SAVE CC FIELDS IF AUTHORIZED, OR SET TO NOT AUTHORIZE
			if (in_array($changed_field, array_keys($credit_card_fields))) {
				if (!$authorize || $trans_bool) {

					# SPECIAL ENCRYPT FOR CC NUM
					if ($changed_field == 'ccNum') {
						$this->insert_log($oNum, 'order_billing_changed', 'CC Number');
						$newdata['ccNum'] = $this->md5_encrypt($_SESSION['ccNum'], CC_SALT);

						# SET PAY METHOD AND CC TYPE AUTOMATICALLY
						$newdata['payment_method'] = 'Credit Card';
						$data['payment_method'] = 'Credit Card';
						$newdata['ccType'] = $cc_types[substr($_SESSION['ccNum'], 0, 1)];
						$data['ccType'] = $newdata['ccType'];

					# OTHER CC FIELDS
					} else {
						$this->insert_log($oNum, 'order_billing_changed', $changed_field);
						$newdata[$changed_field] = $submitted[$changed_field];
					}
					$data[$changed_field] = $submitted[$changed_field];
				}
				continue;

			# SPECIAL HANDLING FOR DATES
			} else if (in_array($changed_field, $date_fields) && trim($submitted[$changed_field]) != '') {
				$newdata[$changed_field] = $this->format_date('db_date', $submitted[$changed_field]);
				$data[$changed_field] = $newdata[$changed_field];

				# DATE PARTS EXPECTED AUTOMATION
				if ($changed_field == 'datePartsExpected') {
					$messages .= '<p>Successfully changed order status to ' . STATUS_WAITING . ' and sent status change email.';
					$this->update_status(
						$oNum, STATUS_WAITING, array_merge($data, $submitted), ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					$submitted['cStatus'] = STATUS_WAITING;
					$data['cStatus'] = STATUS_WAITING;
					$newdata['cStatus'] = STATUS_WAITING;
				}

			# ALL OTHER NON CC AND DATE FIELDS
			} else {

				# LOG PAID, STATUS, BILL AND SHIP CHANGES
				if ($changed_field == 'paid' && $submitted['paid'] == 'Y') {
					$this->insert_log($oNum, 'order_marked_paid');
				} else if ($changed_field == 'cShipService') {
					$this->insert_log($oNum, 'order_shipping_changed');
				} else if ($changed_field == 'cStatus') {
					$this->insert_log($oNum, 'order_status_changed', $submitted['cStatus']);

					# STATUS CHANGE TO COMPLETE SHIPPED - MAKE FINAL SHIPMENT, DATE COMPL
					if ($submitted['cStatus'] == STATUS_SHIP_2) {
						list($close_bool, $close_data) = $this->closeout(
							$submitted, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID)
						);
						if (!$close_bool) {
							$messages .= '<p class="error">' . implode('<br />', $close_data);
						} else {
							$messages .= '<p>Successfully created tracking, sent status email, set date completed.';
							$data['ship_tracking_id3'] = $close_data;
							$data['dateCompleted'] = $this->format_date('db_date');
						}

					# STATUS CHANGE TO COMPLETE - SET DATE COMPL
					} else if ($submitted['cStatus'] == STATUS_COMPLETE) {
						$messages .= '<p>Successfully set date completed.';
						$newdata['dateCompleted'] = $this->format_date('db_date');
						$data['dateCompleted'] = $newdata['dateCompleted'];
						$submitted['dateCompleted'] = $newdata['dateCompleted'];

					# OTHER STATUS CHANGE
					} else {

						# STATUS CHANGE TO LBR - SET DATE EXPECTED
						if ($submitted['cStatus'] == STATUS_APPROVED2) {
							$messages .= '<p>Successfully set LBR date expected.';
							$newdata['datePartsExpected'] = $this->format_date('db_date', false, 6);
							$data['datePartsExpected'] = $newdata['datePartsExpected'];
							$submitted['datePartsExpected'] = $newdata['datePartsExpected'];
						}

						if ($this->email_status($oNum, $submitted, ($data['customer_id'] == SQUARETRADE_CUST_ID))) {
							$messages .= '<p>Successfully sent order status change email.';
						}
					}
				}

				# SAVE CHANGE IN RAM
				$newdata[$changed_field] = $submitted[$changed_field];
				$data[$changed_field] = $submitted[$changed_field];
			}
		}

		# SAVE CHANGES TO DATABASE
		if ($newdata) {
			if ($this->db_update('ds_orders', 'oNum', $oNum, $newdata)) {
				$messages .= '<p><font size="2"><strong>Successfully saved order changes.</strong></font>';
			}
		}
		return array($data, $messages);
	}

	# CHANGES ORDER STATUS
	function update_status($oNum, $new, $data=array(), $squareTrade=false) {
		$this->db_update('ds_orders', 'oNum', $oNum, array('cStatus' => $new));
		$data['cStatus'] = $new;
		if (MODE == 'PROD'){
			$this->email_status($oNum, $data, $squareTrade);
		}
		$this->insert_log($oNum, 'order_status_changed', $new);
	}

	function bulk_update_status($oNumArray, $new, $note='') {
		$serialNums = array();
		for($i = 0; $i < count($oNumArray); $i++) { // Get input numbers that are serial rather than SP numbers
			if (strlen(trim($oNumArray[$i])) > 8) {
				array_push($serialNums, $oNumArray[$i]);
				array_splice($oNumArray, $i, 1);
				$i--;
			}
		}
		$inONumStr = $this->build_in_clause($oNumArray);
		$inSerialStr = $this->build_in_clause($serialNums);
		$setStr = "cStatus = '$new'";
		if ($note != '') {
			$setStr .= ", cShipInstruct = concat(cShipInstruct, '\n".mysql_real_escape_string($note)."')";
		}
		$subSelect = "SELECT oNum FROM ds_orders WHERE serialNumber IN $inSerialStr";
		if (count($serialNums) > 0) {
			$query = "UPDATE ds_orders SET $setStr WHERE oNum IN $inONumStr OR oNum IN ($subSelect);";
		}
		else {
			$query = "UPDATE ds_orders SET $setStr WHERE oNum IN $inONumStr;";
		}
		$this->db_query($query, 'update', true);
		$this->bulk_insert_order_status_changed_log($oNumArray, 'order_status_changed', $new);
	}


	function bulk_insert_order_status_changed_log($oNumArray, $status) {
		$query = "INSERT INTO ds_order_logs(oNum, time, details, type, userName) VALUES";
		foreach ($oNumArray as $oNum => $val) {
			$data = array(
				'oNum' => trim($oNum),
				'time' => $this->format_date('db_full'),
				'details' => "Order Status changed to $status",
				'type' => 'order_status_changed',
				'userName' => $_SESSION['aUser']
			);
			if (strlen(trim($oNum)) > 0) {
				$query .= ' ("'.$data['oNum'].'", "'.$data['time'].'", "'.$data['details'].'", "'.$data['type'].'", "'.$data['userName'].'"),';
			}
		}
		$query = substr($query, 0, -1);
		$query .= ';';
		$this->db_query($query, 'insert', true);
	}

	# VALIDATION AGAINST REQUIRED FIELDS - RETURNS ARRAY IF ERRORS
	function validate($data, $required) {
		global $credit_card_fields;
		$invalid = array();

		# COMBINE REQUIRED FIELD ARRAYS
		if ($data['payment_method'] == 'Credit Card') {
			$required = array_merge($required, $credit_card_fields);
		}

		# VALIDATE
		$required_fields = array_keys($required);
		foreach ($required as $field => $title) {
			if ($data[$field] == '' && in_array($field, $required_fields)) {
				$invalid[] = $title;
			}
		}
		if (sizeof($invalid)) {
			return $invalid;
		}
		return false;
	}

        function cancel_applecare_reminder($serialNumber){
            $this->db_update('ds_orders', 'serialNumber', $serialNumber, array('warrantyStatus' => 'Apple Limited Warranty - No Reminder'));
            header('Location: '.SITE_URL.'applecare_unsubscribe.html');
        }

        //get array of disabled emails for order/customer
        private function disabled_emails($oNum){

            //get disabled arrays from order and customer tables
            $ds_orders = $this->db_select_single('ds_orders', 'customer_id, disabled_emails',array('oNum' => $oNum));

            $order_disabled = unserialize($ds_orders['disabled_emails']);

            $ds_customers = $this->db_select_single('ds_customers', 'disabled_emails',array('cString' => $ds_orders['customer_id']));

            $customer_disabled = unserialize($ds_customers['disabled_emails']);

            //return results
            if (is_array($order_disabled) && is_array($customer_disabled)){
                return array_merge($order_disabled,$customer_disabled);
            }  elseif (is_array($order_disabled)) {
                return $order_disabled;
            }  elseif (is_array($customer_disabled)) {
                return $customer_disabled;
            }else{
                return false;
            }
        }

        public function queue_print($job_id, $printer, $type, $user){

            $data = array(
                'job_id'        =>  $job_id
                ,'printer'      =>  $printer
                ,'print_type'   =>  $type
                ,'aUser'        =>  $user
            );

            return $this->db_insert('print_queue',$data);

        }

        public function create_zoho_invoice($oNum){

            global $zohoinvoiceObj, $cartObj;

            $order = $this->get_data($oNum);

            $zohoinvoice_contact_id = $zohoinvoiceObj->check_existing_contact($order['cEmail']);

            if(!$zohoinvoice_contact_id){

                $account = new stdClass();
                $account->account_name              = $order['cBillFname'].' '.$order['cBillLname'];
                $account->school_district_name      = '';
                $account->title                     = '';
                $account->fname                     = $order['cBillFname'];
                $account->lname                     = $order['cBillLname'];
                $account->email                     = $order['cEmail'];
                $account->phone                     = $order['cPhone'];
                $account->address                   = $order['cBillAddress1'].' '.$order['cBillAddress2'];
                $account->city                      = $order['cBillCity'];
                $account->state                     = $order['cBillState'];
                $account->zip                       = $order['cBillZip'];
                $account->fax                       = $order['cFax'];
                $account->ship_street               = $order['cShipAddress1'].' '.$order['cShipAddress2'];
                $account->ship_city                 = $order['cShipCity'];
                $account->ship_state                = $order['cShipState'];
                $account->ship_code                 = $order['cShipZip'];
                $zohoinvoice_contact_id = $zohoinvoiceObj->insert_contact($account);
            }

            $zohoinvoice_primary_contact = $zohoinvoiceObj->get_primary_contact_id($zohoinvoice_contact_id);

            $cart = $cartObj->get_data($oNum);

            foreach ($cart as $row){

                $item = new stdClass();
                $item->id     = $row['pID'];
                $item->code     = $row['pNum'];
                $item->name     = $row['pName'];
                $item->unit_price     = $row['pPrice'];
                $item->quantity     = $row['pQty'];
                $item->total     = $row['pPrice']*$row['pQty'];
                $item->discount     = 0;
                $item->list_price     = $row['pPrice'];
                $item->net_total     = $row['pPrice']*$row['pQty'];
                $item->tax     = 0;
                $invoice_products[] = $item;
            }

            $zohoinvoice_line_items = $zohoinvoiceObj->get_product_string($invoice_products);

            $invoice_detail = new stdClass();
            $invoice_detail->invoice_number = $order['oNum'];
            $invoice_detail->ship_date = $order['cShipDate'];
            $invoice_detail->discount = $order['cDiscount'];
            $invoice_detail->invoice_owner = '';
            $invoice_detail->purchase_order = $order['poNumber'];
            $invoice_detail->adjustment = '';

            $zohoinvoiceObj->insert_invoice($zohoinvoice_contact_id,$zohoinvoice_primary_contact,$invoice_detail,$zohoinvoice_line_items);

        }
}

?>
