<?php

class Mailchimp extends MCAPI{
    
    var $general_subscriber_list_id = 'dd0124601e';
    
    /**
     * Adds a subscriber to the general subscriber list
     * 
     * @param string $email the email address of the subscriber to be added
     * @param array $merge_vars user info fields, see MCAPI listSubscribe for full details
     * @return boolean 
     */
    function subscribe_general_list($email,$merge_vars){
        
        $listId = $this->general_subscriber_list_id;
        
        return $this->listSubscribe($listId, $email, $merge_vars,'html', false);
        
    }
    
    /**
     * Updates a subscriber in the general subscriber list
     * 
     * @param string $email the email address of the subscriber to be updated
     * @param array $merge_vars user info for fields to be updated
     * @param string $email_type change the email type preference for the member ("html", "text", or "mobile").  Leave blank to keep the existing preference (optional)
     * @return boolean 
     */
    function update_general_list($email,$merge_vars,$email_type=''){
        
        $listId = $this->general_subscriber_list_id;
        
        return $this->listUpdateMember($listId, $email,$merge_vars,$email_type);
        
    }
    
    /*
     * Unsubscribe a member of the general subscriber list
     * 
     * @param string $email the emailaddress of the subscriber to be unsubscribed
     * @return boolean
     */
    function unsubscribe_general_list($email){
        
        $listId = $this->general_subscriber_list_id;
        
        return $this->listUnsubscribe($listId, $email);
        
    }
}
?>