<?php

class GSX {

    var $soapClient;
    var $userSessionId;
    var $coverageEndDate;
    var $coverageEndDateStamp;

    # BEGIN GSX SOAP/WSDL SESSION

    function start_session() {
        try{
            $this->soapClient = new SoapClient(GSX_WSDL_NEW, array('trace' => 1));
            $this->soapClient->Authenticate(
                    array(
                        'AuthenticateRequest' => array(
                            'userId' => GSX_USER,
                            'password' => GSX_PASS,
                            'languageCode' => 'EN',
                            'userTimeZone' => 'PDT',
                            'serviceAccountNo' => GSX_ACCOUNT
                        )
                    )
            );
            $result = $this->soapClient->__getLastResponse();
            $this->userSessionId = $this->get_soap_xml_value($result, 'userSessionId');
        }catch (Exception $e){
            return false;
        }
        return true;
    }

    # CONVERT WARRANTY END TIME TO TIMESTAMP

    function get_warranty_end_timestamp() {
        if (!$this->coverageEndDateStamp) {
            if ($this->coverageEndDate) {
                $this->coverageEndDateStamp = strtotime($this->coverageEndDate);

                # NO WARRANTY END DATE AVAILABLE (NOT IN WARRANTY), SO FAKE IT TO BEING MONTH AGO
            } else {
                $this->coverageEndDateStamp = time() - 86400 * 30;
            }
        }
        return $this->coverageEndDateStamp;
    }

    # GET WARRANTY END DATE FROM SERIAL NUMBER

    function check_warranty_status($serialNumber) {
        $serialNumber = strtoupper($serialNumber);
        if ($this->start_session()){
            try {
                $this->soapClient->WarrantyStatus(
                        array(
                            'WarrantyStatusRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                                ), 'unitDetail' => array(
                                    'serialNumber' => $serialNumber
                                )
                            )
                        )
                );
            } catch (Exception $e) {
                return false;
            }
            $result = $this->soapClient->__getLastResponse();
            $this->coverageEndDate = $this->get_soap_xml_value($result, 'coverageEndDate');
            $this->end_session();
            return true;
        }else{
            return false;
        }
    }

    # GET WARRANTY STATUS FROM SERIAL NUMBER

    function get_warranty_status($serialNumber) {
        $serialNumber = strtoupper($serialNumber);
        if ($this->start_session()){
            $rs = array();
            try {
                $this->soapClient->WarrantyStatus(
                        array(
                            'WarrantyStatusRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                                ), 'unitDetail' => array(
                                    'serialNumber' => $serialNumber
                                )
                            )
                        )
                );
            } catch (Exception $e) {
                $rs['error'] = "We're sorry, but this serial number is not valid. Please check your information and try again.";
            }
            $result = $this->soapClient->__getLastResponse();
            $rs['serialNumber'] = $this->get_soap_xml_value($result, 'serialNumber');
            $rs['warrantyStatus'] = $this->get_soap_xml_value($result, 'warrantyStatus');
            $rs['coverageEndDate'] = $this->get_soap_xml_value($result, 'coverageEndDate');
            $rs['coverageStartDate'] = $this->get_soap_xml_value($result, 'coverageStartDate');
            $rs['daysRemaining'] = $this->get_soap_xml_value($result, 'daysRemaining');
            $rs['estimatedPurchaseDate'] = $this->get_soap_xml_value($result, 'estimatedPurchaseDate');
            $rs['globalWarranty'] = $this->get_soap_xml_value($result, 'globalWarranty');
            $rs['onsiteStartDate'] = $this->get_soap_xml_value($result, 'onsiteStartDate');
            $rs['onsiteEndDate'] = $this->get_soap_xml_value($result, 'onsiteEndDate');
            $rs['purchaseCountry'] = $this->get_soap_xml_value($result, 'purchaseCountry');
            $rs['registrationDate'] = $this->get_soap_xml_value($result, 'registrationDate');
            $rs['imageURL'] = $this->get_soap_xml_value($result, 'imageURL');
            $rs['explodedViewURL'] = $this->get_soap_xml_value($result, 'explodedViewURL');
            $rs['manualURL'] = $this->get_soap_xml_value($result, 'manualURL');
            $rs['productDescription'] = $this->get_soap_xml_value($result, 'productDescription');
            $rs['configDescription'] = $this->get_soap_xml_value($result, 'configDescription');
            $rs['slaGroupDescription'] = $this->get_soap_xml_value($result, 'slaGroupDescription');
            $rs['powerTrainFlag'] = $this->get_soap_xml_value($result, 'powerTrainFlag');
            $rs['triCareFlag'] = $this->get_soap_xml_value($result, 'triCareFlag');
            $rs['ecorathFlag'] = $this->get_soap_xml_value($result, 'ecorathFlag');
            $rs['contractCoverageEndDate'] = $this->get_soap_xml_value($result, 'contractCoverageEndDate');
            $rs['contractCoverageStartDate'] = $this->get_soap_xml_value($result, 'contractCoverageStartDate');
            $rs['contractType'] = $this->get_soap_xml_value($result, 'contractType');
            $rs['laborCovered'] = $this->get_soap_xml_value($result, 'laborCovered');
            $rs['limitedWarranty'] = $this->get_soap_xml_value($result, 'limitedWarranty');
            $rs['partCovered'] = $this->get_soap_xml_value($result, 'partCovered');
            $rs['warrantyReferenceNo'] = $this->get_soap_xml_value($result, 'warrantyReferenceNo');
            $rs['csCode'] = $this->get_soap_xml_value($result, 'csCode');
            $rs['csType'] = $this->get_soap_xml_value($result, 'csType');
            $rs['C which means CUSTOMER'] = $this->get_soap_xml_value($result, 'C which means CUSTOMER');
            $rs['S which means SYSTEM'] = $this->get_soap_xml_value($result, 'S which means SYSTEM');
            $rs['String'] = $this->get_soap_xml_value($result, 'String');
            $rs['csNote'] = $this->get_soap_xml_value($result, 'csNote');
            $rs['notes'] = $this->get_soap_xml_value($result, 'notes');
            $rs['isPersonalized'] = $this->get_soap_xml_value($result, 'isPersonalized');
            $rs['parts'] = $this->get_soap_xml_value($result, 'parts');

            $this->end_session();
            return $rs;
        }else{
            return false;
        }
    }
    
    function mass_serial_lookup($serialNumbers) {
        if ($this->start_session()){
            $return = array();
            foreach ($serialNumbers as $row){
                $row = strtoupper($row);
                $rs = array();
                try {
                    $this->soapClient->WarrantyStatus(
                            array(
                                'WarrantyStatusRequest' => array(
                                    'userSession' => array(
                                        'userSessionId' => $this->userSessionId
                                    ), 'unitDetail' => array(
                                        'serialNumber' => $row
                                    )
                                )
                            )
                    );
                } catch (Exception $e) {
                    $rs['error'] = "We're sorry, but this serial number is not valid. Please check your information and try again.";
                }
                $result = $this->soapClient->__getLastResponse();
                $rs['serialNumber'] = $this->get_soap_xml_value($result, 'serialNumber');
                $rs['warrantyStatus'] = $this->get_soap_xml_value($result, 'warrantyStatus');
                $rs['coverageEndDate'] = $this->get_soap_xml_value($result, 'coverageEndDate');
                $rs['coverageStartDate'] = $this->get_soap_xml_value($result, 'coverageStartDate');
                $rs['daysRemaining'] = $this->get_soap_xml_value($result, 'daysRemaining');
                $rs['productDescription'] = $this->get_soap_xml_value($result, 'productDescription');
                $rs['configDescription'] = $this->get_soap_xml_value($result, 'configDescription');
                
                $return[] = $rs;
            }

            $this->end_session();
            return $return;
        }else{
            return false;
        }
    }

    /**
     * get_comptia_codes
     * 
     * Returns Comp TIA and Modifier codes
     * 
     * @return array
     * 
     * Returns a multi-dimensional array of comp TIA and modifier codes
     * 
     */
    function get_comptia_codes() {
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->CompTIACodes(
                        array(
                            'ComptiaCodeLookupRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                                )
                            )
                        )
                );
            } catch (Exception $e) {
                $this->end_session();
                return $e;
            }

            $result = $this->soapClient->__getLastResponse();
            
            // Remove the XML namespace opening tags
            $result = str_replace('<S:', '<', $result);
            // Remove the XML namespace closing tags
            $result = str_replace('</S:', '</', $result);
            // Remove the XML namespace opening tags
            $result = str_replace('<ns3:', '<', $result);
            // Remove the XML namespace closing tags
            $result = str_replace('</ns3:', '</', $result);
            // For good measure, remove anything that has to do with XML namespace 
            //$result = str_replace('xmlns:ns2', 'nonsense', $result);
            
            
            $comptia = simplexml_load_string($result);
            
            $comptiaInfo = $comptia->Body->ComptiaCodeLookupResponse->ComptiaCodeLookupResponse->comptiaInfo;
            
            //parse the soap xml into a structure
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);
            
            //initialize array count
            $i = 0;
            //set modifiers to false
            $modifiers = false;
            //step through array
            foreach ($vals as $val) {
                //if not modifiers write TIA codes
                if ($modifiers == false) {
                    if ($val['tag'] == 'COMPTIACODE') {
                        $res_tia[$i]['code'] = $val['value'];
                    }
                    if ($val['tag'] == 'COMPTIADESCRIPTION') {
                        $res_tia[$i]['description'] = $val['value'];
                        //increment array count
                        $i++;
                    }
                    //set modifiers to true
                    if ($val['tag'] == 'COMPTIAMODIFIER') {
                        $modifiers = true;
                        //reset array count
                        $i = 0;
                    }
                } else {
                    //write modifiers
                    if ($val['tag'] == 'MODIFIERCODE') {
                        $res_mod[$i]['mod_code'] = $val['value'];
                        //increment array count
                        $i++;
                    }
                    if ($val['tag'] == 'COMPTIADESCRIPTION') {
                        $res_mod[$i]['mod_description'] = $val['value'];
                    }
                }
            }
            //write TIA and Modifier arrays to result
            $res['tia'] = $res_tia;
            $res['mod'] = $res_mod;
            $res['tiagroups'] = $comptiaInfo->comptiaGroup;

            $this->end_session();

            return $res;
        }else{
            return false;
        }
    }
    
    /**
     * get_parts
     * 
     * Returns parts for supplied serial number
     * 
     * @param array $serialNumber
     * 
     * @return array
     * 
     * Returns a multi-dimensional array of part numbers and values
     * 
     */
    function get_parts($serialNumber='',$productName=''){
        if($this->start_session()){
            $res = array();
            try {
                if ($productName == ''){
                    $serialNumber = strtoupper($serialNumber);
                    $this->soapClient->PartsLookup(
                        array(
                            'PartsLookupRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                            ),
                            'lookupRequestData' => array(
                           'serialNumber' => $serialNumber)
                        )));
                }else{
                    $this->soapClient->PartsLookup(
                        array(
                            'PartsLookupRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                            ),
                            'lookupRequestData' => array(
                           'productName' => $productName)
                        )));
                }
            } catch (Exception $e) {
                $this->end_session();
                return false;
            }
            $result = $this->soapClient->__getLastResponse();

            //parse the soap xml into a structure
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);

            //initialize array count
            $i = 0;
            //step through array
            foreach ($vals as $val) {
                if ($val['tag'] == 'PARTDESCRIPTION') {
                    $res[$i]['partDescription'] = $val['value'];
                }
                if ($val['tag'] == 'EEECODE') {
                    $res[$i]['eeeCode'] = $val['value'];
                }
                if ($val['tag'] == 'EXCHANGEPRICE') {
                    $res[$i]['exchangePrice'] = $val['value'];
                }
                if ($val['tag'] == 'LABORTIER') {
                    $res[$i]['laborTier'] = $val['value'];
                }
                if ($val['tag'] == 'PARTNUMBER') {
                    $res[$i]['partNumber'] = $val['value'];
                }
                if ($val['tag'] == 'PARTTYPE') {
                    $res[$i]['partType'] = $val['value'];
                }
                if ($val['tag'] == 'STOCKPRICE') {
                    $res[$i]['stockPrice'] = $val['value'];
                }
                if ($val['tag'] == 'COMPONENTCODE') {
                    $res[$i]['componentCode'] = $val['value'];
                }
                if ($val['tag'] == 'ORIGINALPARTNUMBER') {
                    $res[$i]['originalPartNumber'] = $val['value'];
                }
                if ($val['tag'] == 'COMMODITYTYPE') {
                    $res[$i]['commodityType'] = $val['value'];
                }
                if ($val['tag'] == 'ISSERIALIZED') {
                    $res[$i]['isSerialized'] = $val['value'];
                    //increment array count
                    $i++;
                }
            }

            $this->end_session();

            return $res;
        }else{
            return false;
        }
        
    }
    
    /**
     * get_parts
     * 
     * Returns details for supplied part number
     * 
     * @param array $partNumber
     * 
     * @return array
     * 
     * Returns a multi-dimensional array of part number and details
     * 
     */
    function get_part_details($partNumber){
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->PartsLookup(
                    array(
                        'PartsLookupRequest' => array(
                            'userSession' => array(
                                'userSessionId' => $this->userSessionId
                        ),
                        'lookupRequestData' => array(
                       'partNumber' => $partNumber)
                    )));
            } catch (Exception $e) {
                $this->end_session();
                return $e;
            }
            $result = $this->soapClient->__getLastResponse();

            //parse the soap xml into a structure
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);

            //initialize array count
            $i = 0;
            //step through array
            foreach ($vals as $val) {
                if ($val['tag'] == 'PARTDESCRIPTION') {
                    $res[$i]['partDescription'] = $val['value'];
                }
                if ($val['tag'] == 'EEECODE') {
                    $res[$i]['eeeCode'] = $val['value'];
                }
                if ($val['tag'] == 'EXCHANGEPRICE') {
                    $res[$i]['exchangePrice'] = $val['value'];
                }
                if ($val['tag'] == 'LABORTIER') {
                    $res[$i]['laborTier'] = $val['value'];
                }
                if ($val['tag'] == 'PARTNUMBER') {
                    $res[$i]['partNumber'] = $val['value'];
                }
                if ($val['tag'] == 'PARTTYPE') {
                    $res[$i]['partType'] = $val['value'];
                }
                if ($val['tag'] == 'STOCKPRICE') {
                    $res[$i]['stockPrice'] = $val['value'];
                }
                if ($val['tag'] == 'COMPONENTCODE') {
                    $res[$i]['componentCode'] = $val['value'];
                }
                if ($val['tag'] == 'ISSERIALIZED') {
                    $res[$i]['isSerialized'] = $val['value'];
                    //increment array count
                    $i++;
                }
            }

            $this->end_session();

            return $res;
        }else{
            return false;
        }
        
    }

    /**
     * 
     * Creates a carry in request for repairs to a device
     * 
     * $repairData(
     *      customerAddress=>array(),
     *      orderLines=>array(),
     *      serialNumber=>string,
     *      poNumber=>string,
     *      symptom=>string,
     *      diagnosis=string,
     *      notes=string,
     *      shipTo=>string,
     *      requestReviewByApple=>string,
     *      unitReceievedDate=>string,
     *      unitReceivedTime=>string),
     *      popFaxed=>string,
     *      diagnosedByTechId=>string
     * 
     * customerAddress(
     *      companyName=>string,
     *      firstName=>string,
     *      lastName=>string,
     *      addressLine1=>string,
     *      street=>string,
     *      city=>string,
     *      state=>string,
     *      zipCode=>string,
     *      emailAddress=>string,
     *      primaryPhone=>string,
     *      country=>string,
     *      regionCode=>string)
     * 
     * orderLines(
     *      partNumber=>string,
     *      comptiaCode=>string,
     *      comptiaModifier=>string,
     *      abused=>string,
     *      diagnosticCode=>string)
     * 
     * @param array $repairData Array as specified above
     * 
     * @return array
     * 
     * This function returns an array of carry in repair confirmation including an array of each part number
     */
    function create_carry_in_request($repairData) {
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->CreateCarryInRepair(
                        array(
                            'CreateCarryInRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                                ),
                                'repairData' => $repairData
                            )
                        )
                );
            } catch (Exception $e) {
                $this->end_session();
                return $e;
            }
            $result = $this->soapClient->__getLastResponse();

            //temporary hard coded response
            /*$result = '<S:Envelope xmlns:S="http://schemas.xmlsoap.org/soap/envelope/">
               <S:Body>
                  <ns4:CreateCarryInResponse xmlns:ns4="http://gsxws.apple.com/types/core/asp">
                     <CreateCarryInResponse>
                        <operationId>teHHI9DcQcLsTBtI7+jdLqmOFqFrRaMZ</operationId>
                        <repairConfirmation>
                           <confirmationNumber>G112477331</confirmationNumber>
                           <diagnosticDescription>Diagnostic Code Not Entered</diagnosticDescription>
                           <diagnosticEventNumber>800204262010153816</diagnosticEventNumber>
                           <diagnosticEventEndResult>FAILED</diagnosticEventEndResult>
                           <parts>
                              <availability/>
                              <currency>USD</currency>
                              <netPrice>USD 23.50</netPrice>
                              <partNumber>661-7654</partNumber>
                              <partType/>
                              <quantity>1</quantity>
                           </parts>
                           <parts>
                              <availability/>
                              <currency>USD</currency>
                              <netPrice>USD 11.50</netPrice>
                              <partNumber>661-7655</partNumber>
                              <partType/>
                              <quantity>1</quantity>
                           </parts>
                           <totalFromOrder>USD 38.00</totalFromOrder>
                           <vatTax>USD 3.00</vatTax>
                        </repairConfirmation>
                     </CreateCarryInResponse>
                  </ns4:CreateCarryInResponse>
               </S:Body>
            </S:Envelope>';*/

            //parse the soap xml into a structure
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);

            //initialize array count for parts
            $i = 0;
            //step through array
            foreach ($vals as $val) {
                //Get values for carry in request
                if ($val['tag'] == 'CONFIRMATIONNUMBER') {
                    $res['confirmationNumber'] = $val['value'];
                }
                if ($val['tag'] == 'DIAGNOSTICDESCRIPTION') {
                    $res['diagnosticDescription'] = $val['value'];
                }
                if ($val['tag'] == 'DIAGNOSTICEVENTNUMBER') {
                    $res['diagnosticEventNumber'] = $val['value'];
                }
                if ($val['tag'] == 'DIAGNOSTICEVENTENDRESULT') {
                    $res['diagnosticEventEndResult'] = $val['value'];
                }
                if ($val['tag'] == 'TOTALFROMORDER') {
                    $res['totalFromOrder'] = $val['value'];
                }
                if ($val['tag'] == 'VATTAX') {
                    $res['vatTax'] = $val['value'];
                }
                //Get array of parts lines
                if ($val['tag'] == 'AVAILABILITY') {
                    $res_parts[$i]['availability'] = $val['value'];
                }
                if ($val['tag'] == 'CURRENCY') {
                    $res_parts[$i]['currency'] = $val['value'];
                }
                if ($val['tag'] == 'NETPRICE') {
                    $res_parts[$i]['netPrice'] = $val['value'];
                }
                if ($val['tag'] == 'PARTNUMBER') {
                    $res_parts[$i]['partNumber'] = $val['value'];
                }
                if ($val['tag'] == 'PARTTYPE') {
                    $res_parts[$i]['partType'] = $val['value'];
                }
                if ($val['tag'] == 'QUANTITY') {
                    $res_parts[$i]['quantity'] = $val['value'];
                    //increment array count
                    $i++;
                }
            }

            //add parts array to result
            $res['parts'] = $res_parts;

            $this->end_session();

            return $res;
        }else{
            return false;
        }
    }
    
    /**
     * 
     * Creates a stocking order
     * 
     * $orderData(
     *      otderLines=>array(),
     *      purchaseOrderNumber=>string,
     *      shipToCode=>string,
     * 
     * orderLines(
     *      partNumber=>string,
     *      quantity=>string,
     * 
     * @param array $orderData Array as specified above
     * 
     * @return array
     * 
     * This function returns an array of stocking order confirmation including an array of each part number
     */
    function create_stocking_order($orderData){
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->CreateStockingOrder(
                        array(
                            'CreateStockingOrderRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                                ),
                                'orderData' => $orderData
                            )
                        )
                );
            } catch (Exception $e) {
                $this->end_session();
                return $e;
            }
            $result = $this->soapClient->__getLastResponse();

            //temporary hard coded response
            /*$result = '<S:Envelope xmlns:S="http://schemas.xmlsoap.org/soap/envelope/">
               <S:Body>
                  <ns4:CreateStockingOrderResponse xmlns:ns2="http://asp.core.endpoint.ws.gsx.ist.apple.com/" xmlns:ns3="http://gsxws.apple.com/elements/global" xmlns:ns4="http://gsxws.apple.com/elements/core/asp" xmlns:ns5="http://gsxws.apple.com/elements/core/asp/am" xmlns:ns6="http://gsxws.apple.com/elements/core">
                     <CreateStockingOrderResponse>
                        <operationId>bcd0a1309887359096</operationId>
                        <orderConfirmation>
                           <confirmationNumber>100944352</confirmationNumber>
                           <currency>USD</currency>
                           <subTotal>USD 905.95</subTotal>
                           <tax>USD 0.00</tax>
                           <total>USD 905.95</total>
                           <orderParts>
                              <partNumber>ACSH07</partNumber>
                              <netPrice>USD 6.95</netPrice>
                              <currency>USD</currency>
                              <availability/>
                              <quantity>1</quantity>
                           </orderParts>
                           <orderParts>
                              <partNumber>661-5097</partNumber>
                              <partType>MOD</partType>
                              <netPrice>USD 899.00</netPrice>
                              <currency>USD</currency>
                              <availability/>
                              <quantity>1</quantity>
                           </orderParts>
                        </orderConfirmation>
                        <communicationMessage/>
                     </CreateStockingOrderResponse>
                  </ns4:CreateStockingOrderResponse>
               </S:Body>
            </S:Envelope>';*/

            //parse the soap xml into a structure
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);

            //initialize array count for parts
            $i = 0;
            //step through array
            foreach ($vals as $val) {
                //Get values for carry in request
                if ($val['tag'] == 'CONFIRMATIONNUMBER') {
                    $res['confirmationNumber'] = $val['value'];
                }
                if ($val['tag'] == 'CURRENCY') {
                    $res['currency'] = $val['value'];
                }
                if ($val['tag'] == 'SUBTOTAL') {
                    $res['subTotal'] = $val['value'];
                }
                if ($val['tag'] == 'TAX') {
                    $res['tax'] = $val['value'];
                }
                if ($val['tag'] == 'TOTAL') {
                    $res['total'] = $val['value'];
                }
                //Get array of parts lines
                if ($val['tag'] == 'PARTNUMBER') {
                    $res_parts[$i]['partNumber'] = $val['value'];
                }
                if ($val['tag'] == 'PARTTYPE') {
                    $res_parts[$i]['partType'] = $val['value'];
                }
                if ($val['tag'] == 'NETPRICE') {
                    $res_parts[$i]['netPrice'] = $val['value'];
                }
                if ($val['tag'] == 'CURRENCY') {
                    $res_parts[$i]['currency'] = $val['value'];
                }
                if ($val['tag'] == 'AVAILABILITY') {
                    $res_parts[$i]['availability'] = $val['value'];
                }
                if ($val['tag'] == 'QUANTITY') {
                    $res_parts[$i]['quantity'] = $val['value'];
                    //increment array count
                    $i++;
                }
            }

            //add parts array to result
            $res['parts'] = $res_parts;

            $this->end_session();

            return $res;
        }else{
            return false;
        }
        
    }
    
    function get_product_model($serialNumber){
        $serialNumber = strtoupper($serialNumber);
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->FetchProductModel(
                        array(
                            'FetchProductModelRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                            ),
                            'productModelRequest' => array(
                           'serialNumber' => $serialNumber)
                        )));
            } catch (Exception $e) {
                $this->end_session();
                return false;
            }
            $result = $this->soapClient->__getLastResponse();
            
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);
            
            foreach ($vals as $val) {
                //Get values for carry in request
                if ($val['tag'] == 'PRODUCTLINE') {
                    $res['productLine'] = $val['value'];
                }
                if ($val['tag'] == 'CONFIGDESCRIPTION') {
                    $res['configDescription'] = $val['value'];
                }
                if ($val['tag'] == 'CONFIGCODE') {
                    $res['configCode'] = $val['value'];
                }
            }
            
            return $res;
        }else{
            return false;
        }
    }
    
    function repair_lookup($params){
        if($this->start_session()){
            $res = array();
            try {
                $this->soapClient->RepairLookup(
                        array(
                            'RepairLookupRequest' => array(
                                'userSession' => array(
                                    'userSessionId' => $this->userSessionId
                            ),
                            'lookupRequestData' => $params
                        )));
            } catch (Exception $e) {
                $this->end_session();
                return $e;
            }
             $result = $this->soapClient->__getLastResponse();
            
            $parser = xml_parser_create();
            xml_parse_into_struct($parser, $result, $vals);
            
            // Remove the XML namespace opening tags
            $result = str_replace('<S:', '<', $result);
            // Remove the XML namespace closing tags
            $result = str_replace('</S:', '</', $result);
            // Remove the XML namespace opening tags
            $result = str_replace('<ns4:', '<', $result);
            // Remove the XML namespace closing tags
            $result = str_replace('</ns4:', '</', $result);
            // For good measure, remove anything that has to do with XML namespace 
            //$result = str_replace('xmlns:ns2', 'nonsense', $result);
            
            $retxml= @simplexml_load_string($result);
            
            return $retxml;
            
            foreach ($vals as $val) {
                //Get values for carry in request
                if ($val['tag'] == 'PRODUCTLINE') {
                    $res['productLine'] = $val['value'];
                }
                if ($val['tag'] == 'CONFIGDESCRIPTION') {
                    $res['configDescription'] = $val['value'];
                }
                if ($val['tag'] == 'CONFIGCODE') {
                    $res['configCode'] = $val['value'];
                }
            }
            
            return $res;
        }else{
            return false;
        }
    }

    # END GSX SOAP/WSDL SESSION

    function end_session() {
        $this->soapClient->Logout(
                array(
                    'LogoutRequest' => array(
                        'userSession' => array(
                            'userSessionId' => $this->userSessionId
                        )
                    )
                )
        );
        return true;
    }

    # PARSES SOAP XML FOR VALUES

    function get_soap_xml_value($data, $tag) {
        if ($start = strpos($data, "<$tag>")) {
            if ($end = strpos($data, "</$tag>")) {
                $start += strlen("<$tag>");
                return substr($data, $start, $end - $start);
            }
        }
        return false;
    }

}

?>