<?php

class Groundcontrol {
    
    var $api_key;
    var $base_url = 'https://www.groundctl.com/api/v1/';
    
    public function __construct($api_key) {
        $this->api_key = $api_key;
    }
    
    public function devicesFindAll(){
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'devices/find/all?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }
    
    public function devicesFindBy($criteria){
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'devices/findBy/'.key($criteria).'/'.current($criteria).'?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }
    
    public function devicesGetBy($criteria){
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'devices/getBy/'.key($criteria).'/'.current($criteria).'?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }
    
    public function launchpadsFindAll(){
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'launchpads/find/all?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }
    
    public function launchpadsFind($uniqueid){
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'launchpads/find/uniqueId/'.$uniqueid.'?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }
    
    public function launchpadUpdate($uniqueID,$fields){
    
        $headers = array(
            'Content-Type: application/json',
            'Accept: text/html'
        );
        
        $data = json_encode($fields);
        
        $url = $this->base_url.'launchpads/update/uniqueId/'.$uniqueID.'?api_key='.$this->api_key;
        
        return $this->sendPostCurlRequest($data, $headers, $url);
        
    }
    
    public function policiesEvaluateForDevice($udid) {
        
        $headers = array('Accept: application/json');
        
        $url = $this->base_url.'evaluateForDevice/'.$udid.'?api_key='.$this->api_key;
        
        $result = $this->sendGetCurlRequest($url, $headers);
        
        return (array)json_decode($result);
        
    }

    //private function to send curl GET request to groundcontrol
    private function sendGetCurlRequest($url,$headers) {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            return $result;
        } catch (Exception $exception) {
            echo 'Exception Message: ' . $exception->getMessage() . '<br/>';
            echo 'Exception Trace: ' . $exception->getTraceAsString();
        }
    }
    
    private function sendPostCurlRequest($data,$headers,$url) {
        try {
            $ch = curl_init($url);

            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POST, true);


            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);
           
            curl_close($ch);
            
            return $response;
            
        } catch (Exception $exception) {
            echo 'Exception Message: ' . $exception->getMessage() . '<br/>';
            echo 'Exception Trace: ' . $exception->getTraceAsString();
        }
    }
    
}
