<?php

class GoogleContacts {
    
    var $Zend_Loader;
    var $Zend_Gdata_ClientLogin;
    
    function start_session(){
        
        require_once 'Zend/Loader.php';
        
        $this->Zend_Loader = new Zend_Loader();
        
        $this->Zend_Loader->loadClass('Zend_Gdata');
        $this->Zend_Loader->loadClass('Zend_Gdata_ClientLogin');
        $this->Zend_Loader->loadClass('Zend_Http_Client');
        $this->Zend_Loader->loadClass('Zend_Gdata_Query');
        $this->Zend_Loader->loadClass('Zend_Gdata_Feed');
        
        $this->Zend_Gdata_ClientLogin = new Zend_Gdata_ClientLogin();
        
        $client = $this->Zend_Gdata_ClientLogin->getHttpClient(GOOGLE_CONTACTS_USER, GOOGLE_CONTACTS_PASS, 'cp');
        
        return $client;
    }
    
    function addContact($data){
        
        require_once 'Zend/Loader.php';
        
        try{
        
            $client = $this->start_session();

            $gdata = new Zend_Gdata($client);
            $gdata->setMajorProtocolVersion(3);

            // create new entry
            $doc  = new DOMDocument();
            $doc->formatOutput = true;
            $entry = $doc->createElement('atom:entry');
            $entry->setAttributeNS('http://www.w3.org/2000/xmlns/' ,
             'xmlns:atom', 'http://www.w3.org/2005/Atom');
            $entry->setAttributeNS('http://www.w3.org/2000/xmlns/' ,
             'xmlns:gd', 'http://schemas.google.com/g/2005');
            $doc->appendChild($entry);

            // add name element
            $name = $doc->createElement('gd:name');
            $entry->appendChild($name);
            $fullName = $doc->createElement('gd:fullName', $data['firstname'].' '.$data['lastname']);
            $name->appendChild($fullName);
            $givenName = $doc->createElement('gd:givenName', $data['firstname']);
            $name->appendChild($givenName);
            $familyName = $doc->createElement('gd:familyName', $data['lastname']);
            $name->appendChild($familyName);


            // add email element
            $email = $doc->createElement('gd:email');
            $email->setAttribute('address' ,$data['email']);
            $email->setAttribute('rel' ,'http://schemas.google.com/g/2005#home');
            $entry->appendChild($email);

            // add phone element
            $phoneNumber = $doc->createElement('gd:phoneNumber',$data['phone']);
            $phoneNumber->setAttribute('rel' ,'http://schemas.google.com/g/2005#home');
            $entry->appendChild($phoneNumber);

            // insert entry
            $entryResult = $gdata->insertEntry($doc->saveXML(), 
             'http://www.google.com/m8/feeds/contacts/default/full');
            return $entryResult->id;
        }  catch (Exception $e){
            return false;
        }

    }
    
    function deleteContact($contactid,$client){
        
        require_once 'Zend/Loader.php';
        
        try{
        
            //$client = $this->start_session();
            //$client->setHeaders('If-Match: *');

            $gdata = new Zend_Gdata($client);
            $gdata->setMajorProtocolVersion(3);
            
            $entry = $gdata->getEntry($contactid);

            // delete entry
            $gdata->delete($entry);
            
            return true;
           
        }  catch (Exception $e){
            return false;
        }

    }
}
?>
