<?php

class Framework {

	# CONVERT SINGLE- AND MULTI- DIMMENSIONAL ARRAY TO SELECT OPTIONS - OUTPUTS HTML
	function arrayToHtmlSelectOptions($data, $start_blank=false, $default=false, $exclude=array(), $title='Please Select') {
		if ($start_blank) {
			$output = "\n" . '<option value="">' . $title . '</option>';
		} else {
			$output = '';
		}
		foreach ($data as $row) {

			# INDEXED / ASSOCIATIVE
			if (is_array($row)) {
				if (in_array($row[0], $exclude)) {
					continue;
				}
				$output .= "\n" . '<option value="' . $row[0] . '"';
				if ($default && $row[0] == $default) {
					$output .= ' selected="selected"';
				}
				$output .= '>' . $row[1] . '</option>';

			# NON INDEXED
			} else {
				if (in_array($row, $exclude)) {
					continue;
				}
				$output .= "\n" . '<option value="' . $row . '"';
				if ($default && $row == $default) {
					$output .= ' selected="selected"';
				}
				$output .= '>' . $row . '</option>';
			}
		}
		return $output;
	}

	# ARRAY TO QUERYSTRING - RETURNS STRING
	function array_to_querystring($data) {
		$output = '';
		$i = 0;
		foreach ($data as $key => $val) {
			if ($i) {
				$output .= '&';
			}
			$output .= $key . '=' . urlencode($val);
			$i++;
		}
		return $output;
	}

	# ARRAY TO XML STRING - RETURNS XML
	function array_to_xml($name, $data, $tab="\t") {
		$o = "$tab<$name>\n";
		foreach ($data as $key => $val) {
			if (is_array($val)) {
				$o .= $this->array_to_xml($key, $val, $tab . "\t");
			} else if (!is_numeric($key)) {
				$o .= "$tab\t<$key>$val</$key>\n";
			}
		}
		return $o . "$tab</$name>\n";
	}

	# HTML TO PLAIN TEXT
	function convert_html_to_plain($content) {
		if ($pos = strpos($content, '<title>')) {
			$pos2 = strpos($content, '</title>');
			$content = substr($content, 0, $pos) . substr($content, $pos2);
		}
		if ($pos = strpos($content, '<style')) {
			$pos2 = strpos($content, '</style>');
			$content = substr($content, 0, $pos) . substr($content, $pos2);
		}
		$content = html_entity_decode(strip_tags($content));
		$content = explode("\n", $content);
		$content2 = array();
		foreach ($content as $line) {
			$content2[] = trim($line);
		}
		$content = implode("\n", $content2);
		while (strstr($content, "\n\n")) {
			$content = str_replace("\n\n", "\n", $content);
		}
		return $content;
	}

	# CREATE MD5 KEY - FOR DS COMPATIBILITY
	function createUniqueKey() {
		return md5(uniqid(rand(), true));
	}

	# DETERMINES WHICH FIELDS IN ARRAY HAVE BEEN UPDATED - RETURNS ARRAY
	function determine_which_updated($first, $second, $include_list, $exclude_list=array()) {
		global $date_fields;
		$output = array();
		foreach ($first as $key => $val) {
			if (!is_numeric($key)) {
				if (in_array($key, $include_list) && !in_array($key, $exclude_list)) {
					if (in_array($key, $date_fields)) {
						if ($this->format_date('templ_date', $val) != $second[$key] && $second[$key]) {
							$output[] = $key;
						}
					} else if ($val . ' ' != $second[$key] . ' ') {
						$output[] = $key;
					}
				}
			}
		}
		return $output;
	}

	# ERROR PAGE
	function error_page($message, $back=1, $color='orangered') {
		$o = '<br /><h3><font color="' . $color . '"><strong>' . $message . '</strong></font></h3>' . "\n";
		if ($back) {
			$o .= '<p><a href="javascript:history.go(-' . $back . ');">Return to Previous Step</a></p>' . "\n";
		}
		echo str_replace('__AREA__', 'Checkout', str_replace('__BODY__', $o, TEMPLATE));
		/*if (MODE == 'PROD' && strstr($o, '::')) {
			$this->send_email(ERROR_LOG_EMAIL, ERROR_LOG_EMAIL, 'PROD Error Page', $o);
		}*/


                ob_start();
                debug_print_backtrace();
                file_put_contents(LABEL_TEMP_DIR.'error.log', $this->format_date('db_full').ob_get_clean(),FILE_APPEND);


		exit;
	}

	# MISC TEMPLATE FUNCTIONS
	function format_date($format, $timestamp=false, $offset=false) {
		switch ($format) {
			case 'templ_date': $format = 'm/d/Y'; break;
			case 'templ_full': $format = 'm/d/Y g:ia'; break;
			case 'templ_time': $format = 'g:ia'; break;
			case 'db_date': $format = 'Y-m-d'; break;
			case 'db_full': $format = 'Y-m-d H:i:s'; break;
			case 'regular': $format = 'r'; break;
			case 'day': $format = 'D'; break;
			case 'hour': $format = 'H'; break;
                        case 'minute' : $format = 'i'; break;
			case 'cc_exp': $format = 'my'; break;
			case 'cc_month': $format = 'm'; break;
			case 'cc_year': $format = 'y'; break;
			case 'ups': $format = 'Ymd'; break;
			case 'atom': $format = DATE_ATOM; break;
			case 'misc_1': $format = 'Y-m-d-H-i-s'; break;
			case 'misc_2': $format = 'YmdGis'; break;
			case 'misc_3': $format = 'D m/d/Y'; break;
			case 'misc_4': $format = 'l m/d/Y'; break;
                        case 'short': $format = 'm.d.y'; break;
			default: $this->error_page('Invalid DATE format requested: ' . $format);
		}
		if (is_numeric($offset)) {
			$timestamp = time() + 86400 * $offset;
		}
		if ($timestamp === false) {
			$timestamp = time();
		} else if (!$timestamp) {
			return '';
		}
		if (!is_numeric($timestamp)) {
			$timestamp = strtotime($timestamp);
		}

		# HANDLE SERVER TIME ZONE WHEN MINUTES COUNT
		if (MODE == 'PROD' && strchr($format, 'i')) {
			$timestamp -= 60 * 60 * 2;
		}
		return date($format, $timestamp);
	}

	# RETURNS IMAGE FILE TO BROWSER
	function get_image($img, $type) {
		if ($img && file_exists($img)) {
			header('Content-Type: ', $type);
			header('Content-Disposition: attachment; filename="' . basename($img) . '"');
			@readfile($img);
		}
	}

	# GET DATE OF PREVIOUS WORKING DAY
	function get_prev_working_date() {
		$offset = 86400;
		if ($this->format_date('day', false, $offset) == 'Sun') {
			$offset *= 3;
		} else if ($this->format_date('day', false, $offset) == 'Sat') {
			$offset *= 2;
		}
		return $this->format_date('db_date', false, $offset);
	}

	# RANDOMIZER
	function get_rnd_iv($iv_len) {
		$iv = '';
		while ($iv_len-- > 0) {
			$iv .= chr(mt_rand() & 0xff);
		}
		return $iv;
	}

	# SIMPLE REDIRECT - EXITS
	function goToURL($url) {
		header('Location: ' . $url);
		exit;
	}

	# DETECTS IF BROWSER IS A MOBILE DEVICE - RETURNS BOOL
	function is_mobile() {
		if (eregi('ipod', $_SERVER['HTTP_USER_AGENT'])
			|| eregi('iphone', $_SERVER['HTTP_USER_AGENT'])
			|| eregi('android', $_SERVER['HTTP_USER_AGENT'])
			|| eregi('opera mini', $_SERVER['HTTP_USER_AGENT'])
			|| eregi('blackberry', $_SERVER['HTTP_USER_AGENT'])
			|| preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|vodafone|o2|pocket|kindle|mobile|pda|psp|treo)/i', $_SERVER['HTTP_USER_AGENT'])
			|| strpos($_SERVER['HTTP_ACCEPT'], 'text/vnd.wap.wml') > 0
			|| strpos($_SERVER['HTTP_ACCEPT'], 'application/vnd.wap.xhtml+xml') > 0
			|| isset($_SERVER['HTTP_X_WAP_PROFILE'])
			|| isset($_SERVER['HTTP_PROFILE'])
			|| in_array(strtolower(substr($_SERVER['HTTP_USER_AGENT'],0,4)), array(
				'1207'=>'1207','3gso'=>'3gso','4thp'=>'4thp','501i'=>'501i','502i'=>'502i','503i'=>'503i'
				,'504i'=>'504i','505i'=>'505i','506i'=>'506i','6310'=>'6310','6590'=>'6590','770s'=>'770s'
				,'802s'=>'802s','a wa'=>'a wa','acer'=>'acer','acs-'=>'acs-','airn'=>'airn','alav'=>'alav'
				,'asus'=>'asus','attw'=>'attw','au-m'=>'au-m','aur '=>'aur ','aus '=>'aus ','abac'=>'abac'
				,'acoo'=>'acoo','aiko'=>'aiko','alco'=>'alco','alca'=>'alca','amoi'=>'amoi','anex'=>'anex'
				,'anny'=>'anny','anyw'=>'anyw','aptu'=>'aptu','arch'=>'arch','argo'=>'argo','bell'=>'bell'
				,'bird'=>'bird','bw-n'=>'bw-n','bw-u'=>'bw-u','beck'=>'beck','benq'=>'benq','bilb'=>'bilb'
				,'blac'=>'blac','c55/'=>'c55/','cdm-'=>'cdm-','chtm'=>'chtm','capi'=>'capi','comp'=>'comp'
				,'cond'=>'cond','craw'=>'craw','dall'=>'dall','dbte'=>'dbte','dc-s'=>'dc-s','dica'=>'dica'
				,'ds-d'=>'ds-d','ds12'=>'ds12','dait'=>'dait','devi'=>'devi','dmob'=>'dmob','doco'=>'doco'
				,'dopo'=>'dopo','el49'=>'el49','erk0'=>'erk0','esl8'=>'esl8','ez40'=>'ez40','ez60'=>'ez60'
				,'ez70'=>'ez70','ezos'=>'ezos','ezze'=>'ezze','elai'=>'elai','emul'=>'emul','eric'=>'eric'
				,'ezwa'=>'ezwa','fake'=>'fake','fly-'=>'fly-','fly_'=>'fly_','g-mo'=>'g-mo','g1 u'=>'g1 u'
				,'g560'=>'g560','gf-5'=>'gf-5','grun'=>'grun','gene'=>'gene','go.w'=>'go.w','good'=>'good'
				,'grad'=>'grad','hcit'=>'hcit','hd-m'=>'hd-m','hd-p'=>'hd-p','hd-t'=>'hd-t','hei-'=>'hei-'
				,'hp i'=>'hp i','hpip'=>'hpip','hs-c'=>'hs-c','htc '=>'htc ','htc-'=>'htc-','htca'=>'htca'
				,'htcg'=>'htcg','htcp'=>'htcp','htcs'=>'htcs','htct'=>'htct','htc_'=>'htc_','haie'=>'haie'
				,'hita'=>'hita','huaw'=>'huaw','hutc'=>'hutc','i-20'=>'i-20','i-go'=>'i-go','i-ma'=>'i-ma'
				,'i230'=>'i230','iac'=>'iac','iac-'=>'iac-','iac/'=>'iac/','ig01'=>'ig01','im1k'=>'im1k'
				,'inno'=>'inno','iris'=>'iris','jata'=>'jata','java'=>'java','kddi'=>'kddi','kgt'=>'kgt'
				,'kgt/'=>'kgt/','kpt '=>'kpt ','kwc-'=>'kwc-','klon'=>'klon','lexi'=>'lexi','lg g'=>'lg g'
				,'lg-a'=>'lg-a','lg-b'=>'lg-b','lg-c'=>'lg-c','lg-d'=>'lg-d','lg-f'=>'lg-f','lg-g'=>'lg-g'
				,'lg-k'=>'lg-k','lg-l'=>'lg-l','lg-m'=>'lg-m','lg-o'=>'lg-o','lg-p'=>'lg-p','lg-s'=>'lg-s'
				,'lg-t'=>'lg-t','lg-u'=>'lg-u','lg-w'=>'lg-w','lg/k'=>'lg/k','lg/l'=>'lg/l','lg/u'=>'lg/u'
				,'lg50'=>'lg50','lg54'=>'lg54','lge-'=>'lge-','lge/'=>'lge/','lynx'=>'lynx','leno'=>'leno'
				,'m1-w'=>'m1-w','m3ga'=>'m3ga','m50/'=>'m50/','maui'=>'maui','mc01'=>'mc01','mc21'=>'mc21'
				,'mcca'=>'mcca','medi'=>'medi','meri'=>'meri','mio8'=>'mio8','mioa'=>'mioa','mo01'=>'mo01'
				,'mo02'=>'mo02','mode'=>'mode','modo'=>'modo','mot '=>'mot ','mot-'=>'mot-','mt50'=>'mt50'
				,'mtp1'=>'mtp1','mtv '=>'mtv ','mate'=>'mate','maxo'=>'maxo','merc'=>'merc','mits'=>'mits'
				,'mobi'=>'mobi','motv'=>'motv','mozz'=>'mozz','n100'=>'n100','n101'=>'n101','n102'=>'n102'
				,'n202'=>'n202','n203'=>'n203','n300'=>'n300','n302'=>'n302','n500'=>'n500','n502'=>'n502'
				,'n505'=>'n505','n700'=>'n700','n701'=>'n701','n710'=>'n710','nec-'=>'nec-','nem-'=>'nem-'
				,'newg'=>'newg','neon'=>'neon','netf'=>'netf','noki'=>'noki','nzph'=>'nzph','o2 x'=>'o2 x'
				,'o2-x'=>'o2-x','opwv'=>'opwv','owg1'=>'owg1','opti'=>'opti','oran'=>'oran','p800'=>'p800'
				,'pand'=>'pand','pg-1'=>'pg-1','pg-2'=>'pg-2','pg-3'=>'pg-3','pg-6'=>'pg-6','pg-8'=>'pg-8'
				,'pg-c'=>'pg-c','pg13'=>'pg13','phil'=>'phil','pn-2'=>'pn-2','ppc;'=>'ppc;','pt-g'=>'pt-g'
				,'palm'=>'palm','pana'=>'pana','pire'=>'pire','pock'=>'pock','pose'=>'pose','psio'=>'psio'
				,'qa-a'=>'qa-a','qc-2'=>'qc-2','qc-3'=>'qc-3','qc-5'=>'qc-5','qc-7'=>'qc-7','qc07'=>'qc07'
				,'qc12'=>'qc12','qc21'=>'qc21','qc32'=>'qc32','qc60'=>'qc60','qci-'=>'qci-','qwap'=>'qwap'
				,'qtek'=>'qtek','r380'=>'r380','r600'=>'r600','raks'=>'raks','rim9'=>'rim9','rove'=>'rove'
				,'s55/'=>'s55/','sage'=>'sage','sams'=>'sams','sc01'=>'sc01','sch-'=>'sch-','scp-'=>'scp-'
				,'sdk/'=>'sdk/','se47'=>'se47','sec-'=>'sec-','sec0'=>'sec0','sec1'=>'sec1','semc'=>'semc'
				,'sgh-'=>'sgh-','shar'=>'shar','sie-'=>'sie-','sk-0'=>'sk-0','sl45'=>'sl45','slid'=>'slid'
				,'smb3'=>'smb3','smt5'=>'smt5','sp01'=>'sp01','sph-'=>'sph-','spv '=>'spv ','spv-'=>'spv-'
				,'sy01'=>'sy01','samm'=>'samm','sany'=>'sany','sava'=>'sava','scoo'=>'scoo','send'=>'send'
				,'siem'=>'siem','smar'=>'smar','smit'=>'smit','soft'=>'soft','sony'=>'sony','t-mo'=>'t-mo'
				,'t218'=>'t218','t250'=>'t250','t600'=>'t600','t610'=>'t610','t618'=>'t618','tcl-'=>'tcl-'
				,'tdg-'=>'tdg-','telm'=>'telm','tim-'=>'tim-','ts70'=>'ts70','tsm-'=>'tsm-','tsm3'=>'tsm3'
				,'tsm5'=>'tsm5','tx-9'=>'tx-9','tagt'=>'tagt','talk'=>'talk','teli'=>'teli','topl'=>'topl'
				,'tosh'=>'tosh','up.b'=>'up.b','upg1'=>'upg1','utst'=>'utst','v400'=>'v400','v750'=>'v750'
				,'veri'=>'veri','vk-v'=>'vk-v','vk40'=>'vk40','vk50'=>'vk50','vk52'=>'vk52','vk53'=>'vk53'
				,'vm40'=>'vm40','vx98'=>'vx98','virg'=>'virg','vite'=>'vite','voda'=>'voda','vulc'=>'vulc'
				,'w3c '=>'w3c ','w3c-'=>'w3c-','wapj'=>'wapj','wapp'=>'wapp','wapu'=>'wapu','wapm'=>'wapm'
				,'wig '=>'wig ','wapi'=>'wapi','wapr'=>'wapr','wapv'=>'wapv','wapy'=>'wapy','wapa'=>'wapa'
				,'waps'=>'waps','wapt'=>'wapt','winc'=>'winc','winw'=>'winw','wonu'=>'wonu','x700'=>'x700'
				,'xda2'=>'xda2','xdag'=>'xdag','yas-'=>'yas-','your'=>'your','zte-'=>'zte-','zeto'=>'zeto'
				,'acs-'=>'acs-','alav'=>'alav','alca'=>'alca','amoi'=>'amoi','aste'=>'aste','audi'=>'audi'
				,'avan'=>'avan','benq'=>'benq','bird'=>'bird','blac'=>'blac','blaz'=>'blaz','brew'=>'brew'
				,'brvw'=>'brvw','bumb'=>'bumb','ccwa'=>'ccwa','cell'=>'cell','cldc'=>'cldc','cmd-'=>'cmd-'
				,'dang'=>'dang','doco'=>'doco','eml2'=>'eml2','eric'=>'eric','fetc'=>'fetc','hipt'=>'hipt'
				,'http'=>'http','ibro'=>'ibro','idea'=>'idea','ikom'=>'ikom','inno'=>'inno','ipaq'=>'ipaq'
				,'jbro'=>'jbro','jemu'=>'jemu','java'=>'java','jigs'=>'jigs','kddi'=>'kddi','keji'=>'keji'
				,'kyoc'=>'kyoc','kyok'=>'kyok','leno'=>'leno','lg-c'=>'lg-c','lg-d'=>'lg-d','lg-g'=>'lg-g'
				,'lge-'=>'lge-','libw'=>'libw','m-cr'=>'m-cr','maui'=>'maui','maxo'=>'maxo','midp'=>'midp'
				,'mits'=>'mits','mmef'=>'mmef','mobi'=>'mobi','mot-'=>'mot-','moto'=>'moto','mwbp'=>'mwbp'
				,'mywa'=>'mywa','nec-'=>'nec-','newt'=>'newt','nok6'=>'nok6','noki'=>'noki','o2im'=>'o2im'
				,'opwv'=>'opwv','palm'=>'palm','pana'=>'pana','pant'=>'pant','pdxg'=>'pdxg','phil'=>'phil'
				,'play'=>'play','pluc'=>'pluc','port'=>'port','prox'=>'prox','qtek'=>'qtek','qwap'=>'qwap'
				,'rozo'=>'rozo','sage'=>'sage','sama'=>'sama','sams'=>'sams','sany'=>'sany','sch-'=>'sch-'
				,'sec-'=>'sec-','send'=>'send','seri'=>'seri','sgh-'=>'sgh-','shar'=>'shar','sie-'=>'sie-'
				,'siem'=>'siem','smal'=>'smal','smar'=>'smar','sony'=>'sony','sph-'=>'sph-','symb'=>'symb'
				,'t-mo'=>'t-mo','teli'=>'teli','tim-'=>'tim-','tosh'=>'tosh','treo'=>'treo','tsm-'=>'tsm-'
				,'upg1'=>'upg1','upsi'=>'upsi','vk-v'=>'vk-v','voda'=>'voda','vx52'=>'vx52','vx53'=>'vx53'
				,'vx60'=>'vx60','vx61'=>'vx61','vx70'=>'vx70','vx80'=>'vx80','vx81'=>'vx81','vx83'=>'vx83'
				,'vx85'=>'vx85','wap-'=>'wap-','wapa'=>'wapa','wapi'=>'wapi','wapp'=>'wapp','wapr'=>'wapr'
				,'webc'=>'webc','whit'=>'whit','winw'=>'winw','wmlb'=>'wmlb','xda-'=>'xda-'
		))) {
			header('Cache-Control: no-transform');
			header('Vary: User-Agent, Accept');
			return true;
		}
		return false;
	}

	# CONVERT ARRAY INTO HIDDEN FORM FIELDS - RETURNS HTML
	function make_hidden_fields($data, $data2=array(), $exclude=array()) {
		$hidden_fields = '';
		foreach ($data as $key => $val) {
			if (in_array($key, $exclude)) {
				continue;
			}
			if (is_array($val)) {
				foreach ($val as $val2) {
					$val2 = str_replace('"', "''", $val2);
					$hidden_fields .= '<input type="hidden" name="' . $key . '[]" value="' . $val2 . '">' . "\n";
				}
			} else {
				$val = str_replace('"', "''", $val);
				if (!in_array($key, array('action', 'show_panel', 'x', 'y'))) {
					$hidden_fields .= '<input type="hidden" name="' . $key . '" value="' . $val . '">' . "\n";
				}
			}
		}
		foreach ($data2 as $key => $val) {
			if (in_array($key, $exclude)) {
				continue;
			}
			$val = str_replace('"', "''", $val);
			$hidden_fields .= '<input type="hidden" name="' . $key . '" value="' . $val . '">' . "\n";
		}
		return $hidden_fields;
	}

	# CC ENCRYPT/DECRYPT FUNCTIONS
	function md5_decrypt($enc_text, $password, $iv_len = 16) {
		$enc_text = base64_decode($enc_text);
		$n = strlen($enc_text);
		$i = $iv_len;
		$plain_text = '';
		$iv = substr($password ^ substr($enc_text, 0, $iv_len), 0, 512);
		while ($i < $n) {
			$block = substr($enc_text, $i, 16);
			$plain_text .= $block ^ pack('H*', md5($iv));
			$iv = substr($block . $iv, 0, 512) ^ $password;
			$i += 16;
		}
		return preg_replace('/\\x13\\x00*$/', '', $plain_text);
	}
	function md5_encrypt($plain_text, $password, $iv_len = 16) {
		$plain_text .= "\x13";
		$n = strlen($plain_text);
		if ($n % 16) {
			$plain_text .= str_repeat("\0", 16 - ($n % 16));
		}
		$i = 0;
		$enc_text = $this->get_rnd_iv($iv_len);
		$iv = substr($password ^ $enc_text, 0, 512);
		while ($i < $n) {
			$block = substr($plain_text, $i, 16) ^ pack('H*', md5($iv));
			$enc_text .= $block;
			$iv = substr($block . $iv, 0, 512) ^ $password;
			$i += 16;
		}
		return base64_encode($enc_text);
	}

	# OBFUSCATE FOR CC NUMBERS - RETURNS STRING
	function obfuscate_num($num, $show=0) {
		$num2 = substr($num, 0, $show);
		for ($i = $show; $i < strlen($num) - $show; $i++) {
			$num2 .= 'x';
		}
		$show = substr($num, strlen($num2), $show);
		return $num2 . $show;
	}

	function main_navigation() {
		global $dbObj;

		$moduleSections = $dbObj->db_select_multiple('module_section','*',array(),'order by sequence');

		$output = '';

		foreach ($moduleSections as $moduleSection) {
			$modules = $this->menu_modules($moduleSection['module_section_id']);
			$activeCategory = '';
			if (strpos($modules, 'class="active"') > 0) {
				$activeCategory = "active";
			}
			if ($modules != '') {
				$output .= "
				<div class='dropdown $activeCategory'>
					<button class='dropbtn'>{$moduleSection['module_section_name']}
						<i class='fa fa-caret-down'></i>
					</button>
					<div class='dropdown-content'>$modules</div></div>
				";
			}
		}
		return $output;
	}
	function menu_modules($moduleSectionId) {
		global $dbObj;

		$action = isset($_GET['m']) ? $_GET['m'] : $_POST['action'];

		$dsAdminModules = $dbObj->db_select_multiple('ds_admin_modules','*',array('module.module_section_id' => $moduleSectionId,'ds_admin_modules.aID' => $_SESSION['aID'] ),'order by sequence',array('module on module.module_id = ds_admin_modules.module_id'));

		$output = '';

		if ($dsAdminModules) {
			foreach ($dsAdminModules as $module) {
				$moduleIsActive = '';
				if ($action == $module['module_method']) {
					$moduleIsActive = 'class="active"';
				}
				$output .= "<a $moduleIsActive href='admin_controller.php?m={$module['module_method']}'>{$module['module_name']}</a>";
			}
		}
		return $output;
	}

	# TEMPLATE VARIABLE PARSER - RETURNS STRING
	function parse($output, $data) {

		global $adminObj;

		if ($output == TEMPLATE){
			$output = str_replace('__HEADER__', HEADER, $output);
			$output = str_replace('__FOOTER__', FOOTER, $output);
			$output = str_replace('__MAIN_NAVIGATION__', $this->main_navigation(), $output);
			$output = str_replace('__VERSION__', VERSION, $output);
		}

		//popup one time message if time sheet needs completing
		if ($_SESSION['timesheet_overdue'] == 'true' && substr_count($output, '__SCRIPT__') > 0){

			$output = str_replace('__SCRIPT__', 'function displayMessage(){alert("Please note: You need to complete/submit your time sheet for this pay period.");}', $output);
			$_SESSION['timesheet_overdue'] = 'false';
		}else{
			$output = str_replace('__SCRIPT__', '', $output);
		}

		if (is_array($data)) {
			foreach ($data as $key => $val) {
				$output = str_replace('__' . $key . '__', $val, $output);
			}

                        if ($adminObj->is_super()){
                            $output = str_replace('__SUPER_USER__', '', $output);
                            $output = str_replace('__USER_EDIT__', 'style="display:none;"', $output);
                        }else{
                            $output = str_replace('__SUPER_USER__', 'style="display:none;"', $output);
                            $output = str_replace('__USER_EDIT__', '', $output);
                        }
		}
		// Title should be specified in pages - fallback if it isn't
		$output = str_replace('__TITLE__', $_GET['oNum'] . ' Admin Area (' . MODE . ')', $output);
		$output = str_replace('__CDN_CSS__', CDN_CSS, $output);
		$output = str_replace('__CDN_JAVASCRIPT__', CDN_JAVASCRIPT, $output);
		$output = str_replace('__CONTROLLER__', CONTROLLER, $output);
		$output = str_replace('__CURRENT_DATE__', CURRENT_DATE, $output);
		$output = str_replace('__LOADING_MODAL__', LOADING_MODAL, $output);
		return $output;
	}

	# READS CSV FILE - RETURNS ARRAY
	function read_csv($file) {
		$records = array();
		$handle = fopen($file, 'r');
		if ($handle) {
			while (($row = fgetcsv($handle, 4000, ',')) !== FALSE) {
				$records[] = $row;
			}
		}
		return $records;
	}

	# READS XLS FILE - RETURNS ARRAY
	function read_xls($file) {
		require_once('/var/scripts/xls_reader.php');
		$records = array();
		$data = new Spreadsheet_Excel_Reader();
		$data->setOutputEncoding('CP1251');
		$data->read($file);
		for ($i = 1; $i <= $data->sheets[0]['numRows']; $i++) {
			$row = array();
			for ($j = 1; $j <= $data->sheets[0]['numCols']; $j++) {
				$row[] = $data->sheets[0]['cells'][$i][$j];
			}
			$records[] = $row;
		}
		return $records;
	}

	# PASSWORD ENCRYPTION/DECRYPTION
	function rot13($str) {
		if (!function_exists('str_rot13')) {
			$from = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$to = 'nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM';
			return strtr($str, $from, $to);
		}
		return $rot13str = str_rot13($str);
	}

	# SENDS EMAIL - RETURNS BOOL
	function send_email($to, $from, $subject, $body, $type='text/html', $attachments=array(), $cc = '', $bcc = '') {

            require_once 'class_database.php';

            $dbObj = New Database;

            $dbObj->db_insert('email_log',
                    array(
                        'email_to'  => $to,
                        'email_from'    => $from,
                        'email_subject' => $subject,
                        'email_body'    => $body
                    ));

                if (MODE == 'DEV'){
                    return false;
                }
		global $content_types;
		$semi_rand = md5(time());
		$mime_boundary = '==Multipart_Boundary_x' . $semi_rand . 'x';
		$content = 'multipart/alternative';
		$headers = "Return-Path: $from\nFrom: $from\nX-Sender: $from\nX-Mailer: PHP\n";
                if ($cc != ''){
                    $headers .= "Cc: $cc\n";
                }
                if ($bcc != ''){
                    $headers .= "Bcc: $bcc\n";
                }
		if ($attachments) {
			$content = 'multipart/mixed';
		}
		if ($type != 'text/plain') {
			$headers .= "MIME-Version: 1.0\nContent-type: $content; boundary=\"$mime_boundary\"\n\n";
			$mail_body = "This is a multi-part message in MIME format.\n\n--$mime_boundary\n";
			if ($content != 'multipart/mixed') {
				$mail_body .= "Content-Type: text/plain\n\n"
					. $this->convert_html_to_plain($body) . "\n\n--$mime_boundary\n";
			}
			$mail_body .= "Content-Type: $type\n\n$body\n\n";
			foreach ($attachments as $attach) {
				if (is_array($attach)) {
					$fname = $attach[1];
					$attach = $attach[0];
				} else {
					$fname = basename($attach);
				}
				$file = fopen($attach, 'rb');
				$data = fread($file, filesize($attach));
				fclose($file);
				$data = chunk_split(base64_encode($data));
				$ext = strtolower(substr($attach, strrpos($attach, '.') + 1));
				$type = 'application/octet-stream';
				if (in_array($ext, array_keys($content_types))) {
					$type = $content_types[$ext];
				}
				#$attach = str_replace(session_id() . '_', '', $attach);
				$mail_body .= "--$mime_boundary\nContent-Type: $type; name=\"$fname\"\n"
						. "Content-Disposition: attachment; filename=\"$fname\"\n"
						. "Content-Transfer-Encoding: base64\n\n$data\n\n";
			}
			$mail_body .= "--$mime_boundary--\n";
			$body = $mail_body;
		}
		if (mail($to, $subject, $body, $headers)) {
			/*if (MODE != 'DEV' && $to != ORDERS_CONF_BCC && $bcc == '') {
				mail(ERROR_LOG_EMAIL, '**DIAG** (' . $to . ') ' . $subject, $body, $headers);
			}*/
			return true;
		}
		return false;
	}

	# OUTPUT FILE TO BROWSER - EXITS
	function send_file_to_browser($content, $name) {
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename="' . $name . '"');
		echo $content;
		exit;
	}

        function send_zip_to_browser($content, $name){
            header("Content-type: application/zip");
            header("Content-Disposition: attachment; filename=$name");
            header("Content-length: " . filesize($content));
            header("Pragma: no-cache");
            header("Expires: 0");
            readfile("$content");
        }

	# SENDS FILE TO SPECIFIED PRINTER OVER IPP - RETURNS BOOL
	function send_printer($printer, $file, $attributes=array(), $debug=false) {
		global $content_types;
                $printer = explode(':', $printer);
		putenv('TZ=GMT');
		require_once(HTML_FOLDER . 'phpprintipp/CupsPrintIPP.php');
		$mime_type = basename($file);
		$mime_type = substr($mime_type, strrpos($mime_type, '.') + 1);
		$mime_type = $content_types[$mime_type];
		$ipp = new CupsPrintIPP();
		$ipp->setHost($printer[0]);
		$ipp->setPort($printer[1]);
		$ipp->setPrinterURI($printer[2]);
		if (count($attributes) > 0) {
			foreach ($attributes as $k => $v) {
				if ($debug) {
					echo "<p>Setting attribute: $k = $v</p>";
				}
				$ipp->setAttribute($k, $v);
				if ($debug) {
					echo "<p>Attribute $k = $v has been set</p>";
				}
			}
		}
		if ($debug) {
			echo "<p>Printer info:</p><pre>";
			print_r($printer);
			echo "</pre>";
			echo "<p>Querying printer attributes</p>";
			$ipp->getPrinterAttributes();
			echo "<p>Printer attributes retrieved</p>";
			echo '<pre>' . "\n";
			print_r($ipp->printer_attributes);
			echo '</pre>';
		} else {
			$ipp->setData($file);
			$ipp->setMimeMediaType($mime_type);
			if ($result = $ipp->printJob()) {
				return true;
			}
		}
		return false;
	}

	# SENDS SMS STATUS ALERTS - RETURNS RESPONSE
	function send_sms_tm4b($to, $msg) {
		return $this->tx_rx_curl(
			'https://www.tm4b.com/client/api/http.php', ''
			, 'username=' . SMS_USER . '&password=' . SMS_PASS . '&msg=' . urlencode($msg)
			. '&to=' . $to . '&from=70589&route=uss1&type=broadcast&version=2.1&subscriptionid=00094'
		);
	}

	# SENDS SMS STATUS ALERTS - RETURNS RESPONSE
	function send_sms_clickatell($to, $msg) {
		return $this->tx_rx_curl(
			'http://api.clickatell.com/http/sendmsg', ''
			, 'user=macservice&password=service10591&api_id=3166373&to=' . $to . '&text=' . urlencode($msg)
		);
	}

	# SENDS SMS STATUS ALERTS - RETURNS RESPONSE
	function send_sms_eztexting($to, $msg) {
		return $this->tx_rx_curl(
			'https://app.eztexting.com/api/sending/', ''
			, 'user=macservice&pass=service10591&phonenumber=' . $to . '&subject='
			. SITE_NAME . '&message=' . $msg . '&express=1'
		);
	}

	# SPLITS FIRST AND LAST NAMES BY SPACE - RETURNS STRING
	function split_names($name, $which='first') {
		$parts = explode(' ', $name);
		switch ($which) {
			case 'first':
				return $parts[0];
			break;
			case 'last':
				return substr($name, strpos($name, ' ') + 1);
		}
	}

	# PERFORMS MULTIPLE STRING REPLACEMENTS - RETURNS STRING
	function str_replace_from_array($str, $arr, $default='') {
		if (!$str) {
			return $default;
		}
		foreach ($arr as $key => $val) {
			$str = str_replace($key, $val, $str);
		}
		return $str;
	}

	# STRING REPLACE ONCE - RETURNS STRING
	function str_replace_once($search, $replace, $subject) {
		$firstChar = strpos($subject, $search);
		if ($firstChar !== false) {
			$beforeStr = substr($subject, 0, $firstChar);
			$afterStr = substr($subject, $firstChar + strlen($search));
			return $beforeStr . $replace . $afterStr;
		} else {
			return $subject;
		}
	}

	# SENDS HTTPS POST VIA CURL - RETURNS RESPONSE
	function tx_rx_curl($url, $headers, $params, $auth=false, $followlocation=false) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,				$url);
		curl_setopt($ch, CURLOPT_USERAGENT,			'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
		$headersOpt = 0;
		$postfields = 1;
		if ($headers) {
			$headersOpt = 1;
			curl_setopt($ch, CURLOPT_HTTPHEADER,	$headers);
		}
		if ($auth) {
			curl_setopt($ch, CURLOPT_HTTPAUTH,		CURLAUTH_BASIC);
			curl_setopt($ch, CURLOPT_USERPWD,		$auth);
		}
		if (is_array($params)) {
			$postfields = sizeof($params);
			$params = $this->array_to_querystring($params);
		}
		curl_setopt($ch, CURLOPT_VERBOSE,			0);
		curl_setopt($ch, CURLOPT_HEADER,			$headersOpt);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,	1);
                if ($followlocation){
                    curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	1);
                }else{
                    curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	0);
                }
		curl_setopt($ch, CURLOPT_FORBID_REUSE,		1);
		curl_setopt($ch, CURLOPT_PORT,				'443');
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,	1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,	0);
		curl_setopt($ch, CURLOPT_TIMEOUT,			30);
		curl_setopt($ch, CURLOPT_POST,				$postfields);
		curl_setopt($ch, CURLOPT_POSTFIELDS,		$params);
		$response = curl_exec($ch);
		curl_close($ch);
		return urldecode($response);
	}

	function curl_get($url, $headers, $auth=false, $followlocation=false) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,				$url);
		curl_setopt($ch, CURLOPT_USERAGENT,			'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
		$headersOpt = 0;
		if ($headers) {
			$headersOpt = 1;
			curl_setopt($ch, CURLOPT_HTTPHEADER,	$headers);
		}
		if ($auth) {
			curl_setopt($ch, CURLOPT_HTTPAUTH,		CURLAUTH_BASIC);
			curl_setopt($ch, CURLOPT_USERPWD,		$auth);
		}
		if ($followlocation){
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	1);
		}else{
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION,	0);
		}
		curl_setopt($ch, CURLOPT_VERBOSE,			0);
		curl_setopt($ch, CURLOPT_HEADER,			$headersOpt);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,	1);
		curl_setopt($ch, CURLOPT_FORBID_REUSE,		1);
		curl_setopt($ch, CURLOPT_PORT,				'443');
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,	1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,	0);
		curl_setopt($ch, CURLOPT_TIMEOUT,			30);
		curl_setopt($ch, CURLOPT_HTTPGET, true);
		$response = curl_exec($ch);
		curl_close($ch);
		return urldecode($response);
	}

	function curl_get_2($url, $headers, $auth=false) {
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => $headers,
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $response;
	}

	function curl_put($url, $data) {
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "PUT",
			CURLOPT_POSTFIELDS => json_encode($data),
			CURLOPT_HTTPHEADER => array(
			  "Content-Type: application/json"
			),
		  ));

		  $response = curl_exec($curl);

		  curl_close($curl);
		  return $response;
	}

	function curl_put_2($url, $data, $headers) {
		$curl = curl_init();

		// if (is_array($data)) {
		// 	$data = json_encode($data);
		// }

		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "PUT",
			CURLOPT_POSTFIELDS => json_encode($data),
			CURLOPT_HTTPHEADER => $headers,
		  ));

		  $response = curl_exec($curl);

		  curl_close($curl);
		  return $response;
	}

	function curl_post($url, $data) {
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => json_encode($data),
		  CURLOPT_HTTPHEADER => array(
			"Content-Type: application/json"
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $response;
	}

	function curl_post_2($url, $data, $headers) {
		$curl = curl_init();

		if (is_array($data)) {
			$data = json_encode($data);
		}

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => $data,
		  CURLOPT_HTTPHEADER => $headers
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $response;
	}

	# SIMPLE FILE WRITER
	function write_file($filename, $mode, $contents) {
		if ($fw = fopen($filename, $mode)) {
			if (fwrite($fw, $contents)) {
				return true;
			}
			fclose($fw);
		}
		return false;
	}

        function genRandomString($length) {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
            $string = '';
            for ($p = 0; $p < $length; $p++) {
                $string .= $characters[mt_rand(0, strlen($characters))];
            }
            return $string;
        }

        //print labels
        function print_labels($data,$copies,$lines,$printer,$barcode){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $font = 'arialbd.ttf';

            $fontname = $fontpath.$font;

            if ($barcode){

                foreach ($data as $row){

                    //create image
                    $image = imagecreate(406, 203);
                    //set colors
                    $background_color = imagecolorallocate($image, 255, 255, 255);
                    $text_color = imagecolorallocate($image, 0, 0, 0);

                    //create default box
                    $size = imagettfbbox(20, 0, $fontname, $row);
                    //calulate font size
                    $fontsize = floor(20 * (366 / $size[2]));
                    $size = imagettfbbox($fontsize, 0, $fontname, $row);
                    if ($size[5] < -80){
                        $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row);
                    }
                    //calculate coordinates
                    $x = floor((406 - $size[2])/2);
                    $y = floor((203/4)-($size[5]/2));
                    //write text
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row);

                    //create default box
                    $size = imagettfbbox(20, 0, $fontpath.'3OF9.ttf', '*'.$row.'*');
                    //calulate font size
                    $fontsize = floor(20 * (366 / $size[2]));
                    $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$row.'*');
                    if ($size[5] < -80){
                        $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                        $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$row.'*');
                    }
                    //calculate coordinates
                    $x = floor((406 - $size[2])/2);
                    $y = floor(((203/4)*3)-($size[5]/2));
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$row.'*');

                    $filename = $tmp_path.$this->genRandomString(10).'.png';
                    imagepng($image,$filename);

                    //print
                    for ($i=1;$i<=$copies;$i++){
                        $this->send_printer($printer, $filename);
                    }

                    //tidy up
                    imagedestroy($image);
                    unlink($filename);

                }

            }else{

                if ($lines == 1){

                    foreach ($data as $row){

                        $image = imagecreate(406, 203);
                        $background_color = imagecolorallocate($image, 255, 255, 255);
                        $text_color = imagecolorallocate($image, 0, 0, 0);

                        //create default box
                        $size = imagettfbbox(20, 0, $fontname, $row);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row);
                        if ($size[5] < -160){
                            $fontsize = floor($fontsize * (163 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor((203/2)-($size[5]/2));
                        //write text
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row);

                        $filename = $tmp_path.$this->genRandomString(10).'.png';
                        imagepng($image,$filename);

                        for ($i=1;$i<=$copies;$i++){
                            $this->send_printer($printer, $filename);
                        }

                        imagedestroy($image);
                        unlink($filename);

                    }
                }  elseif ($lines == 2) {

                    $rows = array_chunk($data, 2);

                    foreach ($rows as $row){

                        $image = imagecreate(406, 203);
                        $background_color = imagecolorallocate($image, 255, 255, 255);
                        $text_color = imagecolorallocate($image, 0, 0, 0);

                        $size = imagettfbbox(20, 0, $fontname, $row[0]);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row[0]);
                        if ($size[5] < -80){
                            $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row[0]);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor((203/4)-($size[5]/2));
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row[0]);

                        $size = imagettfbbox(20, 0, $fontname, $row[1]);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row[1]);
                        if ($size[5] < -80){
                            $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row[1]);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor(((203/4)*3)-($size[5]/2));
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row[1]);

                        $filename = $tmp_path.$this->genRandomString(10).'.png';
                        imagepng($image,$filename);

                        for ($i=1;$i<=$copies;$i++){
                            $this->send_printer($printer, $filename);
                        }

                        imagedestroy($image);
                        unlink($filename);

                    }

                }  elseif ($lines == 3) {

                    $rows = array_chunk($data, 3);

                    foreach ($rows as $row){

                        $image = imagecreate(406, 203);
                        $background_color = imagecolorallocate($image, 255, 255, 255);
                        $text_color = imagecolorallocate($image, 0, 0, 0);

                        $size = imagettfbbox(20, 0, $fontname, $row[0]);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row[0]);
                        if ($size[5] < -45){
                            $fontsize = floor($fontsize * (45 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row[0]);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor((203/6)-($size[5]/2));
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row[0]);

                        $size = imagettfbbox(20, 0, $fontname, $row[1]);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row[1]);
                        if ($size[5] < -45){
                            $fontsize = floor($fontsize * (45 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row[1]);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor(((203/6)*3)-($size[5]/2));
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row[1]);

                        $size = imagettfbbox(20, 0, $fontname, $row[2]);
                        //calulate font size
                        $fontsize = floor(20 * (366 / $size[2]));
                        $size = imagettfbbox($fontsize, 0, $fontname, $row[2]);
                        if ($size[5] < -45){
                            $fontsize = floor($fontsize * (45 / ($size[5]/-1)));
                            $size = imagettfbbox($fontsize, 0, $fontname, $row[2]);
                        }
                        //calculate coordinates
                        $x = floor((406 - $size[2])/2);
                        $y = floor(((203/6)*5)-($size[5]/2));
                        imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $row[2]);

                        $filename = $tmp_path.$this->genRandomString(10).'.png';
                        imagepng($image,$filename);

                        for ($i=1;$i<=$copies;$i++){
                            $this->send_printer($printer, $filename);
                        }

                        imagedestroy($image);
                        unlink($filename);

                    }

                }

            }

        }

        public function print_ipad_label($data,$printer){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $font = 'arialbd.ttf';

            $fontname = $fontpath.$font;

            //create image
            $image = imagecreate(406, 203);
            //set colors
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['oNum']);
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            }
            //calculate coordinates
            $x = floor((406 - $size[2])/2);
            $y = 75;
            //write text
            imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $data['oNum']);

            //create default box
            $size = imagettfbbox(20, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            }
            //calculate coordinates
            $x = floor((406 - $size[2])/2);
            $y = '135';
            imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');


            //calculate coordinates
            $x = floor((406 - $size[2])/2);
            $y = '190';
            //write text
            imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, $data['machine_id'].':'.$data['port'].' ' .$data['capacity'].' '.$data['locked']);

            $filename = $tmp_path.$this->genRandomString(10).'.png';
            imagepng($image,$filename);

            //print
            $this->send_printer($printer, $filename);

             //tidy up
            imagedestroy($image);
            unlink($filename);

        }


        public function print_refurb_label_large($data,$printer){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $fontbold = 'arialbd.ttf';
            $font = 'arial.ttf';

            $fontnamebold = $fontpath.$fontbold;
            $fontname = $fontpath.$font;

            $image = imagecreate(1269, 812);
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);



            //create default box
            $size = imagettfbbox(0, 0, $fontnamebold, $data['asset'].' '.$data['machineType']);
            //calulate font size
            $fontsize = floor(10 * (732 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontnamebold, $data['asset'].' '.$data['machineType']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontnamebold, $data['asset'].' '.$data['machineType']);
            }
            //calculate coordinates
            $x = floor((812 - $size[2])/2);
            $y = floor((406/8)-($size[5]/2));
            //write text
            //imagettftext($image, $fontsize, 0, 125, $y, $text_color, $fontnamebold, $data['asset'].' '.$data['machineType']);

            //create rectangle round grade letter
            //imagefilledrectangle($image, 70, 80, 200, 180, $text_color);
            //imagefilledrectangle($image, 75, 85, 195, 175, $background_color);

            //write grade letter
            imagettftext($image, 175, 0, 65, $y + 675, $text_color, $fontnamebold, $data['grade']);

            //wrap description text


            imagettftext($image, 15, 0, 250, $y + 50, $text_color, $fontnamebold, $text);


            //write PO# and Date
            imagettftext($image, 25, 0, 825, 625, $text_color, $fontnamebold, 'PO:'.$data['poNumber'].'     '.$data['date']);


            //create default box
            $size = imagettfbbox(20, 0, $fontnamebold, $data['serialNumber']);
            //calulate font size
            $fontsize = floor(20 * (250 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontnamebold, $data['serialNumber']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontnamebold, $data['serialNumber']);
            }

			//$text = $this->wrap(15, 0, $fontnamebold, ''.$data['case_scratches'].'  '.$data['case_cdents'].' '.$data['case_sdents'].' '.$data['case_edents'].' '.$data['digi_dust'].' '.$data['refurb_notes'], 300);

			//$text = $this->wrap(15, 0, $fontnamebold, ''.$data['case_scratches'].'  '.$data['case_cdents'].' '.$data['case_sdents'].' '.$data['case_edents'].' '.$data['digi_scratches'].' '.$data['refurb_notes'], 300);

			$text = $this->wrap(15, 0, $fontnamebold, ''.$data['refurb_notes'], 300);

			$x = 820;
			$y += 80;

                 /*if ($data['case_scratches'] == 'Minor' || $data['case_scratches'] == 'Minor'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Case Scratches - Minor ');
                }else{

                }
				if ($data['case_scratches'] == 'Moderate' || $data['case_scratches'] == 'Moderate'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Case Scratches - Moderate');
                }else{

                }
				if ($data['case_scratches'] == 'Major' || $data['case_scratches'] == 'Major'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Case Scratches - Major');
                }else{

                }
				$x = 820;
                $y += 40;

                 if ($data['case_cdents'] == 'Minor' || $data['case_cdents'] == 'Minor'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Corner Dents - Minor');
                }else{

                }
				if ($data['case_cdents'] == 'Moderate' || $data['case_cdents'] == 'Moderate'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Corner Dents - Moderate');
                }else{

                }
				if ($data['case_cdents'] == 'Major' || $data['case_cdents'] == 'Major'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Corner Dents - Major');
                }else{

                }
				$x = 820;
                $y += 40;

                 if ($data['case_sdents'] == 'Minor' || $data['case_sdents'] == 'Minor'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Surface Dents - Minor');
                }else{

                }
				if ($data['case_sdents'] == 'Moderate' || $data['case_sdents'] == 'Moderate'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Surface Dents - Moderate');
                }else{

                }
				if ($data['case_sdents'] == 'Major' || $data['case_sdents'] == 'Major'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Surface Dents - Major');
                }else{

                }
				$x = 820;
                $y += 40;

                 if ($data['case_edents'] == 'Minor' || $data['case_edents'] == 'Minor'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Edge Dents - Minor');
                }else{

                }
				if ($data['case_edents'] == 'Moderate' || $data['case_edents'] == 'Moderate'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Edge Dents - Moderate');
                }else{

                }
				if ($data['case_edents'] == 'Major' || $data['case_edents'] == 'Major'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Edge Dents - Major');
                }else{

                }
				$x = 820;
                $y += 40;

                 if ($data['digi_scratches'] == 'Minor' || $data['digi_scratches'] == 'Minor'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen Scratches - Minor');
                }else{

                }
				if ($data['digi_scratches'] == 'Moderate' || $data['digi_scratches'] == 'Moderate'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen Scratches - Moderate');
                }else{

                }
				if ($data['digi_scratches'] == 'Major' || $data['digi_scratches'] == 'Major'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen Scratches - Major');
                }else{

                }



		$x = 820;
                $y += 40;

                 if ($data['digitizer_crack'] == 1 || $data['digitizer_crack'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Cracked');
				   $x += 140;
                }else{

                }

				  if ($data['digi_white'] == 1 || $data['digi_white'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'White Spots  ');
				   $x += 190;
                }else{

                }

				if ($data['digi_dust'] == 1 || $data['digi_dust'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Dust');
				   $x += 180;
                }else{

                }

				$x = 820;
                $y += 40;

                 if ($data['digi_dis'] == 1 || $data['digi_dis'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }

				  if ($data['digi_sep'] == 1 || $data['digi_sep'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }

				if ($data['digi_un'] == 1 || $data['digi_un'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }
				if ($data['digi_un'] == 1 || $data['digi_lines'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }
				if ($data['digi_un'] == 1 || $data['digi_touch'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }
				if ($data['digi_un'] == 1 || $data['digi_video'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontnamebold, 'Screen/Digitzer Issue');

                }else{

                }*/







            imagettftext($image, 20, 0, 825, 75, $text_color, $fontnamebold, $text);

            //calculate coordinates
            $x = floor((406 - $size[2])/2);
            $y = floor((406/3)-($size[5]/2));

            //write text
            imagettftext($image, 18, 0, 30, $offset, $text_color, $fontnamebold, $notes);
			imagettftext($image, 50, 0, 75, 525, $text_color, $fontnamebold, $data['asset']);
			imagettftext($image, 30, 0, 75, 575, $text_color, $fontnamebold, $data['machineType']);

			$diff = max(0, 12 - strlen($data['serialNumber']));
			$yNew = 525 - (5*$diff);
            imagettftext($image, min($fontsize, 30), 0, 825, $yNew, $text_color, $fontnamebold, $data['serialNumber']);
            imagettftext($image, 40, 0, 825, 705, $text_color, $fontnamebold, $data['oNum']);

            //create default box
            $size = imagettfbbox(50, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            //calulate font size
            $fontsize = floor(80 * (250 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor(((406/3))-($size[5]/2));
            imagettftext($image, $fontsize, 0, 825, 575, $text_color, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
			imagettftext($image, 50, 0, 825, 775, $text_color, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
			$fontsize = 36;

            if (!$data['is_ipad']){
               $x = 75;
                $y = 75;
                //write text

				$hdstr = $data['hd'];
				$ramstr = $data['ram'];
				$processorName = $this->normalize_processor_name($data['processor_name']);
				$processorSpeed = $data['processor_speed'];


				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'HD: '.$hdstr);

				 $x += 250;

				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'RAM: '.$ramstr);

                $x += 150;

				$x = 75;
                $y += 70;

				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'OS: '.$data['os_version']);

                $x += 250;

				// Print processor data
				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, $processorSpeed . ' ' . $processorName);

				$x = 75;
                $y += 75;

                if ($data['top_case'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Top Case');
					$x += 230;
                }else{

                }



                if ($data['display_housing'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'DH');
				   $x += 110;
                }else{

                }



                if ($data['bottom_case'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Bottom Case');
                }else{

                }



                $x = 75;
                $y += 65;



                if ($data['keys'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Keyboard');
				   $x += 230;
                }else{

                }



                if ($data['hinge'] == 1 || $data['broken_hinge'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Hinge');
					$x += 140;
                }else{

                }



                if ($data['optical'] == 'fail'){
                     imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Optical');
                }else{

                }



                $x = 75;
                $y += 65;

                if ($data['keyboard'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Kbd');
					$x += 125;
                }else{

                }


                if ($data['lcd'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'LCD');
					$x += 125;
                }else{

                }



                if ($data['wifi'] == 'fail'){
                 imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Wi-Fi');
				 $x += 140;
                }else{

                }



                if ($data['speakers'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, '♫');
                }else{

                }

                $x = 75;
                $y += 65;


                if ($data['battery'] == 'fail'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Battery');
				   $x += 170;
                }else{

                }



                if ($data['isight'] == 'fail'){
                     imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'iSight');
					  $x += 150;
                }else{

                }


                if ($data['enet'] == 'fail'){
                         imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Enet');
                         $x += 150;
                }else{

                }

				$x = 75;
				$y += 50;

				if ($data['mdm_lock'] == 1){
				   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'MDM Lock');
				   $x += 150;
				} else {

				}

                if ($data['boot_failure'] == 1){
                         imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Logic Failure');
                }else{

                }
            }elseif ($data['is_imac']){
               $x = 75;
                $y = 75;
                //write text

			     $hdstr = $data['hd'];
				 $ramstr = $data['ram'];

			     imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'HD: '.$hdstr);

				 $x += 250;

				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'RAM: '.$ramstr);

                $x += 150;

				$x = 75;
                $y += 70;

				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, 'OS: '.$data['os_version']);

				$x = 75;
                $y += 75;

                if ($data['rh_scratched'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'RH Scratched');
					$x += 230;
                }else{

                }



                if ($data['rh_dented'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'RH Dented');
				   $x += 110;
                }else{

                }



                if ($data['stand_scratched'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Stand Scratched');
                }else{

                }



                $x = 75;
                $y += 65;



                if ($data['stand_dented'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Stand Dented');
				   $x += 230;
                }else{

                }



                if ($data['glass_scratched'] == 1){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Glass Scratched');
					$x += 140;
                }else{

                }



                if ($data['glass_cracked'] == 'fail'){
                     imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Glass Cracked');
                }else{

                }



                $x = 75;
                $y += 65;


                if ($data['lcd'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'LCD');
					$x += 125;
                }else{

                }



                if ($data['wifi'] == 'fail'){
                 imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Wi-Fi');
				 $x += 140;
                }else{

                }



                if ($data['speakers'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, '♫');
                }else{

                }

                $x = 75;
				$y += 50;


                if ($data['battery'] == 'fail'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Battery');
				   $x += 170;
                }else{

                }



                if ($data['isight'] == 'fail'){
                     imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'iSight');
					  $x += 150;
                }else{

                }


                if ($data['enet'] == 'fail'){
                         imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Enet');
                }else{

            }

			$x = 75;
			$y += 65;

			if ($data['mdm_lock'] == 1){
			   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'MDM Lock');
			   $x += 150;
			} else {

			}
            }else{
                $x = 75;
                $y = 75;
                //write text

			     imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, $data['capacity']);

                $x += 130;

				imagettftext($image, 30, 0, $x, $y, $text_color, $fontnamebold, '    OS: '.$data['os_version']);

				$x = 75;
                $y += 100;

                if ($data['lcd'] == 1){
                     imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'LCD');
					 $x += 130;
                }else{

                }



                if ($data['digitizer_scratch'] == 1 || $data['digitizer_crack'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Digitizer');
				   $x += 180;
                }else{

                }





                if ($data['case_scratch'] == 1 || $data['case_crack'] || $data['case_dent']){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Case');
                }else{

                }


                $x = 75;
                $y += 65;



                if ($data['charge'] == 'fail'){
                         imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Charge');
						 $x += 170;
                }else{

                }



                if ($data['sleep_wake'] == 'fail'){
                      imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Sleep');
					   $x += 130;
                }else{

                }



                if ($data['mic'] == 'fail'){
           imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Mic');
                }else{

                }

                $x = 75;
                $y += 65;

                if ($data['home_button'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Home');
					$x += 130;
                }else{

                }



                if ($data['volume'] == 'fail'){
                  imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Volume');
				  $x += 175;
                }else{

                }



                if ($data['silent_rot'] == 'fail'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Silent');
				   $x += 130;
                }else{

                }



                if ($data['headphone'] == 'fail'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'H-Jack');
                }else{

                }

                $x = 75;
                $y += 65;

                if ($data['wifi'] == 'fail'){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Wi-Fi');
				   $x += 130;
                }else{



                }



                if ($data['front_camera'] == 'fail'){
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'F-Cam');
					 $x += 150;
                }else{

                }



                if ($data['rear_camera'] == 'fail'){
                  imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'R-Cam');
				  $x += 150;
                }else{

                }



                if ($data['speaker'] == 'fail'){
                 imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Speaker');
                }else{

                }

                $x = 75;
                $y += 65;

                if ($data['mdm_lock'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'MDM Lock');
                   $x += 150;
		}

                if ($data['activation_lock'] == 1){
                   imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Activation Lock');
                   $x += 400;
		}

                //$x = 75;
                //$y += 65;

                if ($data['boot_failure'] == 1){
                         imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Logic Failure');
                }

            }


            $filename = $tmp_path.$this->genRandomString(10).'.png';
            imagepng($image,$filename);

            $this->send_printer($printer, $filename);

            //tidy up
            imagedestroy($image);
            unlink($filename);

        }

        public function print_audit_label($data,$printer){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $font = 'arial.ttf';

            $fontname = $fontpath.$font;

            $fontsize = 20;

            $image = imagecreate(406, 203);
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);

            if (!$data['is_ipad']){
                $x = 20;
                $y = 50;
                //write text
                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Grd: '.$data['grade']);

                $x += 170;

                if ($data['top_case'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+40, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'TC');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'TC');
                }

                $x += 70;

                if ($data['display_housing'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+45, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'DH');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'DH');
                }

                $x += 70;

                if ($data['bottom_case'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+45, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'BC');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'BC');
                }

                $hdstr = $data['hd'];

                $x = 20;
                $y += 40;

                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'HDs: '.$hdstr);

                $x += 170;

                if ($data['keys'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+50, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Key');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Key');
                }

                $x += 70;

                if ($data['hinge'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+40, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Hin');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Hin');
                }

                $x += 70;

                if ($data['optical'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+50, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Opt');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Opt');
                }

                $ramstr = $data['ram'];

                $x = 20;
                $y += 40;

                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Ram: '.$ramstr);

                $x += 170;

                if ($data['lcd'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+60, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'LCD');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'LCD');
                }

                $x += 70;

                if ($data['wifi'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+50, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Wifi');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Wifi');
                }

                $x += 70;

                if ($data['speakers'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+30, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, '♫');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, '♫');
                }

                $x = 20;
                $y += 40;

                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'OS: '.$data['os_version']);

                $x += 170;

                if ($data['battery'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+45, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Bat');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Bat');
                }

                $x += 70;

                if ($data['isight'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+40, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'iSit');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'iSit');
                }

                $x += 70;

                if ($data['enet'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+60, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Enet');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Enet');
            }
            }else{
                $x = 20;
                $y = 50;
                //write text
                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Grd: '.$data['grade']);

                $x += 130;

                if ($data['lcd'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+45, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Lcd');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Lcd');
                }

                $x += 90;

                if ($data['digitizer_scratch'] == 1 || $data['digitizer_crack'] == 1){
                    imagefilledrectangle($image, $x-5, $y+5, $x+50, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Digi');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Digi');
                }

                $x += 90;

                if ($data['case_scratch'] == 1 || $data['case_crack'] || $data['case_dent']){
                    imagefilledrectangle($image, $x-5, $y+5, $x+65, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Case');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Case');
                }

                $hdstr = $data['hd'];

                $x = 20;
                $y += 40;

                imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'OS: '.$data['os_version']);

                $x += 130;

                if ($data['charge'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+75, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Charg');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Charg');
                }

                $x += 90;

                if ($data['sleep_wake'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+75, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Sleep');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Sleep');
                }

                $x += 90;

                if ($data['mic'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+50, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Mic');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Mic');
                }

                $x = 20;
                $y += 40;

                if ($data['home_button'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+75, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Home');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Home');
                }

                $x += 100;

                if ($data['volume'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+80, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Volme');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Volme');
                }

                $x += 100;

                if ($data['silent_rot'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+75, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Silent');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Silent');
                }

                $x += 100;

                if ($data['headphone'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+80, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'H-jack');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'H-jack');
                }

                $x = 20;
                $y += 40;

                if ($data['wifi'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+70, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Wi-Fi');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Wi-Fi');
                }

                $x += 100;

                if ($data['front_camera'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+85, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'F-Cam');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'F-Cam');
                }

                $x += 100;

                if ($data['rear_camera'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+85, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'B-Cam');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'B-Cam');
                }

                $x += 100;

                if ($data['speaker'] == 'fail'){
                    imagefilledrectangle($image, $x-5, $y+5, $x+60, $y-25, $text_color);
                    imagettftext($image, $fontsize, 0, $x, $y, $background_color, $fontname, 'Spkr');
                }else{
                    imagettftext($image, $fontsize, 0, $x, $y, $text_color, $fontname, 'Spkr');
                }

            }

            $filename = $tmp_path.$this->genRandomString(10).'.png';
            imagepng($image,$filename);

            $this->send_printer($printer, $filename);

            //tidy up
            imagedestroy($image);
            unlink($filename);


        }

        private function wrap($fontSize, $angle, $fontFace, $string, $width){

            $ret = "";

            $arr = explode(' ', $string);

            foreach ( $arr as $word ){

                $teststring = $ret.' '.$word;
                $testbox = imagettfbbox($fontSize, $angle, $fontFace, $teststring);
                if ( $testbox[2] > $width ){
                    $ret.=($ret==""?"":"\n").$word;
                } else {
                    $ret.=($ret==""?"":' ').$word;
                }
            }

            return $ret;
        }

        function print_refurb_label($data,$printer){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $font = 'arialbd.ttf';

            $fontname = $fontpath.$font;

            $image = imagecreate(406, 203);
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);

            //ONUM

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['oNum']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor((203/8)-($size[5]/2))+25;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['oNum']);

            //create default box
            $size = imagettfbbox(20, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor(((203/8)*3)-($size[5]/2))+25;
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');

            //DATE #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['short_date']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['short_date']);
            if ($size[5] < -160){
                $fontsize = floor($fontsize * (163 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['short_date']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor((203/4)-($size[5]/2))+100;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['short_date']);

            //ASSET #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['asset']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['asset']);
            if ($size[5] < -160){
                $fontsize = floor($fontsize * (163 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['asset']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor((203/4)-($size[5]/2))+152;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['asset']);

            //PO #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['poNumber']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['poNumber']);
            if ($size[5] < -160){
                $fontsize = floor($fontsize * (163 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['poNumber']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor((203/4)-($size[5]/2))+210;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['poNumber']);

            //SERIAL #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['serialNumber']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['serialNumber']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['serialNumber']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor((203/8)-($size[5]/2))+278;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['serialNumber']);

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['grade']);
            //calulate font size
            $fontsize = floor(10 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['grade']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['grade']);
            }
            //calculate coordinates
            $y = floor((203 + $size[2])/2);
            $x = floor(((203/8)*3)-($size[5]/2))+278;
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname,$data['grade']);

            $filename = $tmp_path.$this->genRandomString(10).'.png';
            imagepng($image,$filename);

            $this->send_printer($printer, $filename);

            //tidy up
            imagedestroy($image);
            unlink($filename);

        }

        function print_retail_label($data,$printer,$copies){

            global $ramvolumes, $hdvolumes;

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $fontbold = 'arialbd.ttf';
            $font = 'arial.ttf';

            $fontboldname = $fontpath.$fontbold;
            $fontname = $fontpath.$font;

            $image = imagecreate(812, 406);
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);

            $x = 50;
            $y = 70;

            imagettftext($image, 30, 0, $x, $y, $text_color, $fontboldname, $data['asset']);

            $x = 380;

           imagettftext($image, 20, 0, $x, $y, $text_color, $fontboldname, $data['machineType']);

           $x = 50;
           $y = 150;

           if ($data['is_ipad'] != 1){

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontboldname, 'RAM:');

                $ram = ($ramvolumes[$data['ram_1']] + $ramvolumes[$data['ram_2']] + $ramvolumes[$data['ram_3']] + $ramvolumes[$data['ram_4']])/1024;

                $x = 170;

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontname, $ram.'GB');

                $x = 320;

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontboldname, 'HD:');

                $hd = $hdvolumes[$data['hd_1']] + $hdvolumes[$data['hd_2']];

                $x = 400;

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontname, $hd.'GB');

           }else{

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontboldname, 'CAPACITY:');

                $x = 270;

                imagettftext($image, 30, 0, $x, $y, $text_color, $fontname, $data['capacity']);
           }

           $x = 50;
           $y = 200;

           imagettftext($image, 30, 0, $x, $y, $text_color, $fontboldname, 'SN:');

           $x = 130;

           imagettftext($image, 30, 0, $x, $y, $text_color, $fontname, $data['serialNumber']);

           $x = 50;
           $y = 260;

           imagettftext($image, 40, 0, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');

           $x = 50;
           $y = 300;

           imagettftext($image, 30, 0, $x, $y, $text_color, $fontname, $data['oNum']);

           $x = 50;
           $y = 350;

           imagettftext($image, 40, 0, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');

		   $x = 700;

           imagettftext($image, 20, 0, $x, $y, $text_color, $fontboldname, date('Y-m-d'));

           $filename = $data['oNum'].'.png';
           imagepng($image,$tmp_path.$filename);

           for ($i=1;$i<=$copies;$i++){
                $this->send_printer($printer, $tmp_path.$filename);
           }

           //tidy up
           imagedestroy($image);
           unlink($tmp_path.$filename);

           //return $filename;

        }

        /*function print_refurb_label_large($data,$printer){

            $fontpath = FONT_PATH;

            $tmp_path = LABEL_TEMP_DIR;

            $font = 'arialbd.ttf';

            $fontname = $fontpath.$font;

            $image = imagecreate(812, 406);
            $background_color = imagecolorallocate($image, 255, 255, 255);
            $text_color = imagecolorallocate($image, 0, 0, 0);

            //ONUM

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['oNum']);
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['oNum']);
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor((203/4)-($size[5]/2))+50;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['oNum']);

            //create default box
            $size = imagettfbbox(20, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor(((203/4)*3)-($size[5]/2))+50;
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['oNum'].'*');

            //ASSET #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['asset']);
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['asset']);
            if ($size[5] < -160){
                $fontsize = floor($fontsize * (163 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['asset']);
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor((203/2)-($size[5]/2))+303;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['asset']);

            //SERIAL #

            //create default box
            $size = imagettfbbox(20, 0, $fontname, $data['serialNumber']);
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontname, $data['serialNumber']);
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontname, $data['serialNumber']);
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor((203/4)-($size[5]/2))+556;
            //write text
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontname, $data['serialNumber']);

            //create default box
            $size = imagettfbbox(20, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            //calulate font size
            $fontsize = floor(20 * (366 / $size[2]));
            $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            if ($size[5] < -80){
                $fontsize = floor($fontsize * (80 / ($size[5]/-1)));
                $size = imagettfbbox($fontsize, 0, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
            }
            //calculate coordinates
            $y = floor((406 + $size[2])/2);
            $x = floor(((203/4)*3)-($size[5]/2))+556;
            imagettftext($image, $fontsize, 90, $x, $y, $text_color, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');

            $filename = $tmp_path.$this->genRandomString(10).'.png';
            imagepng($image,$filename);

            $this->send_printer($printer, $filename);

            //tidy up
            imagedestroy($image);
            //unlink($filename);

        }*/

	function print_rack_tag($data){

		$dpi = 600;

		$width = 8.5*$dpi;
		$height = 11*$dpi;
		$image = imagecreate($width, $height);

		$fontpath = FONT_PATH;

		$tmp_path = LABEL_TEMP_DIR;

		$font = 'arial.ttf';
		$fontbold = 'arialbd.ttf';

		$fontname = $fontpath.$font;
		$fontnamebold = $fontpath.$fontbold;

		imagecolorallocate($image, 255, 255, 255);
		$text_color = imagecolorallocate($image, 0, 0, 0);

		$size = imagettfbbox($height/33, 0, $fontnamebold,$data['account_name']);
		$x = $width/2 - $size[2]/2;
		$y = $height/6;
		imagettftext($image, $height/33, 0, $x, $y, $text_color, $fontnamebold, $data['account_name']);

		$size = imagettfbbox($height/33, 0, $fontnamebold,$data['order_number']);
		$x = $width/2 - $size[2]/2;
		$y = $height/4;
		imagettftext($image, $height/33, 0, $x, $y, $text_color, $fontnamebold, $data['order_number']);

		$x = $width/4;
		$y = ($height/32)*11;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'MACBOOK');

		if ($data['qty_macbook'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_macbook']);
		}

		$x = $width/4;
		$y = ($height/32)*12.5;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'IMAC');

		if ($data['qty_imac'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_imac']);
		}

		$x = $width/4;
		$y = ($height/32)*14;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'MACBOOK PRO');

		if ($data['qty_macbook_pro'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_macbook_pro']);
		}

		$x = $width/4;
		$y = ($height/32)*15.5;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'MACBOOK AIR');

		if ($data['qty_macbook_air'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_macbook_air']);
		}

		$x = $width/4;
		$y = ($height/32)*17;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'MAC MINI');

		if ($data['qty_mac_mini'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_mac_mini']);
		}

		$x = $width/4;
		$y = ($height/32)*18.5;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'IPAD');

		if ($data['qty_ipad'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_ipad']);
		}

		$x = $width/4;
		$y = ($height/32)*20;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'OTHER');

		if ($data['qty_other'] > 0){
			$x = ($width/25)*16;
			imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,$data['qty_other']);
		}

		$x = ($width/25)*3;
		$y = ($height/32)*23;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'Rack '.$data['rack_no'].' of '.$data['rack_count']);

		$x = ($width/25)*13;
		$y = ($height/32)*23;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname,'Received '.$data['date_received']);


		$x = ($width/25)*4;
		$y = ($height/32)*25;
		imagettftext($image, $height/25, 0, $x, $y, $text_color, $fontname, '□');

		$x = ($width/25)*6;
		$y = ($height/32)*25;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, 'Cleaned');

		$x = ($width/25)*12;
		$y = ($height/32)*25;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*18;
		$y = ($height/32)*25;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*4;
		$y = ($height/32)*26.5;
		imagettftext($image, $height/25, 0, $x, $y, $text_color, $fontname, '□');

		$x = ($width/25)*6;
		$y = ($height/32)*26.5;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, 'Imaged');

		$x = ($width/25)*12;
		$y = ($height/32)*26.5;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*18;
		$y = ($height/32)*26.5;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*4;
		$y = ($height/32)*28;
		imagettftext($image, $height/25, 0, $x, $y, $text_color, $fontname, '□');

		$x = ($width/25)*6;
		$y = ($height/32)*28;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, 'Audited');

		$x = ($width/25)*12;
		$y = ($height/32)*28;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*18;
		$y = ($height/32)*28;
		imagettftext($image, $height/40, 0, $x, $y, $text_color, $fontname, '______');

		$x = ($width/25)*12;
		$y = ($height/32)*29;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname, 'Initials');

		$x = ($width/25)*18;
		$y = ($height/32)*29;
		imagettftext($image, $height/50, 0, $x, $y, $text_color, $fontname, 'Date');

		$filename = $tmp_path.$this->genRandomString(10).'.png';
		imagepng($image,$filename);

		//print the image
		$this->send_printer(WAREHOUSE_PRINTER, $filename);

		//tidy up
		imagedestroy($image);
		unlink($filename);

	}
	/**
	 * Normalizes processor names to an abbreviated, standardized format.
	 *
	 * Processor names are standardized to an abbreviated format removing the manufacturer name and
	 * reducing them to just their identifying elements. Processor names with core number specified
	 * as 'dual' or 'quad' and so on have those elements replaced with their numerical
	 * representations.
	 *
	 * @since 2.4.05
	 *
	 * @param string $processorName Processor name from system profiler DB.
	 * @return string Normalized, abbreviated processor name.
	 */
	function normalize_processor_name($processorName) {
		$search = array('Dual', 'Quad', 'Octa', 'Intel ');
		$replace = array('2', '4', '8', '');
		return str_replace($search, $replace, $processorName);
	}

	//print diagnostic summary
	function print_diagnostic($oNum,$data,$isprevious){

		global $cartObj;

		//get the cart data
		$cartitems = $cartObj->get_data($oNum);

		$fontpath = FONT_PATH;

		$tmp_path = LABEL_TEMP_DIR;

		$font = 'arial.ttf';
		$fontbold = 'arialbd.ttf';

		$fontname = $fontpath.$font;
		$fontnamebold = $fontpath.$fontbold;

		//create the image
		$image = imagecreate(812, 1218);

		//get the checked/unchecked graphics
		$imgchecked = imagecreatefromjpeg(HTML_FOLDER.'images/checkbox.gif');
		$imgunchecked = imagecreatefromgif(HTML_FOLDER.'images/checkbox-unchecked.gif');

		$imgchecked_size = getimagesize(HTML_FOLDER.'images/checkbox.gif');
		$imgunchecked_size = getimagesize(HTML_FOLDER.'images/checkbox-unchecked.gif');

		//set background and text colors
		$background_color = imagecolorallocate($image, 255, 255, 255);
		$text_color = imagecolorallocate($image, 0, 0, 0);

		//order number
		imagettftext($image, 120, 0, 30, 140, $text_color, $fontname, $oNum);

		//date
		imagettftext($image, 60, 0, 30, 240, $text_color, $fontname, date('m/d'));

		//AppleCare
		imagettftext($image, 30, 0, 300, 230, $text_color, $fontnamebold, 'AC');
		if ($data['oWarranty'] == 'Y'){
			imagecopy($image, $imgchecked, 370, 210, 0, 0, $imgchecked_size[0], $imgchecked_size[1]);
		}else{
			imagecopy($image, $imgunchecked, 370, 210, 0, 0, $imgunchecked_size[0], $imgunchecked_size[1]);
		}

		//Previous
		imagettftext($image, 30, 0, 440, 230, $text_color, $fontnamebold, 'PR');
		if ($isprevious){
			imagecopy($image, $imgchecked, 510, 200, 0, 0, $imgchecked_size[0], $imgchecked_size[1]);
		}else{
			imagecopy($image, $imgunchecked, 510, 210, 0, 0, $imgunchecked_size[0], $imgunchecked_size[1]);
		}

		//RMA
		imagettftext($image, 30, 0, 580, 230, $text_color, $fontnamebold, 'RMA');
		if ($data['oRMA'] == 'Y'){
			imagecopy($image, $imgchecked, 680, 210, 0, 0, $imgchecked_size[0], $imgchecked_size[1]);
		}else{
			imagecopy($image, $imgunchecked, 680, 210, 0, 0, $imgunchecked_size[0], $imgunchecked_size[1]);
		}

		//Organisation
		if ($data['cBillCompany'] != ''){
			imagettftext($image, 40, 0, 30, 320, $text_color, $fontnamebold, $data['cBillCompany']);
		}else{
			imagettftext($image, 40, 0, 30, 320, $text_color, $fontnamebold, $data['cBillFname'].' '.$data['cBillLname']);
		}

		//SN & Barcode
		if ($data['serialNumber'] != ''){
			imagettftext($image, 36, 0, 30, 410, $text_color, $fontpath.'3OF9.ttf', '*'.$data['serialNumber'].'*');
			imagettftext($image, 36, 0, 420, 410, $text_color, $fontnamebold, $data['serialNumber']);
		}

		//Cart Items
		$offset = 500;
		foreach ($cartitems as $item){
			if ($item['pNum'] != 'Free Diagnostic'){
				$pstring = $item['pNum'].' - '.substr($item['pName'],0,40);
				imagettftext($image, 24, 0, 30, $offset, $text_color, $fontnamebold, $pstring);

				$offset += 50;
			}

		}

		//Notes
		imagettftext($image, 24, 0, 30, $offset, $text_color, $fontnamebold, 'Notes:');

		$offset += 50;

		$notes = wordwrap($data['problem'],60);
		imagettftext($image, 18, 0, 30, $offset, $text_color, $fontnamebold, $notes);

		//Ship Service
		if (strlen($data['cShipService']) <= 30){
			imagettftext($image, 40, 0, 30, 1190, $text_color, $fontnamebold, $data['cShipService']);
		}else{
			imagettftext($image, 30, 0, 30, 1190, $text_color, $fontnamebold, $data['cShipService']);
		}

		//create the image
		$filename = $tmp_path.$this->genRandomString(10).'.png';
		imagepng($image,$filename);

		//print the image
		$this->send_printer(UPS_LABEL_PRINTER, $filename);

		//tidy up
		imagedestroy($image);
		unlink($filename);
	}

	/**
	 * Determines if the given field name is an iPad field.
	 * @param string $str The field name to check
	 * @return bool true if ipad field, else false
	 */
	function is_ipad_field($str) {
		$ipadFieldsArray = array(
			'case_scratches',
			'case_cdents',
			'case_sdents',
			'case_edents',
			'digi_scratches',
			'lcd_white',
			'lcd_dust',
			'digi_dis',
			'digi_sep',
			'digi_un',
			'digi_lines',
			'digi_touch',
			'digi_video',
			'capacity',
			'logic_failure_ipad',
			'home_button',
			'volume',
			'sleep_wake',
			'silent_rot',
			'headphone',
			'front_camera',
			'rear_camera',
			'speaker',
			'mic',
			'charge',
			'ios_version'
		);

		return ($this->is_both_field($str) || in_array(trim($str), $ipadFieldsArray));
	}

	/**
	 * Determines if the given field name is a Mac field.
	 * @param string $str The field name to check.
	 * @return bool true if a mac field, else false.
	 */
	function is_mac_field($str) {
		$macFieldArray = array(
			'case_scratches2',
			'case_cracks',
			'case_sdents2',
			'case_cdents2',
			'refurb_keys',
			'case_Track',
			'lcd_scratches',
			'case_keymarks',
			'digi_lines',
			'digi_white',
			'digi_dis',
			'digi_video',
			'hinge',
			'hd_1',
			'hd_2',
			'ram_1',
			'ram_2',
			'ram_3',
			'ram_4',
			'hd_failure',
			'logic_failure_osx',
			'keyboard',
			'trackpad',
			'optical',
			'lcd',
			'glass',
			'enet',
			'ports',
			'speakers',
			'battery',
			'battery_cycles',
			'battery_mah',
			'isight',
		);

		return ($this->is_both_field($str) || in_array(trim($str), $macFieldArray));
	}

	/**
	 * Determines if the given field name is a universal field.
	 * @param string $str The field name to check.
	 * @return bool true if a universal field, else false.
	 */
	function is_both_field($str) {
		$bothFieldArray = array(
			'grade',
			'grade_at_audit',
			'machineType',
			'asset',
			'poNumber',
			'marking',
			'digitizer_crack',
			'wifi',
			'os_version',
			'boot_failure',
			'dateMachineReceived',
			'activation_lock',
			'mdm_lock',
		);

		return in_array(trim($str), $bothFieldArray);
	}

	/**
	 * Determines if a field is an activation lock status field.
	 */
	function is_activation_status_field($str) {
		$activationStatusField = array(
			'mdm_lock',
			'activation_lock'
		);

		return in_array(trim($str), $bothFieldArray);
	}

	/**
	 * Corrects form field names to align with the names as defined in the database table ds_orders.
	 */
	function correct_field_name($str) {
		if (strtolower(trim($str)) == 'ios_version') {
			return 'os_version';
		} elseif (strtolower(trim($str)) == 'logic_failure_osx' || strtolower(trim($str)) == 'logic_failure_ipad') {
			return 'boot_failure';
		} else {
			return $str;
		}
	}

	/**
	 * Converts field values to their numerical representation. on -> 1, off -> 0, else return input string as is
	 */
	function correct_field_value($str) {
		if (strtolower(trim($str)) == 'on') {
			return 1;
		} elseif (strtolower(trim($str)) == 'off') {
			return 0;
		} else {
			return $str;
		}
	}


	/**
	 * Returns 1 if is a SP number, else 0
	 */
	protected function isSPNum($str) {
		return preg_match('/^(SP\d{6})$/', $str);
	}

	function divideSPAndSerialNums($inputNumbers,& $oNums=array(),& $serialNums=array()) {
		foreach ($inputNumbers as $inputNumber) {
			if ($this->isSPNum(trim($inputNumber)) == 1) {
				array_push($oNums, trim($inputNumber));
			} else {
				array_push($serialNums, trim($inputNumber));
			}
		}
	}

	// Start of SQL query building helper functions.

	/**
	 * Builds a string from the array for use in an IN clause in a SQL query. @param arr Array from which to build the string. @return string
	 */
	function build_in_clause($arr) {
		$str = '(';
		for($i = 0; $i < count($arr); $i++) {
			$str .= "'".trim($arr[$i])."'";
			if ($i < count($arr) - 1) {
				$str .= ", ";
			}
		}
		$str .= ')';
		return $str;
	}

	/**
	 * Builds a string from the given array listing all the fields to be affected in a given query. @return string
	 */
	function build_fields_clause($arr) {
		$str = '(';
		for($i = 0; $i < count($arr); $i++) {
			$str .= $arr[$i];
			if ($i < count($arr) - 1) {
				$str .= ", ";
			}
		}
		$str .= ')';
		return $str;
	}

	/**
	 * Builds the SET clause of a SQL query using an associative array's key-value pairing.
	 */
	function build_update_set_clause($arr) {
		$str = '';
		$i = 0;
		foreach($arr as $k => $v) {
			if ($i) {
				$str .= ", ";
			}
			if (is_numeric($v) && $k != 'os_version') {
				$str .= "$k = $v";
			} else {
				$str .= "$k = '$v'";
			}
			$i++;
		}
		return $str;
	}

	function getRealSku($skuString) {
		$specialPattern = '/(-\d{1,3}\/\d{1,6})$/';
		if (preg_match($specialPattern, $skuString)) {
			$breakLoc = strrpos($skuString, '-');
			$assetNum = substr($skuString, 0, $breakLoc);
			return $assetNum;
		} else {
			return $skuString;
		}
	}

	function startsWith($string, $startString) {
		$len = strlen($startString);
		return (substr($string, 0, $len) === $startString);
	}

	function endsWith($string, $endString) {
		$len = strlen($endString);
		if ($len == 0) {
			return true;
		}
		return (substr($string, -$len) === $endString);
	}

	function decodeSanitizedString($string) {
		$replaceVals = array(
			'TTS_NUM' => '#',
			'TTS_AMP' => '&',
			'TTS_QST' => '?'
		);
		foreach($replaceVals as $toReplace => $replaceWith) {
			$string = str_replace($toReplace, $replaceWith, $string);
		}
		return $string;
	}

	function safe_json_encode($data) {
		$json = json_encode($data);
		if ($json) {
			return $json;
		}
		else {
			if (json_last_error() == 5) {
				foreach ($data as $k1 => $v1) {
					if (is_array($data[$k1])) {
						foreach ($data[$k1] as $k2 => $v2) {
							$data[$k1][$k2] = mb_convert_encoding($data[$k1][$k2], "UTF-8", "ISO-8859-1");
						}
					} else {
						$data[$k1] = mb_convert_encoding($data[$k1], "UTF-8", "ISO-8859-1");
					}
				}
				$json = json_encode($data);
				return $json;
			}
		}
	}

	public function getOneMonthAgoDate() {
		$currentDateTime = new DateTime('now', new DateTimeZone('UTC'));
		$currentMonth = $currentDateTime->format('m');
		$day = $currentDateTime->format('d');
		$lastYear = $currentDateTime->format('Y');
		$lastMonth = (int)$currentMonth - 1;
		if ($lastMonth == 1) {
			$lastMonth = '12';
			$lastYear = strval((int)$lastYear-1);
		}
		elseif ($lastMonth < 10) {
			$lastMonth = "0$lastMonth";
		}
		$lastMonth = strval($lastMonth);
		return "$lastYear-$lastMonth-$day";
	}

	/**
	* Pause processing until the specified time, to avoid hammering a DB or service
	*
	* @param int $target_time Timestamp
	* @param int $min_sleep Always sleep for a minimum number of seconds,
	*    even if the target timestamp has already passed.
	*     Default 0, meaning only sleep until the target timestamp is reached.
	*
	* @example <code>
	*	while ( ! $finished )
	*	{
	*		$minimum_start_of_next_loop = time() + $min_secs_per_loop;
	*
	*		# DO STUFF THAT MAY OR MAY NOT TAKE VERY LONG
	*
	*		self::sleep_until( $minimum_start_of_next_loop, $min_pause_between_loops );
	*	}
	*	</code>
	*/
	public static function sleep_until($target_time, $min_sleep = 0) {
		$time_now = time();

		$time_to_target = $target_time - $time_now;

		// If we've already reached the target time, that's fine
		if ( $time_to_target <= $min_sleep )
		{
			// If required, sleep for a bit anyway
			sleep( $min_sleep );
		}
		else
		{
			// Sleep for the number of seconds until the target time
			sleep( $time_to_target );
		}
	}
}

?>
