<?php

/**
 * E-Commerce controller class. Extends Database.
 */
class ECom extends Database
{
	/**
	 * Sets the number of rows to display on the ecommerce checkout page.
	 */
	private $numRows = 1;
	/**
	 * Echos ecom checkout form.
	 */
	function ecom_checkout_page()
	{
		// $shippers = array(
		// 	'Central',
		// 	'Dayton',
		// 	'Dependable Highway',
		// 	'DotLine',
		// 	'Estes',
		// 	'Fedex LTL',
		// 	'Forward Air',
		// 	'GlobalTranz Freight',
		// 	'JTS Express',
		// 	'Local Pickup',
		// 	'New Penn',
		// 	'Numark',
		// 	'Oak Harbor',
		// 	'R & L Carriers',
		// 	'Reddaway',
		// 	'UPS',
		// 	'T-Force (formerly UPS Freight)',
		// 	'USPS',
		// 	'Ward',
		// 	'XPO',
		// 	'YRC'
		// );
		$shippers = self::getShippers();

		// Generate header row
		$output = '
			<tr>
				<td><strong>Order #</strong></td>
				<td><strong>SP Numbers</strong></td>
				<td><strong>Tracking Numbers</strong></td>
				<td><strong>Ship Date</strong></td>
				<td><strong>Ship Method (For MTS/TTS Only)</strong></td>
				<td><input type="submit" id="submit" name="submit" value="Submit" /></td>
				<td><a href="' . CONTROLLER . '?m=editFreightCarriers" target="_blank">View/Edit Freight Carriers</a></td>
			</tr>
		';
		if ($this->numRows > 1) {
			$output .= '
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td><p style="margin:0;">Set All:</p><input type="date" id="set_all_date" onchange="setAllDates(this)" value="' . date('Y-m-d') . '" /></td>
				</tr>
			';
		}

		// Generate input rows
		for ($x = 0; $x < $this->numRows; $x++) {
			$output .= '<tr valign="top">';
			$output .= '<td><input inputrow="' . strval($x) . '" class="order_number_input" name="order_number_' . strval($x) . '" id="order_number_' . strval($x) . '"/></td>';
			$output .= '<td><textarea rows="2" inputrow="' . strval($x) . '" class="sp_number_input" name="sp_numbers_' . strval($x) . '" id="sp_numbers_' . strval($x) . '"></textarea></td>';
			$output .= '<td><textarea rows="2" inputrow="' . strval($x) . '" class="tracking_number_input" name="tracking_numbers_' . strval($x) . '" id="tracking_numbers_' . strval($x) . '"></textarea></td>';
			$output .= '<td><input inputrow="' . strval($x) . '" type="date" class="shipping_date_input" name="shipping_date_' . strval($x) . '" id="shipping_date_' . strval($x) . '" value="' . date('Y-m-d') . '"/></td>';
			$output .= '<td><select inputrow="' . strval($x) . '" disabled class="shipping_method_select" name="shipping_method_' . strval($x) . '" id="shipping_method_' . strval($x) . '">';
			$output .= '<option selected disabled>Select</option>';
			foreach ($shippers as $shipper) {
				$shipperId = $shipper->id;
				$shipperName = $shipper->name;
				$output .= "<option>$shipperName</option>";
			}
			$output .= '</select></td>';
			$output .= '</tr>';
		}
		$templateElements = array(
			'INPUTS' => $output,
			'LOADING_MODAL' => LOADING_MODAL
		);
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ECOMMERCE_CHECKOUT, $templateElements), "TITLE" => "Order Checkout"));
	}
	/**
	 * Handles database entry for ecom checkout.
	 *
	 * Changes SP number status to Refurb - Complete, and adds the associated order number and tracking numbers.
	 *
	 */
	function ecom_checkout_submit()
	{
		global $backmarketObj;
		$mtsCheckoutOrders = array();
		$backMarketOrders = array();
		$ebayOrders = array();
		$neweggOrders = array();
		$amazonOrders = array();
		$checkoutSPArray = array();
		for ($i = 0; $i < $this->numRows; $i++) {
			if ($_POST['order_number_' . $i]) {
				$orderNum = $_POST['order_number_' . $i];
				$spNums = explode(PHP_EOL, $_POST['sp_numbers_' . $i]);
				$trackingNums = explode(PHP_EOL, trim($_POST['tracking_numbers_' . $i]));

				$shipDateTime = DateTime::createFromFormat('Y-m-d', $_POST["shipping_date_$i"], new DateTimeZone('America/New_York'));
				// $shipDate = $shipDateTime->format('Y-m-d H:i:s');
				// echo $shipDate;
				// exit;
				$shipDate = $_POST['shipping_date_' . $i];
				$shipMethod = $_POST["shipping_method_$i"];
				if ($this->is_mts_order(trim($orderNum)) == 1) {
					$mtsCheckoutOrders[$orderNum] = array(
						'orderNum' => $orderNum,
						'spNums' => $spNums,
						'trackingNums' => $trackingNums,
						'shipDate' => $shipDate,
						'shipMethod' => $shipMethod
					);
				} else if ($backmarketObj->isBackMarketOrder(trim($orderNum))) {
					$firstSpNum = $spNums[0];
					$sql = "SELECT dso.serialNumber FROM ds_orders AS dso WHERE dso.oNum = '$firstSpNum' ORDER BY dso.oID DESC LIMIT 1";
					$returnedData = $this->db_query($sql, 'select-single', true);
					$serialNumber = $returnedData['serialNumber'];
					$firstTrackingNum = $trackingNums[0];
					$backMarketOrders[$orderNum] = array(
						'order_id' => $orderNum,
						'serial_number' => $serialNumber,
						'tracking_number' => $firstTrackingNum,
						'tracking_numbers' => $trackingNums,
						'shipper' => $shipMethod
					);
				} else if ($this->isEbayOrder($orderNum)) {
					$ebayOrders[$orderNum] = array(
						'order_id' => $orderNum,
						'spNums' => $spNums,
						'trackingNums' => $trackingNums,
						'shipDate' => $shipDateTime->format('Y-m-d H:i:s'),
						'shipMethod' => $shipMethod
					);
				} else if ($this->isNeweggOrder($orderNum)) {
					$neweggOrders[$orderNum] = array(
						'order_id' => $orderNum,
						'spNums' => $spNums,
						'trackingNums' => $trackingNums,
						'shipDate' => $shipDateTime->format('Y-m-d H:i:s'),
						'shipMethod' => $shipMethod
					);
				} else if ($this->isAmazonOrder($orderNum)) {
					$amazonOrders[$orderNum] = array(
						'order_id' => $orderNum,
						'spNums' => $spNums,
						'trackingNums' => $trackingNums,
						'shipDate' => $shipDateTime->format('Y-m-d H:i:s'),
						'shipMethod' => $shipMethod
					);
				}
				// echo('<p>'.$_POST['sp_numbers_'.$i].'</p>');
				foreach ($spNums as $spNum) {
					$checkoutSPArray[trim($spNum)] = 'PO number: ' . $orderNum . PHP_EOL;
					$checkoutSPArray[trim($spNum)] .= 'Tracking numbers:';
					foreach ($trackingNums as $trackingNum) {
						$checkoutSPArray[trim($spNum)] .= PHP_EOL . trim($trackingNum);
					}
					$checkoutSPArray[trim($spNum)] .= PHP_EOL . 'Ship date: ' . trim($shipDate);
				}
				// Delete from pending UPS shipment data.
				$sql = "DELETE FROM ups_pending_orders WHERE order_number = '$orderNum';";
				$this->db_query($sql, 'delete', true);
			}
		}
		if (count($mtsCheckoutOrders) > 0) {
			$zohoInvoices = $this->getZohoInvoiceNums();
			$this->mtsOrderCheckout($mtsCheckoutOrders, $zohoInvoices);

			// Send to device
			require_once(HTML_FOLDER . "class_cron.php");
			$cronObj = new Cron;
			$argv = array();
			// $argv[3] = $shipDateTime->format('Y-m-d');
			// $argv[4] = $shipDateTime->format('Y-m-d');
			$cronObj->orderExportsNew($argv);
		}
		if (count($backMarketOrders) > 0) {
			foreach ($backMarketOrders as $bmOrder) {
				$this->backMarketCheckout($bmOrder);
			}
		}
		if (count($ebayOrders) > 0) {
			foreach ($ebayOrders as $ebayOrder) {
				$this->eBayCheckout($ebayOrder);
			}
		}
		if (count($neweggOrders) > 0) {
			foreach ($neweggOrders as $neweggOrder) {
				$this->neweggCheckout($neweggOrder);
			}
		}
		if (count($amazonOrders) > 0) {
			foreach ($amazonOrders as $amazonOrder) {
				$this->amazonCheckout($amazonOrder);
			}
		}
		if (count($checkoutSPArray) > 0) {
			$updateQuery = $this->buildCheckoutUpdateQuery($checkoutSPArray);
			$insertQuery = $this->buildOrderLogInsertQuery($checkoutSPArray, STATUS_REFURB_COMPLETE);
			$this->db_query($updateQuery, 'update', true);
			if ($insertQuery !== FALSE) {
				$this->db_query($insertQuery, 'insert', true);
			}
		}
		header('Location: ' . CONTROLLER . '?m=ecommerce_checkout');
	}

	function mtsOrderCheckout($orders, $invoices)
	{
		global $zohoObj, $zoho_auth_tokens;
		$otherInvoices = array();
		$allSPNums = $this->associateSPNumsAndOrderNumsArray($orders, $invoices, $otherInvoices);
		$mtsCheckoutUpdateQuery = $this->buildMTSCheckoutUpdateQuery($allSPNums);
		$mtsCheckoutInsertLogQuery = $this->buildMTSCheckoutLogInsertQuery($allSPNums);
		if ($mtsCheckoutUpdateQuery) {
			$this->db_query($mtsCheckoutUpdateQuery, 'update', true);
		}
		if ($mtsCheckoutInsertLogQuery) {
			$this->db_query($mtsCheckoutInsertLogQuery, 'insert', true);
		}
		$invoices = array_merge($invoices, $otherInvoices);
		// After this point, ds_orders MTS database queries are complete and it is time to move on to zoho queries
		foreach ($orders as $order) {
			$spInfo = $this->getOrderSPInfo($order['spNums']);
			$assets = array();
			$serialNums = array();
			foreach ($spInfo as $sp) {
				array_push($serialNums, $sp['serialNumber']);
			}

			$invoiceId = '';
			foreach ($invoices as $key => $invoiceName) {
				if (substr($invoiceName, 0, 8) == $order['orderNum'])
					$invoiceId = $key;
			}
			//get user prefix
			$prefix = substr($invoiceId, 0, 1);
			//get zoho record id
			$zoho_id = substr($invoiceId, 1);
			if (!$zoho_id) {
				echo "<p>No zoho ID, getting.</p>";
				$zoho_id = $zohoObj->getRecordIdByMtsNumber($order['orderNum']);
				echo "<p>Got zoho id: $zoho_id</p>";
			}
			//determine user prefix and retrieve correct authtoken
			foreach ($zoho_auth_tokens as $k => $v) {
				if ($v['prefix'] == $prefix) {
					$authtoken = $v['authtoken'];
				}
			}
			$serial_numbers_string = implode(' ', $serialNums);

			if (MODE == 'PROD') {
				// //insert ship method
				$zohoObj->update_record_admin_4($zoho_id, array('Ship_Method' => $order['shipMethod']));
				if ($serial_numbers_string) {
					$zohoObj->update_record_admin_4($zoho_id, array('Serial_Number' => $serial_numbers_string));
				}
				// //add ship date
				$zohoObj->update_record_admin_4($zoho_id, array('Ship_Date' => $order['shipDate']));
				foreach ($order['trackingNums'] as $key => $value) {
					$index = $key + 1;
					$zohoObj->update_record_admin_4($zoho_id, array('Tracking_Number_' . $index => $value));
				}
				//set status to shipped
				$zohoObj->update_record_admin_4($zoho_id, array('Status' => 'Shipped'));
				// Get updated data from Zoho and insert it into database
				$updatedRecord = $zohoObj->getShippedRecordData($zoho_id);
			}

			$updatedRecord['serials'] = $serial_numbers_string;
			$this->insertMtsShipLogData($updatedRecord);
			$this->emailShipNotification($updatedRecord);
		}
		return true;
	}

	function insertMtsShipLogData($updatedRecord)
	{
		global $zohoObj;

		$accountData = $updatedRecord['account'];
		$accountData['newCustomer'] = false;
		$account = new Account($accountData);
		$account->save();
		// $escapedAccountName = mysql_escape_string($account['Account_Name']);
		// $accountInsertQuery = "INSERT INTO order_accounts(`name`, `zoho_id`) VALUES ('$escapedAccountName', '{$account['Account_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedAccountName';";

		// $salesperson = $updatedRecord['salesperson'];
		// $escapedSalespersonName = mysql_escape_string($salesperson['Owner']);
		// $salespersonInsertQuery = "INSERT INTO order_salespersons(`name`, `zoho_id`) VALUES ('$escapedSalespersonName', '{$salesperson['Owner_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedSalespersonName';";

		$salespersonData = $updatedRecord['salesperson'];
		$salesperson = new Salesperson($salespersonData);
		$salesperson->save();


		$i = 0;
		$hasLineItems = false;
		// $lineItemInsertQuery = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`, `code`) VALUES ";
		foreach ($updatedRecord['lineItems'] as $lineItemData) {
			$hasLineItems = true;

			$lineItem = new LineItem($lineItemData);
			$lineItem->save();

			// if ($i) {
			// 	$lineItemInsertQuery .= ', ';
			// }
			// $escapedLineItemName = mysql_escape_string($lineItemData['name']);
			// $escapedLineItemCode = mysql_escape_string($lineItemData['code']);
			// $lineItemInsertQuery .= "('$escapedLineItemName', '{$lineItemData['id']}', '$escapedLineItemCode')";
			// $i++;
		}
		// $lineItemInsertQuery .= ';';


		$invoice = $updatedRecord['invoice'];
		$state = $invoice['State'];
		$shipLogInsertQuery =
			"INSERT INTO order_ship_log (`zoho_id`, `account_id`, `salesperson_id`, mts_number, invoice_date, total, deductions, notes, `state_id`)
			VALUES
				('{$invoice['Invoice_Id']}',
				(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
				(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
				'{$invoice['MTS_Quote_Number']}',
				'{$invoice['Created_Time']}',
				{$invoice['Total']},
				{$invoice['Deduction']},
				(SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}'),
				(SELECT `id` FROM `states` WHERE `abbreviation`='$state' LIMIT 1))
			ON DUPLICATE KEY UPDATE
				`account_id`=(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
				`salesperson_id`=(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
				mts_number='{$invoice['MTS_Quote_Number']}',
				invoice_date='{$invoice['Created_Time']}',
				total={$invoice['Total']},
				notes=(SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}');";
		$j = 0;
		$joinTableInsertQuery = "INSERT IGNORE INTO order_shipped_line_items(`ship_log_id`, `line_item_id`, `quantity`, `description`, `total`) VALUES ";
		foreach ($invoice['Products'] as $product) {
			if ($j) {
				$joinTableInsertQuery .= ', ';
			}
			$escapedDescription = mysql_real_escape_string($product['description']);
			$joinTableInsertQuery .= "((SELECT id FROM order_ship_log WHERE zoho_id = '{$invoice['Invoice_Id']}'), (SELECT id FROM order_line_items WHERE zoho_id = '{$product['id']}'), {$product['quantity']}, '$escapedDescription', '{$product['total']}')";
			$j++;
		}
		$joinTableInsertQuery .= ';';

		$shipping = $updatedRecord['shipping'];
		$shippingInsertQuery = "INSERT IGNORE INTO order_shipping_details VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '{$shipping['Invoice_Id']}'), '{$shipping['Ship_Date']}', '{$shipping['Ship_Method']}', '{$shipping['Tracking_Number_1']}', '{$shipping['Tracking_Number_2']}', '{$shipping['Tracking_Number_3']}', '{$shipping['Tracking_Number_4']}', '{$shipping['Tracking_Number_5']}');";

		// $this->db_query($accountInsertQuery, 'insert', true);
		// $this->db_query($salespersonInsertQuery, 'insert', true);
		$this->db_query($shipLogInsertQuery, 'insert', true);
		// $this->insertOrderState($state, $zoho_id);
		if ($hasLineItems) {
			// $this->db_query($lineItemInsertQuery, 'insert', true);
			$this->db_query($joinTableInsertQuery, 'insert', true);
		}
		$this->db_query($shippingInsertQuery, 'insert', true);
		$zoho_id = $invoice['Invoice_Id'];
		$this->deleteOrderFromOpenOrders($zoho_id);
		// $this->resetAutoIncrement('order_accounts');
		// $this->resetAutoIncrement('order_salespersons');
		// $this->resetAutoIncrement('order_line_items');
		$this->resetAutoIncrement('order_ship_log');
		return true;
	}

	function insertMtsShipLogDataDebug($zoho_id)
	{
		global $zohoObj;
		echo "<h1>Beginning debug.</h1>";
		echo "<h2>Zoho ID: $zoho_id.</h2>";
		echo "<h3>record data from Zoho:</h3>";
		$updatedRecord = $zohoObj->getShippedRecordData($zoho_id);
		echo "<pre>";
		print_r($updatedRecord);
		echo "</pre>";
		$account = $updatedRecord['account'];
		$escapedAccountName = mysql_escape_string($account['Account_Name']);
		$accountInsertQuery = "INSERT INTO order_accounts(`name`, `zoho_id`) VALUES ('$escapedAccountName', '{$account['Account_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedAccountName';";

		echo "<h3>accountInsertQuery</h3>";
		echo "<p>$accountInsertQuery</p>";

		$salesperson = $updatedRecord['salesperson'];
		$escapedSalespersonName = mysql_escape_string($salesperson['Owner']);
		$salespersonInsertQuery = "INSERT INTO order_salespersons(`name`, `zoho_id`) VALUES ('$escapedSalespersonName', '{$salesperson['Owner_Id']}') ON DUPLICATE KEY UPDATE `name`='$escapedSalespersonName';";

		echo "<h3>salespersonInsertQuery</h3>";
		echo "<p>$salespersonInsertQuery</p>";


		$i = 0;
		$hasLineItems = false;
		$lineItemInsertQuery = "INSERT IGNORE INTO order_line_items(`name`, `zoho_id`, `code`) VALUES ";
		foreach ($updatedRecord['lineItems'] as $lineItem) {
			$hasLineItems = true;
			if ($i) {
				$lineItemInsertQuery .= ', ';
			}
			$escapedLineItemName = mysql_escape_string($lineItem['name']);
			$escapedLineItemCode = mysql_escape_string($lineItem['code']);
			$lineItemInsertQuery .= "('$escapedLineItemName', '{$lineItem['id']}', '$escapedLineItemCode')";
			$i++;
		}
		$lineItemInsertQuery .= ';';

		echo "<h3>lineItemInsertQuery</h3>";
		echo "<p>$lineItemInsertQuery</p>";

		$invoice = $updatedRecord['invoice'];
		$state = $invoice['State'];
		$shipLogInsertQuery =
			"INSERT INTO order_ship_log (`zoho_id`, `account_id`, `salesperson_id`, mts_number, invoice_date, total, deductions, notes, `state_id`)
			VALUES
				('{$invoice['Invoice_Id']}',
				(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
				(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
				'{$invoice['MTS_Quote_Number']}',
				'{$invoice['Created_Time']}',
				{$invoice['Total']},
				{$invoice['Deduction']},
				(SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}'),
				(SELECT `id` FROM `states` WHERE `abbreviation`='$state' LIMIT 1))
			ON DUPLICATE KEY UPDATE
				`account_id`=(SELECT id FROM order_accounts WHERE zoho_id = '{$invoice['Account_Id']}'),
				`salesperson_id`=(SELECT id FROM order_salespersons WHERE zoho_id = '{$invoice['Owner_Id']}'),
				mts_number='{$invoice['MTS_Quote_Number']}',
				invoice_date='{$invoice['Created_Time']}',
				total={$invoice['Total']},
				notes=(SELECT open_orders.notes FROM open_orders WHERE open_orders.zoho_id='{$invoice['Invoice_Id']}');";

		echo "<h3>shipLogInsertQuery</h3>";
		echo "<p>$shipLogInsertQuery</p>";

		$j = 0;
		$joinTableInsertQuery = "INSERT IGNORE INTO order_shipped_line_items(`ship_log_id`, `line_item_id`, `quantity`, `description`, `total`) VALUES ";
		foreach ($invoice['Products'] as $product) {
			if ($j) {
				$joinTableInsertQuery .= ', ';
			}
			$escapedDescription = mysql_real_escape_string($product['description']);
			$joinTableInsertQuery .= "((SELECT id FROM order_ship_log WHERE zoho_id = '{$invoice['Invoice_Id']}'), (SELECT id FROM order_line_items WHERE zoho_id = '{$product['id']}'), {$product['quantity']}, '$escapedDescription', '{$product['total']}')";
			$j++;
		}
		$joinTableInsertQuery .= ';';

		echo "<h3>joinTableInsertQuery</h3>";
		echo "<p>$joinTableInsertQuery</p>";

		$shipping = $updatedRecord['shipping'];
		$shippingInsertQuery = "INSERT IGNORE INTO order_shipping_details VALUES ((SELECT id FROM order_ship_log WHERE zoho_id = '{$shipping['Invoice_Id']}'), '{$shipping['Ship_Date']}', '{$shipping['Ship_Method']}', '{$shipping['Tracking_Number_1']}', '{$shipping['Tracking_Number_2']}', '{$shipping['Tracking_Number_3']}', '{$shipping['Tracking_Number_4']}', '{$shipping['Tracking_Number_5']}');";

		echo "<h3>shippingInsertQuery</h3>";
		echo "<p>$shippingInsertQuery</p>";

		// $this->db_query($accountInsertQuery, 'insert', true);
		// $this->db_query($salespersonInsertQuery, 'insert', true);
		// $this->db_query($shipLogInsertQuery, 'insert', true);
		// $this->insertOrderState($state, $zohoId);
		// $this->insertOrderStateDebug($state, $zoho_id);
		if ($hasLineItems) {
			// $this->db_query($lineItemInsertQuery, 'insert', true);
			// $this->db_query($joinTableInsertQuery, 'insert', true);
		}
		// $this->db_query($shippingInsertQuery, 'insert', true);
		// $this->deleteOrderFromOpenOrders($zoho_id);
		$this->resetAutoIncrement('order_accounts');
		$this->resetAutoIncrement('order_salespersons');
		$this->resetAutoIncrement('order_line_items');
		$this->resetAutoIncrement('order_ship_log');
		return true;
	}

	function emailShipNotification($record)
	{
		global $zohoObj;
		$contactZohoId = $record['contact']['Contact_Id'];
		$salesZohoId = $record['salesperson']['Owner_Id'];
		$contactDetails = $zohoObj->getDetailsForShipNotificationEmail($contactZohoId, $salesZohoId);

		require_once(HTML_FOLDER . "classes/Email/EmailController.php");
		return EmailController::shipNotificationLiveTest($record, $contactDetails);
	}


	function backMarketCheckout($data)
	{
		global $backmarketObj;
		// Perform backmarket API call to mark the order as shipped.
		$backmarketObj->shipOrder($data);

		// Perform local database insertions.
		$this->insertBackMarketShipLogData($data);
	}

	private function eBayCheckout($order)
	{
		global $ebayApiObj;

		$orderId = $order['order_id'];
		$trackingNums = $order['trackingNums'];
		$shipMethod = $order['shipMethod'];
		$spNums = $order['spNums'];
		$trackingNumCount = count($trackingNums);

		$response = $ebayApiObj->getOrder($orderId);
		$order = json_decode($response);

		$salesChannel = $order->lineItems[0]->soldFormat == 'AUCTION' ? 'ebay_auctions' : 'ebay_others';

		$ecommChannelTableDetails = $this->getEcommChannelTableDetails($salesChannel);

		$lineItemCount = count($order->lineItems);

		$lineItemObjects = array();

		$boxes = array();

		$shipFulfillments = array();

		for ($i = 0; $i < $trackingNumCount; $i++) {
			array_push($boxes, array());
		}
		for ($i = 0; $i < $lineItemCount; $i++) {
			$lineItemData = new stdClass;
			$lineItemData->lineItemId = $order->lineItems[$i]->lineItemId;
			$lineItemData->quantity = $order->lineItems[$i]->quantity;
			array_push($boxes[floor($i / $trackingNumCount)], $lineItemData);
			array_push($lineItemObjects, $lineItemData);
		}

		for ($i = 0; $i < $trackingNumCount; $i++) {
			$trackingNum = trim($trackingNums[$i]);
			$details = new stdClass;
			// $details->lineItems = $boxes[$i];
			$details->lineItems = $lineItemObjects;
			// $details->shippedDate = $shipDate;
			$details->shippingCarrierCode = $this->isUpsNum($trackingNum) ? $this->getUpsCarrierCode($trackingNum) : 'ShippingMethodStandard';
			$details->trackingNumber = $trackingNum;
			array_push($shipFulfillments, $details);
		}
		$results = array();
		foreach ($shipFulfillments as $shippingFulfillment) {
			$result = $ebayApiObj->createShippingFulfillment($orderId, $shippingFulfillment);
		}

		$channelId = $ecommChannelTableDetails['id'];
		$itemTableName = $ecommChannelTableDetails['item_table_name'];
		$joinTableName = $ecommChannelTableDetails['join_table_name'];
		$shipMethod = $shipFulfillments[0]->shippingCarrierCode;
		$invoiceDate = $order->creationDate;
		if (!$shipDate) {
			$shipDate = date("Y-m-d H:i:s");
		}
		$subtotal = $order->pricingSummary->priceSubtotal->value;
		$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";
		$this->db_query($sql, 'insert', true);
		$this->resetAutoIncrement('ecomm_ship_log');
		$sql = "SELECT id FROM `ecomm_ship_log` WHERE `channel_id`='$channelId' AND `order_id`='$orderId' ORDER BY id DESC LIMIT 1;";
		$newId = $this->db_query($sql, 'select-single', true);
		$ecommId = $newId['id'];

		foreach ($order->lineItems as $lineItem) {
			$sku = $lineItem->sku;
			$legacyItemId = $lineItem->legacyItemId;
			$title = mb_convert_encoding(mysql_real_escape_string($lineItem->title), 'ISO-8859-1', 'UTF-8');
			$quantity = $lineItem->quantity;
			$sql = '';
			if ($sku) {
				$sql = "INSERT INTO `$itemTableName`(`sku`, `legacy_item_id`, `title`) VALUES ('$sku', '$legacyItemId', '$title') ON DUPLICATE KEY UPDATE `sku`='$sku', `title`='$title';";
			} else {
				$sql = "INSERT INTO `$itemTableName`(`sku`, `legacy_item_id`, `title`) VALUES (NULL, '$legacyItemId', '$title') ON DUPLICATE KEY UPDATE `title`='$title';";
			}
			$this->db_query($sql, 'insert', true);
			$this->resetAutoIncrement($itemTableName);
			$sql = "SELECT id FROM `$itemTableName` WHERE `legacy_item_id`='$legacyItemId' ORDER BY id DESC LIMIT 1;";
			$newId = $this->db_query($sql, 'select-single', true);
			$itemId = $newId['id'];
			$sql = "INSERT IGNORE INTO `$joinTableName`(`item_id`, `ecomm_id`, `quantity`) VALUES ('$itemId', '$ecommId', '$quantity');";
			$this->db_query($sql, 'insert', true);
		}
		foreach ($shipFulfillments as $fulfillment) {
			$trackingNumber = $fulfillment->trackingNumber;
			$sql = "INSERT IGNORE INTO `ecomm_tracking_numbers`(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNumber');";
			$this->db_query($sql, 'insert', true);
		}
		$sql = "INSERT INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod') ON DUPLICATE KEY UPDATE `ship_date`='$shipDate', `ship_method`='$shipMethod';";
		$this->db_query($sql, 'insert', true);

		// {
		// 	"lineItems" : [
		// 	{
		// 		"lineItemId" : "string",
		// 		"quantity" : "integer"}
		// 	],
		// 	"shippedDate" : "string",
		// 	"shippingCarrierCode" : "string",
		// 	"trackingNumber" : "string"
		// }

	}

	private function neweggCheckout($order)
	{
		global $neweggApiObj;

		$orderId = $order['order_id'];
		$trackingNums = $order['trackingNums'];
		$shipDate = $order['shipDate'];
		$shipMethod = $order['shipMethod'];
		$spNums = $order['spNums'];

		$orderData = json_decode($neweggApiObj->getOrder($orderId));


		$orderNumber = $order['order_id'];
		$trackingNumber = trim($trackingNums[0]);
		if ($this->isUpsNum($trackingNumber)) {
			$shipCarrier = 'UPS';
			$shipService = $this->getUpsShipServiceForNewegg($trackingNumber);
		}

		$sellerPartNumber = $orderData->ResponseBody->OrderInfoList[0]->ItemInfoList[0]->SellerPartNumber;
		$quantity = $orderData->ResponseBody->OrderInfoList[0]->ItemInfoList[0]->OrderedQty;


		$packageResult = $neweggApiObj->shipOrder($orderId, $trackingNumber, $shipCarrier, $shipService, $sellerPartNumber, $quantity);


		$orderDataNew = json_decode($neweggApiObj->getOrder($orderId));

		$orderInfo = $orderDataNew->ResponseBody->OrderInfoList[0];

		$tableDetails = $this->getEcommChannelTableDetails('newegg');

		$channelId = $tableDetails['id'];
		$itemTableName = $tableDetails['item_table_name'];
		$joinTableName = $tableDetails['join_table_name'];


		// Get data for ecomm_ship_log insertion
		$orderId = $orderInfo->OrderNumber;
		$invoiceDateToFormat = DateTime::createFromFormat('m/d/Y H:i:s', $orderInfo->OrderDate);
		$invoiceDate = $invoiceDateToFormat->format('Y-m-d H:i:s');
		$subtotal = $orderInfo->OrderItemAmount;

		// Build ecomm_ship_log query
		$sql = "INSERT IGNORE INTO ecomm_ship_log(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";

		// Perform insertion
		$this->db_query($sql, 'insert', true);

		// Reset auto increment
		$this->resetAutoIncrement('ecomm_ship_log');

		// Get ecomm ID from db of newly inserted ship log item
		$sql = "SELECT `id` FROM ecomm_ship_log WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";

		//DEBUG
		echo "<p>$sql<p>";
		$dat = $this->db_query($sql, 'select-single', true);
		$ecommId = $dat['id'];
		echo "<p>Ecomm ID gotten: $ecommId</p>";

		// Get date for ecomm_shipping_details insertion
		// echo "<p>Creating ship date format</p>";
		// $shipDateToFormat = DateTime::createFromFormat('m/d/Y H:i:s', $orderInfo->PackageInfoList[0]->ShipDate);
		// $shipDate = $shipDateToFormat->format('Y-m-d H:i:s');
		// echo "<p>Ship date formatted: $shipDate<p>";
		// $shipMethod = $orderInfo->PackageInfoList[0]->ShipCarrier . ' ' . $orderInfo->PackageInfoList[0]->ShipService;

		$shipMethod = $shipCarrier . ' ' . $shipService;

		// Build ecomm_shipping_details query
		$sql = "INSERT IGNORE INTO ecomm_shipping_details(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod');";

		//DEBUG
		echo "<p>$sql<p>";

		// Perform insertion
		$this->db_query($sql, 'insert', true);

		// Get tracking numbers and perform insertions
		foreach ($trackingNums as $trackingNum) {
			$sql = "INSERT IGNORE INTO ecomm_tracking_numbers(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNum');";
			//DEBUG
			echo "<p>$sql<p>";


			$this->db_query($sql, 'insert', true);
		}

		// Get items and perform insertions
		foreach ($orderInfo->ItemInfoList as $itemInfo) {
			$sku = $itemInfo->SellerPartNumber;
			$neweggItemNumber = $itemInfo->NeweggItemNumber;
			$quantity = $itemInfo->OrderedQty;

			// Item table insertion
			$sql = "INSERT INTO `$itemTableName`(`sku`, `newegg_item_number`) VALUES ('$sku', '$neweggItemNumber') ON DUPLICATE KEY UPDATE `sku`='$sku';";
			//DEBUG
			echo "<p>$sql<p>";
			$this->db_query($sql, 'insert', true);
			$this->resetAutoIncrement($itemTableName);

			// Join table insertion
			$sql = "INSERT IGNORE INTO `$joinTableName`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `$itemTableName` WHERE `newegg_item_number`='$neweggItemNumber' LIMIT 1), '$ecommId', '$quantity');";
			//DEBUG
			echo "<p>$sql<p>";
			$this->db_query($sql, 'insert', true);
		}
		return true;
	}

	private function amazonCheckout($amazonOrder)
	{
		/*require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
		$amazon = new AmazonMWS;*/
		require_once(HTML_FOLDER . 'apis/amazon/class_amazon_api.php');
		$amazon = new AmazonAPI;

		// Get channel table details
		$tableDetails = $this->getEcommChannelTableDetails('amazon');
		$channelId = $tableDetails['id'];
		$itemTableName = $tableDetails['item_table_name'];
		$joinTableName = $tableDetails['join_table_name'];

		// Break up variables
		$orderId = $amazonOrder['order_id'];
		$spNums = $amazonOrder['spNums'];
		$trackingNums = $amazonOrder['trackingNums'];
		$shipDate = $amazonOrder['shipDate'];
		$shipMethod = $amazonOrder['shipMethod'];

		// Get tracking type
		$trackingNumber = $trackingNums[0];
		if ($this->isUpsNum($trackingNumber)) {
			$shipCarrier = 'UPS';
			$shipService = $this->getUpsShipServiceForNewegg($trackingNumber);
		}


		// Get order data from Amazon API
		/*$getOrderResult = $amazon->getOrder($orderId);
		$order = $getOrderResult->GetOrderResult->Orders->Order;*/

		$getOrderResult = $amazon->OrderRequestSigner($orderId);

		$order = $getOrderResult['payload'];

		// Get order item detail from Amazon API
		$orderItems = $amazon->getOrderItemsSP($orderId);
		$orderData->orderItems = $orderItems;

		$invoiceDate = $order['PurchaseDate'];

		// Calculate subtotal
		$subtotal = 0;
		foreach ($orderItems as $orderItem) {
			$subtotal += $orderItem->price;
		}


		// Build ecomm_ship_log query
		$sql = "INSERT IGNORE INTO ecomm_ship_log(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";
		// Perform insertion
		$this->db_query($sql, 'insert', true);

		// Reset auto increment
		$this->resetAutoIncrement('ecomm_ship_log');

		// Get ecomm ID from db of newly inserted ship log item
		$sql = "SELECT `id` FROM ecomm_ship_log WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
		$response = $this->db_query($sql, 'select-single', true);
		$ecommId = $response['id'];


		// Build ecomm_shipping_details query
		$shipMethod = $shipCarrier . ' ' . $shipService;
		$sql = "INSERT IGNORE INTO ecomm_shipping_details(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod');";
		// Perform insertion
		$variable = $this->db_query($sql, 'insert', true);

		// Get tracking numbers and perform insertions
		foreach ($trackingNums as $trackingNum) {
			$sql = "INSERT IGNORE INTO ecomm_tracking_numbers(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNum');";
			$this->db_query($sql, 'insert', true);
		}

		// Get items and perform insertions
		foreach ($orderItems as $orderItem) {
			$sku = $orderItem->sku;
			$itemId = $orderItem->itemId;
			$quantity = $orderItem->quantity;
			$title = mysql_real_escape_string($orderItem->title);

			// Item table insertion
			$sql = "INSERT INTO `$itemTableName`(`sku`, `order_item_id`, `title`) VALUES ('$sku', '$itemId', '$title') ON DUPLICATE KEY UPDATE `sku`='$sku', `title`='$title';";
			$this->db_query($sql, 'insert', true);
			$this->resetAutoIncrement($itemTableName);

			// Join table insertion
			$sql = "INSERT IGNORE INTO `$joinTableName`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `$itemTableName` WHERE `order_item_id`='$itemId' LIMIT 1), '$ecommId', '$quantity');";
			$this->db_query($sql, 'insert', true);
		}
		// $sql = "DELETE FROM `ecomm_open_orders` WHERE `order_id`='$orderId';";
		// $this->db_query($sql, 'delete', true);
		$sql = "UPDATE `ecomm_open_orders` SET `open`='0' WHERE `order_id`='$orderId';";
		$this->db_query($sql, 'update', true);
		return true;
	}

	public function populateLocalShippedDatabase($fromDate)
	{
		// $this->populateEbayShippedDatabase($fromDate);
		$this->populateNeweggShippedDatabase();
	}

	private function populateNeweggShippedDatabase()
	{
		global $neweggApiObj;

		$tableDetails = $this->getEcommChannelTableDetails('newegg');

		$channelId = $tableDetails['id'];
		$itemTableName = $tableDetails['item_table_name'];
		$joinTableName = $tableDetails['join_table_name'];

		echo "<h2>Fetching order history...</h2>";
		$orders = $neweggApiObj->getOrderHistory();
		echo "<h2>Order history fetched!</h2>";

		foreach ($orders as $order) {
			if ($order->OrderStatus != 3) {
				continue;
			}


			// Get data for ecomm_ship_log insertion
			$orderId = $order->OrderNumber;
			$invoiceDateToFormat = DateTime::createFromFormat('m/d/Y H:i:s', $order->OrderDate);
			$invoiceDate = $invoiceDateToFormat->format('Y-m-d H:i:s');
			$subtotal = $order->OrderItemAmount;

			// Build ecomm_ship_log query
			$sql = "INSERT IGNORE INTO ecomm_ship_log(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";

			// DEBUG: Echo sql query
			echo "<pre>$sql</pre><p></p>";

			// Perform insertion
			$this->db_query($sql, 'insert', true);

			// Reset auto increment
			$this->resetAutoIncrement('ecomm_ship_log');

			// Get ecomm ID from db of newly inserted ship log item
			$sql = "SELECT `id` FROM ecomm_ship_log WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
			$dat = $this->db_query($sql, 'select-single', true);
			$ecommId = $dat['id'];

			// Get date for ecomm_shipping_details insertion
			$shipDateToFormat = DateTime::createFromFormat('m/d/Y H:i:s', $order->PackageInfoList[0]->ShipDate);
			$shipDate = $shipDateToFormat->format('Y-m-d H:i:s');
			$shipMethod = $order->PackageInfoList[0]->ShipCarrier . ' ' . $order->PackageInfoList[0]->ShipService;

			// Build ecomm_shipping_details query
			$sql = "INSERT IGNORE INTO ecomm_shipping_details(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod');";

			// DEBUG: Echo sql query
			echo "<pre>$sql</pre><p></p>";

			// Perform insertion
			$this->db_query($sql, 'insert', true);

			// Get tracking numbers and perform insertions
			foreach ($order->PackageInfoList as $packageInfo) {
				$trackingNum = $packageInfo->TrackingNumber;
				$sql = "INSERT IGNORE INTO ecomm_tracking_numbers(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNum');";


				// DEBUG: Echo sql query
				echo "<pre>$sql</pre><p></p>";

				$this->db_query($sql, 'insert', true);
			}

			// Get items and perform insertions
			foreach ($order->ItemInfoList as $itemInfo) {
				$sku = $itemInfo->SellerPartNumber;
				$neweggItemNumber = $itemInfo->NeweggItemNumber;
				$quantity = $itemInfo->OrderedQty;

				// Item table insertion
				$sql = "INSERT INTO `$itemTableName`(`sku`, `newegg_item_number`) VALUES ('$sku', '$neweggItemNumber') ON DUPLICATE KEY UPDATE `sku`='$sku';";
				// DEBUG: Echo sql query
				echo "<pre>$sql</pre><p></p>";
				$this->db_query($sql, 'insert', true);
				$this->resetAutoIncrement($itemTableName);

				// Join table insertion

				$sql = "INSERT IGNORE INTO `$joinTableName`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `$itemTableName` WHERE `newegg_item_number`='$neweggItemNumber' LIMIT 1), '$ecommId', '$quantity');";
				// DEBUG: Echo sql query
				echo "<pre>$sql</pre><p></p>";
				$this->db_query($sql, 'insert', true);
			}
		}
		echo "<h2>Done!</h2>";
		return true;
	}

	private function populateEbayShippedDatabase($fromDate)
	{
		global $ebayApiObj;
		$response = $ebayApiObj->getOrders($fromDate, 1000);
		$orderData = json_decode($response);
		$orders = $orderData->orders;
		$ebayAuctionsTableDetails = $this->getEcommChannelTableDetails('ebay_auctions');
		$ebayOthersTableDetails = $this->getEcommChannelTableDetails('ebay_others');
		$auctionsChannelId = $ebayAuctionsTableDetails['id'];
		$auctionsItemTableName = $ebayAuctionsTableDetails['item_table_name'];
		$auctionsJoinTableName = $ebayAuctionsTableDetails['join_table_name'];
		$othersChannelId = $ebayOthersTableDetails['id'];
		$othersItemTableName = $ebayOthersTableDetails['item_table_name'];
		$othersJoinTableName = $ebayOthersTableDetails['join_table_name'];
		// echo "<pre>";
		// print_r($orders[0]);
		// echo "</pre>";
		// exit;
		foreach ($orders as $order) {
			if ($order->orderFulfillmentStatus != 'FULFILLED') {
				continue;
			}
			$orderId = $order->orderId;
			$shippingFulfillmentResponse = $ebayApiObj->getShippingFulfillments($orderId);
			$shippingFulfillmentData = json_decode($shippingFulfillmentResponse);
			$shipDate = $shippingFulfillmentData->fulfillments[0]->shippedDate;
			$channelId = '';
			if ($order->lineItems[0]->soldFormat == 'AUCTION') {
				$channelId = $auctionsChannelId;
			} else {
				$channelId = $othersChannelId;
			}
			$shipMethod = $order->fulfillmentStartInstructions[0]->shippingStep->shippingServiceCode;
			$invoiceDate = $order->creationDate;
			if (!$shipDate) {
				$shipDate = $order->creationDate;
			}
			$subtotal = $order->pricingSummary->priceSubtotal->value;
			$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";
			echo "<h4>Running Query:</h4><p>$sql</p>";
			$this->db_query($sql, 'insert', true);
			$this->resetAutoIncrement('ecomm_ship_log');
			$sql = "SELECT id FROM `ecomm_ship_log` WHERE `channel_id`='$channelId' AND `order_id`='$orderId' ORDER BY id DESC LIMIT 1;";
			echo "<h4>Running Query:</h4><p>$sql</p>";
			$newId = $this->db_query($sql, 'select-single', true);
			$ecommId = $newId['id'];


			foreach ($order->lineItems as $lineItem) {
				$sku = $lineItem->sku;
				$legacyItemId = $lineItem->legacyItemId;
				$title = mysql_real_escape_string($lineItem->title);
				$quantity = $lineItem->quantity;
				$sql = '';
				if ($sku) {
					$sql = "INSERT INTO `ecomm_ebay_listings`(`sku`, `legacy_item_id`, `title`) VALUES ('$sku', '$legacyItemId', '$title') ON DUPLICATE KEY UPDATE `sku`='$sku', `title`='$title';";
				} else {
					$sql = "INSERT INTO `ecomm_ebay_listings`(`sku`, `legacy_item_id`, `title`) VALUES (NULL, '$legacyItemId', '$title') ON DUPLICATE KEY UPDATE `title`='$title';";
				}
				echo "<h4>Running Query:</h4><p>$sql</p>";
				$this->db_query($sql, 'insert', true);
				$this->resetAutoIncrement('ecomm_ebay_listings');
				$sql = "SELECT id FROM `ecomm_ebay_listings` WHERE `legacy_item_id`='$legacyItemId' ORDER BY id DESC LIMIT 1;";
				echo "<h4>Running Query:</h4><p>$sql</p>";
				$newId = $this->db_query($sql, 'select-single', true);
				$itemId = $newId['id'];
				$sql = "INSERT IGNORE INTO `ecomm_ebay_listings_shipped`(`item_id`, `ecomm_id`, `quantity`) VALUES ('$itemId', '$ecommId', '$quantity');";
				echo "<h4>Running Query:</h4><p>$sql</p>";
				$this->db_query($sql, 'insert', true);
			}
			foreach ($shippingFulfillmentData->fulfillments as $fulfillment) {
				$trackingNumber = $fulfillment->shipmentTrackingNumber;
				$sql = "INSERT IGNORE INTO `ecomm_tracking_numbers`(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNumber');";
				echo "<h4>Running Query:</h4><p>$sql</p>";
				$this->db_query($sql, 'insert', true);
			}
			$sql = "INSERT INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod') ON DUPLICATE KEY UPDATE `ship_date`='$shipDate', `ship_method`='$shipMethod';";
			echo "<h4>Running Query:</h4><p>$sql</p>";
			$this->db_query($sql, 'insert', true);
		}
	}



	private function populateBackMarketShippedDatabase()
	{
		global $backmarketObj;
		$salesChannelDetails = $this->getEcommChannelTableDetails('back_market');
		$channelId = $salesChannelDetails['id'];
		$itemTableName = $salesChannelDetails['item_table_name'];
		$joinTableName = $salesChannelDetails['join_table_name'];

		$results = $backmarketObj->getOrderHistory();

		$uniqueSkus = array();
		$orderLineItems = array();
		$i = 0;
		$shipLogSql = "INSERT IGNORE INTO ecomm_ship_log(`order_id`, `channel_id`, `invoice_date`, `subtotal`, `notes`) VALUES ";
		$shippingDetailsSql = "INSERT IGNORE INTO ecomm_shipping_details VALUES ";
		$trackingNumberSql = "INSERT IGNORE INTO ecomm_tracking_numbers VALUES ";
		foreach ($results as $result) {
			$orderId = $result->order_id;
			$invoiceDate = $result->date_creation;
			$subtotal = $result->price;
			$shipDate = $result->date_shipping;
			$shipMethod = $result->shipper;
			$lineItems = $result->orderlines;
			$trackingNumber = $result->tracking_number;

			$orderLineItems[$orderId] = array();

			foreach ($lineItems as $lineItem) {
				if (!in_array($lineItem->listing, $uniqueSkus)) {
					array_push($uniqueSkus, $lineItem->listing);
				}
				$orderLineItems[$orderId][$lineItem->listing] = $lineItem->quantity;
			}

			if ($i) {
				$shipLogSql .= ', ';
				$shippingDetailsSql .= ', ';
				$trackingNumberSql .= ', ';
			}
			$shipLogValueString = "('$orderId', $channelId, '$invoiceDate', $subtotal, (SELECT eoo.notes FROM ecomm_open_orders AS eoo WHERE eoo.order_id = '$orderId' LIMIT 1))";
			$shippingDetailValueString = "((SELECT id FROM ecomm_ship_log WHERE order_id = '$orderId' AND channel_id = '$channelId' LIMIT 1), '$shipDate', '$shipMethod')";
			$trackingNumberValueString = "((SELECT id FROM ecomm_ship_log WHERE order_id = '$orderId' AND channel_id = '$channelId' LIMIT 1), '$trackingNumber')";




			$shipLogSql .= $shipLogValueString;
			$shippingDetailsSql .= $shippingDetailValueString;
			$trackingNumberSql .= $trackingNumberValueString;
			$i++;
		}
		$shipLogSql .= ";";
		$shippingDetailsSql .= ";";
		$joinTableInsertSql = "INSERT IGNORE INTO $joinTableName VALUES ";
		$i = 0;
		foreach ($orderLineItems as $orderId => $items) {
			foreach ($items as $sku => $quantity) {
				if ($i) {
					$joinTableInsertSql .= ", ";
				}
				$joinTableInsertSql .= "((SELECT id FROM $itemTableName WHERE sku = '$sku' LIMIT 1), (SELECT id FROM ecomm_ship_log WHERE order_id = '$orderId' AND channel_id = '$channelId' LIMIT 1), $quantity)";
				$i++;
			}
		}
		echo "<h3>Ship Log SQL:</h3><p>$shipLogSql</p>";
		echo "<h3>Ship Details SQL:</h3><p>$shippingDetailsSql</p>";
		echo "<h3>Tracking Number SQL:</h3><p>$trackingNumberSql</p>";
		echo "<h3>Join Table SQL:</h3><p>$joinTableInsertSql</p>";


		$this->db_query($shipLogSql, 'insert', true);
		$this->resetAutoIncrement('ecomm_ship_log');

		$this->db_query($shippingDetailsSql, 'insert', true);
		$this->db_query($trackingNumberSql, 'insert', true);

		$lineItemData = array(
			'lineItemSkus' => $uniqueSkus,
			'itemTableName' => $itemTableName
		);
		$this->addNewLineItemsToTable($lineItemData);
		$this->db_query($joinTableInsertSql, 'insert', true);

		echo "<h1>DONE SUCCESSFULLY!</h1>";
	}

	function insertBackMarketShipLogData($data)
	{
		global $backmarketObj;

		$channelIdentifier = 'back_market';

		// Get sales channel table details
		$salesChannelDetails = $this->getEcommChannelTableDetails($channelIdentifier);
		$channelId = $salesChannelDetails['id'];
		$itemTableName = $salesChannelDetails['item_table_name'];
		$joinTableName = $salesChannelDetails['join_table_name'];

		// Put order details into variables
		$orderId = $data['order_id'];
		$trackingNumbers = $data['tracking_numbers'];
		$orderDetails = $backmarketObj->getOrder($orderId);
		$decodedDetails = json_decode($orderDetails);
		$orderId = $decodedDetails->order_id;
		$invoiceDate = $decodedDetails->date_creation;
		$subtotal = $decodedDetails->price;
		$shipDate = $decodedDetails->date_shipping;
		$shipMethod = $decodedDetails->shipper;
		$lineItems = $decodedDetails->orderlines;

		// Perform ship log data insertion
		$shipLogData = array(
			'channelId' => $channelId,
			'orderId' => $orderId,
			'invoiceDate' => $invoiceDate,
			'subtotal' => $subtotal
		);
		$this->performEcommShipLogInsertion($shipLogData);

		$ecommShipLogId = $this->getEcommShipLogId($orderId, $channelId);

		$shippingDetailsData = array(
			'ecommShipLogId' => $ecommShipLogId,
			'shipDate' => $shipDate,
			'shipMethod' => $shipMethod
		);
		$this->performEcommShippingDetailsInsertion($shippingDetailsData);

		$trackingNumberData = array(
			'ecommShipLogId' => $ecommShipLogId,
			'trackingNumbers' => $trackingNumbers
		);
		$this->performEcommTrackingNumbersInsertion($trackingNumberData);

		$lineItemSkus = array();
		$lineItemSkuQuantities = array();
		foreach ($lineItems as $lineItem) {
			array_push($lineItemSkus, $lineItem->listing);
			$lineItemSkuQuantities[$lineItem->listing] = $lineItem->quantity;
		}
		$lineItemData = array(
			'ecommShipLogId' => $ecommShipLogId,
			'lineItemSkus' => $lineItemSkus,
			'lineItemSkuQuantities' => $lineItemSkuQuantities,
			'itemTableName' => $itemTableName,
			'joinTableName' => $joinTableName
		);
		$this->performLineItemsInsertions($lineItemData);

		// $sql = "DELETE FROM ecomm_open_orders WHERE order_id = '$orderId' AND channel_id = $channelId;";
		// $this->db_query($sql, 'delete', true);
		$sql = "UPDATE `ecomm_open_orders` SET `open`='0' WHERE `order_id`='$orderId' AND `channel_id`='$channelId';";
		$this->db_query($sql, 'update', true);
	}

	private function getEcommChannelTableDetails($channelIdentifier)
	{
		$sql = "SELECT id, item_table_name, join_table_name FROM ecomm_sales_channels WHERE identifier = '$channelIdentifier';";
		return $this->db_query($sql, 'select-single', true);
	}

	private function performEcommShipLogInsertion($data)
	{
		$channelId = $data['channelId'];
		$orderId = $data['orderId'];
		$invoiceDate = $data['invoiceDate'];
		$subtotal = $data['subtotal'];
		$sql = "INSERT INTO ecomm_ship_log(`order_id`, `channel_id`, `invoice_date`, `subtotal`, `notes`)
				VALUES ('$orderId', $channelId, '$invoiceDate', $subtotal, (SELECT eoo.notes FROM ecomm_open_orders AS eoo WHERE eoo.order_id = '$orderId' LIMIT 1))
				ON DUPLICATE KEY UPDATE `invoice_date`='$invoiceDate', `subtotal`=$subtotal, `notes`=(SELECT eoo.notes FROM ecomm_open_orders AS eoo WHERE eoo.order_id = '$orderId' LIMIT 1);";
		return $this->db_query($sql, 'insert', true);
	}

	private function performEcommShippingDetailsInsertion($data)
	{
		$ecommShipLogId = $data['ecommShipLogId'];
		$shipDate = $data['shipDate'];
		$shipMethod = $data['shipMethod'];
		$sql = "INSERT IGNORE INTO ecomm_shipping_details VALUES ($ecommShipLogId, '$shipDate', '$shipMethod');";
		return $this->db_query($sql, 'insert', true);
	}

	private function performEcommTrackingNumbersInsertion($data)
	{
		$ecommShipLogId = $data['ecommShipLogId'];
		$trackingNums = $data['trackingNumbers'];
		$valueString = '';
		$i = 0;
		foreach ($trackingNums as $num) {
			if ($i) {
				$valueString .= ", ";
			}
			$num = trim($num);
			$valueString .= "($ecommShipLogId, '$num')";
			$i++;
		}
		$sql = "INSERT IGNORE INTO ecomm_tracking_numbers VALUES $valueString;";
		return $this->db_query($sql, 'insert', true);
	}

	private function performLineItemsInsertions($data)
	{
		$ecommShipLogId = $data['ecommShipLogId'];
		$lineItemSkuQuantities = $data['lineItemSkuQuantities'];
		$itemTableName = $data['itemTableName'];
		$joinTableName = $data['joinTableName'];

		$this->addNewLineItemsToTable($data);

		$joinTableInsertString = '';
		$i = 0;
		foreach ($lineItemSkuQuantities as $sku => $quantity) {
			if ($i) {
				$joinTableInsertString .= ", ";
			}
			$joinTableInsertString .= "((SELECT id FROM $itemTableName WHERE sku = '$sku'), $ecommShipLogId, $quantity)";
			$i++;
		}
		$sql = "INSERT IGNORE INTO $joinTableName VALUES $joinTableInsertString;";
		return $this->db_query($sql, 'insert', true);
	}

	private function addNewLineItemsToTable($data)
	{
		$itemTableName = $data['itemTableName'];
		$lineItemSkus = $data['lineItemSkus'];
		$itemTableInsertString = implode("'), ('", $lineItemSkus);
		$sql = "INSERT IGNORE INTO $itemTableName(`sku`) VALUES ('$itemTableInsertString');";
		$this->db_query($sql, 'insert', true);
		$this->resetAutoIncrement($itemTableName);
		return true;
	}

	private function getEcommShipLogId($orderId, $channelId)
	{
		$sql = "SELECT id FROM ecomm_ship_log WHERE order_id = '$orderId' AND channel_id = $channelId ORDER BY id DESC LIMIT 1;";
		$data = $this->db_query($sql, 'select-single', true);
		return $data['id'];
	}

	function deleteOrderFromOpenOrders($orderId)
	{
		$sql = "DELETE FROM open_orders WHERE zoho_id = '$orderId';";
		$this->db_query($sql, 'delete', true);
		return true;
	}

	function getOrderSPInfo($spNums)
	{
		$inClause = $this->build_in_clause($spNums);
		$spInfoQuery = "SELECT oNum, serialNumber, grade, asset FROM ds_orders WHERE oNum IN $inClause ORDER BY oNum DESC;";
		$spInfo = $this->db_query($spInfoQuery, 'select-multiple', true);
		return $spInfo;
	}

	function getMtsOrdersSubmittedButNotOpen($mtsOrders)
	{
		$query1 = '(';
		$query2 = '(';
		$query3 = '(';
		$i = 0;
		foreach ($mtsOrders as $order) {
			if ($i < 10) {
				if ($i % 10) {
					$query1 .= ' OR ';
				}
				$query1 .= "(MTS_Quote_Number:equals:$order)";
			} elseif ($i < 20) {
				if ($i % 10) {
					$query2 .= ' OR ';
				}
				$query2 .= "(MTS_Quote_Number:equals:$order)";
			} elseif ($i < 30) {
				if ($i % 10) {
					$query3 .= ' OR ';
				}
				$query3 .= "(MTS_Quote_Number:equals:$order)";
			}
			$i++;
		}
		$query1 .= ')';
		$query2 .= ')';
		$query3 .= ')';
		$invoiceNums = array();
		if ($query1 != '()') {
			$invoiceNums = array_merge($invoiceNums, $this->getZohoInvoiceNums($query1));
		}
		if ($query2 != '()') {
			$invoiceNums = array_merge($invoiceNums, $this->getZohoInvoiceNums($query2));
		}
		if ($query3 != '()') {
			$invoiceNums = array_merge($invoiceNums, $this->getZohoInvoiceNums($query3));
		}
		return $invoiceNums;
	}
	function associateSPNumsAndOrderNumsArray($orders, $invoices, &$otherInvoices)
	{
		$arr = array();
		$invoiceNums = array();
		$unfoundInvoiceNums = array();
		foreach ($invoices as $invoice) {
			$invoiceNums[substr($invoice, 0, 8)] = $invoice;
		}
		foreach ($orders as $order) {
			if (in_array($order['orderNum'], array_keys($invoiceNums))) {
				foreach ($order['spNums'] as $spNum) {
					$arr[trim($spNum)] = $invoiceNums[$order['orderNum']];
				}
			} else {
				array_push($unfoundInvoiceNums, $order['orderNum']);
			}
		}
		$nonopenInvoices = $this->getMtsOrdersSubmittedButNotOpen($unfoundInvoiceNums);
		$nonopenInvoiceNums = array();
		foreach ($nonopenInvoices as $invoice) {
			$nonopenInvoiceNums[substr($invoice, 0, 8)] = $invoice;
		}
		foreach ($orders as $order) {
			if (in_array($order['orderNum'], array_keys($nonopenInvoiceNums))) {
				foreach ($order['spNums'] as $spNum) {
					$arr[trim($spNum)] = $nonopenInvoiceNums[$order['orderNum']];
				}
			}
		}
		$otherInvoices = $nonopenInvoices;
		return $arr;
	}

	function buildMTSCheckoutUpdateQuery($spNums)
	{
		if (count($spNums) == 0) {
			return false;
		}
		$inClause = $this->build_in_clause(array_keys($spNums));
		$caseClause = "";
		foreach ($spNums as $k => $v) {
			$caseClause .= "WHEN oNum = '$k' THEN '" . substr($v, 0, 8) . "' ";
		}
		$status = STATUS_REFURB_COMPLETE;
		$query = "UPDATE ds_orders SET mts_number = (CASE $caseClause END), cStatus = '$status' WHERE oNum IN $inClause;";
		return $query;
	}

	function buildMTSCheckoutLogInsertQuery($spNums)
	{
		$status = STATUS_REFURB_COMPLETE;
		if (count($spNums) == 0) {
			return false;
		}
		$valuesStr = "";
		foreach ($spNums as $sp => $val) {
			$data1 = array(
				'oNum' => trim($sp),
				'time' => $this->format_date('db_full'),
				'details' => "Order Status changed to $status",
				'type' => 'order_status_changed',
				'userName' => $_SESSION['aUser']
			);
			$data2 = array(
				'oNum' => trim($sp),
				'time' => $this->format_date('db_full'),
				'details' => "Sold to $val",
				'type' => 'sold',
				'userName' => $_SESSION['aUser']
			);
			if (strlen(trim($sp)) > 0) {
				$valuesStr .= ' ("' . $data1['oNum'] . '", "' . $data1['time'] . '", "' . $data1['details'] . '", "' . $data1['type'] . '", "' . $data1['userName'] . '"),';
				$valuesStr .= ' ("' . $data2['oNum'] . '", "' . $data2['time'] . '", "' . $data2['details'] . '", "' . $data2['type'] . '", "' . $data2['userName'] . '"),';
			}
		}
		$valuesStr = substr($valuesStr, 0, -1);
		if (strlen($valuesStr) < 5) {
			return false;
		}
		$query = "INSERT INTO ds_order_logs (oNum, time, details, type, userName) VALUES $valuesStr;";
		return $query;
	}

	function getZohoInvoices($searchBy = "")
	{
		global $zohoObj;

		if (!$searchBy || $searchBy == "" || $searchBy == "open") {
			$searchBy = "((Status:equals:PO) OR (Status:equals:PO received) OR (Status:equals:Wire Received - Waiting for Shipping) OR (Status:equals:Credit Card))";
		}
		$invoices = $zohoObj->getSearchRecords_BB($searchBy);
		return $invoices;
	}

	function getZohoInvoiceNums($searchBy = "")
	{
		$invoices = $this->getZohoInvoices($searchBy);
		foreach ($invoices as $invoice) {
			$invoice_no = $invoice['MTS_Quote_Number'];
			$account_name = $invoice['Account_Name'];
			$status = $invoice['Status'];
			if ($invoice_no != '' /* && strpos($status, 'BB') === false*/) {
				$invoice_nums["a" . $invoice['Invoice_Id']] = $invoice_no . ' - ' . $account_name;
			}
		}
		return $invoice_nums;
	}

	function getZohoInvoicesAJAX($searchBy = "")
	{
		echo json_encode($this->getZohoInvoices($searchBy));
	}

	function buildCheckoutUpdateQuery($spArray)
	{
		$query = 'UPDATE ds_orders SET cShipInstruct = (case ';
		foreach ($spArray as $sp => $val) {
			$substr = 'when oNum = "' . $sp . '" then concat(cShipInstruct, "\n", "' . $val . '") ';
			$query .= $substr;
		}
		$query .= ' end), cStatus = "' . STATUS_REFURB_COMPLETE . '" WHERE oNum in (';
		foreach ($spArray as $sp => $val) {
			$query .= '"' . $sp . '",';
		}
		$query = substr($query, 0, -1);
		$query .= ');';
		return $query;
	}

	function buildOrderLogInsertQuery($spArray, $status)
	{
		$query = 'INSERT INTO ds_order_logs(oNum, time, details, type, userName) VALUES';
		$originalQuery = $query;

		foreach ($spArray as $sp => $val) {
			$data = array(
				'oNum' => trim($sp),
				'time' => $this->format_date('db_full'),
				'details' => "Order Status changed to $status",
				'type' => 'order_status_changed',
				'userName' => $_SESSION['aUser']
			);
			if (strlen(trim($sp)) > 0) {
				$query .= ' ("' . $data['oNum'] . '", "' . $data['time'] . '", "' . $data['details'] . '", "' . $data['type'] . '", "' . $data['userName'] . '"),';
			}
		}
		if ($query == $originalQuery) {
			return false;
		}
		$query = substr($query, 0, -1);
		$query .= ';';
		return $query;
	}

	/**
	 * Determines shipping carrier based upon tracking number.
	 *
	 * @param string $trackingNumber Tracking number for a given parcel.
	 * @return string Shipping carrier if able to determine, else 'Unknown'.
	 */
	function get_tracking_type($trackingNumber)
	{
		$upsPattern = '/^(1Z.{16})$/';
		$fedexPattern = '/^(.{12}|.{15})$/';
		$uspsPattern = '/^(.{22})$/';
		if (preg_match($upsPattern, $trackingNumber) == 1) {
			return 'UPS';
		} elseif (preg_match($fedexPattern, $trackingNumber) == 1) {
			return 'FedEx';
		} elseif (preg_match($uspsPattern, $trackingNumber == 1)) {
			return 'USPS';
		} else {
			return 'Unknown';
		}
	}

	function ecom_returns_page()
	{
		$body .= '
			<tr>
				<td></td>
				<td></td>
				<td hidden id="orderNumColumnHead"><strong>Order Number</strong></td>
			</tr>
			<tr>
				<td><strong>Scan Order Number or Tracking Number</strong></td>
				<td><input size="30" type="text" name="scanInput" id="scanInput" /></td>
				<td><input hidden readonly size="30" id="orderNumInput" name="orderNum" value="" /></td>
			</tr>
			<tr id="inputHeaderRow" hidden>
				<td></td>
				<td></td>
				<td><strong>SP Numbers</strong></td>
			</tr>
			<tr id="serialInputRow" hidden>
				<td valign="top"><strong>Input Serial/SP Numbers</strong></td>
				<td valign="top"><textarea name="serialNumbers" id="serialTextAreaInput"></textarea></td>
				<td valign="top" id="displaySPNums"></td>
			</tr>
			<tr id="singleSPInputRow" hidden>
				<td><strong>SP Number</strong></td>
				<td><input readonly type="text" name="singleSpNumber" id="singleSPInput" /></td>
			</tr>
			<tr id="spSelectRow" hidden>
				<td><strong>Select SP Numbers</strong></td>
				<td>
					<select name="spNumbers[]" id="spNumbersInput" multiple>
					</select>
				</td>
			</tr>
		';
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ECOMMERCE_RETURNS, array('INPUTS' => $body)), "TITLE" => "Ecomm Returns"));
	}

	/**
	 * Handles submitting ecommerce return form.
	 *
	 * @global $adminObj - Used to reprint refurb labels.
	 */
	function ecom_returns_submit()
	{
		global $adminObj;
		$spNums = array();
		if ($_POST['spNumbers']) {
			$spNums = $_POST['spNumbers'];
		} else if ($_POST['singleSpNumber']) {
			array_push($spNums, $_POST['singleSpNumber']);
		} else {
			exit; // If post is somehow sent without sp numbers, abort
		}
		$queryResult = $this->getPreviouslyReturnedOrders($spNums);
		$previouslyReturnedOrders = array();
		if (!$queryResult) {
		} else {
			if (!$queryResult['oNum']) {
				foreach ($queryResult as $result) {
					array_push($previouslyReturnedOrders, $result['oNum']);
				}
			} else {
				array_push($previouslyReturnedOrders, $queryResult['oNum']);
			}
		}
		// Query ds_order_logs to check if any submitted SP numbers have been returned before. DONE

		$this->sendReturnCheckoutUpdateQuery($spNums, $previouslyReturnedOrders);
		$this->sendOrderLogInsertQuery($spNums);
		// Update DB for all submitted to have status changed to STATUS_ECOMM_RETURN

		for ($i = 0; $i < count($spNums); $i++) {
			$adminObj->reprint_refurb_label($spNum[$i]);
		}
		// Print all SP tags at user's default printer.
	}

	function getPreviouslyReturnedOrders($spNums)
	{
		$searchString;
		if (is_array($spNums)) {
			$searchString = 'in ' . $this->buildSearchString($spNums);
		} else {
			$searchString = '= "' . $spNums . '"';
		}
		$query = 'SELECT oNum FROM ds_order_logs WHERE oNum ' . $searchString . ' AND details LIKE "%' . STATUS_ECOMM_RETURN . '%";';
		$data = is_array($spNums) ? $this->db_query($query, 'select-multiple', true) : $this->db_query($query, 'select-single', true);
		// $data['query'] = $query;
		return $data;
	}

	function sendReturnCheckoutUpdateQuery($spNums, $spNumsAlreadyReturned)
	{
		$alreadyReturnedSearchString = $this->buildSearchString($spNumsAlreadyReturned);
		$allSearchString = $this->buildSearchString($spNums);
		$status = STATUS_ECOMM_RETURN;

		$query;
		if (count($spNumsAlreadyReturned) > 0) {
			$query =
				"UPDATE ds_orders
					SET grade =
						CASE
							WHEN oNum IN $alreadyReturnedSearchString THEN 'R'
							ELSE grade
						END, cStatus = '$status'
					WHERE oNum IN $allSearchString;";
		} else {
			$query = "UPDATE ds_orders SET cStatus = '$status' WHERE oNum IN $allSearchString;";
		}
		$data = $this->db_query($query, 'update', true);
	}

	function sendOrderLogInsertQuery($spNums)
	{
		$nums = array();
		foreach ($spNums as $spNum) {
			$nums[$spNum] = $spNum;
		}
		$query = $this->buildOrderLogInsertQuery($nums, STATUS_ECOMM_RETURN);
		if ($query !== FALSE) {
			$this->db_query($query, 'insert', true);
		}
	}

	/**
	 * Builds a search string from an array of SP numbers
	 * @param $spNums
	 */
	function buildSearchString($spNums)
	{
		$searchString = '(';
		for ($i = 0; $i < count($spNums); $i++) {
			$searchString .= '"' . $spNums[$i] . '"';
			if ($i < count($spNums) - 1) {
				$searchString .= ',';
			}
		}
		$searchString .= ')';
		return $searchString;
	}

	function getOrderDataFromTracking($trackingNumber)
	{
		$sql = "SELECT upo.id, upo.order_number FROM ups_pending_tracking_numbers AS uptn LEFT JOIN ups_pending_orders AS upo ON upo.id = uptn.order_number_id WHERE uptn.tracking_number = '$trackingNumber';";
		$result = $this->db_query($sql, 'select-single', true);
		if ($result && $result['id']) {
			$id = $result['id'];
			$orderNum = $result['order_number'];
			$sql = "SELECT tracking_number FROM ups_pending_tracking_numbers WHERE order_number_id = $id;";
			$trackingNums = $this->db_query($sql, 'select-multiple', true);
			$sql = "SELECT sku, quantity, is_internal_sku, `description` FROM ups_pending_order_expected_items WHERE order_number_id = $id;";
			$expectedItems = $this->db_query($sql, 'select-multiple', true);
			return array(
				'orderNum' => $orderNum,
				'trackingNums' => $trackingNums,
				'expectedItems' => $expectedItems
			);
		} else {
			return false;
		}
	}

	public function getExpectedItems($orderNumber)
	{
		$sql = "SELECT `sku`, `quantity` FROM ecomm_open_order_line_items WHERE `open_order_id`=(SELECT `id` FROM ecomm_open_orders WHERE `order_id`='$orderNumber');";
		$response = $this->db_query($sql, 'select-multiple', true);
		$items = array();
		foreach ($response as $itemData) {
			$item = array(
				'sku' => $itemData['sku'],
				'quantity' => $itemData['quantity'],
			);
			array_push($items, $item);
		}
		return $items;
	}

	private function getExpectedTrackingNums($orderNumber)
	{
		$sql = "SELECT `tracking_number` FROM `ecomm_open_order_tracking_numbers` WHERE `open_order_id`=(SELECT `id` FROM `ecomm_open_orders` WHERE `order_id`='$orderNumber');";
		$response = $this->db_query($sql, 'select-multiple', true);
		$trackingNums = array();
		foreach ($response as $trackingNumData) {
			array_push($trackingNums, $trackingNumData['tracking_number']);
		}
		return $trackingNums;
	}

	public function getExpectedItemsAndTrackingNums($orderNumber)
	{
		$data = array(
			'items' => $this->getExpectedItems($orderNumber),
			'trackingNumbers' => $this->getExpectedTrackingNums($orderNumber)
		);
		return $data;
	}

	function getAssetNumberCounts($oNums)
	{
		$oNumArray = explode(',', $oNums);
		$searchString = "(";
		for ($i = 0; $i < count($oNumArray); $i++) {
			if ($i) {
				$searchString .= ', ';
			}
			$oNum = $oNumArray[$i];
			$searchString .= "'$oNum'";
		}
		$searchString .= ")";
		$sql = "SELECT asset, COUNT(asset) AS asset_count FROM ds_orders WHERE oNum IN $searchString GROUP BY asset ORDER BY asset ASC;";
		$assets = $this->db_query($sql, 'select-multiple', true);
		$returnArr = array(
			'oNums' => $oNums,
			'oNumArray' => $oNumArray,
			'query' => $sql,
			'items' => $assets
		);
		return $returnArr;
	}

	function get_order_num_from_tracking($trackingNo)
	{
		$query = 'SELECT ref1 AS orderNumber FROM ups_shipments WHERE tracking_no = "' . $trackingNo . '";';
		$data = $this->db_query($query, 'select-single', true);
		if (!$data['orderNumber']) {
			echo json_encode($data);
		} else {
			echo json_encode($data);
		}
	}

	function get_tracking_num_from_order($orderNo)
	{
		$query = "SELECT tracking_no AS trackingNumber FROM ups_shipments WHERE address1 != '1530 Montague Expressway' AND ref1 = '$orderNo';";
		$data = $this->db_query($query, 'select-multiple', true);
		echo json_encode($data);
	}

	function get_sp_nums_associated_with_order_num($orderNo)
	{
		$query = 'SELECT oNum, serialNumber FROM ds_orders WHERE cShipInstruct LIKE "%' . $orderNo . '%" ORDER BY oNum ASC;';
		$data = $this->db_query($query, 'select-multiple', true);
		echo json_encode($data);
	}

	function get_sp_num_from_serial($serialNo)
	{
		$query = 'SELECT oNum FROM ds_orders WHERE serialNumber = "' . $serialNo . '" ORDER BY oNum DESC';
		$data = $this->db_query($query, 'select-single', true);
		echo json_encode($data);
	}

	function confirm_sp_exists($spNo)
	{
		$query = 'SELECT oNum FROM ds_orders WHERE oNum = "' . $spNo . '";';
		$data = $this->db_query($query, 'select-single', true);
		echo json_encode($data);
	}

	function is_mts_order($orderNum)
	{
		return preg_match('/^(MTS\d{5,6})$/', trim($orderNum));
	}

	private function isEbayOrder($orderNum)
	{
		return preg_match('/^(\d{2}\-\d{5}\-\d{5})$/', trim($orderNum));
	}

	private function isNeweggOrder($orderNum)
	{
		return preg_match('/^\d{9}$/', trim($orderNum));
	}

	private function isAmazonOrder($orderNum)
	{
		return preg_match('/^(\d{3}\-\d{7}\-\d{7})$/', trim($orderNum));
	}

	private function getUpsShipServiceForNewegg($trackingNumber)
	{
		echo "<p>$trackingNumber</p>";
		$serviceCodeNum = substr(trim($trackingNumber), 8, 2);
		echo "<p>$serviceCodeNum</p>";
		$serviceCodeMapping = array(
			'01' => 'Next Day Air',
			'02' => '2nd Day Air',
			'03' => 'Ground',
			'29' => 'Next Day Air',
			'42' => 'Ground'

		);
		return $serviceCodeMapping[$serviceCodeNum] ? $serviceCodeMapping[$serviceCodeNum] : 'Standard Shipping';
	}

	private function getUpsCarrierCode($trackingNum)
	{
		$serviceCodeNum = substr(trim($trackingNum), 8, 2);
		$serviceCodeMapping = array(
			'01' => 'UPSNextDayAir',
			'02' => 'UPS2ndDayAir',
			'03' => 'UPSGround',
			'29' => 'UPSNextDayAir',
			'42' => 'UPSGround'

		);
		return $serviceCodeMapping[$serviceCodeNum] ? $serviceCodeMapping[$serviceCodeNum] : 'ShippingMethodStandard';
	}

	private function isUpsNum($trackingNum)
	{
		return preg_match('/^(1Z\d{2}AY\d{12})$/', $trackingNum);
	}

	private function insertOrderState($state, $zohoId = '', $orderId = '')
	{
		$result = 0;
		if ($orderId && $orderId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ('$orderId', (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
			$result = $this->db_query($insertQuery, 'insert', true);
		} elseif ($zohoId && $zohoId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ((SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId' LIMIT 1), (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
			$result = $this->db_query($insertQuery, 'insert', true);
		}
		return $result;
	}

	private function insertOrderStateDebug($state, $zohoId = '', $orderId = '')
	{
		$result = 0;
		echo "<h3>In insertOrderState debug. Passed params: state - $state, zohoId - $zohoId, orderId - $orderId</h3>";
		$hasOrderId = $orderId && $orderId != '' ? true : false;
		echo "<p>Has order id: $hasOrderId</p>";
		$hasZohoId = $zohoId && $zohoId != '' ? true : false;
		echo "<p>Has zoho id: $hasZohoId</p>";
		if ($orderId && $orderId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ('$orderId', (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
			$result = $this->db_query($insertQuery, 'insert', true);
		} elseif ($zohoId && $zohoId != '') {
			$insertQuery = "INSERT IGNORE INTO `orders_states`(`order_id`, `state_id`) VALUES ((SELECT `id` FROM `order_ship_log` WHERE `zoho_id`='$zohoId' LIMIT 1), (SELECT `id` FROM `states` WHERE `name`='$state' OR `abbreviation`='$state' LIMIT 1));";
			$result = $this->db_query($insertQuery, 'insert', true);
		}
		echo "<h3>State: insertQuery</h3>";
		echo "<p>$insertQuery</p>";
		return $result;
	}

	private static function getShippers()
	{
		$db = new Database;
		$sql = "SELECT * FROM freight_carriers ORDER BY `name` ASC;";
		$results = $db->db_query($sql, 'select-multiple');
		$shippers = array();
		foreach ($results as $result) {
			$shipper = new stdClass;
			$shipper->id = $result['id'];
			$shipper->name = $result['name'];
			array_push($shippers, $shipper);
		}
		return $shippers;
	}
}
