<?php

class Dropbox {
    
    var $token;
    var $uploadurl = 'https://content.dropboxapi.com/2/files/upload';
    var $shareurl = 'https://api.dropboxapi.com/2/sharing/create_shared_link';
    var $deleteurl = 'https://api.dropboxapi.com/2/files/delete';
    
    function __construct($token) {
        $this->token = $token;
    }
    
    public function upload($file,$folder){
        
        $headers = array('Authorization: Bearer '. $this->token,
            'Content-Type: application/octet-stream',
            'Dropbox-API-Arg: {"path":"/'.$folder.'/'.basename($file).'","mode":{".tag":"overwrite"}}'
        );
        
        $path = $file;
        $fp = fopen($path, 'rb');
        $filesize = filesize($path);
        
        $data = fread($fp, $filesize);
       
        return $this->sendCurlRequest($data, $headers, $this->uploadurl);
        
    }
    
    public function delete($file){
        
        $headers = array('Authorization: Bearer '. $this->token,
            'Content-Type: application/json'
        );
        
        $data = '{"path":"'.$file.'"}';
       
        return $this->sendCurlRequest($data, $headers, $this->deleteurl);
        
    }
    
    public function getImageURL($file){
        
        $headers = array('Authorization: Bearer '. $this->token,
            'Content-Type: application/json'
        );
        
        $data = '{"path":"'.$file.'"}';
        
        $response = (array)json_decode($this->sendCurlRequest($data, $headers, $this->shareurl));
        
        $result = str_replace(array('www.dropbox.com','?dl=0'),array('dl.dropboxusercontent.com',''), $response['url']);
        
        return $result;
        
    }

    private function sendCurlRequest($data,$headers,$url) {
        try {
            $ch = curl_init($url);

            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POST, true);


            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);
           
            curl_close($ch);
            
            return $response;
            
        } catch (Exception $exception) {
            echo 'Exception Message: ' . $exception->getMessage() . '<br/>';
            echo 'Exception Trace: ' . $exception->getTraceAsString();
        }
    }
}
