<?php

class Database extends Framework {

	# DATABASE CONNECTION
	function db_connect() {
		$conn = mysql_pconnect(DB_SERVER, DB_USER, DB_PASS)
			or $this->error_page(SITE_ERROR . ' :: Unable to connect to the database server.');
		mysql_select_db(DB_DBASE, $conn)
			or $this->error_page(SITE_ERROR . ' :: Unable to select the database.');
		return $conn;
	}

	# DELETES RECORDS - RETURNS NUMBER ROWS
	function db_delete($table, $key, $val, $show_error=true) {
		$sql = '
			delete from ' . $table . '
			where ' . $key . ' = ' . $this->qualify_value($val) . '
		';
		return $this->db_query($sql, 'delete', $show_error);
	}

	# APPLIES TABLE INSERT FROM ARRAY - RETURNS INSERT ID
	function db_insert($table, $data, $show_error=true) {
		$data2 = array();
		foreach ($data as $key => $val) {
			$data2[] = $this->qualify_value($val, $key);
		}
		$sql = 'insert into ' . $table
			. ' (' . implode(', ', array_keys($data)) . ')'
			. ' values (' . implode(', ', $data2) . ')';
		return $this->db_query($sql, 'insert', $show_error);
	}

	# DATABASE QUERY - RETURNS NUM RECORDS OR DATA SET
	function db_query($sql, $type, $show_error = false) {
		$conn = $this->db_connect();
		$result = mysql_query($sql, $conn);
		$error = mysql_error();
		if ($error && $show_error) {
			$this->error_page(SITE_ERROR . ' :: database :: ' . $error . '<br /><br />' . $sql);
		}
		switch ($type) {
			case 'insert':
				return mysql_insert_id();
				break;
			case 'select-single':
				if (mysql_num_rows($result)) {
					return mysql_fetch_array($result);
				}
				break;
			case 'select-multiple':
				if (mysql_num_rows($result)) {
					$val = array();
					while ($row = mysql_fetch_array($result)) {
						$val[] = $row;
					}
					return $val;
				}
				break;
			case 'update':
				return mysql_affected_rows();
				break;
			case 'delete':
				return mysql_affected_rows();
				break;
                        case 'stored-proc':
                                return true;
                                break;
		}
		return false;
	}

	# DATABASE SELECT BUILDER - RETURNS ARRAY
	function db_select($table, $get, $cond, $extra, $join, $type, $show_error=true) {
		$sql = 'select ' . $get . ' from ' . $table . ' ';
		foreach ($join as $val) {
			$sql .= 'join ' . $val . ' ';
		}
		$i = 0;
		foreach ($cond as $key => $val) {
			if ($i == 0) {
				$sql .= 'where (' . $key . ' = ' . $this->qualify_value($val) . ') ';
			} else {
				$sql .= 'and (' . $key . ' = ' . $this->qualify_value($val) . ') ';
			}
			$i++;
		}
		return $this->db_query($sql . $extra, 'select-' . $type, $show_error);
	}
	function db_select_single($table, $get, $cond=array(), $extra='', $join=array(), $show_error=true) {
		return $this->db_select($table, $get, $cond, $extra, $join, 'single', $show_error);
	}
	function db_select_multiple($table, $get, $cond=array(), $extra='', $join=array(), $show_error=true) {
		return $this->db_select($table, $get, $cond, $extra, $join, 'multiple', $show_error);
	}

	# LAUNCHES MYSQL TABLE EDITOR APP
	function db_tableedit($table, $sort, $key, $titles, $noedit=array(), $nodisp=array()) {
		define(TABLE_EDITOR, '
		<style type="text/css">
		.tableeditor { border:0; text-align:left; float:left; width:300px; background: #eee; margin-bottom:5px; }
		.tableeditor ul { margin:0; padding:0; list-style:none; }
		.tableeditor ul li { margin:0; padding:0; color:#666; }
		.tableeditor ul li input { display:block; margin: 0 0 10px 0; border:1px solid #ccc; }
		.tableeditor ul li textarea { display:block; margin: 0 0 10px 0; border:1px solid #ccc; }
		</style>
		<div style="width:1000px;text-align:left;">
			<p>__LINKS__</p>
			__BODY__
			<div style="clear:both;"> </div>
		</div>
		<script type="text/javascript">
		function confirmDelete() {
			if (!confirm(\'Are you sure you wish to permanently delete this record?\')) {
				return false;
			} else {
				return true;
			}
		}
		</script>
		');
		$fields = array();
		$updates = array();
		$output = '';
		$populated = '';
		$links = array();
		$per_page = 5;
		$limit = is_numeric($_GET['limit']) ? $_GET['limit'] : 0;

		# GET FIELD LISTS/SIZES FROM MYSQL
		$keys = $this->get_table_fields($table);
		foreach ($keys[1] as $field => $size) {
			if ($title != $titles[$field]) {
				$title = $field;
			}
			if (in_array($field, $nodisp)) {
				$fields[] = '<input type="hidden" name="' . $field . '" value="' . $field . 'VAL" />';
			} else if (in_array($field, $noedit)) {
				$fields[] = $title . ': ' . $field . 'VAL<input type="hidden" name="' . $field . '" value="' . $field . 'VAL" />';
			} else if ($size > 60) {
				$fields[] = $title . ':<textarea name="' . $field . '" cols="35" rows="8">' . $field . 'VAL</textarea>';
				$updates[$field] = $_POST[$field];
			} else {
				$fields[] = $title . ':<input type="text" name="' . $field . '" size="35" maxlength="' . $size . '" value="' . $field . 'VAL" />';
				$updates[$field] = $_POST[$field];
			}
		}

		# HANDLE FORM SUBMISSIONS
		if ($val = $_POST[$key]) {
			if ($_POST['submit'] == "ADD") {
				$this->db_insert($table, $updates);
			} else if ($_POST['submit'] == "DELETE") {
				$this->db_delete($table, $key, $val);
			} else {
				$this->db_update($table, $key, $val, $updates);
			}
		}

		# CREATE RECORD TEMPLATE FORM HTML
		$form = '<fieldset class="tableeditor"><form method="post" action="' . $_SERVER['REQUEST_URI'] . '"><ul>' . "\n"
				. '<li>' . implode("</li>\n<li>", $fields) . "</li>\n</ul>__BUTTONS__</form></fieldset>\n";
		$data = $this->db_select_multiple($table, implode(', ', $keys[0]), array(), 'order by ' . $sort . ' desc limit ' . $limit . ', ' . $per_page);

		# POPULATE TEMPLATE WITH RECORDS
		foreach ($data as $row) {
			$populated = $form;
			foreach ($row as $field => $val) {
				$populated = str_replace($field . 'VAL', addcslashes(stripslashes($val), '"'), $populated);
			}
			$output .= $this->parse($populated, array(
					'BUTTONS' => '<input type="submit" name="submit" value="SAVE" /> '
					. '<input type="submit" name="submit" value="DELETE" onclick="return confirmDelete();" />'
				)
			);
		}

		# CREATE ADD RECORD TEMPLATE
		foreach ($keys[0] as $field) {
			$form = str_replace($field . 'VAL', '', $form);
		}
		$output .= $this->parse($form, array('BUTTONS' => '(+) <input type="submit" name="submit" value="ADD" />'));

		# CREATE PREV/NEXT LINKS
		if ($limit > 0) {
			$links[] = '<input type="button" onclick="window.location.href=\'' . $_SERVER['REQUEST_URI'] . '&limit=' . ($limit - $per_page) . '\';" value="&#171; Previous ' . $per_page . '" />';
		}
		$links[] = '<input type="button" onclick="window.location.href=\'' . $_SERVER['REQUEST_URI'] . '&limit=' . ($limit + $per_page) . '\';" value="Next ' . $per_page . ' &#187;" />';

		# OUTPUT WITHIN OUTER TEMPLATE AND WITH CSS
		echo $this->parse(TEMPLATE, array(
				'BODY' => $this->parse(TABLE_EDITOR, array('BODY' => $output)), 'LINKS' => implode("\n", $links)
			)
		);
	}

	# APPLIES TABLE UPDATE FROM ARRAY - RETURNS NUMBER ROWS
	function db_update($table, $key, $key_id, $data, $key2=false, $key2_id=0, $show_error=true) {
		$data2 = array_keys($data);
		$sql = 'update ' . $table . ' set ';
		$i = 0;
		foreach($data as $aKey => $aVal) {
			if ($i) {
				$sql .= ', ';
			}
			$sql .= $aKey . '=' . $this->qualify_value($aVal, $aKey);
			$i++;
		}
		$sql .= ' where ' . $key . '=' . $this->qualify_value($key_id, $key);
		if ($key2) {
			$sql .= ' and ' . $key2 . '=' . $this->qualify_value($key2_id, $key2);
		}
		return $this->db_query($sql, 'update', $show_error);
	}

	# TABLE SCHEMA - RETURNS ARRAY
	function get_table_fields($table) {
		$data2 = array();
		$data3 = array();
		$sql = 'show columns from ' . $table;
		$data = $this->db_query($sql, 'select-multiple');
		foreach ($data as $row) {
			$data2[] = $row[0];
			switch (substr($row[1], 0, 4)) {
				case 'blob':
					$row[1] = 255;
					break;
				case 'text':
					$row[1] = 255;
					break;
				case 'floa':
					$row[1] = 7;
					break;
				case 'date':
					$row[1] = 10;
					break;
				case 'bool':
					$row[1] = 1;
					break;
				default:
					$row[1] = str_replace('varchar(', '', $row[1]);
					$row[1] = str_replace('char(', '', $row[1]);
					$row[1] = str_replace('int(', '', $row[1]);
					$row[1] = str_replace(')', '', $row[1]);
					if (!is_numeric($row[1]) || $row[1] < 1) {
						$row[1] = 40;
					}
			}
			$data3[$row[0]] = $row[1];
		}
		return array($data2, $data3);
	}

	# QUERY BUILDER - DETERMINES (NUMERIC | TIMESTAMP | STRING), ESCAPES
	function qualify_value($value, $key='') {
		global $leading_zero_fields;
		$conn = $this->db_connect();

		# HANDLE EMPTY VALUES
		if (!$value) {
			return "''";

		# HANDLE SEARCH VALUES
		} else if ($key == 'WILD') {
			return '\'%' . mysql_real_escape_string(stripslashes($value), $conn) . '%\'';

		# HANDLE NUMERIC VALUES
		} else if (is_numeric($value)) {

			# SUPPORT FOR UNIX TIMESTAMPS - NOT TO BE CONFUSED WITH 10-DIGIT PHONES OR EXPONENTS
			if ($value > 946684800
				&& $value < 1577836800
				&& !stristr($key, 'phone')
				&& !stristr($key, 'fax')
				&& !strchr($value, 'e')) {
				return "from_unixtime($value)";
			}

			# SUPPORT FIELDS WITH LEADING ZEROS
			if (in_array($key, $leading_zero_fields)) {
				return "'$value'";
			}

			# OTHER NUMBER
			return $value;

		# HANDLE STRING VALUES
		} else {

			# SUPPORT FOR CONCAT FUNCTION
			if (stristr($value, 'concat(')) {
				return $value;
			}

			# REGULAR STRING - ESCAPE AND PREVENT SQL INJECTION
			$value = mysql_real_escape_string(stripslashes($value), $conn);
			return "'$value'";
		}
	}
	function resetAutoIncrement($table) {
		$resetAutoIncrementQuery = array(
			"SET @newMax = IFNULL((SELECT MAX(id) + 1 FROM $table), 1);",
			"SET @newQuery = CONCAT('ALTER TABLE $table AUTO_INCREMENT=', @newMax);",
			"PREPARE stmt FROM @newQuery;",
			"EXECUTE stmt;",
			"DEALLOCATE PREPARE stmt;"
		);
		for ($i=0; $i < count($resetAutoIncrementQuery); $i++) {
			$this->db_query($resetAutoIncrementQuery[$i], 'update', true);
		}
	}

	public function getTableFields($table) {
		$tableFields = array();
		$sql = "SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE `TABLE_SCHEMA`='macservice' AND `TABLE_NAME`='$table';";
		$results = $this->db_query($sql, 'select-multiple', true);
		foreach ($results as $result) {
			if (is_array($result)) {
				array_push($tableFields, $result[0]);
			} else {
				array_push($tableFields, $result);
			}
		}
		return $tableFields;
	}
}

?>
