<?php

class Customer extends Database {
    # LOGIC FOR CUSTOMER MY ACCOUNT AREA

    function account_detail($customer, $submitted, $action, $message, $oNum, $token, $PayerID, $transID, $stamp, $cString) {
        global $pmtObj, $searchObj, $orderObj, $adminObj, $my_account_edit_fields, $my_account_order_edit_fields, $page_titles;
        $updates = '';

        # ACCOUNT AREA SIGN-IN FORM
        if (!$customer && $action != 'save_account_email') {
            echo $this->parse(
                    TEMPLATE, array(
                'TITLE' => $page_titles['Account'], 'AREA' => 'Account', 'BODY' => $this->parse(
                        ACCOUNT_LOGIN, array('MESSAGE' => $message)
                )
                    )
            );
            exit;
        }

        # EDITING CUST DATA
        if (in_array($action, array('edit_account', 'save_account_card', 'save_account_email'))) {

            # SAVING CUST CHANGES
            if ($action == 'save_account_card') {
                list($customer, $updates) = $this->update($customer, $updates, $submitted);
                if ($updates) {
                    $this->email_password($submitted['cEmail']);
                }
            } else if ($action == 'save_account_email') {
                if (!$customer = $this->consolidate($submitted['cEmailPrevious'], $submitted['cStringPrevious'], $submitted)) {
                    $customer = $this->find($submitted['cEmailPrevious'], '', $cString);
                    $updates .= '<p class="error">' . PASSWORD_CONFLICT2 . '</p>';
                }
            }
            $output =
                    $orderObj->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 2))
                    . $updates . $this->parse(EDIT_CARD, array('EMAIL' => $customer['cEmail']
                        , 'FIELDS' => $adminObj->get_fields('ds_customers', $customer, 1, $my_account_edit_fields)
                            )
            );

            # VIEWING BACKUP LOG
        } else if ($action == 'account_backup_detail' && $stamp) {
            $output = $orderObj->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 1))
                    . $this->show_backup($customer['cString'], $stamp);

            # EDITING EMAIL ADDRESS
        } else if ($action == 'edit_account_email') {
            $output =
                    $orderObj->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 2))
                    . $updates . $this->parse(CHANGE_EMAIL, array(
                        'EMAIL' => $customer['cEmail']
                        , 'PASS' => $customer['cPass']
                        , 'CLIENT_ID' => $customer['clientID']
                        , 'CSTRING' => $customer['cString']
                            )
            );

            # SHOW DASHBOARD
        } else if (!$oNum) {
            $history = $this->parse_history('account', $customer['cString'], ($action == 'more'));
            $output = $orderObj->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 1)) . $this->parse(
                            ACCOUNT_DASHBOARD, array(
                        'HISTORY' => $history, 'BACKUPS' => $this->get_backups($customer['cString'])
                            )
            );

            # VIEWING ORDER
        } else {
            $data = $orderObj->get_data($oNum);
            if (!$data || $data['customer_id'] != $customer['cString']) {
                $this->error_page(PASSWORD_CONFLICT);
            }

            # PAYMENT SERVICE PROCESSING
            if ($action == 'account_paypal_service') {
                $output = $pmtObj->paypal_service($oNum, $data, $token, $PayerID);

                # ORDER EDIT FORM
            } else if ($action == 'edit_account_order') {
                $data = $orderObj->get_data($oNum, array('*'), true); # LOAD CC INTO SESS
                $cString = $data['cID'];
                $output =
                        $orderObj->parse_order(ACCOUNT_HEADER, $customer, array('STEP' => 1))
                        . $this->parse(EDIT_ORDER, array('ONUM' => $oNum, 'FIELDS' => $adminObj->get_fields(
                                    'ds_orders', $data, 1, $my_account_order_edit_fields
                            )
                                )
                );

                # ORDER SUMMARY
            } else {

                # ADD NOTE
                if ($action == 'add_account_note' && $submitted['nNote']) {
                    $data['nNote'] = $submitted['nNote'];
                    $data['nStatus'] = 'external';
                    if ($orderObj->insert_note($oNum, $data, 'Y')) {
                        $updates .= '<p><font size="2"><strong>' . SUCCESS_NOTE . '</strong></font></p>';
                    }
                }

                # RUN ORDER UPDATE PROCESS, SAVING CHANGED FIELDS TO DATA ARRAY
                if ($action == 'save_account_order') {
                    list($data, $updates) = $orderObj->update(
                            $oNum, $updates, $data, $my_account_order_edit_fields, $submitted, true
                    );

                    # IF ORDER IN AWAITING PAYMENT, ATTEMPT TO CHARGE AND CLOSE ORDER
                    if ($data['cStatus'] == STATUS_PAYMENT && $data['ccExp']) {
                        $data['ccExpMonth'] = $this->format_date('cc_month', $data['ccExp']);
                        $data['ccExpYear'] = $this->format_date('cc_year', $data['ccExp']);
                        list($trans_bool, $trans_data) = $pmtObj->payflowpro_service($data, $oNum, 'S', $data['cTotal']);
                        if (!$trans_bool) {
                            $updates .= '<p class="error">' . implode('<br />', $trans_data);
                            $orderObj->email_charge_fail($oNum, $data);
                        } else {
                            $orderObj->payment_service_received($oNum, $trans_data, $data);
                        }
                    }
                }
                if ($transID) {
                    $updates .= '<p><font size="2"><strong>' . SUCCESS_PAYMENT . '</strong></font></p>';
                }
                $output = $orderObj->detail($oNum, $customer, $data, $updates);
            }
        }

        # DISPLAY PAGE
        echo $this->parse(TEMPLATE, array('TITLE' => $page_titles['Account'], 'AREA' => 'Account', 'BODY' => $output));
    }

    # IPHONE ACCOUNT DETAIL - RETURNS XML AND EXITS

    function account_detail_iphone($xml) {
        global $orderObj, $cartObj;
        if (!$xObj = simplexml_load_string($xml)) {
            die('Error: Not a well formed XML request.');
        }
        switch ('' . $xObj->action) {
            case 'login':
                if ($_COOKIE['customerID']) {
                    $_COOKIE['customerID'] = '';
                }
                if ($data = $this->find('' . $xObj->cEmail, '' . $xObj->cPass)) {
                    die($this->parse_iphone_xml('', 'login', $data));
                } else {
                    die($this->parse_iphone_xml('Unable to locate matching account.'));
                }
                break;
            case 'list':
                if ($orders = $this->get_history('' . $xObj->cString)) {
                    $data = array();
                    foreach ($orders as $order) {
                        $data[] = $orderObj->get_data($order);
                    }
                    die($this->parse_iphone_xml('', 'list', $data));
                } else {
                    die($this->parse_iphone_xml('Unable to locate order history.'));
                }
                break;
            case 'order_detail':
                if ($data = $orderObj->get_data('' . $xObj->oNum)) {
                    if ($data['customer_id'] != '' . $xObj->cString) {
                        die('Requested order does not match customer account.');
                    }
                    if ($data['cEmail'] != '' . $xObj->cEmail) {
                        die('Requested order does not match customer email.');
                    }
                    $data['histArr'] = $orderObj->get_history('' . $xObj->oNum);
                    $data['cartArr'] = $cartObj->get_data($data['cID']);
                    $data['noteArr'] = $orderObj->get_notes('' . $xObj->oNum);
                    die($this->parse_iphone_xml('', 'order', $data));
                } else {
                    die($this->parse_iphone_xml('Unable to locate the requested order.'));
                }
                break;
            case 'customer_detail':
                if ($data = $this->get_data('' . $xObj->cString)) {
                    if ($data['cEmail'] != '' . $xObj->cEmail) {
                        die('Requested customer record does not match customer email.');
                    }
                    die($this->parse_iphone_xml('', 'customer', $data));
                } else {
                    die($this->parse_iphone_xml('Unable to locate customer record.'));
                }
                break;
            default:
                die($this->parse_iphone_xml('Invalid action requested.'));
        }
    }

    # FOR EMAIL ADDRESS CHANGES, CHECK FOR PRE-EXISTANCE AND CONSOLIDATE RECORDS - RETURNS C-STRING

    function consolidate($cEmail, $cString, $submitted) {
        global $orderObj;

        # MAKE SURE THE NEW EMAIL WAS SET
        if (!strchr($submitted['cEmail'], '@')) {
            return false;
        }

        # LOOK FOR CUSTOMER RECORD FOR NEW EMAIL
        if ($data = $this->get_data($submitted['cEmail'])) {

            # FOUND RECORD BUT PASSWORDS DON'T MATCH, FAIL
            if ($data['cPass'] != $submitted['cPass']) {
                return false;

                # PASSWORDS MATCH - ASSOCIATE ORDERS WITH DESTINATION ACCOUNT
            } else {
                $sql = '
					update ds_orders set customer_id = "' . $data['cString'] . '",
					cEmail = ' . $this->qualify_value($submitted['cEmail']) . '
					where cEmail in (
						' . $this->qualify_value($cEmail) . '
						, ' . $this->qualify_value($submitted['cEmail']) . '
					)
				';
                $this->db_query($sql, 'update');
                $this->db_delete('ds_customers', 'cEmail', $cEmail);
            }

            # NEW EMAIL HAS NO RECORD, CHANGE EMAIL ON RECORD AND ASSOCIATED ORDERS
        } else {
            $this->db_update(
                    'ds_customers', 'cString', $cString, array('cEmail' => $submitted['cEmail'])
            );
            $this->db_update(
                    'ds_orders', 'customer_id', $cString, array('cEmail' => $submitted['cEmail'])
            );
        }

        # RE-SET CUSTOMER DATA, OR LOG INTO NEW ACCOUNT
        $customer = $this->find($submitted['cEmail'], $submitted['cPass'], '', $submitted, $submitted['clientID']);
        return $customer;
    }

    # SEND FORGOT PASSWORD EMAIL - RETURNS BOOL

    function email_password($email, $site = false, $send = true) {
        global $orderObj;

        $data = $this->get_data($email);
        if ($data) {
            $new_password = $this->generateStrongPassword(10, false, 'lud');
            $this->db_update('ds_customers', 'cEmail', $email, array('cPass' => md5($new_password)));
            $data = $this->get_data($email);
            $data['cPass'] = $new_password;
            if ($send) {
                if ($site) {
                    $data['oNum'] = $site;
                }
                if ($this->send_email(
                                $email
                                , $orderObj->parse_order('__INFO_FROM_EMAIL__', $data)
                                , $orderObj->parse_order(FORGOT_PASS_SUBJECT, $data)
                                , $orderObj->parse_order(FORGOT_PASS_EMAIL, $data)
                        )
                ) {
                    return true;
                }
            } else {
                return $data['cPass'];
            }
        }
        return false;
    }

    function generateStrongPassword($length = 10, $add_dashes = false, $available_sets = 'luds')
    {
            $sets = array();
            if(strpos($available_sets, 'l') !== false)
                    $sets[] = 'abcdefghjkmnpqrstuvwxyz';
            if(strpos($available_sets, 'u') !== false)
                    $sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
            if(strpos($available_sets, 'd') !== false)
                    $sets[] = '23456789';
            if(strpos($available_sets, 's') !== false)
                    $sets[] = '!@#$%&*?';

            $all = '';
            $password = '';
            foreach($sets as $set)
            {
                    $password .= $set[array_rand(str_split($set))];
                    $all .= $set;
            }

            $all = str_split($all);
            for($i = 0; $i < $length - count($sets); $i++)
                    $password .= $all[array_rand($all)];

            $password = str_shuffle($password);

            if(!$add_dashes)
                    return $password;

            $dash_len = floor(sqrt($length));
            $dash_str = '';
            while(strlen($password) > $dash_len)
            {
                    $dash_str .= substr($password, 0, $dash_len) . '-';
                    $password = substr($password, $dash_len);
            }
            $dash_str .= $password;
            return $dash_str;
    }

    # SENDS TELL_A_FRIEND EMAIL

    function email_tellafriend($from, $to, $data, $sender = false) {
        global $orderObj;
        $cpCode = 'TF' . substr($this->createUniqueKey(), 0, 6);
        $body = TELL_A_FRIEND;
        $subject = TELL_A_FRIEND_SUBJECT;
        if ($sender) {
            $body = TELL_A_FRIEND_SENDER;
            $subject = T_A_F_SENDER_SUBJECT;
        }
        return $this->send_email(
                        $to, $from, $orderObj->parse_order($subject, $data)
                        , $orderObj->parse_order($body, $data, array('COUPON' => $cpCode)), 'text/plain'
        );
    }

    # SEND EMAIL FOR NEW CUSTOMER - RETURNS BOOL

    function email_welcome($data) {
        global $orderObj;
        if (!$data['cPass']) {
            $data['cPass'] = $this->email_password($data['cEmail'], $data['oNum'], false);
        }
        if ($this->send_email(
                        $data['cEmail']
                        , $orderObj->parse_order('__INFO_FROM_EMAIL__', $data)
                        , $orderObj->parse_order(CUST_CREATED_SUBJECT, $data)
                        , $orderObj->parse_order(CUSTOMER_WELCOME_EMAIL, $data)
                )
        ) {
            return true;
        }
        return false;
    }

    # FEEDBACK SUBMIT AND TELL-A-FRIEND PROCESS

    function feedback_submit($submitted) {
        global $orderObj;
        $this->insert_feedback($submitted);
        $this->send_email(
                SUPPORT_FROM, $submitted['cEmail'], 'Feedback'
                , "FROM: ${submitted['cBillFname']} ${submitted['cBillLname']}\n\n"
                . "ORDER NUMBER: ${submitted['oNum']}\n\nCOMMENTS:\n${submitted['comments']}\n", 'text/plain'
        );
        if ($friend = $submitted['friend1']) {
            if ($friend == $submitted['cEmail']) {
                $this->error_page('Error: Friend\'s email must be different from your own.');
            }
            $this->email_tellafriend($submitted['cEmail'], $friend, $this->get_data($submitted['cEmail']));
        }
        $this->goToUrl('feedbackok.html');
    }

    # GET CUSTOMER DATA AND SIGN-IN - RETURNS ARRAY

    function find($email, $password, $cString = '', $submitted = array(), $clientID = false) {

        # ALREADY LOGGED IN
        if ($_COOKIE['customerID']) {
            if ($row = $this->get_data($_COOKIE['customerID'])) {
                return $row;
            }
        }

        # SEARCH FOR CUST RECORD
        if (!$row = $this->get_data($email)) {
            if (!$row = $this->get_data($cString)) {

                # NEW CUSTOMER, TRY TO MAKE RECORD & SIGN-IN
                if ($submitted) {
                    $cString = $this->createUniqueKey();
                    setcookie('customerID', $cString);
                    return $this->insert($cString, $submitted);
                }
            }
        }

        # CHECK PASSWORD
        if ($password != PASS_SALT && md5($password) != $row['cPass']) {
            return false;
        }

        # SOLUTIONS AREA ACCOUNT NUMBER CHECK
        if (AREA == 'SOLUTIONS') {
            if (!$row['clientID'] || $clientID != $row['clientID']) {
                return false;
            }
        }

        # SIGN IN
        setcookie('customerID', $row['cString']);
        return $row;
    }

    # GETS LATEST TESTIMONIALS, WRITES TO FILE

    function generate_testimonials($num = 10, $start = 0) {
        $output = '';
        $feedback = $this->get_feedback($num, $start);
        foreach ($feedback as $i => $fb) {
            //just to ensure zip is in nl_coordinates
            $this->get_coordinates_from_zip($fb['cBillZip']);
            if ($content = $fb['content']) {
                if (strlen($content) > 80) {
                    $content = substr($content, 0, 80) . '...';
                }
                $output .= "\n" . '<li style="display:none;" id="testimonial' . $i . '" class="testimonial">'
                        . '<a href="' . CONTROLLER . '?m=testimonials">'
                        . '&quot;' . htmlspecialchars($content) . '&quot; &nbsp; ' . $fb['cBillFname']
                        . ' from ' . $fb['cBillCity'] . ', ' . $fb['cBillState'] . ' on ' . $fb['stamp'] . '</a></li>';
            }
        }
        $this->write_file(HTML_FOLDER . 'testimonials.inc', 'w', $output);
    }

    function generate_testimonials2($num = 10, $start = 0) {
        $output = '';
        $feedback = $this->get_feedback($num, $start);
        foreach ($feedback as $i => $fb) {
            //just to ensure zip is in nl_coordinates
            $this->get_coordinates_from_zip($fb['cBillZip']);
            if ($content = $fb['content']) {
                if (strlen($content) > 80) {
                    $content = substr($content, 0, 80) . '...';
                }
                $output .= "\n" . '<li style="display:none;" id="testimonial' . $i . '" class="testimonial">'
                        . '<a href="' . CONTROLLER . '?m=testimonials">'
                        . '&quot;' . htmlspecialchars($content) . '&quot; &nbsp; ' . $fb['cBillFname']
                        . ' from ' . $fb['cBillCity'] . ', ' . $fb['cBillState'] . ' on ' . $fb['stamp'] . '</a></li>';
            }
        }
        $this->write_file(HTML_FOLDER2 . 'testimonials.inc', 'w', $output);
    }

    # GET BACKUP LOGS - RETURNS HTML

    function get_backups($cString) {
        $output = '';
        if ($data = $this->db_select_single(
                'nl_clients', '*', array('cString' => $cString), 'limit 10'
                )
        ) {
            if (is_dir(BACKUP_LOG_PATH)) {
                $d = dir(BACKUP_LOG_PATH);
                while (false !== ($entry = $d->read())) {
                    $entry2 = explode('__', $entry);
                    if ($entry2[0] == $data['clientID']) {
                        $output .= '<a href="' . CONTROLLER . '?m=account_backup_detail&stamp=' . $entry2[1] . '"> '
                                . $this->format_date('templ_full', $entry2[1]) . ' &nbsp; '
                                . strtoupper($entry2[2]) . '</a><br /><br />';
                    }
                }
                $d->close();
            }
        }
        return $output;
    }

    # CHECKS DB LAT/LONG FROM ZIP, IF NOT FOUND QUERIES SERVICE ADS TO DB - RETURNS ARRAY

    function get_coordinates_from_zip($query) {
        if ($data = $this->db_select_single(
                'nl_coordinates', 'latitude, longitude', array('zip' => $query)
                )
        ) {
            return array($data['latitude'], $data['longitude']);
        }
        //the SimpleXMLElement call didn't work on the prod server, so changed to this.
        if ($xml = $this->tx_rx_curl('http://api.eyesis.ca/geo.xml?code=' . $query, '', '')) {
            $feed = simplexml_load_string($xml);
            if ($feed->Request->StatusCode == 200) {
                #'PostalCode'	=> (string) $feed->Details->PostalCode
                #, 'City'		=> (string) $feed->Details->City
                #, 'Province'	=> (string) $feed->Details->Province
                #, 'Country'	=> (string) $feed->Details->Country
                #, 'AreaCode'	=> (integer) $feed->Details->AreaCode
                #, 'TimeZone'	=> (integer) $feed->Details->TimeZone
                $latitude = (float) $feed->Details->Coordinates->Latitude;
                $longitude = (float) $feed->Details->Coordinates->Longitude;
                $this->db_insert(
                        'nl_coordinates', array('zip' => $query, 'latitude' => $latitude, 'longitude' => $longitude)
                );
                return array($latitude, $longitude);
            }
        }
        /* if ($feed = new SimpleXMLElement('http://api.eyesis.ca/geo.xml?code=' . $query, NULL, true)) {
          if ($feed->Request->StatusCode == 200) {
          #'PostalCode'	=> (string) $feed->Details->PostalCode
          #, 'City'		=> (string) $feed->Details->City
          #, 'Province'	=> (string) $feed->Details->Province
          #, 'Country'	=> (string) $feed->Details->Country
          #, 'AreaCode'	=> (integer) $feed->Details->AreaCode
          #, 'TimeZone'	=> (integer) $feed->Details->TimeZone
          $latitude = (float) $feed->Details->Coordinates->Latitude;
          $longitude = (float) $feed->Details->Coordinates->Longitude;
          $this->db_insert(
          'nl_coordinates', array('zip' => $query, 'latitude' => $latitude, 'longitude' => $longitude)
          );
          return array($latitude, $longitude);
          }
          } */
        return array();
    }

    # GETS ALL DATA FOR ORDER - RETURNS ARRAY

    function get_data($key) {
        if (is_numeric($key)) {
            $field = 'cID';
        } else if (strchr($key, '@')) {
            $field = 'cEmail';
        } else {
            $field = 'c.cString';
        }
        if ($data = $this->db_select_single(
                'ds_customers c', 'cl.*, c.*', array()
                , 'left join nl_clients cl on c.cString = cl.cString '
                . 'where ' . $field . ' = ' . $this->qualify_value($key)
                )
        ) {
            //$data['cPass'] = $this->rot13($data['cPass']);
            if (!$data['cShipEmail']) {
                $data['cShipEmail'] = $data['cEmail'];
            }
            return $data;
        }
        return false;
    }

    # GETS FEEDBACKS - RETURNS ARRAY

    function get_feedback($num = 100, $start = 0, $zip = '') {

        if ($zip != ''){

            $coords = $this->get_coordinates_from_zip($zip);

        }else{
            $zipfilter = '';
        }

        if ($zip == ''){
            $feedbacks = $this->db_select_multiple(
                    'nl_feedback f', 'machineType,cBillState,content,stamp,cBillFname,cBillCity,cBillZip', array('public' => 'Y')
                    , 'and cBillCity != "" group by fbID order by stamp desc limit ' . $start . ',' . $this->qualify_value($num)
                    , array('ds_orders o on f.cString = o.customer_id')
            );

        }else{

            $feedbacks = $this->db_query(
                    'select * from
                    (select machineType,cBillState,content,stamp,cBillFname,cBillCity,cBillZip,
                    SQRT(
                        POW(69.1 * (c.latitude - '.$coords[0].'), 2) +
                        POW(69.1 * ('.$coords[1].' - c.longitude) * COS(c.latitude / 57.3), 2)) as distance
                    from nl_feedback f
                    join ds_orders o on f.cString = o.customer_id
                    join nl_coordinates c on o.cBillZip = c.zip
                    where (public = "Y") and cBillCity != ""
                    group by fbID order by distance limit ' . $start . ',' . $this->qualify_value($num).')
                    as res order by stamp desc','select-multiple'
            );

        }


        foreach ($feedbacks as $key => $val) {
            $state = $this->get_state_name($val['cBillState']);
            $machine = $this->db_select_single('nl_sku_mappings', 'name', array('ds_sku' => $val['machineType']));
            $val['content'] = str_replace("\n", ' ', $val['content']);
            $val['content'] = str_replace("\r", ' ', $val['content']);
            $feedbacks[$key]['stamp'] = $this->format_date('templ_date', $val['stamp']);
            $feedbacks[$key]['cBillFname'] = ucwords($val['cBillFname']);
            $feedbacks[$key]['content'] = ereg_replace("[^0-9a-zA-Z ~`'!@#$%^&*()+=:;/?<>,._-]", '', $val['content']);
            $feedbacks[$key]['cBillCity'] = ucwords($val['cBillCity']);
            $feedbacks[$key]['cBillState'] = $state['long_description'];
            $feedbacks[$key]['machineType'] = $machine['name'];
        }
        return $feedbacks;
    }

    # GET CUSTOMER ORDER HISTORY - RETURNS ARRAY SET $limit TO 0 FOR NO LIMIT

    function get_history($cString, $limit = 100) {

        if ($limit > 0) {
            $extra = 'order by oID desc limit ' . $limit;
        } else {
            $extra = 'order by oID desc';
        }
        if ($orders = $this->db_select_multiple(
                'ds_orders', 'oNum', array('customer_id' => $cString)
                , $extra
                )
        ) {
            $orders2 = array();
            foreach ($orders as $order) {
                $orders2[] = $order['oNum'];
            }
            return $orders2;
        }
        return false;
    }

    # GETS MOST RECENT CC INFO FROM ORDER HISTORY - RETURNS ARRAY

    function get_most_recent_cc($cString) {
        global $orderObj;
        $_SESSION['ccNum'] = '';
        if ($cString == SQUARETRADE_CUST_ID) {
            return array();
        }
        if ($orders = $this->get_history($cString)) {
            foreach ($orders as $oNum) {
                $order = $orderObj->get_data($oNum);
                if ($order['CVV2'] && $order['ccName']) {
                    $order = $orderObj->get_data($oNum, array('*'), true); # LOADS CC INTO SESSION
                    return array(
                        'ccExp' => $order['ccExp'], 'ccName' => $order['ccName']
                        , 'CVV2' => $order['CVV2'], 'ccType' => $order['ccType']
                        , 'payment_method' => 'Credit Card'
                    );
                }
            }
        }
        return array();
    }

    # GETS ANY STORED NET TERMS OR RETURNS 30 - RETURNS INTEGER

    function get_perm_terms($cString) {
        $data = $this->get_data($cString);
        if ($data['po_terms']) {
            return $data['po_terms'];
        }
        return 30;
    }

    # GET STATE NAME FROM ABBREVIATION CODE

    function get_state_name($abbr) {
        return $this->db_select_single(
                        'ds_states', 'long_description', array('state_code' => $abbr)
        );
    }

    # ADD CUSTOMER RECORD - RETURNS ID

    function insert($cString, $submitted) {
        global $googleObj;
        if (!$this->get_data($submitted['cEmail'])) {
            if (!$submitted['cPass']) {
                $submitted['cPass'] = substr($cString, 0, 6);
            }
            //add customer details to Google Contacts
            // $googledata = array(
            //     'firstname' => $submitted['cBillFname']
            //     , 'lastname' => $submitted['cBillLname']
            //     , 'email' => $submitted['cEmail']
            //     , 'phone' => $submitted['cPhone']
            // );
            // $google_contact_id = $googleObj->addContact($googledata);
            // if ($google_contact_id === false) {
			$google_contact_id = '';
            // }
            $data = array(
                'cBillCompany' => $submitted['cBillCompany']
                , 'cBillFname' => $submitted['cBillFname']
                , 'cBillLname' => $submitted['cBillLname']
                , 'cBillAddress1' => $submitted['cBillAddress1']
                , 'cBillAddress2' => $submitted['cBillAddress2']
                , 'cBillCity' => $submitted['cBillCity']
                , 'cBillState' => $submitted['cBillState']
                , 'cBillZip' => $submitted['cBillZip']
                , 'cBillCountry' => $submitted['cBillCountry']
                , 'cPhone' => $submitted['cPhone']
                , 'cFax' => $submitted['cFax']
                , 'cHow' => $submitted['cHow']
                , 'billEqualShip' => $submitted['billEqualShip']
                , 'cShipCompany' => $submitted['cShipCompany']
                , 'cShipFname' => $submitted['cShipFname']
                , 'cShipLname' => $submitted['cShipLname']
                , 'cShipAddress1' => $submitted['cShipAddress1']
                , 'cShipAddress2' => $submitted['cShipAddress2']
                , 'cShipCity' => $submitted['cShipCity']
                , 'cShipState' => $submitted['cShipState']
                , 'cShipZip' => $submitted['cShipZip']
                , 'cShipCountry' => $submitted['cShipCountry']
                , 'cShipEmail' => $submitted['cShipEmail']
                , 'cEmail' => $submitted['cEmail']
                , 'cDateSince' => $this->format_date('db_date')
                , 'cString' => $cString
                , 'cPass' => md5($submitted['cPass'])
                , 'google_contact_id' => $google_contact_id
            );
            // $this->email_welcome($submitted);
            return $this->db_insert('ds_customers', $data);
        }
        return false;
    }

    # ADD FEEDBACK DB RECORD - RETURNS ID

    function insert_feedback($submitted) {
        $data = array(
            'stamp' => $this->format_date('db_full')
            , 'cString' => $submitted['cString']
            , 'content' => $submitted['comments']
        );
        return $this->db_insert('nl_feedback', $data);
    }

    # PARSES FEEDBACK ENTRY FORM - RETURNS HTML

    function parse_feedback($cString, $oNum) {
        $data = $this->get_data($cString);
        return $this->parse(FEEDBACK, array(
                    'FNAME' => $data['cBillFname'], 'LNAME' => $data['cBillLname']
                    , 'EMAIL' => $data['cEmail'], 'ONUM' => $oNum
                    , 'CSTRING' => $cString
                        )
        );
    }

    # PARSES FEEDBACK DISPLAY TEMPLATE - RETURNS HTML

    function parse_feedback_display($zip) {
        $position = '40, -90';
        $zoom = 4;
        $preserveViewport = 'true';
        if ($zip) {
            $preserveViewport = 'false';
            if (strlen($zip) > 5) {
                $zip = substr($zip, 0, 5);
            }
            if (is_numeric($zip)) {
                $coords = $this->get_coordinates_from_zip($zip);
                $position = $coords[0] . ', ' . $coords[1];
                $zoom = 8;
            }
        }

        $data = $this->get_feedback(100,0,$zip);
        $output = $this->parse(FEEDBACK_HEADER,
                                array(
                                    'POSITION' => $position,
                                    'ZOOM' => $zoom,
                                    'ZIP' => $zip,
                                    'PRESERVEVIEWPORT' => $preserveViewport,
                                    ));
        foreach ($data as $row) {
            $output .= $this->parse(FEEDBACK_ROW, array(
                'DATE' => $row['stamp']
                , 'NAME' => $row['cBillFname']
                , 'TEXT' => $row['content']
                , 'CITY' => $row['cBillCity'] . ', ' . $row['cBillState']
                , 'MACH' => $row['machineType']
                    )
            );
        }

        if (count($data) >= 100){
            $output .= '<p align="center">[ Displaying most recent 100 ]</p>';
        }
        return $output;
    }

    # PAGINATES ORDER HISTORY RESULTS

    function parse_history($area, $cString, $showall = false) {
        global $searchObj;
        $history = MISSING_HISTORY;
        if ($showall) {
            $data = $this->get_history($cString, 0);
        } else {
            $data = $this->get_history($cString, 5);
        }
        if ($data) {
            switch ($area) {
                case 'account':
                    $history = $searchObj->display_orders_account($data);
                    if (!$showall && sizeof($data) == 5) {
                        $history .= '<p align="center"><a href="' . CONTROLLER . '?area=account&m=more">show more</a></p>';
                    }
                    break;
                case 'admin':
                    $history = $searchObj->display_orders($data);
                    if (!$showall && sizeof($data) == 5) {
                        $history .= '<p><a href="' . CONTROLLER . '?m=customer_detail&history=1&cString=' . $cString . '">show more</a></p>';
                    }
                    break;
            }
        }
        return $history;
    }

    # GENERATES RESPONSES TO IPHONE WEB SERVICE CALLS - RETURNS XML

    function parse_iphone_xml($error_msg = '', $step = '', $data = array()) {
        $o = "<?xml version=\"1.0\" ?>\n<document>\n\t<error_msg>$error_msg</error_msg>\n";
        switch ($step) {
            case 'login':
                $o .= "\t<cString>${data['cString']}</cString>\n";
                break;
            case 'list':
                $o .= $this->array_to_xml('listArr', $data);
                break;
            case 'order':
                $o .= $this->array_to_xml('orderArr', $data);
                break;
            case 'customer':
                $o .= $this->array_to_xml('custArr', $data);
                break;
        }
        return $o . '</document>';
    }

    # CREATES RSS FEED FOR MY ACCOUNT

    function rss($cString) {
        global $orderObj, $order_statii, $machine_translations, $socialObj;
        $data = false;
        if (strlen($cString) == 8) {
            $data = $this->db_select_single(
                    'ds_customers', '*', array(), 'where cString like "' . addslashes($cString) . '%"'
            );
            $message1 = 'Welcome to your message center! - Order history and important status updates.';
        }
        if (!$data) {
            $data['cBillFname'] = 'Configure Your Account';
            $message1 =
                    'Please click the (i) button in the lower-right to configure your account. '
                    . 'This requires your identification code from My Account.';
        }
        $articles = array();
        $articles[] = array(
            'TITLE' => $data['cBillFname'] . ' ' . $data['cBillLname'], 'DESC' => $message1
        );
        if ($orders = $this->get_history($data['cString'], 3)) {
            foreach ($orders as $order) {
                $data = $orderObj->get_data($order);
                $articles[] = array(
                    'TITLE' => $order
                    . ' ' . $this->str_replace_from_array($data['machineType'], $machine_translations)
                    . ' ' . $data['processorSpeed']
                    , 'DESC' => $order_statii[$data['cStatus']]
                    , 'LINK' => SITE_SURL . CONTROLLER . '?oNum=' . $order
                );
            }
        }
        $articles[] = array(
            'TITLE' => 'My Account', 'DESC' => 'Your SSL secured control panel.'
            , 'LINK' => SITE_SURL . CONTROLLER . '?m=account'
        );
        return $socialObj->rss_2_0('MacService Message Center', $articles);
    }

    # DISPLAYS RSYNC BACKUP HISTORY

    function show_backup($cString, $stamp) {
        if ($data = $this->db_select_single('nl_clients', '*', array('cString' => $cString))) {
            $d = dir(BACKUP_LOG_PATH);
            while (false !== ($entry = $d->read())) {
                $entry2 = explode('__', $entry);
                if ($entry2[0] == $data['clientID'] && $entry2[1] == $stamp) {
                    return $this->parse(SOLUTIONS_BACKUP, array(
                                TITLE => $this->format_date('templ_full', $entry2[1]) . ' &nbsp; ' . strtoupper($entry2[2])
                                , BACKUPS => nl2br(implode('', file(BACKUP_LOG_PATH . $entry)))
                                    )
                    );
                }
            }
        }
        return '';
    }

    # MARKETING LIST SUBSCRIPTION - RETURNS BOOL

    function subscribe($email) {
        if (!$this->db_select_single('ds_subscribers', '*', array('email' => $email))) {
            return $this->db_insert('ds_subscribers', array('email' => $email));
        }
        return false;
    }

    # HANDLES FORM SUBMISSION OF TELL_A_FRIEND - RETURNS HTML

    function tellafriend_submit($submitted) {
        global $orderObj, $page_titles;
        if (!$submitted['cEmail']) {
            $submitted['cEmail'] = ORDERS_FROM;
        }
        $data = $this->get_data($submitted['cEmail']);
        foreach ($submitted['friend'] as $email) {
            if ($email) {
                $this->email_tellafriend($submitted['cEmail'], $email, $data);
            }
        }
        #$this->email_tellafriend(ORDERS_FROM, $submitted['cEmail'], $data, true);
        echo $this->parse(TEMPLATE, array(
            'TITLE' => $page_titles['Account'], 'AREA' => 'Account'
            , 'BODY' => '<br /><div class="pad15"><strong>Successfully emailed your friends.  Your code is: '
            . 'TF' . substr($this->createUniqueKey(), 0, 6) . ' Enjoy!</strong></div>'
            . $orderObj->parse_order(TELL_A_FRIEND_PAGE, $this->get_data($submitted['cEmail']))
                )
        );
    }

    # COMPARES POST DATA TO INPUT ARRAY, HANDLES SPECIAL FIELDS, UPDATES DATABASE - RETURNS ARRAY

    function update($data, $updates, $submitted) {
        global $orders_field_titles;

        # DETERMINE WHICH FIELDS HAVE BEEN UPDATED
        if ($changed_fields = $this->determine_which_updated($data, $submitted, array_keys($orders_field_titles))) {
            $newdata = array();

            # ADMIN AREA EMAIL CHANGE - CONSOLIDATE
            if (in_array('cEmail', $changed_fields)) {
                if ($submitted['cEmail']) {
                    if (!$customer = $this->consolidate(
                            $data['cEmail'], $data['cString'], array_merge($data, $submitted)
                            )
                    ) {
                        $updates .= '<p class="error">' . PASSWORD_CONFLICT2 . '</p>';
                    } else {
                        $this->goToUrl(CONTROLLER . '?m=customer_detail&cString=' . $customer['cString']);
                    }
                }
            }

            foreach ($changed_fields as $changed_field) {

                # SKIP EMAIL CHANGES, THIS IS PRE-PROCESSED FOR ADMIN AREA ONLY
                if ($changed_field == 'cEmail') {
                    continue;

                    # SPECIAL HANDLING OF PASSWORD
                } else if ($changed_field == 'cPass') {
                    if ($submitted['cPass']) {
                        $submitted['cPass'] = md5($submitted['cPass']);
                    } else {
                        continue;
                    }
                }

                # ALL FIELDS
                $newdata[$changed_field] = $submitted[$changed_field];
                $data[$changed_field] = $submitted[$changed_field];
            }
            if ($newdata) {
                if ($this->db_update('ds_customers', 'cString', $data['cString'], $newdata)) {
                    $updates .= '<p><font size="2"><strong>Successfully saved account changes.</strong></font>';
                }
            }
        }
        return array($data, $updates);
    }

}

?>
