<?php

class Cron extends Database
{
    # MAPS CRONTAB ARGUMENT/COMMAND WITH FUNCTION

    function run($cmd)
    {
        //set to correct timezone
        date_default_timezone_set(GSX_TIMEZONE);

        global $custObj;
        switch ($cmd) {
            case 'inprocess':
                $this->email_in_process_late();
                break;
            case '2weeksafter':
                $this->email_feedback_request();
                break;
            case 'importxls':
                $this->order_import_xls();
                break;
                //case 'neverreceived30': $this->email_never_received_30(); break;
            case 'neverreceived60':
                $this->email_never_received_60();
                break;
            case 'notreceived7':
                $this->email_not_received(7);
                break;
            case 'notreceived14':
                $this->email_not_received(14);
                break;
            case 'notreceived21':
                $this->email_not_received(21);
                break;
            case 'notreceived28':
                $this->email_not_received(28);
                break;
            case 'notreceived35':
                $this->email_not_received_35();
                break;
            case 'notreceived36':
                $this->charge_shipping_36();
                break;
                //case 'notreceivedtidy' : $this->email_not_received_tidy(); break;
                //case 'chargeshippingtidy' : $this->charge_shipping_tidy(); break;
            case 'upstomorrow':
                $this->email_ups_sched('tomorrow');
                break;
            case 'upstoday':
                $this->email_ups_sched('today');
                break;
            case 'upssignatures':
                $this->store_ups_signatures();
                break;
            case 'lbrextended':
                $this->email_lbr_extended();
                break;
            case 'markdelivered':
                $this->mark_delivered(STATUS_SHIP_2, STATUS_DELIVERED, 'ship_tracking_id3');
                break;
            case 'markreturntransit':
                $this->mark_return_transit(STATUS_BOX_DELIVERED, STATUS_RETURN_TRANSIT, 'ship_tracking_id2');
                $this->mark_return_transit(STATUS_SHIP_0, STATUS_RETURN_TRANSIT, 'ship_tracking_id2');
                $this->mark_return_transit(STATUS_RETURN, STATUS_RETURN_TRANSIT, 'ship_tracking_id2');
                break;
            case 'markboxdelivered':
                $this->mark_delivered(STATUS_SHIP_1, STATUS_BOX_DELIVERED, 'ship_tracking_id');
                break;
            case 'rsync':
                $this->rsync();
                break;
            case 'feedback_digest':
                $this->email_feedback_digest();
                break;
            case 'order2cust':
                $this->order_to_cust_card($_SERVER['argv'][3]);
                break;
            case 'testimonials':
                $custObj->generate_testimonials();
                break;
            case 'testimonials2':
                $custObj->generate_testimonials2();
                break;
            case 'boxoutcheck':
                $this->email_boxouts_late();
                break;
            case 'squaretrade':
                $this->email_squaretrade_csv();
                break;
            case 'awaitingparts':
                $this->email_awaiting_parts_late();
                break;
            case 'execsummary':
                $this->sms_summary($this->format_date('db_date'));
                break;
            case 'abandonednextday':
                $this->email_abandoned_checkouts_1day();
                break;
            case 'customerexportcsv':
                $this->customer_csv();
                break;
            case 'applecarereminder30':
                $this->applecare_email(30);
                break;
            case 'applecarereminder60':
                $this->applecare_email(60);
                break;
            case 'deletegooglecontacts':
                $this->deleteGoogleContacts();
                break;
            case 'diagnosticfollowup':
                $this->diagnostic_followup(1);
                $this->diagnostic_followup(2);
                $this->diagnostic_followup(3);
                $this->diagnostic_followup(4);
                $this->diagnostic_followup(6);
                $this->diagnostic_followup(8);
                $this->diagnostic_followup(10);
                $this->diagnostic_followup(12);
                $this->diagnostic_followup(14);
                $this->diagnostic_followup(16);
                $this->diagnostic_followup(18);
                $this->diagnostic_followup(20);
                $this->diagnostic_followup(22);
                $this->diagnostic_followup(24);
                $this->diagnostic_followup(26);
                $this->diagnostic_followup(28);
                $this->diagnostic_followup(30);
                break;
            case 'followupcallemail':
                $this->followup_call_email(15);
                $this->followup_call_email(30);
                break;
            case 'getquotes':
                $this->get_quotes();
                break;
            case 'getproductmodels':
                $this->get_product_models();
                break;
            case 'getmobileorders':
                $this->get_mobile_orders();
                break;
            case 'abandonedorderemail':
                $this->abandoned_order_email();
                break;
            case 'emailawaitingpayment':
                $this->email_awaiting_payment(1);
                $this->email_awaiting_payment(2);
                $this->email_awaiting_payment(3);
                $this->email_awaiting_payment(4);
                $this->email_awaiting_payment(6);
                $this->email_awaiting_payment(8);
                $this->email_awaiting_payment(10);
                $this->email_awaiting_payment(12);
                $this->email_awaiting_payment(14);
                $this->email_awaiting_payment(16);
                $this->email_awaiting_payment(18);
                $this->email_awaiting_payment(20);
                $this->email_awaiting_payment(22);
                $this->email_awaiting_payment(24);
                $this->email_awaiting_payment(26);
                $this->email_awaiting_payment(28);
                $this->email_awaiting_payment(30);
                break;
            case 'adminawaitingpayment':
                $this->admin_awaiting_payment(15);
                $this->admin_awaiting_payment(30);
                break;
            case 'payflowdailyactivity':
                $this->payflow_daily_activity();
                break;
            case 'repairlookupupdate':
                $this->update_repair_lookup();
                break;
            case 'timesheetnotsubmitted':
                $this->timesheet_not_submitted();
                break;
            case 'completepayperiod':
                $this->complete_pay_period();
                break;
            case 'emailstockorder':
                $this->email_stock_order();
                break;
            case 'printrefurbslips':
                $this->print_refurb_slips();
                break;
            case 'orderexports':
                $this->order_exports($_SERVER['argv']);
                break;
            case 'orderexportsnew':
                $this->orderExportsNew($_SERVER['argv']);
                break;
            case 'zohosync':
                $this->zoho_sync();
                break;
            case 'auditweekly':
                $this->email_audit_csv();
                break;
            case 'zohocontactsync':
                $this->zoho_contact_sync();
                break;
            case 'ebayorders':
                $this->get_ebay_orders();
                break;
            case 'ebayorderexport':
                $this->ebay_order_export($_SERVER['argv']);
                break;
            case 'verifyshipped':
                $this->verify_shipped();
                break;
            case 'fileexports':
                $this->file_exports();
                break;
            case 'zohoorderexports':
                $this->zoho_order_exports($_SERVER['argv']);
                break;
            case 'mergeexports':
                $this->merge_exports($_SERVER['argv']);
                break;
            case 'emailerrorlog':
                $this->email_error_log();
                break;
            case 'sevendayreminder':
                $this->seven_days_until_payment_due_reminder_email();
                break;
            case 'updateshopifyinventory':
                $this->updateShopifyInventory();
                break;
            case 'validateeligibleorders':
                $this->validateEligibleOrders();
                break;
            case 'amazonorderhistory':
                $this->getAmazonOrders();
                break;
            case 'updateopenorders':
                $this->updateOpenOrders();
                break;
            case 'updatereturns':
                $this->updateReturns();
                break;
            case 'emaillistimport':
                require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
                EmailListController::emailListImport();
                break;
            case 'emaillistupdate':
                require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
                EmailListController::updateEmailList(true, false);
                break;
            case 'imagingcompleteemail':
                $this->sendImagingCompleteEmail($_SERVER['argv']);
                break;
            case 'dailybackup':
                $this->queueDailyBackup($_SERVER['argv']);
                break;
            case 'uploaddailybackup':
                $this->uploadDailyBackup($_SERVER['argv']);
                break;
        }
    }

    function updateShopifyInventory()
    {
        global $invObj;
        $results = $invObj->updateShopifyInventory();
    }

    function printOpenOrders()
    {
        global $dbObj;

        require_once(HTML_FOLDER . "classes/class_worldship.php");
        $worldship = new Worldship;
        $sql = "SELECT eoo.order_id AS orderId, esc.identifier AS channel, eood.`status`, eood.`date_placed` FROM `ecomm_open_orders` AS eoo LEFT JOIN `ecomm_sales_channels` AS esc ON eoo.`channel_id` = esc.id LEFT JOIN `ecomm_open_order_details` AS eood ON eood.`open_order_id`= eoo.`id` WHERE eoo.`labels_printed` != '1' AND (eoo.`error` IS NULL OR eoo.`error` = '') AND eoo.`open`='1';";
        $orders = $dbObj->db_query($sql, 'select-multiple', true);
        $backmarketOrders = array();
        $ebayOrders = array();
        $neweggOrders = array();
        foreach ($orders as $order) {
            $channel = $order['channel'];
            $orderId = $order['orderId'];
            $status = $order['status'];
            $datePlaced = $order['date_placed'];
            $orderAge = $this->getOrderAge($datePlaced, 'Y-m-d H:i:s');
            if ($orderAge >= 1800) {
                if ($channel == 'newegg') {
                    array_push($neweggOrders, trim($orderId));
                } elseif ($channel == 'back_market' || $channel == 'backmarket') {
                    if ($status == 3) {
                        echo "Back Market order $orderId has status $status. Adding to array to be shipped.\n";
                        array_push($backmarketOrders, trim($orderId));
                    } else {
                        echo "Back Market order $orderId has status $status. NOT adding to array to be shipped.\n";
                    }
                } elseif ($channel == 'ebay_others' || $channel == 'ebay_auctions') {
                    array_push($ebayOrders, trim($orderId));
                }
            } else {
                echo "$channel order $orderId created at $datePlaced UTC is $orderAge seconds old, which is less than the 1800 seconds required to print. Bypassing.\n";
            }
        }
        if (count($backmarketOrders) > 0) {
            $worldship->shipBackMarketOrders($backmarketOrders, true);
        }
        if (count($ebayOrders) > 0) {
            $worldship->shipEbayOrders($ebayOrders, true);
        }
        if (count($neweggOrders) > 0) {
            $worldship->shipNeweggOrders($neweggOrders, true);
        }
    }

    function getAmazonOrders()
    {
        echo "Getting amazon order history\n";
        require_once('apis/amazon/AmazonMWS.php');
        echo "Required MWS\n";
        $amazon = new AmazonMWS;
        echo "Created MWS\n";
        $amazon->getFullOrderHistory('11');
        exit;
    }

    public function updateReturns()
    {
        $date = $this->getOneMonthAgoDate();
        $this->getAmazonReturns($date);
        $this->getNeweggReturns($date);
        $this->getEbayReturns($date);
        $this->getBackmarketReturns($date);
    }

    private function getAmazonReturns($date)
    {
        require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
        $amazon = new AmazonMWS;
        $channelId = $amazon->getAmazonChannelId();
        $refunds = $amazon->getRefundsSinceDate($date);
        foreach ($refunds as $refund) {
            $orderId = $refund->orderId;
            $ecommId = $refund->ecommId;
            $returnDate = $refund->returnDate;
            $returnAmount = $refund->returnAmount;
            $attempts = 0;
            while (!$ecommId && $attempts < 3) {
                $sql = "INSERT INTO `ecomm_ship_log`(`order_id`, `channel_id`, `subtotal`) VALUES ('$orderId','$channelId','$returnAmount');";
                $this->db_query($sql, 'insert', true);
                $ecommId = $amazon->getEcommId($orderId);
                $attempts++;
            }
            $sql = "INSERT INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$returnAmount') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$returnAmount';";
            $this->db_query($sql, 'insert', true);
        }
    }

    private function getNeweggReturns($date)
    {
        require_once(HTML_FOLDER . 'apis/newegg/class_newegg_api.php');
        $newegg = new NeweggAPI;
        $newegg->getRefundHistory();
    }

    private function getEbayReturns($date)
    {
        require_once(HTML_FOLDER . 'apis/ebay/class_ebay_api.php');
        $ebay = new EbayAPI;
        $ebay->getRefundHistory();
    }

    private function getBackmarketReturns($date)
    {
        require_once(HTML_FOLDER . "apis/backmarket/class_backmarket.php");
        $backmarket = new BackmarketAPI;
        $backmarket->resetAutoIncrement('ecomm_ship_log');
        $orders = $backmarket->getOrderHistory();
        $channelId = $backmarket->getChannelId();
        foreach ($orders as $order) {
            $orderId = $order->order_id;
            if (!$order->date_shipping) {
                // echo "<pre>";
                // print_r($order);
                // echo "</pre>";
                // $sql = "DELETE FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId';";
                // echo "No ship date found for Back Market $orderId";
                // $backmarket->db_query($sql, 'delete', true);
                $backmarket->resetAutoIncrement('ecomm_ship_log');
            } else {
                $invoiceDate = DateTime::createFromFormat(DATE_ATOM, $order->date_creation)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
                $shipDate = DateTime::createFromFormat(DATE_ATOM, $order->date_shipping)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
                $itemStatus = (int)$order->orderlines[0]->state;
                $subtotal = (float)$order->price;
                $price = (float)$order->orderlines[0]->price;
                $ecommId = $backmarket->getEcommId($orderId);
                if ($ecommId) {
                    $sql = "UPDATE `ecomm_shipping_details` SET `ship_date`='$shipDate' WHERE `ecomm_id`='$ecommId';";
                    $backmarket->db_query($sql, 'update', true);
                } else {
                    $shipMethod = $order->shipper;
                    $trackingNumber = $order->tracking_number;
                    $sku = $order->orderlines[0]->listing;
                    $quantity = $order->orderlines[0]->quantity;

                    // echo "<h1>Performing previously-unseen order inserts</h1>";

                    $sql = "INSERT IGNORE INTO `ecomm_back_market_listings`(`sku`) VALUES ('$sku');";
                    // echo "<p>$sql</p>";
                    $backmarket->db_query($sql, 'insert', true);
                    $backmarket->resetAutoIncrement('ecomm_back_market_listings');

                    $sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";
                    // echo "<p>$sql</p>";
                    $backmarket->db_query($sql, 'insert', true);
                    $backmarket->resetAutoIncrement('ecomm_ship_log');

                    $sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
                    $result = $backmarket->db_query($sql, 'select-single', true);
                    $ecommId = $result['id'];

                    $sql = "INSERT IGNORE INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod');";
                    // echo "<p>$sql</p>";
                    $backmarket->db_query($sql, 'insert', true);

                    $sql = "INSERT IGNORE INTO `ecomm_tracking_numbers`(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNumber');";
                    // echo "<p>$sql</p>";
                    $backmarket->db_query($sql, 'insert', true);

                    $sql = "INSERT IGNORE INTO `ecomm_back_market_listings_shipped`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `ecomm_back_market_listings` WHERE `sku`='$sku' LIMIT 1), '$ecommId', '$quantity');";
                    // echo "<p>$sql</p>";
                    $backmarket->db_query($sql, 'insert', true);

                    // echo "<p>Done!</p>";
                    // echo "<hr />";
                }
                if ($itemStatus > 3) {
                    $returnDate = DateTime::createFromFormat(DATE_ATOM, $order->date_modification)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
                    // echo "<h1>Returned order</h1>";
                    // echo "<p>Order ID: $orderId</p>";
                    // echo "<p>Ship Date: $shipDate</p>";
                    // echo "<p>Return date: $returnDate</p>";
                    // echo "<hr />";
                    if (!$ecommId) {
                        $ecommId = $backmarket->getEcommId($orderId);
                    }
                    if ($ecommId) {
                        $sql = "INSERT IGNORE INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$price') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$price';";
                        $backmarket->db_query($sql, 'insert', true);
                    }
                }
            }
        }
    }

    public function updateOpenOrders()
    {
        $this->updateBackmarketOrders();
        $this->updateAmazonOrders();
        $this->updateNeweggOrders();
        $this->updateEbayOrders();
        $this->updateTtsOrders();
    }

    private function updateInboundOrders()
    {
        require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
        PurchaseOrdersController::refreshPurchaseOrdersFromZoho();
    }

    public function updateAmazonOrders($debug = true)
    {
        require_once(HTML_FOLDER . 'classes/OrderTypes/AmazonOrder.php');
        $orderNumbers = array();

        $path_to_files = '/var/www/vhosts/macservice.com/logs/amazoncronlog/';
        $merge_prefix = date('Y-m-d_H:i:s', time());

        /*$amazon = new AmazonMWS;
		$openOrdersResult = $amazon->getOpenOrders();*/

        $amazonSP = new AmazonAPI;

        $cancledOrdersSPResult = $amazonSP->canceledOrderRequestSigner();
        if (count($cancledOrdersSPResult) > 0) {
            foreach ($cancledOrdersSPResult as $amazonOrderToCancel) {
                $orderToCancel = new AmazonOrder($amazonOrderToCancel);
                $orderToCancel->deleteFromDatabase();
            }
        }

        $openOrdersSPResult = $amazonSP->OpenOrderRequestSigner();

        $amazonSP->ShippedOrderRequestSigner();
        //$channelId = $amazon->getAmazonChannelId();
        $channelId = $amazonSP->getAmazonChannelIdSP();
        $orderNumbers = $this->getExistingOrderNumbers($channelId);
        //$existingOrdersResult = $amazon->getOrder($orderNumbers);

        /*if (is_array($openOrdersResult->ListOrdersResult->Orders->Order)) {
			$openOrders = $openOrdersResult->ListOrdersResult->Orders->Order;
		}
		else {
			$openOrders = array($openOrdersResult->ListOrdersResult->Orders->Order);
		}*/

        if (is_array($existingOrdersResult->GetOrderResult->Orders->Order)) {
            $existingOrders = $existingOrdersResult->GetOrderResult->Orders->Order;
        } else {
            $existingOrders = array($existingOrdersResult->GetOrderResult->Orders->Order);
        }
        $shippedOrders = AmazonOrder::getShippedAmazonOrders();

        /*$amazonOrders = array();
		if ($openOrders[0] && $openOrders[0]->AmazonOrderId) {
			foreach ($openOrders as $orderData) {
				array_push($amazonOrders, new AmazonOrder($orderData));
			}
		}*/
        $amazonOrdersSP = array();

        if ($openOrdersSPResult[0] && $openOrdersSPResult[0]->AmazonOrderId) {
            foreach ($openOrdersSPResult as $orderData) {
                array_push($amazonOrdersSP, new AmazonOrder($orderData));
            }
        }

        /*if ($existingOrders[0] && $existingOrders[0]->AmazonOrderId) {
			foreach ($existingOrders as $orderData) {
				array_push($amazonOrders, new AmazonOrder($orderData));
			}
		}*/
        /*foreach ($amazonOrders as $order) {
			if ($debug) {
				echo "<h1>Beginning inserts</h1>\n";
				echo "<pre>\n";
				print_r($order);
				echo "</pre>\n";
			}
			$order->performDatabaseInserts();
			if ($order->getStatus() == 'Canceled') {
				if ($debug) {
					echo "<h3>Deleting " . $order->getOrderId() . "</h3>\n";
				}
				$order->deleteFromDatabase();
			}
			elseif ($order->getStatus() == 'Shipped') {
				if ($debug) {
					echo "<h3>Checking if order is shipped</h3>";
				}
				if (in_array($order->getOrderId(), $shippedOrders)) {
					if ($debug) {
						echo "<h4>Closing " . $order->getOrderId() . "</h4>";
					}
					$order->closeOrder();
				}
			}
		}*/
        /*Add log in file*/
        $amazonOrdersSP_json = json_encode($openOrdersSPResult);
        file_put_contents("{$path_to_files}{$merge_prefix}_file_2_1.json", $amazonOrdersSP_json);
        
        foreach ($amazonOrdersSP as $order) {
            if ($debug) {
                echo "<h1>Beginning inserts</h1>\n";
                echo "<pre>\n";
                print_r($order);
                echo "</pre>\n";
            }
            $order->performDatabaseInserts();
            if ($order->getStatus() == 'Canceled') {
                if ($debug) {
                    echo "<h3>Deleting " . $order->getOrderId() . "</h3>\n";
                }
                $order->deleteFromDatabase();
            } elseif ($order->getStatus() == 'Shipped') {
                if ($debug) {
                    echo "<h3>Checking if order is shipped</h3>";
                }
                if (in_array($order->getOrderId(), $shippedOrders)) {
                    if ($debug) {
                        echo "<h4>Closing " . $order->getOrderId() . "</h4>";
                    }
                    $order->closeOrder();
                }
            }
        }
    }

    private function updateTtsOrders()
    {
        $shippedOrderIds = array();
        $sql = "SELECT oo.`zoho_id`
				FROM `open_orders` AS oo
				WHERE oo.`zoho_id` IN (
					SELECT * FROM
					(
						SELECT `zoho_id`
						FROM `order_ship_log`
					) as subquery
				);";
        $results = $this->db_query($sql, 'select-multiple', true);
        foreach ($results as $result) {
            array_push($shippedOrderIds, $result['zoho_id']);
        }
        $totalDeleted = 0;
        foreach ($shippedOrderIds as $orderId) {
            $sql = "DELETE FROM `open_orders` WHERE `zoho_id`='$orderId';";
            $result = $this->db_query($sql, 'delete', true);
            echo "Deleted $orderId from open_orders. Query: $sql\n";
        }
        if ($totalDeleted > 0) {
            echo "Deleted total of $totalDeleted from open_orders\n";
        }
    }

    private function getExistingOrderNumbers($channelId)
    {
        $orderNumbers = array();
        $sql = "SELECT `order_id` FROM `ecomm_open_orders` WHERE `channel_id`='$channelId' AND `open`='1';";
        $results = $this->db_query($sql, 'select-multiple', true);
        foreach ($results as $result) {
            array_push($orderNumbers, $result['order_id']);
        }
        return $orderNumbers;
    }

    private function updateNeweggOrders()
    {
        require_once(HTML_FOLDER . 'classes/OrderTypes/NeweggOrder.php');
        $orderNumbers = array();
        $newegg = new NeweggAPI;
        $response = json_decode($newegg->getOrders());
        $channelId = $newegg->getChannelId();
        if ((int)$response->ResponseBody->PageInfo->TotalCount > 0) {
            $orders = $response->ResponseBody->OrderInfoList;
            foreach ($orders as $orderData) {
                $order = new NeweggOrder($orderData);
                $order->performDatabaseInserts();
                array_push($orderNumbers, $order->getOrderId());
            }
        }
        $this->closeOldOrders($orderNumbers, $channelId);
    }

    private function updateEbayOrders()
    {
        require_once(HTML_FOLDER . 'classes/OrderTypes/EbayOrder.php');
        $auctionsOrderNumbers = array();
        $othersOrderNumbers = array();
        $ebay = new EbayAPI;
        $response = $ebay->getUnfulfilledOrders(true);
        $orders = $response->orders;
        $auctionsChannelId = $ebay->getChannelId('auctions');
        $othersChannelId = $ebay->getChannelId('others');
        if ((int)$response->total > 0) {
            foreach ($orders as $orderData) {
                $order = new EbayOrder($orderData);
                $order->performDatabaseInserts();
                if ($orderData->lineItems[0]->soldFormat == 'FIXED_PRICE') {
                    array_push($othersOrderNumbers, $order->getOrderId());
                } else {
                    array_push($auctionsOrderNumbers, $order->getOrderId());
                }
            }
        }
        $this->closeOldOrders($auctionsOrderNumbers, $auctionsChannelId);
        $this->closeOldOrders($othersOrderNumbers, $othersChannelId);
    }

    private function updateBackmarketOrders()
    {
        require_once(HTML_FOLDER . 'classes/OrderTypes/BackmarketOrder.php');
        $orderNumbers = array();
        $backmarket = new BackmarketAPI;
        $pendingPaymentResponse = json_decode($backmarket->getOrders(0, 50)); // Returns as JSON string.
        $pendingValidationResponse = json_decode($backmarket->getOrders(1, 50)); // Returns as JSON string.
        $readyToShipResponse = json_decode($backmarket->getOrders(3, 50)); // Returns as JSON string.
        $channelId = $backmarket->getChannelId();
        if ((int)$pendingPaymentResponse->count > 0) {
            $orders = $pendingPaymentResponse->results;
            foreach ($orders as $orderData) {
                $order = new BackmarketOrder($orderData);
                $order->performDatabaseInserts();
                array_push($orderNumbers, $order->getOrderId());
            }
        }
        if ((int)$pendingValidationResponse->count > 0) {
            $orders = $pendingValidationResponse->results;
            foreach ($orders as $orderData) {
                $order = new BackmarketOrder($orderData);
                $order->performDatabaseInserts();
                array_push($orderNumbers, $order->getOrderId());
            }
        }
        if ((int)$readyToShipResponse->count > 0) {
            $orders = $readyToShipResponse->results;
            foreach ($orders as $orderData) {
                $order = new BackmarketOrder($orderData);
                $order->performDatabaseInserts();
                array_push($orderNumbers, $order->getOrderId());
            }
        }
        $this->closeOldOrders($orderNumbers, $channelId);
    }

    private function closeOldOrders($orderNumbers, $channelId)
    {
        if ($orderNumbers && count($orderNumbers) > 0) {
            $orderNumberString = implode("', '", $orderNumbers);
            // $sql = "DELETE FROM `ecomm_open_orders` WHERE `channel_id`='$channelId' AND `order_id` NOT IN ('$orderNumberString');";
            $sql = "UPDATE `ecomm_open_orders` SET `open`='0' WHERE `channel_id`='$channelId' AND `order_id` NOT IN ('$orderNumberString');";
        } else {
            // $sql = "DELETE FROM `ecomm_open_orders` WHERE `channel_id`='$channelId';";
            $sql = "UPDATE `ecomm_open_orders` SET `open`='0' WHERE `channel_id`='$channelId';";
        }
        // return $this->db_query($sql, 'delete', true);
        return $this->db_query($sql, 'update', true);
    }

    function validateEligibleOrders()
    {
        global $backmarketObj, $invObj;
        $orders = json_decode($backmarketObj->getOrders(1, 50));
        foreach ($orders->results as $result) {
            $haveAllInStock = true;
            if ($this->getOrderAge($result->date_creation) < 1800) {
                continue;
            }
            foreach ($result->orderlines as $orderline) {
                $listingId = $orderline->listing_id;
                $itemCount = $invObj->getItemCountByBackMarketListingId($orderline->listing_id);
                // echo "Backmarket order $result->order_id requires $orderline->quantity $orderline->listing and there are $itemCount in stock\n";
                if ((int)$itemCount < (int)$orderline->quantity) { // Check to see if sufficient quantity
                    // echo "Insufficient stock to fill Back Market order $result->order_id\n";
                    // $haveAllInStock = false;
                    // Checks disabled per Robert 10 March 2021
                }
            }
            if ($haveAllInStock) {
                // echo "Validating $result->order_id\n";
                $backmarketObj->validateOrder($result->order_id);
            }
        }
        $this->updateOpenOrders();
        $this->printOpenOrders();
        $this->updateInboundOrders();
    }

    private function getOrderAge($creationDate, $format = DATE_ATOM)
    {
        if ($format == DATE_ATOM) {
            return $this->getOrderAgeAtom($creationDate);
        } elseif ($format == 'Y-m-d H:i:s') {
            return $this->getOrderAgeDatabase($creationDate);
        }
    }

    private function getOrderAgeAtom($creationDate)
    {
        $creationDateTime = DateTime::createFromFormat(DATE_ATOM, $creationDate);
        $creationDateTime->setTimezone(new DateTimeZone('UTC'));
        $currentDateTime = new DateTime('now', new DateTimeZone('UTC'));
        $currentDateTime->setTimezone(new DateTimeZone('UTC'));
        return abs($currentDateTime->getTimestamp() - $creationDateTime->getTimestamp());
    }

    private function getOrderAgeDatabase($creationDate)
    {
        $creationDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $creationDate, new DateTimeZone('UTC'));
        $currentDateTime = new DateTime('now', new DateTimeZone('UTC'));
        return abs($currentDateTime->getTimestamp() - $creationDateTime->getTimestamp());
    }

    function customer_csv()
    {
        if ($data = $this->db_select_multiple('ds_customers', 'cShipFname,cShipLname,cEmail,cPass')) {
            $csv = LABEL_TEMP_DIR . 'customers_export.csv';
            $fw = fopen($csv, 'w');
            foreach ($data as $row) {
                //$row['cPass'] = $this->rot13($row['cPass']);
                foreach ($row as $i => $cell) {
                    if (!is_numeric($i)) {
                        $row[$i] = addcslashes($cell, '"');
                        fwrite($fw, "\"{$cell}\",");
                    }
                }
                fwrite($fw, "\n");
            }
            fclose($fw);
            $this->send_email(
                MANAGER_EMAIL,
                INFO_FROM,
                'Customers Export CSV',
                'Please refer to the attached',
                '',
                array($csv)
            );
        }
    }

    function email_awaiting_parts_late()
    {
        global $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where (cStatus = "' . STATUS_WAITING . '" OR cStatus = "' . STATUS_APPROVED2 . '") '
                . 'and datePartsExpected < "' . $this->format_date('db_date') . '" '
                . 'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            $body = '';
            foreach ($rows as $row) {
                $body .= "\n" . $row['oNum'] . ' ' . $row['cStatus']
                    . ' Expected: ' . $row['datePartsExpected'];
            }
            if ($body) {
                $this->send_email(
                    $orderObj->parse_order('__INFO_FROM_EMAIL__', $row),
                    $orderObj->parse_order('__INFO_FROM_EMAIL__', $row),
                    'Daily Awaiting Parts Past Due ALERTS',
                    $body,
                    'text/plain'
                );
            }
        }
    }

    function email_boxouts_late()
    {
        global $upsObj, $orderObj;
        $prev = $this->get_prev_working_date();
        if ($this->format_date('day', $prev) == 'Fri') {
            return true;
        }
        if ($rows = $this->db_select_multiple(
            'ds_orders o',
            '*',
            array('details' => 'Order Created', 'cStatus' => STATUS_SHIP_1),
            'and time < "' . $prev . ' 18:00" and ship_tracking_id != "" ',
            array('ds_order_logs l on o.oNum = l.oNum')
        )) {
            $body = '';
            foreach ($rows as $row) {
                $results = $upsObj->track_data($row['ship_tracking_id']);
                if (is_array($results)) {
                    if ($results['ACT_DESC'] == 'BILLING INFORMATION RECEIVED') {
                        $body .= "\n" . $row['oNum'] . ' ' . $results['ACT_DESC'];
                    }
                } else {
                    $body .= "\nUnable to track " . $row['oNum'];
                }
            }
            if ($body) {
                $this->send_email(
                    $orderObj->parse_order('__INFO_FROM_EMAIL__', $row),
                    $orderObj->parse_order('__INFO_FROM_EMAIL__', $row),
                    'Daily UPS Box Shipment Discrepency ALERTS',
                    $body,
                    'text/plain'
                );
            }
        }
    }

    function email_feedback_digest()
    {
        if ($rows = $this->db_select_multiple(
            'nl_feedback f',
            '*',
            array(),
            'where stamp between "' . $this->format_date('db_date', false, -1) . ' 18:45:00" '
                . 'and "' . $this->format_date('db_full') . '" '
                . 'order by stamp asc ',
            array('ds_customers c on f.cString = c.cString')
        )) {
            $fb = array();
            foreach ($rows as $row) {
                $fb[] = '<a href="' . SITE_SURL . 'admin_controller.php?m=customer_detail&cString=' . $row['cString'] . '">'
                    . $row['cBillFname'] . ' ' . $row['cBillLname'] . '</a> ' . $this->format_date('templ_full', $row['stamp']) . '<br />'
                    . ereg_replace("[^0-9a-zA-Z ~`!@#$%^&*()+='\":;/?<>,._-]", '', $row['content']);
            }
            if ($rows) {
                $this->send_email(FEEDBACK_EMAILS, BROADCAST, 'Daily Feedback Digest', implode("<br /><br />", $fb));
            }
        }
    }

    function email_feedback_request()
    {
        global $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array('cStatus' => STATUS_DELIVERED, 'dateCompleted' => $this->format_date('db_date', false, -14)),
            'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            foreach ($rows as $row) {

                //check if emails are disabled
                $sendemail = true;

                $disabled_emails = $this->disabled_emails($row['oNum']);

                if (is_array($disabled_emails)) {
                    if (in_array('TWO_WEEK_THANKS', $disabled_emails)) {
                        $sendemail = false;
                    }
                }

                if ($sendemail) {
                    $this->send_email(
                        $row['cEmail'],
                        $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $row),
                        $orderObj->parse_order(ORDER_FEEDBACK_SUBJECT, $row),
                        $orderObj->parse_order(TWO_WEEK_THANKS, $row, array('CSTRING' => $row['customer_id']))
                    );
                }
            }
        }
    }

    function email_in_process_late()
    {
        global $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array('cStatus' => STATUS_READY, 'dateMachineReceived' => $this->format_date('db_date')),
            'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            foreach ($rows as $row) {
                if (!$orderObj->determine_approval($row['oNum'], $row)) {

                    //check if emails are disabled
                    $sendemail = true;

                    $disabled_emails = $this->disabled_emails($row['oNum']);

                    if (is_array($disabled_emails)) {
                        if (in_array('STILL_IN_DIAGNOSTIC', $disabled_emails)) {
                            $sendemail = false;
                        }
                    }

                    if ($sendemail) {
                        $this->send_email(
                            $row['cEmail'],
                            $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $row),
                            $orderObj->parse_order(ORDER_STATUS_SUBJECT, $row),
                            $orderObj->parse_order(STILL_IN_DIAGNOSTIC, $row)
                        );
                    }
                }
            }
        }
    }

    function email_lbr_extended()
    {
        global $site_data_emails, $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(
                'cStatus' => STATUS_APPROVED2, 'datePartsExpected' => $this->format_date('db_date', false, 8)
            ),
            'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            foreach ($rows as $row) {
                $this->send_email(
                    $row['cEmail'],
                    $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $row),
                    $orderObj->parse_order(ORDER_STATUS_SUBJECT, $row),
                    $orderObj->parse_order(LBR_EXTENDED, $row)
                );
            }
        }
    }

    function email_abandoned_checkouts_1day()
    {
        // SELECT cShipFname,cShipLname,cShipEmail FROM `ds_carts` c
        // JOIN ds_customers cu ON c.cString = cu.cString WHERE c.oNum = "" group by c.cString
        $prevDay = time() - 86400;
        $startStamp = mktime(0, 0, 0, date('n', $prevDay), date('j', $prevDay), date('Y', $prevDay));
        $endStamp = mktime(23, 59, 59, date('n', $prevDay), date('j', $prevDay), date('Y', $prevDay));
        if ($rows = $this->db_select_multiple(
            'ds_carts c',
            'cShipFname,cShipLname,cShipEmail',
            array(
                'c.oNum = ""', "customer_id != '" . SQUARETRADE_CUST_ID . "'", "added between '{$startStamp}' and '{$endStamp}'"
            ),
            'group by c.cString',
            array('ds_customers cu on c.cString = cu.cString')
        )) {
            foreach ($rows as $row) {

                # EMAIL CUSTOMER
                $this->send_email(
                    $row['cShipEmail'],
                    ORDER_PERSONAL_EMAIL,
                    'Re: MyService Order',
                    $this->parse(
                        NEXT_DAY_ABANDONED_EMAIL,
                        array(
                            'NAME' => "{$row['cShipFname']} {$row['cShipLname']}"
                        )
                    ),
                    'text/plain'
                );

                # EMAIL BCC TO ADMINISTRATOR
                $this->send_email(
                    RECONTACT_EMAIL,
                    ORDER_PERSONAL_EMAIL,
                    'Re: MyService Order',
                    $this->parse(
                        NEXT_DAY_ABANDONED_EMAIL,
                        array(
                            'NAME' => "{$row['cShipFname']} {$row['cShipLname']}"
                        )
                    ),
                    'text/plain'
                );
            }
        }
    }

    function email_never_received_30()
    {
        global $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where cStatus in ("' . STATUS_SHIP_0 . '", "' . STATUS_SHIP_1 . '", "' . STATUS_BOX_DELIVERED . '") '
                . 'and cDate <= "' . $this->format_date('db_date', false, -30) . '" '
                . 'and cDate > "' . $this->format_date('db_date', false, -60) . '" '
                . 'and paid != "Y"'
        )) {
            foreach ($rows as $row) {
                if (!$row['cBillCompany']) {
                    $row['nStatus'] = 'external';
                    $row['nNote'] = $orderObj->parse_order(NEVER_RECEIVED, $row);
                    $orderObj->insert_note($row['oNum'], $row, 'Y', 'alerts_system');
                }
            }
        }
    }

    function email_never_received_60()
    {
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where cStatus in ("' . STATUS_SHIP_0 . '", "' . STATUS_SHIP_1 . '", "' . STATUS_BOX_DELIVERED . '") '
                . 'and cDate <= "' . $this->format_date('db_date', false, -60) . '" '
                . 'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            $late = array();
            foreach ($rows as $row) {
                $late[] = $row['oNum'] . ' ' . $row['cStatus'] . ' ' . $row['cBillCompany'];
            }
            $this->send_email(
                INFO_FROM,
                INFO_FROM,
                'Never Received Past 60 ALERT List',
                implode("\n", $late),
                'text/plain'
            );
        }
    }

    function email_not_received($days)
    {
        global $orderObj;

        //if it's a Monday, pickup weekend records as well
        if (date('w') == 1) {
            $offset = 3;
        } else {
            $offset = 1;
        }

        //if 7 days only send to Self Mailed, if 28 days only send to Box Delivered, otherwise to both
        if ($days == 7) {
            $filter = STATUS_SHIP_0;
        } else {
            $filter = STATUS_SHIP_0 . '", "' . STATUS_BOX_DELIVERED;
        }

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where cStatus in ("' . $filter . '") '
                . 'and cDate <= "' . $this->format_date('db_date', false, -$days) . '" '
                . 'and cDate > "' . $this->format_date('db_date', false, - ($days + $offset)) . '" '
                . 'and (paid != "Y" or paid is null)'
        )) {
            foreach ($rows as $row) {

                $row['nStatus'] = 'external';
                if ($row['cStatus'] == STATUS_BOX_DELIVERED || $days != 28) {
                    $row['nNote'] = $orderObj->parse_order(NOT_RECEIVED, $row);
                } else {
                    $row['nNote'] = $orderObj->parse_order(ORDER_CLOSED, $row);
                    //$this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_VOID));
                }
                $orderObj->insert_note($row['oNum'], $row, 'Y', 'orders');
            }
        }
    }

    function email_not_received_35()
    {
        global $orderObj, $cartObj;

        //if it's a Monday, pickup weekend records as well
        if (date('w') == 1) {
            $offset = 3;
        } else {
            $offset = 1;
        }

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where cStatus = "' . STATUS_BOX_DELIVERED . '" '
                . 'and cDate <= "' . $this->format_date('db_date', false, -35) . '" '
                . 'and cDate > "' . $this->format_date('db_date', false, - (35 + $offset)) . '" '
                . 'and (paid != "Y" or paid is null)'
        )) {
            foreach ($rows as $row) {

                if (substr($row['cShipService'], 0, 3) != 'RMA') {
                    if ($row['cShipService'] == 'Round Trip - Next Day Shipping') {
                        $shipping = 99;
                    } elseif ($row['cShipService'] == 'Round Trip - 2nd Day Shipping') {
                        $shipping = 69;
                    } else {
                        $shipping = 25;
                    }

                    $row['cShipping'] = $shipping;

                    $this->db_update('ds_orders', 'oID', $row['oID'], array('cShipping' => $shipping, 'cSubTotal' => 0, 'cTotal' => $shipping, 'cTax' => 0));

                    $row['nStatus'] = 'external';
                    $row['nNote'] = $orderObj->parse_order(SHIPPING_CHARGE, $row);

                    $orderObj->insert_note($row['oNum'], $row, 'Y', 'orders');
                } else {
                    $this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_VOID, 'cShipping' => 0, 'cSubTotal' => 0, 'cTotal' => 0, 'cTax' => 0));
                }

                $cartObj->zero_cart($row['oNum']);
            }
        }
    }

    function charge_shipping_36()
    {
        global $pmtObj, $orderObj;

        //if it's a Monday, pickup weekend records as well
        if (date('w') == 2) {
            $offset = 3;
        } else {
            $offset = 1;
        }

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'where cStatus = "' . STATUS_BOX_DELIVERED . '" '
                . 'and cDate <= "' . $this->format_date('db_date', false, -36) . '" '
                . 'and cDate > "' . $this->format_date('db_date', false, - (36 + $offset)) . '" '
                . 'and (paid != "Y" or paid is null)'
        )) {
            foreach ($rows as $row) {

                $pass = false;

                if ($row['payment_method'] == 'Credit Card') {
                    $row['ccExp'] = date('m', strtotime($row['ccExp'])) . date('y', strtotime($row['ccExp']));
                    $row['ccNum'] = $this->md5_decrypt($row['ccNum'], CC_SALT);
                    list($pass, $responses) = $pmtObj->payflowpro_service($row, $row['oNum'], 'S', $row['cShipping']);
                }

                if ($pass) {
                    $orderObj->mark_paid($row['oNum']);
                    $this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_COMPLETE, 'dateCompleted' => $this->format_date('db_date', time())));
                } else {
                    $this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_CANT_CHARGE));
                }

                $this->db_delete('ds_carts', 'oNum', $row['oNum'], false);
            }
        }
    }

    function email_awaiting_payment($days)
    {

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'left join ds_order_logs on ds_order_logs.oNum = ds_orders.oNum '
                . 'where ds_orders.cStatus = "' . STATUS_PAYMENT . '" '
                . 'and ds_order_logs.details = "Order Status Changed to ' . STATUS_PAYMENT . '" '
                . 'and date_format(ds_order_logs.`time`,"%Y-%m-%d") = "' . $this->format_date('db_date', false, -$days) . '"'
        )) {

            foreach ($rows as $row) {

                //check if emails are disabled
                $sendemail = true;

                $disabled_emails = $this->disabled_emails($row['oNum']);

                if (is_array($disabled_emails)) {
                    if (in_array('AWAITING_PAYMENT', $disabled_emails)) {
                        $sendemail = false;
                    }
                }

                if ($sendemail) {
                    $this->send_email(
                        $row['cEmail'],
                        ORDERS_FROM,
                        $row['oNum'] . ' Awaiting Payment',
                        $this->parse(AWAITING_PAYMENT, array()),
                        'text/plain'
                    );
                }
            }
        }
    }

    function admin_awaiting_payment($days)
    {

        //if it's a Monday, pickup weekend records as well
        if (date('w') == 1) {
            $offset = 3;
        } else {
            $offset = 1;
        }

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            'left join ds_order_logs on ds_order_logs.oNum = ds_orders.oNum '
                . 'where ds_orders.cStatus = "' . STATUS_PAYMENT . '" '
                . 'and ds_order_logs.details = "Order Status Changed to ' . STATUS_PAYMENT . '" '
                . 'and ds_order_logs.`time` <= "' . $this->format_date('db_date', false, -$days) . '" '
                . 'and ds_order_logs.`time` > "' . $this->format_date('db_date', false, - ($days + $offset)) . '" '
        )) {

            foreach ($rows as $row) {

                $parse = array(
                    'ONUM' => $row['oNum'],
                    'CBILLFNAME' => $row['cBillFname'],
                    'CBILLLNAME' => $row['cBillLname'],
                    'CBILLADDRESS1' => $row['cBillAddress1'],
                    'CBILLADDRESS2' => $row['cBillAddress2'],
                    'CBILLCITY' => $row['cBillCity'],
                    'CBILLSTATE' => $row['cBillState'],
                    'CBILLZIP' => $row['cBillZip'],
                    'CSHIPFNAME' => $row['cShipFname'],
                    'CSHIPLNAME' => $row['cShipLname'],
                    'CSHIPADDRESS1' => $row['cShipAddress1'],
                    'CSHIPADDRESS2' => $row['cShipAddress2'],
                    'CSHIPCITY' => $row['cShipCity'],
                    'CSHIPSTATE' => $row['cShipState'],
                    'CSHIPZIP' => $row['cShipZip'],
                    'CSHIPEMAIL' => $row['cShipEmail'],
                    'CPHONE' => $row['cPhone'],
                    'CEMAIL' => $row['cEmail']
                );
                $this->send_email(
                    SUPPORT_FROM,
                    INFO_FROM,
                    $row['oNum'] . ' Followup Call ' . $days . ' days Awaiting Payment',
                    $this->parse(AWAITING_PAYMENT_ADMIN, $parse),
                    'text/html'
                );
            }
        }
    }

    /* function email_not_received_tidy() {
      global $orderObj, $cartObj;

      if ($rows = $this->db_select_multiple(
      'ds_orders', '*', array()
      , 'where cStatus = "' . STATUS_BOX_DELIVERED . '" '
      . 'and cDate <= "2011-10-24" '
      . 'and (paid != "Y" or paid is null)'
      )

      ) {
      foreach ($rows as $row) {

      if (substr($row['cShipService'], 0,3) != 'RMA'){
      if ($row['cShipService'] == 'Round Trip - Next Day Shipping'){
      $shipping = 99;
      }elseif($row['cShipService'] == 'Round Trip - 2nd Day Shipping'){
      $shipping = 69;
      }else{
      $shipping = 25;
      }

      $row['cShipping'] = $shipping;

      $this->db_update('ds_orders', 'oID', $row['oID'], array('cShipping' => $shipping, 'cSubTotal' => $shipping, 'cTotal' => $shipping, 'cTax' => 0));

      $row['nStatus'] = 'external';
      $row['nNote'] = $orderObj->parse_order(SHIPPING_CHARGE, $row);

      $orderObj->insert_note($row['oNum'], $row, 'Y', 'amber');
      }else{
      $this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_VOID, 'cShipping' => 0, 'cSubTotal' => 0, 'cTotal' => 0, 'cTax' => 0));
      }

      $cartObj->zero_cart($row['oNum']);


      }
      }
      }

      function charge_shipping_tidy(){
      global $pmtObj, $orderObj;



      if ($rows = $this->db_select_multiple(
      'ds_orders', '*', array()
      , 'where cStatus = "' . STATUS_BOX_DELIVERED . '" '
      . 'and cDate <= "2011-10-24" '
      . 'and (paid != "Y" or paid is null)'
      )
      ) {
      foreach ($rows as $row) {

      $pass = false;

      if ($row['payment_method'] == 'Credit Card'){
      list($pass, $responses) = $pmtObj->payflowpro_service($row, $row['oNum'], 'S', $row['cShipping']);
      }

      if($pass){
      $orderObj->mark_paid($row['oNum']);
      }else{
      $this->db_update('ds_orders', 'oID', $row['oID'], array('cStatus' => STATUS_CANT_CHARGE));
      }

      }
      }
      } */

    function email_ups_sched($day)
    {
        global $orderObj, $upsObj;
        if ($day == 'tomorrow') {
            $check_day = $this->format_date('templ_date', false, 1);
        } else {
            $check_day = $this->format_date('templ_date');
        }
        if (!$rows = $this->db_select_multiple(
            'ds_orders',
            'oNum,cStatus,cEmail,cShipAddress1,cShipCity,cShipState,cShipZip',
            array(),
            'where cStatus in ("' . STATUS_SHIP_1 . '", "' . STATUS_SHIP_2 . '") '
                . 'and (dateCompleted = "" or dateCompleted > "' . $this->format_date('db_date', false, -10) . '") '
                . 'and customer_id != "' . SQUARETRADE_CUST_ID . '"'
        )) {
            return false;
        }
        foreach ($rows as $row) {
            switch ($row['cStatus']) {
                case STATUS_SHIP_1:
                    $field = 'ship_tracking_id';
                    $sms_template = UPS_BOX_DELIVERY_SMS;
                    if ($day == 'tomorrow') {
                        $template = UPS_BOX_OUT_TOMORROW;
                    } else {
                        $template = UPS_BOX_OUT_TODAY;
                        $to = array(
                            'address1' => $row['cShipAddress1'],
                            'address2' => '',
                            'city' => $row['cShipCity'],
                            'state' => $row['cShipState'],
                            'zip' => $row['cShipZip'],
                            'country' => 'US'
                        );
                        $drop_offs = $upsObj->get_dropoff_locations($to);
                        $template = $this->parse($template, array('DROP_OFFS' => $drop_offs));
                    }
                    break;
                case STATUS_SHIP_2:
                    $field = 'ship_tracking_id3';
                    $sms_template = UPS_MACH_DELIVERY_SMS;
                    if ($day == 'tomorrow') {
                        $template = UPS_MACH_OUT_TOMORROW;
                    } else {
                        $template = UPS_MACH_OUT_TODAY;
                    }
                    break;
            }
            if (!$tracking = $orderObj->get_tracking($row['oNum'])) {
                continue;
            }
            $tracknum = $tracking[$field];
            if (!$results = $upsObj->track_data($tracknum)) {
                continue;
            }
            $sched = $results['SCHEDULED'];
            $sched = substr($sched, 4, 10);
            if ($results['ACT_DESC'] != 'BILLING INFORMATION RECEIVED' && $sched == $check_day) {
                $data = $orderObj->get_data($row['oNum']);
                if ($send = $orderObj->get_sms_numbers($data)) {
                    $this->send_sms_eztexting($send, $orderObj->parse_order($sms_template, $data));
                }

                //check if emails are disabled
                $sendemail = true;

                $disabled_emails = $this->disabled_emails($row['oNum']);

                if (is_array($disabled_emails)) {
                    foreach ($disabled_emails as $disabled) {

                        $email_templ = constant($disabled);
                        if ($email_templ == $template) {
                            $sendemail = false;
                        }
                    }
                }

                //send if emails not disabled
                if ($sendemail) {
                    $this->send_email(
                        $row['cEmail'],
                        $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $data),
                        $orderObj->parse_order(ORDER_STATUS_SUBJECT, $data),
                        $orderObj->parse_order($template, $data)
                    );
                }
            }
        }
    }

    function email_squaretrade_csv()
    {
        global $sqrtObj, $orderObj;
        if ($data = $this->db_select_multiple(
            'ds_orders',
            '*',
            array('customer_id' => SQUARETRADE_CUST_ID),
            'and cStatus not in ("' . STATUS_VOID . '", "' . STATUS_SHIP_2 . '", "' . STATUS_COMPLETE . '", "' . STATUS_DELIVERED . '")'
        )) {
            $output = 'Customer Name, Claim ID, Order Number, Status, Notes' . "\n";
            foreach ($data as $row) {
                $claim = $sqrtObj->get_squaretrade_id($row['problem']);
                $note = '';
                if ($notes = $this->db_select_multiple(
                    'ds_order_notes',
                    '*',
                    array('nStatus' => 'external', 'oNumber' => $row['oNum'])
                )) {
                    foreach ($notes as $row2) {
                        $note .= $row2['nDate'] . ' ' . $row2['nNote'] . ' ';
                    }
                }
                $output .=
                    $row['cShipFname'] . ' ' . $row['cShipLname']
                    . ',' . $claim
                    . ',' . $row['oNum']
                    . ',' . $row['cStatus']
                    . ',' . ereg_replace("[^0-9A-Za-z: @_-]", '', $note)
                    . "\n";
            }
            $csv = LABEL_TEMP_DIR . 'squaretrade_daily.csv';
            $this->write_file($csv, 'w', $output);
            $this->send_email(
                SQUARETRADE_REP_EMAIL,
                $orderObj->parse_order('__ORDERS_FROM_EMAIL__', $row),
                'Daily CSV Update File',
                'Please refer to the attached',
                '',
                array($csv)
            );
        }
    }

    function mark_delivered($fromStatus, $toStatus, $track_field)
    {
        global $upsObj, $orderObj;

        $sql = "select oNum, ship_tracking_id, ship_tracking_id3 from ds_orders where cStatus = '$fromStatus' and length($track_field) > 0";
        $rows = $this->db_query($sql, 'select-multiple');
        if ($rows) {
            /*if ($rows = $this->db_select_multiple(
                'ds_orders', 'oNum, ship_tracking_id, ship_tracking_id3', array('cStatus' => $fromStatus)
                )
        ) {*/
            foreach ($rows as $row) {
                $results = $upsObj->track_data($row[$track_field]);
                if (is_array($results)) {
                    if ($results['ACT_DESC'] == 'DELIVERED') {
                        $orderObj->update_status($row['oNum'], $toStatus);
                    }
                }
            }
        }
    }

    function mark_return_transit($fromStatus, $toStatus, $track_field)
    {
        global $upsObj, $orderObj;
        if ($rows = $this->db_select_multiple(
            'ds_orders',
            'oNum, ship_tracking_id, ship_tracking_id2',
            array('cStatus' => $fromStatus)
        )) {
            foreach ($rows as $row) {
                $results = $upsObj->track_data($row[$track_field]);
                if (is_array($results)) {
                    if ($results['ACT_DESC'] != 'BILLING INFORMATION RECEIVED') {
                        $orderObj->update_status($row['oNum'], $toStatus);
                    }
                }
            }
        }
    }

    function order_import_xls()
    {
        global $cartObj, $orderObj, $custObj, $diagnostic_pids;
        $import_folder = dirname(__FILE__) . '/_import/_customerorders/';
        $completed_folder = $import_folder . 'completed/';
        $customer = $custObj->get_data(SQUARETRADE_CUST_ID);
        foreach (scandir($import_folder) as $key => $value) {
            $file_ext = strtolower(substr($value, strrpos($value, '.')));
            if ($file_ext == '.xls') {
                $records = $this->read_xls($import_folder . $value);
                echo "Scanning: $value \n";
            } else if ($file_ext == '.csv') {
                $records = $this->read_csv($import_folder . $value);
                echo "Scanning: $value \n";
            } else {
                continue;
            }
            $row = 0;
            foreach ($records as $data) {
                if (!is_numeric(trim($data[0]))) {
                    continue;
                }
                $row++;

                # MAKE THE CART
                $cSession = $this->createUniqueKey();
                $cartObj->insert($cSession, $diagnostic_pids[0], 1);

                # DETERMINE SHIP METHOD TO USE
                $ship_method = SHIP_ROUND_2DAY;
                if (stristr($data[12], 'phones')) {
                    $cartObj->insert($cSession, '1619', 1);
                    switch (trim(strtolower($data[19]))) {
                        case 'yes':
                            $ship_method = SHIP_ROUND_1DAY;
                            break;
                        case 'no':
                            $ship_method = SHIP_EXPRESS_1DAY;
                    }
                }

                # CREATE CART AND ORDER
                $order_data = array(
                    'cpCode' => array('SQUARETRADE'), 'cBillCompany' => $customer['cBillCompany'], 'cBillFname' => $customer['cBillFname'], 'cBillLname' => $customer['cBillLname'], 'cEmail' => 'squaretrade@myservice.com', 'cPhone' => $customer['cPhone'], 'cBillAddress1' => $customer['cBillAddress1'], 'cBillAddress2' => $customer['cBillAddress2'], 'cBillCity' => $customer['cBillCity'], 'cBillZip' => $customer['cBillZip'], 'cBillCountry' => $customer['cBillCountry'], 'cShipCountry' => $customer['cShipCountry'], 'payment_method' => 'Purchase Order', 'cShipService' => array($ship_method), 'poNumber' => $data[0], 'cShipFname' => $data[2], 'cShipLname' => $data[3], 'cShipAddress1' => $data[4], 'cShipAddress2' => $data[5], 'cShipCity' => $data[6], 'cShipState' => $data[7], 'cShipZip' => $data[8], 'cFax' => $data[10], 'cShipEmail' => $data[11], 'problem' => array(
                        'Claim ID: ' . $data[0] . ', ADH: ' . $data[19]
                            . "\n" . 'Cust Email: ' . $data[11]
                            . "\n" . 'Manufacturer: ' . $data[13] . ', Model: ' . $data[14]
                            . "\n" . 'Serial No: ' . $data[15]
                            . "\n" . 'Description: ' . $data[16]
                    )
                );
                $orderObj->create_multiple(
                    SQUARETRADE_CUST_ID,
                    $order_data,
                    array($cSession),
                    ORDER_NUM_PREFIX
                );
            }
            if ($row > 0) {
                rename($import_folder . $value, $completed_folder . $this->format_date('misc_1') . '-' . $value);
                echo 'Completed import of file: ' . $value . "\n";
            } else {
                echo 'Error with file - no records found: ' . $value . "\n";
            }
        }
    }

    function order_to_cust_card($oNum)
    {
        global $custObj, $orderObj;
        $cString = $this->createUniqueKey();
        if (!$oNum) {
            die("Format: script.php site.com order2cust MS123456\n");
        }
        if ($data = $orderObj->get_data($oNum)) {
            if ($custObj->insert($cString, $data)) {
                echo "Added new customer card: $cString\n";
                $this->db_update('ds_orders', 'oNum', $oNum, array('customer_id' => $cString));
            }
        }
    }

    function rsync()
    {
        $data = $this->db_select_multiple('nl_clients', '*');
        foreach ($data as $row) {
            $folders = explode(',', $row['folders']);
            foreach ($folders as $folder) {
                $lastdir = explode('/', $folder);
                $lastdir = $lastdir[sizeof($lastdir) - 2];
                $log = BACKUP_LOG_PATH . $row['clientID'] . '__' . time() . '__' . $lastdir;
                exec(
                    'rsync -avz ' . $folder . ' ' . $row['rSyncU'] . '@' . $row['rSyncS']
                        . ':' . $lastdir . '/ >' . $log,
                    $retarr,
                    $retval
                );
            }
        }
    }

    function sms_summary($date)
    {
        $completed_cc = $this->db_select_single(
            'ds_orders',
            'count(*) as num,sum(cTotal) as total',
            array('dateCompleted' => $date, 'payment_method' => 'Credit Card'),
            'and cStatus in ("' . STATUS_SHIP_2 . '", "' . STATUS_COMPLETE . '")'
        );
        $completed_po = $this->db_select_single(
            'ds_orders',
            'count(*) as num,sum(cTotal) as total',
            array('dateCompleted' => $date, 'payment_method' => 'Purchase Order'),
            'and cStatus in ("' . STATUS_SHIP_2 . '", "' . STATUS_COMPLETE . '")'
        );
        foreach (explode('|', EXECUTIVE_SMS) as $to) {
            $this->send_sms_eztexting(
                $to,
                $this->format_date('db_date', $date)
                    . ' Completed ' . ($completed_cc['num'] + $completed_po['num'])
                    . ' CC $' . number_format($completed_cc['total'])
                    . ' PO $' . number_format($completed_po['total'])
            );
        }
    }

    function store_ups_signatures()
    {
        global $upsObj;
        $data = $this->db_select_multiple(
            'ds_orders',
            'oNum, ship_tracking_id3',
            array('cStatus' => STATUS_DELIVERED, 'ups_signature' => 'N'),
            'order by oID desc limit 10'
        );
        foreach ($data as $row) {
            if ($proof = $upsObj->track_signature($row['ship_tracking_id3'], $row['oNum'])) {
                $this->db_update(
                    'ds_orders',
                    'oNum',
                    $oNum,
                    array(
                        'ups_signature' => 'Y', 'ups_signature_img' => $proof[1], 'ups_signature_html' => $proof[0]
                    )
                );
            }
        }
    }

    function applecare_email($days)
    {
        global $orderObj, $cartObj, $gsxObj;

        //if it's a Monday, pickup weekend records as well
        if (date('w') == 1) {
            $filter = 'where warrantyStatus = "Apple Limited Warranty" '
                . 'and warrantyEndDate <= "' . $this->format_date('db_date', false, $days) . '" '
                . 'and warrantyEndDate >= "' . $this->format_date('db_date', false, ($days - 2)) . '" '
                . 'and daysRemaining between 1 and 365';
        } else {
            $filter = 'where warrantyStatus = "Apple Limited Warranty" '
                . 'and warrantyEndDate = "' . $this->format_date('db_date', false, $days) . '" '
                . 'and daysRemaining between 1 and 365';
        }

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            '*',
            array(),
            $filter
        )) {

            $serialNumbers = array();

            foreach ($rows as $row) {

                //check if emails are disabled
                $sendemail = true;

                $disabled_emails = $this->disabled_emails($row['oNum']);

                if (is_array($disabled_emails)) {
                    foreach ($disabled_emails as $disabled) {

                        $email_templ = constant($disabled);
                        if ($email_templ == $template) {
                            $sendemail = false;
                        }
                    }
                }

                //only send if not disabled
                if ($sendemail) {

                    //check for duplicate serial numbers
                    if (!in_array($row['serialNumber'], $serialNumbers)) {

                        $serialNumbers[] = $row['serialNumber'];

                        $warranty_status = $gsxObj->get_warranty_status($row['serialNumber']);

                        //check warranty status hasn't changed
                        if ($warranty_status['warrantyStatus'] == 'Apple Limited Warranty' && intval($warranty_status['daysRemaining']) < 365) {
                            $parse = array(
                                'BILL_FIRST' => $row['cBillFname'],
                                'BILL_LAST' => $row['cBillLname'],
                                'SITE_NAME_EMAIL' => SITE_NAME,
                                'SITE_URL_EMAIL' => SITE_URL,
                                'SERIAL_NUMBER' => $row['serialNumber'],
                                'ONUM' => $row['oNum']
                            );
                            if ($days == 30) {
                                $this->send_email(
                                    $row['cEmail'],
                                    ORDERS_FROM,
                                    'AppleCare',
                                    $this->parse(APPLECARE_REMINDER_BODY_30, $parse)
                                );
                            } else {
                                $this->send_email(
                                    $row['cEmail'],
                                    ORDERS_FROM,
                                    'AppleCare',
                                    $this->parse(APPLECARE_REMINDER_BODY_60, $parse)
                                );
                            }
                        }
                    }
                }
            }
        }
    }

    function deleteGoogleContacts()
    {
        global $googleObj, $dbObj;

        $datesince = date('Y-m-d', time() - (60 * 60 * 24 * 365));

        $result = $dbObj->db_select_multiple('ds_customers', 'cID, google_contact_id', array(), 'where cDateSince <= "' . $datesince . '" and google_contact_id is not null and google_contact_id <> ""');

        $client = $googleObj->start_session();

        foreach ($result as $row) {

            $contactid = explode('/', $row['google_contact_id']);

            $google_contact_id = 'http://www.google.com/m8/feeds/contacts/default/base/' . $contactid[8];

            $googleObj->deleteContact($google_contact_id, $client);

            $dbObj->db_update('ds_customers', 'cID', $row['cID'], array('google_contact_id' => ''));
        }
    }

    //get array of disabled emails for order/customer
    private function disabled_emails($oNum)
    {

        //get disabled arrays from order and customer tables
        $ds_orders = $this->db_select_single('ds_orders', 'customer_id, disabled_emails', array('oNum' => $oNum));

        $order_disabled = unserialize($ds_orders['disabled_emails']);

        $ds_customers = $this->db_select_single('ds_customers', 'disabled_emails', array('cString' => $ds_orders['customer_id']));

        $customer_disabled = unserialize($ds_customers['disabled_emails']);

        //return results
        if (is_array($order_disabled) && is_array($customer_disabled)) {
            return array_merge($order_disabled, $customer_disabled);
        } elseif (is_array($order_disabled)) {
            return $order_disabled;
        } elseif (is_array($customer_disabled)) {
            return $customer_disabled;
        } else {
            return false;
        }
    }

    function diagnostic_followup($days)
    {

        //get records
        $sql = "select o_n.oNumber, o.cEmail, o_n.nNote from ds_order_notes o_n
                    left join ds_order_logs o_l on o_l.oNum = o_n.oNumber
                    left join ds_orders o on o.oNum = o_n.oNumber
                    where o_n.nNote like '%diagnostic%'
                    and o_n.nStatus <> 'internal'
                    and date_format(o_n.nDate,'%Y-%m-%d') = date_format(o_l.`time`,'%Y-%m-%d')
                    and o_l.details = 'Order Status Changed to " . STATUS_APPROVAL . "'
                    and o.cStatus = '" . STATUS_APPROVAL . "'
                    and date_format(o_l.`time`,'%Y-%m-%d') = '" . $this->format_date('db_date', false, -$days) . "'";

        $ds_order_logs = $this->db_query($sql, 'select-multiple');

        //step through recordset and send emails
        foreach ($ds_order_logs as $row) {

            //check if emails are disabled
            $sendemail = true;

            $disabled_emails = $this->disabled_emails($row['oNumber']);

            if (is_array($disabled_emails)) {
                foreach ($disabled_emails as $disabled) {

                    $email_templ = constant($disabled);
                    if ($email_templ == $template) {
                        $sendemail = false;
                    }
                }
            }


            if ($sendemail) {
                $to = $row['cEmail'];
                $from = ORDERS_FROM;
                $subject = 'Order number: ' . $row['oNumber'];
                $body = $row['nNote'];

                $this->send_email($to, $from, $subject, $body);
            }
        }
    }

    function followup_call_email($days, $loop = true)
    {

        if (date('w') == 1 && $loop == true) {
            $this->followup_call_email($days + 2, false);
            $this->followup_call_email($days + 1, false);
        }

        //get records
        $sql = "select o_n.oNumber, o.cEmail, o.cPhone, o.cShipEmail, o.cPhone2, o_n.nNote from ds_order_notes o_n
                    left join ds_order_logs o_l on o_l.oNum = o_n.oNumber
                    left join ds_orders o on o.oNum = o_n.oNumber
                    where o_n.nNote like '%diagnostic%'
                    and o_n.nStatus <> 'internal'
                    and date_format(o_n.nDate,'%Y-%m-%d') = date_format(o_l.`time`,'%Y-%m-%d')
                    and o_l.details = 'Order Status Changed to " . STATUS_APPROVAL . "'
                    and o.cStatus = '" . STATUS_APPROVAL . "'
                    and date_format(o_l.`time`,'%Y-%m-%d') = '" . $this->format_date('db_date', false, -$days) . "'";

        $ds_order_logs = $this->db_query($sql, 'select-multiple');

        //step through recordset and send emails
        foreach ($ds_order_logs as $row) {

            $to = $row['cEmail'];
            $from = ORDERS_FROM;
            $subject = $row['oNumber'] . ' Followup Call ' . $days . ' days';

            $parse = array(
                'ORDER_NUMBER' => $row['oNumber'],
                'BILLING_PHONE' => $row['cPhone'],
                'BILLING_EMAIL' => $row['cEmail'],
                'SHIPPING_PHONE' => $row['cPhone2'],
                'SHIPPING_EMAIL' => $row['cShipEmail'],
                'DIAGNOSTIC_BODY' => $row['nNote']
            );
            $body = $this->parse(FOLLOWUP_CALL, $parse);

            $this->send_email(SUPPORT_FROM, $from, $subject, $body);
        }
    }

    //get quote requests from Wufoo
    function get_quotes()
    {
        global $wufooObj, $dbObj;

        //get yesterdays date
        $filterdate = $this->format_date('db_date', time(), -1);

        //get records from standard form via Wufoo API
        $quotes = $wufooObj->get_quotes(array('Filter1' => 'DateCreated+Contains+' . $filterdate));

        //write to database
        foreach ($quotes->Entry as $row) {

            $data = array(
                'entry_id' => $row->EntryId,
                'first_name' => $row->Field1,
                'last_name' => $row->Field2,
                'email' => $row->Field7,
                'phone' => $row->Field13,
                'machineType' => $row->Field15,
                'serialNumber' => strtoupper($row->Field140),
                'description' => $row->Field17,
                'dateCreated' => $row->DateCreated,
                'ipAddress' => $row->IP
            );

            $dbObj->db_insert('quote_requests', $data);
        }

        //get records from facebook form via Wufoo API
        $quotes = $wufooObj->get_facebook_quotes(array('Filter1' => 'DateCreated+Contains+' . $filterdate));

        //write to database
        foreach ($quotes->Entry as $row) {

            $data = array(
                'facebook_entry_id' => $row->EntryId,
                'first_name' => $row->Field1,
                'last_name' => $row->Field2,
                'email' => $row->Field7,
                'phone' => $row->Field13,
                'machineType' => $row->Field15,
                'serialNumber' => strtoupper($row->Field140),
                'description' => $row->Field17,
                'dateCreated' => $row->DateCreated,
                'ipAddress' => $row->IP
            );

            $dbObj->db_insert('quote_requests', $data);
        }

        //get records from mobile form via Wufoo API
        $quotes = $wufooObj->get_mobile_quotes(array('Filter1' => 'DateCreated+Contains+' . $filterdate));

        //write to database
        foreach ($quotes->Entry as $row) {

            $name = explode(' ', $row->Field1);

            $data = array(
                'mobile_entry_id' => $row->EntryId,
                'first_name' => $name[0],
                'last_name' => $name[1],
                'email' => $row->Field7,
                'phone' => $row->Field13,
                'machineType' => $row->Field15,
                'description' => $row->Field17,
                'dateCreated' => $row->DateCreated,
                'ipAddress' => $row->IP
            );

            $dbObj->db_insert('quote_requests', $data);
        }
    }

    function get_mobile_orders()
    {
        global $wufooObj, $dbObj;

        //get yesterdays date
        $filterdate = date('Y-m', time() - (60 * 60 * 24));

        $filterdate = '2012-02';

        //get records from standard form via Wufoo API
        $orders = $wufooObj->get_mobile_orders(array('Filter1' => 'DateCreated+Contains+' . $filterdate));

        $dbObj->db_query('delete from mobile_orders where dateCreated like "' . $filterdate . '%"', 'delete');

        foreach ($orders->Entry as $row) {

            $data = array(
                'entry_id' => $row->EntryID,
                'name' => $row->Field1,
                'email' => $row->Field3,
                'phone' => $row->Field8,
                'description' => $row->Field5,
                'pid' => $row->Field6,
                'dateCreated' => $row->DateCreated,
                'ipAddress' => $row->IP
            );

            $dbObj->db_insert('mobile_orders', $data);
        }

        $mobile_orders = $dbObj->db_query('select count(mobile_order_id) as mobile_count from mobile_orders where dateCreated like "' . $filterdate . '%"', 'select-single');

        $order_count = $mobile_orders['mobile_count'];

        $converted = $dbObj->db_query('select count(mobile_orders.mobile_order_id) order_count from mobile_orders, ds_orders
                    where ds_orders.cEmail = mobile_orders.email
                    and mobile_orders.dateCreated like "' . $filterdate . '%"
                    and date_format(mobile_orders.dateCreated,"%Y-%m-%d") <= ds_orders.cDate', 'select-single');

        $converted_count = $converted['order_count'];

        $count1 = $converted_count / $order_count;
        $count2 = $count1 * 100;
        $count = number_format($count2, 2);

        $body = $this->parse(MOBILE_ORDERS, array('ORDERS_SUBMITTED' => $order_count, 'ORDERS_CREATED' => $converted_count, 'CONVERSION_RATE' => $count));

        $this->send_email(MANAGER_EMAIL, INFO_FROM, 'Mobile Orders Monthly Statistics', $body);
    }

    function get_product_models()
    {
        global $gsxObj;

        if ($rows = $this->db_select_multiple(
            'ds_orders',
            'serialNumber',
            array(),
            'where cDate = "' . $this->format_date('db_date', false, -1) . '" '
        )) {

            foreach ($rows as $row) {

                if ($row['serialNumber']) {
                    $product = $gsxObj->get_product_model($row['serialNumber']);

                    if (!$machine_description = $this->db_select_single('machine_lookup', 'machine_description', array('machine_description' => $product['configDescription']))) {
                        $this->db_insert('machine_lookup', array('machine_description' => $product['configDescription'], 'product_line' => $product['productLine'], 'enabled' => '1'));
                    }
                }
            }
        }
    }

    function abandoned_order_email()
    {

        global $cartObj, $abandoned_order_email_addresses;

        $temp_cart = $this->db_select_multiple('temp_cart', '*', array(), 'where (email_sent is null or email_sent = "0") and last_update < "' . $this->format_date('db_date') . '"');

        $i = 0;

        foreach ($temp_cart as $row) {

            $body = "I noticed that you started an order but didn't complete it. Did you have any issues during the checkout process or were there any questions I could answer for you?\n\n";
            $body .= "If you have submitted your order and received your shipping materials please disregard this message.\n\n";
            $body .= "Thank you.\n\n";
            $body .= $abandoned_order_email_addresses[$i]['name'] . "\nService Advisor\nMacService\n1530 Montague Expressway\nSan Jose, CA 95131\ntoll free: 877.622.3473\nwww.macservice.com";

            if ($order = $this->db_select_single('ds_orders', 'oID', array(), 'where (cEmail = "' . $row['cEmail'] . '" or cShipCompany = "' . $row['cShipCompany'] . '" or cShipLname = "' . $row['cShipLname'] . '") and cDate >= "' . $row['last_update'] . '"')) {
                $cartObj->delete_temp_cart($row['cEmail']);
            } else {
                $bodytext = $row['cShipFname'] . "-\n\n" . $body;

                $this->send_email($row['cEmail'], $abandoned_order_email_addresses[$i]['email'], 'MacService Mac Repairs', $bodytext, 'text/plain', array(), '', MANAGER_EMAIL);

                $this->db_update('temp_cart', 'temp_cart_id', $row['temp_cart_id'], array('email_sent' => '1'));
            }

            if ($i < count($abandoned_order_email_addresses) - 1) {
                $i++;
            } else {
                $i = 0;
            }
        }
    }

    function payflow_daily_activity()
    {
        global $pmtObj;

        $pmtObj->payflowpro_report($this->format_date('db_date'));
    }

    function update_repair_lookup()
    {
        global $gsxObj;

        $repair_lookup = $gsxObj->repair_lookup(array('incompleteRepair' => 'Y'));

        $repair_lookup->asXml(HTML_FOLDER . 'xml/repair_lookup.xml');
    }

    function timesheet_not_submitted()
    {

        $yesterday = $this->format_date('db_date', time() - (60 * 60 * 24));

        if ($pay_period = $this->db_select_single('ts_pay_period', '*', array('period_end_date' => $yesterday))) {

            $timesheets = $this->db_select_multiple('ts_timesheet ts', 'ts.timesheet_id, da.aUser', array(), 'where period_id = "' . $pay_period['period_id'] . '" and timesheet_submitted != "1"', array('ds_admins da on da.aID = ts.timesheet_aid'));

            foreach ($timesheets as $row) {

                $grid .= '<tr><td>' . $row['aUser'] . '</td></tr>';
            }

            $body = '<p>The following users have not submitted their time sheet for ' . $pay_period['period_name'] . ':</p>';
            $body .= '<table>';
            $body .= $grid;
            $body .= '</table>';

            $this->send_email(MANAGER_EMAIL, INFO_FROM, $pay_period['period_name'], $body);
        }
    }

    function complete_pay_period()
    {

        global $timesheetObj;

        $curr_date = $this->format_date('db_date');

        $pay_period = $this->db_select_single('ts_pay_period', '*', array(), 'where period_end_date < "' . $curr_date . '" order by period_end_date desc limit 0,1');

        $period_id = $pay_period['period_id'];

        if ($pay_period['period_complete'] != 1) {

            $join = array('ds_admins da on da.aID = ts.timesheet_aid');

            $timesheets = $this->db_select_multiple(
                'ts_timesheet ts',
                'ts.*',
                array(),
                'where ts.period_id = "' . $period_id . '" and ts.timesheet_submitted != "1" and da.aTimesheet = "Y"',
                $join
            );

            if ($timesheets == 0) {
                $this->db_update('ts_pay_period', 'period_id', $period_id, array('period_complete' => 1));

                $subject = 'Pay Period ' . $pay_period['period_name'] . ' Spreadsheet';

                $spreadsheet = $timesheetObj->generate_spreadsheet($period_id);

                if ($spreadsheet != '<p><strong>No time sheets currently exist for the selected pay period.</strong></p>') {
                    $body = '<link href="' . SITE_URL . 'admin_header.css" rel="stylesheet" type="text/css" />';
                    $body .= $spreadsheet;
                    $test = $body;

                    $this->send_email(MANAGER_EMAIL, INFO_FROM, $subject, $body);
                }
            }
        }
    }

    function email_stock_order()
    {

        //get current order id
        $current_order = $this->db_select_single('gsx_stock_order', 'gsx_stock_id, confirmationNumber', array(), 'where confirmationNumber is null order by gsx_stock_id desc');

        $order_id = $current_order['gsx_stock_id'];
        $order_number = 'ST' . str_pad($order_id, 4, '0', STR_PAD_LEFT);

        //get array of parts ordered
        $parts = $this->db_select_multiple('gsx_stock_order_parts', 'gsx_stock_parts_id, partNumber, partDescription, stockPrice, quantity', array('gsx_stock_id' => $order_id), 'order by partNumber');

        if (is_array($parts)) {
            foreach ($parts as $partitem) {

                $parts_table .= '<tr>';
                $parts_table .= '<td>' . $partitem['partNumber'] . '</td>';
                $parts_table .= '<td>' . $partitem['partDescription'] . '</td>';
                $parts_table .= '<td>' . $partitem['quantity'] . '</td>';
                $parts_table .= '<td>' . $partitem['stockPrice'] . '</td>';
                $parts_table .= '</tr>';
            }

            $output = '<table>';
            $output .= '<tr>';
            $output .= '<td>Part Number</td>';
            $output .= '<td>Description</td>';
            $output .= '<td>Quantity</td>';
            $output .= '<td>Price</td>';
            $output .= '</tr>';
            $output .= $parts_table;
            $output .= '</table>';

            $this->send_email(
                    MANAGER_EMAIL,
                    INFO_FROM,
                    'Stock Order #' . $order_number,
                    $output
                );

            //update ds_orders table
            $this->db_update(
                'gsx_stock_order',
                'gsx_stock_id',
                $order_id,
                array(
                    'confirmationNumber' => 'Ordered',
                    'order_date' => date('Y-m-d')
                )
            );
        }
    }

    function print_refurb_slips()
    {

        global $orderObj;

        $data = $this->db_select_multiple('print_queue', '*', array(), 'where print_type = "checkin" and queue_time is null');

        $this->db_query('update print_queue set queue_time = "' . $this->format_date('db_full') . '" where queue_time is null');

        foreach ($data as $row) {

            if ($orderObj->print_slip($row['job_id'], $row['printer'], 'checkin')) {
                $this->db_update('print_queue', 'print_queue_id', $row['print_queue_id'], array('print_time' => $this->format_date('db_full')));
            } else {
                $this->db_query('update print_queue set queue_time = NULL where print_queue_id = ' . $row['print_queue_id'], 'update');
            }
        }
    }

    function order_exports($argv)
    {

        global $searchObj;

        $output = null;

        //set variable
        $path_to_files = '/var/www/vhosts/macservice.com/logs/exports/';

        if ($argv[4]) {

            $start_date = strtotime($argv[4]);
            $end_date = strtotime($argv[4]);
            $file_prefix = date('m-d-Y', $start_date);
            $merge_prefix = date('Y-m-d', $start_date);
        } else {

            //$start_date = time() - (60 * 60 * 24);
            //$end_date = time() - (60 * 60 * 24);
            $start_date = time();
            $end_date = time();

            //$file_prefix = date('m-d-Y', time() - (60 * 60 * 24));
            //$merge_prefix = date('Y-m-d', time() - (60 * 60 * 24));
            $file_prefix = date('m-d-Y', time());
            $merge_prefix = date('Y-m-d', time());
        }

        //get order numbers for day
        list($results, $youSearched) = $searchObj->run('orders', '', '', date('m/d/y', $start_date), date('m/d/y', $end_date), 'dateCompleted');

        if (is_array($results)) {
            //create export files
            if ($argv[5] && $argv[5] == 'local') {
                if ($argv[3] == 'orders') {
                    $csv = $searchObj->export_orders($results, $file_prefix);
                    exit;
                }

                if ($argv[3] == 'customers') {
                    $csv = $searchObj->export_customers($results, $file_prefix);
                    exit;
                }
            } elseif ($argv[5] && $argv[5] == 'server') {
                if ($argv[3] == 'orders') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, false, false, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_2_1.csv", $csv);
                }

                if ($argv[3] == 'nopo') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, true, false, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_3_1.csv", $csv);
                }

                if ($argv[3] == 'hardware') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, false, true, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_4_1.csv", $csv);
                }

                if ($argv[3] == 'nopohardware') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, true, true, false);

                    file_put_contents("{$path_to_files}{$merge_prefix}file_5_1.csv", $csv);
                }

                if ($argv[3] == 'customers') {
                    $csv = $searchObj->export_customers($results, $file_prefix, true);

                    //file_put_contents("{$path_to_files}{$file_prefix}customer.csv", $csv);
                    file_put_contents("{$path_to_files}{$file_prefix}file_1_1.csv", $csv);
                }
            } else {
                if ($argv[3] == 'orders') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, false, false, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_2_1.csv", $csv);
                }

                if ($argv[3] == 'nopo') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, true, false, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_3_1.csv", $csv);
                }

                if ($argv[3] == 'hardware') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, false, true, false);

                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_4_1.csv", $csv);
                }

                if ($argv[3] == 'nopohardware') {
                    $csv = $searchObj->export_orders($results, $file_prefix, true, true, true, false);

                    file_put_contents("{$path_to_files}{$merge_prefix}file_5_1.csv", $csv);
                }

                if ($argv[3] == 'customers') {
                    $csv = $searchObj->export_customers($results, $file_prefix, true);

                    //file_put_contents("{$path_to_files}{$file_prefix}customer.csv", $csv);
                    file_put_contents("{$path_to_files}{$merge_prefix}file_1_1.csv", $csv);
                }
            }


            //send files
            //exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}");
            //exec("scp {$path_to_files}{$file_prefix}customer.csv {$path_to_remote_files}");
        }

        if ($argv[3] == 'apple_parts') {
            if ($csv = $searchObj->export_apple_parts(date('Y-m-d', $start_date), date('Y-m-d', $end_date))) {
                file_put_contents("{$path_to_files}{$file_prefix}apple_parts.csv", $csv);

                //send files
                //exec("scp {$path_to_files}{$file_prefix}apple_parts.csv {$path_to_remote_files}");
            }
        }

        if ($argv[3] == 'items') {
            if ($csv = $searchObj->export_apple_items(date('Y-m-d', $start_date), date('Y-m-d', $end_date))) {
                file_put_contents("{$path_to_files}{$file_prefix}items.csv", $csv);

                //send files
                //exec("scp {$path_to_files}{$file_prefix}items.csv {$path_to_remote_files}");
            }
        }

        /*if (!$argv[5] || $argv[5] == 'server') {

            if (file_exists("{$path_to_files}{$file_prefix}customer.csv") && $argv[3] == 'customers') {
                exec("scp {$path_to_files}{$file_prefix}customer.csv {$path_to_remote_files}",$output);
                unlink("{$path_to_files}{$file_prefix}customer.csv");
                $export_log = array(
                    'file_path' =>  "{$path_to_files}{$file_prefix}customers.csv",
                    'transfer_result'   =>  implode(' ',$output),
                    'file_content'      =>  $csv,
                    'function_called'   =>  'order_exports'
                );
            }

            if (file_exists("{$path_to_files}{$file_prefix}items.csv") && $argv[3] == 'items') {
                exec("scp {$path_to_files}{$file_prefix}items.csv {$path_to_remote_files}",$output);
                unlink("{$path_to_files}{$file_prefix}items.csv");
                $export_log = array(
                    'file_path' =>  "{$path_to_files}{$file_prefix}items.csv",
                    'transfer_result'   =>  implode(' ',$output),
                    'file_content'      =>  $csv,
                    'function_called'   =>  'order_exports items'
                );
            }

            if (file_exists("{$path_to_files}{$file_prefix}apple_parts.csv") && $argv[3] == 'apple_parts') {
                exec("scp {$path_to_files}{$file_prefix}apple_parts.csv {$path_to_remote_files}",$output);
                unlink("{$path_to_files}{$file_prefix}apple_parts.csv");
                $export_log = array(
                    'file_path' =>  "{$path_to_files}{$file_prefix}apple_parts.csv",
                    'transfer_result'   =>  implode(' ',$output),
                    'file_content'      =>  $csv,
                    'function_called'   =>  'order_exports apple_parts'
                );
            }

            if (file_exists("{$path_to_files}{$file_prefix}order.csv") && $argv[3] == 'orders') {
                exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}",$output);
                unlink("{$path_to_files}{$file_prefix}order.csv");
                $export_log = array(
                    'file_path' =>  "{$path_to_files}{$file_prefix}order.csv",
                    'transfer_result'   =>  implode(' ',$output),
                    'file_content'      =>  $csv,
                    'function_called'   =>  'order_exports'
                );
            }

            if (file_exists("{$path_to_files}{$file_prefix}order.csv") && $argv[3] == 'nopo') {
                exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}",$output);
                unlink("{$path_to_files}{$file_prefix}order.csv");
                $export_log = array(
                    'file_path' =>  "{$path_to_files}{$file_prefix}order.csv",
                    'transfer_result'   =>  implode(' ',$output),
                    'file_content'      =>  $csv,
                    'function_called'   =>  'order_exports nopo'
                );
            }

        }

        if (!$export_log){
            $export_log = array(
                'file_path' =>  $argv[3].$file_prefix,
                'transfer_result'   =>  'Nothing exported',
                'file_content'      =>  '',
                'function_called'   =>  'order_exports '.$argv[3]
            );
        }*/

        //$this->db_insert('export_log', $export_log);

        return $output;
    }

    function orderExportsNew($argv)
    {
        // $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com[1] orderexports[2] customers[3] '.$date[4];

        // $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexportsnew[2] $dateFrom[3] $dateTo[4];

        echo "received commands:\n";
        print_r($argv);
        require_once(HTML_FOLDER . "classes/FileExport/loadModule.php");
        echo "successfully loaded module\n";

        if ($argv[3]) {
            $dateFrom = new DateTime($argv[3], new DateTimeZone('America/Los_Angeles'));
        } else {
            $dateFrom = new DateTime('now', new DateTimeZone('America/Los_Angeles'));
        }
        if ($argv[4]) {
            $dateTo = new DateTime($argv[4], new DateTimeZone('America/Los_Angeles'));
        } else {
            $dateTo = new DateTime('now', new DateTimeZone('America/Los_Angeles'));
        }
        echo "dates parsed:\n";
        print_r($dateFrom);
        print_r($dateTo);
        echo "sending command to file export controller\n";
        FileExportController::performOrderExports($dateFrom, $dateTo);
    }

    function zoho_sync()
    {

        global $zoho_auth_tokens;

        $this->zoho_sync_process($zoho_auth_tokens['amber'], $zoho_auth_tokens['tim']);
        $this->zoho_sync_process($zoho_auth_tokens['stefanie'], $zoho_auth_tokens['tim']);
        $this->zoho_sync_process($zoho_auth_tokens['tim'], $zoho_auth_tokens['amber']);
        $this->zoho_sync_process($zoho_auth_tokens['tim'], $zoho_auth_tokens['stefanie']);
    }

    private function zoho_sync_process($from, $to)
    {

        global $zohoObj;

        $logging = false;
        $log_path = "/root/logs/";

        //fields to be inserted/updated
        $fields = array(
            'Company', 'First Name', 'Last Name', 'Designation', 'Email', 'Phone', 'Fax', 'Mobile', 'Website', 'Lead Source', 'Lead Status', 'No of Employees', 'Campaign Source', 'Street', 'City', 'State', 'Zip Code', 'Description', 'Email Opt Out', 'Salutation', 'Secondary Email', 'As Of', 'Buyback not possible', 'iMacs', 'iPad', 'Mac Pro', 'MacBook', 'MacBook Air', 'MacBook Pro', 'Nothing to sell', 'MTSB2', 'MTSS1', 'MTSS2', 'PowerBook/iBook', 'Recontact Buy', 'Recontact Sell', 'Referred By', 'Sent USB', 'Unknown', 'Reason', 'ISTE 2013', 'CETPA', 'CETPA 2013', 'FETC 2013', 'TCEA 2014', 'How did you hear about us?', '1 to 1', 'Purchased', 'Imported Activity'
        );

        if ($to['prefix'] == 'a') {
            $states = explode(',', 'AK,AL,AR,AZ,CA,CO,DE,FL,GA,HI,ID,KY,LA,MD,MS,MT,NC,NM,NV,OK,OR,SC,TN,TX,UT,VA,WA,WV,WY');
        } elseif ($to['prefix'] == 's') {
            $states = explode(',', 'CT,IA,IL,IN,KS,MA,ME,MI,MN,MO,ND,NE,NH,NJ,NY,OH,PA,RI,SD,VT,WI');
        } else {
            $states = explode(',', 'AK,AL,AR,AZ,CA,CO,DE,FL,GA,HI,ID,KY,LA,MD,MS,MT,NC,NM,NV,OK,OR,SC,TN,TX,UT,VA,WA,WV,WY,CT,IA,IL,IN,KS,MA,ME,MI,MN,MO,ND,NE,NH,NJ,NY,OH,PA,RI,SD,VT,WI');
        }

        //set date to yesterday
        $lastModifiedTime = date('Y-m-d', time() - 60 * 60 * 24);

        $count = 1;
        $i = 1;

        //get updated records in max batches of 200
        while ($count > 0) {

            $toIndex = $i * 100;
            $fromIndex = $toIndex - 99;
            $lastModifiedTime_new = $lastModifiedTime . 'T06:00:00';
            /* Bilal: Old code block comment out
            $parameters = array(
                'selectColumns' => 'All'
                , 'lastModifiedTime' => $lastModifiedTime.' 06:00:00'
                , 'fromIndex' => $fromIndex
                , 'toIndex' => $toIndex
            );

            $xml = $zohoObj->getRecords($from['authtoken'], $parameters, 'Leads');
            $result = simplexml_load_string($xml);
            $count = count($result->result->Leads->row);
             *
             */


            $zoho_array = $zohoObj->getRecords($fromIndex, $toIndex, $lastModifiedTime_new);
            $count = count($zoho_array);

            //build array to update database
            for ($j = 0; $j < $count; $j++) {

                /* Bilal: Old code block comment out
                //build insert/update array and time variables
                foreach ($result->result->Leads->row[$j]->FL as $fl){

                    if (in_array((string)$fl->attributes()->val, $fields)){
                        $zoho_array[(string)$fl->attributes()->val] = (string)$fl;
                    }

                    if ((string)$fl->attributes()->val == 'Modified By'){
                        $modified_by = (string)$fl;
                    }

                    if ((string)$fl->attributes()->val == 'Modified Time'){
                        $modified_time = (string)$fl;
                    }

                    if ((string)$fl->attributes()->val == 'Last Activity Time'){
                        $last_activity_time = (string)$fl;
                    }

                    if ((string)$fl->attributes()->val == 'Created Time'){
                        $created_time = (string)$fl;
                    }

                }
             *
             */

                $leads = array(
                    'company' => $zoho_array[$j]['Company'], 'first_name' => $zoho_array[$j]['First_Name'], 'last_name' => $zoho_array[$j]['Last_Name'], 'title' => $zoho_array[$j]['Designation'], 'email' => $zoho_array[$j]['Email'], 'phone' => $zoho_array[$j]['Phone'], 'fax' => $zoho_array[$j]['Fax'], 'mobile' => $zoho_array[$j]['Mobile'], 'website' => $zoho_array[$j]['Website'], 'lead_source' => $zoho_array[$j]['Lead_Source'], 'lead_status' => $zoho_array[$j]['Lead_Status'], 'no_of_employees' => $zoho_array[$j]['No_of_Employees'], 'campaign_source' => $zoho_array[$j]['Campaign_Status1'], 'modified_by' => $zoho_array[$j]['Modified_By_Name'], 'modified_time' => $zoho_array[$j]['Modified_Time'], 'street' => $zoho_array[$j]['Street'], 'city' => $zoho_array[$j]['City'], 'state' => $zoho_array[$j]['State'], 'zip_code' => $zoho_array[$j]['Zip_Code'], 'description' => $zoho_array[$j]['Description'], 'email_opt_out' => $zoho_array[$j]['Email_Opt_Out'], 'salutation' => $zoho_array[$j]['Salutation'], 'secondary_email' => $zoho_array[$j]['Secondary_Email'], 'last_activity_time' => $zoho_array[$j]['Last_Activity_Time'], 'recontact_buy' => $zoho_array[$j]['Recontact_Buy'], 'recontact_sell' => $zoho_array[$j]['Recontact_Sell'], 'referred_by' => $zoho_array[$j]['Referred_By'], 'how_did_you_hear_about_us' => $zoho_array[$j]['How_did_you_hear_about_us'], 'one_to_one' => $zoho_array[$j]['to_1'], 'purchased' => $zoho_array[$j]['Purchased']
                );


                $res_insert = $this->db_update('zoho_leads', 'lead_id', $zoho_array[$j]['LEADID'], $leads, false);

                //if not in database, add new record
                if ($res_insert === 0) {
                    $leads['lead_id'] = $zoho_array[$j]['LEADID'];
                    $leads['lead_owner_id'] = $from['lead_owner_id'];
                    $leads['created_time'] = $zoho_array[$j]['Created_Time'];
                    $this->db_insert('zoho_leads', $leads, false);
                }

                if (in_array($leads['state'], $states)) {

                    $cond = array(
                        'email' =>  $zoho_array['Email'], 'lead_owner_id' => $to['lead_owner_id']
                    );
                    $res = $this->db_select_single('zoho_leads', 'lead_id', $cond);
                    if (is_array($res)) {
                        $zoho_array['Id'] = $res[0];
                        $update_zoho[] = $zoho_array;
                    } else {
                        //if (in_array($result->result->Leads->row[$j]->FL[23], $states)){
                        if (in_array($zoho_array['state'], $states)) {
                            $insert_zoho[] = $zoho_array;
                        }
                    }
                }

                unset($zoho_array);
            }

            $i++;

            //batch run zoho updates and inserts
            if ($update_zoho) {
                $result = $zohoObj->updateRecords($update_zoho);

                /* Bilal: Old code block comment out
                $result = $zohoObj->updateRecords($to['authtoken'],'Leads',$update_zoho);
                if ($logging){
                    $dom = new DOMDocument;
                    $dom->preserveWhiteSpace = false;
                    $dom->loadXML($result['result']);
                    $dom->formatOutput = true;
                    file_put_contents($log_path.$lastModifiedTime.'-'.$from['prefix'].'-'.$to['prefix'].'-'.$i.'-update_result.log', $dom->saveXML(), FILE_APPEND);
                    file_put_contents($log_path.$lastModifiedTime.'-'.$from['prefix'].'-'.$to['prefix'].'-'.$i.'-update_request.log', $result['request'], FILE_APPEND);
                }
                     *
                     */
            }

            if ($insert_zoho) {
                $result = $zohoObj->insertRecords($insert_zoho);

                /* Bilal: Old code block comment out
                $result = $zohoObj->insertRecords($to['authtoken'],'Leads',$insert_zoho);
                if ($logging){
                    $dom = new DOMDocument;
                    $dom->preserveWhiteSpace = false;
                    $dom->loadXML($result['result']);
                    $dom->formatOutput = true;
                    file_put_contents($log_path.$lastModifiedTime.'-'.$from['prefix'].'-'.$to['prefix'].'-'.$i.'-insert_result.log', $dom->saveXML(), FILE_APPEND);
                    file_put_contents($log_path.$lastModifiedTime.'-'.$from['prefix'].'-'.$to['prefix'].'-'.$i.'-insert_request.log', $result['request'], FILE_APPEND);
                }
                     *
                     */
            }

            /* Bilal: Old code block comment out
            if ($logging){
                $dom = new DOMDocument;
                $dom->preserveWhiteSpace = false;
                $dom->loadXML($xml);
                $dom->formatOutput = true;
                file_put_contents($log_path.$lastModifiedTime.'-'.$from['prefix'].'-'.$to['prefix'].'-'.$i.'-get_records.log', $dom->saveXML(), FILE_APPEND);
            }
             *
             */
            unset($update_zoho);
            unset($insert_zoho);
        }

        unset($count);
    }

    function email_audit_csv()
    {

        $start_date = time() - (60 * 60 * 24 * 4);

        $test = date('Y-m-d', $start_date);

        $sql = "select date_format(al.start_time,'%m/%d/%y') audit_date, da.aUser, dr.serialNumber, ml.model_number, dr.grade, timediff(al.end_time,al.start_time) audit_time,
                    (select order_number from machine_order_number where machine_id = pm.machine_id limit 1) order_number
                    from audit_log al
                    left join ds_admins da on da.aID = al.aID
                    left join ds_orders dr on dr.oNum = al.oNum
                    left join product_model pm on pm.configCode = substring(dr.serialNumber,9)
                    left join machine_lookup ml on ml.machine_id = pm.machine_id
                    where al.start_time > '$test' and al.end_time != ''
                    order by al.start_time";

        $data = $this->db_query($sql, 'select-multiple');

        $output = 'Date, User, Serial Number, Order Number, Model Number, Grade, Time to complete' . "\n";
        foreach ($data as $row) {

            $output .=
                $row['audit_date']
                . ',' . $row['aUser']
                . ',' . $row['serialNumber']
                . ',' . $row['model_number']
                . ',' . $row['order_number']
                . ',' . $row['grade']
                . ',' . $row['audit_time']
                . "\n";
        }
        $csv = LABEL_TEMP_DIR . 'audit_weekly.csv';
        $this->write_file($csv, 'w', $output);
        $this->send_email(
            JUSTIN_EMAIL,
            INFO_FROM,
            'Audit Report CSV',
            'Please refer to the attached',
            '',
            array($csv)
        );
    }

    function zoho_contact_sync()
    {

        global $zohoObj, $zoho_auth_tokens;

        //set parameters to retrieve invoice numbers for drop down
        $parameters = array(
            'scope'     =>  'crmapi', 'selectColumns'    =>  'All' //columns to select
            , 'fromIndex'        =>  1 //start record
            , 'toIndex'          =>  200 //end record
            , 'sortColumnString' =>  'MTS Quote Number' //sort column
            , 'searchCondition'  =>  '(Status|contains|*PO*)' //filter
        );

        //retrieve records for all users

        /* Bilal: Old code block comment out
        foreach($zoho_auth_tokens as $row){
            $result = $zohoObj->getSearchRecords($row['authtoken'], $parameters,'Invoices');
            $numberOfRecords = count($result->result->Invoices->row);
            for ($i = 0; $i < $numberOfRecords; $i++) {
                $contacts[] = $result->result->Invoices->row[$i]->FL[24];
            }
         *
         */

        /* Bilal Modifications */
        $contacts = $zohoObj->getSearchRecords();

        //check if contact is in db and if not, add it
        foreach ($contacts as $contact_row) {

            /* Bilal Modifications */
            //                $contact_result = $zohoObj->getRecordById($row['authtoken'], $contact_row,'Contacts','Contacts(Account Name,Email,Phone,Other Phone,First Name,Last Name,Mailing Street,Mailing City,Mailing State,Mailing Zip)');
            $contact_result = $zohoObj->getRecordById_cron($contact_row);

            if (!$ds_customers = $this->db_select_single('ds_customers', '*', array('cEmail' => $contact_result['cEmail']))) {
                /* Bilal Modifications */

                //                    $fields = array(
                //                            'cEmail'            =>  $contact_result->result->Contacts->row[0]->FL[5]
                //                            ,'cPhone'           =>  $contact_result->result->Contacts->row[0]->FL[6]
                //                            ,'cPhone2'          =>  $contact_result->result->Contacts->row[0]->FL[7]
                //                            ,'cShipCompany'     =>  $contact_result->result->Contacts->row[0]->FL[4]
                //                            ,'cShipFname'       =>  $contact_result->result->Contacts->row[0]->FL[1]
                //                            ,'cShipLname'       =>  $contact_result->result->Contacts->row[0]->FL[2]
                //                            ,'cShipAddress1'    =>  $contact_result->result->Contacts->row[0]->FL[8]
                //                            ,'cShipCity'        =>  $contact_result->result->Contacts->row[0]->FL[9]
                //                            ,'cShipState'       =>  $contact_result->result->Contacts->row[0]->FL[10]
                //                            ,'cShipZip'         =>  $contact_result->result->Contacts->row[0]->FL[11]
                //                            ,'cShipCountry'     =>  'US'
                //                            ,'cBillCompany'     =>  $contact_result->result->Contacts->row[0]->FL[4]
                //                            ,'cBillFname'       =>  $contact_result->result->Contacts->row[0]->FL[1]
                //                            ,'cBillLname'       =>  $contact_result->result->Contacts->row[0]->FL[2]
                //                            ,'cBillAddress1'    =>  $contact_result->result->Contacts->row[0]->FL[8]
                //                            ,'cBillCity'        =>  $contact_result->result->Contacts->row[0]->FL[9]
                //                            ,'cBillState'       =>  $contact_result->result->Contacts->row[0]->FL[10]
                //                            ,'cBillZip'         =>  $contact_result->result->Contacts->row[0]->FL[11]
                //                            ,'zoho_contactid'   =>  $contact_result->result->Contacts->row[0]->FL[0]
                //                            ,'cBillCountry'     =>  'US'
                //                            ,'educational'      =>  'Y'
                //                            ,'billEqualShip'    =>  'Y'
                //                            ,'cString'          => $this->createUniqueKey()
                //                    );

                $fields = $contact_result;
                $fields['cString'] = $this->createUniqueKey();

                $this->db_insert('ds_customers', $fields);
            }
        }
        unset($contacts);
        //        }
    }

    function get_ebay_orders($page = false)
    {

        global $ebayObj;

        if (!$page) {
            $eBayOrders = $ebayObj->GetOrders(16);
        } else {
            $eBayOrders = $ebayObj->GetOrders(16, $page);
        }

        foreach ($eBayOrders->OrderArray->Order as $eBayOrder) {

            if ($eBayOrder->CheckoutStatus->PaymentMethod == 'PayPal' && $eBayOrder->CheckoutStatus->Status == 'Complete') {

                $ebay_order = $this->db_select_single('ebay_orders', '*', array('order_id' => $eBayOrder->OrderID));

                if ($ebay_order) {
                    $db_data = array(
                        'order_id'      =>  $eBayOrder->OrderID,
                        'user_id'       =>  $eBayOrder->BuyerUserID,
                        'email'         =>  $eBayOrder->TransactionArray->Transaction->Buyer->Email,
                        'user_name'     =>  $eBayOrder->ShippingAddress->Name,
                        'street1'       =>  $eBayOrder->ShippingAddress->Street1,
                        'street2'       =>  $eBayOrder->ShippingAddress->Street2,
                        'city'          =>  $eBayOrder->ShippingAddress->CityName,
                        'state'         =>  $eBayOrder->ShippingAddress->StateOrProvince,
                        'zip'           =>  $eBayOrder->ShippingAddress->PostalCode,
                        'item'          =>  $eBayOrder->TransactionArray->Transaction->Item->Title,
                        'quantity'      =>  $eBayOrder->TransactionArray->Transaction->QuantityPurchased,
                        'total_value'   =>  number_format((float)$eBayOrder->Total, 2),
                        'created_time'  =>  $eBayOrder->CreatedTime,
                        'tracking_number'   =>  $eBayOrder->TransactionArray->Transaction->ShippingDetails->ShipmentTrackingDetails->ShipmentTrackingNumber,
                        'ship_date'     =>  $eBayOrder->ShippedTime,
                        'price'         =>  number_format((float)$eBayOrder->TransactionArray->Transaction->TransactionPrice, 2),
                        'fee'           =>  number_format((float)$eBayOrder->MonetaryDetails->Payments->Payment->FeeOrCreditAmount, 2),
                        'phone'         =>  $eBayOrder->ShippingAddress->Phone,
                        'sku'           =>  'Hardware',
                        'tax'           =>  $eBayOrder->ShippingDetails->SalesTax->SalesTaxAmount,
                        'record_number' =>  $eBayOrder->ShippingDetails->SellingManagerSalesRecordNumber,
                        'payment_date'  =>  $eBayOrder->MonetaryDetails->Payments->Payment->PaymentTime
                    );

                    //$this->db_insert('ebay_orders', $db_data);
                    $this->db_update('ebay_orders', 'order_id', $db_data['order_id'], array('record_number' => $db_data['record_number']));
                }
            }
        }

        if (!$page) {
            $totalPages = (int)$eBayOrders->PaginationResult->TotalNumberOfPages;

            if ($totalPages > 1) {
                for ($i = 2; $i <= $totalPages; $i++) {
                    $this->get_ebay_orders($i);
                }
            }
        }
    }

    /*function get_ebay_orders($page = false){

        global $ebayObj;

            if (!$page){
                $eBayOrders = $ebayObj->GetOrders(15);
            }else{
                $eBayOrders = $ebayObj->GetOrders(15,$page);
            }

            foreach ($eBayOrders->OrderArray->Order as $eBayOrder){

                if ($eBayOrder->CheckoutStatus->PaymentMethod == 'PayPal' && $eBayOrder->CheckoutStatus->Status == 'Complete'){

                    $ebay_order = $this->db_select_single('ebay_orders', '*', array('order_id' => $eBayOrder->OrderID));

                    if (!$ebay_order){
                        $db_data = array(
                            'order_id'      =>  $eBayOrder->OrderID,
                            'user_id'       =>  $eBayOrder->BuyerUserID,
                            'email'         =>  $eBayOrder->TransactionArray->Transaction->Buyer->Email,
                            'user_name'     =>  $eBayOrder->ShippingAddress->Name,
                            'street1'       =>  $eBayOrder->ShippingAddress->Street1,
                            'street2'       =>  $eBayOrder->ShippingAddress->Street2,
                            'city'          =>  $eBayOrder->ShippingAddress->CityName,
                            'state'         =>  $eBayOrder->ShippingAddress->StateOrProvince,
                            'zip'           =>  $eBayOrder->ShippingAddress->PostalCode,
                            'item'          =>  $eBayOrder->TransactionArray->Transaction->Item->Title,
                            'quantity'      =>  $eBayOrder->TransactionArray->Transaction->QuantityPurchased,
                            'total_value'   =>  number_format((float)$eBayOrder->Total,2),
                            'created_time'  =>  $eBayOrder->CreatedTime,
                            'tracking_number'   =>  $eBayOrder->TransactionArray->Transaction->ShippingDetails->ShipmentTrackingDetails->ShipmentTrackingNumber,
                            'ship_date'     =>  $eBayOrder->ShippedTime,
                            'price'         =>  number_format((float)$eBayOrder->TransactionArray->Transaction->TransactionPrice,2),
                            'fee'           =>  number_format((float)$eBayOrder->MonetaryDetails->Payments->Payment->FeeOrCreditAmount,2),
                            'phone'         =>  $eBayOrder->ShippingAddress->Phone,
                            'sku'           =>  'Hardware',
                            'tax'           =>  $eBayOrder->ShippingDetails->SalesTax->SalesTaxAmount
                        );

                        $this->db_insert('ebay_orders', $db_data);
                    }
                }
            }

            if (!$page){
                $totalPages = (int)$eBayOrders->PaginationResult->TotalNumberOfPages;

                if ($totalPages > 1){
                    for($i=2;$i<=$totalPages;$i++){
                        $this->get_ebay_orders($i);
                    }
                }
            }

    }*/

    function ebay_order_export($argv)
    {

        global $searchObj, $paypalObj;

        //set variable
        $path_to_files = '/var/www/vhosts/macservice.com/logs/exports/';

        //$path_to_remote_files = 'serveradmin@50.250.235.169:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';
        $path_to_remote_files = '';

        if ($argv[4]) {
            $date = strtotime($argv[4]);
        } else {
            //$date = time()-(60*60*24);
            $date = time();
        }

        //$date = time() - (60 * 60 * 24);

        $file_prefix = $this->format_date('db_date', $date);

        switch ($argv[3]) {
            case 'customers':

                $customer_csv = $searchObj->export_ebay_customers($date);

                if ($customer_csv != "") {
                    //file_put_contents("{$path_to_files}{$file_prefix}customer.csv", $customer_csv);
                    file_put_contents("{$path_to_files}{$file_prefix}file_1_4.csv", $customer_csv);
                    exec("scp -v {$path_to_files}{$file_prefix}customer.csv {$path_to_remote_files}", $output);
                    unlink("{$path_to_files}{$file_prefix}customer.csv");
                    $export_log = array(
                        'file_path' =>  "{$path_to_files}{$file_prefix}items.csv",
                        'transfer_result'   =>  implode(' ', $output),
                        'file_content'      =>  $customer_csv,
                        'function_called'   =>  'ebay_order_export customers'
                    );
                }
                break;

            case 'nosku':

                $order_csv = $searchObj->export_ebay_orders($date, false);

                if ($order_csv != "") {
                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $order_csv);
                    file_put_contents("{$path_to_files}{$file_prefix}file_4_4.csv", $order_csv);
                    exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}", $output);
                    unlink("{$path_to_files}{$file_prefix}order.csv");
                    $export_log = array(
                        'file_path' =>  "{$path_to_files}{$file_prefix}order.csv",
                        'transfer_result'   =>  implode(' ', $output),
                        'file_content'      =>  $order_csv,
                        'function_called'   =>  'ebay_order_export nosku'
                    );
                }

                break;

            case 'nopo':

                $order_csv = $searchObj->export_ebay_orders($date, false, true);

                if ($order_csv != "") {
                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $order_csv);
                    file_put_contents("{$path_to_files}{$file_prefix}file_3_4.csv", $order_csv);
                    exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}", $output);
                    unlink("{$path_to_files}{$file_prefix}order.csv");
                    $export_log = array(
                        'file_path' =>  "{$path_to_files}{$file_prefix}order.csv",
                        'transfer_result'   =>  implode(' ', $output),
                        'file_content'      =>  $order_csv,
                        'function_called'   =>  'ebay_order_export nopo'
                    );
                }

                break;

            case 'orders':

                $order_csv = $searchObj->export_ebay_orders($date);

                if ($order_csv != "") {
                    //file_put_contents("{$path_to_files}{$file_prefix}order.csv", $order_csv);
                    file_put_contents("{$path_to_files}{$file_prefix}file_2_4.csv", $order_csv);
                    exec("scp {$path_to_files}{$file_prefix}order.csv {$path_to_remote_files}", $output);
                    unlink("{$path_to_files}{$file_prefix}order.csv");
                    $export_log = array(
                        'file_path' =>  "{$path_to_files}{$file_prefix}order.csv",
                        'transfer_result'   =>  implode(' ', $output),
                        'file_content'      =>  $order_csv,
                        'function_called'   =>  'ebay_order_export orders'
                    );
                }

                break;

            case 'paypal':

                $path_to_remote_files = 'serveradmin@10.8.0.5:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';

                $paypal_csv = $searchObj->export_paypal_journal();

                $params = array('STARTDATE' => $file_prefix . 'T00:00:00Z', 'ENDDATE' => $file_prefix . 'T23:59:59Z');

                $transactions = $paypalObj->request('TransactionSearch', $params);

                $count = count($transactions);

                $rowcount = ($count - 5) / 11;

                for ($i = 0; $i < $rowcount; $i++) {

                    if ($transactions['L_TYPE' . $i] == 'Payment' && $transactions['L_STATUS' . $i] == 'Completed') {

                        $paypal_row['payment_date'] = $file_prefix;
                        $paypal_row['user_name'] = $transactions['L_NAME' . $i];
                        $paypal_row['fee'] = abs($transactions['L_FEEAMT' . $i]);

                        $paypal_arr[] = $paypal_row;
                    }
                }

                if ($paypal_arr) {
                    if ($paypal_csv != "") {
                        $paypal_csv .= $searchObj->export_paypal_payments($paypal_arr);
                    } else {
                        $paypal_csv = $searchObj->export_paypal_payments($paypal_arr, false);
                    }
                }


                if ($paypal_csv != "") {
                    file_put_contents("{$path_to_files}Paypaljournalentry-{$file_prefix}.csv", $paypal_csv);
                    exec("scp -v {$path_to_files}Paypaljournalentry-{$file_prefix}.csv {$path_to_remote_files}", $output);
                    //unlink("{$path_to_files}Paypaljournalentry-{$file_prefix}.csv");
                    $export_log = array(
                        'file_path' =>  "{$path_to_files}Paypaljournalentry-{$file_prefix}.csv",
                        'transfer_result'   =>  implode(' ', $output),
                        'file_content'      =>  $paypal_csv,
                        'function_called'   =>  'ebay_order_export paypal ' . $file_prefix
                    );
                    $this->db_insert('export_log', $export_log);
                }

                break;
        }

        if (!$export_log) {
            $export_log = array(
                'file_path' =>  $argv[3] . $file_prefix,
                'transfer_result'   =>  'Nothing exported',
                'file_content'      =>  '',
                'function_called'   =>  'ebay_order_export ' . $argv[3]
            );
        }

        //$this->db_insert('export_log', $export_log);

    }

    function verify_shipped()
    {

        global $upsObj;

        $body = '';

        $startdate = $this->format_date('db_date', time() - (60 * 60 * 24 * 7));
        $enddate = $this->format_date('db_date') . ' 18:00:00';

        $sql = "select distinct oNum from ds_order_logs where time between '$startdate' and '$enddate' and details = 'Order Status Changed to Roundtrip - Box Sent'";

        $orders = $this->db_query($sql, 'select-multiple');

        foreach ($orders as $order) {

            $sql = "select right(details,18) as tracking_no from ds_order_logs where oNum = '{$order['oNum']}' and details like 'Shipment Created%' and time > '$startdate' order by time asc limit 1";

            $tracking = $this->db_query($sql, 'select-single');

            $tracking_no = $tracking['tracking_no'];

            $data = $upsObj->track_data($tracking_no);

            if ($data['ACT_DESC'] == 'BILLING INFORMATION RECEIVED') {
                $body .= '<tr><td>' . $order['oNum'] . '</td><td>' . $tracking_no . '</td></tr>';
            }
        }

        if ($body != '') {

            $output = '<table><tr><td>Order Number</td><td>Tracking Number</td></tr>';
            $output .= $body;
            $output .= '</table>';
            $this->send_email(
                    ORDER_STATUS_ALERT,
                    INFO_FROM,
                    'Empty Box Shipments Not Picked Up',
                    $output,
                    'text/html',
                    array(),
                    JUSTIN_EMAIL
                );
        }
    }


    function sendImagingCompleteEmail($argv)
    {
        $orderId = '';
        if ($argv[3]) {
            $orderId = $argv[3];
        } else {
            echo "Error: No order ID passed. Exiting.\n";
            return false;
        }
        global $searchObj;

        $sql = "SELECT * FROM po_orders WHERE order_id='$orderId';";
        $poOrder = $this->db_query($sql, 'select-single');

        $orderAccountId = $poOrder['account_id'];

        $sql = "SELECT `account_name` FROM `po_accounts` WHERE `account_id`='$orderAccountId';";
        $result = $this->db_query($sql, 'select-single');
        $accountName = $result['account_name'];

        require_once(HTML_FOLDER . "classes/Csv/loadModule.php");

        $orderNumber = $poOrder['order_number'];
        $dateReceivedStr = date('m/d/Y', strtotime($poOrder['date_received']));
        $dateImagingCompleteStr = date('m/d/Y', strtotime($poOrder['date_imaging_complete']));
        $imagingNotes = $poOrder['imaging_notes'];

        $sql = 'SELECT "mdm_lock" AS lock_type, COUNT(dso.mdm_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "' . $orderNumber . '" AND dso.mdm_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "activation_lock" AS lock_type, COUNT(dso.activation_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "' . $orderNumber . '" AND dso.activation_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "audit_mdm_lock" AS lock_type, COUNT(dso.audit_mdm_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "' . $orderNumber . '" AND dso.audit_mdm_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "audit_activation_lock" AS lock_type, COUNT(dso.audit_activation_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "' . $orderNumber . '" AND dso.audit_activation_lock = 1 AND pod.deduction_id = 12;';

        $locks = $this->db_query($sql, 'select-multiple');

        $mdmLock = 0;
        $activationLock = 0;
        $auditMdmLock = 0;
        $auditActivationLock = 0;

        foreach ($locks as $lock) {
            if ($lock['lock_type'] == 'mdm_lock') {
                $mdmLock = $lock['total'];
            }
            if ($lock['lock_type'] == 'activation_lock') {
                $activationLock = $lock['total'];
            }
            if ($lock['lock_type'] == 'audit_mdm_lock') {
                $auditMdmLock = $lock['total'];
            }
            if ($lock['lock_type'] == 'audit_activation_lock') {
                $auditActivationLock = $lock['total'];
            }
        }

        $to = 'Justin Sanderson <justin.s@techtoschool.com>,Jason Melero <j.melero@techtoschool.com>';
        $from = "TTS Admin Info <info@macservice.com>";
        $subject = "$orderNumber Imaging Complete - $accountName";
        $body = "<div>
					<h3>Summary for <a href='https://macservice.com/admin_controller.php?m=bb_detail&order_id=$orderId' target='_blank'>$orderNumber</a></h3>
					<p><strong>Date Received:</strong> $dateReceivedStr</p>
					<p><strong>Date Imaging Complete:</strong> $dateImagingCompleteStr</p>
					<p><strong>MDM Locked At Audit:</strong> $auditMdmLock</p>
					<p><strong>MDM Locked:</strong> $mdmLock</p>
					<p><strong>Activation Locked At Audit:</strong> $auditActivationLock</p>
					<p><strong>Activation Locked:</strong> $activationLock</p>
					<hr />
					<p><strong>Imaging Notes:</strong> $imagingNotes</p>
				</div>";


        $type = "text/html";

        $csvData = explode(PHP_EOL, str_replace('"', '', $searchObj->export_bb_locks($orderNumber, true)));
        $filename = $orderNumber . "_lock_export.csv";
        $csvPaths = CsvBuilder::buildCsv($csvData, $filename);
        $csv = $csvPaths->full;
        $attachments = array($csv);
        $cc = 'm.kemper@techtoschool.com';

        // echo "<h3>Sending email with following parameters</h3>";
        // echo "<p>To: ".htmlspecialchars($to)."</p>";
        // echo "<p>From: ".htmlspecialchars($from)."</p>";
        // echo "<p>Subject: ".htmlspecialchars($subject)."</p>";
        // echo "<p>Body:</p>$body";
        // echo "<p>Type: ".htmlspecialchars($type)."</p>";
        // echo "<p>Attachments: " . implode(', ', $attachments);
        // echo "<p>Cc: ".htmlspecialchars($cc)."</p>";

        // require_once(HTML_FOLDER . "classes/Email/loadModule.php");


        // $emailData = new stdClass;
        // $emailData->recipients = array(
        // 	'Justin Sanderson' => 'justin.s@techtoschool.com',
        // 	'Tim McNiff' => 't.mcniff@techtoschool.com',
        // 	'Michael Kemper' => 'm.kemper@techtoschool.com'
        // );
        // $emailData->fromName = "Tech To School";
        // $emailData->fromEmail = 'info@techotoschool.com';
        // $emailData->subject = $subject;
        // $emailData->body = $body;

        // $sent = EmailController::sendEmail($emailData);

        // if ($sent) {
        // 	echo "<p>Email controller succeeded in sending</p>";
        // }
        // else {
        // 	echo "<p>Email controller failed</p>";
        // }

        $result = $this->send_email($to, $from, $subject, $body, $type, $attachments, $cc);

        if ($result == true) {
            echo "Email sent successfully\n";
            $sql = "UPDATE `po_orders` SET `imaging_complete_email_sent`='1' WHERE `order_id`='$orderId';";
            $this->db_query($sql, 'update');
        } else {
            echo "Email failed to send\n";
        }

        // return send_email($to, $from, $subject, $body, $type='text/html', $attachments=array(), $cc = '', $bcc = '')
    }

    function file_exports()
    {

        $commands = $this->db_select_multiple('cron_queue', '*', array(), 'order by cron_queue_id asc');

        foreach ($commands as $command) {

            $this->db_delete('cron_queue', 'cron_queue_id', $command['cron_queue_id']);
        }

        foreach ($commands as $command) {

            exec($command['cron_queue_command']);

            sleep($command['delay']);
        }
    }

    /*function zoho_order_exports(){

        global $zohoObj, $zoho_auth_tokens, $searchObj;

        $path_to_files = '/Users/jeffpaff/Desktop/labels/';

        //$path_to_remote_files = 'serveradmin@50.250.235.169:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';

        $exclude = array('KH','AL','BH');

        $index = 1;
        $offset = 30;

        while ($offset > 0) {

            $toIndex = $index * 100;
            $fromIndex = $toIndex - 99;

            foreach ($zoho_auth_tokens as $auth_token) {

                $lastModifiedTime = $this->format_date('db_date',time()-(60*60*24*$offset));

                $parameters = array(
                    'selectColumns' => 'All'
                    //, 'lastModifiedTime' => $lastModifiedTime.' 06:00:00'
                    , 'criteria' => '((Status:Shipped)AND(Ship Date:'.$lastModifiedTime.'))'
                    //, 'fromIndex' => $fromIndex
                    , 'toIndex' => 200
                );

                $xml = $zohoObj->searchRecords($auth_token['authtoken'], $parameters, 'Invoices');
                $result = $xml;
                $count = count($result->result->Invoices->row);

                $zoho_array = array();

                //build array to update database
                for ($j = 0; $j < $count; $j++) {

                    //build insert/update array and time variables
                    foreach ($result->result->Invoices->row[$j]->FL as $fl){

                        if ($fl->attributes()->val == 'Product Details'){

                            $product_count = count($fl->product);

                            for ($i = 0; $i < $product_count; $i++) {

                                foreach ($fl->product[$i]->FL as $product_fl){

                                    $product_array[(string)$product_fl->attributes()->val] = (string)$product_fl;

                                }

                                if (!in_array($product_array['Product Name'], $exclude)){

                                    $product = $zohoObj->getRecordById($auth_token['authtoken'],$product_array['Product Id'],'Products','Products(Product Code)');

                                    if ((string)$product->result->Products->row[0]->FL[1] != ''){
                                        $product_array['Item Number'] = (string)$product->result->Products->row[0]->FL[1];
                                    }else{
                                        $product_array['Item Number'] = 'Hardware';
                                    }

                                    $product_array['Item Number'] = 'Hardware';

                                    $zoho_products[] = $product_array;

                                }

                            }


                            $zoho_array['Product Details'] = $zoho_products;

                            unset($zoho_products);

                        }else{

                            $zoho_array[(string)$fl->attributes()->val] = (string)$fl;

                        }

                    }

                    $zoho_items[] = $zoho_array;

                }

            }

            $offset --;

        }

        $custcsv = $searchObj->export_zoho_customers($zoho_items);
        file_put_contents($path_to_files.$lastModifiedTime."_zoho_customer.csv", $custcsv);
        //exec("scp {$path_to_files}{$lastModifiedTime}_zoho_customer.csv {$path_to_remote_files}");
        //unlink("{$path_to_files}{$lastModifiedTime}_zoho_customer.csv");
        $ordercsv = $searchObj->export_zoho_orders($zoho_items);
        file_put_contents($path_to_files.$lastModifiedTime."_zoho_orders.csv", $ordercsv);
        //exec("scp {$path_to_files}{$lastModifiedTime}_zoho_orders.csv {$path_to_remote_files}");
        //unlink("{$path_to_files}{$lastModifiedTime}_zoho_orders.csv");

        //$test = $custcsv;

    }*/

    function zoho_order_exports($argv)
    {
        //        echo "coming zoho_order_exports";
        //        if(!isset($argv[3]))
        //        {
        //            $argv[3] = "all";
        //            $argv[4] = "2019-12-20";
        //        }
        global $zohoObj, $zoho_auth_tokens, $searchObj;

        $path_to_files = '/var/www/vhosts/macservice.com/logs/exports/';

        //$path_to_remote_files = 'serveradmin@50.250.235.169:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';
        $path_to_remote_files = '';

        $exclude = array('KH', 'AL', 'BH');

        if ($argv[4]) {
            $lastModifiedTime = $this->format_date('db_date', strtotime($argv[4]));
        } else {
            //$lastModifiedTime = $this->format_date('db_date',time()-(60*60*24));
            $lastModifiedTime = $this->format_date('db_date', time());
        }

        //        file_put_contents("./zohodata_argv.txt", print_r($argv,true));
        /* Bilal: Old code block comment out

        foreach ($zoho_auth_tokens as $auth_token) {

            $parameters = array(
                'selectColumns' => 'All'
                , 'criteria' => '((Status:Shipped)AND(Ship Date:'.$lastModifiedTime.'))'
                , 'toIndex' => 200
            );

            $xml = $zohoObj->searchRecords($auth_token['authtoken'], $parameters, 'Invoices');
            $result = $xml;
            $count = count($result->result->Invoices->row);

            $zoho_array = array();

            //build array to update database
            for ($j = 0; $j < $count; $j++) {

                //build insert/update array and time variables
                foreach ($result->result->Invoices->row[$j]->FL as $fl){

                    if ($fl->attributes()->val == 'Product Details'){

                        $product_count = count($fl->product);

                        for ($i = 0; $i < $product_count; $i++) {

                            foreach ($fl->product[$i]->FL as $product_fl){

                                $product_array[(string)$product_fl->attributes()->val] = (string)$product_fl;

                                if ((string)$product_fl->attributes()->val == 'Product Name' && (string)$product_fl == 'SHIPPING'){
                                    foreach ($fl->product[$i]->FL as $product_fl2){
                                        if ((string)$product_fl2->attributes()->val == 'Total'){
                                            $shipping = (string)$product_fl2;
                                        }
                                    }

                                }

                            }

                            if (!in_array($product_array['Product Name'], $exclude)){

                                $product = $zohoObj->getRecordById($auth_token['authtoken'],$product_array['Product Id'],'Products','Products(Product Code)');

                                if ($argv[3] != 'hardware'){
                                    if ((string)$product->result->Products->row[0]->FL[1] != ''){
                                        $product_array['Item Number'] = (string)$product->result->Products->row[0]->FL[1];
                                    }else{
                                        $product_array['Item Number'] = 'Hardware';
                                    }
                                }else{
                                    $product_array['Item Number'] = 'Hardware';
                                }


                                if ($product_array['Product Name'] != 'SHIPPING'){
                                    $zoho_products[] = $product_array;
                                }

                             }

                             if ($shipping){
                                 $zoho_products[0]['Freight'] = $shipping;
                                 unset($shipping);
                             }

                        }


                        $zoho_array['Product Details'] = $zoho_products;

                        unset($zoho_products);

                    }else{

                        $zoho_array[(string)$fl->attributes()->val] = (string)$fl;

                    }

                }

                $zoho_items[] = $zoho_array;

            }

        }
         *
         */

        /* Bilal Modifications */
        $zoho_items = $zohoObj->searchRecords_cron($lastModifiedTime, $exclude, $argv[3]);
        //         print_r($zoho_items);
        //        file_put_contents("./zohodata.txt", print_r($zoho_items,true));

        if (count($zoho_items) > 0) {

            if ($argv[3] == 'all' || $argv[3] == 'customers') {
                $custcsv = $searchObj->export_zoho_customers($zoho_items);
                //                print_r($custcsv);
                //file_put_contents($path_to_files.$lastModifiedTime."_zoho_customer.csv", $custcsv);
                file_put_contents($path_to_files . $lastModifiedTime . "file_1_3.csv", $custcsv);
                exec("scp {$path_to_files}{$lastModifiedTime}_zoho_customer.csv {$path_to_remote_files}", $output);
                //unlink("{$path_to_files}{$lastModifiedTime}_zoho_customer.csv");
                $export_log = array(
                    'file_path' =>  $path_to_files . $lastModifiedTime . "_zoho_customer.csv",
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      =>  $custcsv,
                    'function_called'   =>  'zoho_order_exports customers'
                );
            }
            if ($argv[3] == 'all' || $argv[3] == 'orders') {
                $ordercsv = $searchObj->export_zoho_orders($zoho_items);
                //file_put_contents($path_to_files.$lastModifiedTime."_zoho_orders.csv", $ordercsv);
                print_r($ordercsv);
                file_put_contents($path_to_files . $lastModifiedTime . "file_2_3.csv", $ordercsv);
                exec("scp {$path_to_files}{$lastModifiedTime}_zoho_orders.csv {$path_to_remote_files}", $output);
                //unlink("{$path_to_files}{$lastModifiedTime}_zoho_orders.csv");
                $export_log = array(
                    'file_path' =>  $path_to_files . $lastModifiedTime . "_zoho_orders.csv",
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'zoho_order_exports orders'
                );
            }
            if ($argv[3] == 'all' || $argv[3] == 'hardware') {
                $ordercsv = $searchObj->export_zoho_orders($zoho_items, true);
                //file_put_contents($path_to_files.$lastModifiedTime."_zoho_orders.csv", $ordercsv);
                file_put_contents($path_to_files . $lastModifiedTime . "file_4_3.csv", $ordercsv);
                exec("scp {$path_to_files}{$lastModifiedTime}_zoho_orders.csv {$path_to_remote_files}", $output);
                //unlink("{$path_to_files}{$lastModifiedTime}_zoho_orders.csv");
                $export_log = array(
                    'file_path' =>  $path_to_files . $lastModifiedTime . "_zoho_orders.csv",
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'zoho_order_exports hardware'
                );
            }
            if ($argv[3] == 'all' || $argv[3] == 'nopo') {
                $ordercsv = $searchObj->export_zoho_orders($zoho_items, false, true);
                //file_put_contents($path_to_files.$lastModifiedTime."_zoho_orders.csv", $ordercsv);
                file_put_contents($path_to_files . $lastModifiedTime . "file_3_3.csv", $ordercsv);
                exec("scp {$path_to_files}{$lastModifiedTime}_zoho_orders.csv {$path_to_remote_files}", $output);
                //unlink("{$path_to_files}{$lastModifiedTime}_zoho_orders.csv");
                $export_log = array(
                    'file_path' =>  $path_to_files . $lastModifiedTime . "_zoho_orders.csv",
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'zoho_order_exports hardware'
                );
            }
            if ($argv[3] == 'all' || $argv[3] == 'nopohardware') {
                $ordercsv = $searchObj->export_zoho_orders($zoho_items, true, true);
                file_put_contents($path_to_files . $lastModifiedTime . "file_5_3.csv", $ordercsv);
            }
        }

        if (!$export_log) {
            $export_log = array(
                'file_path' =>  $argv[3] . $lastModifiedTime,
                'transfer_result'   =>  'Nothing exported',
                'file_content'      =>  '',
                'function_called'   =>  'zoho_order_exports ' . $argv[3]
            );
        }

        $this->db_insert('export_log', $export_log);
    }

    function merge_exports($argv)
    {

        $output = '';

        if (!$argv[4]) {
            //$date = $this->format_date('db_date',time()-(60*60*24));
            //$prefix = date('m-d-Y',time()-(60*60*24));
            $date = $this->format_date('db_date', time());
            $prefix = date('m-d-Y', time());
        } else {
            $date = $argv[4];
            $prefix = date('m-d-Y',  strtotime($argv[4]));
        }

        $path_to_files = '/var/www/vhosts/macservice.com/logs/exports/';

        $path_to_remote_files = 'serveradmin@10.8.0.5:"/Users/serveradmin/Dropbox/Back\ End\ Export/Daily\ Files\ Inbound/"';

        $customer_header = file_get_contents($path_to_files . 'customer_header.txt');
        $order_header = file_get_contents($path_to_files . 'order_header.txt');

        if ($argv[3] == 'customers') {
            for ($i = 1; $i < 5; $i++) {
                if (file_get_contents($path_to_files . $date . 'file_1_' . $i . '.csv')) {
                    $file_1_array[] = file_get_contents($path_to_files . $date . 'file_1_' . $i . '.csv');
                    unlink($path_to_files . $date . 'file_1_' . $i . '.csv');
                }
            }

            if (count($file_1_array) > 0) {

                $file_1 = fopen($path_to_files . $prefix . '-customers.csv', "w");

                fwrite($file_1, $customer_header);

                foreach ($file_1_array as $file) {
                    fwrite($file_1, str_replace($customer_header, '', $file));
                }

                fclose($file_1);
                exec("scp -v {$path_to_files}{$prefix}-customers.csv {$path_to_remote_files}", $output);

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-customers.csv',
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      => file_get_contents($path_to_files . $prefix . '-customers.csv'),
                    'function_called'   =>  'mergeexports customers ' . $date
                );

                $this->db_insert('export_log', $export_log);

                unlink($path_to_files . $prefix . '-customers.csv');
            } else {

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-customers.csv',
                    'transfer_result'   =>  'Nothing exported',
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'mergeexports customers ' . $date
                );

                $this->db_insert('export_log', $export_log);
            }
        }

        if ($argv[3] == 'orders1') {
            for ($i = 1; $i < 5; $i++) {
                if (file_get_contents($path_to_files . $date . 'file_2_' . $i . '.csv')) {
                    $file_2_array[] = file_get_contents($path_to_files . $date . 'file_2_' . $i . '.csv');
                    unlink($path_to_files . $date . 'file_2_' . $i . '.csv');
                }
            }

            if (count($file_2_array) > 0) {

                $file_2 = fopen($path_to_files . $prefix . '-orders1.csv', "w");

                fwrite($file_2, $order_header);

                foreach ($file_2_array as $file) {
                    fwrite($file_2, str_replace($order_header, '', $file));
                }

                fclose($file_2);
                exec("scp -v {$path_to_files}{$prefix}-orders1.csv {$path_to_remote_files}");

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-orders1.csv',
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      => file_get_contents($path_to_files . $prefix . '-orders1.csv'),
                    'function_called'   =>  'mergeexports orders1 ' . $date
                );

                $this->db_insert('export_log', $export_log);

                unlink($path_to_files . $prefix . '-orders1.csv');
            } else {

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-customers.csv',
                    'transfer_result'   =>  'Nothing exported',
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'mergeexports orders1 ' . $date
                );

                $this->db_insert('export_log', $export_log);
            }
        }

        if ($argv[3] == 'orders2') {
            for ($i = 1; $i < 5; $i++) {
                if (file_get_contents($path_to_files . $date . 'file_3_' . $i . '.csv')) {
                    $file_3_array[] = file_get_contents($path_to_files . $date . 'file_3_' . $i . '.csv');
                    unlink($path_to_files . $date . 'file_3_' . $i . '.csv');
                }
            }

            if (count($file_3_array) > 0) {

                $file_3 = fopen($path_to_files . $prefix . '-orders2.csv', "w");

                fwrite($file_3, $order_header);

                foreach ($file_3_array as $file) {
                    fwrite($file_3, str_replace($order_header, '', $file));
                }

                fclose($file_3);
                exec("scp -v {$path_to_files}{$prefix}-orders2.csv {$path_to_remote_files}");

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-orders2.csv',
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      => file_get_contents($path_to_files . $prefix . '-orders2.csv'),
                    'function_called'   =>  'mergeexports orders2 ' . $date
                );

                $this->db_insert('export_log', $export_log);

                unlink($path_to_files . $prefix . '-orders2.csv');
            } else {

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-customers.csv',
                    'transfer_result'   =>  'Nothing exported',
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'mergeexports orders2 ' . $date
                );

                $this->db_insert('export_log', $export_log);
            }
        }

        if ($argv[3] == 'orders3') {
            for ($i = 1; $i < 5; $i++) {
                if (file_get_contents($path_to_files . $date . 'file_4_' . $i . '.csv')) {
                    $file_4_array[] = file_get_contents($path_to_files . $date . 'file_4_' . $i . '.csv');
                    unlink($path_to_files . $date . 'file_4_' . $i . '.csv');
                }
            }

            if (count($file_4_array) > 0) {

                $file_4 = fopen($path_to_files . $prefix . '-orders3.csv', "w");

                fwrite($file_4, $order_header);

                foreach ($file_4_array as $file) {
                    fwrite($file_4, str_replace($order_header, '', $file));
                }

                fclose($file_4);
                exec("scp -v {$path_to_files}{$prefix}-orders3.csv {$path_to_remote_files}");

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-orders3.csv',
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      => file_get_contents($path_to_files . $prefix . '-orders3.csv'),
                    'function_called'   =>  'mergeexports orders3 ' . $date
                );

                $this->db_insert('export_log', $export_log);

                unlink($path_to_files . $prefix . '-orders3.csv');
            } else {

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-orders3.csv',
                    'transfer_result'   =>  'Nothing exported',
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'mergeexports orders3 ' . $date
                );

                $this->db_insert('export_log', $export_log);
            }
        }


        if ($argv[3] == 'orders4') {
            for ($i = 1; $i < 5; $i++) {
                if (file_get_contents($path_to_files . $date . 'file_5_' . $i . '.csv')) {
                    $file_5_array[] = file_get_contents($path_to_files . $date . 'file_5_' . $i . '.csv');
                    unlink($path_to_files . $date . 'file_5_' . $i . '.csv');
                }
            }

            if (count($file_5_array) > 0) {

                $file_5 = fopen($path_to_files . $prefix . '-orders4.csv', "w");

                fwrite($file_5, $order_header);

                foreach ($file_5_array as $file) {
                    fwrite($file_5, str_replace($order_header, '', $file));
                }

                fclose($file_5);
                exec("scp -v {$path_to_files}{$prefix}-orders4.csv {$path_to_remote_files}");

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-orders4.csv',
                    'transfer_result'   =>  implode(' ', $output),
                    'file_content'      => file_get_contents($path_to_files . $prefix . '-orders4.csv'),
                    'function_called'   =>  'mergeexports orders4 ' . $date
                );

                $this->db_insert('export_log', $export_log);

                unlink($path_to_files . $prefix . '-orders4.csv');
            } else {

                $export_log = array(
                    'file_path' =>  $path_to_files . $prefix . '-customers.csv',
                    'transfer_result'   =>  'Nothing exported',
                    'file_content'      =>  $ordercsv,
                    'function_called'   =>  'mergeexports orders4 ' . $date
                );

                $this->db_insert('export_log', $export_log);
            }
        }
    }

    function queueDailyBackup($argv)
    {
        $forceRebase = false;
        $verbose = false;
        if (in_array('forcerebase', $argv)) {
            echo "Forcing rebase\n";
            $forceRebase = true;
        }
        if (in_array('verbose', $argv)) {
            $verbose = true;
        }

        $currentDateTime = new DateTime('now', new DateTimeZone('America/Los_Angeles'));

        $ymdStamp = $currentDateTime->format('Ymd');

        $yearMonthStamp = $currentDateTime->format('Ym');
        $dayStamp = $currentDateTime->format('d');
        $todayYmd = $currentDateTime->format('Y-m-d');

        // Set up the path
        $localPath = "/var/mariadb/backup/$yearMonthStamp/$dayStamp";

        // echo "Datetime data:\n\tCurrent date time: $todayYmd\n\tYear Month stamp: $yearMonthStamp\n\tCurrent day stamp: $dayStamp\n";

        $cronCommands = array();
        $commandsAsArray = array();

        // Prepare folder for new month backup
        $mkdirCommand = new stdClass;
        $mkdirCommand->command = "mkdir -p /var/mariadb/backup/$yearMonthStamp";
        $mkdirCommand->delay = 5;

        array_push($cronCommands, $mkdirCommand);
        array_push($commandsAsArray, $mkdirCommand->command);

        // Perform backup
        $backupCommand = new stdClass;
        $backupCommand->command = "mariabackup --backup    --target-dir=/var/mariadb/backup/$yearMonthStamp/$dayStamp    --user=mariabackup --password='W)Qp7^%P?~_ZrJa^'";
        $backupCommand->delay = 30;
        array_push($cronCommands, $backupCommand);
        array_push($commandsAsArray, $backupCommand->command);

        // Change directory pointer to current month folder
        $cdCommand = new stdClass;
        $cdCommand->command = "cd /var/mariadb/backup/$yearMonthStamp";
        $cdCommand->delay = 5;
        array_push($cronCommands, $cdCommand);
        array_push($commandsAsArray, $cdCommand->command);


        // Compress backup
        $compressCommand = new stdClass;
        $compressCommand->command = "tar -zcf $ymdStamp.tgz $dayStamp/ && cd ..";
        $compressCommand->delay = 30;
        array_push($cronCommands, $compressCommand);
        array_push($commandsAsArray, $compressCommand->command);

        // Dropbox transfer command
        $dropboxCommand = new stdClass;
        $dropboxCommand->command = "php56 /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com uploaddailybackup $ymdStamp";
        $dropboxCommand->delay = 30;
        array_push($cronCommands, $dropboxCommand);
        array_push($commandsAsArray, $dropboxCommand->command);

        // Delete backup folder
        $deleteCommand = new stdClass;
        $deleteCommand->command = "rm -rf /var/mariadb/backup/$yearMonthStamp/";
        $deleteCommand->delay = 10;
        array_push($cronCommands, $deleteCommand);
        array_push($commandsAsArray, $deleteCommand->command);

        $joinedString = implode(' && ', $commandsAsArray);
        if ($verbose) {
            echo "\nExecuting command string:\t\n$joinedString\n";
        }
        $output = array();
        $resultCode = 0;
        exec($joinedString, $output, $resultCode);
        if ($verbose) {
            echo "\nResult code: $resultCode\nOutput:\n";
            print_r($output);
        }
        exit;

        // Iterate over commands and insert them into cron queue
        // foreach ($cronCommands as $cronCommand) {
        // $command = $cronCommand->command;
        // $delay = $cronCommand->delay;
        // echo "\t$command\n";
        // $command = mysql_real_escape_string($command);
        // $sql = "INSERT INTO cron_queue(`cron_queue_command`, `delay`) VALUES ('$command', '$delay');";
        // }
        // $cronQueueCommand = mysql_real_escape_string($cronQueueCommand);
        // exit;

        // $cronQueueCommand = mysql_real_escape_string("php56 /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com imagingcompleteemail $orderId");
        // $sql = "INSERT INTO cron_queue(`cron_queue_command`, `delay`) VALUES ('$cronQueueCommand', '10');";
        // return $this->db_query($sql, 'insert');

    }

    function uploadDailyBackup($argv)
    {
        // print_r($argv);
        $verbose = false;
        if (in_array('verbose', $argv)) {
            $verbose = true;
        }
        $filename = ($argv[3] . ".tgz");
        require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
        DropboxAPIController::uploadDailyBackup($filename, $verbose);
    }

    function email_error_log()
    {

        if (file_exists(LABEL_TEMP_DIR . 'error.log')) {

            $this->send_email(ERROR_LOG_EMAIL, ERROR_LOG_EMAIL, 'Error Log', '', 'text/html', array(LABEL_TEMP_DIR . 'error.log'));

            unlink(LABEL_TEMP_DIR . 'error.log');
        }
    }

    function seven_days_until_payment_due_reminder_email()
    {
        $query =
            "SELECT poo.order_id
				,poo.order_number
				,poa.account_name
				,poo.notes
				,poo.date_received
				,(SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus NOT IN('Refurb - Imaged', 'Void'))/(SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other)) AS progress
				,DATE_ADD(poo.`date_received`, INTERVAL poo.`payment_term` DAY) AS due_date
				,poo.payment_term
				,poo.`payment_sent_date`
				,(CASE WHEN DATE_ADD(poo.`date_received`, INTERVAL poo.`payment_term` - 7 DAY) = CURDATE() THEN TRUE ELSE FALSE END) AS due_in_seven_days
			FROM po_orders poo
			LEFT JOIN po_accounts poa ON poo.account_id = poa.account_id
			LEFT JOIN po_received por ON por.order_id = poo.order_id
			WHERE
				poo.date_received > '2020-02-01'
				AND poo.payment_sent_date IS NULL
			GROUP BY poo.order_id
			ORDER BY due_date ASC;";


        $data = $this->db_query($query, 'select-multiple', false);
        $due_in_seven_days = array();
        $pastDue = array();
        $upcoming = array();
        $table_header = '
			<table>
				<thead>
					<tr>
						<th>Order Number</th>
						<th>Date Received</th>
						<th>Payment Term</th>
						<th>Due Date</th>
						<th>Progress</th>
					</tr>
				</thead>
				<tbody>
				';
        foreach ($data as $datum) {
            $today = new DateTime('now', new DateTimeZone('UTC'));
            $dueDate = new DateTime($datum['due_date'], new DateTimeZone('UTC'));
            if ($datum['due_in_seven_days'] == '1') {
                array_push($due_in_seven_days, $datum);
            }
            if ($today > $dueDate) {
                array_push($pastDue, $datum);
            } else {
                if (count($upcoming) < 5) {
                    array_push($upcoming, $datum);
                }
            }
        }
        $pastDueTable = "<h2>Past Due</h2>$table_header";
        foreach ($pastDue as $datum) {
            $pastDueTable .= '<tr>';
            $pastDueTable .= "<td><a href='https://macservice.com/admin_controller.php?m=bb_detail&order_id={$datum['order_id']}' target='_blank'>{$datum['order_number']} - {$datum['account_name']}</a></td>";
            $pastDueTable .= '<td>' . $datum['date_received'] . '</td>';
            $pastDueTable .= '<td>' . $datum['payment_term'] . ' days</td>';
            $pastDueTable .= '<td>' . $datum['due_date'] . '</td>';
            $pastDueTable .= '<td>' . strval((float)$datum['progress'] * 100) . '%</td>';
            $pastDueTable .= '</tr>';
        }
        $pastDueTable .= '</tbody></table>';
        $upcomingTable = "<h2>Upcoming</h2>$table_header";
        foreach ($upcoming as $datum) {
            $upcomingTable .= '<tr>';
            $upcomingTable .= "<td><a href='https://macservice.com/admin_controller.php?m=bb_detail&order_id={$datum['order_id']}' target='_blank'>{$datum['order_number']} - {$datum['account_name']}</a></td>";
            $upcomingTable .= '<td>' . $datum['date_received'] . '</td>';
            $upcomingTable .= '<td>' . $datum['payment_term'] . ' days</td>';
            $upcomingTable .= '<td>' . $datum['due_date'] . '</td>';
            $upcomingTable .= '<td>' . strval((float)$datum['progress'] * 100) . '%</td>';
            $upcomingTable .= '</tr>';
        }
        $upcomingTable .= '</tbody></table>';
        if (count($due_in_seven_days) > 0) {
            foreach ($due_in_seven_days as $datum) {
                $subject = "Reminder: 7 Days Remaining for {$datum['order_number']} - {$datum['account_name']} NET{$datum['payment_term']} Terms";
                $reminder = "<h2>Good morning.</h2><h3>{$datum['order_number']} - {$datum['account_name']} is due in seven days on {$datum['due_date']} and is {$strval((float)$datum['progress'] * 100)}% complete.</h3><hr style='margin: 40px 0;'/>";
                $body = $reminder . $pastDueTable . $upcomingTable;
                $this->send_email('Tim McNiff <t.mcniff@techtoschool.com>', ORDERS_FROM, $subject, $body, 'text/html');
                $this->send_email('Jason Melero <j.melero@techtoschool.com>', ORDERS_FROM, $subject, $body, 'text/html');
            }
        }
    }
}

function ipad_audit()
{

    global $groundcontrolObj, $adminObj, $sourceplusArray, $pigArray, $orderObj;

    $launchpads = $groundcontrolObj->launchpadsFindAll();

    foreach ($launchpads as $launchpad) {

        $uniqueId = $launchpad->uniqueId;

        $devices = $groundcontrolObj->launchpadsFind($uniqueId);

        foreach ($devices[0]->devices as $device) {

            $serialNumber = $device->serial;

            if (strlen($serialNumber) < 13) {
                $configCode = substr($serialNumber, 8);
            } else {
                $configCode = substr($serialNumber, 9);
            }

            $sql = 'select mon.order_number
                    from machine_order_number mon
                    left join product_model pm on pm.order_number_id = mon.order_number_id
                    where pm.configCode = "' . $configCode . '"';

            $machine_info = $adminObj->db_query($sql, 'select-single');

            $data['order_number'] = $machine_info['order_number'];

            $order = $adminObj->db_select_single('ds_orders', 'serialNumber, oNum', array('serialNumber' => $data['serialNumber']), ' AND oNum LIKE "SP%"');

            if ($order['serialNumber'] == $serialNumber) {
                break;
            }

            if ($device->supervisedByHost == 'true') {
                $data['activation_lock'] = '1';
            }

            if ($device->appleDEPStatus == 'true') {
                $data['mdm_lock'] = '1';
            }

            $imaging_control = $adminObj->db_select_single('imaging_control', '*', array('groundctl_uniqueid' => $uniqueId));

            $data['poNumber'] = $imaging_control['groundctl_po_number'];

            $oNum = $adminObj->parse_audit_response($data, false, true);

            $log = 'Imaged with OS ' . $device->os . ', machine ' . $imaging_control['machine_id'] . ', port N/A';

            if ($data['locked'] == 'A') {
                $log .= ', Activation Lock';
            }

            if ($data['locked'] == 'M') {
                $log .= ', MDM Lock';
            }

            $orderObj->insert_log($oNum, '', $log);

            if (in_array((int)$data['machine_id'], $sourceplusArray)) {
                $adminObj->print_ipad_label($data, ZEBRA_REFURB2_PRINTER);
            } elseif (in_array((int)$data['machine_id'], $pigArray)) {
                $adminObj->print_ipad_label($data, ZEBRA_PIG_PRINTER);
            } else {
                $adminObj->print_ipad_label($data, ZEBRA_BEAST_PRINTER);
            }
        }
    }
}
