<?php

class Cart extends Database {
    # ADD TO CART

    function add($key, $add_pID = 6, $add_qty = 1) {
        global $diagnostic_pids;
        if ($add_qty < 1) {
            $add_qty = 1;
        }
        $this->insert($key, $add_pID, $add_qty);
        if (!in_array($add_pID, $diagnostic_pids)) {
            $this->insert($key, $diagnostic_pids[0], 1);
        }
    }

    # CHECKS FOR CART CHANGES - RETURNS BOOL

    function check_changes($cSession, $pID, $pQty, $pPrice = false, $oNum = '') {
        $cart_changes = false;
        $cart = $this->get_data($cSession);
        for ($j = 0; $j < sizeof($pQty); $j++) {

            # MAKE SURE VALID POST
            if ($pID[$j]) {

                # PRICE CHANGE
                if ($pPrice) {
                    if ($cart[$j]['pPrice'] != $pPrice[$j] && $cart[$j]['pID'] == $pID[$j]) {
                        $cart_changes = true;
                        if ($oNum) {
                            $this->db_update(
                                    'ds_carts', 'oNum', $oNum, array('pPrice' => $pPrice[$j]), 'pID', $pID[$j]
                            );
                        } else {
                            $this->db_update(
                                    'ds_carts', 'cSession', $cSession, array('pPrice' => $pPrice[$j]), 'pID', $pID[$j]
                            );
                        }
                    }
                }

                # QUANTITY CHANGE
                if ($cart[$j]['pQty'] != $pQty[$j] && $cart[$j]['pID'] == $pID[$j]) {
                    $cart_changes = true;
                    if (!$this->set_quantity($cSession, $pID[$j], $pQty[$j])) {
                        $this->error_page('Unable to update cart item quantity for cart item: ' . $pID[$j]);
                    }
                }

                # ADD NEW CART ITEM
                if (!$cart[$j]['pQty'] && $pQty[$j]) {
                    $cart_changes = true;
                    if (!$this->insert($cSession, $pID[$j], $pQty[$j], $oNum)) {
                        $this->error_page('Error adding cart item: ' . $pID[$j]);
                    }
                }
            }
        }
        return $cart_changes;
    }

    # DELETES CART

    function delete($cSession) {
        $this->db_delete('ds_carts', 'cSession', $cSession);
    }

    # EMAILS CART

    function email_cart($key, $submitted) {
        global $orderObj;
        if ($this->get_data($key)) {
            $submitted['cSession'] = $key;
            $submitted = array_merge($submitted, $this->get_pricing($key));
            if ($this->send_email(
                            $submitted['cShipEmail'], $submitted['cEmail']
                            , $this->parse(CART_A_FRIEND_SUBJECT, array('SITE_NAME_EMAIL' => SITE_NAME))
                            , $orderObj->parse_order(CART_A_FRIEND, $submitted, array('MESSAGE' => $submitted['comments']), 'preview')
                    )
            ) {
                return true;
            }
        }
        return false;
    }

    # GETS CART TEMPLATE DATA - RETURNS ARRAY

    function get_cart_template_data($data, $step, $pricing) {
        if (!$data) {
            return false;
        }
        $pids = array();
        $num_items = 0;
        $cart_update_links = '';
        $within = '';
        foreach ($data as $row) {
            $within .= CART_VIEW_ITEM;
            $quantity_field = $row['pQty'];
            if ($step == 'cart') {
                $quantity_field = '<input type="hidden" name="productID[]" value="' . $row['pID'] . '" />'
                        . '<input type="text" size="2" name="quantity[]" value="' . $row['pQty'] . '" />';
                $cart_update_links = CART_UPDATE_LINKS;
            }
            $row['pPrice'] = number_format($row['pPrice'] * $row['pQty'], 2);
            $parse = array(
                'CART_ITEM_QTY' => $quantity_field
                , 'CART_ITEM_NAME' => $row['pNum']
                , 'CART_ITEM_DESC' => $row['pName']
                , 'CART_ITEM_PRICE' => $row['pPrice']
            );
            $within = $this->parse($within, $parse);
            $pids[] = $row['pID'];
            $num_items += $row['pQty'];
        }
        if (!in_array($step, array('cart', 'preview'))) {
            $parse = array(
                'PRICING' => CART_VIEW_PRICING
                , 'TAX' => number_format($pricing['cTax'], 2)
                , 'SHIPPING' => number_format($pricing['cShipping'], 2)
                , 'TOTAL' => number_format($pricing['cTotal'], 2)
                , 'DISCOUNT_TITLE' => ''
                , 'DISCOUNT_AMT' => ''
            );
            if ($pricing['cDiscount'] > 0) {
                $parse['DISCOUNT_TITLE'] = 'Discount:<br />';
                $parse['DISCOUNT_AMT'] = '$' . number_format($pricing['cDiscount'], 2) . '<br />';
            }
        } else {
            $parse = array('PRICING' => '');
        }
        $parse2 = array(
            'ITEMS' => $within
            , 'UPDATE_LINKS' => $cart_update_links
            , 'SUB_TOTAL' => number_format($pricing['cSubTotal'], 2)
            , 'ITEM_COUNT' => $num_items
        );
        return array(array_merge($parse, $parse2), $pids);
    }

    # GET CROSS SELL ITEMS

    function get_cross_sell_items($pids) {
        if ($data = $this->db_select_multiple(
                'ds_products_cross_sell pcs'
                , 'itemID, pThumb, pThumbWidth, pThumbHeight'
                , array()
                , 'where pcs.pID in (' . implode(',', $pids) . ') and itemID not in (' . implode(',', $pids) . ') '
                . 'and pThumb != "" group by itemID order by pPrice desc limit 3 '
                , array('ds_products p on p.pID = pcs.itemID')
                )
        ) {
            return $data;
        }
        return false;
    }

    # GET CART ITEMS DATA

    function get_data($cSession) {
        if (!$cSession) {
            return false;
        }
        return $this->db_select_multiple(
                        'ds_carts'
                        , '*'
                        , array('cSession' => $cSession)
                        , 'or oNum = ' . $this->qualify_value($cSession) . ' order by pName'
        );
    }

    // get cart items in cart id order
    function get_data_by_id($cSession) {
        if (!$cSession) {
            return false;
        }
        return $this->db_select_multiple(
                        'ds_carts'
                        , '*'
                        , array('cSession' => $cSession)
                        , 'or oNum = ' . $this->qualify_value($cSession) . ' order by cID'
        );
    }

    # CALCULATE COUPON DISCOUNT BASED ON CART ITEMS - RETURNS DOLLAR

    function get_discount($cSession, $code, $customer) {
        $discount = 0;
        $subtotal = 0;

        # CHECK FOR COUPON CODE DISCOUNT AS APPLIES TO PRODUCT(S)
        if ($data = $this->get_data($cSession)) {
            foreach ($data as $row) {
                $subtotal += $row['pPrice'] * $row['pQty'];
                if ($code && $row['pPrice'] > 0) {
                    if ($row2 = $this->db_select_single(
                            'ds_coupons c'
                            , 'cpDiscount, cpFreeShip, pID'
                            , array('cpType' => 'Product', 'pID' => $row['pID'])
                            , 'and cpExpire > "' . $this->format_date('db_date') . '" '
                            . 'and cpUsageRemaining > 0 and cpCode like ' . $this->qualify_value($code)
                            , array('ds_coupon_products cp on c.cpID = cp.cpID')
                            )
                    ) {
                        if ($row2['cpFreeShip'] != '') {
                            $discount = 'FREE_SHIP';
                            break;
                        } else {
                            $disc = $row2['cpDiscount'];
                            if (stristr($disc, '%')) {
                                $disc = str_replace('%', '', $disc);
                                $disc = $row['pPrice'] * $row['pQty'] * ($disc / 100);
                            }
                            $discount += $disc;
                        }
                    }
                }
            }
        }

        # CHECK FOR CUSTOMER CARD PERCENTAGE DISCOUNT
        if ($customer['cWholesaleDiscount'] > 0) {
            $discount = $subtotal * ($customer['cWholesaleDiscount'] / 100);
        }
        return $discount;
    }

    # PARSES CART ITEM PRODUCT NAME SEEKING STATUS BASED DESCRIPTION

    function get_item_status_description($status, $cart) {
        global $cart_item_msgs;
        if ($cart_item_msgs[$status]) {
            foreach ($cart as $row) {
                $pName = explode(' ', ereg_replace("[^0-9a-z _-]", '', strtolower($row['pName'])));
                foreach ($pName as $word) {
                    if ($desc = $cart_item_msgs[$status][$word]) {
                        return $desc;
                    }
                }
            }
        }
        return false;
    }

    # GETS CATEGORIES FROM CART ID - RETURNS CATEGORY NAME

    function get_largest_physical_category($cSession, $is_order_num = false) {
        global $orderObj, $diagnostic_pids;
        $categories = array();
        if ($data = $this->get_data($cSession)) {
            if (sizeof($data) == 1 && in_array($data[0]['pID'], $diagnostic_pids)) {
                return LARGEST_PHYS_CATEGORY;
            }
            foreach ($data as $row) {
                if ($cats = $this->db_select_multiple(
                        'ds_categories c', 'catName', array('pID' => $row['pID'])
                        , '', array('ds_product_categories pc on c.catID = pc.catID')
                        )
                ) {
                    foreach ($cats as $cat) {
                        $categories[] = $cat['catName'];
                    }
                }
            }
            if (in_array(OTHER_PHYS_CATEGORY_1, $categories)) {
                return OTHER_PHYS_CATEGORY_1;
            }
            return LARGEST_PHYS_CATEGORY;
        }
        return LARGEST_PHYS_CATEGORY;
    }

    # CALCULATE PRICING - RETURNS ARRAY

    function get_pricing($cSession, $cString = '', $submitted = false) {
        global $custObj, $orderObj, $ship_methods;
        $customer = $custObj->get_data($cString);
        $category = $this->get_largest_physical_category($cSession);
        $subtotal = 0;
        $subtotal_nontax = 0;
        $discount = 0;
        if (is_array($submitted['cpCode'])) {
            $submitted['cpCode'] = $submitted['cpCode'][0];
        }
        if (is_array($submitted['cShipService'])) {
            $submitted['cShipService'] = $submitted['cShipService'][0];
        }

        # GET CART PRICING
        if ($data = $this->get_data($cSession)) {
            foreach ($data as $row) {
                if ($row['taxable'] == 'Y') {
                    $subtotal += $row['pPrice'] * $row['pQty'];
                } else {
                    $subtotal_nontax += $row['pPrice'] * $row['pQty'];
                }
            }
            if (!$submitted) {
                return array(
                    'cSubTotal' => round(($subtotal + $subtotal_nontax), 2)
                    , 'cDiscount' => 'TBD', 'cTax' => 'TBD', 'cShipping' => 'TBD', 'cTotal' => 'TBD'
                );
            }

            # CALC SHIPPING IF NOT OVER-RIDDEN
            if ($submitted['cShipping'] == '') {
                if ($cString == SQUARETRADE_CUST_ID) {
                    $shipping = $ship_methods[$submitted['cShipService']]['squaretrade_price'];
                } else {
                    $shipping = $ship_methods[$submitted['cShipService']][$category]['price'];
                }
            } else {
                $shipping = $submitted['cShipping'];
            }

            # CALC DISCOUNT IF NOT OVER-RIDDEN
            if ($submitted['cDiscount'] == '') {
                $discount = $this->get_discount($cSession, $submitted['cpCode'], $customer);
                if (!$discount && $submitted['cpCode']) {
                    $discount = $orderObj->check_discount_code($submitted['cpCode'], $subtotal + $subtotal_nontax);
                }
                if ($discount === 'FREE_SHIP') {
                    $discount = $shipping;
                }
            } else {
                $discount = $submitted['cDiscount'];
            }

            # CALC TAX
            $tax = $this->get_tax($submitted['cShipState'], ($subtotal - $discount), $customer);

            # OUTPUT
            return array(
                'cSubTotal' => round(($subtotal + $subtotal_nontax), 2)
                , 'cDiscount' => round($discount, 2)
                , 'cTax' => round($tax, 2)
                , 'cShipping' => round($shipping, 2)
                , 'cTotal' => round(($subtotal + $subtotal_nontax - $discount + $tax + $shipping), 2)
            );
        }
        return false;
    }

    # GETS PRODUCT DATA - RETURNS ARRAY

    function get_product($pID) {
        return $this->db_select_single('ds_products', '*', array('pID' => $pID));
    }

    # GETS PRODUCTS - RETURNS ARRAY

    function get_products_list($part_numbers_only = false,$machine_id = 0,$multiple = false) {
        
        $prefixes = array('922','923','661','076');
        
        $exclude_filter = '';
        $include_filter = '';
        
        foreach ($prefixes as $row){
            if ($exclude_filter == ''){
                $exclude_filter = 'pNum not like "'.$row.'-%"';
            }else{
                $exclude_filter .= ' and pNum not like "'.$row.'-%"';
            }
        }

        foreach ($prefixes as $row){
            if ($include_filter == ''){
                $include_filter = 'pNum like "'.$row.'-%"';
            }else{
                $include_filter .= ' or pNum like "'.$row.'-%"';
            }
        }
        
        if ($multiple){
            
            return $this->db_select_multiple(
                        'ds_products', 'pID, concat(pNum, " - ", pName)', array('pAvail' => 'Y'), ' and '.$exclude_filter.' order by pNum'
            );
        }
        if (!$part_numbers_only) {
            if ($machine_id == 0){
                return $this->db_select_multiple(
                            'ds_products', 'pID, concat(pNum, " - ", pName)', array('pAvail' => 'Y'), ' and '.$exclude_filter.' order by pNum'
                );
            }else{
                
                $sql = 'select dp.pID, concat(dp.pNum, " - ", dp.pName) pNum
                    from ds_products dp 
                    join machine_parts_map mp on dp.pID = mp.pID 
                    where (dp.pAvail = "Y") and (mp.machine_id = "'.$machine_id.'") and ('.$include_filter.')
                    union
                    select dp.pID, concat(dp.pNum, " - ", dp.pName) pNum
                    from ds_products dp 
                    where (dp.pAvail = "Y") and ('.$exclude_filter.')
                    order by pNum';
                return $this->db_query($sql, 'select-multiple');
            }
            
        } else {
            if ($machine_id == 0){
                return $this->db_select_multiple(
                                'ds_products', 'pID, pNum', array('pAvail' => 'Y'), ' and '.$exclude_filter.' and pNum is not null  and pNum <> "" order by pNum'
                );
            }else{
                $sql = 'select dp.pID, dp.pNum
                    from ds_products dp 
                    join machine_parts_map mp on dp.pID = mp.pID 
                    where (dp.pAvail = "Y") and (mp.machine_id = "'.$machine_id.'") and ('.$include_filter.')
                    union
                    select dp.pID, dp.pNum
                    from ds_products dp 
                    where (dp.pAvail = "Y") and ('.$exclude_filter.')
                    order by pNum';
                return $this->db_query($sql, 'select-multiple');
            }
        }
    }

    # CALCULATE TAX - RETURNS DOLLAR

    function get_tax($state, $subtotal_after_discount, $customer) {

        # CHECK FOR CUSTOMER CARD TAX EXEMPTION FLAG
        if ($customer['cTaxExempt'] == 'Y') {
            return 0;
        }

        # CALC TAX
        $tax = 0;
        if ($row = $this->db_select_single(
                'ds_tax_rates tr', 'rate', array('state_code' => $state), ''
                , array('ds_tax t on tr.ds_tax_id = t.ds_tax_id')
                )
        ) {
            $tax += ($row['rate'] / 100) * $subtotal_after_discount;
        }
        return $tax;
    }

    # ADD CART RECORD - RETURNS BOOL

    function insert($cSession, $pID, $pQty = 1, $oNum = '') {

        # CHECK FOR PRE-EXISTANCE
        if ($this->db_select_single(
                        'ds_carts', '*', array('pID' => $pID)
                        , 'and ((cSession = ' . $this->qualify_value($cSession) . ' and cSession != "") '
                        . 'or (oNum = ' . $this->qualify_value($oNum) . ' and oNum != "")) '
                )
        ) {
            return true;
        }

        # GET PRODUCT DATA FOR PID
        if ($product = $this->get_product($pID)) {

            # INSERT CART ITEM
            return $this->db_insert('ds_carts', array(
                        'pID' => $pID
                        , 'pQty' => $pQty
                        , 'cSession' => $cSession
                        , 'oNum' => $oNum
                        , 'taxable' => $product['taxable']
                        , 'pName' => $product['pName']
                        , 'pNum' => $product['pNum']
                        , 'pPrice' => $product['pPrice']
                            )
            );
        }
        return false;
    }

    # PARSES CART TEMPLATE - RETURNS HTML & CART PID LIST

    function parse_cart_template($data, $step, $pricing, $template = CART_VIEW_BODY) {
        list ($parse, $pids) = $this->get_cart_template_data($data, $step, $pricing);
        $output = $this->parse($template, $parse);
        return array($output, $pids);
    }

    # PARSES UPSELL TEMPLATE - RETURNS HTML

    function parse_upsell_template($cross_sellers) {
        $cross_html = '';
        if (!$cross_sellers) {
            return false;
        }
        foreach ($cross_sellers as $cross) {
            $parse = array(
                'ID' => $cross['itemID']
                , 'THUMB' => $cross['pThumb']
                , 'THUMB_W' => $cross['pThumbWidth']
                , 'THUMB_H' => $cross['pThumbHeight']
            );
            $cross_html .= $this->parse(CROSS_SELL_ITEM, $parse);
        }
        return $this->parse(CROSS_SELL, array('CROSS_SELLERS' => $cross_html));
    }

    # UPDATE CART ITEM QTY - RETURNS BOOL

    function set_quantity($cSessionOrOrderNum, $pID, $pQty) {
        global $diagnostic_pids;

        # DON"T TOUCH DIAGNOSTIC PIDS
        if (in_array($pID, $diagnostic_pids)) {
            return true;
        }

        # DELETE INSTEAD OF UPDATE WHEN QTY SET TO 0
        if ($pQty == 0) {
            $sql = '
				delete from ds_carts where pID = ' . $this->qualify_value($pID) . '
				and (
					cSession = ' . $this->qualify_value($cSessionOrOrderNum) . '
					or oNum = ' . $this->qualify_value($cSessionOrOrderNum) . '
				)
				limit 1
			';
            return $this->db_query($sql, 'delete');
        } else {
            $data = array('pQty' => ($pQty));
            if (!$this->db_update('ds_carts', 'cSession', $cSessionOrOrderNum, $data, 'pID', ($pID))) {
                return $this->db_update('ds_carts', 'oNum', $cSessionOrOrderNum, $data, 'pID', ($pID));
            } else {
                return true;
            }
        }
    }

    function empty_cart($cSessionOrOrderNum) {

        $sql = 'delete from ds_carts where (
                            cSession = ' . $this->qualify_value($cSessionOrOrderNum) . '
                            or oNum = ' . $this->qualify_value($cSessionOrOrderNum) . '
                    )
            ';
        return $this->db_query($sql, 'delete');
    }

    function zero_cart($cSessionOrOrderNum) {

        $sql = 'update ds_carts set pPrice = "0" where (
                            cSession = ' . $this->qualify_value($cSessionOrOrderNum) . '
                            or oNum = ' . $this->qualify_value($cSessionOrOrderNum) . '
                    )
            ';
        return $this->db_query($sql, 'delete');
    }

    # UPDATE MULTIPLE CARTS

    function update_multiple($cart_sessions, $problems, $pIDs, $pQtys, $pPrices) {
        for ($i = 0; $i < sizeof($cart_sessions); $i++) {
            if ($problems[$i]) {
                if ($this->check_changes($cart_sessions[$i], $pIDs[$i], $pQtys[$i], $pPrices[$i])) {
                    $output .= '<p>Saved cart changes.';
                }
                $this->insert($cart_sessions[$i], 6);
            }
        }
    }

    # SHOWS CART AND ORDER FORM

    function show($cSession, $customer, $submitted, $show_panel, $message = false, $cc_error = array()) {
        global $orderObj;
        if ($message) {
            $message = '<h3 class="error">* ' . $message . '</h3>';
        }

        # GET CART DATA
        if ($data = $this->get_data($cSession)) {

            # SHOW CART
            if ($pricing = $this->get_pricing($cSession, $customer)) {
                if (list($cart_html, $pids) = $this->parse_cart_template($data, 'cart', $pricing)) {
                    $upsell_html = $this->parse_upsell_template($this->get_cross_sell_items($pids));

                    # SHOW ORDER FORM
                    return $orderObj->parse_order_form(
                                    $cSession, $customer, $cart_html, $upsell_html, $submitted, $show_panel, $message, $cc_error
                    );
                } else {
                    $this->error_page(SITE_ERROR . ' :: show_cart :: ' . $cSession);
                }
            } else {
                $this->error_page(SITE_ERROR . ' :: cart_pricing :: ' . $cSession);
            }

            # CART IS EMPTY
        } else {
            return CART_EMPTY;
        }
    }

    # DISPLAYS CART ITEM FIELDS - RETURNS HTML

    function show_admin($cSession, $i = 0, $single = false, $multiple = false) {
        global $cartObj;
        
        $ds_orders = $this->db_select_single('ds_orders', 'machineType', array('oNum' => $cSession));
        
        if ($machine_lookup = $this->db_select_single('machine_lookup','machine_id' , array('machine_description' => $ds_orders['machineType']))){
            $machine_id = $machine_lookup['machine_id'];
        }else{
            $machine_id = 0;
        }
        
        $o = '<table>';
        if ($data = $cartObj->get_data($cSession)) {
            foreach ($data as $row) {
                $o .= '
					<tr>
						<td><input class="borderless" type="text" name="pQty[' . $i . '][]" size="2" value="' . $row['pQty'] . '" /></td>
						<td class="small">
							' . $row['pNum'] . '<br />' . $row['pName'] . '
							<input type="hidden" name="pName[' . $i . '][]" value="' . $row['pName'] . '" />
							<input type="hidden" name="pID[' . $i . '][]" value="' . $row['pID'] . '" />
						</td>
						<td class="small">$<input type="text" class="borderless" size="6" name="pPrice[' . $i . '][]" value="' . $row['pPrice'] . '" />/ea</td>
					</tr>
				';
            }
        }
        //deliver different html for multiple and single orders
        if ($single) {
            $o .= '
                                    <tr>
                                            <td><input class="borderless" type="text" name="pQty[' . $i . '][]" size="2" value="1" /></td>
                                            <td colspan="2">
                                                    <select name="pID[' . $i . '][]" style="width: 200px;">
                                                    <option value="">Add Item</option>
                                                    ' . $this->arrayToHtmlSelectOptions($this->get_products_list(false,$machine_id,$multiple)) . '
                                                    </select>
                                                    <input type="submit" name="submit_action" value="' . ADD_CART_BUTTON . '" />
                                            </td>
                                    </tr>
                            </table>
                    ';
        } else {
            //check how many add item drop downs to show
            if (count($data) > 1) {
                $numrows = 2;
            } else {
                $numrows = 3;
            }
            for ($j = 1; $j <= $numrows; $j++) {
                $o .= '
                                    <tr>
                                            <td><input class="borderless" type="text" name="pQty[' . $i . '][]" size="2" value="1" /></td>
                                            <td colspan="2">
                                                    <select name="pID[' . $i . '][]" style="width: 200px;">
                                                    <option value="">Add Item</option>
                                                    ' . $this->arrayToHtmlSelectOptions($this->get_products_list(false,$machine_id)) . '
                                                    </select>
                                            </td>
                                    </tr>';
            }
            $o .= '
                                    <tr>
                                            <td colspan="3" align="right">
                                                    <input type="submit" name="submit_action" value="' . ADD_CART_BUTTON . '" />
                                            </td>
                                    </tr>
                            </table>
                    ';
        }
        return $o;
    }

    # DISPLAYS CART ITEM FIELDS - RETURNS HTML

    function diag_parts($cSession) {
        global $cartObj;
        $i = 0;
        $o = '<table>';
        if ($data = $cartObj->get_data_by_id($cSession)) {
            foreach ($data as $row) {
                if ($row['pNum'] != 'Free Diagnostic') {
                    $o .= '
                                            <tr>
                                                    <td><input type="hidden" name="pQty[0][]" value="' . $row['pQty'] . '" /></td>
                                                    <td class="small">
                                                            ' . $row['pNum'] . '
                                                            <input type="hidden" name="pID[0][]" value="' . $row['pID'] . '" />
                                                            <input type="hidden" name="pName[0][]" value="' . $row['pName'] . '" />
                                                            <input type="hidden" name="pID[0][]" value="' . $row['pID'] . '" />
                                                            <input type="hidden" name="pPrice[0][]" value="' . $row['pPrice'] . '" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="borderless" style="width: 80px;" id="txtPartOrder' . $i . '" name="txtPartOrder' . $i . '" value="__txtPartOrder' . $i . '__" />
                                                    </td>
                                            </tr>
                                    ';
                    $i++;
                } else {
                    $o .= '
                                            <tr>
                                                    <td>
                                                        <input type="hidden" name="pQty[0][]" value="' . $row['pQty'] . '" /></td>
                                                    
                                                        <input type="hidden" name="pName[0][]" value="' . $row['pName'] . '" />
                                                        <input type="hidden" name="pID[0][]" value="' . $row['pID'] . '" />
                                                        <input type="hidden" name="pPrice[0][]" value="' . $row['pPrice'] . '" />
                                                    
                                                    </td>
                                            </tr>
                                    ';
                }
            }
        }
        //deliver different html for multiple and single orders
        //check how many add item drop downs to show
        if ($data) {
            $numrows = 6 - $i;
        } else {
            $numrows = 6;
        }
        for ($j = 1; $j <= $numrows; $j++) {
            $o .= '
                                <tr>
                                        <td><input type="hidden" name="pQty[0][]" size="2" value="1" /></td>
                                        <td>
                                                <select name="pID[0][]" style="width: 100px;">
                                                <option value="">Add Item</option>
                                                ' . $this->arrayToHtmlSelectOptions($this->get_products_list(true)) . '
                                                </select>
                                        </td>
                                        <td>
                                            <input type="text" class="borderless" style="width: 80px;" id="txtPartOrder' . $i . '" name="txtPartOrder' . $i . '" value="__txtPartOrder' . $i . '__" />
                                        </td>
                                </tr>';
            $i++;
        }
        $o .= '</table>';

        return $o;
    }

    //store temporary cart data
    function store_temp_cart($data) {

        //only store if email present and not from local ip address
        if ($data['cEmail'] != "" && $_SERVER['REMOTE_ADDR'] != LOCAL_IP) {

            //unset unwanted fields
            unset($data['action']);
            unset($data['ccNum']);
            unset($data['ccExpMonth']);
            unset($data['ccExpYear']);
            unset($data['CVV2']);
            unset($data['email']);

            $temp_cart = $this->db_select_single('temp_cart', 'count(temp_cart_id)', array('cEmail' => $data['cEmail']));

            //either add or update record
            if ($temp_cart[0] == 0) {
                $this->db_insert('temp_cart', $data);
            } else {
                $this->db_update('temp_cart', 'cEmail', $data['cEmail'], $data);
            }
        }
    }

    //delete from temp cart
    function delete_temp_cart($cEmail) {

        $this->db_delete('temp_cart', 'cEmail', $cEmail);
    }

}

?>
