<?php

class Admin extends Database {

	# ADMIN PANEL LOGIN SCREEN - OUTPUTS HTML
	function admin_login($data, $returnUrl) {
		$isQuery = ($_SERVER['QUERY_STRING']) ? true : false;
		if ($data['username']) {
			if ($data2 = $this->db_select_single(
					'ds_admins', 'aID,aString,aUser,aEmail,aPermType,aReports,aTimesheet,aAuditOnly,printer_id,large_printer_id,default_module_id', array('aUser' => $data['username'])
					, 'and aPass = encode(' . $this->qualify_value($data['password']) . ', "' . PASS_SALT . '") '
					. 'and (aOrders = "Y" OR aPermType = "S")'
				)
			) {
				setcookie('xdigiSHOPadmin', $data2['aString']);
				$_SESSION['xdigiSHOPadmin'] = $data2['aString'];
				$_SESSION['aID'] = $data2['aID'];
				$_SESSION['aUser'] = $data2['aUser'];
				$_SESSION['aEmail'] = $data2['aEmail'];
				$_SESSION['aPermType'] = $data2['aPermType'];
				$_SESSION['aPayflow'] = $data2['aReports'];
				$_SESSION['aAuditOnly'] = $data2['aAuditOnly'];
				$_SESSION['printer_id'] = $data2['printer_id'];
				$_SESSION['large_printer_id'] = $data2['large_printer_id'];
				$_SESSION['default_module_id'] = $data2['default_module_id'];
				//check if user is due to submit a timesheet
				if ($data2['aTimesheet'] == 'Y'){
					if ($pay_period = $this->db_select_single('ts_pay_period', 'period_id', array('period_end_date' => $this->format_date('db_date')))){
						if ($timesheet = $this->db_select_single('ts_timesheet', '*', array(), 'where timesheet_aid = "'.$data2['aID'].'" and period_id = "'.$pay_period['period_id'].'" and timesheet_submitted != "1"')){
							$_SESSION['timesheet_overdue'] = 'true';
						}else{
							$_SESSION['timesheet_overdue'] = 'false';
						}
					}else{
						$_SESSION['timesheet_overdue'] = 'false';
					}
				}else{
					$_SESSION['timesheet_overdue'] = 'false';
				}
				if ($isQuery) {
					$this->goToUrl($returnUrl);
				} else {
					$query = "SELECT `mod`.module_method FROM `module` AS `mod` LEFT JOIN `ds_admins` ON `mod`.module_id = ds_admins.default_module_id WHERE ds_admins.aID = {$data2['aID']};";
					$defaultPage = $this->db_query($query, 'select-single', true)['module_method'];
					if ($defaultPage) {
						$this->goToUrl(CONTROLLER . '?m=' . $defaultPage);
					} else {
						$this->goToUrl($returnUrl);
					}
				}
			}
		}
		echo $this->parse(LOGIN_TEMPLATE, array('BODY' => LOGIN_HTML));
		exit;
	}

	# ADMIN PANEL CREDENTIAL CHECK - RETURNS BOOL
	function check_admin_login() {
		/*if ($_COOKIE['xdigiSHOPadmin']) {
			return $this->db_select_single(
				'ds_admins'
				, 'aID'
				, array('aString' => $_COOKIE['xdigiSHOPadmin'])
				, 'and (aOrders = "Y" OR aPermType = "S") '
			);
		}*/
			if ($_SESSION['xdigiSHOPadmin']) {
			return $this->db_select_single(
				'ds_admins'
				, 'aID'
				, array('aString' => $_COOKIE['xdigiSHOPadmin'])
				, 'and (aOrders = "Y" OR aPermType = "S") '
			);
		}
		return false;
	}

	function admin_logout(){
		//unset($_COOKIE['xdigiSHOPadmin']);
		setcookie('xdigiSHOPadmin', '', time() - 3600);
		session_start();
		session_unset();
	}

	# CUSTOMER DETAIL PAGE LOGIC
	function customer_detail($cString, $action, $create, $submitted, $dd_data, $history) {
		global $custObj, $orderObj, $cartObj;
		$output = '';
		$data = array();
		if (!$cString) {
			$this->error_page(MISSING_URL_DATA);
		}
		if ($cString != 'NEW-CUSTOMER') {
			if (
				!in_array($action, array(CUST_NEW_MS_INV_BUTTON, CUST_NEW_PC_INV_BUTTON))
				&& !$data = $custObj->get_data($cString)
			) {
				$this->error_page(MISSING_HISTORY);
			}
			$output = '<p><strong>' . strtoupper($data['cBillFname'] . ' ' . $data['cBillLname']) . '</strong></p>';
		}

		# SUB 1: SAVE CUSTOMER
		if ($action) {

			# HANDLE NEW CUSTOMER SAVE
			if ($cString == 'NEW-CUSTOMER' && $submitted['cEmail']) {
				$new_sess = $this->createUniqueKey();
				if ($custObj->insert($new_sess, $submitted)) {
					$cString = $new_sess;
					$data = $submitted;
					$output .= '<p>' . EMAIL_SENT;
				} else {
					$output .= '<p class="error">' . PASSWORD_CONFLICT;
				}

			# HANDLE EXISTING CUSTOMER SAVE/UPDATE
			} else {
				list($data, $output) = $custObj->update($data, $output, $submitted);
			}

			# SUB 2: NEW INVOICE
			if ($action == CUST_NEW_MS_INV_BUTTON) {
				$orderObj->create_from_cust($submitted, $cString, SHIP_ROUND_GROUND, 'MS');
			} else if ($action == CUST_NEW_PC_INV_BUTTON) {
				$orderObj->create_from_cust($submitted, $cString, SHIP_ROUND_GROUND, 'PC');

			# SUB 2: EMAIL PASSWORD
			} else if ($action == CUST_PASSW_BUTTON) {
				if ($custObj->email_password($submitted['cEmail'])) {
					$output .= '<p>' . EMAIL_SENT;
				}

			# SUB 2: UPDATE CART AND ADD MULTI ORDERS
			} else if (in_array(
					$action, array(ADD_CART_BUTTON, CUST_MS_MULTI_BUTTON, CUST_PC_MULTI_BUTTON))
			) {

				# UPDATE MULTI CART
				$create = sizeof($submitted['cart_sess']);
				$cartObj->update_multiple(
					$submitted['cart_sess'], $submitted['problem'], $submitted['pID'], $submitted['pQty'], $submitted['pPrice']
				);

				# PROCESS MULTI ORDER SUBMISSION
				$submitted['payment_method'] = 'Purchase Order';
				$submitted['ccType'] = 'Purchase Order';
				$submitted = array_merge($custObj->get_most_recent_cc($cString), $submitted);
				if ($action == CUST_MS_MULTI_BUTTON) {
					list($oNums, $body, $output) = $orderObj->create_multiple(
						$cString, $submitted, $submitted['cart_sess'], 'MS'
					);
				} else if ($action == CUST_PC_MULTI_BUTTON) {
					list($oNums, $body, $output) = $orderObj->create_multiple(
						$cString, $submitted, $submitted['cart_sess'], 'PC'
					);
				}
			}

		# NEW CUSTOMER SIGNAL
		} else if ($cString == 'NEW-CUSTOMER') {
			$output .= NEW_CUSTOMER;
		}

		# GET CUSTOMER ORDER HISTORY
		$create_orders = '';
		if ($cString != 'NEW-CUSTOMER') {
			$create_orders = '<a href="javascript:void(0);">CREATE MULTIPLE ORDERS</a>';
			$output .= $custObj->parse_history('admin', $cString, $history);
		}

		# OUTPUT CUSTOMER DETAIL TEMPLATE
		echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ADMIN_SEARCH_BODY, $dd_data)
				. $output . $this->parse_customer_detail(
					$create_orders, $data, $cString, $submitted['cart_sess'], $submitted['problem']
					, $submitted['cpCode'], $submitted['cShipService'], $create
				)
			)
		);
	}

	# OPEN DB TABLE EDITOR FOR FEEDBACK TABLE
	function edit_feedback() {
		$this->db_tableedit('nl_feedback', 'stamp', 'fbID', array(
				'stamp' => 'Time', 'cString' => 'Customer', 'public' => 'Viewable', 'content' => 'Comments'
			), array('stamp', 'cString'), array('fbID')
		);
	}

	# OPEN DB TABLE EDITOR FOR FEEDBACK TABLE
	function edit_skus() {
		$this->db_tableedit('nl_sku_mappings', 'ds_sku', 'id', array(
				'ds_sku' => 'Machine Type', 'myob_sku' => 'MYOB ID'
			), array(), array('id')
		);
	}

	#INSERT INTO DATABASE TABLE PRODUCTS
	function add_product($data=array()){

		return $this->db_insert('ds_products',$data);
	}

	# OPEN DB TABLE EDITOR FOR FEEDBACK TABLE
	function edit_clients() {
		$this->db_tableedit('nl_clients', 'clientID', 'clientID', array(
				'clientID' => 'Account #', 'folders' => 'Backup Folders', 'cString' => 'Customer ID'
				, 'rSyncU' => 'RSync User', 'rSyncP' => 'RSync Pass', 'rSyncS' => 'RSync Serv'
			)
		);
	}

	# BUILDS FORM INPUTS - RETURNS HTML
	function get_fields($table, $data, $split=1, $only_fields=false) {
		global $orders_field_titles, $db_field_textareas, $non_edit_fields, $drop_down_fields,
			$checkbox_fields, $phone_fields, $date_fields, $order_statii;
		list($fields, $field_sizes) = $this->get_table_fields($table);
		if ($only_fields) {
			$fields = $only_fields;
		}
		$inputs = array();
		foreach ($fields as $field_db) {
			$field_title = $orders_field_titles[$field_db];

			# ONLY ALLOWED FIELDS
			if (in_array($field_db, $fields)) {

				# DETERMINE TEXTAREA
				if (in_array($field_db, $db_field_textareas)) {
					$inputs[$field_title] .= '<td colspan="2">' . $field_title . '<br /><textarea name="' . $field_db . '" cols="50" rows="5">' . $data[$field_db] . '</textarea></td>';
					continue;
				}

				# HANDLE MULTI-LINERS
				if (is_array($field_title)) {
					$inputs[$field_db] = '<td nowrap="nowrap">' . $field_db . '</td><td>';
					foreach ($field_title as $field_element => $size) {
						$maxlength = $field_sizes[$field_element];
						if (!$size) {
							$size = 30;
						}
						$inputs[$field_db] .= '<input class="borderless" type="text" name="' . $field_element . '" value="' . $data[$field_element] . '" maxlength="' . $maxlength . '" size="' . $size . '" />';
					}
					$inputs[$field_db] .= '</td>';
					continue;
				}

				# TITLE CELL
				$inputs[$field_title] = '<td nowrap="nowrap">' . $field_title . '</td>';

				# EXCLUDE LIST - SHOW VALUE ONLY
				if (in_array($field_db, $non_edit_fields)) {
					if (in_array($field_db, $date_fields)) {
						if (!in_array($data[$field_db], array('0000-00-00', '', 0))) {
							$data[$field_db] = $this->format_date('templ_date', $data[$field_db]);
						} else {
							$data[$field_db] = '';
						}
						$inputs[$field_title] .= '<td class="small"><strong>' . $data[$field_db] . '</strong></td>';
					} else if (is_numeric($data[$field_db])) {
						$data[$field_db] = number_format($data[$field_db], 2);
						$inputs[$field_title] .= '<td class="small">$ <strong>' . $data[$field_db] . '</strong></td>';
					}
				} else {

					# ORDER STATUS
					if ($field_db == 'cStatus') {
						$options = array();
						foreach (array_keys($order_statii) as $value) {
							$options[$value] = $value;
						}
						$inputs[$field_title] .= '<td><select class="borderless" name="' . $field_db . '" style="width: 160px;">'
							. $this->arrayToHtmlSelectOptions($options, true, $data[$field_db], array(), '--blank--') . '</select></td>';

					# ADMINS
					} else if (in_array($field_db, array('admin1', 'admin2'))) {
						$values = $this->db_select_multiple('ds_admins', 'aUser');
						$options = array();
						foreach ($values as $value) {
							$options[$value[0]] = $value[0];
						}
						$inputs[$field_title] .= '<td><select class="borderless" name="' . $field_db . '" style="width: 160px;">'
							. $this->arrayToHtmlSelectOptions($options, true, $data[$field_db]) . '</select></td>';

					# DETERMINE IF DROP DOWN
					} else if (in_array($field_db, $drop_down_fields)) {
						$values = $this->db_select_multiple(
							$table, 'distinct ' . $field_db, array(), 'where ' . $field_db . ' not in ("", " ") order by ' . $field_db
						);
						$options = array();
						foreach ($values as $value) {
							$options[$value[0]] = $value[0];
						}
						$inputs[$field_title] .= '<td><select class="borderless" name="' . $field_db . '" style="width: 160px;">'
							. $this->arrayToHtmlSelectOptions($options, true, $data[$field_db]) . '</select></td>';

					# DETERMINE IF CHECKBOX
					} else if (in_array($field_db, $checkbox_fields)) {
						$isChecked = '';
						if ($data[$field_db] == 'Y') {
							$isChecked = ' checked';
						}
						$inputs[$field_title] .= '<td><input type="checkbox" name="' . $field_db . '" value="Y"' . $isChecked . ' /></td>';

					# TEXT INPUT FIELD
					} else {

						# CALC SIZES
						$size = 30;
						$maxlength = $field_sizes[$field_db];
						if ($maxlength < 30) {
							$size = $maxlength;
						}

						# HANDLE CC NUM
						if ($field_db == 'ccNum') {
							$inputs[$field_title] .= '<td><input class="borderless" type="text" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="30" size="16" />';
							if ($data[$field_db] && $this->is_super()) {
								$inputs[$field_title] .= '<span class="small"><a href="javascript:void(0);" onclick="window.open(\'admin_controller.php?m=ccNum\', \'ccNum\', \'width=500,height=200\');">Show</a></span>';
							}
							$inputs[$field_title] .= '</td>';

						# HANDLE PHONES
						} else if (in_array($field_db, $phone_fields)) {
							$inputs[$field_title] .= '<td><input class="borderless" type="text" id="' . $field_db . '" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="' . $maxlength . '" size="' . $size . '" onKeyUp="formatPhone(\'' . $field_db . '\');" /></td>';

						# HANDLE EXPIRATION DATE
						} else if ($field_db == 'ccExp') {
							$date = '';
							if (!in_array($data[$field_db], array('0000-00-00', '', 0))) {
								$date = $this->format_date('cc_exp', $data[$field_db]);
							}
							$inputs[$field_title] .= '<td><input class="borderless" type="text" id="' . $field_db . '" name="' . $field_db . '" value="' . $date . '" maxlength="4" size="4" /></td>';

						# HANDLE PASSWORD
						} else if ($field_db == 'cPass') {
							$inputs[$field_title] .= '<td><input class="borderless" type="password" id="' . $field_db . '" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="' . $maxlength . '" /></td>';

						# HANDLE DATES
						} else if (in_array($field_db, $date_fields)) {
							$date = '';
							if (!in_array($data[$field_db], array('0000-00-00', '', 0))) {
								$date = $this->format_date('templ_date', $data[$field_db]);
							}
							$inputs[$field_title] .= '<td><input class="borderless" type="text" id="' . $field_db . '" name="' . $field_db . '" value="' . $date . '" maxlength="' . $maxlength . '" size="10" onKeyUp="formatSearchDate(\'' . $field_db . '\');" /></td>';

						# HANDLE TRACKING FIELDS WITH LABEL
						} else if (stristr($field_title, 'track') && file_exists(UPS_LABEL_PATH . $data[$field_db] . '.pdf')) {
							$inputs[$field_title] .=
								'<td><input class="borderless" type="text" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="' . $maxlength . '" size="20" />'
								. '<span class="small"><a href="' . CONTROLLER . '?m=getimage&tracking=' . $data[$field_db] . '">View</a> | '
								. '<a href="#" onclick="javascript:doubleCheck(\'' . CONTROLLER . '?m=print&print=label&tracking=' . $data[$field_db] . '&oNum=' . $_GET['oNum'] . '\', \'print this label\');">Print</a> | '
								. '<a href="#" onclick="javascript:doubleCheck(\'' . CONTROLLER . '?m=ups_void&tracking=' . $data[$field_db] . '&oNum=' . $_GET['oNum'] . '\', \'VOID this label\');">Void</a></span></td>';

						# HANDLE TRACKING FIELDS WITHOUT LABELS
						} else if (stristr($field_title, 'track') && $data[$field_db]) {
							$inputs[$field_title] .=
								'<td><input class="borderless" type="text" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="' . $maxlength . '" size="20" />'
								. '<span class="small"><a href="#" onclick="javascript:doubleCheck(\'' . CONTROLLER . '?m=ups_void&tracking=' . $data[$field_db] . '&oNum=' . $_GET['oNum'] . '\', \'VOID this label\');">Void</a></span></td>';

						# OTHER
						} else {
							$inputs[$field_title] .= '<td><input class="borderless" type="text" name="' . $field_db . '" value="' . $data[$field_db] . '" maxlength="' . $maxlength . '" size="' . $size . '" /></td>';
						}
					}
				}
			}
		}
		$inputs2 = '';
		$i = 0;
		$split2 = round(sizeof($inputs) / $split);
		foreach ($inputs as $input) {
			if ($i == $split2) {
				$split2 += sizeof($inputs) / $split;
				$inputs2 .= '</table></td><td valign="top"><table>';
			}
			$inputs2 .= '<tr>' . $input . '</tr>';
			$i++;
		}
		return '<tr><td><table>' . $inputs2 . '</table></td></tr>';
	}

	# PERMISSIONS CHECKER - RETURNS BOOL
	function is_super() {

                if ($_SESSION['aPermType'] == 'S'){
                    return true;
                }else{
                    return false;
                }

	}

	# ORDER DETAIL PAGE LOGIC
	function order_detail($oNum, $tracking, $action1, $action2, $submitted, $dd_data) {
		global $cartObj, $orderObj, $pmtObj, $upsObj, $orders_field_titles, $warehouse_info;
		$output = '';
		if (!$oNum) {
			$this->error_page(MISSING_URL_DATA);
		}
		if (!$data = $orderObj->get_data($oNum)) {
			$this->error_page(MISSING_RESULTS);
		}

		# SUB1: SHIPMENT TRACKING
		if ($action1 == 'tracking') {
			if (!$output = $this->tracking($oNum)) {
				$output .= '<p class="error">' . MISSING_TRACKING;
			}


		# SUB1: UPS VOID
		} else if ($action1 == 'ups_void' && $tracking) {
			if ($response = $upsObj->void_tracking($oNum, $tracking)) {
				if ($response === true) {
					$output .= '<p>' . SUCCESS_VOID;
					$this->db_update('ds_orders', 'oNum', $oNum, array(
							'cShipInstruct' => "concat(cShipInstruct, '\nVoided " . $tracking . '\')'
						)
					);
					$data['cShipInstruct'] .= 'Voided ' . $tracking;
				} else {
					$output .= '<p class="error">' . MISSING_TRACKING . '<br />' . $response;
				}
			}
		}

                if ($action1 == 'authorize'){

                    list($pmt_bool, $pmt_msg) = $pmtObj->payflowpro_service($submitted,$oNum,'AI');

                    if ($pmt_bool){

                        $order = $orderObj->get_data($oNum);

                        $order['cBillFname'] = $submitted['cBillFname'];
                        $order['cBillLname'] = $submitted['cBillLname'];
                        $order['cBillAddress1'] = $submitted['cBillAddress1'];
                        $order['cBillAddress2'] = $submitted['cBillAddress2'];
                        $order['cBillCity'] = $submitted['cBillCity'];
                        $order['cBillState'] = $submitted['cBillState'];
                        $order['cBillZip'] = $submitted['cBillZip'];
                        $order['ccName'] = $submitted['ccName'];
                        $order['ccExp'] = $submitted['ccExp'];
                        $order['CVV2'] = $submitted['CVV2'];

                        unset($submitted);

                        $submitted = $order;

                        $action2 = ORDER_SAVE_BUTTON;

                        $submitted['gateway_transaction_id'] = $pmt_msg;
                        $output .= '<p class="error">Authorized: '.$pmt_msg.'</p>';
                    }else{
                        $output .= '<p class="error">Authorization failed: '.implode('',$pmt_msg).'</p>';
                    }
                }

		# SUB1: SAVE ORDER
		if ($action2) {

			# SAVE CART CHANGES
			$cartObj->check_changes(
				$oNum, $submitted['pID'][0], $submitted['pQty'][0], $submitted['pPrice'][0], $oNum
			);

			# RE-CALCULATE PRICING - DUE TO COUPON OR CART CHANGES
			if ($pricing = $cartObj->get_pricing($oNum, $data['customer_id'], $submitted)) {
				$submitted['cSubTotal']	= $pricing['cSubTotal'];
				$submitted['cTax']		= $pricing['cTax'];
				$submitted['cTotal']	= $pricing['cTotal'];
				$submitted['cDiscount']	= $pricing['cDiscount'];
				$submitted['cShipping']	= $pricing['cShipping'];
			}

			if ($action2 == ORDER_SAVE_BUTTON) {

				if ($submitted['cStatus'] == STATUS_REFURB_COMPLETE){

					$data['dateCompleted'] = $this->format_date('db_date');

					$this->db_update('ds_orders', 'oNum', $oNum, array('dateCompleted' => $this->format_date('db_date')));
				}

				if ($submitted['cStatus'] == STATUS_WALKIN_COMPLETE){

					global $site_data_emails;

					$data['dateCompleted'] = $this->format_date('db_date');

					$this->db_update('ds_orders', 'oNum', $oNum, array('dateCompleted' => $this->format_date('db_date')));

					$parse = array(
						'SITE_URL_EMAIL'    =>  $site_data_emails[substr($oNum, 0, 2)]['url']
						,'SITE_NAME_EMAIL'  =>  $site_data_emails[substr($oNum, 0, 2)]['name']
						,'NAME'             =>  $data['cBillFname']
						,'MACHINE_TYPE'     =>  $data['machineType']
					);

					$body = $this->parse(WALKIN_COMPLETE_EMAIL, $parse);
				}


			}

			# RUN ORDER UPDATE PROCESS, SAVING CHANGED FIELDS TO DATA ARRAY
			list($data, $output) = $orderObj->update(
				$oNum, $output, $data, array_keys($orders_field_titles), $submitted
			);

			# SUB2: ADD ORDER NOTE
			if ($submitted['nNote']) {
				$sent = 'N';
				if ($submitted['nStatus'] == 'external') {
					$sent = 'Y';
				}
				$output .= $orderObj->insert_note($oNum, $submitted, $sent, $_SESSION['aUser']
					, ($data['customer_id'] == SQUARETRADE_CUST_ID), ($submitted['physical_damage'] == 'Y')
				);
			}

			# SUB2: MARK PAID, SET DATE COMPLETED
			if ($action2 == ORDER_PAID_BUTTON) {
				if ($orderObj->mark_paid($oNum)) {
					$data['paid'] = 'Y';
					list($close_bool, $close_data) = $orderObj->closeout(
						$submitted, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					if (!$close_bool) {
						$output .= '<p class="error">' . implode('<br />', $close_data);
					} else {
						$output .= '<p>' . SUCCESS_CLOSEOUT;
						$data['ship_tracking_id3'] = $close_data;
						$data['dateCompleted'] = $this->format_date('db_date');
						$data['cStatus'] = STATUS_SHIP_2;
					}
				}

			# SUB2: RE-SEND EMAIL
			} else if ($action2 == ORDER_EMAIL_BUTTON) {
				$output .= $orderObj->resend($submitted['email_type'], $oNum, $data['customer_id'], $data, false);

			# SUB2: RMA / NEW ORDER EMAIL
			} else if ($action2 == ORDER_EMAIL2_BUTTON) {
				$output .= $orderObj->resend($submitted['email_type'], $oNum, $data['customer_id'], $data);

			# SUB2: PROCESS CHARGES
			} else if ($action2 == ORDER_CHARGE_BUTTON || $action2 == ORDER_CHARGE2_BUTTON) {
				switch ($submitted['payment_method']) {
					case 'PayPal':
						$trans_bool = false;
						$data['cStatus'] = STATUS_PAYMENT;
						$orderObj->update_status(
							$oNum, STATUS_PAYMENT, array_merge($data, $submitted), ($data['customer_id'] == SQUARETRADE_CUST_ID)
						);
						$output .= '<p>Changed PayPal order to: ' . STATUS_PAYMENT;
					break;
					case 'Google Checkout':
						if ($gNum = $data['google_order_num']) {
							$trans_data = $pmtObj->google_charge($gNum, $data['cTotal']);
						}
						$trans_bool = false;
						$output .= '<p>Sent charge request to Google - Awaiting response: ' . $trans_data;
					break;
					case 'Credit Card':
						if ($submitted['ccNum'] && $submitted['CVV2']) {
							list($trans_bool, $trans_data) = $pmtObj->payflowpro_service(
								$submitted, $oNum, 'S', $submitted['cTotal']
							);
							if (!$trans_bool) {
								$output .= '<p class="error">' . implode('<br />', $trans_data);
								$orderObj->email_charge_fail($oNum, $data);
								$data['cStatus'] = STATUS_PAYMENT;
								$orderObj->update_status($oNum, STATUS_PAYMENT, array_merge($data, $submitted));
							}
						}
					break;
				}

				# IF SUCCESS CHARGE, MARK PAID, INSERT NOTE
				if ($trans_bool) {
					$output .= '<p>' . SUCCESS_PAYMENT;
					if ($orderObj->mark_paid($oNum)) {
						$data['paid'] = 'Y';
						$orderObj->insert_log($oNum, 'order_marked_paid');
					}
					$output .= $orderObj->insert_note($oNum, array(
							'nStatus'	=> 'internal'
							, 'nNote'	=> 'Charged ' . $submitted['payment_method']
								. ' $' . $submitted['cTotal'] . ' Transaction ID: ' . $trans_data
						), 'N', $_SESSION['aUser']
					);

					# IF PROCESS BUTTON CLICKED, EXECUTE ORDER COMPLETE PROCESSS
					if ($action2 == ORDER_CHARGE_BUTTON) {
						list($close_bool, $close_data) = $orderObj->closeout(
							$submitted, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID)
						);
						if (!$close_bool) {
							$output .= '<p class="error">' . implode('<br />', $close_data);
						} else {
							$output .= '<p>' . SUCCESS_CLOSEOUT;
							$data['dateCompleted'] = $this->format_date('db_date');
							$data['cStatus'] = STATUS_SHIP_2;
							$data['ship_tracking_id3'] = $close_data;
						}
					}
				}

			# SUB2: PROCESS RETURN STEP 1
			} else if ($action2 == ORDER_RETURN_BUTTON) {
				$orderObj->create_from_cust(
					$submitted, $data['customer_id'], SHIP_RMA_ROUND_GROUND
					, substr($data['oNum'], 0, 2), 'This is an RMA order for #' . $oNum, 'Y'
				);

			# SUB2: PROCESS RETURN STEP 2
			} else if ($action2 == ORDER_RETURN2_BUTTON) {

				# SEND RMA ORDER CONFIRMATION EMAIL
				if ($pricing = $cartObj->get_pricing($oNum, $data['customer_id'], $submitted)) {
					if ($cart = $cartObj->get_data($oNum, $pricing)) {
						if ($orderObj->receipt(
								array($cart), array($submitted), array($oNum)
								, ($data['customer_id'] == SQUARETRADE_CUST_ID), false
							)
						) {
							$output .= '<p>' . EMAIL_SENT;
						}
					}
				}

				# PROCESS CUSTOMER RETURN MAILING, ONLY IF NEW BOX NOT CHOSEN
				if ($submitted['new_box'] != 'Y' && $submitted['imac_box'] != 'Y') {
					list($from, $method) = $orderObj->get_ship_address(
						$data, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					$ship_data = array_merge($data, array('oNum' => $oNum));
					list($to, $retval) = $orderObj->get_ship_address(
						$warehouse_info, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					if ($tracking = $upsObj->ship(
							$ship_data, $from, $to, $method, 'weight_full', 'ship_tracking_id2', 'RZ', false, false, false, ($data['customer_id'] == SQUARETRADE_CUST_ID)
						)
					) {
						if (is_array($tracking)) {
							$output .= '<p class="error">' . implode('<br />', $tracking);
						} else {
							$data['ship_tracking_id2'] = $tracking;
							$output .= '<p>' . SUCCESS_RETURN;
							if ($upsObj->email_label($data, $submitted['cShipEmail'], $tracking)) {
								$output .= '<p>' . EMAIL_SENT;
							}
						}
					}
				}
			}

			# CREATE SHIPMENTS FOR ROUNDTRIP ORDERS
			if ($submitted['new_box'] == 'Y') {

				# ROUND TRIP
				if (stristr($submitted['cShipService'], 'round trip')) {
					list ($data['ship_tracking_id'], $data['ship_tracking_id2'], $error) = $orderObj->box_ship(
						$submitted, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID), ($submitted['sat_deliv'] == 'Y')
					);
					if ($data['ship_tracking_id'] && $data['ship_tracking_id2']) {
						$output .= '<p>' . SUCCESS_NEWBOX;
					} else {
						$output .= '<p class="error">' . $error;
					}

				# EXPRESS SELF BOX MAILED
				} else if (stristr($submitted['cShipService'], 'express')) {
					list($from, $method) = $orderObj->get_ship_address(
						array_merge($data, $submitted), ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					list($to, $retval) = $orderObj->get_ship_address(
						$warehouse_info, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					if ($tracking = $upsObj->ship(
							array_merge($data, $submitted), $from, $to, $method, 'weight_full'
							, 'ship_tracking_id2', 'IK', false, false, false
							, ($data['customer_id'] == SQUARETRADE_CUST_ID),false
						)
					) {
						if (!is_array($tracking)) {
							$data['ship_tracking_id2'] = $tracking;
							$upsObj->email_label(
								array_merge($data, $submitted), $submitted['cEmail'], $tracking
							);
							$output .= '<p>' . EMAIL_SENT;
						}
					}
				}
			}

                        if ($submitted['imac_box'] == 'Y') {

				# ROUND TRIP
				if (stristr($submitted['cShipService'], 'round trip')) {
					list ($data['ship_tracking_id'], $data['ship_tracking_id2'], $error) = $orderObj->box_ship(
						$submitted, $oNum, ($data['customer_id'] == SQUARETRADE_CUST_ID), ($submitted['sat_deliv'] == 'Y')
					);
					if ($data['ship_tracking_id'] && $data['ship_tracking_id2']) {
						$output .= '<p>' . SUCCESS_NEWBOX;
					} else {
						$output .= '<p class="error">' . $error;
					}

				# EXPRESS SELF BOX MAILED
				} else if (stristr($submitted['cShipService'], 'express')) {
					list($from, $method) = $orderObj->get_ship_address(
						array_merge($data, $submitted), ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					list($to, $retval) = $orderObj->get_ship_address(
						$warehouse_info, ($data['customer_id'] == SQUARETRADE_CUST_ID)
					);
					if ($tracking = $upsObj->ship(
							array_merge($data, $submitted), $from, $to, $method, 'weight_imac'
							, 'ship_tracking_id2', 'IK', false, false, false
							, ($data['customer_id'] == SQUARETRADE_CUST_ID),false
						)
					) {
						if (!is_array($tracking)) {
							$data['ship_tracking_id2'] = $tracking;
							$upsObj->email_label(
								array_merge($data, $submitted), $submitted['cEmail'], $tracking
							);
							$output .= '<p>' . EMAIL_SENT;
						}
					}
				}
			}
		}

                if ($submitted['keyboard'] == 'fail'){
                    $audit_summary .= 'Keyboard - fail. ';
                }
				if ($submitted['trackpad'] == 'fail'){
                    $audit_summary .= 'Trackpad - fail. ';
                }
				if ($submitted['optical'] == 'fail'){
                    $audit_summary .= 'Optical - fail. ';
                }
				if ($submitted['lcd'] == 'fail'){
                    $audit_summary .= 'Screen - fail. ';
                }
				if ($submitted['glass'] == 'fail'){
                    $audit_summary .= 'Glass - fail. ';
                }
				if ($submitted['ports'] == 'fail'){
                    $audit_summary .= 'Ports - fail. ';
                }
				if ($submitted['wifi'] == 'fail'){
                    $audit_summary .= 'Wifi - fail. ';
                }
				if ($submitted['speakers'] == 'fail'){
                    $audit_summary .= 'Speakers - fail. ';
                }
				if ($submitted['isight'] == 'fail'){
                    $audit_summary .= 'iSight - fail. ';
                }
				if ($submitted['enet'] == 'fail'){
                    $audit_summary .= 'Ethernet port - fail. ';
                }
				if ($submitted['battery'] == 'fail'){
                    $audit_summary .= 'Battery - fail. ';
                }
						 if ($submitted['home_button'] == 'fail'){
                    $audit_summary .= 'Home button - fail. ';
                }
				if ($submitted['volume'] == 'fail'){
                    $audit_summary .= 'Volume up/down - fail. ';
                }
				if ($submitted['sleep_wake'] == 'fail'){
                    $audit_summary .= 'Sleep/wake - fail. ';
                }
				if ($submitted['silent_rot'] == 'fail'){
                    $audit_summary .= 'Silent switch - fail. ';
                }
				if ($submitted['headphone'] == 'fail'){
                    $audit_summary .= 'Headphone jack - fail. ';
                }
				if ($submitted['front_camera'] == 'fail'){
                    $audit_summary .= 'Front camera - fail. ';
                }
				if ($submitted['rear_camera'] == 'fail'){
                    $audit_summary .= 'Rear camera - fail. ';
                }
				if ($submitted['speaker'] == 'fail'){
                    $audit_summary .= 'Speaker - fail. ';
                }
				if ($submitted['mic'] == 'fail'){
                    $audit_summary .= 'Microphone - fail. ';
                }
				if ($submitted['charge'] == 'fail'){
                    $audit_summary .= 'Charge - fail. ';
                }
				if ($submitted['wifi_ipad'] == 'fail'){
                    $audit_summary .= 'Wifi - fail. ';
                }
                if ($submitted['case_scratches'] != ''){
                    $audit_summary .= 'Case scratches - '.$submitted['case_scratches'].'. ';
                }
                if ($submitted['case_cdents'] != ''){
                    $audit_summary .= 'Corner dents - '.$submitted['case_cdents'].'. ';
                }
                if ($submitted['case_sdents'] != ''){
                    $audit_summary .= 'Surface dents - '.$submitted['case_sdents'].'. ';
                }
                                        if ($submitted['case_scratches2'] != ''){
                    $audit_summary .= 'Case scratches - '.$submitted['case_scratches2'].'. ';
                }
                if ($submitted['case_cdents2'] != ''){
                    $audit_summary .= 'Corner dents - '.$submitted['case_cdents2'].'. ';
                }
                if ($submitted['case_sdents2'] != ''){
                    $audit_summary .= 'Surface dents - '.$submitted['case_sdents2'].'. ';
                }
                if ($submitted['case_edents'] != ''){
                    $audit_summary .= 'Edge dents - '.$submitted['case_edents'].'. ';
                }
                                        if ($submitted['case_cracks'] != ''){
                    $audit_summary .= 'Case cracks - '.$submitted['case_cracks'].'. ';
                }
                                        if ($submitted['lcd_scratches'] != ''){
                    $audit_summary .= 'Screen scratches - '.$submitted['lcd_scratches'].'. ';
                }
                                        if ($submitted['lcd_dust'] != ''){
                    $audit_summary .= 'Dust/Dirt under glass - '.$submitted['lcd_dust'].'. ';
                }
                                        if ($submitted['lcd_white'] != ''){
                    $audit_summary .= 'White spots - '.$submitted['lcd_white'].'. ';
                }
                                        if ($submitted['case_keymarks'] != ''){
                    $audit_summary .= 'Keyboard marks - '.$submitted['case_keymarks'].'. ';
                }
                if ($submitted['digi_scratches'] != ''){
                    $audit_summary .= 'Screen scratches - '.$submitted['digi_scratches'].'. ';
                }
                if ($submitted['digi_dust'] == 'on'){
                    $audit_summary .= 'Dust/Dirt under digitizer. ';
                }
                if ($submitted['digi_white'] == 'on'){
                    $audit_summary .= 'White spots on screen. ';
                }
                if ($submitted['hinge'] == 'on'){
                    $audit_summary .= 'Loose hinge. ';
                }
				if ($submitted['refurb_keys'] == 'on'){
                    $audit_summary .= 'Missing keys. ';
                }
				if ($submitted['case_track'] == 'on'){
                    $audit_summary .= 'Trackpad misaligned. ';
                }
                if ($submitted['digi_lines'] == 'on'){
                    $audit_summary .= 'Lines on screen. ';
                }
                if ($submitted['digi_un'] == 'on'){
                    $audit_summary .= 'Touchscreen unresponsive. ';
                }
                if ($submitted['digi_dis'] == 'on'){
                    $audit_summary .= 'Screen discolored. ';
                }
                if ($submitted['digi_sep'] == 'on'){
                    $audit_summary .= 'Digitizer separation. ';
                }
                if ($submitted['digi_touch'] == 'on'){
                    $audit_summary .= 'LCD/Digi touching. ';
                }
                if ($submitted['digi_video'] == 'on'){
                    $audit_summary .= 'Video issue. ';
                }
                if ($submitted['digitizer_crack'] == 'on'){
                    $audit_summary .= 'Cracked screen. ';
                }
                                        if ($submitted['marking'] == 'on'){
                    $audit_summary .= 'Engraving/Permanent Markings. ';
                }
                if ($submitted['missing_feet'] == 'on'){
                    $audit_summary .= 'Missing feet. ';
                }
                if ($submitted['broken_hinge'] == 'on'){
                    $audit_summary .= 'Broken hinge. ';
                }
                if ($submitted['hd_failure'] == 'on'){
                    $audit_summary .= 'HD failure. ';
                }
                if ($submitted['boot_failure'] == 'on'){
                    $audit_summary .= 'Logic failure. ';
                }
                if ($submitted['refurb_notes'] != ''){
                    $audit_summary .= $submitted['refurb_notes'].'.';
                }

                //process any audit changes
                if (substr($oNum, 0,2) == 'SP' && $action2 == ORDER_SAVE_BUTTON){
                    if ($submitted['is_ipad'] != 'true' && $submitted['is_imac'] != 'true'){

                        $updates = array(
                                'machineType'			=> $submitted['machineType']
                                , 'serialNumber'		=> $submitted['serialNumber']
                                , 'grade'           => $submitted['grade']
                                , 'poNumber'        => $submitted['poNumber']
                                , 'top_case'                => $submitted['top_case']=='on'?'1':''
                                , 'display_housing'         => $submitted['display_housing']=='on'?'1':''
                                , 'bottom_case'             => $submitted['bottom_case']=='on'?'1':''
                                , 'refurb_keys'             => $submitted['refurb_keys']=='on'?'1':''
                                , 'case_track'             => $submitted['case_track']=='on'?'1':''
                                , 'digi_white'             => $submitted['digi_white']=='on'?'1':''
                                , 'digi_dust'             => $submitted['digi_dust']=='on'?'1':''
                                , 'digi_lines'             => $submitted['digi_lines']=='on'?'1':''
                                , 'digi_dis'             => $submitted['digi_dis']=='on'?'1':''
                                , 'case_sdents'                => $submitted['case_sdents']
                                , 'hinge'                   => $submitted['hinge']=='on'?'1':''
                                , 'refurb_notes'            => $submitted['refurb_notes']
                                , 'hd_1'                    => $submitted['hd_1']
                                , 'hd_2'                    => $submitted['hd_2']
                                , 'ram_1'                   => $submitted['ram_1']
                                , 'ram_2'                   => $submitted['ram_2']
                                , 'ram_3'                   => $submitted['ram_3']
                                , 'ram_4'                   => $submitted['ram_4']
                                , 'optical'                 => $submitted['optical']
                                , 'optical_notes'           => $submitted['optical_notes']
                                , 'lcd'                     => $submitted['lcd']
                                , 'lcd_notes'               => $submitted['lcd_notes']
                                , 'glass'                   => $submitted['glass']
                                , 'glass_notes'             => $submitted['glass_notes']
                                , 'enet'                    => $submitted['enet']
                                , 'enet_notes'              => $submitted['enet_notes']
                                , 'wifi'                    => $submitted['wifi']
                                , 'wifi_notes'              => $submitted['wifi_notes']
                                , 'speakers'                => $submitted['speakers']
                                , 'scratch'                => $submitted['scratch']=='on'?'1':''
                                , 'marking'                => $submitted['marking']=='on'?'1':''
                                , 'trackpad'                => $submitted['trackpad']
                                , 'trackpad_notes'                => $submitted['trackpad_notes']
                                , 'keyboard'                => $submitted['keyboard']
                                , 'keyboard_notes'                => $submitted['keyboard_notes']
                                , 'ports'                => $submitted['ports']
                                , 'ports_notes'                => $submitted['ports_notes']
                                , 'speakers_notes'          => $submitted['speakers_notes']
                                , 'battery'                 => $submitted['battery']
                                , 'battery_cycles'          => $submitted['battery_cycles']
                                , 'battery_mah'             => $submitted['battery_mah']
                                , 'isight'                  => $submitted['isight']
                                , 'isight_notes'            => $submitted['isight_notes']
                                , 'os_version'              => $submitted['os_version']
                                , 'boot_failure'            => $submitted['boot_failure']=='on'?'1':''
                                , 'digitizer_crack'         => $submitted['digitizer_crack']=='on'?'1':''
                                , 'digi_video'         => $submitted['digi_video']=='on'?'1':''
                                , 'digi_scratches'              => $submitted['digi_scratches']
                                , 'case_scratches'              => $submitted['case_scratches']
                                , 'case_cdents'              => $submitted['case_cdents']
                                , 'case_sdents'              => $submitted['case_sdents']
                                , 'case_scratches2'              => $submitted['case_scratches2']
                                , 'case_cdents2'              => $submitted['case_cdents2']
                                , 'case_sdents2'              => $submitted['case_sdents2']
                                , 'case_edents'              => $submitted['case_edents']
                                , 'case_cracks'              => $submitted['case_cracks']
                                , 'case_keymarks'              => $submitted['case_keymarks']
                                , 'LCD_scratches'              => $submitted['lcd_scratches']
                                , 'audit_summary'               => $audit_summary
                                , 'missing_feet'              => $submitted['missing_feet']=='on'?'1':''
                                , 'broken_hinge'              => $submitted['broken_hinge']=='on'?'1':''
				, 'hd_failure'              => $submitted['hd_failure']=='on'?'1':''
				, 'mdm_lock'                => $submitted['mdm_lock'] == 'on'?1:0
                          );

                    }elseif ($submitted['is_imac'] == 'true'){
                        $updates = array(
                                'machineType'			=> $submitted['machineType']
                                , 'serialNumber'		=> $submitted['serialNumber']
                                , 'grade'           => $submitted['grade']
                                , 'poNumber'        => $submitted['poNumber']
                                , 'rh_scratched'                => $submitted['rh_scratched']=='on'?'1':''
                                , 'rh_dented'         => $submitted['rh_dented']=='on'?'1':''
                                , 'stand_scratched'             => $submitted['stand_scratched']=='on'?'1':''
                                , 'stand_dented'             => $submitted['stand_dented']=='on'?'1':''
                                , 'glass_scratched'                   => $submitted['glass_scratched']=='on'?'1':''
                                , 'glass_cracked'                   => $submitted['glass_cracked']=='on'?'1':''
                                , 'refurb_notes'            => $submitted['refurb_notes']
                                , 'hd_1'                    => $submitted['hd_1']
                                , 'hd_2'                    => $submitted['hd_2']
                                , 'ram_1'                   => $submitted['ram_1']
                                , 'ram_2'                   => $submitted['ram_2']
                                , 'ram_3'                   => $submitted['ram_3']
                                , 'ram_4'                   => $submitted['ram_4']
                                , 'optical'                 => $submitted['optical']
                                , 'optical_notes'           => $submitted['optical_notes']
                                , 'lcd'                     => $submitted['lcd']
                                , 'lcd_notes'               => $submitted['lcd_notes']
                                , 'glass'                   => $submitted['glass']
                                , 'glass_notes'             => $submitted['glass_notes']
                                , 'enet'                    => $submitted['enet']
                                , 'enet_notes'              => $submitted['enet_notes']
                                , 'wifi'                    => $submitted['wifi']
                                , 'wifi_notes'              => $submitted['wifi_notes']
                                , 'speakers'                => $submitted['speakers']
                                , 'ports'                => $submitted['ports']
                                , 'ports_notes'                => $submitted['ports_notes']
                                , 'speakers_notes'          => $submitted['speakers_notes']
                                , 'isight'                  => $submitted['isight']
                                , 'isight_notes'            => $submitted['isight_notes']
                                , 'os_version'              => $submitted['os_version']
                                , 'boot_failure'            => $submitted['boot_failure']
                                , 'digitizer_crack'         => $submitted['digitizer_crack']=='on'?'1':''
                                , 'digi_video'         => $submitted['digi_video']=='on'?'1':''
                                , 'digi_scratches'              => $submitted['digi_scratches']
                                , 'case_scratches'              => $submitted['case_scratches']
                                , 'case_cdents'              => $submitted['case_cdents']
                                , 'case_sdents'              => $submitted['case_sdents']
                                , 'case_scratches2'              => $submitted['case_scratches2']
                                , 'case_cdents2'              => $submitted['case_cdents2']
                                , 'case_sdents2'              => $submitted['case_sdents2']
                                , 'case_edents'              => $submitted['case_edents']
                                , 'case_cracks'              => $submitted['case_cracks']
                                , 'case_keymarks'              => $submitted['case_keymarks']
                                , 'LCD_scratches'              => $submitted['lcd_scratches']
                                , 'audit_summary'           => $audit_summary
                                , 'hd_failure'              => $submitted['hd_failure']
                                , 'mdm_lock'                => $submitted['mdm_lock'] == 'on'?1:0
                          );
                    }else{

                        $updates = array(
                                'machineType'			=> $submitted['machineType']
                                , 'serialNumber'		=> $submitted['serialNumber']
                                , 'grade'           => $submitted['grade']
                                , 'digitizer_scratch'       => $submitted['digitizer_scratch']=='on'?'1':''
                                , 'digitizer_crack'         => $submitted['digitizer_crack']=='on'?'1':''
                                , 'digi_dust'         => $submitted['digi_dust']=='on'?'1':''
                                , 'digi_white'         => $submitted['digi_white']=='on'?'1':''
                                , 'marking'         => $submitted['marking']=='on'?'1':''
                                , 'digi_lines'         => $submitted['digi_lines']=='on'?'1':''
                                , 'digi_un'         => $submitted['digi_un']=='on'?'1':''
                                , 'digi_dis'         => $submitted['digi_dis']=='on'?'1':''
                                , 'digi_sep'         => $submitted['digi_sep']=='on'?'1':''
                                , 'digi_touch'         => $submitted['digi_touch']=='on'?'1':''
                                , 'digi_video'         => $submitted['digi_video']=='on'?'1':''
                                , 'digi_scratches'              => $submitted['digi_scratches']
                                , 'case_scratches'              => $submitted['case_scratches']
                                , 'case_cdents'              => $submitted['case_cdents']
                                , 'case_sdents'              => $submitted['case_sdents']
                                , 'case_scratches2'              => $submitted['case_scratches2']
                                , 'case_cdents2'              => $submitted['case_cdents2']
                                , 'case_sdents2'              => $submitted['case_sdents2']
                                , 'case_edents'              => $submitted['case_edents']
                                , 'case_cracks'              => $submitted['case_cracks']
                                , 'LCD_scratches'              => $submitted['LCD_scratches']
                                , 'lcd_dust'              => $submitted['lcd_dust']
                                , 'lcd_white'              => $submitted['lcd_white']
                                , 'case_keymarks'              => $submitted['case_keymarks']
                                , 'lcd_crack'               => $submitted['lcd_crack']=='on'?'1':''
                                , 'case_scratch'            => $submitted['case_scratch']=='on'?'1':''
                                , 'case_crack'              => $submitted['case_crack']=='on'?'1':''
                                , 'case_dent'               => $submitted['case_dent']=='on'?'1':''
                                , 'refurb_notes'            => $submitted['refurb_notes']
                                , 'home_button'             => $submitted['home_button']
                                , 'home_button_notes'       => $submitted['home_button_notes']
                                , 'volume'                  => $submitted['volume']
                                , 'volume_notes'            => $submitted['volume_notes']
                                , 'sleep_wake'              => $submitted['sleep_wake']
                                , 'sleep_wake_notes'        => $submitted['sleep_wake_notes']
                                , 'silent_rot'              => $submitted['silent_rot']
                                , 'silent_rot_notes'        => $submitted['silent_rot_notes']
                                , 'headphone'               => $submitted['headphone']
                                , 'headphone_notes'         => $submitted['headphone_notes']
                                , 'front_camera'            => $submitted['front_camera']
                                , 'front_camera_notes'      => $submitted['front_camera_notes']
                                , 'rear_camera'             => $submitted['rear_camera']
                                , 'rear_camera_notes'       => $submitted['rear_camera_notes']
                                , 'speaker'                 => $submitted['speaker']
                                , 'speaker_notes'           => $submitted['speaker_notes']
                                , 'wifi'                    => $submitted['wifi']
                                , 'wifi_notes'              => $submitted['wifi_notes']
                                , 'mic'                     => $submitted['mic']
                                , 'mic_notes'               => $submitted['mic_notes']
                                , 'charge'                  => $submitted['charge']
                                , 'charge_notes'            => $submitted['charge_notes']
                                , 'os_version'              => $submitted['os_version']
                                , 'boot_failure'            => $submitted['boot_failure']=='on'?'1':''
                                , 'audit_summary'           => $audit_summary
                                , 'capacity'                => $submitted['capacity']
                                , 'activation_lock'         => $submitted['activation_lock'] == 'on'?1:0
                                , 'mdm_lock'                => $submitted['mdm_lock'] == 'on'?1:0
                          );

                    }

                    #UPDATE DB
                    $this->db_update('ds_orders', 'oNum', $oNum, $updates);
                }

		# OUTPUT ORDER DETAIL TEMPLATE AND FOOTER
		$data = $orderObj->get_data($oNum, array('*'), true);	# LOAD CC INTO SESSION
		echo $this->parse(TEMPLATE, array(
				'BODY' => $this->parse(ADMIN_SEARCH_BODY, $dd_data) . $output . $this->parse_order_detail($data, $oNum)
			)
		);
	}

	# PARSES ADMIN CUSTOMER DETAIL - RETURNS HTML
	function parse_customer_detail($create_orders, $data, $cString, $cart_sess, $problem, $coupon, $shipping, $create_mult) {
		global $cartObj, $orderObj, $admin_cust_card_fields;
		$parse = array(
			'C_STRING'			=> $cString
			, 'INPUTS'			=> $this->get_fields('ds_customers', $data, 2, $admin_cust_card_fields)
			, 'PRODUCTS'		=> $this->arrayToHtmlSelectOptions($cartObj->get_products_list(), true, false, array(), 'Add Product')
			, 'CREATE_ORDERS'	=> $create_orders
			, 'CREATE_MULT'		=> $orderObj->parse_create_mult_orders(
				$cString, $create_mult, $cart_sess, $problem, $coupon, $shipping
			)
		);
		return $this->parse(CUSTOMER_VIEW, $parse);
	}

	# PARSES ADMIN ORDER DETAIL - RETURNS HTML
	function parse_order_detail($data, $oNum) {
		global $cartObj, $searchObj, $orderObj;
		$charge_button = '';
		$charge2_button = '';
		$paid_button = '';
		$order_logs = '';
		if ($data['paid'] != 'Y') {
			$charge_button = '<input type="submit" class="tab2" name="submit_action" value="' . ORDER_CHARGE_BUTTON . '" onclick="return doubleCheckCharge();" />';
			$charge2_button = '<input type="submit" class="tab2" name="submit_action" value="' . ORDER_CHARGE2_BUTTON . '" onclick="return doubleCheckCharge();" />';
			$paid_button = '<input type="submit" class="tab2" name="submit_action" value="' . ORDER_PAID_BUTTON . '" />';
		}
		if ($logs = $orderObj->get_history($oNum)) {
			foreach ($logs as $log) {
				$order_logs .= '<tr><td class="small" nowrap="nowrap">' . $this->format_date('templ_full', $log['time'])
					. '&nbsp;&nbsp;</td><td class="small">' . $log['details']
                                        . '&nbsp;&nbsp;</td><td class="small">' . $log['userName'] . '</td></tr>';
			}
		}
		if ($admins = $this->db_select_single('ds_customers', 'admin1, admin2', array('cString' => $data['customer_id']))) {
			if ($admins[1]) {
				$admins = $admins[0] . ', ' . $admins[1];
			} else {
				$admins = $admins[0];
			}
			$admins = ucwords(str_replace('.', ' ', $admins));
		}

        if (substr($oNum, 0,2) != 'SP'){
            $parse = array(
                    'ONUM'				=> $oNum
                    , 'MACH'			=> $data['machineType']
                    , 'SPEED'			=> $data['processorSpeed']
                    , 'CUST_ID'			=> $data['customer_id']
                    , 'ADMINS'			=> $admins
                    , 'CART_ITEMS'		=> $cartObj->show_admin($oNum,0,DISABLE_MULTIPLE_ITEMS)
                    , 'DATES'			=> $this->get_fields('ds_orders', $data, 1, array('cDate', 'dateMachineReceived', 'datePartsExpected', 'dateCompleted', 'warrantyEndDate' , 'cStatus'))
                    , 'SHIP'			=> $this->get_fields('ds_orders', $data, 1, array('cShipService', 'cShipCompany', 'cShipFname', 'cShipLname', 'cShipAddress1', 'cShipAddress2', 'Shipping City, State, Zip', 'cShipCountry', 'cShipEmail'))
                    , 'BILL'			=> $this->get_fields('ds_orders', $data, 1, array('cBillCompany', 'cBillFname', 'cBillLname', 'cBillAddress1', 'cBillAddress2', 'Billing City, State, Zip', 'cBillCountry'))
                    , 'CONTACT'			=> $this->get_fields('ds_orders', $data, 1, array('cEmail', 'cPhone', 'cPhoneSms', 'cFax', 'cFaxSms'))
                    , 'MACH_0'			=> $this->get_fields('ds_orders', $data, 1, array('problem'))
                    , 'MACH_1'			=> $this->get_fields('ds_orders', $data, 1, array('machineType', 'processorSpeed', 'serialNumber', 'asset'))
                    , 'MACH_2'			=> $this->get_fields('ds_orders', $data, 1, array('oWarranty', 'oOSDisks', 'oACAdapter', 'oRMA'))
                    , 'PRICE'			=> $this->get_fields('ds_orders', $data, 2, array('cSubTotal', 'cDiscount', 'cTax', 'cShipping', 'cpCode', 'cTotal'))
                    , 'NOTES'			=> $this->get_fields('ds_orders', $data, 1, array('cShipInstruct'))
                    , 'PAY'				=> $this->get_fields('ds_orders', $data, 1, array('paid', 'payment_method', 'ccType', 'gateway_transaction_id', 'ccName', 'ccNum', 'ccExp', 'CVV2', 'poNumber', 'google_order_num'))
                    , 'TRACK'			=> $this->get_fields('ds_orders', $data, 1, array('ship_tracking_id', 'ship_tracking_id2', 'ship_tracking_id3'))
                    , 'CHARGE_BUTTON'	=> $charge_button
                    , 'CHARGE2_BUTTON'	=> $charge2_button
                    , 'PAID_BUTTON'		=> $paid_button
                    , 'ORDER_NOTES'		=> $searchObj->display_notes($searchObj->search_records('ds_order_notes', $oNum, 'oNumber', 'nID'), false)
                    , 'ORDER_LOGS'		=> $order_logs
            );
            return $this->parse(ORDER_VIEW, $parse);
        }  else {

            global $hdvolumes, $ramvolumes, $osx_versions, $ios_versions, $ipadcapacities;

            $dd_grade = '<tr><td>Grade</td><td><select class="borderless" id="grade" name="grade">';

            $dd_grade .= '<option></option>';

            if ($data['grade'] == 'A'){
                $dd_grade .= '<option selected>A</option>';
            }else{
                $dd_grade .= '<option>A</option>';
            }

            if ($data['grade'] == 'B'){
                $dd_grade .= '<option selected>B</option>';
            }else{
                $dd_grade .= '<option>B</option>';
            }

            if ($data['grade'] == 'C'){
                $dd_grade .= '<option selected>C</option>';
            }else{
                $dd_grade .= '<option>C</option>';
            }

            if ($data['grade'] == 'AD'){
                $dd_grade .= '<option selected>AD</option>';
            }else{
                $dd_grade .= '<option>AD</option>';
            }

            if ($data['grade'] == 'BD'){
                $dd_grade .= '<option selected>BD</option>';
            }else{
                $dd_grade .= '<option>BD</option>';
            }

            if ($data['grade'] == 'CD'){
                $dd_grade .= '<option selected>CD</option>';
            }else{
                $dd_grade .= '<option>CD</option>';
            }

            if ($data['grade'] == 'D'){
                $dd_grade .= '<option selected>D</option>';
            }else{
                $dd_grade .= '<option>D</option>';
            }

                if ($data['grade'] == 'DC'){
                $dd_grade .= '<option selected>DC</option>';
            }else{
                $dd_grade .= '<option>DC</option>';
            }

                if ($data['grade'] == 'DF'){
                $dd_grade .= '<option selected>DF</option>';
            }else{
                $dd_grade .= '<option>DF</option>';
            }

                if ($data['grade'] == 'DCF'){
                $dd_grade .= '<option selected>DCF</option>';
            }else{
                $dd_grade .= '<option>DCF</option>';
            }

            if ($data['grade'] == 'F'){
                $dd_grade .= '<option selected>F</option>';
            }else{
                $dd_grade .= '<option>F</option>';
            }

            $dd_grade .= '</select></td></tr></table></td></tr>';

            $hds = '<option></option>';

            foreach ($hdvolumes as $k => $v){
                $hds .= '<option>'.$k.'</option>';
            }

            $rams = '<option></option>';

            foreach ($ramvolumes as $k => $v){
                $rams .= '<option>'.$k.'</option>';
            }

            $dates = $this->get_fields('ds_orders', $data, 1, array('dateMachineReceived', 'dateSold', 'soldInvoice', 'dateCompleted', 'warrantyEndDate' , 'cStatus'));
            //$dates .= '<tr><td>Grade</td><td>'.$dd_grade.'</td></tr></table></td></tr>';

            $dates = str_replace('</table></td></tr>', $dd_grade, $dates);

            if ($data['is_ipad']){

                $oss = '<option></option>';

                foreach ($ios_versions as $os){
                    if ($os == $data['os_version']){
                        $oss .= '<option selected>'.$os.'</option>';
                    }else{
                        $oss .= '<option>'.$os.'</option>';
                    }
				}

				$osVersion = $data['os_version'];

                $capacities = '<option></option>';

                foreach ($ipadcapacities as $capacity){
                    if ($capacity == $data['capacity']){
                        $capacities .= '<option selected>'.$capacity.'</option>';
                    }else{
                        $capacities .= '<option>'.$capacity.'</option>';
                    }
                }

                $scratches = array('Minor','Moderate','Major');
                $scratches2 = array('Minor','Major');

                $case_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_scratches']){
                        $case_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_scratches .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cdents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cdents']){
                        $case_cdents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cdents .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_sdents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_sdents']){
                        $case_sdents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_sdents .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_scratches2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_scratches2']){
                        $case_scratches2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_scratches2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cdents2']){
                        $case_cdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cdents2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_sdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_sdents2']){
                        $case_sdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_sdents2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_edents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_edents']){
                        $case_edents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_edents .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_cracks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cracks']){
                        $case_cracks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cracks .= '<option>'.$scratch.'</option>';
                    }
                }
                $LCD_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['LCD_scratches']){
                        $LCD_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $LCD_scratches .= '<option>'.$scratch.'</option>';
                    }
                }
                $lcd_dust = '<option></option>';
                foreach ($scratches2 as $scratch2){
                    if ($scratch2 == $data['lcd_dust']){
                        $lcd_dust .= '<option selected>'.$scratch2.'</option>';
                    }else{
                        $lcd_dust .= '<option>'.$scratch2.'</option>';
                    }
                }
                $lcd_white = '<option></option>';
                foreach ($scratches2 as $scratch2){
                    if ($scratch2 == $data['lcd_white']){
                        $lcd_white .= '<option selected>'.$scratch2.'</option>';
                    }else{
                        $lcd_white .= '<option>'.$scratch2.'</option>';
                    }
                }
                $case_keymarks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_keymarks']){
                        $case_keymarks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_keymarks .= '<option>'.$scratch.'</option>';
                    }
                }

                $digi_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['digi_scratches']){
                        $digi_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $digi_scratches .= '<option>'.$scratch.'</option>';
                    }
                }

                $auditdata1 = array(
                    'DIGITIZER_SCRATCH'    => $data['digitizer_scratch'] == 1?'checked':''
                    ,'DIGITIZER_CRACK'    => $data['digitizer_crack'] == 1?'checked':''
                    ,'DIGI_DUST'    => $data['digi_dust'] == 1?'checked':''

                    ,'DIGI_WHITE'    => $data['digi_white'] == 1?'checked':''
                    ,'MARKING'    => $data['marking'] == 1?'checked':''
                    ,'DIGI_LINES'    => $data['digi_lines'] == 1?'checked':''
                    ,'DIGI_UN'    => $data['digi_un'] == 1?'checked':''
                    ,'DIGI_DIS'    => $data['digi_dis'] == 1?'checked':''
                    ,'DIGI_SEP'    => $data['digi_sep'] == 1?'checked':''
                    ,'DIGI_TOUCH'    => $data['digi_touch'] == 1?'checked':''
                    ,'DIGI_VIDEO'    => $data['digi_video'] == 1?'checked':''
                    ,'CASE_SCRATCHES'    => $case_scratches
                    ,'CASE_CDENTS'    => $case_cdents
                    ,'CASE_SDENTS'    => $case_sdents
                    ,'CASE_SCRATCHES2'    => $case_scratches2
                    ,'CASE_CDENTS2'    => $case_cdents2
                    ,'CASE_SDENTS2'    => $case_sdents2
                    ,'CASE_EDENTS'    => $case_edents
                    ,'CASE_CRACKS'    => $case_cracks
                    ,'LCD_SCRATCHES'    => $LCD_scratches
                    ,'LCD_DUST'    => $lcd_dust
                    ,'LCD_WHITE'    => $lcd_white
                    ,'CASE_KEYMARKS'    => $case_keymarks
                    ,'LCD_CRACK'    => $data['lcd_crack'] == 1?'checked':''
                    ,'CASE_SCRATCH'    => $data['case_scratch'] == 1?'checked':''
                    ,'CASE_CRACK'    => $data['case_crack'] == 1?'checked':''
                    ,'CASE_DENT'    => $data['case_dent'] == 1?'checked':''
                    ,'REFURB_NOTES' => $data['refurb_notes']
                    ,'DIGI_SCRATCHES'    => $digi_scratches
                    ,'CAPACITY'     => $capacities
                    ,'AUDIT_SUMMARY' => $data['audit_summary']
                    ,'BOOT_FAILURE'     => $data['boot_failure'] == '1'?'checked':''

                );

                $auditdata2 = array(
					'OS'        => $oss
					,'OS_VERSION'	=> $osVersion
                    ,'HOME_PASS'    => $data['home_button'] == 'pass'?'checked':''
                    ,'HOME_FAIL'    => $data['home_button'] == 'fail'?'checked':''
                    ,'HOME_NA'      => $data['home_button'] == 'na'?'checked':''
                    ,'HOME_NOTES'       => $data['home_button_notes']
                    ,'VOLUME_PASS'    => $data['volume'] == 'pass'?'checked':''
                    ,'VOLUME_FAIL'    => $data['volume'] == 'fail'?'checked':''
                    ,'VOLUME_NA'      => $data['volume'] == 'na'?'checked':''
                    ,'VOLUME_NOTES'       => $data['volume_notes']
                    ,'SLEEP_PASS'    => $data['sleep_wake'] == 'pass'?'checked':''
                    ,'SLEEP_FAIL'    => $data['sleep_wake'] == 'fail'?'checked':''
                    ,'SLEEP_NA'      => $data['sleep_wake'] == 'na'?'checked':''
                    ,'SLEEP_NOTES'       => $data['sleep_wake_notes']
                    ,'SILENT_PASS'    => $data['silent_rot'] == 'pass'?'checked':''
                    ,'SILENT_FAIL'    => $data['silent_rot'] == 'fail'?'checked':''
                    ,'SILENT_NA'      => $data['silent_rot'] == 'na'?'checked':''
                    ,'SILENT_NOTES'       => $data['silent_rot_notes']
                    ,'HEADPHONE_PASS'    => $data['headphone'] == 'pass'?'checked':''
                    ,'HEADPHONE_FAIL'    => $data['headphone'] == 'fail'?'checked':''
                    ,'HEADPHONE_NA'      => $data['headphone'] == 'na'?'checked':''
                    ,'HEADPHONE_NOTES'       => $data['headphone_notes']
                    ,'FRONT_PASS'    => $data['front_camera'] == 'pass'?'checked':''
                    ,'FRONT_FAIL'    => $data['front_camera'] == 'fail'?'checked':''
                    ,'FRONT_NA'      => $data['front_camera'] == 'na'?'checked':''
                    ,'FRONT_NOTES'       => $data['front_camera_notes']
                    ,'REAR_PASS'    => $data['rear_camera'] == 'pass'?'checked':''
                    ,'REAR_FAIL'    => $data['rear_camera'] == 'fail'?'checked':''
                    ,'REAR_NA'      => $data['rear_camera'] == 'na'?'checked':''
                    ,'REAR_NOTES'       => $data['rear_camera_notes']
                    ,'SPEAKER_PASS'    => $data['speaker'] == 'pass'?'checked':''
                    ,'SPEAKER_FAIL'    => $data['speaker'] == 'fail'?'checked':''
                    ,'SPEAKER_NA'      => $data['speaker'] == 'na'?'checked':''
                    ,'SPEAKER_NOTES'       => $data['speaker_notes']
                    ,'MIC_PASS'    => $data['mic'] == 'pass'?'checked':''
                    ,'MIC_FAIL'    => $data['mic'] == 'fail'?'checked':''
                    ,'MIC_NA'      => $data['mic'] == 'na'?'checked':''
                    ,'MIC_NOTES'       => $data['mic_notes']
                    ,'CHARGE_PASS'    => $data['charge'] == 'pass'?'checked':''
                    ,'CHARGE_FAIL'    => $data['charge'] == 'fail'?'checked':''
                    ,'CHARGE_NA'      => $data['charge'] == 'na'?'checked':''
                    ,'CHARGE_NOTES'       => $data['charge_notes']
                    ,'WIFI_PASS'    => $data['wifi'] == 'pass'?'checked':''
                    ,'WIFI_FAIL'    => $data['wifi'] == 'fail'?'checked':''
                    ,'WIFI_NA'      => $data['wifi'] == 'na'?'checked':''
                    ,'WIFI_NOTES'       => $data['wifi_notes']
                    ,'MDM_LOCK'     => $data['mdm_lock'] == '1'?'checked':''
                    ,'ACTIVATION_LOCK'     => $data['activation_lock'] == '1'?'checked':''
                );

                $auditarea1 = $this->parse(SP_ORDER_VIEW_AUDIT_IPAD_1,$auditdata1);
                $auditarea2 = $this->parse(SP_ORDER_VIEW_AUDIT_IPAD_2,$auditdata2);
            /*}elseif($data['is_imac']){

                $oss = '<option></option>';

                foreach ($osx_versions as $os){
                    if ($os == $data['os_version']){
                        $oss .= '<option selected>'.$os.'</option>';
                    }else{
                        $oss .= '<option>'.$os.'</option>';
                    }
                }

                $scratches = array('Minor','Moderate','Major');
                $scratches2 = array('Minor','Major');

                $case_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_scratches']){
                        $case_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_scratches .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cdents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cdents']){
                        $case_cdents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cdents .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_sdents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_sdents']){
                        $case_sdents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_sdents .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_scratches2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_scratches2']){
                        $case_scratches2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_scratches2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cdents2']){
                        $case_cdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cdents2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_sdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_sdents2']){
                        $case_sdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_sdents2 .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_edents = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_edents']){
                        $case_edents .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_edents .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_cracks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cracks']){
                        $case_cracks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cracks .= '<option>'.$scratch.'</option>';
                    }
                }
                $LCD_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['LCD_scratches']){
                        $LCD_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $LCD_scratches .= '<option>'.$scratch.'</option>';
                    }
                }
                $case_keymarks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_keymarks']){
                        $case_keymarks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_keymarks .= '<option>'.$scratch.'</option>';
                    }
                }
                    $lcd_white = '<option></option>';
                foreach ($scratches2 as $scratch2){
                    if ($scratch2 == $data['lcd_white']){
                        $lcd_white .= '<option selected>'.$scratch2.'</option>';
                    }else{
                        $lcd_white .= '<option>'.$scratch2.'</option>';
                    }
                }


                $digi_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['digi_scratches']){
                        $digi_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $digi_scratches .= '<option>'.$scratch.'</option>';
                    }
                }



                $hds_1 = '<option></option>';

                foreach ($hdvolumes as $k => $v){
                    if ($k == $data['hd_1']){
                        $hds_1 .= '<option selected>'.$k.'</option>';
                    }else{
                        $hds_1 .= '<option>'.$k.'</option>';
                    }
                }

                $hds_2 = '<option></option>';

                foreach ($hdvolumes as $k => $v){
                    if ($k == $data['hd_2']){
                        $hds_2 .= '<option selected>'.$k.'</option>';
                    }else{
                        $hds_2 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_1 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_1']){
                        $rams_1 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_1 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_2 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_2']){
                        $rams_2 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_2 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_3 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_3']){
                        $rams_3 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_3 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_4 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_4']){
                        $rams_4 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_4 .= '<option>'.$k.'</option>';
                    }
                }



                $auditdata1 = array(
                    'RH_SCRATCHED'          => $data['rh_scratched'] == 1?'checked':''
                    ,'RH_DENTED'  => $data['rh_dented'] == 1?'checked':''
                    ,'STAND_SCRATCHED'      => $data['stand_scratched'] == 1?'checked':''
                    ,'STAND_DENTED'      => $data['stand_dented'] == 1?'checked':''
                    ,'GLASS_SCRATCHED'            => $data['glass_scratched'] == 1?'checked':''
                    ,'GLASS_CRACKED'            => $data['glass_cracked'] == 1?'checked':''
                    ,'REFURB_NOTES'     => $data['refurb_notes']
                    ,'DIGITIZER_CRACK'    => $data['digitizer_crack'] == 1?'checked':''
                    ,'DIGI_VIDEO'    => $data['digi_video'] == 1?'checked':''
                );

                $auditdata2 = array(
                    'OS'                => $oss
                    ,'HD_1'             => $hds_1
                    ,'HD_2'             => $hds_2
                    ,'RAM_1'            => $rams_1
                    ,'RAM_2'            => $rams_2
                    ,'RAM_3'            => $rams_3
                    ,'RAM_4'            => $rams_4
                    ,'OPTICAL_PASS'     => $data['optical'] == 'pass'?'checked':''
                    ,'OPTICAL_FAIL'     => $data['optical'] == 'fail'?'checked':''
                    ,'OPTICAL_NA'       => $data['optical'] == 'na'?'checked':''
                    ,'OPTICAL_NOTES'    => $data['optical_notes']
                    ,'LCD_PASS'         => $data['lcd'] == 'pass'?'checked':''
                    ,'LCD_FAIL'         => $data['lcd'] == 'fail'?'checked':''
                    ,'LCD_NA'           => $data['lcd'] == 'na'?'checked':''
                    ,'LCD_NOTES'        => $data['lcd_notes']
                    ,'GLASS_PASS'       => $data['glass'] == 'pass'?'checked':''
                    ,'GLASS_FAIL'       => $data['glass'] == 'fail'?'checked':''
                    ,'GLASS_NA'         => $data['glass'] == 'na'?'checked':''
                    ,'GLASS_NOTES'      => $data['glass_notes']
                    ,'ENET_PASS'        => $data['enet'] == 'pass'?'checked':''
                    ,'ENET_FAIL'        => $data['enet'] == 'fail'?'checked':''
                    ,'ENET_NA'          => $data['enet'] == 'na'?'checked':''
                    ,'ENET_NOTES'       => $data['enet_notes']
                    ,'WIFI_PASS'        => $data['wifi'] == 'pass'?'checked':''
                    ,'WIFI_FAIL'        => $data['wifi'] == 'fail'?'checked':''
                    ,'WIFI_NA'          => $data['wifi'] == 'na'?'checked':''
                    ,'WIFI_NOTES'       => $data['wifi_notes']
                    ,'SPEAKERS_PASS'    => $data['speakers'] == 'pass'?'checked':''
                    ,'SPEAKERS_FAIL'    => $data['speakers'] == 'fail'?'checked':''
                    ,'SPEAKERS_NA'      => $data['speakers'] == 'na'?'checked':''
                    ,'SPEAKERS_NOTES'   => $data['speakers_notes']
                    ,'PORTS_PASS'    => $data['ports'] == 'pass'?'checked':''
                    ,'PORTS_FAIL'    => $data['ports'] == 'fail'?'checked':''
                    ,'PORTS_NA'      => $data['ports'] == 'na'?'checked':''
                    ,'PORTS_NOTES'   => $data['ports_notes']
                    ,'ISIGHT_PASS'      => $data['isight'] == 'pass'?'checked':''
                    ,'ISIGHT_FAIL'      => $data['isight'] == 'fail'?'checked':''
                    ,'ISIGHT_NA'        => $data['isight'] == 'na'?'checked':''
                    ,'ISIGHT_NOTES'     => $data['isight_notes']
                );

                $auditarea1 = $this->parse(SP_ORDER_VIEW_AUDIT_IMAC_1,$auditdata1);
                $auditarea2 = $this->parse(SP_ORDER_VIEW_AUDIT_IMAC_2,$auditdata2);*/
            }else{

                $scratches = array('Minor','Moderate','Major');
                $scratches2 = array('Minor','Major');



                $case_scratches2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_scratches2']){
                        $case_scratches2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_scratches2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cdents2']){
                        $case_cdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cdents2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_sdents2 = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_sdents2']){
                        $case_sdents2 .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_sdents2 .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_cracks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_cracks']){
                        $case_cracks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_cracks .= '<option>'.$scratch.'</option>';
                    }
                }

                $case_keymarks = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['case_keymarks']){
                        $case_keymarks .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $case_keymarks .= '<option>'.$scratch.'</option>';
                    }
                }
                $LCD_scratches = '<option></option>';
                foreach ($scratches as $scratch){
                    if ($scratch == $data['LCD_scratches']){
                        $LCD_scratches .= '<option selected>'.$scratch.'</option>';
                    }else{
                        $LCD_scratches .= '<option>'.$scratch.'</option>';
                    }
                }
                $lcd_white = '<option></option>';
                foreach ($scratches2 as $scratch2){
                    if ($scratch2 == $data['lcd_white']){
                        $lcd_white .= '<option selected>'.$scratch2.'</option>';
                    }else{
                        $lcd_white .= '<option>'.$scratch2.'</option>';
                    }
                }



                $oss = '<option></option>';

                foreach ($osx_versions as $os){
                    if ($os == $data['os_version']){
                        $oss .= '<option selected>'.$os.'</option>';
                    }else{
                        $oss .= '<option>'.$os.'</option>';
                    }
				}

				$osVersion = $data['os_version'];

                $hds_1 = '<option></option>';

                foreach ($hdvolumes as $k => $v){
                    if ($k == $data['hd_1']){
                        $hds_1 .= '<option selected>'.$k.'</option>';
                    }else{
                        $hds_1 .= '<option>'.$k.'</option>';
                    }
                }

                $hds_2 = '<option></option>';

                foreach ($hdvolumes as $k => $v){
                    if ($k == $data['hd_2']){
                        $hds_2 .= '<option selected>'.$k.'</option>';
                    }else{
                        $hds_2 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_1 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_1']){
                        $rams_1 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_1 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_2 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_2']){
                        $rams_2 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_2 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_3 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_3']){
                        $rams_3 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_3 .= '<option>'.$k.'</option>';
                    }
                }

                $rams_4 = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    if ($k == $data['ram_4']){
                        $rams_4 .= '<option selected>'.$k.'</option>';
                    }else{
                        $rams_4 .= '<option>'.$k.'</option>';
                    }
                }

                $auditdata1 = array(
                    'TOP_CASE'          => $data['top_case'] == 1?'checked':''
                    ,'DISPLAY_HOUSING'  => $data['display_housing'] == 1?'checked':''
                    ,'BOTTOM_CASE'      => $data['bottom_case'] == 1?'checked':''
                    ,'REFURB_KEYS'      => $data['refurb_keys'] == 1?'checked':''
                    ,'CASE_TRACK'      => $data['case_track'] == 1?'checked':''
                        ,'DIGI_WHITE'      => $data['digi_white'] == 1?'checked':''
                        ,'DIGI_DUST'      => $data['digi_dust'] == 1?'checked':''
                        ,'DIGI_LINES'      => $data['digi_lines'] == 1?'checked':''
                        ,'DIGI_DIS'      => $data['digi_dis'] == 1?'checked':''
                    ,'HINGE'            => $data['hinge'] == 1?'checked':''
                    ,'SCRATCH'            => $data['scratch'] == 1?'checked':''
                    ,'MARKING'            => $data['marking'] == 1?'checked':''
                                                ,'CASE_SCRATCHES2'     => $case_scratches2
                    ,'CASE_SDENTS2'     => $case_sdents2
                    ,'CASE_CDENTS2'     => $case_cdents2
                    ,'CASE_CRACKS'     => $case_cracks
                    ,'LCD_SCRATCHES'     => $LCD_scratches
                    ,'LCD_DUST'     => $lcd_dust
                    ,'LCD_WHITE'     => $lcd_white
                    ,'CASE_KEYMARKS'     => $case_keymarks
                    ,'REFURB_NOTES'     => $data['refurb_notes']
                    ,'AUDIT_SUMMARY'    => $data['audit_summary']
                    ,'DIGITIZER_CRACK'    => $data['digitizer_crack'] == 1?'checked':''
                    ,'DIGI_VIDEO'    => $data['digi_video'] == 1?'checked':''
                    ,'BROKEN_HINGE'    => $data['broken_hinge'] == 1?'checked':''
                    ,'MISSING_FEET'    => $data['missing_feet'] == 1?'checked':''
                    ,'BOOT_FAILURE'    => $data['boot_failure'] == 1?'checked':''
                    ,'HD_FAILURE'    => $data['hd_failure'] == 1?'checked':''
                );

                $auditdata2 = array(
					'OS'                => $oss
					,'OS_VERSION'		=> $osVersion
                    ,'HD_1'             => $hds_1
                    ,'HD_2'             => $hds_2
                    ,'RAM_1'            => $rams_1
                    ,'RAM_2'            => $rams_2
                    ,'RAM_3'            => $rams_3
                    ,'RAM_4'            => $rams_4
                    ,'OPTICAL_PASS'     => $data['optical'] == 'pass'?'checked':''
                    ,'OPTICAL_FAIL'     => $data['optical'] == 'fail'?'checked':''
                    ,'OPTICAL_NA'       => $data['optical'] == 'na'?'checked':''
                    ,'OPTICAL_NOTES'    => $data['optical_notes']
                    ,'LCD_PASS'         => $data['lcd'] == 'pass'?'checked':''
                    ,'LCD_FAIL'         => $data['lcd'] == 'fail'?'checked':''
                    ,'LCD_NA'           => $data['lcd'] == 'na'?'checked':''
                    ,'LCD_NOTES'        => $data['lcd_notes']
                    ,'GLASS_PASS'       => $data['glass'] == 'pass'?'checked':''
                    ,'GLASS_FAIL'       => $data['glass'] == 'fail'?'checked':''
                    ,'GLASS_NA'         => $data['glass'] == 'na'?'checked':''
                    ,'GLASS_NOTES'      => $data['glass_notes']
                    ,'ENET_PASS'        => $data['enet'] == 'pass'?'checked':''
                    ,'ENET_FAIL'        => $data['enet'] == 'fail'?'checked':''
                    ,'ENET_NA'          => $data['enet'] == 'na'?'checked':''
                    ,'ENET_NOTES'       => $data['enet_notes']
                    ,'WIFI_PASS'        => $data['wifi'] == 'pass'?'checked':''
                    ,'WIFI_FAIL'        => $data['wifi'] == 'fail'?'checked':''
                    ,'WIFI_NA'          => $data['wifi'] == 'na'?'checked':''
                    ,'WIFI_NOTES'       => $data['wifi_notes']
                    ,'SPEAKERS_PASS'    => $data['speakers'] == 'pass'?'checked':''
                    ,'SPEAKERS_FAIL'    => $data['speakers'] == 'fail'?'checked':''
                    ,'SPEAKERS_NA'      => $data['speakers'] == 'na'?'checked':''
                    ,'SPEAKERS_NOTES'   => $data['speakers_notes']
                    ,'TRACKPAD_PASS'    => $data['trackpad'] == 'pass'?'checked':''
                    ,'TRACKPAD_FAIL'    => $data['trackpad'] == 'fail'?'checked':''
                    ,'TRACKPAD_NA'      => $data['trackpad'] == 'na'?'checked':''
                    ,'TRACKPAD_NOTES'   => $data['trackpad_notes']
                    ,'PORTS_PASS'    => $data['ports'] == 'pass'?'checked':''
                    ,'PORTS_FAIL'    => $data['ports'] == 'fail'?'checked':''
                    ,'PORTS_NA'      => $data['ports'] == 'na'?'checked':''
                    ,'PORTS_NOTES'   => $data['ports_notes']
                    ,'KEYBOARD_PASS'    => $data['keyboard'] == 'pass'?'checked':''
                    ,'KEYBOARD_FAIL'    => $data['keyboard'] == 'fail'?'checked':''
                    ,'KEYBOARD_NA'      => $data['keyboard'] == 'na'?'checked':''
                    ,'KEYBOARD_NOTES'   => $data['keyboard_notes']
                        ,'BATTERY_PASS'     => $data['battery'] == 'pass'?'checked':''
                    ,'BATTERY_FAIL'     => $data['battery'] == 'fail'?'checked':''
                    ,'BATTERY_NA'       => $data['battery'] == 'na'?'checked':''
                    ,'BATTERY_CYCLES'   => $data['battery_cycles']
                    ,'BATTERY_MAH'      => $data['battery_mah']
                    ,'ISIGHT_PASS'      => $data['isight'] == 'pass'?'checked':''
                    ,'ISIGHT_FAIL'      => $data['isight'] == 'fail'?'checked':''
                    ,'ISIGHT_NA'        => $data['isight'] == 'na'?'checked':''
                    ,'ISIGHT_NOTES'     => $data['isight_notes']
                    ,'MDM_LOCK'     => $data['mdm_lock'] == '1'?'checked':''
                );
                if ($data['is_imac']){
                    $auditarea1 = $this->parse(SP_ORDER_VIEW_AUDIT_IMAC_1,$auditdata1);
                    $auditarea2 = $this->parse(SP_ORDER_VIEW_AUDIT_IMAC_2,$auditdata2);
                }else{
                    $auditarea1 = $this->parse(SP_ORDER_VIEW_AUDIT_MAC_1,$auditdata1);
                    $auditarea2 = $this->parse(SP_ORDER_VIEW_AUDIT_MAC_2,$auditdata2);
                }
            }

            if ($data['is_ipad']){
                $mach1 = $this->get_fields('ds_orders', $data, 1, array('machineType', 'processorSpeed', 'color','serialNumber', 'asset', 'poNumber', 'mac_wifi'));
            }else{
                $mach1 = $this->get_fields('ds_orders', $data, 1, array('machineType', 'processorSpeed', 'color','serialNumber', 'asset', 'poNumber', 'mac_wifi', 'mac_enet'));
			}

			$sqlAsset = $this->getRealSku($data['asset']);

			$sql = "SELECT
					CASE
						WHEN dso.grade_at_audit = 'A' THEN poi.price_a
						WHEN dso.grade_at_audit = 'B' THEN poi.price_b
						WHEN dso.grade_at_audit = 'C' THEN poi.price_c
						WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
						WHEN dso.grade_at_audit = 'F' THEN poi.price_f
					END AS cost
					FROM po_items poi
					LEFT JOIN po_orders por ON por.order_id = poi.order_id
					LEFT JOIN ds_orders dso ON dso.poNumber = por.order_number
					WHERE dso.oNum = '{$data['oNum']}' AND poi.order_number = '$sqlAsset'";

            $cost = $this->db_query($sql, 'select-single');


            $mach1 .= '<tr><td><table><tr><td nowrap="nowrap" style="width:150px;">Cost</td><td>$'.$cost['cost'].'</td></tr></table></td></tr>';

            $parse = array(
                    'ONUM'				=> $oNum
                    , 'MACH'			=> $data['machineType']
                    , 'SPEED'			=> $data['processorSpeed']
                    , 'CUST_ID'			=> $data['customer_id']
                    , 'ADMINS'			=> $admins
                    , 'CART_ITEMS'		=> $cartObj->show_admin($oNum,0,DISABLE_MULTIPLE_ITEMS)
                    , 'DATES'			=> $dates
                    , 'SHIP'			=> $this->get_fields('ds_orders', $data, 1, array('cShipService', 'cShipCompany', 'cShipFname', 'cShipLname', 'cShipAddress1', 'cShipAddress2', 'Shipping City, State, Zip', 'cShipCountry', 'cShipEmail'))
                    , 'BILL'			=> $this->get_fields('ds_orders', $data, 1, array('cBillCompany', 'cBillFname', 'cBillLname', 'cBillAddress1', 'cBillAddress2', 'Billing City, State, Zip', 'cBillCountry'))
                    , 'CONTACT'			=> $this->get_fields('ds_orders', $data, 1, array('cEmail', 'cPhone', 'cPhoneSms', 'cFax', 'cFaxSms'))
                    , 'MACH_0'			=> str_replace('Problem Description', 'Condition Notes',  $this->get_fields('ds_orders', $data, 1, array('problem')))
                    , 'MACH_1'			=> $mach1
                    , 'PRICE'			=> $this->get_fields('ds_orders', $data, 2, array('cSubTotal', 'cDiscount', 'cTax', 'cShipping', 'cpCode', 'cTotal'))
                    , 'NOTES'			=> $this->get_fields('ds_orders', $data, 1, array('cShipInstruct'))
                    , 'TRACK'			=> $this->get_fields('ds_orders', $data, 1, array('ship_tracking_id', 'ship_tracking_id2', 'ship_tracking_id3'))
                    , 'CHARGE_BUTTON'	=> $charge_button
                    , 'CHARGE2_BUTTON'	=> $charge2_button
                    , 'PAID_BUTTON'		=> $paid_button
                    , 'ORDER_NOTES'		=> $searchObj->display_notes($searchObj->search_records('ds_order_notes', $oNum, 'oNumber', 'nID'), false)
                    , 'ORDER_LOGS'		=> $order_logs
                    , 'AUDIT_AREA_1'            => $auditarea1
                    , 'AUDIT_AREA_2'            => $auditarea2
            );
            return $this->parse(SP_ORDER_VIEW, $parse);
        }
	}

	# ADMIN RECEIVING FORM - RETURNS HTML
	function parse_receiving_form($data, $last=array()) {
		global $warehouse_staff, $warehouse_staff_default;

                array_multisort($warehouse_staff);

		$data = $this->get_fields('ds_orders', array(), 1, array('machineType', 'processorSpeed'));
		$dd = array();
		foreach (array_keys($warehouse_staff) as $s) {
			$dd[] = array($s, $warehouse_staff[$s]['name']);
                        if ($s == $warehouse_staff_default){
                            $default = $s;
                        }
		}
		$parse = array(
			'STAFF'			=> $this->arrayToHtmlSelectOptions($dd,false,$default)
			, 'DROPS'		=> $data
		);
		return $this->parse(RECEIVING_BODY, $parse);
	}

	# BUILDS RECEIVING FORM RESPONSE - RETURNS HTML
	function parse_receiving_response($data, $cart) {
		global $orderObj;
		return $orderObj->parse_order(RECEIVING_RESPONSE, $data, array('CART' => $cart));
	}

    function parse_audit_form($data, $last=array()) {
		global $warehouse_staff, $hdvolumes, $ramvolumes, $ipadcapacities, $osx_versions, $zohoObj, $zoho_auth_tokens;

                //set parameters to retrieve invoice numbers for drop down
                /*$parameters = array(
                    'scope'     =>  'crmapi'
                    ,'selectColumns'    =>  'All'//columns to select
                    ,'fromIndex'        =>  1//start record
                    ,'toIndex'          =>  200//end record
                    ,'sortColumnString' =>  'MTS Quote Number'//sort column
                    ,'searchCondition'  =>  '(Status|=|Buyback - Waiting for Machines)'//filter
                );*/

                /*$parameters = array(
                    'scope'     =>  'crmapi'
                    ,'selectColumns'    =>  'All'//columns to select
                    ,'fromIndex'        =>  1//start record
                    ,'toIndex'          =>  200//end record
                    //,'sortColumnString' =>  'MTS Quote Number'//sort column
                    ,'criteria'  =>  '((Status:BB - Waiting for Machines)OR(Status:BB - 5. Arrived - Initial Count Complete))'//filter
                );

                //retrieve records for all users
                foreach($zoho_auth_tokens as $row){
                    //$result = $zohoObj->getSearchRecords($row['authtoken'], $parameters,'Invoices');
                    $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
                    $numberOfRecords = count($result->result->Invoices->row);
                    for ($i = 0; $i < $numberOfRecords; $i++) {
                        //$invoice_nums[$row['prefix'].$result->result->Invoices->row[$i]->FL[0]] = $result->result->Invoices->row[$i]->FL[26];
                        $count = count($result->result->Invoices->row[$i]->FL);
                        for ($j = 0; $j < $count; $j++){
                            if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'MTS Quote Number'){
                                $invoice_nums[$row['prefix'].$result->result->Invoices->row[$i]->FL[0]] = (string)$result->result->Invoices->row[$i]->FL[$j];
                            }
                            if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Status'){
                                $status = (string)$result->result->Invoices->row[$i]->FL[$j];
                            }
                        }
                    }

                }*/

                $sql = 'SELECT po.order_number, COUNT(dso.oID) AS order_count,
                        (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = po.order_number AND cStatus NOT IN("Refurb - Imaged", "Void")) AS audit_count
                        FROM po_orders po
                        LEFT JOIN ds_orders dso ON dso.poNumber = po.order_number
                        WHERE po.status_id = 2
                        GROUP BY po.order_number
                        UNION
                        SELECT po_number AS order_number, 1 AS order_count, 0 AS audit_count
                        FROM po_numbers
                        ORDER BY order_number';

                $po_numbers = $this->db_query($sql, 'select-multiple');

                $zoho_select = '<option></option>';

                //build mts invoice drop down
                foreach($po_numbers as $po_number){
                    if ($po_number['order_count'] >= $po_number['audit_count']){
                        $zoho_select .= '<option>'.$po_number['order_number'].'</option>';
                    }
                }

                $hds = '<option></option>';

                foreach ($hdvolumes as $k => $v){
                    $hds .= '<option>'.$k.'</option>';
                }

                $rams = '<option></option>';

                foreach ($ramvolumes as $k => $v){
                    $rams .= '<option>'.$k.'</option>';
                }

                $oss = '<option></option>';

                foreach ($osx_versions as $os){
                    $oss .= '<option>'.$os.'</option>';
                }

                $capacities = '<option></option>';

                foreach ($ipadcapacities as $capacity){
                    $capacities .= '<option>'.$capacity.'</option>';
                }

                array_multisort($warehouse_staff);

		$data = $this->get_fields('ds_orders', array(), 1, array('machineType', 'processorSpeed'));
		$dd = array();
		foreach (array_keys($warehouse_staff) as $s) {
			$dd[] = array($s, $warehouse_staff[$s]['name']);
				if ($warehouse_staff[$s]['default'] == true){
					$default = $s;
				}
		}
		$dd_printers .= $this->buildPrinterList($_SESSION['printer_id']);

		$parse = array(
			'STAFF'			=> $this->arrayToHtmlSelectOptions($dd,false,$default)
			,'DROPS'		=> $data
			,'HD'                   => $hds
			,'RAM'                  => $rams
			,'INVOICES'             => $zoho_select
			,'OS'                   => $oss
			,'CAPACITY'             => $capacities
			,'PRINTERS'             => $dd_printers
			,'LOADING_MODAL'		=> file_get_contents("templates/loading_modal.html")
		);
		return $this->parse(AUDIT_BODY, $parse);
	}

    function parse_audit_response($submitted,$addlog=true,$imaged=false){

        global $custObj, $orderObj, $hdvolumes, $ramvolumes, $zohoObj, $zoho_auth_tokens;

        $serialNumber = false;

        if (!$imaged){

            $po_order = $this->db_select_single('po_orders', 'zoho_status', array('order_number' => $submitted['poNumber']));

            $sql = 'SELECT COUNT(oID) AS audited,
                (SELECT SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other) FROM po_received por WHERE por.order_id = poo.order_id) AS expected
                FROM ds_orders
                LEFT JOIN po_orders poo ON poo.order_number = ds_orders.poNumber
                LEFT JOIN po_received por ON por.order_id = poo.order_id
                WHERE poNumber = "'.$submitted['poNumber'].'" AND cStatus NOT IN("Refurb - Imaged", "Void")';

            $progress = $this->db_query($sql, 'select-single');

            if ($po_order['zoho_status'] != 'BB - 7. Being Audited' && $progress['audited'] < $progress['expected']){

                /* Bilal: Old code block comment out
                $parameters = array(
                    'scope'     =>  'crmapi'
                    ,'selectColumns'    =>  'All'//columns to select
                    ,'fromIndex'        =>  1//start record
                    ,'toIndex'          =>  200//end record
                    ,'criteria'  =>  '(MTS Quote Number:'.$submitted['poNumber'].')'//filter
                );

                //retrieve records for all users
                foreach($zoho_auth_tokens as $row){
                    $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
                    $numberOfRecords = count($result->result->Invoices->row);
                    for ($i = 0; $i < $numberOfRecords; $i++) {
                        $zoho_id = (string)$result->result->Invoices->row[$i]->FL[0];
                        $authtoken = $row['authtoken'];
                    }
                }

                $zoho_data = array('Status' => 'BB - 7. Being Audited');

                $zohoObj->updateInvoice($authtoken,$zoho_id,$zoho_data);
                    *
                    */

                /* Bilal Modifications */
				if (MODE != 'DEV') {
					$zohoObj->update_record_admin($submitted['poNumber'],'BB - 7. Being Audited');
				}


                $this->db_update('po_orders', 'order_id', $po_order['order_id'], array('zoho_status' => 'BB - 7. Being Audited'));

            }elseif ($po_order['zoho_status'] != 'BB - 8. Audit Complete' && $progress['audited'] >= $progress['expected']) {

                /* Bilal: Old code block comment out
                $parameters = array(
                    'scope'     =>  'crmapi'
                    ,'selectColumns'    =>  'All'//columns to select
                    ,'fromIndex'        =>  1//start record
                    ,'toIndex'          =>  200//end record
                    ,'criteria'  =>  '(MTS Quote Number:'.$submitted['poNumber'].')'//filter
                );

                //retrieve records for all users
                foreach($zoho_auth_tokens as $row){
                    $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
                    $numberOfRecords = count($result->result->Invoices->row);
                    for ($i = 0; $i < $numberOfRecords; $i++) {
                        $zoho_id = (string)$result->result->Invoices->row[$i]->FL[0];
                        $authtoken = $row['authtoken'];
                    }
                }

                $zoho_data = array('Status' => 'BB - 8. Audit Complete');

                $zohoObj->updateInvoice($authtoken,$zoho_id,$zoho_data);
                    *
                    */


                /* Bilal Modifications */
				if (MODE != 'DEV') {
					$zohoObj->update_record_admin($submitted['poNumber'],'BB - 8. Audit Complete');
				}

                $this->db_update('po_orders', 'order_id', $po_order['order_id'], array('zoho_status' => 'BB - 8. Audit Complete'));

            }

        }

        //get customer
        $customer = $custObj->get_data(REFURB_CSTRING);

        //merge customer and submitted arrays
        $data = array_merge($submitted,$customer);

        if ($data['hdnSerialNumber']){
            if ($data['hdnSerialNumber'] != ''){
                $data['serialNumber'] = $data['hdnSerialNumber'];
            }
        }

        $data['asset'] = $data['order_number'];

        //get machine info
        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        // if (strlen($data['serialNumber']) < 13){
        //     $configCode = substr($data['serialNumber'],8);
        // }else{
        //     $configCode = substr($data['serialNumber'],9);
		// }
		$configCode = $data['identifier'];

        $sql = 'select pm.product_model_id, pm.order_number_id, ml.machine_id, ml.machine_description configDescription
                from product_model pm
                left join machine_lookup ml on ml.machine_id = pm.machine_id
                where pm.configCode = "'.$configCode.'" and ml.enabled = 1';

        $machineInfo = $this->db_query($sql, 'select-single');


        if (substr($machineInfo['configDescription'],0,1) == "~"){
            $machineInfo['configDescription'] = substr($machineInfo['configDescription'], 5);
        }

        $data['machineType'] = $machineInfo['configDescription'];

        //check if order number in database
        $sql = 'select order_number_id
                from machine_order_number
                where order_number = "'.$data['asset'].'"';

        $machineOrder = $this->db_query($sql, 'select-single');

        if ($machineOrder){
            if (!$machineInfo['order_number_id']){
                $this->db_update('product_model','product_model_id',$machineInfo['product_model_id'],  array('order_number_id' => $machineOrder['order_number_id']));
            }
        }else{
            $order_number_id = $this->db_insert('machine_order_number',array('order_number' => $data['asset'],'machine_id' => $machineInfo['machine_id']));
            $this->db_update('product_model','product_model_id',$machineInfo['product_model_id'],  array('order_number_id' => $order_number_id));
        }

        if ($submitted['oNum']){
            if ($submitted['oNum'] != ''){
                $oNum = $submitted['oNum'];
            }
		}

		$spPattern = '/^(SP\d{6})$/';

        if (!$oNum && preg_match($spPattern, trim($submitted['serialNumber']))){
            $oNum = $submitted['serialNumber'];
            $order = $this->db_select_single('ds_orders', 'serialNumber', array('oNum' => $oNum));
            $serialNumber = $order['serialNumber'];
        }

        $status = '';

        if (!$oNum || strlen($submitted['serialNumber']) > 8){
            //create the order
            $oNum = $orderObj->create_from_cust($data,REFURB_CSTRING,'',REFURB_PREFIX);

        }

        //update the status to refurb
        if ($data['is_ipad'] != 'false' && strpos($data['grade'], 'D') !== false){
            $status = STATUS_REFURB_NEED_REPAIR_IPAD;
        }elseif(strpos($data['grade'], 'D') !== false){
            $status = STATUS_REFURB_NEED_REPAIR;
        }else{
            $status = STATUS_REFURB_PROCESS;
        }
        $orderObj->update_status($oNum,$status);

        $data['oNum'] = $oNum;

        $audit_data = array(
            'oNum'      =>  $oNum
            ,'end_time' => $this->format_date('db_full')
            ,'data_array'   => serialize($data)
        );

        $this->db_update('audit_log', 'audit_log_id', $data['audit_log_id'], $audit_data);

        # SAVE INFO TO DB
        /*if ($submitted['admin']){
            $note = 'Received by ' . $_SESSION['aUser'] . ' ' . $this->format_date('regular');
        }else{
            $note = 'Received ' . $this->format_date('regular');
        }*/
        $note = 'Received by ' . $_SESSION['aUser'] . ' ' . $this->format_date('regular');

        $note .= "\nSchool/PO#: ".$data['poNumber'];

        $audit_summary = '';


		if ($data['keyboard'] == 'fail'){
			$audit_summary .= 'Keyboard - fail. ';
		}
		if ($data['trackpad'] == 'fail'){
			$audit_summary .= 'Trackpad - fail. ';
		}
		if ($data['optical'] == 'fail'){
			$audit_summary .= 'Optical - fail. ';
		}
		if ($data['lcd'] == 'fail'){
			$audit_summary .= 'Screen - fail. ';
		}
		if ($data['glass'] == 'fail'){
			$audit_summary .= 'Glass - fail. ';
		}
		if ($data['ports'] == 'fail'){
			$audit_summary .= 'Ports - fail. ';
		}
		if ($data['wifi'] == 'fail'){
			$audit_summary .= 'Wifi - fail. ';
		}
		if ($data['speakers'] == 'fail'){
			$audit_summary .= 'Speakers - fail. ';
		}
		if ($data['isight'] == 'fail'){
			$audit_summary .= 'iSight - fail. ';
		}
		if ($data['enet'] == 'fail'){
			$audit_summary .= 'Ethernet port - fail. ';
		}
		if ($data['battery'] == 'fail'){
			$audit_summary .= 'Battery - fail. ';
		}
		if ($data['home_button'] == 'fail'){
			$audit_summary .= 'Home button - fail. ';
		}
		if ($data['volume'] == 'fail'){
			$audit_summary .= 'Volume up/down - fail. ';
		}
		if ($data['sleep_wake'] == 'fail'){
			$audit_summary .= 'Sleep/wake - fail. ';
		}
		if ($data['silent_rot'] == 'fail'){
			$audit_summary .= 'Silent switch - fail. ';
		}
		if ($data['headphone'] == 'fail'){
			$audit_summary .= 'Headphone jack - fail. ';
		}
		if ($data['front_camera'] == 'fail'){
			$audit_summary .= 'Front camera - fail. ';
		}
		if ($data['rear_camera'] == 'fail'){
			$audit_summary .= 'Rear camera - fail. ';
		}
		if ($data['speaker'] == 'fail'){
			$audit_summary .= 'Speaker - fail. ';
		}
		if ($data['mic'] == 'fail'){
			$audit_summary .= 'Microphone - fail. ';
		}
		if ($data['charge'] == 'fail'){
			$audit_summary .= 'Charge - fail. ';
		}
		if ($data['wifi_ipad'] == 'fail'){
			$audit_summary .= 'Wifi - fail. ';
		}
		if ($data['case_scratches'] != ''){
			$audit_summary .= 'Case scratches - '.$data['case_scratches'].'. ';
		}
		if ($data['case_cdents'] != ''){
			$audit_summary .= 'Corner dents - '.$data['case_cdents'].'. ';
		}
		if ($data['case_sdents'] != ''){
			$audit_summary .= 'Surface dents - '.$data['case_sdents'].'. ';
		}
		if ($data['case_scratches2'] != ''){
			$audit_summary .= 'Case scratches - '.$data['case_scratches2'].'. ';
		}
		if ($data['case_cdents2'] != ''){
			$audit_summary .= 'Corner dents - '.$data['case_cdents2'].'. ';
		}
		if ($data['case_sdents2'] != ''){
			$audit_summary .= 'Surface dents - '.$data['case_sdents2'].'. ';
		}
		if ($data['case_edents'] != ''){
			$audit_summary .= 'Edge dents - '.$data['case_edents'].'. ';
		}
			if ($data['case_cracks'] != ''){
			$audit_summary .= 'Case cracks - '.$data['case_cracks'].'. ';
		}
		if ($data['LCD_scratches'] != ''){
			$audit_summary .= 'Screen scratches - '.$data['LCD_scratches'].'. ';
		}
		if ($data['lcd_white'] != ''){
			$audit_summary .= 'White spots - '.$data['lcd_white'].'. ';
		}
		if ($data['lcd_dust'] != ''){
			$audit_summary .= 'Dust/Dirt under glass - '.$data['lcd_dust'].'. ';
		}
		if ($data['case_keymarks'] != ''){
			$audit_summary .= 'Keyboard marks - '.$data['case_keymarks'].'. ';
		}
		if ($data['digi_scratches'] != ''){
			$audit_summary .= 'Screen scratches - '.$data['digi_scratches'].'. ';
		}
		if ($data['digi_dust'] == 1){
			$audit_summary .= 'Dust/Dirt under digitizer. ';
		}
		if ($data['digi_white'] == 1){
			$audit_summary .= 'White spots on screen. ';
		}
		if ($data['digi_lines'] == 1){
			$audit_summary .= 'Lines on screen. ';
		}
		if ($data['hinge'] == 1){
			$audit_summary .= 'Loose hinge. ';
		}
		if ($data['refurb_keys'] == 1){
			$audit_summary .= 'Missing keys. ';
		}
		if ($data['case_track'] == 1){
			$audit_summary .= 'Trackpad misaligned. ';
		}
		if ($data['missing_feet'] == 1){
			$audit_summary .= 'Missing feet. ';
		}
		if ($data['broken_hinge'] == 1){
			$audit_summary .= 'Broken hinge. ';
		}
		if ($data['digi_un'] == 1){
			$audit_summary .= 'Touchscreen unresponsive. ';
		}
		if ($data['digi_dis'] == 1){
			$audit_summary .= 'Screen discolored. ';
		}
		if ($data['digi_sep'] == 1){
			$audit_summary .= 'Digitizer separation. ';
		}
		if ($data['digi_touch'] == 1){
			$audit_summary .= 'LCD/Digi touching. ';
		}
		if ($data['digi_video'] == 1){
			$audit_summary .= 'Video issue. ';
		}
		if ($data['digitizer_crack'] == 1){
			$audit_summary .= 'Cracked screen. ';
		}
		if ($data['marking'] == 1){
			$audit_summary .= 'Engraving/Permanent Markings. ';
		}
		if ($data['boot_failure_osx'] == 1){
			$audit_summary .= 'Logic failure. ';
		}
		if ($data['boot_failure_ipad'] == 1){
			$audit_summary .= 'Logic failure. ';
		}
		if ($data['hd_failure_osx'] == 1){
			$audit_summary .= 'HD failure. ';
		}
		if ($data['refurb_notes'] != ''){
			$audit_summary .= $data['refurb_notes'].'.';
		}


        if ($data['is_ipad'] != 'true' && $data['is_imac'] != 'true'){
            $updates = array(
                    'machineType'			=> $data['machineType']
                    , 'serialNumber'		=> $serialNumber?$serialNumber:$data['serialNumber']
                    , 'grade'           => $data['grade']
					,'grade_at_audit'             => $data['grade']
                    , 'poNumber'        => trim($data['poNumber'])
                    , 'cStatus'				=> $imaged?STATUS_REFURB_IMAGED:$status
                    , 'dateMachineReceived'	=> $this->format_date('db_date')
                    , 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
                    , 'top_case'                => $data['top_case']
                    , 'display_housing'         => $data['display_housing']
                    , 'bottom_case'             => $data['bottom_case']
                    , 'refurb_keys'             => $data['refurb_keys']
                    , 'case_track'             => $data['case_track']
                        , 'digi_white'             => $data['digi_white']
                        , 'digi_dust'         => $data['digi_dust']
                        , 'digi_lines'         => $data['digi_lines']
                        ,'digi_dis'      => $data['digi_dis']
                                            ,'digitizer_crack'      => $data['digitizer_crack']
                        , 'case_cracks'         => $data['case_cracks']
                        , 'case_scratches'         => $data['case_scratches']
                        , 'LCD_scratches'         => $data['LCD_scratches']
                        , 'lcd_dust'         => $data['lcd_dust']
                        , 'lcd_white'         => $data['lcd_white']
                        , 'case_keymarks'         => $data['case_keymarks']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                        , 'case_scratches2'         => $data['case_scratches2']
                        , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                        , 'audit_summary'           => $audit_summary
                    , 'hinge'                   => $data['hinge']
                    , 'refurb_notes'            => $data['refurb_notes']
                    , 'hd_1'                    => $data['hd_1']
                    , 'hd_2'                    => $data['hd_2']
                    , 'ram_1'                   => $data['ram_1']
                    , 'ram_2'                   => $data['ram_2']
                    , 'ram_3'                   => $data['ram_3']
                    , 'ram_4'                   => $data['ram_4']
                    , 'optical'                 => $data['optical']
                    , 'optical_notes'           => $data['optical_notes']
                    , 'lcd'                     => $data['lcd']
                    , 'lcd_notes'               => $data['lcd_notes']
                    , 'glass'                   => $data['glass']
                    , 'glass_notes'             => $data['glass_notes']
                    , 'enet'                    => $data['enet']
                    , 'enet_notes'              => $data['enet_notes']
                    , 'wifi'                    => $data['wifi']
                    , 'wifi_notes'              => $data['wifi_notes']
                    , 'speakers'                => $data['speakers']
                    , 'scratch'                => $data['scratch']
                    , 'marking'                => $data['marking']
                    , 'case_sdents'         => $data['case_sdents']
                    , 'trackpad'                => $data['trackpad']
                    , 'trackpad_notes'                => $data['trackpad_notes']
                    , 'keyboard'                => $data['keyboard']
                    , 'keyboard_notes'                => $data['keyboard_notes']
                    , 'ports'                => $data['ports']
                    , 'ports_notes'                => $data['ports_notes']
                    , 'speakers_notes'          => $data['speakers_notes']
                    , 'battery'                 => $data['battery']
                    , 'battery_cycles'          => $data['battery_cycles']
                    , 'battery_mah'             => $data['battery_mah']
                    , 'isight'                  => $data['isight']
                    , 'isight_notes'            => $data['isight_notes']
                    , 'os_version'              => $data['os_version']
                    , 'boot_failure'            => $data['boot_failure_osx']
                    , 'hd_failure'              => $data['hd_failure_osx']
                    , 'asset'                   => $data['order_number']
                    , 'missing_feet'            => $data['missing_feet']
                    , 'broken_hinge'            => $data['broken_hinge']
                    , 'digi_video'         => $data['digi_video']
					, 'mdm_lock'                => $data['mdm_lock']
					, 'audit_mdm_lock'                => $data['audit_mdm_lock']?$data['audit_mdm_lock']:$data['mdm_lock']

                );
        }elseif ($data['is_imac'] == 'true'){
            $updates = array(
                    'machineType'			=> $data['machineType']
                    , 'serialNumber'		=> $serialNumber?$serialNumber:$data['serialNumber']
                    , 'grade'           => $data['grade']
					,'grade_at_audit'             => $data['grade']
                    , 'poNumber'        => $data['poNumber']
                    , 'cStatus'				=> $imaged?STATUS_REFURB_IMAGED:$status
                    , 'dateMachineReceived'	=> $this->format_date('db_date')
                    , 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
                    , 'rh_scratched'                => $data['rh_scratched']
                    , 'rh_dented'         => $data['rh_dented']
                    , 'stand_scratched'             => $data['stand_scratched']
                    , 'stand_dented'             => $data['stand_dented']
                    , 'glass_scratched'                   => $data['glass_scratched']
                    , 'glass_cracked'                   => $data['glass_cracked']
                    , 'refurb_notes'            => $data['refurb_notes']
                        , 'audit_summary'           => $audit_summary
                    , 'hd_1'                    => $data['hd_1']
                    , 'hd_2'                    => $data['hd_2']
                    , 'ram_1'                   => $data['ram_1']
                    , 'ram_2'                   => $data['ram_2']
                    , 'ram_3'                   => $data['ram_3']
                    , 'ram_4'                   => $data['ram_4']
                    , 'optical'                 => $data['optical']
                    , 'optical_notes'           => $data['optical_notes']
                    , 'lcd'                     => $data['lcd']
                    , 'lcd_notes'               => $data['lcd_notes']
                    , 'glass'                   => $data['glass']
                    , 'glass_notes'             => $data['glass_notes']
                    , 'enet'                    => $data['enet']
                    , 'enet_notes'              => $data['enet_notes']
                    , 'wifi'                    => $data['wifi']
                    , 'wifi_notes'              => $data['wifi_notes']
                    , 'speakers'                => $data['speakers']
                    , 'ports'                => $data['ports']
                    , 'ports_notes'                => $data['ports_notes']
                    , 'speakers_notes'          => $data['speakers_notes']
                    , 'isight'                  => $data['isight']
                    , 'isight_notes'            => $data['isight_notes']
                    , 'os_version'              => $data['os_version']
                    , 'boot_failure'            => $data['boot_failure_osx']
                    , 'hd_failure'            => $data['hd_failure_osx']
                    , 'asset'                   => $data['order_number']
                    , 'is_imac'                 => 1
                    , 'case_track'             => $data['case_track']
                    , 'digi_white'             => $data['digi_white']
                    , 'digi_dust'         => $data['digi_dust']
                    , 'digi_lines'         => $data['digi_lines']
                    ,'digi_dis'      => $data['digi_dis']
                    ,'digitizer_crack'      => $data['digitizer_crack']
                    , 'case_cracks'         => $data['case_cracks']
                    , 'case_scratches'         => $data['case_scratches']
                    , 'LCD_scratches'         => $data['LCD_scratches']
                    , 'lcd_dust'         => $data['lcd_dust']
                    , 'lcd_white'         => $data['lcd_white']
                    , 'case_keymarks'         => $data['case_keymarks']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                    , 'case_scratches2'         => $data['case_scratches2']
                    , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                    , 'marking'         => $data['marking']
                    , 'digi_video'         => $data['digi_video']
					, 'mdm_lock'                => $data['mdm_lock']
					, 'audit_mdm_lock'                => $data['audit_mdm_lock']?$data['audit_mdm_lock']:$data['mdm_lock']

                );
        }else{
            $updates = array(
                    'machineType'			=> $data['machineType']
                    , 'serialNumber'		=> $serialNumber?$serialNumber:$data['serialNumber']
                    , 'grade'           => $data['grade']
					,'grade_at_audit'             => $data['grade']
                    , 'poNumber'        => $data['poNumber']
                    , 'cStatus'				=> $imaged?STATUS_REFURB_IMAGED:$status
                    , 'dateMachineReceived'	=> $this->format_date('db_date')
                    , 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
                    , 'digitizer_scratch'       => $data['digitizer_scratch']
                    , 'digitizer_crack'         => $data['digitizer_crack']
                    , 'digi_dust'         => $data['digi_dust']
                    , 'digi_scratches'         => $data['digi_scratches']
                    , 'digi_white'         => $data['digi_white']
                    , 'marking'         => $data['marking']
                    , 'digi_lines'         => $data['digi_lines']
                    , 'digi_un'         => $data['digi_un']
                    , 'digi_dis'         => $data['digi_dis']
                    , 'digi_sep'         => $data['digi_sep']
                    , 'digi_touch'         => $data['digi_touch']
                    , 'digi_video'         => $data['digi_video']
                    , 'case_scratches'         => $data['case_scratches']
                    , 'case_scratches2'         => $data['case_scratches2']
                        , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                    , 'case_edents'         => $data['case_edents']
                    , 'case_cracks'         => $data['case_cracks']
                    , 'lcd_crack'               => $data['lcd_crack']
                    , 'case_scratch'            => $data['case_scratch']
                    , 'LCD_scratches'         => $data['LCD_scratches']
                    , 'lcd_dust'         => $data['lcd_dust']
                        , 'lcd_white'         => $data['lcd_white']
                        , 'case_keymarks'         => $data['case_keymarks']
                    , 'case_dent'               => $data['case_dent']
                    , 'refurb_notes'            => $data['refurb_notes']
                    , 'home_button'             => $data['home_button']
                    , 'home_button_notes'       => $data['home_button_notes']
                    , 'volume'                  => $data['volume']
                    , 'volume_notes'            => $data['volume_notes']
                    , 'sleep_wake'              => $data['sleep_wake']
                    , 'sleep_wake_notes'        => $data['sleep_wake_notes']
                    , 'silent_rot'              => $data['silent_rot']
                    , 'silent_rot_notes'        => $data['silent_rot_notes']
                    , 'headphone'               => $data['headphone']
                    , 'headphone_notes'         => $data['headphone_notes']
                    , 'front_camera'            => $data['front_camera']
                    , 'front_camera_notes'      => $data['front_camera_notes']
                    , 'rear_camera'             => $data['rear_camera']
                    , 'rear_camera_notes'       => $data['rear_camera_notes']
                    , 'speaker'                 => $data['speaker']
                    , 'speaker_notes'           => $data['speaker_notes']
                    , 'wifi'                    => $data['wifi_ipad']
                    , 'wifi_notes'              => $data['wifi_ipad_notes']
                    , 'mic'                     => $data['mic']
                    , 'mic_notes'               => $data['mic_notes']
                    , 'charge'                  => $data['charge']
                    , 'charge_notes'            => $data['charge_notes']
                    , 'os_version'              => $data['os_version']
                    , 'boot_failure'            => $data['boot_failure_ipad']
                    , 'is_ipad'                 => '1'
                    , 'asset'                   => $data['order_number']
                    , 'capacity'                => $data['capacity']
                    , 'activation_lock'         => $data['activation_lock']
                    , 'mdm_lock'                => $data['mdm_lock']
                    , 'audit_activation_lock'         => $data['audit_activation_lock']?$data['audit_activation_lock']:$data['activation_lock']
                    , 'audit_mdm_lock'                => $data['audit_mdm_lock']?$data['audit_mdm_lock']:$data['mdm_lock']
                    , 'audit_summary'           => $audit_summary
                    , 'color'                   => $data['color']
                );

        }

        #UPDATE DB
        $this->db_update('ds_orders', 'oNum', $oNum, $updates);

        $log = 'Audited by '.$_SESSION['aUser'].', Grade '.$data['grade'];

        if ($addlog){
            $orderObj->insert_log($oNum,'',$log);


            $sql = 'insert into audit_summary (start_time, aID, aUser, serialNumber, model_number, grade, audit_time, order_number, product_type)
                    select al.start_time, al.aID, da.aUser, dr.serialNumber, ml.model_number, dr.grade, timediff(al.end_time,al.start_time) audit_time,
                    (select order_number from machine_order_number where machine_id = pm.machine_id limit 1) order_number,
                    CASE
                        WHEN UPPER(ml.product_line) LIKE "MACBOOK%" THEN "MACBOOK"
                        WHEN UPPER(ml.product_line) = "IPAD" THEN "IPAD"
                        WHEN UPPER(ml.product_line) = "IMAC" THEN "IMAC"
                    END AS product_type
                    from audit_log al
                    left join ds_admins da on da.aID = al.aID
                    left join ds_orders dr on dr.oNum = al.oNum
                    left join product_model pm on pm.configCode = substring(dr.serialNumber,9)-- OR pm.configCode = substring(dr.serialNumber,length(dr.serialNumber)-3)
                    left join machine_lookup ml on ml.machine_id = pm.machine_id
                    where al.end_time != "" and al.oNum = "'.$oNum.'"';

            $this->db_query($sql, 'insert');

        }

        $labelarray = array(
            'machineType'   =>  $data['machineType']
            ,'asset'	=>  $data['order_number']
            ,'grade'        =>  $data['grade']
            ,'problem'      =>  $data['problem']
                , 'refurb_notes'            => $data['refurb_notes']
            ,'poNumber'     =>  $data['poNumber']
            ,'date'         =>  $this->format_date('templ_date')
            ,'short_date'   =>  $this->format_date('short')
            ,'serialNumber' =>  $serialNumber?$serialNumber:$data['serialNumber']
            ,'oNum'         =>  $oNum
        );

        if ($data['hd_1'] != ''){
            $hdtotal = (int)$hdvolumes[$data['hd_1']];
        }

        if ($data['hd_2'] != ''){
            $hdtotal += (int)$hdvolumes[$data['hd_2']];
        }

        if ($hdtotal < 1024){
            $hdstr = $hdtotal.'GB';
        }else{
            $hdstr = round((float)($hdtotal/1024),1).'TB';
        }

        if ($data['ram_1'] != ''){
            $ramtotal = (int)$ramvolumes[$data['ram_1']];
        }

        if ($data['ram_2'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_2']];
        }

        if ($data['ram_3'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_3']];
        }

        if ($data['ram_4'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_4']];
        }

        if ($ramtotal < 1024){
            $ramstr = $ramtotal.'MB';
        }else{
            $ramstr = round((float)($ramtotal/1024),1).'GB';
        }

        if ($data['is_ipad'] != 'true'){
            $auditarray = array(
                'grade'             => $data['grade']
                ,'grade_at_audit'             => $data['grade']
                ,'top_case'         => $data['top_case']
                ,'display_housing'  => $data['display_housing']
                ,'bottom_case'      => $data['bottom_case']
                ,'hd'               => $hdstr
                ,'keys'             => $data['refurb_keys']
                    ,'case_track'             => $data['case_track']
                ,'digi_white'             => $data['digi_white']
                ,'digi_dust'             => $data['digi_dust']
                ,'digi_dis'             => $data['digi_dis']
                , 'case_cracks'         => $data['case_cracks']
                , 'LCD_scratches'         => $data['LCD_scratches']
                , 'lcd_dust'         => $data['lcd_dust']
                        , 'lcd_white'         => $data['lcd_white']
                        , 'case_keymarks'         => $data['case_keymarks']
                , 'case_scratches'         => $data['case_scratches']
                , 'case_scratches2'         => $data['case_scratches2']
                        , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                ,'hinge'            => $data['hinge']
                ,'optical'          => $data['optical']
                ,'ram'              => $ramstr
                ,'lcd'              => $data['lcd']
                ,'wifi'             => $data['wifi']
                ,'speakers'         => $data['speakers']
                ,'os_version'       => $data['os_version']
                ,'battery'          => $data['battery']
                ,'isight'           => $data['isight']
                ,'enet'             => $data['enet']
                ,'keyboard'         => $data['keyboard']
                , 'refurb_notes'           => $audit_summary
                , 'boot_failure'            => $data['boot_failure_osx']
                , 'mdm_lock'                => $data['mdm_lock']
                ,'is_ipad'          => false
            );
        }else{
            $auditarray = array(
                'grade'             => $data['grade']
                ,'grade_at_audit'             => $data['grade']
                ,'lcd'              => $data['lcd_crack']
                ,'digitizer_scratch'    => $data['digitizer_scratch']
                ,'digitizer_crack'      => $data['digitizer_crack']
                ,'digi_dust'      => $data['digi_dust']
                , 'digi_scratches'         => $data['digi_scratches']
                    , 'digi_white'         => $data['digi_white']
                    , 'marking'         => $data['marking']
                    , 'digi_lines'         => $data['digi_lines']
                    , 'digi_un'         => $data['digi_un']
                    , 'digi_dis'         => $data['digi_dis']
                    , 'digi_sep'         => $data['digi_sep']
                    , 'digi_touch'         => $data['digi_touch']
                    , 'digi_video'         => $data['digi_video']
                    , 'case_scratches'         => $data['case_scratches']
                    , 'case_scratches2'         => $data['case_scratches2']
                        , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                    , 'case_edents'         => $data['case_edents']
                    , 'case_cracks'         => $data['case_cracks']
                    , 'LCD_scratches'         => $data['LCD_scratches']
                    , 'lcd_dust'         => $data['lcd_dust']
                        , 'lcd_white'         => $data['lcd_white']
                    , 'case_keymarks'         => $data['case_keymarks']
                ,'case_scratch'         => $data['case_scratch']
                ,'case_crack'           => $data['case_crack']
                ,'case_dent'            => $data['case_dent']
                ,'os_version'           => $data['os_version']
                ,'charge'               => $data['charge']
                ,'sleep_wake'           => $data['sleep_wake']
                ,'mic'                  => $data['mic']
                ,'home_button'          => $data['home_button']
                ,'volume'               => $data['volume']
                ,'silent_rot'           => $data['silent_rot']
                ,'headphone'            => $data['headphone']
                ,'wifi'                 => $data['wifi_ipad']
                ,'front_camera'         => $data['front_camera']
                ,'rear_camera'          => $data['rear_camera']
                ,'speaker'              => $data['speaker']
                    ,'capacity'              => $data['capacity']
                    , 'refurb_notes'            => $audit_summary
                , 'activation_lock'         => $data['activation_lock']
                , 'mdm_lock'                => $data['mdm_lock']
                , 'boot_failure'            => $data['boot_failure_ipad']
                ,'is_ipad'              => true
            );
        }

        $printer_id = $data['printer_set'];

		$printer = $this->db_select_single('printers', '*', array('printer_id' => $printer_id));

		//Check if we're working with an iMac/MacBook. If so, get processor data.
		if ($data['is_ipad'] != '1') {
			$labelarray = array_merge($labelarray, $this->get_processor_data($data['serialNumber']));
		}

        # PRINT CHECKIN AND LABELS
        if (MODE == 'PROD' || MODE == 'DEV') {

            //$this->print_refurb_label($labelarray, constant($printer['printer_queue']));

                $this->print_refurb_label_large(array_merge($labelarray, $auditarray), constant($printer['printer_queue']));
            //$this->print_refurb_label_large($labelarray, ZEBRA_REFURB_PRINTER_LARGE);
            //$this->print_audit_label($auditarray, constant($printer['printer_queue']));

        }

        # PRINT CHECKIN AND LABELS
        /*if (MODE == 'PROD' || MODE == 'DEV') {


                if ($aRefurbPrinter == 'Refurb Station'){
                    $orderObj->queue_print($oNum, REFURB_PRINTER, 'checkin',$_SESSION['aUser']);
                }else{
                    $orderObj->queue_print($oNum, SLIP_PRINTER, 'checkin',$_SESSION['aUser']);
                }
                if ($_SESSION['aUser'] == 'audit2'){
                    $this->print_refurb_label($labelarray, ZEBRA_REFURB2_PRINTER);
                    $this->print_refurb_label_large($labelarray, ZEBRA_REFURB_PRINTER_LARGE);
                    $this->print_audit_label($auditarray, ZEBRA_REFURB2_PRINTER);
                }else{
                    $this->print_refurb_label($labelarray, ZEBRA_REFURB_PRINTER);
                    $this->print_refurb_label_large($labelarray, ZEBRA_REFURB_PRINTER_LARGE);
                    $this->print_audit_label($auditarray, ZEBRA_REFURB_PRINTER);
                }
        }*/

        return $oNum;

    }

    # ADMIN RECEIVING FORM - RETURNS HTML
	function parse_refurbishing_form() {
		global $warehouse_staff;

                array_multisort($warehouse_staff);

		$data = $this->get_fields('ds_orders', array(), 1, array('machineType', 'processorSpeed'));
		$dd = array();
		foreach (array_keys($warehouse_staff) as $s) {
			$dd[] = array($s, $warehouse_staff[$s]['name']);
                        if ($warehouse_staff[$s]['default'] == true){
                            $default = $s;
                        }
		}

                $ds_admins = $this->db_select_single('ds_admins', 'aRefurbPrinter', array('aUser' => $_SESSION['aUser']));

                if ($ds_admins['aRefurbPrinter'] == 'Refurb Station'){
                    $printer_set = '<option selected>Refurb Station</option><option>Warehouse 1</option>';
                }else{
                    $printer_set = '<option>Refurb Station</option><option selected>Warehouse 1</option>';
                }

                for ($i = 1;$i <= 15;$i++){

                    $refurb_lines .= '
                        <tr>
                                <td>Serial #</td>
                                <td>
                                    <input class="borderless" type="text" name="serialNumber'.$i.'" id="serialNumber'.$i.'" onchange="getGSXInfo(this,'.$i.');" />
                                </td>
                                <td>
                                    <input type="text" class="borderless" name="orderNumber'.$i.'" id="orderNumber'.$i.'" readonly onblur="hideSearch('.$i.');" />
                                </td>
                                <td id="searchLink'.$i.'" name="searchLink'.$i.'"></td>
                                <td>
                                    <input type="text" class="borderless" style="width:400px;" name="problem'.$i.'" id="problem'.$i.'" />
                                </td>
                                <td>
                                    <select id="grade'.$i.'" name="grade'.$i.'">
                                        <option></option>
                                        <option>A</option>
                                        <option>B</option>
                                        <option>C</option>
                                        <option>D</option>
                                        <option>F</option>
                                    </select>
                                </td>
                        </tr>';
                }

		$parse = array(
			'STAFF'			=> $this->arrayToHtmlSelectOptions($dd,false,$default)
			, 'DROPS'		=> $data
                        ,'PRINTER_SET'          => $printer_set
                        ,'REFURB_LINES'         => $refurb_lines
		);
		return $this->parse(REFURBISHING_BODY, $parse);
	}

    //returns response message
    function parse_refurbishing_response($oNum,$data) {

            $parse = array(
                'ONUM'      =>  $oNum,
                'MACHINE'   =>  $data['machineType'],
                'PROCESSOR' =>  $data['processorSpeed'],
                'SERIAL'    =>  $data['serialNumber']
            );

        return $this->parse(REFURBISHING_RESPONSE, $parse);
	}

    # add refurbish order
    // function refurbishing($submitted){
    //     global $custObj, $orderObj, $warehouse_staff;

    //     /*$error_msg = '';

    //     if ($submitted['machineType']  == ''){
    //         $error_msg .= '<font color="red">Please select a machine type</font><br />';
    //     }

    //     if ($submitted['serialNumber'] == ''){
    //         $error_msg .= '<font color="red">Please enter a serial #</font><br />';
    //     }

    //     if ($error_msg != ''){
    //         echo $error_msg;
    //         return false;
    //     }*/

    //     //get customer
    //     $customer = $custObj->get_data(REFURB_CSTRING);

    //     //merge customer and submitted arrays
    //     $data = array_merge($submitted,$customer);

    //     //create the order
    //     $oNum = $orderObj->create_from_cust($data,REFURB_CSTRING,'',REFURB_PREFIX);

    //     //update the status to refurb
    //     $orderObj->update_status($oNum,STATUS_REFURB_PROCESS);
    //     $data['oNum'] = $oNum;

    //     # GSX CHECK WARRANTY COVERAGE
    //     /*$oWarranty = 'N';
    //     $warrantyEndDate = '';
    //     $warrantyStatus = '';
    //     $daysRemaining = 0;
    //     if ($submitted['serialNumber']) {
    //             $gsxObj->check_warranty_status($submitted['serialNumber']);
    //             if ($gsxObj->get_warranty_end_timestamp() > time() + (86400 * 2)) {
    //                     $oWarranty = 'Y';
    //                     $warrantyEndDate = $this->format_date('db_date', $gsxObj->get_warranty_end_timestamp());
    //                     $warranty_status = $gsxObj->get_warranty_status($submitted['serialNumber']);
    //                     $warrantyStatus = $warranty_status['warrantyStatus'];
    //                     $daysRemaining = intval($warranty_status['daysRemaining']);
    //             }
    //     }*/

    //     # SAVE INFO TO DB
    //     if ($submitted['admin']){
    //         $note = 'Received by ' . $submitted['admin'] . ' ' . $this->format_date('regular');
    //     }else{
    //         $note = 'Received ' . $this->format_date('regular');
    //     }
    //     $updates = array(
    //             'machineType'			=> $data['machineType']
    //             , 'processorSpeed'		=> $data['processorSpeed']
    //             , 'serialNumber'		=> $data['serialNumber']
    //             , 'asset'		=> $data['asset']
    //             , 'oOSDisks'			=> $data['oOSDisks']
    //             , 'oACAdapter'			=> $data['oACAdapter']
    //             , 'cStatus'				=> STATUS_REFURB_PROCESS
    //             , 'dateMachineReceived'	=> $this->format_date('db_date')
    //             , 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
    //             , 'oWarranty'			=> $submitted['oWarranty']
    //             , 'warrantyEndDate'		=> $submitted['warrantyEndDate']
    //             , 'warrantyStatus'              => $submitted['warrantyStatus']
    //             , 'daysRemaining'               => $submitted['daysRemaining']
    //     );

    //     #UPDATE DB
    //     $this->db_update('ds_orders', 'oNum', $oNum, $updates);

    //     //parse response message
    //     echo $this->parse_refurbishing_response($oNum,$data);

    //     # PRINT CHECKIN AND LABELS
    //     if (MODE == 'PROD' || MODE == 'DEV') {
    //             $orderObj->print_slip($oNum, $warehouse_staff[$submitted['admin']]['print'], 'checkin');
    //             system('convert -size 288x144 xc:white -font Helvetica-Bold -pointsize 24 '
    //                     . '-draw "text 0,144 \'' . strtoupper($submitted['oNum'])
    //                     . '\'" /tmp/' . $submitted['oNum'] . '.png', $retval);
    //             for ($i = 0; $i < $submitted['num_labels']; $i++) {
    //                     $this->send_printer(LABEL_PRINTER, '/tmp/' . $submitted['oNum'] . '.png');
    //             }
    //             /*$this->print_labels(array($oNum), 1, 1, ZEBRA_LABEL_PRINTER, true);
    //             $this->print_labels(array($data['asset']), 1, 1, ZEBRA_LABEL_PRINTER, false);
    //             $this->print_labels(array($data['serialNumber']), 1, 1, ZEBRA_LABEL_PRINTER, true);*/
    //             $this->print_refurb_label(array('oNum' => $oNum,'asset' => $data['asset'],'serialNumber' => $data['serialNumber']), ZEBRA_LABEL_PRINTER);
    //     }

    // }

    function refurbishing($submitted){

        global $searchObj;


        for ($i=1;$i<=15;$i++){

            if ($submitted['serialNumber'.$i] != ''){
                $data['admin'] = $submitted['admin'];
                $data['serialNumber'] = $submitted['serialNumber'.$i];
                $data['asset'] = $submitted['orderNumber'.$i];
                $data['problem'] = $submitted['problem'.$i];
                $data['grade'] = $submitted['grade'.$i];
                $data['poNumber'] = $submitted['schoolPO'];
                $data['schoolPO'] = $submitted['schoolPO'];
                $this->refurbishing_item($data);
            }
        }

        //if this is the final batch, we'll generate the CSV to mail to Justin
        if ($_POST['finalBatch']){

            $csvstr = $searchObj->export_refurb($submitted['schoolPO']);

            file_put_contents(UPS_LABEL_PATH.'refurb.csv', $csvstr);

            $this->send_email(MANAGER_EMAIL,INFO_FROM,'Refurb Order# '.$submitted['schoolPO'],'','text/html',array($csvstr));

        }

        $this->db_update('ds_admins','aUser',$_SESSION['aUser'],array('aRefurbPrinter' => $_POST['PrinterSet']));

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse_refurbishing_form()));
    }

    function refurbishing_item($submitted){
        global $custObj, $orderObj;


        //get customer
        $customer = $custObj->get_data(REFURB_CSTRING);

        //merge customer and submitted arrays
        $data = array_merge($submitted,$customer);

        //get machine info
        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        if (strlen($serialNumber) < 13){
            $configCode = substr($serialNumber,8);
        }else{
            $configCode = substr($serialNumber,9);
        }

        $sql = 'select pm.product_model_id, pm.order_number_id, ml.machine_id, ml.machine_description configDescription
                from product_model pm
                left join machine_lookup ml on ml.machine_id = pm.machine_id
                where pm.configCode = "'.$configCode.'"';

        $machineInfo = $this->db_query($sql, 'select-single');


        if (substr($machineInfo['configDescription'],0,1) == "~"){
            $machineInfo['configDescription'] = substr($machineInfo['configDescription'], 5);
        }

        $data['machineType'] = $machineInfo['configDescription'];

        //check if order number in database
        $sql = 'select order_number_id
                from machine_order_number
                where order_number = "'.$data['asset'].'"';

        $machineOrder = $this->db_query($sql, 'select-single');

        if ($machineOrder){
            if (!$machineInfo['order_number_id']){
                $this->db_update('product_model','product_model_id',$machineInfo['product_model_id'],  array('order_number_id' => $machineOrder['order_number_id']));
            }
        }else{
            $order_number_id = $this->db_insert('machine_order_number',array('order_number' => $data['asset'],'machine_id' => $machineInfo['machine_id']));
            $this->db_update('product_model','product_model_id',$machineInfo['product_model_id'],  array('order_number_id' => $order_number_id));
        }
        //create the order
        $oNum = $orderObj->create_from_cust($data,REFURB_CSTRING,'',REFURB_PREFIX);

        //update the status to refurb
        $orderObj->update_status($oNum,STATUS_REFURB_PROCESS);
        $data['oNum'] = $oNum;

        # SAVE INFO TO DB
        if ($submitted['admin']){
            $note = 'Received by ' . $submitted['admin'] . ' ' . $this->format_date('regular');
        }else{
            $note = 'Received ' . $this->format_date('regular');
        }
        $note .= "\nSchool/PO#: ".$data['schoolPO'];

        $updates = array(
                'machineType'			=> $data['machineType']
                , 'serialNumber'		=> $data['serialNumber']
                , 'asset'		=> $data['asset']
                , 'problem'         => $data['problem']

                , 'grade'           => $data['grade']
                , 'poNumber'        => $data['poNumber']
                , 'cStatus'				=> STATUS_REFURB_PROCESS
                , 'dateMachineReceived'	=> $this->format_date('db_date')
                , 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
            );

        #UPDATE DB
        $this->db_update('ds_orders', 'oNum', $oNum, $updates);

        $ds_admins = $this->db_select_single('ds_admins', 'aRefurbPrinter', array('aUser' => $_SESSION['aUser']));

        $aRefurbPrinter = $ds_admins['aRefurbPrinter'];

        $labelarray = array(
            'machineType'   =>  $data['machineType']
            ,'asset'	=>  $data['asset']
            ,'grade'        =>  $data['grade']
            ,'problem'      =>  $data['problem']
            , 'refurb_notes'            => $data['refurb_notes']
            , 'capacity'                => $data['capacity']
            ,'poNumber'     =>  $data['poNumber']
            ,'date'         =>  $this->format_date('templ_date')
            ,'serialNumber' =>  $data['serialNumber']
            ,'oNum'         =>  $oNum
		);

		//Check if we're working with an iMac/MacBook. If so, get processor data.
		if ($data['is_ipad'] != '1') {
			$labelarray = array_merge($labelarray, $this->get_processor_data($data['serialNumber']));
		}

        # PRINT CHECKIN AND LABELS
        if (MODE == 'PROD' || MODE == 'DEV') {


                /*if ($aRefurbPrinter == 'Refurb Station'){
                    $orderObj->queue_print($oNum, REFURB_PRINTER, 'checkin',$_SESSION['aUser']);
                }else{
                    $orderObj->queue_print($oNum, SLIP_PRINTER, 'checkin',$_SESSION['aUser']);
                }*/
                if ($aRefurbPrinter == 'Refurb Station'){
                    $this->print_refurb_label($labelarray, ZEBRA_REFURB_PRINTER);
                    $this->print_refurb_label_large($labelarray, ZEBRA_REFURB_PRINTER_LARGE);
                }else{
                    $this->print_refurb_label($labelarray, ZEBRA_REFURB_PRINTER);
                    $this->print_refurb_label_large($labelarray, ZEBRA_REFURB_PRINTER_LARGE);
                }
        }

    }

    function reprint_refurb_label($oNum,$removefromgrade=''){

        global $orderObj, $hdvolumes, $ramvolumes;

        $data = $orderObj->get_data($oNum);

        if ($removefromgrade != ''){
            $grade = str_replace($removefromgrade,'',$data['grade']);
        }else{
            $grade = $data['grade'];
		}


        $labelarray = array(
            'machineType'   =>  $data['machineType']
            ,'asset'	=>  $data['asset']
            ,'grade'        =>  $grade
            ,'problem'      =>  $data['problem']
            , 'refurb_notes'            => $data['refurb_notes']
            , 'capacity'                => $data['capacity']
            ,'poNumber'     =>  $data['poNumber']
            ,'date'         =>  $this->format_date('templ_date')
            ,'serialNumber' =>  $data['serialNumber']
            ,'oNum'         =>  $oNum
        );

        if ($data['hd_1'] != ''){
            $hdtotal = (int)$hdvolumes[$data['hd_1']];
        }

        if ($data['hd_2'] != ''){
            $hdtotal += (int)$hdvolumes[$data['hd_2']];
        }

        if ($hdtotal < 1024){
            $hdstr = $hdtotal.'GB';
        }else{
            $hdstr = round((float)($hdtotal/1024),1).'TB';
        }

        if ($data['ram_1'] != ''){
            $ramtotal = (int)$ramvolumes[$data['ram_1']];
        }

        if ($data['ram_2'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_2']];
        }

        if ($data['ram_3'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_3']];
        }

        if ($data['ram_4'] != ''){
            $ramtotal += (int)$ramvolumes[$data['ram_4']];
        }

        if ($ramtotal < 1024){
            $ramstr = $ramtotal.'MB';
        }else{
            $ramstr = round((float)($ramtotal/1024),1).'GB';
        }

        if ($data['is_ipad'] != '1' && $data['is_imac'] != '1'){
            $auditarray = array(
				'grade'             => $grade
				,'top_case'         => $data['top_case']
				,'display_housing'  => $data['display_housing']
				,'bottom_case'      => $data['bottom_case']
				,'hd'               => $hdstr
				,'keys'             => $data['refurb_keys']
				,'case_track'             => $data['case_track']
				,'digi_white'             => $data['digi_white']
				,'digi_dust'             => $data['digi_dust']
				,'digi_dis'             => $data['digi_dis']
				,'case_cracks'             => $data['case_cracks']
				,'LCD_scratches'             => $data['LCD_scratches']
				, 'lcd_dust'         => $data['lcd_dust']
				, 'lcd_white'         => $data['lcd_white']
				,'case_keymarks'             => $data['case_keymarks']
				, 'case_scratches'         => $data['case_scratches']
				, 'case_scratches2'         => $data['case_scratches2']
				, 'case_cdents2'         => $data['case_cdents2']
				, 'case_sdents2'         => $data['case_sdents2']
				, 'case_cdents'         => $data['case_cdents']
				, 'case_sdents'         => $data['case_sdents']
				,'hinge'            => $data['hinge']
				,'optical'          => $data['optical']
				,'ram'              => $ramstr
				,'lcd'              => $data['lcd']
				,'wifi'             => $data['wifi']
				,'speakers'         => $data['speakers']
				,'os_version'       => $data['os_version']
				,'battery'          => $data['battery']
				,'isight'           => $data['isight']
				,'enet'             => $data['enet']
				,'keyboard'         => $data['keyboard']
				,'refurb_notes'         => $data['audit_summary']
                , 'mdm_lock'                => $data['mdm_lock']
				,'is_ipad'          => false
            );
        }elseif ($data['is_imac'] == '1'){
            $auditarray = array(
                'grade'             => $grade
                ,'rh_scratched'         => $data['rh_scratched']
                ,'rh_dented'  => $data['rh_dented']
                ,'stand_scratched'      => $data['stand_scratched']
                ,'hd'               => $hdstr
                ,'stand_dented'             => $data['stand_dented']
                ,'glass_scratched'            => $data['glass_scratched']
                ,'glass_cracked'            => $data['glass_cracked']
                ,'optical'          => $data['optical']
                ,'ram'              => $ramstr
                ,'lcd'              => $data['lcd']
                ,'wifi'             => $data['wifi']
                ,'speakers'         => $data['speakers']
                ,'os_version'       => $data['os_version']
                ,'battery'          => $data['battery']
                ,'isight'           => $data['isight']
                ,'enet'             => $data['enet']
                ,'refurb_notes'         => $data['audit_summary']
                , 'mdm_lock'                => $data['mdm_lock']
                ,'is_imac'          => true
            );
        }else{
            $auditarray = array(
                'grade'             => $grade
                ,'lcd'              => $data['lcd_crack']
                ,'digitizer_scratch'    => $data['digitizer_scratch']
                ,'digitizer_crack'      => $data['digitizer_crack']
                ,'digi_dust'      => $data['digi_dust']
                , 'digi_scratches'         => $data['digi_scratches']
                    , 'digi_white'         => $data['digi_white']
                    , 'marking'         => $data['marking']
                    , 'digi_lines'         => $data['digi_lines']
                    , 'digi_un'         => $data['digi_un']
                    , 'digi_dis'         => $data['digi_dis']
                    , 'digi_sep'         => $data['digi_sep']
                    , 'digi_touch'         => $data['digi_touch']
                    , 'digi_video'         => $data['digi_video']
                    , 'case_scratches'         => $data['case_scratches']
                    , 'case_scratches2'         => $data['case_scratches2']
                        , 'case_cdents2'         => $data['case_cdents2']
                    , 'case_sdents2'         => $data['case_sdents2']
                    , 'case_cdents'         => $data['case_cdents']
                    , 'case_sdents'         => $data['case_sdents']
                    , 'case_edents'         => $data['case_edents']

                ,'case_scratch'         => $data['case_scratch']
                ,'case_cracks'           => $data['case_cracks']
                ,'LCD_scratches'           => $data['LCD_scratches']
                , 'lcd_dust'         => $data['lcd_dust']
                        , 'lcd_white'         => $data['lcd_white']
                ,'case_keymarks'           => $data['case_keymarks']
                ,'case_dent'            => $data['case_dent']
                ,'os_version'           => $data['os_version']
                ,'charge'               => $data['charge']
                ,'sleep_wake'           => $data['sleep_wake']
                ,'mic'                  => $data['mic']
                ,'home_button'          => $data['home_button']
                ,'volume'               => $data['volume']
                ,'silent_rot'           => $data['silent_rot']
                ,'headphone'            => $data['headphone']
                ,'wifi'                 => $data['wifi_ipad']
                ,'front_camera'         => $data['front_camera']
                ,'rear_camera'          => $data['rear_camera']
                ,'speaker'              => $data['speaker']
                ,'capacity'                => $data['capacity']
                ,'activation_lock'      => $data['activation_lock']
                ,'mdm_lock'             => $data['mdm_lock']
                ,'refurb_notes'         => $data['audit_summary']
                ,'is_ipad'              => true
            );
        }

        if ($_SESSION['printer_id']){
            $printer_id = $_SESSION['printer_id'];
        }else{
            $printer_id = 1;
        }

		$printer = $this->db_select_single('printers', '*', array('printer_id' => $printer_id));

		//Check if we're working with an iMac/MacBook. If so, get processor data.
		if ($data['is_ipad'] != '1') {
			$labelarray = array_merge($labelarray, $this->get_processor_data($data['serialNumber']));
		}

        # PRINT CHECKIN AND LABELS
        if (MODE == 'PROD' || MODE == 'DEV') {

            // $this->print_refurb_label($labelarray, constant($printer['printer_queue']));
            $this->print_refurb_label_large(array_merge($labelarray, $auditarray), constant($printer['printer_queue']));
            //$this->print_refurb_label_large(array_merge($labelarray, $auditarray), ZEBRA_REFURB_PRINTER_LARGE);
            //  $this->print_audit_label($auditarray, constant($printer['printer_queue']));

        }

	}

	/**
	 * Gets processor name and speed from system_profiler.
	 *
	 * Extracts data from system profiler database for the given serial number's processor name
	 * and speed. Places the two returned values into an array and returns.
	 *
	 * @since 2.4.05
	 *
	 * @param string $serialNumber Serial number to pass to query.
	 * @return array Associative array holding the processor_name and processor_speed.
	 */
	function get_processor_data($serialNumber) {
		$query = 'SELECT processor_name, processor_speed FROM system_profiler WHERE serial_number = "' . $serialNumber .'";';
		$returnValue = $this->db_query($query, 'select-single');
		$processorArray = array(
			'processor_name' => $returnValue['processor_name'],
			'processor_speed' => $returnValue['processor_speed']
		);
		return $processorArray;
	}

	# RECEIVING PROCESS
	function receiving($oNum, $submitted) {
		global $orderObj, $cartObj, $warehouse_staff;
		$submitted['oNum'] = strtoupper($submitted['oNum']);
		$data = $orderObj->get_data($submitted['oNum']);

		# CHECK FOR PROPER ORDER PRE-STATUS
		if (!in_array($data['cStatus'], array(
					STATUS_RETURN, STATUS_SHIP_0, STATUS_SHIP_1, STATUS_BOX_DELIVERED, STATUS_RETURN_TRANSIT, STATUS_REFURB_PROCESS
				)
			)
		) {
			return 'FAIL';
			//return false;
		}

		# GSX CHECK WARRANTY COVERAGE
		/*$oWarranty = 'N';
		$warrantyEndDate = '';
                $warrantyStatus = '';
                $daysRemaining = 0;
		if ($submitted['serialNumber']) {
			$gsxObj->check_warranty_status($submitted['serialNumber']);
			if ($gsxObj->get_warranty_end_timestamp() > time() + (86400 * 2)) {
				$oWarranty = 'Y';
				$warrantyEndDate = $this->format_date('db_date', $gsxObj->get_warranty_end_timestamp());
                                $warranty_status = $gsxObj->get_warranty_status($submitted['serialNumber']);
                                $warrantyStatus = $warranty_status['warrantyStatus'];
                                $daysRemaining = intval($warranty_status['daysRemaining']);
			}
		}*/

		# SAVE INFO TO DB
                if ($submitted['admin']){
                    $note = 'Received by ' . $submitted['admin'] . ' ' . $this->format_date('regular');
                }else{
                    $note = 'Received ' . $this->format_date('regular');
                }
		if ($submitted['cShipInstruct']) {
			$note .= "\n" . $submitted['cShipInstruct'];
		}
		$updates = array(
			'machineType'			=> $submitted['machineType']
			, 'processorSpeed'		=> $submitted['processorSpeed']
			, 'serialNumber'		=> $submitted['serialNumber']
			, 'asset'		=> $submitted['asset']
			, 'oOSDisks'			=> $submitted['oOSDisks']
			, 'oACAdapter'			=> $submitted['oACAdapter']
			, 'cStatus'				=> STATUS_READY
			, 'dateMachineReceived'	=> $this->format_date('db_date')
			, 'cShipInstruct'		=> 'concat(cShipInstruct, "\n", ' . $this->qualify_value($note) . ')'
			, 'oWarranty'			=> $submitted['oWarranty']
			, 'warrantyEndDate'		=> $submitted['warrantyEndDate']
                        , 'warrantyStatus'              => $submitted['warrantyStatus']
                        , 'daysRemaining'               => $submitted['daysRemaining']
		);

		# IF UNABLE TO UPDATE DB, SEND FAILURE NOTICE
		if (!$this->db_update('ds_orders', 'oNum', $submitted['oNum'], $updates)) {
			return 'FAIL';
			//return false;
		}

                //if no AppleCare and under 30 days warranty, send email
                /*if (($daysRemaining > 0 && $daysRemaining < 30) && $warrantyStatus == 'Apple Limited Warranty'){
                    $parse = array(
                                    'BILL_FIRST'        => $data['cBillFname'],
                                    'BILL_LAST'         => $data['cBillLname'],
                                    'DAYS_REMAINING'    => $daysRemaining,
                                    'SITE_NAME_EMAIL'   => SITE_NAME,
                                    'SITE_URL_EMAIL'    => SITE_URL,
                                    'ONUM'              => $submitted['oNum'],
                                    'SERIAL_NUMBER'      => $submitted['serialNumber']
                                    );
                    $this->send_email(
                                    $data['cEmail'],
                                    ORDERS_FROM,
                                    'AppleCare',
                                    $this->parse(APPLECARE_RECEIVE_REMINDER_BODY, $parse)
                                    );
                }*/

		# ADD LOG AND INTERNAL ORDER NOTE
		$data = array_merge($data, $updates);
		$orderObj->insert_log($oNum, 'order_status_changed', STATUS_READY);
		if ($submitted['nNote']) {
			$orderObj->insert_note($submitted['oNum'], $submitted, 'N', $_SESSION['aUser']);
		}

		# SEND ORDER RECIEVED EMAIL TO CUSTOMER
		if ($cart_rows = $cartObj->get_data($submitted['oNum'])) {
			$cart = $cartObj->parse_cart_template($cart_rows, '', $data, CART_VIEW_BODY_SMALL);
			$return = $this->parse_receiving_response($data, $cart[0]);
		}
		$orderObj->email_status($submitted['oNum'], $data, ($data['customer_id'] == SQUARETRADE_CUST_ID));

		# PRINT CHECKIN AND LABELS
		if (MODE == 'PROD') {
			$orderObj->print_slip($submitted['oNum'], $warehouse_staff[$submitted['admin']]['print'], 'checkin');
			system('/usr/bin/convert -size 288x144 xc:white -font Helvetica-Bold -pointsize 24 '
				. '-draw "text 0,144 \'' . strtoupper($submitted['oNum'])
				. '\'" '.LABEL_TEMP_DIR . $submitted['oNum'] . '.png', $retval);
			for ($i = 0; $i < $submitted['num_labels']; $i++) {
				$this->send_printer(LABEL_PRINTER, LABEL_TEMP_DIR . $submitted['oNum'] . '.png');
			}
                }
                return $return;
	}

	# BUILDS UPS TRACKING RESULTS TABLE - RETURNS HTML
	function tracking($oNum) {
		global $orderObj, $upsObj;
		if ($tracking = $orderObj->get_tracking($oNum)) {
			$output = '<table><tr>';
			foreach ($tracking as $track) {
				if ($track_data = $upsObj->track($track)) {
					$output .= '<td valign="top">' . $track_data . '</td>';
				} else {
					$output .= '<td class="error">' . MISSING_TRACKING . '<br />' . $track . '</td>';
				}
			}
			return $output . '</tr></table>';
		}
	}

    # ADD ITEMS ORDER SELECT
    function add_items($data){
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ADD_ITEMS,$data)));
    }

    # CREATE REPAIR
    function create_repair($order){

        $result = '';

        if ($_POST['submit']){
            $order = $_POST;

            //get current order id
            $current_order = $this->db_select_single('gsx_stock_order', 'gsx_stock_id', array(),'where confirmationNumber is null');

            if (!is_array($current_order)){
                $order_id = $this->db_insert('gsx_stock_order', array('subTotal' => 0, 'tax' => 0));
            }else{
                $order_id = $current_order['gsx_stock_id'];
            }

            if($_POST['PartNumber_1'] != ''){

                if ($ds_products = $this->db_select_single('ds_products', 'pNum, pName, pPrice', array('pNum' => $_POST['PartNumber_1']))){

                    $data = array(
                        'gsx_stock_id'  =>  $order_id
                        ,'partNumber'   =>  $ds_products['pNum']
                        ,'partDescription'  =>  $ds_products['pName']
                        ,'quantity'         =>  1
                        ,'stockPrice'       =>  $ds_products['pPrice']
                    );

                    $this->db_insert('gsx_stock_order_parts', $data);

                    $result .= '<tr><td><strong>'.$data['partNumber'].'</strong></td><td><strong>'.$data['partDescription'].'</strong></td><td><strong>'.$data['stockPrice'].'</strong></td></tr>';
                }
            }

            if($_POST['PartNumber_2'] != ''){

                if ($ds_products = $this->db_select_single('ds_products', 'pNum, pName, pPrice', array('pNum' => $_POST['PartNumber_2']))){

                    $data = array(
                        'gsx_stock_id'  =>  $order_id
                        ,'partNumber'   =>  $ds_products['pNum']
                        ,'partDescription'  =>  $ds_products['pName']
                        ,'quantity'         =>  1
                        ,'stockPrice'       =>  $ds_products['pPrice']
                    );

                    $this->db_insert('gsx_stock_order_parts', $data);

                    $result .= '<tr><td><strong>'.$data['partNumber'].'</strong></td><td><strong>'.$data['partDescription'].'</strong></td><td><strong>'.$data['stockPrice'].'</strong></td></tr>';
                }
            }

            if($_POST['PartNumber_3'] != ''){

                if ($ds_products = $this->db_select_single('ds_products', 'pNum, pName, pPrice', array('pNum' => $_POST['PartNumber_3']))){

                    $data = array(
                        'gsx_stock_id'  =>  $order_id
                        ,'partNumber'   =>  $ds_products['pNum']
                        ,'partDescription'  =>  $ds_products['pName']
                        ,'quantity'         =>  1
                        ,'stockPrice'       =>  $ds_products['pPrice']
                    );

                    $this->db_insert('gsx_stock_order_parts', $data);

                    $result .= '<tr><td><strong>'.$data['partNumber'].'</strong></td><td><strong>'.$data['partDescription'].'</strong></td><td><strong>'.$data['stockPrice'].'</strong></td></tr>';
                }
            }

            if($_POST['PartNumber_4'] != ''){

                if ($ds_products = $this->db_select_single('ds_products', 'pNum, pName, pPrice', array('pNum' => $_POST['PartNumber_4']))){

                    $data = array(
                        'gsx_stock_id'  =>  $order_id
                        ,'partNumber'   =>  $ds_products['pNum']
                        ,'partDescription'  =>  $ds_products['pName']
                        ,'quantity'         =>  1
                        ,'stockPrice'       =>  $ds_products['pPrice']
                    );

                    $this->db_insert('gsx_stock_order_parts', $data);

                    $result .= '<tr><td><strong>'.$data['partNumber'].'</strong></td><td><strong>'.$data['partDescription'].'</strong></td><td><strong>'.$data['stockPrice'].'</strong></td></tr>';
                }
            }

            if ($result != ''){
                $result = '<table style="padding: 20px;"><tr><td colspan="3"><strong>The following items have been added to a stock order:</strong></td></tr>'.$result.'</table>';
            }else{
                $result = '<table style="padding: 20px;"><tr><td colspan="3"><strong>No items added</strong></td></tr></table>';
            }
        }

        //global $gsx_techs;

        //create array of US part prefixes to filter parts drop down
        $us_parts_prefix = array('661','922');

        //$gsxObj = new GSX();

        /*$tia = array();
        $mod = array();

        //prepare arrays for drop down generation
        foreach ($tia_data['tia'] as $tia_value){
            $tia[] = array($tia_value['code'],$tia_value['code'].' '.$tia_value['description']);
        }

        foreach ($tia_data['mod'] as $mod_value){
            $mod[] = array($mod_value['mod_code'],$mod_value['mod_description']);
        }*/

        //Get parts list
        $parts = array();

        $currentPartNumber = '';

        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        if (strlen($serialNumber) < 13){
            $configCode = substr($serialNumber,8);
        }else{
            $configCode = substr($serialNumber,9);
        }

        //$parts_data = $gsxObj->get_parts($order['serialNumber']);

        $product_model = $this->db_select_single('product_model', 'machine_id', array('configCode' => $configCode));

        $join = array('machine_parts_map mpm on mpm.pID = dp.pID');
        $parts_data = $this->db_select_multiple('ds_products dp', 'pNum partNumber, pName partDescription', array('mpm.machine_id' => $product_model['machine_id']), 'order by pNum', $join);

        //if parts returned, create parts arrays
        if (is_array($parts_data)){
            foreach ($parts_data as $parts_value){
                if (in_array(substr($parts_value['partNumber'], 0,3), $us_parts_prefix) && $parts_value['partNumber'] != $currentPartNumber){
                    $parts[] = array($parts_value['partNumber'],$parts_value['partNumber'].' '.$parts_value['partDescription']);
                    $currentPartNumber = $parts_value['partNumber'];

                    $parts_jscript[] = array('partNumber' => $parts_value['partNumber'], 'componentCode' => $parts_value['componentCode']);
                }
            }

            //encode parts array for javascript JSON object
            $parts_json = json_encode($parts_jscript);

            //add partNumber/componentCode array to JSON object
            $var_json = 'var partsJSONObj = {"partnumbers":'.$parts_json;

            //create JSON arrays of compTIA groups
            foreach ($tia_data['tiagroups'] as $group){
                $var_json .= ',"tia'.$group->componentId.'":';

                foreach ($group->comptiaCodeInfo as $codeInfo){
                    $codes_jscript[] = array('comptiaCode' => (string)$codeInfo->comptiaCode,'comptiaDescription' => (string)$codeInfo->comptiaCode.' '.(string)$codeInfo->comptiaDescription);
                }

                $codes_json = json_encode($codes_jscript);

                unset ($codes_jscript);

                $var_json .= $codes_json;
            }

            $var_json .= '};';

            //create parts drop downs
            $dd_parts = $this->arrayToHtmlSelectOptions($parts,true);
            $parts_1_content = "<select tabindex='17' name='PartNumber_1' id='PartNumber_1' onchange='selectPart(this);'>$dd_parts</select>";
            $parts_2_content = "<select tabindex='20' name='PartNumber_2' id='PartNumber_2' onchange='selectPart(this);'>$dd_parts</select>";
            $parts_3_content = "<select tabindex='23' name='PartNumber_3' id='PartNumber_3' onchange='selectPart(this);'>$dd_parts</select>";
            $parts_4_content = '<input type="text" class="borderless" name="PartNumber_4" id="PartNumber_4" maxlength="18" tabindex="26" />';
            $dd_tia = '';
            $dd_tia_4 = $this->arrayToHtmlSelectOptions($tia,true);
            $tia_1_disabled = 'disabled';
            $tia_2_disabled = 'disabled';
            $tia_3_disabled = 'disabled';
            }else{
            //create parts textboxes
            $parts_1_content = '<input type="text" class="borderless" name="PartNumber_1" id="PartNumber_1" maxlength="18" tabindex="17" />';
            $parts_2_content = '<input type="text" class="borderless" name="PartNumber_2" id="PartNumber_2" maxlength="18" tabindex="20" />';
            $parts_3_content = '<input type="text" class="borderless" name="PartNumber_3" id="PartNumber_3" maxlength="18" tabindex="23" />';
            $parts_4_content = '<input type="text" class="borderless" name="PartNumber_4" id="PartNumber_4" maxlength="18" tabindex="26" />';
            //generate drop downs
            $dd_tia = $this->arrayToHtmlSelectOptions($tia,true);
            $dd_tia_4 = $this->arrayToHtmlSelectOptions($tia,true);
            $tia_1_disabled = '';
            $tia_2_disabled = '';
            $tia_3_disabled = '';
        }

        //generate drop downs
        $dd_mod = $this->arrayToHtmlSelectOptions($mod,true);

        $dd_techs = $this->arrayToHtmlSelectOptions($gsx_techs,true);

        //generate page html from template
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(CREATE_REPAIR,array(
                'ORDER_NUMBER'      =>  $order['oID'],
                'BILL_COMPANY'      =>  $order['cBillCompany'],
                'BILL_FIRST_NAME'   =>  $order['cBillFname'],
                'BILL_LAST_NAME'    =>  $order['cBillLname'],
                'BILL_ADDRESS_1'    =>  $order['cBillAddress1'],
                'BILL_ADDRESS_2'    =>  $order['cBillAddress2'],
                'BILL_CITY'         =>  $order['cBillCity'],
                'BILL_STATE'        =>  $order['cBillState'],
                'BILL_ZIP'          =>  $order['cBillZip'],
                'EMAIL'             =>  $order['cEmail'],
                'PHONE'             =>  $order['cPhone'],
                'SERIAL_NUMBER'     =>  $order['serialNumber'],
                'TIA_1'             =>  $dd_tia,
                'MOD_1'             =>  $dd_mod,
                'TIA_2'             =>  $dd_tia,
                'MOD_2'             =>  $dd_mod,
                'TIA_3'             =>  $dd_tia,
                'MOD_3'             =>  $dd_mod,
                'TIA_4'             =>  $dd_tia_4,
                'MOD_4'             =>  $dd_mod,
                'TECHID'            =>  $dd_techs,
                'ABUSE_1'           =>  '',
                'SYMPTOM'           =>  '',
                'DIAGNOSIS'         =>  '',
                'DIAGNOSTIC_CODE'   =>  '',
                'APPLE_REVIEW'      =>  '',
                'PART_1'            =>  $parts_1_content,
                'PART_2'            =>  $parts_2_content,
                'PART_3'            =>  $parts_3_content,
                'PART_4'            =>  $parts_4_content,
                'RESPONSE'          =>  $result,
                'SUBMIT_DISABLED'   =>  '',
                'NEW_DISPLAY'       =>  'style="display:none;"',
                'VAR_JSON'          =>  $var_json,
                'TIA_1_DISABLED'      =>  $tia_1_disabled,
                'TIA_2_DISABLED'      =>  $tia_2_disabled,
                'TIA_3_DISABLED'      =>  $tia_3_disabled
                ))));

    }

    #SUBMIT REPAIR
    function submit_repair(){

        global $gsx_techs;

        //create array of US part prefixes to filter parts drop down
        $us_parts_prefix = array('661','922');

        //shipping part number, to exclude from db
        $shipping_part_no = 'ACSH08';

        $gsxObj = new GSX();

        //set to correct timezone
        date_default_timezone_set(GSX_TIMEZONE);

        if ($_POST['serialNumber'] != $_POST['hdnSerialNumber']){
            //update serial number in database
            $this->db_update('ds_orders', 'oID', $_POST['oID'], array(
                            'serialNumber' => $_POST['serialNumber']
                    )
            );
        }

        //build customer address array
        $customerAddress = array(
            'companyName'       =>  $_POST['cBillCompany'],
            'firstName'         =>  $_POST['cBillFname'],
            'lastName'          =>  $_POST['cBillLname'],
            'addressLine1'      =>  $_POST['cBillAddress1'],
            'street'            =>  $_POST['cBillAddress2'],
            'city'              =>  $_POST['cBillCity'],
            'state'             =>  $_POST['cBillState'],
            'zipCode'           =>  $_POST['cBillZip'],
            'emailAddress'      =>  $_POST['cEmail'],
            'primaryPhone'      =>  $_POST['cPhone'],
            'country'           =>  GSX_COUNTRY,
            'regionCode'        =>  GSX_REGION
        );

        //build order lines
        if($_POST['PartNumber_1'] != ''){
            $orderLines[] = array(
                'partNumber'        =>  $_POST['PartNumber_1'],
                'comptiaCode'       =>  $_POST['tia_1'],
                'comptiaModifier'   =>  $_POST['mod_1'],
                'abused'            =>  ($_POST['abuse_1'] ? 'Y' : 'N'),
                'diagnosticCode'    =>  $_POST['DiagnosticCode']
            );
        }

        if($_POST['PartNumber_2'] != ''){
            $orderLines[] = array(
                'partNumber'        =>  $_POST['PartNumber_2'],
                'comptiaCode'       =>  $_POST['tia_2'],
                'comptiaModifier'   =>  $_POST['mod_2'],
                'abused'            =>  ($_POST['abuse_2'] ? 'Y' : 'N'),
                'diagnosticCode'    =>  $_POST['DiagnosticCode']
            );
        }

        if($_POST['PartNumber_3'] != ''){
            $orderLines[] = array(
                'partNumber'        =>  $_POST['PartNumber_3'],
                'comptiaCode'       =>  $_POST['tia_3'],
                'comptiaModifier'   =>  $_POST['mod_3'],
                'abused'            =>  ($_POST['abuse_3'] ? 'Y' : 'N'),
                'diagnosticCode'    =>  $_POST['DiagnosticCode']
            );
        }

        if($_POST['PartNumber_4'] != ''){
            $orderLines[] = array(
                'partNumber'        =>  $_POST['PartNumber_4'],
                'comptiaCode'       =>  $_POST['tia_4'],
                'comptiaModifier'   =>  $_POST['mod_4'],
                'abused'            =>  ($_POST['abuse_4'] ? 'Y' : 'N'),
                'diagnosticCode'    =>  $_POST['DiagnosticCode']
            );
        }

        //build repair data
        $repairData = array(
            'customerAddress'       =>  $customerAddress,
            'orderLines'            =>  $orderLines,
            'serialNumber'          =>  $_POST['serialNumber'],
            'poNumber'              =>  ORDER_NUM_PREFIX.$_POST['oID'],
            'symptom'               =>  substr($_POST['txtSymptom'],0,1500),
            'diagnosis'             =>  substr($_POST['txtDiagnosis'],0,1500),
            'notes'                 =>  ($_POST['AppleReview'] ? substr($_POST['txtDiagnosis'],0,800) : ''),
            'shipTo'                =>  GSX_SHIPTO,
            'requestReviewByApple'  =>  ($_POST['AppleReview'] ? 'Y' : 'N'),
            'unitReceivedDate'      =>  date('m/d/y'),
            'unitReceivedTime'      =>  date('h:i A'),
            'popFaxed'              =>  'N',
            'diagnosedByTechId'     =>  $_POST['diagnosedByTechId']
        );

        //create the carry in request
        $create_carry_in = $gsxObj->create_carry_in_request($repairData);

        $tia_data = $gsxObj->get_comptia_codes();

        $tia = array();
        $mod = array();

        //prepare arrays for drop down generation
        foreach ($tia_data['tia'] as $tia_value){
            $tia[] = array($tia_value['code'],$tia_value['code'].' '.$tia_value['description']);
        }

        foreach ($tia_data['mod'] as $mod_value){
            $mod[] = array($mod_value['mod_code'],$mod_value['mod_description']);
        }

        //generate drop downs defaulting to selected values
        if ($_POST['PartNumber_1'] != ''){
            $dd_tia_1 = $this->arrayToHtmlSelectOptions($tia,true,$_POST['tia_1']);
            $tia_1_disabled = '';
        }else{
            $dd_tia_1 = '';
            $tia_1_disabled = 'disabled';
        }
        if ($_POST['PartNumber_2'] != ''){
            $dd_tia_2 = $this->arrayToHtmlSelectOptions($tia,true,$_POST['tia_2']);
            $tia_2_disabled = '';
        }else{
            $dd_tia_2 = '';
            $tia_2_disabled = 'disabled';
        }
        if ($_POST['PartNumber_3'] != ''){
            $dd_tia_3 = $this->arrayToHtmlSelectOptions($tia,true,$_POST['tia_3']);
            $tia_3_disabled = '';
        }else{
            $dd_tia_3 = '';
            $tia_3_disabled = 'disabled';
        }
        $dd_tia_4 = $this->arrayToHtmlSelectOptions($tia,true,$_POST['tia_4']);

        $dd_mod_1 = $this->arrayToHtmlSelectOptions($mod,true,$_POST['mod_1']);
        $dd_mod_2 = $this->arrayToHtmlSelectOptions($mod,true,$_POST['mod_2']);
        $dd_mod_3 = $this->arrayToHtmlSelectOptions($mod,true,$_POST['mod_3']);
        $dd_mod_4 = $this->arrayToHtmlSelectOptions($mod,true,$_POST['mod_4']);

        $dd_techs = $this->arrayToHtmlSelectOptions($gsx_techs,true,$_POST['diagnosedByTechId']);

        //Get parts list
        $parts = array();

        $currentPartNumber = '';

        $parts_data = $gsxObj->get_parts($_POST['serialNumber']);
        //$parts_data = $gsxObj->get_parts('');


        //if parts have been returned, create parts arrays
        if (is_array($parts_data)){
            foreach ($parts_data as $parts_value){
                if (in_array(substr($parts_value['partNumber'], 0,3), $us_parts_prefix) && $parts_value['partNumber'] != $currentPartNumber){
                    $parts[] = array($parts_value['partNumber'],$parts_value['partNumber'].' '.$parts_value['partDescription']);
                    $currentPartNumber = $parts_value['partNumber'];

                    $parts_jscript[] = array('partNumber' => $parts_value['partNumber'], 'componentCode' => $parts_value['componentCode']);
                }
            }

            $parts_json = json_encode($parts_jscript);

            $var_json = 'var partsJSONObj = {"partnumbers":'.$parts_json;

            foreach ($tia_data['tiagroups'] as $group){
                $var_json .= ',"tia'.$group->componentId.'":';

                foreach ($group->comptiaCodeInfo as $codeInfo){
                    $codes_jscript[] = array('comptiaCode' => (string)$codeInfo->comptiaCode,'comptiaDescription' => (string)$codeInfo->comptiaCode.' '.(string)$codeInfo->comptiaDescription);
                }

                $codes_json = json_encode($codes_jscript);

                unset ($codes_jscript);

                $var_json .= $codes_json;
            }

            $var_json .= '};';

            //create parts drop downs
            $dd_parts_1 = $this->arrayToHtmlSelectOptions($parts,true,$_POST['PartNumber_1']);
            $dd_parts_2 = $this->arrayToHtmlSelectOptions($parts,true,$_POST['PartNumber_2']);
            $dd_parts_3 = $this->arrayToHtmlSelectOptions($parts,true,$_POST['PartNumber_3']);
            $parts_1_content = "<select tabindex='17' name='PartNumber_1' id='PartNumber_1' onchange='selectPart(this);'>$dd_parts_1</select>";
            $parts_2_content = "<select tabindex='20' name='PartNumber_2' id='PartNumber_2' onchange='selectPart(this);'>$dd_parts_2</select>";
            $parts_3_content = "<select tabindex='23' name='PartNumber_3' id='PartNumber_3' onchange='selectPart(this);'>$dd_parts_3</select>";
            $parts_4_content = '<input type="text" class="borderless" name="PartNumber_4" id="PartNumber_4" maxlength="18" tabindex="26" value="'.$_POST['PartNumber_4'].'" />';
            }else{
            //create parts textboxes
            $parts_1_content = '<input type="text" class="borderless" name="PartNumber_1" id="PartNumber_1" maxlength="18" tabindex="17" value="'.$_POST['PartNumber_1'].'" />';
            $parts_2_content = '<input type="text" class="borderless" name="PartNumber_2" id="PartNumber_2" maxlength="18" tabindex="20" value="'.$_POST['PartNumber_2'].'" />';
            $parts_3_content = '<input type="text" class="borderless" name="PartNumber_3" id="PartNumber_3" maxlength="18" tabindex="23" value="'.$_POST['PartNumber_3'].'" />';
            $parts_4_content = '<input type="text" class="borderless" name="PartNumber_4" id="PartNumber_4" maxlength="18" tabindex="26" value="'.$_POST['PartNumber_4'].'" />';
        }

        //generate check box checked status
        ($_POST['abuse_1'] ? $abuse_1 = 'checked' : '');
        ($_POST['abuse_2'] ? $abuse_2 = 'checked' : '');
        ($_POST['abuse_3'] ? $abuse_3 = 'checked' : '');
        ($_POST['abuse_4'] ? $abuse_4 = 'checked' : '');

        ($_POST['AppleReview'] ? $apple_review = 'checked' : '');

        $result_row = '';

        //if carry in created generate success message
        if(is_array($create_carry_in)){

            //update ds_orders table
            $this->db_update('ds_orders', 'oID', $_POST['oID'], array(
                            'cShipInstruct' => "concat(cShipInstruct, '\nApple Part Order " . date('m/d/y') . " " . $create_carry_in['confirmationNumber'] . "')"
                    )
            );

            //add record to gsx_orders
            $gsx_order = array(
                'oID'                       =>  $_POST['oID'],
                'confirmationNumber'        =>  $create_carry_in['confirmationNumber'],
                'diagnosticDescription'     =>  $create_carry_in['diagnosticDescription'],
                'diagnosticEventNumber'     =>  $create_carry_in['diagnosticEventNumber'],
                'diagnosticEventEndResult'  =>  $create_carry_in['diagnosticEventEndResult'],
                'totalFromOrder'            =>  floatval(substr($create_carry_in['totalFromOrder'],3)),
                'vatTax'                    =>  floatval(substr($create_carry_in['vatTax'],3)),
                'gsx_order_date'            =>  date('Y-m-d')
            );

            $gsx_id = $this->db_insert('gsx_orders', $gsx_order);

            //add records to gsx_orders_parts
            foreach($create_carry_in['parts'] as $parts){
                //if it's not for shipping
                if ($parts['partNumber'] != $shipping_part_no){
                    $gsx_order_part = array(
                        'gsx_id'    =>  $gsx_id,
                        'partNumber'    =>  $parts['partNumber'],
                        'partType'      =>  $parts['partType'],
                        'netPrice'      =>  floatval(substr($parts['netPrice'],3)),
                        'currency'      =>  $parts['currency'],
                        'availability'  =>  $parts['availability'],
                        'quantity'      =>  intval($parts['quantity'])
                    );

                    $this->db_insert('gsx_orders_parts', $gsx_order_part);

                    $part = $gsxObj->get_part_details($parts['partNumber']);

                    $partDescription = $part[0]['partDescription'];

                    $this->addProduct($parts['partNumber'], $partDescription, $parts['netPrice']);

                }
            }



            //add a row to result table for each part
            foreach($create_carry_in['parts'] as $parts){
                $result_row .= $this->parse(REPAIR_SUCCESS_ROW,array(
                    'PART_NUMBER'   => $parts['partNumber'],
                    'PART_TYPE'     => $parts['partType'],
                    'NET_PRICE'     => $parts['netPrice'],
                    'AVAILABILITY'  => $parts['availability'],
                    'QUANTITY'      => $parts['quantity'],
                ));
            }

            //create the confirmation header
            $result = $this->parse(REPAIR_SUCCESS,array(
                'CONFIRMATION_NO'               =>  $create_carry_in['confirmationNumber'],
                'TOTAL_PRICE'                   =>  $create_carry_in['totalFromOrder'],
                'TAX'                           =>  $create_carry_in['vatTax'],
                'DIAGNOSTIC_DESCRIPTION'        =>  $create_carry_in['diagnosticDescription'],
                'DIAGNOSTIC_EVENT_NUMBER'       =>  $create_carry_in['diagnosticEventNumber'],
                'DIAGNOSTIC_EVENT_END_RESULT'   =>  $create_carry_in['diagnosticEventEndResult'],
                'REPAIR_SUCCESS_ROWS'           =>  $result_row
                ));

            $submit_disabled = 'disabled';
            $new_display = '';
        }else{
            //generate failure message
            $result = $this->parse(REPAIR_FAILURE,array(
                'RESULT_CODE'   =>  $create_carry_in->faultcode,
                'REASON'        =>  $create_carry_in->faultstring
            ));

            $submit_disabled = '';
            $new_display = 'style="display:none;"';
        }

        //generate page html from template
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(CREATE_REPAIR,array(
                'ORDER_NUMBER'      =>  $_POST['oID'],
                'BILL_COMPANY'      =>  $_POST['cBillCompany'],
                'BILL_FIRST_NAME'   =>  $_POST['cBillFname'],
                'BILL_LAST_NAME'    =>  $_POST['cBillLname'],
                'BILL_ADDRESS_1'    =>  $_POST['cBillAddress1'],
                'BILL_ADDRESS_2'    =>  $_POST['cBillAddress2'],
                'BILL_CITY'         =>  $_POST['cBillCity'],
                'BILL_STATE'        =>  $_POST['cBillState'],
                'BILL_ZIP'          =>  $_POST['cBillZip'],
                'EMAIL'             =>  $_POST['cEmail'],
                'PHONE'             =>  $_POST['cPhone'],
                'SERIAL_NUMBER'     =>  $_POST['serialNumber'],
                'PART_1'            =>  $parts_1_content,
                'PART_2'            =>  $parts_2_content,
                'PART_3'            =>  $parts_3_content,
                'PART_4'            =>  $parts_4_content,
                'TIA_1'             =>  $dd_tia_1,
                'MOD_1'             =>  $dd_mod_1,
                'TIA_2'             =>  $dd_tia_2,
                'MOD_2'             =>  $dd_mod_2,
                'TIA_3'             =>  $dd_tia_3,
                'MOD_3'             =>  $dd_mod_3,
                'TIA_4'             =>  $dd_tia_4,
                'MOD_4'             =>  $dd_mod_4,
                'TECHID'            =>  $dd_techs,
                'ABUSE_1'           =>  $abuse_1,
                'ABUSE_2'           =>  $abuse_2,
                'ABUSE_3'           =>  $abuse_3,
                'ABUSE_4'           =>  $abuse_4,
                'SYMPTOM'           =>  $_POST['txtSymptom'],
                'DIAGNOSIS'         =>  $_POST['txtDiagnosis'],
                'DIAGNOSTIC_CODE'   =>  $_POST['DiagnosticCode'],
                'APPLE_REVIEW'      =>  $apple_review,
                'RESPONSE'          =>  $result,
                'SUBMIT_DISABLED'   =>  $submit_disabled,
                'NEW_DISPLAY'       =>  $new_display,
                'VAR_JSON'          =>  $var_json,
                'TIA_1_DISABLED'      =>  $tia_1_disabled,
                'TIA_2_DISABLED'      =>  $tia_2_disabled,
                'TIA_3_DISABLED'      =>  $tia_3_disabled
                ))));

    }

    function stock_order(){

        //initialize error message
        $errMessage = '';

        //update order lines
        if ($_POST['btnUpdate']){

            //get array of parts ordered
            $parts = $this->db_select_multiple('gsx_stock_order_parts','gsx_stock_parts_id',array('gsx_stock_id' => $_POST['hdnGSX_Stock_ID']),'order by partNumber');

            //check if to delete a row
            foreach ($parts as $partitem){

                if ($_POST[$partitem['gsx_stock_parts_id']]){
                    $this->db_delete('gsx_stock_order_parts', 'gsx_stock_parts_id', $partitem['gsx_stock_parts_id']);
                }
            }

        }

        //add parts
        if ($_POST['btnAdd']){

            //$objGSX = new GSX();

            //get current order id
            $current_order = $this->db_select_single('gsx_stock_order', 'gsx_stock_id', array('gsx_stock_id' => $_POST['hdnGSX_Stock_ID']));

            if (!is_array($current_order)){
                $order_id = $this->db_insert('gsx_stock_order', array('subTotal' => 0, 'tax' => 0));
            }else{
                $order_id = $current_order['gsx_stock_id'];
            }

            //step through parts entered
            for ($i=1;$i<=10;$i++){
                if ($_POST["Part{$i}"] != ''){

                    $part = $this->db_select_single('ds_products', 'pNum,pName,pSalesPrice', array('pNum' => $_POST["Part{$i}"]));

                    if($part){
                        //insert record into database
                        $part_detail = array(
                            'gsx_stock_id'  =>  $order_id,
                            'partNumber'    =>  $part['pNum'],
                            'partDescription'   =>  $part['pName'],
                            'quantity'          =>  $_POST["Part{$i}_Qty"],
                            'stockPrice'        =>  floatval($part['pSalesPrice'])
                        );

                        $this->db_insert('gsx_stock_order_parts', $part_detail);
                    }else{
                        //if invalid part # add to error message
                        $errMessage .= $_POST["Part{$i}"];
                    }

                    /*$part = $objGSX->get_part_details($_POST["Part{$i}"]);

                    if(is_array($part)){
                        //insert record into database
                        $part_detail = array(
                            'gsx_stock_id'  =>  $order_id,
                            'partNumber'    =>  $part[0]['partNumber'],
                            'partDescription'   =>  $part[0]['partDescription'],
                            'quantity'          =>  $_POST["Part{$i}_Qty"],
                            'stockPrice'        =>  floatval($part[0]['stockPrice'])
                        );

                        $this->db_insert('gsx_stock_order_parts', $part_detail);
                    }else{
                        //if invalid part # add to error message
                        $errMessage .= $_POST["Part{$i}"];
                    }*/
                }
            }
        }

        if ($_POST['btnForce']){

            $objGSX = new GSX();

            $order_id = $_POST['hdnGSX_Stock_ID'];
            $order_number = 'ST'.str_pad($order_id, 4,'0',STR_PAD_LEFT);

            //get array of parts ordered
            $parts = $this->db_select_multiple('gsx_stock_order_parts','gsx_stock_parts_id, partNumber, partDescription, stockPrice, quantity',array('gsx_stock_id' => $order_id),'order by partNumber');

            foreach ($parts as $partitem){
                $orderLines[] = array(
                    'partNumber'        =>  $partitem['partNumber'],
                    'quantity'          =>  $partitem['quantity']
                );
                $this->addProduct($partitem['partNumber'], $partitem['partDescription'], $partitem['stockPrice']);
            }

            //build order data
            $orderData = array(
                'purchaseOrderNumber'   =>  $order_number,
                'shipToCode'            =>  GSX_SHIPTO,
                'orderLines'            =>  $orderLines
                );

            $create_stocking_order = $objGSX->create_stocking_order($orderData);

            $result_row = '';

            //if stocking order created generate success message
            if(is_array($create_stocking_order)){

                //update ds_orders table
                $this->db_update('gsx_stock_order', 'gsx_stock_id', $order_id, array(
                                'confirmationNumber'    => $create_stocking_order['confirmationNumber'],
                                'order_date'            =>  date('Y-m-d'),
                                'subTotal'              => floatval(substr($create_stocking_order['subTotal'],3)),
                                'tax'                   => floatval(substr($create_stocking_order['tax'],3))
                        )
                );

                //add a row to result table for each part
                foreach($create_stocking_order['parts'] as $parts){
                    $result_row .= $this->parse(REPAIR_SUCCESS_ROW,array(
                        'PART_NUMBER'   => $parts['partNumber'],
                        'PART_TYPE'     => $parts['partType'],
                        'NET_PRICE'     => $parts['netPrice'],
                        'AVAILABILITY'  => $parts['availability'],
                        'QUANTITY'      => $parts['quantity'],
                    ));
                }

                //create the confirmation header
                $result = $this->parse(FORCE_ORDER_HEADER,array(
                    'CONFIRMATION_NO'       =>  $create_stocking_order['confirmationNumber'],
                    'SUB_TOTAL'             =>  $create_stocking_order['subTotal'],
                    'REPAIR_SUCCESS_ROWS'   =>  $result_row
                    ));

            }else{
                //generate failure message
                $result = $this->parse(FORCE_ORDER_FAILURE,array(
                    'RESULT_CODE'   =>  $create_stocking_order->faultcode,
                    'REASON'        =>  $create_stocking_order->faultstring
                ));

            }

            $disabled = 'disabled';

            //create array for quantity drop downs
            for ($i=1;$i<=100;$i++){
                $qty[] = $i;
            }
            //$qty = array('1','2','3','4','5','6','7','8','9','10');

            //create quantity drop downs
            $dd_qty = $this->arrayToHtmlSelectOptions($qty);

            //generate page html from template
            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(STOCK_ORDER,array(
                    'ORDER_NUMBER'  => $order_number,
                    'QTY'           =>  $dd_qty,
                    'GSX_STOCK_ID'  =>  $order_id,
                    'ERR_MESSAGE'   =>  '',
                    'PARTS_ROWS'    =>  $result,
                    'PARTS_TOTAL'   =>  '',
                    'DISABLED'      =>  $disabled
                    ))));

            exit;

        }

        //create array for quantity drop downs
        for ($i=1;$i<=100;$i++){
                $qty[] = $i;
            }
        //$qty = array('1','2','3','4','5','6','7','8','9','10');


        //create quantity drop downs
        $dd_qty = $this->arrayToHtmlSelectOptions($qty);

        //get current order id
        $current_order = $this->db_select_single('gsx_stock_order', 'gsx_stock_id, confirmationNumber', array(), 'order by gsx_stock_id desc');

        if (!is_array($current_order)){
            $order_id = 1;
        }elseif($current_order['confirmationNumber'] == ''){
            $order_id = $current_order['gsx_stock_id'];
        }else{
            $order_id = $current_order['gsx_stock_id']+1;
        }

        $order_number = 'ST'.str_pad($order_id, 4,'0',STR_PAD_LEFT);

        //get current parts in order
        $parts = $this->db_select_multiple('gsx_stock_order_parts', 'gsx_stock_parts_id, partNumber, partDescription, quantity, stockPrice, (stockPrice * quantity) as extended',array('gsx_stock_id' => $order_id),'order by partNumber');


        if (is_array($parts)){
            //create rows in parts area
            foreach ($parts as $partitem){
                $parts_row .= $this->parse(STOCK_ORDER_ROW,array(
                    'PART_NUMBER'       => $partitem['partNumber'],
                    'PART_DESCRIPTION'  => $partitem['partDescription'],
                    'QTY'               => $partitem['quantity'],
                    'PRICE'             => '$'.$partitem['stockPrice'],
                    'EXTENDED'          => '$'.$partitem['extended'],
                    'PART_ID'           => $partitem['gsx_stock_parts_id']
                ));

                $parts_total += $partitem['extended'];
            }
            //create order total row
            $parts_total_row = $this->parse(STOCK_ORDER_TOTAL, array(
                    'ORDER_TOTAL'   =>  '$'.$parts_total
            ));
            $disabled = '';
        }else{
            //display empty order message
            $parts_row = $this->parse(STOCK_ORDER_BLANK,array());
            $parts_total_row = '';
            $disabled = 'disabled';
        }

        //generate page html from template
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(STOCK_ORDER,array(
                'ORDER_NUMBER'  => $order_number,
                'QTY'           =>  $dd_qty,
                'GSX_STOCK_ID'  =>  $order_id,
                'ERR_MESSAGE'   =>  $errMessage,
                'PARTS_ROWS'    =>  $parts_row,
                'PARTS_TOTAL'   =>  $parts_total_row,
                'DISABLED'      =>  $disabled
                ))));
    }

    //check if product needs adding to ds_products
    private function addProduct($partNumber,$partDescription,$stockPrice){

        if ($stockPrice == 0){

            $partNumber = 'A'.$partNumber;

        }

        $product = $this->db_select_single('ds_products', 'pID',array('pNum' => $partNumber));

        if(!is_array($product)){

            $part = array(
                'pName'     =>  $partDescription,
                'pNum'      =>  $partNumber,
                'pPrice'    =>  $stockPrice,
                'taxable'   =>  ($stockPrice == 0 ? 'N' : 'Y')
            );

            return $this->db_insert('ds_products', $part);

        }else{
            return 0;
        }
    }

    function disableEmails($id,$type){

        global $dbObj;

        //set table values based on type
        if($type == 'order'){
            $table = 'ds_orders';
            $keyid = 'oNum';
        }else{
            $table = 'ds_customers';
            $keyid = 'cString';
        }

        //check if we're saving a record
        if($_GET['saveclose']){


            //if we're dealing with an order, get the disables for customer too
            if ($type == 'order'){

                $ds_record = $this->db_select_single($table, 'customer_id',array($keyid => $id));
                $ds_customers = $this->db_select_single('ds_customers', 'disabled_emails',array('cString' => $ds_record['customer_id']));

                $customer_emails = unserialize($ds_customers['disabled_emails']);

                if (is_array($customer_emails)){
                    $disabled_keys = array_merge(array_keys($_POST),$customer_emails);
                }else{
                    $disabled_keys = array_keys($_POST);
                }

            }else{
                $disabled_keys = array_keys($_POST);
            }

            //store records in serialized array and write to database
            $disabled_emails = serialize($disabled_keys);

            $this->db_update($table, $keyid, $id, array('disabled_emails' => $disabled_emails));

            //write back javascript to close popup
            return $this->parse(TEMPLATE, array('BODY' => "<script type'text/javascript'>function displayMessage(){self.close();}</script>",array()));
            exit;
        }

        //get current disables
        if ($type == 'order'){
            $ds_record = $this->db_select_single($table, 'customer_id, disabled_emails',array($keyid => $id));
        }else{
            $ds_record = $this->db_select_single($table, 'disabled_emails',array($keyid => $id));
        }

        $disabled_array = unserialize($ds_record['disabled_emails']);

        //if order then also pull in customer disables and set customer checkboxes to disabled
        if ($type == 'order'){
            $ds_customers = $this->db_select_single('ds_customers', 'disabled_emails',array('cString' => $ds_record['customer_id']));

            $customer_array = unserialize($ds_customers['disabled_emails']);

            $disabled = array(
            'ID' => $id,
            'TYPE' => $type,
            'APPLECARE' =>  (in_array('APPLECARE', $customer_array) ? 'checked DISABLED' : (in_array('APPLECARE', $disabled_array) ? 'checked' : '')),
            'TWO_WEEK_THANKS' =>  (in_array('TWO_WEEK_THANKS', $customer_array) ? 'checked DISABLED' : (in_array('TWO_WEEK_THANKS', $disabled_array) ? 'checked' : '')),
            'ORDER_APPROVAL_EMAIL' =>  (in_array('ORDER_APPROVAL_EMAIL', $customer_array) ? 'checked DISABLED' : (in_array('ORDER_APPROVAL_EMAIL', $disabled_array) ? 'checked' : '')),
            'STILL_IN_DIAGNOSTIC' =>  (in_array('STILL_IN_DIAGNOSTIC', $customer_array) ? 'checked DISABLED' : (in_array('STILL_IN_DIAGNOSTIC', $disabled_array) ? 'checked' : '')),
            'ORDER_PARTS_EMAIL' =>  (in_array('ORDER_PARTS_EMAIL', $customer_array) ? 'checked DISABLED' : (in_array('ORDER_PARTS_EMAIL', $disabled_array) ? 'checked' : '')),
            'LOGIC_BOARD_REPAIR' =>  (in_array('LOGIC_BOARD_REPAIR', $customer_array) ? 'checked DISABLED' : (in_array('LOGIC_BOARD_REPAIR', $disabled_array) ? 'checked' : '')),
            'NOT_RECEIVED' =>  (in_array('NOT_RECEIVED', $customer_array) ? 'checked DISABLED' : (in_array('NOT_RECEIVED', $disabled_array) ? 'checked' : '')),
            'UPS_MACH_OUT_TODAY' =>  (in_array('UPS_MACH_OUT_TODAY', $customer_array) ? 'checked DISABLED' : (in_array('UPS_MACH_OUT_TODAY', $disabled_array) ? 'checked' : '')),
            'UPS_BOX_OUT_TODAY' =>  (in_array('UPS_BOX_OUT_TODAY', $customer_array) ? 'checked DISABLED' : (in_array('UPS_BOX_OUT_TODAY', $disabled_array) ? 'checked' : '')),
            'UPS_MACH_OUT_TOMORROW' =>  (in_array('UPS_MACH_OUT_TOMORROW', $customer_array) ? 'checked DISABLED' : (in_array('UPS_MACH_OUT_TOMORROW', $disabled_array) ? 'checked' : '')),
            'UPS_BOX_OUT_TOMORROW' =>  (in_array('UPS_BOX_OUT_TOMORROW', $customer_array) ? 'checked DISABLED' : (in_array('UPS_BOX_OUT_TOMORROW', $disabled_array) ? 'checked' : '')),
            'ORDER_PROCESS' =>  (in_array('ORDER_PROCESS', $customer_array) ? 'checked DISABLED' : (in_array('ORDER_PROCESS', $disabled_array) ? 'checked' : '')),
            'CHARGE_FAIL_MSG' =>  (in_array('CHARGE_FAIL_MSG', $customer_array) ? 'checked DISABLED' : (in_array('CHARGE_FAIL_MSG', $disabled_array) ? 'checked' : '')),
            'DIAGNOSTIC_FOLLOWUP' =>  (in_array('DIAGNOSTIC_FOLLOWUP', $customer_array) ? 'checked DISABLED' : (in_array('DIAGNOSTIC_FOLLOWUP', $disabled_array) ? 'checked' : '')),
            'AWAITING_PAYMENT' =>  (in_array('AWAITING_PAYMENT', $customer_array) ? 'checked DISABLED' : (in_array('AWAITING_PAYMENT', $disabled_array) ? 'checked' : '')));
        }else{
            $disabled = array(
            'ID' => $id,
            'TYPE' => $type,
            'APPLECARE' =>  (in_array('APPLECARE', $disabled_array) ? 'checked' : ''),
            'TWO_WEEK_THANKS' =>  (in_array('TWO_WEEK_THANKS', $disabled_array) ? 'checked' : ''),
            'ORDER_APPROVAL_EMAIL' =>  (in_array('ORDER_APPROVAL_EMAIL', $disabled_array) ? 'checked' : ''),
            'STILL_IN_DIAGNOSTIC' =>  (in_array('STILL_IN_DIAGNOSTIC', $disabled_array) ? 'checked' : ''),
            'ORDER_PARTS_EMAIL' =>  (in_array('ORDER_PARTS_EMAIL', $disabled_array) ? 'checked' : ''),
            'LOGIC_BOARD_REPAIR' =>  (in_array('LOGIC_BOARD_REPAIR', $disabled_array) ? 'checked' : ''),
            'NOT_RECEIVED' =>  (in_array('NOT_RECEIVED', $disabled_array) ? 'checked' : ''),
            'UPS_MACH_OUT_TODAY' =>  (in_array('UPS_MACH_OUT_TODAY', $disabled_array) ? 'checked' : ''),
            'UPS_BOX_OUT_TODAY' =>  (in_array('UPS_BOX_OUT_TODAY', $disabled_array) ? 'checked' : ''),
            'UPS_MACH_OUT_TOMORROW' =>  (in_array('UPS_MACH_OUT_TOMORROW', $disabled_array) ? 'checked' : ''),
            'UPS_BOX_OUT_TOMORROW' =>  (in_array('UPS_BOX_OUT_TOMORROW', $disabled_array) ? 'checked' : ''),
            'ORDER_PROCESS' =>  (in_array('ORDER_PROCESS', $disabled_array) ? 'checked' : ''),
            'CHARGE_FAIL_MSG' =>  (in_array('CHARGE_FAIL_MSG', $disabled_array) ? 'checked' : ''),
            'DIAGNOSTIC_FOLLOWUP' =>  (in_array('DIAGNOSTIC_FOLLOWUP', $disabled_array) ? 'checked' : ''),
            'AWAITING_PAYMENT' =>  (in_array('AWAITING_PAYMENT', $disabled_array) ? 'checked' : ''));
        }

        //return form
        //return $this->parse(TEMPLATE, array('BODY' => $this->parse(DISABLE_EMAILS,$disabled)));
        return $this->parse(DISABLE_EMAILS,$disabled);

    }

    function printLabels(){

        if ($_POST['printNoBarcode']){

            $print_data = explode("\n", $_POST['txtNoBarcode']);
            $print_copies = $_POST['cboNoBarcodeCopies'];
            $print_lines = $_POST['cboNoBarcodeLines'];

            $this->print_labels($print_data, $print_copies, $print_lines, constant($_POST['cboNoBarcodePrinter']),false);
        }

        if ($_POST['printBarcode'] && !$_POST['chkRetailBox']){

            $print_data = explode("\n", $_POST['txtBarcode']);
            $print_copies = $_POST['cboBarcodeCopies'];
            $print_lines = 0;

            $this->print_labels($print_data, $print_copies, $print_lines, constant($_POST['cboBarcodePrinter']),true);
        }

        if ($_POST['printRetailBox']){

            /*$zip = new ZipArchive();

            $filename = LABEL_TEMP_DIR.'Labels.zip';

            if ($zip->open($filename, ZipArchive::CREATE)!==TRUE) {
                exit("cannot open <$filename>\n");
            }*/

            $print_copies = $_POST['cboRetailBoxCopies'];

            $print_data = explode("\n", $_POST['txtRetailBox']);

            foreach ($print_data as $print){

                $data = $this->db_select_single('ds_orders', '*', array('oNum' => trim($print)));

                $this->print_retail_label($data,constant($_POST['cboRetailBoxPrinter']),$print_copies);

                //$zip->addFile(LABEL_TEMP_DIR.$file,$file);
                //$arrFiles[] = LABEL_TEMP_DIR.$file;


            }

            /*$zip->close();
            $this->send_zip_to_browser(LABEL_TEMP_DIR.'Labels.zip','Labels.zip');
            unlink(LABEL_TEMP_DIR.'Labels.zip');

            foreach ($arrFiles as $image){
                unlink($image);
            }*/


        }
		$dd_printers .= $this->buildPrinterList($_SESSION['printer_id'], 'printer_queue');

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PRINT_LABELS,array('PRINTERS' => $dd_printers)), "TITLE" => "Labels"));
    }

    function parts_lookup(){

        $errorscript = '';
        $serial_number = '';
        $machine_type = '';

        if ($_POST['submit']){

            $objGSX = new GSX();
            $objSearch = new Search();

            if ($_POST['serial_number'] != ''){

                $serial_number = $_POST['serial_number'];

                $product_model = $objGSX->get_product_model($serial_number);

                $machine_type = $product_model['configDescription'];

                if (!$machine_lookup = $this->db_select_single('machine_lookup', 'machine_id', array('machine_description' => $machine_type))){

                    $machine_id = $this->db_insert('machine_lookup', array('machine_description' => $product_model['configDescription'],'product_line' => $product_model['productLine'],'enabled' => '1'));

                }else{

                    $machine_id = $machine_lookup['machine_id'];

                }

                if ($gsxparts = $objGSX->get_parts($serial_number)){

                    $this->db_delete('parts_lookup','machine_id',$machine_id);

                    foreach ($gsxparts as $row){

                        $row['machine_id'] = $machine_id;

                        $this->db_insert('parts_lookup', $row);

                    }

                }

                $parts = $this->db_select_multiple('parts_lookup', '*', array('machine_id' => $machine_id),'order by partNumber');

                if (is_array($parts)){
                    $header =  '<table width="100%">
                                    <tr>
                                        <td width="100px" align="left">Serial Number:</td><td align="left">'.$serial_number.'</td>
                                        <td align="right">
                                            <form method="POST" action="' . CONTROLLER . '?m=parts_export">
                                                <input type="hidden" name="serial_number" value="'.$serial_number.'" />
                                                <input type="submit" value="Export" />
                                            </form>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="100px" align="left">Machine Type:</td><td align="left">'.$product_model['configDescription'].'</td>
                                    </tr>
                                </table>';

                    echo $this->parse(TEMPLATE, array('BODY' => $header.$objSearch->display_parts($parts)));

                    exit;
                }else{
                    $errorscript = '<script type="text/javascript">function displayMessage(){ alert("Invalid serial number entered, please check."); }</script>';
                }

            }  elseif ($_POST['machine_type'] != '') {

                $machine_type = $_POST['machine_type'];

                $machine_lookup = $this->db_select_single('machine_lookup', 'machine_id', array('machine_description' => $machine_type));

                $machine_id = $machine_lookup['machine_id'];

                if ($gsxparts = $objGSX->get_parts('',$machine_type)){

                    $this->db_delete('parts_lookup','machine_id',$machine_id);

                    foreach ($gsxparts as $row){

                        $row['machine_id'] = $machine_id;

                        $this->db_insert('parts_lookup', $row);

                    }

                }

                $parts = $this->db_select_multiple('parts_lookup', '*', array('machine_id' => $machine_id),'order by partNumber');

                //$parts = $objGSX->get_parts('',$machine_type);

                if (is_array($parts)){
                    $header =  '<table width="100%">
                                    <tr>
                                        <td align="left">Machine Type: '.$machine_type.'</td>
                                        <td align="right">
                                            <form method="POST" action="' . CONTROLLER . '?m=parts_export">
                                                <input type="hidden" name="machine_type" value="'.$machine_type.'" />
                                                <input type="submit" value="Export" />
                                            </form>
                                        </td>
                                    </tr>
                                </table>';

                    echo $this->parse(TEMPLATE, array('BODY' => $header.$objSearch->display_parts($parts)));

                    exit;
                    }else{
                    $errorscript = '<script type="text/javascript">function displayMessage(){ alert("Machine Type not recognised."); }</script>';
                    //disable unrecognised machine type
                    $this->db_update('machine_lookup', 'machine_description', $machine_type, array('enabled' => '0'));
                }

            }  else {
                $errorscript = '<script type="text/javascript">function displayMessage(){ alert("Please either enter a Serial Number or select a Machine Type"); }</script>';
            }
        }

        $products = $this->db_select_multiple('machine_lookup', 'distinct product_line',array('enabled' => '1'),'order by product_line');


        $var_json = 'var productJSONObj = {';

        $i = 0;

        //build json object to store products
        foreach ($products as $value){
            $product_data[] = array($value['product_line'],$value['product_line']);
            $machine_data = $this->db_select_multiple('machine_lookup', 'machine_description',array('enabled' => '1','product_line' => $value['product_line']),'order by product_line, machine_description');

            if ($i > 0){
                $var_json .= ',"'.$value['product_line'].'":';
            }else{
                $var_json .= '"'.$value['product_line'].'":';
            }

            foreach ($machine_data as $machine){
                $json_machine[] = array('machine' => $machine['machine_description']);
            }
            $json_data = json_encode($json_machine);

            unset($json_machine);

            $var_json .= $json_data;

            $i++;
        }

        $var_json .= '};';

        $product_select = $this->arrayToHtmlSelectOptions($product_data,true);

        $errorscript = '<script type="text/javascript">
                        function displayMessage(){
                            var product_line = document.getElementById("product_line")
                            if (product_line.selectedIndex != 0){
                                getMachines(product_line);
                            }
                        }
                        </script>';

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PARTS_LOOKUP_REQUEST,array('PRODUCT_LINE' => $product_select,
                                                                                            'ERROR_SCRIPT' => $errorscript,
                                                                                            'SERIAL_NUMBER' => $serial_number,
                                                                                            'VAR_JSON'      => $var_json
                ))));
    }

    function parts_export(){

        $objGSX = new GSX();
        $objSearch = new Search();

        if ($_POST['serial_number'] != ''){

            $serial_number = $_POST['serial_number'];

            $parts = $objGSX->get_parts($serial_number);
        }else{

            $machine_type = $_POST['machine_type'];

            $machine_lookup = $this->db_select_single('machine_lookup', 'machine_id', array('machine_description' => $machine_type));

            $machine_id = $machine_lookup['machine_id'];

            $parts = $this->db_select_multiple('parts_lookup', '*', array('machine_id' => $machine_id),'order by partNumber');
        }

        $content = $objSearch->export_parts($parts);

        $this->send_file_to_browser($content, 'parts_export.csv');
        exit;
    }

    function diag_form($oNum){

        global $orderObj;

        global $cartObj;

        $_POST['serialNumber'] = $_POST['sno'];
        $_POST['machineType'] = $_POST['ModelName'];
        $_POST['processorSpeed'] = $_POST['ProcessorSpeed'];

        //process receiving
        $this->receiving($oNum, $_POST);

        //if close redirect to order detail
        if (isset ($_POST['close'])){
            header('Location:'.CONTROLLER.'?m=order_detail&oNum='.$_POST['oNum']);
            exit;
        }

        //if save or print save changes to database
        if (isset($_POST['save']) || isset($_POST['print'])){

            foreach ($_POST as $k => $v){
                if (substr($k, 0,3) == 'chk'){
                    $_POST[$k] = 'checked';
                }
                $_POST[$k] = str_replace('"', "'", $_POST[$k]);
            }

            $diagArray = serialize($_POST);

            $this->db_update('ds_orders', 'oNum', $_POST['oNum'], array('diag_form' => $diagArray));

            $cartObj->check_changes(
                    $_POST['oNum'], $_POST['pID'][0], $_POST['pQty'][0], $_POST['pPrice'][0], $_POST['oNum']
            );

            //if save return to order detail
            if(isset ($_POST['save'])){
                header('Location:'.CONTROLLER.'?m=order_detail&oNum='.$_POST['oNum']);
                exit;
            }
        }

        //go to error page if not valid order
        if (!$data = $orderObj->get_data($oNum)) {
                $this->error_page(MISSING_RESULTS);
        }

        if ($_POST['coverageEndDate'] == ''){
            $warranty = 'N';
        }

        global $warehouse_staff;

        //sort warehouse staff array
        array_multisort($warehouse_staff);

        $dd_staff = array();
        foreach (array_keys($warehouse_staff) as $s) {
                $dd_staff[] = array($s, $warehouse_staff[$s]['name']);
        }

        //get header data
        $approval = $orderObj->determine_approval($oNum, $data);
        if ($data['serialNumber'] != ''){
            $isprevious = $orderObj->determine_previous($data['oNum'], $data['serialNumber']);
        }else{
            $isprevious = false;
        }
        $rma = 'checkbox-unchecked.gif';
        $disks = 'checkbox-unchecked.gif';
        $adapter = 'checkbox-unchecked.gif';
        $approved = 'checkbox-unchecked.gif';
        $warranty = 'checkbox-unchecked.gif';
        $previous = 'checkbox-unchecked.gif';
        if ($data['oRMA'] == 'Y') { $rma = 'checkbox.gif'; }
        if ($data['oACAdapter'] == 'Y') { $adapter = 'checkbox.gif'; }
        if ($data['oOSDisks'] == 'Y') { $disks = 'checkbox.gif'; }
        if ($data['oWarranty'] == 'Y') { $warranty = 'checkbox.gif'; }
        if ($approval) { $approved = 'checkbox.gif'; }
        if ($isprevious) { $previous = 'checkbox.gif'; }
        $parse = array(
                'RMA_CHECKED'			=> $rma
                , 'ADAPTER_CHECKED'		=> $adapter
                , 'DISKS_CHECKED'		=> $disks
                , 'APPROVE_CHECKED'		=> $approved
                , 'WARRANTY_CHECKED'	=> $warranty
                , 'PREVIOUS_CHECKED'        => $previous
                , 'CLEAR_SCRIPT'            => ""
                , 'PARTS'                   => $cartObj->diag_parts($oNum)
        );

        //fix serialized data from diag_form
        $unserialized = preg_replace('!s:(\d+):"(.*?)";!se', "'s:'.strlen('$2').':\"$2\";'", $data['diag_form'] );

        //read serialized form data into array
        $formvalues = unserialize($unserialized);

        foreach ($formvalues as $k => $v){

            if (substr($k, 0,2) == 'dd'){

                $formvalues[$k] = $this->arrayToHtmlSelectOptions($dd_staff, true, $v,array(),'');
            }
        }

        //print diagnostic summary label
        if ($_POST['summary']){
            $this->print_diagnostic($oNum,$data,$isprevious);
        }

        //if form values ar array merge with form data
        if (is_array($formvalues)){
            $merged_parse = array_merge($parse,$formvalues);
            if($_POST['print']){
                $to_write = $this->parse(DIAG_HEADER,array('BODY' => $orderObj->parse_order(DIAG_FORM, $data, $merged_parse, 'diag'),'ONUM' => $data['oNum']));
                $to_write = preg_replace('/__dd.*__/', $this->arrayToHtmlSelectOptions($dd_staff,true,false,array(),''), $to_write);
            }else{
                $to_write = $this->parse(TEMPLATE, array('BODY' => $orderObj->parse_order(DIAG_FORM, $data, $merged_parse, 'diag')));
                $to_write = preg_replace('/__dd.*__/', $this->arrayToHtmlSelectOptions($dd_staff,true,false,array(),''), $to_write);
            }
        }else{
            //generate script to blank form
            $clearscript = '<script type="text/javascript">
                function displayMessage()
                {
                    var elem = document.getElementById("frmDiag").elements;
                    for(var i = 0; i < elem.length; i++)
                    {
                        if(elem[i].type == "text" || elem[i].type == "textarea")
                        {
                            elem[i].value = "";
                        }
                    }
                }
            </script>';

            $parse['CLEAR_SCRIPT'] = $clearscript;
            $merged_parse = $parse;
            $to_write = $this->parse(TEMPLATE, array('BODY' => $orderObj->parse_order(DIAG_FORM, $data, $merged_parse, 'diag')));
            $to_write = preg_replace('/__dd.*__/', $this->arrayToHtmlSelectOptions($dd_staff,true,false,array(),''), $to_write);
        }

        //write form to page
        echo $to_write;

        exit;

    }

    # CHECK IN
    function check_in($data){
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(CHECK_IN,$data), "TITLE" => "Check In"));
    }

    # CHECK IN
    function system_profiler(){

        global $adminObj;

        $order = $this->db_select_single('ds_orders', 'oNum',array('oNum' => $_POST['order_number']));

        if (!$order){
            $errorscript = 'function displayMessage(){ alert("'.$_POST['order_number'].' is not a valid order number."); }';
            $adminObj->check_in(array("ERROR_MESSAGE" => "","VALUE" => $_POST['order_number'],'ERROR_SCRIPT' => $errorscript));
            exit;
        }

        $data = array(
            'ONUM'  =>  $_POST['order_number']
        );


        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(SYSTEM_PROFILER,$data), "TITLE" => "System Profiler"));

    }

    function process_metrics(){

        if ($_POST['time_frame']){
            $current_time_frame = $_POST['time_frame'];
        }elseif ($_GET['time_frame']){
            $current_time_frame = urldecode($_GET['time_frame']);
        }else{
            $current_time_frame = 'Today';
        }

        switch ($current_time_frame){
            case 'Today':
                $starttime = $this->format_date('db_date');
                $endtime = $this->format_date('db_date',time()+(60*60*24));
                break;
            case 'Yesterday':
                $starttime = $this->format_date('db_date',time()-(60*60*24));
                $endtime = $this->format_date('db_date');
                break;
            case 'This Week':
                if ($this->format_date('day') != "Mon"){
                    $starttime = $this->format_date('db_date', strtotime('last monday'));
                    $endtime = $this->format_date('db_date', strtotime('last monday + 4 days'));
                }else{
                    $starttime = $this->format_date('db_date');
                    $endtime = $this->format_date('db_date',time()+(60*60*24));
                }
                break;
            case 'Last Week':
                if ($this->format_date('day') == "Mon"){
                    $starttime = $this->format_date('db_date', strtotime('last monday'));
                    $endtime = $this->format_date('db_date', strtotime('last monday + 4 days'));
                }else{
                    $starttime = $this->format_date('db_date', strtotime('last monday - 7 days'));
                    $endtime = $this->format_date('db_date', strtotime('last monday - 3 days'));
                }
                break;
            case 'This Month':
                $starttime = $this->format_date('db_date',strtotime('first day of this month'));
                $endtime = $this->format_date('db_date',time()+(60*60*24));
                break;
            case 'Last Month':
                $starttime = $this->format_date('db_date',strtotime('first day of last month'));
                $endtime = $this->format_date('db_date',strtotime('last day of last month'));
                break;
            case 'All Time':
                $starttime = false;
                break;
            case 'Date Range':
                $starttime = $this->format_date('db_date', strtotime($_POST['start_date']));
                $endtime = $this->format_date('db_date', strtotime($_POST['end_date']));
                break;
            default :
                $starttime = $this->format_date('db_date');
                $endtime = $this->format_date('db_date',time()+(60*60*24));
        }

        if (!$_GET['aid']){

            $orderby = ' ORDER BY aUser ASC';

            if ($starttime){
                $sql = 'SELECT aID, aUser, COUNT(audit_summary_id) AS audit_count, product_type, sec_to_time(avg(TIME_TO_SEC(audit_time))) AS avg_audit_time
                        FROM audit_summary
                        WHERE aID > 0 AND aUser IS NOT NULL AND product_type IS NOT NULL AND order_number IS NOT NULL AND start_time BETWEEN "'.$starttime.'" AND "'.$endtime.'"
                        GROUP BY aID, aUser, product_type'.$orderby;
            }else{
                $sql = 'SELECT aID, aUser, COUNT(audit_summary_id) AS audit_count, product_type, sec_to_time(avg(TIME_TO_SEC(audit_time))) AS avg_audit_time
                        FROM audit_summary
                        WHERE aID > 0 AND aUser IS NOT NULL AND product_type IS NOT NULL
                        GROUP BY aID, aUser, product_type'.$orderby;
            }

            $audit_summary = $this->db_query($sql, 'select-multiple');

            $audit_array = array();

            foreach ($audit_summary as $audit){

                $audit_array[$audit['aID']]['aUser'] = $audit['aUser'];
                $audit_array[$audit['aID']]['aID'] = $audit['aID'];
                $audit_array[$audit['aID']][$audit['product_type']]['count'] = $audit['audit_count'];
                $audit_array[$audit['aID']][$audit['product_type']]['audit_time'] = $audit['avg_audit_time'];
            }

            $audit_table = '<table class="sortable">';
            $audit_table .= '<tr><td style="width:100px;"><strong>Name</strong></td><td align="right" style="width:100px;"><strong>iPads</strong></td><td align="right" style="width:100px;"><strong>AT</strong></td><td align="right" style="width:100px;"><strong>Laptops</strong></td><td align="right" style="width:100px;"><strong>AT</strong></td><td align="right" style="width:100px;"><strong>iMacs</strong></td><td align="right" style="width:100px;"><strong>AT</strong></td></tr>';

            foreach ($audit_array as $audit_row){
                $audit_table .= '<tr>';
                $audit_table .= '<td><a href='.CONTROLLER.'?m=process_metrics&aid='.$audit_row['aID'].'&time_frame='.urlencode($current_time_frame).'>'.$audit_row['aUser'].'</a></td>';
                $audit_table .= '<td align="right">'.$audit_row['IPAD']['count'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['IPAD']['audit_time'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['MACBOOK']['count'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['MACBOOK']['audit_time'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['IMAC']['count'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['IMAC']['audit_time'].'</td>';
                $audit_table .= '</tr>';
            }

            $audit_table.= '</table>';

            if ($starttime){
                $sql = 'SELECT COUNT(audit_summary_id) AS audit_count, product_type, sec_to_time(avg(TIME_TO_SEC(audit_time))) AS avg_audit_time
                        FROM audit_summary
                        WHERE aID > 0 AND aUser IS NOT NULL AND product_type IS NOT NULL AND order_number IS NOT NULL AND start_time BETWEEN "'.$starttime.'" AND "'.$endtime.'"
                        GROUP BY product_type';
            }else{
                $sql = 'SELECT COUNT(audit_summary_id) AS audit_count, product_type, sec_to_time(avg(TIME_TO_SEC(audit_time))) AS avg_audit_time
                        FROM audit_summary
                        WHERE aID > 0 AND aUser IS NOT NULL AND product_type IS NOT NULL
                        GROUP BY product_type';
            }

            $audit_totals = $this->db_query($sql, 'select-multiple');

            $totals_array = array();

            foreach ($audit_totals as $total){

                $totals_array[$total['product_type']]['count'] = $total['audit_count'];
                $totals_array[$total['product_type']]['audit_time'] = $total['avg_audit_time'];
            }

            $audit_table .= '<table>';
            $audit_table .= '<tr>';
            $audit_table .= '<td style="width:100px;"><strong>Totals</strong></td>';


            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['IPAD']['count'].'</strong></td>';
            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['IPAD']['audit_time'].'</strong></td>';
            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['MACBOOK']['count'].'</strong></td>';
            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['MACBOOK']['audit_time'].'</strong></td>';
            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['IMAC']['count'].'</strong></td>';
            $audit_table .= '<td align="right" style="width:100px;"><strong>'.$totals_array['IMAC']['audit_time'].'</strong></td>';


            $audit_table .= '</tr>';
            $audit_table .= '</table>';
        }else{

            $sql = 'SELECT DISTINCT start_time, serialNumber,order_number,model_number,grade,audit_time'
                    . ' FROM audit_summary'
                    . ' WHERE aID = "'.$_GET['aid'].'" AND start_time BETWEEN "'.$starttime.'" AND "'.$endtime.'" AND order_number IS NOT NULL';

            $audit_summary = $this->db_query($sql, 'select-multiple');

            $audit_table = '<table class="sortable">';
            $audit_table .= '<tr><td><strong>Date</strong></td><td><strong>Serial Number</strong></td><td><strong>Order Number</strong></td><td><strong>Model Number</strong></td><td><strong>Grade</strong></td><td align="right"><strong>Time to complete</strong></td></tr>';

            foreach ($audit_summary as $audit_row){
                $audit_table .= '<tr>';
                $audit_table .= '<td>'.$audit_row['start_time'].'</td>';
                $audit_table .= '<td>'.$audit_row['serialNumber'].'</td>';
                $audit_table .= '<td>'.$audit_row['order_number'].'</td>';
                $audit_table .= '<td>'.$audit_row['model_number'].'</td>';
                $audit_table .= '<td>'.$audit_row['grade'].'</td>';
                $audit_table .= '<td align="right">'.$audit_row['audit_time'].'</td>';
                $audit_table .= '</tr>';
            }

            $audit_table .= '</tr>';
            $audit_table .= '</table>';

        }

        $time_frames = array('Today','Yesterday','This Week','Last Week','This Month','Last Month','All Time','Date Range');

        $time_frame = '<select id="time_frame" name="time_frame">';
        foreach ($time_frames as $frame){
            if ($current_time_frame == $frame){
                $time_frame .= '<option selected>'.$frame.'</option>';
            }else{
                $time_frame .= '<option>'.$frame.'</option>';
            }
        }
        $time_frame .= '</select>';

        if ($current_time_frame == 'Date Range'){
            $start_date = $_POST['start_date'];
            $end_date = $_POST['end_date'];
        }else{
            $start_date = '';
            $end_date = '';
        }

        $data = array(
            'CONTENT' => $audit_table,
            'TIME_FRAME' => $time_frame,
            'START_DATE' => $start_date,
            'END_DATE' => $end_date
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PROCESS_METRICS,$data)));
    }

    function authorizations($oNum){

        global $orderObj;

        //get data
        $data = $orderObj->get_data($oNum);

        //create input html
        $bill = $this->get_fields('ds_orders', $data, 1, array('cBillFname', 'cBillLname', 'cBillAddress1', 'cBillAddress2', 'Billing City, State, Zip'));
        $pay = $this->get_fields('ds_orders', $data, 1, array('ccName', 'ccNum', 'ccExp', 'CVV2'));

        //return html
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(AUTHORIZATIONS,array('BILL' => $bill, 'PAY' => $pay, 'ONUM' => $oNum))));

    }

    function multiple_orders($cString){

        global $ship_methods;

        //parse page content
        $parse = array(
            'SHIP_METHODS'	=> $this->arrayToHtmlSelectOptions(array_keys($ship_methods), false, $shipping[$i]),
            'CSTRING'       => $cString
        );

        //return html
        return $this->parse(MULTIPLE_ORDERS,$parse);
    }

    function update_multiple_status($data,$new_status,$note=''){
        global $orderObj;

        foreach ($data as $oNum){
            if (strlen($oNum) > 8){
                $order = $this->db_select_single('ds_orders', 'oNum', array('serialNumber' => $oNum));
                $oNum = $order['oNum'];
            }
            if ($new_status != ''){
                $orderObj->update_status(trim($oNum),$new_status);
            }
            if ($note != ''){
                $this->db_update('ds_orders', 'oNum', trim($oNum), array('cShipInstruct' => "concat(cShipInstruct, '\n" . mysql_real_escape_string($note) . '\')'));
            }
        }


    }

    function edit_items(){

        //set defaults
        $start = 0;
        $rowcount = 100;
        $sort = 'pNum';
        $order = 'ASC';
        $neworder = 'ASC';
        $args = '';

        $filter = '';

        $search_text = '';

        //get variables
        if ($_GET['start']){
            $start = $_GET['start'];
        }

        if ($_GET['search_text']){
            $search_text = $_GET['search_text'];
            $start = 0;
        }

        if ($_POST['search_text']){
            $search_text = $_POST['search_text'];
            $start = 0;
        }

        if ($_GET['sort']){
            $sort = $_GET['sort'];
        }

        if ($_GET['order']){
            $order = $_GET['order'];
        }

        if ($_GET['neworder']){
            $neworder = $_GET['neworder'];
            $order = $_GET['neworder'];
        }


        //update records of changed items
        if ($_POST['submit']){

            foreach ($_POST as $k => $v){
                if ($v['changed']  == 'Y'){
                    $taxable = ($v['taxable'] ? 'Y' : 'N');
                    $this->db_update('ds_products', 'pID', $k, array('pNum' => $v['pNum'],'pName' => $v['pName'],'pPrice' => $v['pPrice'],'taxable' => $taxable));
                }
            }
        }


        //get data for grid
        if ($_POST['clear']){
            $search_text = '';
        }

        if ($search_text != ''){
            $filter = 'WHERE pNum LIKE "%'.$search_text.'%" ';
        }

        $products = $this->db_select_multiple('ds_products', 'pNum, pName, pID, pPrice, taxable',array(),$filter.'ORDER BY '.$sort.' '.$order.' LIMIT '.$start.','.$rowcount);

        if ($_GET['neworder'] == 'ASC'){
            $neworder = 'DESC';
        }else{
            $neworder = 'ASC';
        }

        if ($products == 0){
            $table = '<tr><td><strong>No items match your search string.</strong></td></tr>';
        }else{
            //create navigation
            if (count($products) >= $rowcount && $start == 0){
                $navigation = '<tr>
                                <td colspan="5" align="right"><a href="'.CONTROLLER.'?m=edit_items&start='.($start+$rowcount).'&search_text='.$search_text.'&sort='.$sort.'&order='.$order.'">Next>></a></td>
                        </tr>';
            }elseif (count($products) >= $rowcount && $start > 0) {
                $navigation = '<tr>
                                <td colspan="2" align="left"><a href="'.CONTROLLER.'?m=edit_items&start='.($start-$rowcount).'&search_text='.$search_text.'&sort='.$sort.'&order='.$order.'">&lt;&lt;Previous</a></td>
                                <td colspan="3" align="right"><a href="'.CONTROLLER.'?m=edit_items&start='.($start+$rowcount).'&search_text='.$search_text.'&sort='.$sort.'&order='.$order.'">Next&gt;&gt;</a></td>
                        </tr>';
            }elseif (count($products) < $rowcount && $start > 0) {
                $navigation = '<tr>
                                <td colspan="5" align="left"><a href="'.CONTROLLER.'?m=edit_items&start='.($start-$rowcount).'&search_text='.$search_text.'&sort='.$sort.'&order='.$order.'">&lt;&lt;Previous</a></td>
                        </tr>';
            }else{
                $navigation = '<tr>
                                <td colspan="5" align="left">&nbsp;</td>
                        </tr>';
            }

            $table = $navigation;

            //create headers
            $table .= '<tr>
                            <td class="subheading1" width="20%"><a id="ID" onMouseOver="headerMouseOver(this);" onMouseOut="headerMouseOut(this);" href="'.CONTROLLER.'?m=edit_items&start=0&search_text='.$search_text.'&sort=pID&neworder='.$neworder.'">ID</a></td>
                            <td class="subheading1" width="20%"><a id="Part_Number" onMouseOver="headerMouseOver(this);" onMouseOut="headerMouseOut(this);" href="'.CONTROLLER.'?m=edit_items&start=0&search_text='.$search_text.'&sort=pNum&neworder='.$neworder.'">Part Number</a></td>
                            <td class="subheading1" width="40%"><a id="Description" onMouseOver="headerMouseOver(this);" onMouseOut="headerMouseOut(this);" href="'.CONTROLLER.'?m=edit_items&start=0&search_text='.$search_text.'&sort=pName&neworder='.$neworder.'">Description</a></td>
                            <td class="subheading1" width="20%"><a id="Price" onMouseOver="headerMouseOver(this);" onMouseOut="headerMouseOut(this);" href="'.CONTROLLER.'?m=edit_items&start=0&search_text='.$search_text.'&sort=pPrice&neworder='.$neworder.'">Price</a></td>
                    </tr>';

            //create product rows
            foreach ($products as $row){

                $table .= '<tr>';

                $table .= '<td><a href="'.CONTROLLER.'?m=view_item&pID='.$row['pID'].'">'.$row['pID'].'</a></td>';
                $table .= '<td>'.$row['pNum'].'</td>';
                $table .= '<td>'.$row['pName'].'</td>';
                $table .= '<td>'.$row['pPrice'].'</td>';

                $table .= '</td>';

                $table .= '<input type="hidden" id="'.$row['pID'].'[changed]" name="'.$row['pID'].'[changed]" />';

            }

            $table .= $navigation;
        }


        if (!$_POST['clear']){
            $args = '&start='.$start.'&search_text='.$search_text.'&sort='.$sort.'&order='.$order;
        }

        //generate page
        echo $this->parse(TEMPLATE,  array('BODY' => $this->parse(EDIT_ITEMS,array('BODY' => $table,'SEARCH' => $search_text,'ARGS' => $args))));

    }

    function view_item($pID,$machine_id){

        if ($_POST['edit']){
            $this->edit_item($_POST);
            exit;
        }

        if ($_POST['back']){

            if ($_POST['machine_id']){
                $this->goToURL(CONTROLLER.'?m=machine_detail&machine_id='.$_POST['machine_id']);
            }else{
                $this->goToURL(CONTROLLER.'?m=edit_items');
            }
            exit;
        }

        if ($_POST['save']){

            if ($_POST['catID']){
                $this->db_delete('ds_product_categories', 'pID', $pID);

                $this->db_insert('ds_product_categories', array('pID' => $pID,'catID' => $_POST['catID'],'sortOrder' => 0));
            }

            If ($_POST['taxable']){
                $taxable = 'Y';
            }else{
                $taxable = 'N';
            }

            $update = array(
                'taxable'       => $taxable
                ,'tech_notes'   => $_POST['tech_notes']
                ,'pName'        => $_POST['pname']
                ,'pPrice'       => $_POST['price']
            );

            $this->db_update('ds_products', 'pID', $pID, $update);
        }

        $ds_product = $this->db_select_single('ds_products', '*', array('pID' => $pID));

        $join = array(
            'ds_product_categories dpc on dpc.catID = dc.catID'
        );

        $category = $this->db_select_single('ds_categories dc', 'dc.catName', array('dpc.pID' => $pID), '', $join);

        $ds_categories = $this->db_select_multiple('ds_categories', 'catID, catName', array(), 'order by catName');

        $dd_categories = $this->arrayToHtmlSelectOptions($ds_categories, true, $category['catID']);

        $join = array('machine_parts_map mpm on mpm.machine_id = ml.machine_id');

        $machines = $this->db_select_multiple('machine_lookup ml', 'distinct ml.machine_id, ml.machine_description', array('mpm.pID' => $pID), 'order by ml.machine_description', $join);

        foreach ($machines as $row){

            $works_with .= '<tr><td><a href="'.CONTROLLER.'?m=machine_detail&machine_id='.$row['machine_id'].'">'.$row['machine_description'].'</a></td></tr>';
        }

        if (file_exists(HTML_FOLDER.'images/service_parts/'.$ds_product['pNum'].'.gif')){
            $image = '<img src="'.SITE_SURL.'images/service_parts/'.$ds_product['pNum'].'.gif" />';
        }elseif (file_exists(HTML_FOLDER.'images/service_parts/'.$ds_product['pNum'].'_350_350.gif')) {
            $image = '<img src="'.SITE_SURL.'images/service_parts/'.$ds_product['pNum'].'_350_350.gif" />';
        }else{
            $image = '';
        }

        if (in_array($_SESSION['aUser'],array('justin','robert','jeff'))){
            $edit_visible = '';
        }else{
            $edit_visible = 'style="display:none;"';
        }

        $parse = array(
            'PID'       =>  $ds_product['pID']
            ,'PNUM'      =>  $ds_product['pNum']
            ,'PNAME'    =>  $ds_product['pName']
            ,'PRICE'    => $ds_product['pPrice']
            ,'TAXABLE'  =>  ($ds_product['taxable'] == 'Y' ? 'checked' : '')
            ,'CATEGORY' =>  $dd_categories
            ,'WORKS_WITH'   =>  $works_with
            ,'TECH_NOTES'   =>  $ds_product['tech_notes']
            ,'MACHINE_ID'    =>  $machine_id
            ,'IMAGE'        =>  $image
            ,'EDIT_VISIBLE' =>  $edit_visible
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(VIEW_ITEM, $parse)));
    }

    function edit_item($data){

        $pID = $data['pID'];

        if ($_POST['back']){

            if ($_POST['machine_id']){
                $this->goToURL(CONTROLLER.'?m=machine_detail&machine_id='.$_POST['machine_id']);
            }else{
                $this->goToURL(CONTROLLER.'?m=edit_items');
            }
            exit;
        }

        if ($_POST['cancel']){
            $this->goToURL(CONTROLLER.'?m=view_item&pID='.$pID);
            exit;
        }

        if ($_POST['save']){

            $this->db_delete('machine_parts_map', 'pID', $pID);

            foreach ($_POST['works_with'] as $k => $v){

                $this->db_insert('machine_parts_map', array('machine_id' => $k, 'pID' => $pID));
            }

            if ($_POST['catID']){
                $this->db_delete('ds_product_categories', 'pID', $pID);

                $this->db_insert('ds_product_categories', array('pID' => $pID,'catID' => $_POST['catID'],'sortOrder' => 0));
            }

            If ($_POST['taxable']){
                $taxable = 'Y';
            }else{
                $taxable = 'N';
            }

            $update = array(
                'taxable'       => $taxable
                ,'pName'        => $_POST['pname']
                ,'pPrice'       => $_POST['price']
            );

            $this->db_update('ds_products', 'pID', $pID, $update);

            $this->goToURL(CONTROLLER.'?m=view_item&pID='.$pID);
            exit;
        }

        $ds_product = $this->db_select_single('ds_products', '*', array('pID' => $pID));

        $join1 = array('product_line pl on pl.product_line = ml.product_line');

        $machine_lookup = $this->db_select_multiple('machine_lookup ml', 'ml.machine_id, ml.machine_description, ml.product_line, pl.product_line_id',array('enabled' => '1'),'order by pl.sort_order, ml.machine_description',$join1);

        $join2 = array('machine_parts_map mpm on mpm.machine_id = ml.machine_id');

        $machines = $this->db_select_multiple('machine_lookup ml', 'distinct ml.machine_id', array('mpm.pID' => $pID), '', $join2);

        $join3 = array(
            'ds_product_categories dpc on dpc.catID = dc.catID'
        );

        $category = $this->db_select_single('ds_categories dc', 'dc.catID', array('dpc.pID' => $pID), '', $join3);

        $ds_categories = $this->db_select_multiple('ds_categories', 'catID, catName', array(), 'order by catName');

        $dd_categories = $this->arrayToHtmlSelectOptions($ds_categories, true, $category['catID']);

        foreach ($machines as $row){
            $works_with[] = $row['machine_id'];
        }

        $product_line = '';

        $i = 0;

        $allchecked = true;

        foreach ($machine_lookup as $row){

            if ($row['product_line'] != $product_line){
                if ($i > 0){
                    if ($allchecked == true){
                        $table_columns[$i] = str_replace('__CHECKED__', 'checked',$table_columns[$i]);
                    }else{
                        $table_columns[$i] = str_replace('__CHECKED__', '',$table_columns[$i]);
                    }
                }
                $i++;
                $allchecked = true;
                $product_line = $row['product_line'];
                $table_columns[$i] = '<tr><td>&nbsp;</td></tr><tr><td style="font-weight:bold;"><input onchange="checkColumn('.($i-1).',this);" __CHECKED__ type="checkbox" id="product_line['.$row['product_line_id'].']" name="product_line['.$row['product_line_id'].']" />'.$product_line.'</td></tr>';
            }

            if (in_array($row['machine_id'], $works_with)){
                $table_columns[$i] .= '<tr><td><input onchange="uncheckHead('.($i-1).');" type="checkbox" id="works_with['.$row['machine_id'].']" name="works_with['.$row['machine_id'].']" checked />'.$row['machine_description'].'</td></tr>';
            }else{
                $allchecked = false;
                $table_columns[$i] .= '<tr><td><input onchange="uncheckHead('.($i-1).');" type="checkbox" id="works_with['.$row['machine_id'].']" name="works_with['.$row['machine_id'].']" />'.$row['machine_description'].'</td></tr>';
            }

        }

        $i = 0;
        $j = 0;

        $table = '<table><tr>';

        foreach ($table_columns as $column){

            if ($i < 4){
                $table .= '<td valign="top"><table id="table'.$j.'">'.$column.'</table></td>';
                $i++;
            }else{
                $table .= '</tr><tr><td valign="top"><table id="table'.$j.'">'.$column.'</table></td>';
                $i = 1;
            }

            $j++;
        }

        $table .= '</tr></table>';

        if (file_exists(HTML_FOLDER.'images/service_parts/'.$ds_product['pNum'].'.gif')){
            $image = '<img src="'.SITE_SURL.'images/service_parts/'.$ds_product['pNum'].'.gif" />';
        }elseif (file_exists(HTML_FOLDER.'images/service_parts/'.$ds_product['pNum'].'_350_350.gif')) {
            $image = '<img src="'.SITE_SURL.'images/service_parts/'.$ds_product['pNum'].'_350_350.gif" />';
        }else{
            $image = '';
        }

        $parse = array(
            'PID'       =>  $ds_product['pID']
            ,'PNUM'      =>  $ds_product['pNum']
            ,'PNAME'    =>  $ds_product['pName']
            ,'PRICE'    =>  $ds_product['pPrice']
            ,'TAXABLE'  =>  ($ds_product['taxable'] == 'Y' ? 'checked' : '')
            ,'CATEGORY' =>  $dd_categories
            ,'WORKS_WITH'   =>  $table
            ,'TECH_NOTES'   =>  $ds_product['tech_notes']
            ,'IMAGE'        =>  $image
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(EDIT_ITEM, $parse)));
    }

    function get_machine_info($serialNumber){

        //global $gsxObj;

        /*$data['oWarranty'] = 'N';
        $data['warrantyEndDate'] = '';
        $data['warrantyStatus'] = '';
        $data['daysRemaining'] = 0;

        $gsxObj->check_warranty_status($serialNumber);
        if ($gsxObj->get_warranty_end_timestamp() > time() + (86400 * 2)) {
                $data['oWarranty'] = 'Y';
                $data['warrantyEndDate'] = $this->format_date('db_date', $gsxObj->get_warranty_end_timestamp());
                $warranty_status = $gsxObj->get_warranty_status($serialNumber);
                $data['warrantyStatus'] = $warranty_status['warrantyStatus'];
                $data['daysRemaining'] = intval($warranty_status['daysRemaining']);
        }*/

        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        if (strlen($serialNumber) < 13){
            $configCode = substr($serialNumber,8);
        }else{
            $configCode = substr($serialNumber,9);
        }

        /*$sql = 'select ml.machine_description configDescription
                from product_model pm
                left join machine_lookup ml on ml.machine_id = pm.machine_id
                where pm.configCode = "'.$configCode.'"';*/

        //check if config in database
        /*if (!$machineInfo = $this->db_query($sql, 'select-single')){

            //if not, get from GSX
            if($machineInfo = $gsxObj->get_product_model($serialNumber)){

                //check if machine in database
                if (!$machine_id = $this->db_select_single('machine_lookup', 'machine_id', array('machine_description' => $machineInfo['configDescription']))){

                    $machine_lookup = array(
                        'machine_description'   =>  $machineInfo['configDescription']
                        ,'product_line'         =>  $machineInfo['productLine']
                        ,'enabled'              =>  '1'
                    );

                    //if not, add to database
                    $machine_id = $this->db_insert('machine_lookup', $machine_lookup);

                    //get parts for machine
                    if ($gsxparts = $gsxObj->get_parts($serialNumber)){

                        $this->db_delete('parts_lookup','machine_id',$machine_id);

                        foreach ($gsxparts as $row){

                            $row['machine_id'] = $machine_id;

                            $this->db_insert('parts_lookup', $row);

                        }

                    }

                }

                if (is_array($machine_id)){
                    $machine_id = $machine_id['machine_id'];
                }

                //add config to database
                if (!$product_model_id = $this->db_select_single('product_model', 'product_model_id', array('configCode' => $configCode))){

                    $product_model = array(
                        'configCode'    =>  $configCode
                        ,'machine_id'   =>  $machine_id
                    );

                    $this->db_insert('product_model', $product_model);

                }
            }

        }*/

        $sql = 'select ml.machine_description configDescription
                from product_model pm
                left join machine_lookup ml on ml.machine_id = pm.machine_id
                where pm.configCode = "'.$configCode.'"';

        $machineInfo = $this->db_query($sql, 'select-single');


        if (!$machineInfo['configDescription']){
            echo 'Serial number not recognized.';
            exit;
        }

        if (substr($machineInfo['configDescription'],0,1) == "~"){
            $machineInfo['configDescription'] = substr($machineInfo['configDescription'], 5);
        }

        $data['configDescription'] = $machineInfo['configDescription'];

        echo json_encode($data);

    }

    function get_grades($serialNumber, $identifier){

        global $osx_versions, $ios_versions, $hdvolumes, $orderObj;

        $is_ipad = false;
        $is_imac = false;

        $locSerialNumber = $serialNumber;
		$data['hdnSerialNumber'] = '';

		$sql = "SELECT dso.oNum, dso.cStatus, dso.serialNumber FROM ds_orders AS dso WHERE dso.cStatus = 'Refurb - Imaged' AND dso.serialNumber = '$serialNumber' ORDER BY oNum DESC LIMIT 1;";
		$item = $this->db_query($sql, 'select-single', true);
		$data['itemfound'] = $item;
		if ($item['serialNumber']) {
			$serialNumber = $item['oNum'];
			$data['foundoNum'] = $item;
		}

        if (strlen($serialNumber) == 8){
            $order = $orderObj->get_data($serialNumber);
        }else{
            $data['hdnSerialNumber'] = $serialNumber;
        }

        if ($order['oNum']){

            if ($order['is_ipad']){
                $is_ipad = true;
                $oss = $ios_versions;
                if (strpos($machine_description, 'iMac') !== false){
                    $is_imac = true;
                }
            }else{
                $is_ipad = false;
                $oss = $osx_versions;
            }

            $data['oNum'] = $order['oNum'];
            $data['is_ipad'] = $is_ipad;
            $data['oss'] = $oss;
            $data['capacity'] = $order['capacity'];
            $data['hdnSerialNumber'] = $order['serialNumber'];
            $serialNumber = $order['serialNumber'];
            $data['os_version'] = $order['os_version'];
            $data['mdm_lock'] = $order['mdm_lock']==1?'true':'false';
            $data['activation_lock'] = $order['activation_lock']==1?'true':'false';
			$data['poNumber'] = $order['poNumber'];
			$data['grade'] = $order['grade'];
			if ($order['grade'] && $order['grade'] != '') {
				$data['already_audited'] = true;
				$query = "SELECT dol.oNum, dso.cStatus, dol.details, dol.time FROM ds_order_logs AS dol LEFT JOIN ds_orders AS dso ON dol.oNum = dso.oNum WHERE dol.oNum='{$order['oNum']}' AND dol.details LIKE 'Audited%' ORDER BY dol.time DESC LIMIT 1;";
				$data['previous_audit'] = $this->db_query($query, 'select-single', true);
			}
            //$return_json = json_encode($data);

            //echo $return_json;
        }else{
            $serialNumber = '';
        }
        //}else{

        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        if ($serialNumber != ''){
            if (strlen($serialNumber) < 13){
                $configCode = substr($serialNumber,8);
            }else{
                $configCode = substr($serialNumber,9);
            }
        }else{
			$configCode = $identifier;
            // if (strlen($serialNumber) < 13){
            //     $configCode = substr($locSerialNumber,8);
            // }else{
            //     $configCode = substr($locSerialNumber,9);
            // }
		}

        $sql = 'select mgs.grade, mgs.symptoms, pm.machine_id, ml.product_line, ml.machine_description, ml.model_number, mon.order_number
                from machine_grading_scale mgs
                left join machine_lookup ml on ml.model_number = mgs.model_number
                left join product_model pm on pm.machine_id = ml.machine_id
                left join machine_order_number mon on mon.machine_id = pm.machine_id
                where pm.configCode = "'.$configCode.'" and mon.enabled is not null
                order by mgs.grade';

        $grades = $this->db_query($sql, 'select-multiple');

        if ($grades){
            $machine_id = $grades[0]['machine_id'];
            $machine_description = $grades[0]['machine_description'];
            $model_number = $grades[0]['model_number'];
            $product_line = $grades[0]['product_line'];
        }else{

            $sql = 'select pm.machine_id, ml.product_line, ml.machine_description, ml.model_number
                from machine_lookup ml
                left join product_model pm on pm.machine_id = ml.machine_id
                where pm.configCode = "'.$configCode.'"';

                $machine_info = $this->db_query($sql, 'select-single');

                $machine_id = $machine_info['machine_id'];
                $machine_description = $machine_info['machine_description'];
                $model_number = $machine_info['model_number'];
                $product_line = $machine_info['product_line'];
        }

        /*if (strpos($machine_description, 'iPad') === false && strpos($machine_description, 'iPod') === false){
            $is_ipad = false;
            $oss = $osx_versions;
            if (strpos($machine_description, 'iMac') !== false){
                $is_imac = true;
            }
        }else{
            $is_ipad = true;
            $oss = $ios_versions;
        }*/

        if (strtoupper($product_line) == 'IPAD'){
            $is_ipad = true;
            $oss = $ios_versions;
        }else{
            $is_ipad = false;
            $oss = $osx_versions;
            if (strpos($machine_description, 'iMac') !== false){
                $is_imac = true;
            }
        }

        /*$sql = 'select distinct order_number
                from machine_order_number
                where machine_id = "'.$machine_id.'"';

        $models = $this->db_query($sql, 'select-multiple');

        foreach ($models as $model){
            $modelstr .= $model['order_number'];
        }

        $return = '<table>';

        $return .= '<tr><td>'.$machine_description.' '.$model_number.' '.$modelstr.'<br /><br /></td></tr>';

        foreach ($grades as $grade){
            $return .= '<tr><td>'.$grade['grade'].' - '.$grade['symptoms'].'<br /><br /></td></tr>';
        }

        $return .= '</table>';*/

        $sql = 'select mon.order_number
                from machine_order_number mon
                left join product_model pm on pm.order_number_id = mon.order_number_id
                where pm.configCode = "'.$configCode.'" and mon.order_number <> "" and mon.enabled is not null';

        $machineInfo = $this->db_query($sql, 'select-single');

        if (!$machineInfo['order_number']){

            /*$everymac = $this->tx_rx_curl('https://everymac.com/ultimate-mac-lookup/?search_keywords='.$configCode,'','',false,true);

            $doc = new DOMDocument();
            $doc->loadHTML($everymac);
            $doc->preserveWhiteSpace = false;
            $tables = $doc->getElementsByTagName('table');
            $rows = $tables->item(0)->getElementsByTagName('tr');

            $i = 0;
            foreach ($rows as $row){
                $cols = $row->getElementsByTagName('td');
                if ($i == 3){
                    $order_number = $cols->item(1)->nodeValue;
                }

                $i++;

            }
            $scraped = true;*/
            $order_number = '';
            $data['order_number_exists'] = false;
        }else{
            $order_number = $machineInfo['order_number'];
            $data['order_number_exists'] = true;
        }

        $serialCheck = $this->db_select_single('ds_orders', 'serialNumber', array('serialNumber' => $locSerialNumber));

        $data['grades'] = $return;
        $data['model_number'] = $model_number;
        $data['is_ipad'] = $is_ipad;
        $data['is_imac'] = $is_imac;
        $data['oss'] = $oss;
        $data['order_number'] = $order_number;
        if ($serialNumber == ''){
            $data['oNum'] = '';
        }
        if ($data['hdnSerialNumber'] == '' && strlen($serialNumber) > 8){
            $data['hdnSerialNumber'] = $serialNumber;
        }

        if ($serialCheck['serialNumber'] && !$data['oNum']){
            $data['serial_exists'] = true;
            $data['hdnSerialNumber'] = $serialNumber;
        }

        $audit_data = array(
            'aID'           =>  $_SESSION['aID']
            ,'start_time'   => $this->format_date('db_full')

        );

        $audit_log_id = $this->db_insert('audit_log', $audit_data);

        $data['audit_log_id'] = $audit_log_id;

        $system_profiler = $this->db_select_single('system_profiler', '*', array('serial_number' => $data['hdnSerialNumber']));

        $system_txt = "";

        if ($system_profiler){

            $system_txt .= "System Profiler:<br />";
            $system_txt .= "Model Name: ".$system_profiler['model_name']."<br />";
            $system_txt .= "Model Identifier: ".$system_profiler['model_identifier']."<br />";
            $system_txt .= "Processor: ".$system_profiler['processor_name']."<br />";
            $system_txt .= "Speed: ".$system_profiler['processor_speed']."<br />";
            $system_txt .= "Last POST Time: ".$system_profiler['last_post']."<br />";
            $system_txt .= "Last POST Result: ".$system_profiler['post_result']."<br />";
            $system_txt .= "<br />";
            $system_txt .= "Hard Drive Serial: ".$system_profiler['hard_drive_serial']."<br />";
            $system_txt .= "Hard Drive Medium: ".$system_profiler['hard_drive_medium']."<br />";
            $system_txt .= "Hard Drive Model: ".$system_profiler['hard_drive_model']."<br />";
            $system_txt .= "SMART Status: ".$system_profiler['hard_drive_smart']."<br />";
            $system_txt .= "This hard drive ".$system_profiler['verify_volume'];

            $data['ram_1'] = $system_profiler['memory_bank_1'];
            $data['ram_2'] = $system_profiler['memory_bank_2'];
            $data['ram_3'] = $system_profiler['memory_bank_3'];
            $data['ram_4'] = $system_profiler['memory_bank_4'];

            $ram = intval($system_profiler['memory_bank_1']) + intval($system_profiler['memory_bank_2']) + intval($system_profiler['memory_bank_3']) + intval($system_profiler['memory_bank_4']);

            $data['ram'] = (string)$ram.'GB';
            $data['hd'] = $system_profiler['hard_drive_size'];
            $data['battery_mah'] = $system_profiler['battery_capacity'];
            $data['battery_cycles'] = $system_profiler['battery_cycle'];

            $osarray = explode('.', $system_profiler['os_version']);
			$data['os_version'] = $osarray[0].'.'.$osarray[1];
			if ($system_profiler['poNumber'] && !$data['poNumber']) {
				$data['poNumber'] = $system_profiler['poNumber'];
			}

            $data['system_txt'] = $system_txt;

            if (!strpos($system_profiler['hard_drive_size'],'TB')){
                $hdsize = floatval($system_profiler['hard_drive_size']);
            }else{
                $hdsize = floatval($system_profiler['hard_drive_size'])*1024;
            }

            $hdreverse = array_reverse($hdvolumes);

            foreach ($hdreverse as $k => $v){

                if ($v <= $hdsize){
                    $data['hd_1'] = $k;
                    break;
                }
            }

		}

        $return_json = json_encode($data);

        echo $return_json;

        //}


    }

    function get_order_number($serialNumber,$target){

        //get configCode (last3 of 11 digit or 4 of 12 or 13 digit serial #)
        if (strlen($serialNumber) < 13){
            $configCode = substr($serialNumber,8);
        }else{
            $configCode = substr($serialNumber,9);
        }

        $sql = 'select mon.order_number
                from machine_order_number mon
                left join product_model pm on pm.order_number_id = mon.order_number_id
                where pm.configCode = "'.$configCode.'"';

        $machineInfo = $this->db_query($sql, 'select-single');

        if (!$machineInfo['order_number']){

            $everymac = $this->tx_rx_curl('https://everymac.com/ultimate-mac-lookup/?search_keywords='.$configCode,'','',false,true);

            $doc = new DOMDocument();
            $doc->loadHTML($everymac);
            $doc->preserveWhiteSpace = false;
            $tables = $doc->getElementsByTagName('table');
            $rows = $tables->item(0)->getElementsByTagName('tr');

            $i = 0;
            foreach ($rows as $row){
                /*** get each column by tag name ***/
                $cols = $row->getElementsByTagName('td');
                /*** echo the values ***/
                if ($i == 3){
                    $order_number = $cols->item(1)->nodeValue;
                }

                $i++;

            }
            $scraped = true;
        }else{
            $order_number = $machineInfo['order_number'];
            $scraped = false;
        }

        $data['order_number'] = $order_number;
        $data['target'] = $target;
        $data['config_code'] = $configCode;
        $data['scraped'] = $scraped;

        echo json_encode($data);

    }

    function get_payflow_totals(){

        global $payflow_viewers;

        if ($_SESSION['aPayflow'] == 'Y'){
            $data = $this->db_select_single('payflow_daily_activity', 'round(sum(amount),2)', array('r_type' => 'Sale','response_msg' => 'Approved'),'and r_time like '.'"'.$this->format_date('db_date').'%"');
            if ($data[0]){
                return '$'.$data[0];
            }else{
                return '$0.00';
            }
        }else{
            return '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
        }
    }

    function worldship(){

        global $ups_ship_from, $executiveObj;

        $ups_service = $this->db_select_multiple('ups_service', 'ups_service_code,internal_description',array(),'order by ups_service_code');

		$sql = "SELECT * FROM ups_service_types WHERE `description` = '{$_GET['shipper']}';";
		// echo $sql;
		$serviceCodeData = $this->db_query($sql, 'select-single', true);
		// echo print_r($serviceCode);
		// echo print_r($ups_service);
		$serviceCode = $serviceCodeData['service_code'] ? $serviceCodeData['service_code'] : '03';
        $service = $this->arrayToHtmlSelectOptions($ups_service, false, $serviceCode);

        $ups_package_type =  $this->db_select_multiple('ups_package_type', 'ups_package_type_id,ups_packaging_type_code,internal_description,length,width,height',array(),'order by sequence');

		$boxId = 0;
		if ($_GET['listing_id'] && $_GET['channel']) {
			$boxId = $this->getSelectedBoxId($_GET['listing_id'], $_GET['channel']);
			$deviceWeight = $this->getSelectedDeviceWeight($_GET['listing_id'], $_GET['channel']);
		}

        $package = '';

		$shipping_boxes = $executiveObj->getShippingBoxes();

        $dimensions['length'] = $shipping_boxes[0]['length'];
        $dimensions['width'] = $shipping_boxes[0]['width'];
        $dimensions['height'] = $shipping_boxes[0]['height'];

		$weight = '';
		foreach ($shipping_boxes as $shipping_box){
			if ($shipping_box['id'] == $boxId) {
				$dimensions['length'] = $shipping_box['length'];
				$dimensions['width'] = $shipping_box['width'];
				$dimensions['height'] = $shipping_box['height'];
				if ($shipping_box['weight'] && $deviceWeight) {
					$weight = strval(round((float)$shipping_boxes[$boxId]['weight'] + (float)$deviceWeight));
				}
				$package .= '<option selected value="new_'.$shipping_box['id'].'" ups_packaging_type_code="'.$shipping_box['type_code'].'" length="'.$shipping_box['length'].'" width="'.$shipping_box['width'].'" height="'.$shipping_box['height'].'">'.$shipping_box['name'].'</option>';
			} else {
				$package .= '<option value="new_'.$shipping_box['id'].'" ups_packaging_type_code="'.$shipping_box['type_code'].'" length="'.$shipping_box['length'].'" width="'.$shipping_box['width'].'" height="'.$shipping_box['height'].'">'.$shipping_box['name'].'</option>';
			}
		}
		$package .= '<option disabled>=====Old Box Types=====</option>';
        foreach ($ups_package_type as $package_type){
            $package .= '<option value="old_'.$package_type['ups_package_type_id'].'" ups_packaging_type_code="'.$package_type['ups_packaging_type_code'].'" length="'.$package_type['length'].'" width="'.$package_type['width'].'" height="'.$package_type['height'].'">'.$package_type['internal_description'].'</option>';
        }
		if ($_GET['echoweight'] == 'yes') {
			echo "<p>$deviceWeight</p>";
			echo "<p>{$shipping_boxes[$boxId]['weight']}</p>";
			echo "<p></p>";
			echo print_r($shipping_boxes[$boxId]);
			echo "<p></p>";
			echo "<p>$weight</p>";
		}
        //$package = $this->arrayToHtmlSelectOptions($ups_package_type,false);

        $ups_return_service = $this->db_select_multiple('ups_return_service', 'ups_return_service_code,internal_description',array(),'order by ups_return_service_code');

        $return_service = $this->arrayToHtmlSelectOptions($ups_return_service,true,false,array(),'None');

        $ups_shipments = $this->db_select_multiple('ups_shipments', 'distinct ship_to, attention, address1, address2, address3, city, state, zip, phone, email', '', 'order by ship_to');

        $i = 0;
        foreach ($ups_shipments as $row){

            $ups_ship_to[] = array($i,$row['ship_to']);
            $ups_shipments[$i]['ship_id'] = $i;

            $i++;
        }
        $ship_to_json = json_encode($ups_shipments);

        $var_json = 'var shiptoJSONObj = {"shipaddresses":'.$ship_to_json.'};';

        $ship_from = $this->arrayToHtmlSelectOptions(array_keys($ups_ship_from));

		$ship_to = $this->arrayToHtmlSelectOptions($ups_ship_to,true);


        if ($_GET['oNum']){
            $ds_orders = $this->db_select_single('ds_orders', '*', array('oNum' => $_GET['oNum']));

            if ($ds_orders['cShipCompany'] == ''){

                $company = $ds_orders['cShipFname'].' '.$ds_orders['cShipLname'];
                $name = '';

            }else{

                $company = $ds_orders['cShipCompany'];
                $name = $ds_orders['cShipFname'].' '.$ds_orders['cShipLname'];

            }

            $address1 = $ds_orders['cShipAddress1'];
            $address2 = $ds_orders['cShipAddress2'];
            $city = $ds_orders['cShipCity'];
            $state = $ds_orders['cShipState'];
            $zip = $ds_orders['cShipZip'];
            $phone = $ds_orders['cPhone'];
            $email = $ds_orders['cShipEmail'];
            $ref1 = $ds_orders['oNum'];

        }else{

            $company = $_GET['company'] ? $this->decodeSanitizedString($_GET['company']) : '';
            $name = $_GET['name'] ? $this->decodeSanitizedString($_GET['name']) : '';
            $address1 = $_GET['address1'] ? $this->decodeSanitizedString($_GET['address1']) : '';
            $address2 = $_GET['address2'] ? $this->decodeSanitizedString($_GET['address2']) : '';
            $city = $_GET['city'] ? $this->decodeSanitizedString($_GET['city']) : '';
            $state = $_GET['state'] ? $this->decodeSanitizedString($_GET['state']) : '';
            $zip = $_GET['zip'] ? $this->decodeSanitizedString($_GET['zip']) : '';
            $phone = $_GET['phone'] ? $this->decodeSanitizedString($_GET['phone']) : '';
            $email = $_GET['email'] ? $this->decodeSanitizedString($_GET['email']) : '';
            $ref1 = $_GET['ref1'] ? $this->decodeSanitizedString($_GET['ref1']) : '';
			$ref2 = $_GET['ref2'] ? $this->decodeSanitizedString($_GET['ref2']) : '';
			$saleChannel = $_GET['channel'] ? $this->decodeSanitizedString($_GET['channel']) : '';

        }

        $large_printers = $this->db_select_multiple('large_printers', 'large_printer_id, large_printer_name',array(),'order by large_printer_name');
		$dd_large_printers = '';
		foreach ($large_printers as $large_printer){
			if ($_GET['origin'] == 'open_orders' && $large_printer['large_printer_id'] == '12') {
				$dd_large_printers .= '<option selected value="'.$large_printer['large_printer_id'].'">'.$large_printer['large_printer_name'].'</option>';
			}
			else {
				$dd_large_printers .= '<option value="'.$large_printer['large_printer_id'].'">'.$large_printer['large_printer_name'].'</option>';
			}
		}

        $parse = array(
            'SERVICE'   => $service,
            'PACKAGE'   => $package,
            'RETURN_SERVICE'    =>  $return_service,
            'SHIP_FROM' => $ship_from,
            'SHIP_TO'   => $ship_to,
            'COMPANY'   => $company,
            'NAME'      => $name,
            'ADDRESS1'  => $address1,
            'ADDRESS2'  => $address2,
            'CITY'      => $city,
            'STATE'     => $state,
            'ZIP'       => $zip,
            'PHONE'     => $phone,
            'EMAIL'     => $email,
            'REF1'      => $ref1,
            'REF2'      => $ref2,
            'VAR_JSON'  => $var_json,
            'LENGTH'    => $dimensions['length'],
            'WIDTH'    => $dimensions['width'],
            'HEIGHT'    => $dimensions['height'],
			'LARGE_PRINTERS'    => $dd_large_printers,
			'WEIGHT' => $weight,
			'SALE_CHANNEL' => $saleChannel
        );

        echo $this->parse(TEMPLATE,  array('BODY' => $this->parse(WORLDSHIP,$parse)));
	}

	private function getSelectedBoxId($listingId, $channel) {
		if ($channel == "back_market") {
			$channel = "backmarket";
		}
		elseif (substr($channel, 0, 4) === 'ebay') {
			$channel = "ebay";
		}
		$sql = "SELECT sb.id FROM machine_order_number AS mon LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id LEFT JOIN machine_order_shipping_boxes AS mosb ON mon.order_number_id = mosb.machine_order_id LEFT JOIN shipping_boxes AS sb ON sb.id = mosb.shipping_box_id WHERE mei.listing_id = '$listingId' AND mei.channel_identifier = '$channel';";
		// echo "<p>$sql</p>";
		$data = $this->db_query($sql, 'select-single');
		return $data['id'];
	}

	public function getSelectedDeviceWeight($listingId, $channel) {
		if ($channel == "back_market") {
			$channel = "backmarket";
		}
		elseif (substr($channel, 0, 4) === "ebay") {
			$channel = "ebay";
		}
		$sql = "SELECT mon.device_weight FROM machine_order_number AS mon LEFT JOIN machine_ecomm_ids AS mei ON mon.order_number_id = mei.order_number_id WHERE mei.listing_id = '$listingId' AND mei.channel_identifier = '$channel';";
		// echo "<p>$sql</p>";
		$data = $this->db_query($sql, 'select-single');
		return $data['device_weight'];
	}

	function worldship_new() {
		global $worldshipObj;
		return $worldshipObj->worldshipNew();
	}

    function ups_get_quote($data){

        global $upsObj, $ups_ship_from, $executiveObj;

        $ups_weight_div = 139;

        $calc_weight = ($data['length']*$data['width']*$data['height'])/$ups_weight_div;

        if (round($calc_weight) > $data['weight']){
            $data['weight'] = round($calc_weight);
        }

		$from = $ups_ship_from[$data['ship_from']];
		$ups_package_type = '';
		if (strpos($data['package'], 'new') === false) {
			$data['package'] = substr($data['package'], strrpos($data['package'], '_') + 1);
			$ups_package_type = $this->db_select_single('ups_package_type', 'ups_packaging_type_code,ups_description', array('ups_package_type_id' => $data['package']));
		}
		else {
			$data['package'] = substr($data['package'], strrpos($data['package'], '_') + 1);
			$sql = "SELECT uptc.type_code AS ups_packaging_type_code, uptc.`description` AS ups_description FROM shipping_boxes AS sb LEFT JOIN ups_package_type_codes AS uptc ON sb.ups_type_code_id = uptc.`id` WHERE sb.id = {$data['package']};";
			$ups_package_type = $this->db_query($sql, 'select-single', true);
		}


        $package_type = $ups_package_type['ups_packaging_type_code'];
        $package_description = $ups_package_type['ups_description'];

        $data['country'] = 'US';

		($data['saturday_delivery'] == 'true' ? $saturday = true : $saturday = false);

        if ($data['return_service'] == '99'){

            //flip from and to addresses
            $from['company'] = $data['company'];
            $from['phone'] = $data['phone'];
            $from['address1'] = $data['address1'];
            $from['city'] = $data['city'];
            $from['state'] = $data['state'];
            $from['zip'] = $data['zip'];

            $data['company'] = $ups_ship_from[$data['ship_from']]['company'];
            $data['phone'] = $ups_ship_from[$data['ship_from']]['phone'];
            $data['address1'] = $ups_ship_from[$data['ship_from']]['address1'];
            $data['city'] = $ups_ship_from[$data['ship_from']]['city'];
            $data['state'] = $ups_ship_from[$data['ship_from']]['state'];
            $data['zip'] = $ups_ship_from[$data['ship_from']]['zip'];
            $data['address2'] = '';
            $data['address3'] = '';
            $data['name'] = '';

            //get quote for return shipment
            $xml = $upsObj->get_ship_confirm_xml('GetQuote',$from,$data,$data['service'],$data['weight'],9,$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$package_type,$package_description);

            $response = $upsObj->communicate($xml, 'ShipConfirm');

            //if error display error message
            if (isset($response->Response->Error)){
                $this->db_insert('ups_errors', array('request_data' => $xml,'error_text' => $response->Response->Error->ErrorDescription));
                echo '<strong><font color="red">'.$response->Response->Error->ErrorDescription.'</font></strong>';
                exit;
            }

            //return return quote
            if( isset($response->NegotiatedRateCharges) && isset($response->NegotiatedRateCharges->TotalCharge) ){
                $quote = $response->NegotiatedRateCharges->TotalCharges;
            }
            else{
                $quote = $response->ShipmentCharges->TotalCharges;
            }

            $return .= '<br /><strong>Total Charges: $'.$quote->MonetaryValue.'</strong>';



        //if no return service single shipment
        } elseif ($data['return_service'] == ''){

            //get quote
            $xml = $upsObj->get_ship_confirm_xml('GetQuote',$from,$data,$data['service'],$data['weight'],$data['return_service'],$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$package_type,$package_description);

            $response = $upsObj->communicate($xml, 'ShipConfirm');

            //if error, display error message
            if (isset($response->Response->Error)){
                $this->db_insert('ups_errors', array('request_data' => $xml,'error_text' => $response->Response->Error->ErrorDescription));
                echo '<strong><font color="red">'.$response->Response->Error->ErrorDescription.'</font></strong>';
                exit;
            }

            //return quote
            if( isset($response->NegotiatedRateCharges) && isset($response->NegotiatedRateCharges->TotalCharge) ){
                $quote = $response->NegotiatedRateCharges->TotalCharges;
            }
            else{
                $quote = $response->ShipmentCharges->TotalCharges;
            }

            $return = '<strong>Total Charges Out: $'.$quote->MonetaryValue.'</strong>';

        }else{

            //get quote for out shipment
            $xml = $upsObj->get_ship_confirm_xml('GetQuote',$from,$data,$data['service'],$data['weight'],'',$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$package_type,$package_description);

            $response = $upsObj->communicate($xml, 'ShipConfirm');

            //if error return
            if (isset($response->Response->Error)){
                $this->db_insert('ups_errors', array('request_data' => $xml,'error_text' => $response->Response->Error->ErrorDescription));
                echo '<strong><font color="red">'.$response->Response->Error->ErrorDescription.'</font></strong>';
                exit;
            }

            //return out quote
            if( isset($response->NegotiatedRateCharges) && isset($response->NegotiatedRateCharges->TotalCharge) ){
                $quote = $response->NegotiatedRateCharges->TotalCharges;
            }
            else{
                $quote = $response->ShipmentCharges->TotalCharges;
            }

            $return = '<strong>Total Charges Out: $'.$quote->MonetaryValue.'</strong>';

            //flip from and to addresses
            $from['company'] = $data['company'];
            $from['phone'] = $data['phone'];
            $from['address1'] = $data['address1'];
            $from['city'] = $data['city'];
            $from['state'] = $data['state'];
            $from['zip'] = $data['zip'];

            $data['company'] = $ups_ship_from[$data['ship_from']]['company'];
            $data['phone'] = $ups_ship_from[$data['ship_from']]['phone'];
            $data['address1'] = $ups_ship_from[$data['ship_from']]['address1'];
            $data['city'] = $ups_ship_from[$data['ship_from']]['city'];
            $data['state'] = $ups_ship_from[$data['ship_from']]['state'];
            $data['zip'] = $ups_ship_from[$data['ship_from']]['zip'];
            $data['address2'] = '';
            $data['address3'] = '';
            $data['name'] = '';

            //get quote for return shipment
            $xml = $upsObj->get_ship_confirm_xml('GetQuote',$from,$data,$data['service'],$data['weight'],$data['return_service'],$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$package_type,$package_description);

            $response = $upsObj->communicate($xml, 'ShipConfirm');

            //if error display error message
            if (isset($response->Response->Error)){
                echo '<strong><font color="red">'.$response->Response->Error->ErrorDescription.'</font></strong>';
                exit;
            }

            //return return quote
            if( isset($response->NegotiatedRateCharges) && isset($response->NegotiatedRateCharges->TotalCharge) ){
                $quote = $response->NegotiatedRateCharges->TotalCharges;
            }
            else{
                $quote = $response->ShipmentCharges->TotalCharges;
            }

            $return .= '<br /><strong>Total Charges Return: $'.$quote->MonetaryValue.'</strong>';


        }

        echo $return;

    }

    function ups_worldship($data){

        global $upsObj, $ups_ship_from;

        $ups_weight_div = 139;

        $calc_weight = ($data['length']*$data['width']*$data['height'])/$ups_weight_div;

        $scale_weight = $data['weight'];

        if (round($calc_weight) > $data['weight']){
            $data['weight'] = round($calc_weight);
		}

		$print = $data['request_type'] == 'ship_print' ? true : false;

		$printEcomm = $data['request_type'] == 'ship_ecomm' ? true : false;

		$newBox = false;

		$from = $ups_ship_from[$data['ship_from']];
		$ups_package_type = '';
		if (strpos($data['package'], 'new') === false) {
			$data['package'] = substr($data['package'], strrpos($data['package'], '_') + 1);
			$ups_package_type = $this->db_select_single('ups_package_type', 'ups_packaging_type_code,ups_description', array('ups_package_type_id' => $data['package']));
		}
		else {
			$newBox = true;
			$data['package'] = substr($data['package'], strrpos($data['package'], '_') + 1);
			$sql = "SELECT uptc.type_code AS ups_packaging_type_code, uptc.`description` AS ups_description FROM shipping_boxes AS sb LEFT JOIN ups_package_type_codes AS uptc ON sb.ups_type_code_id = uptc.`id` WHERE sb.id = {$data['package']};";
			$ups_package_type = $this->db_query($sql, 'select-single', true);
		}

        $package_type = $ups_package_type['ups_packaging_type_code'];
		$package_description = $ups_package_type['ups_description'];

        $data['country'] = 'US';

        ($data['saturday_delivery'] == 'true' ? $saturday = true : $saturday = false);

        $temp_large_printer = $_SESSION['large_printer_id'];

		$_SESSION['large_printer_id'] = $data['printer'];

		$addrStr = "<p style='margin:0;'>To: {$data['company']}</p>";
		$addrStr .= "<p style='margin:0;'>Address: {$data['address1']} {$data['address2']} {$data['address3']}</p>";
		$addrStr .= "<p style='margin:0;'>City: {$data['city']}</p>";
		$addrStr .= "<p style='margin:0;'>State: {$data['state']}</p>";
		$addrStr .= "<p style='margin:0;'>Zip: {$data['zip']}</p>";

		// echo $addrStr;
		// exit;
		$trackingNumbers = array();

        if ($data['return_service'] == '99'){

            //flip from and to addresses
            $from['company'] = $data['company'];
            $from['phone'] = $data['phone'];
            $from['address1'] = $data['address1'];
            $from['city'] = $data['city'];
            $from['state'] = $data['state'];
            $from['zip'] = $data['zip'];

            $data['company'] = $ups_ship_from[$data['ship_from']]['company'];
            $data['phone'] = $ups_ship_from[$data['ship_from']]['phone'];
            $data['address1'] = $ups_ship_from[$data['ship_from']]['address1'];
            $data['city'] = $ups_ship_from[$data['ship_from']]['city'];
            $data['state'] = $ups_ship_from[$data['ship_from']]['state'];
            $data['zip'] = $ups_ship_from[$data['ship_from']]['zip'];
            $data['address2'] = '';
            $data['address3'] = '';
            $data['name'] = '';

            //create return shipment
            $response = $upsObj->ship_worldship('Worldship',$from,$data,$data['service'],$data['weight'],9,$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],false,0,$package_type,$package_description);

			$i = 1;

            foreach($response as $row){

                //write record to ship log
                if ($row['status'] == 'Success'){
					array_push($trackingNumbers, $row['tracking']);

                    $ship_data = array(
                        'tracking_no'               =>  $row['tracking']
                        ,'ship_from'                =>  $from['company']
                        ,'ship_to'                  =>  $data['company']
                        ,'attention'                =>  $data['name']
                        ,'address1'                 =>  $data['address1']
                        ,'address2'                 =>  $data['address2']
                        ,'address3'                 =>  $data['address3']
                        ,'city'                     =>  $data['city']
                        ,'state'                    =>  $data['state']
                        ,'zip'                      =>  $data['zip']
                        ,'phone'                    =>  $data['phone']
                        ,'email'                    =>  $data['email']
                        ,'service'                  =>  $data['service']
                        ,'bill_to'                  =>  $data['bill_to']
                        // ,'packagetype'              =>  $data['package']
                        ,'weight'                   =>  $scale_weight
                        ,'ref1'                     =>  $data['ref1']
                        ,'ref2'                     =>  $data['ref2']
                        ,'delivery_confirmation'    =>  $data['delivery_confirmation']
                        ,'return_service'           =>  $data['return_service']
                        ,'declared_value'           =>  $data['declared_value']
                        ,'saturday_delivery'        =>  $saturday
                        ,'number_boxes'             =>  $i.' of '.$boxes
                        ,'total_charge'             =>  (float)$row['total_charge']/$boxes
                        ,'length'                   => $data['length']
                        ,'width'                    => $data['width']
                        ,'height'                   => $data['height']
                        ,'dimensional_weight'       => round($calc_weight)
						,'service_type_id'			=> "(SELECT id FROM ups_service_types WHERE service_code = '{$data['service']}' LIMIT 1)"
                    );

					if ($newBox) {
						$ship_data['package_type_id'] = $data['package'];
					}
					else {
						$ship_data['packagetype'] = $data['package'];
					}

                    $this->db_insert('ups_shipments', $ship_data);

                    //return tracking #
                    $json = array('address' => $addrStr, 'shipping_label' => $row['tracking'].'.pdf','label_path' => UPS_LABEL_PATH, 'html' => '<strong>Tracking # '.$i.': <a href="'.CONTROLLER.'?m=worldship_detail&tracking_no='.$row['tracking'].'" target="_blank">'.$row['tracking'].'</a></strong> | <a href="'.CONTROLLER.'?m=view_shipping_label&trackingNumber='.$row['tracking'].'" target="_blank">View Label</a><br />');

                    //$return .= '<strong>Tracking # '.$i.': <a href="'.CONTROLLER.'?m=worldship_detail&tracking_no='.$row['tracking'].'">'.$row['tracking'].'</a></strong><br />';

                    $return .= json_encode($json);

                }else{

                    //return error
                    $return .=  '<strong><font color="red">'.$row['error'].'</font></strong><br />';

                    $this->db_insert('ups_errors', array('request_data' => serialize($data), 'error_text' => serialize($row)), false);

                }

                $i++;

            }


        //if no returm service, single shipment
        } elseif ($data['return_service'] == ''){

            //create shipment
            $response = $upsObj->ship_worldship('Worldship',$from,$data,$data['service'],$data['weight'],$data['return_service'],$data['delivery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$print,0,$package_type,$package_description);

            $boxes = count($response);

			$i = 1;

			$channel = $data['channel'];
			$channel = str_replace('_', '', $channel);
			$orderNumber = $data['ref2'];

            foreach($response as $row){

                //write record to ship log
                if ($row['status'] == 'Success'){
					array_push($trackingNumbers, $row['tracking']);

                    $ship_data = array(
                        'tracking_no'               =>  $row['tracking']
                        ,'ship_from'                =>  $data['ship_from']
                        ,'ship_to'                  =>  $data['company']
                        ,'attention'                =>  $data['name']
                        ,'address1'                 =>  $data['address1']
                        ,'address2'                 =>  $data['address2']
                        ,'address3'                 =>  $data['address3']
                        ,'city'                     =>  $data['city']
                        ,'state'                    =>  $data['state']
                        ,'zip'                      =>  $data['zip']
                        ,'phone'                    =>  $data['phone']
                        ,'email'                    =>  $data['email']
						,'service'                  =>  $data['service']
                        ,'bill_to'                  =>  $data['bill_to']
                        // ,'packagetype'              =>  $data['package']
                        ,'weight'                   =>  $scale_weight
                        ,'ref1'                     =>  $data['ref1']
                        ,'ref2'                     =>  $data['ref2']
                        ,'delivery_confirmation'    =>  $data['delivery_confirmation']
                        ,'return_service'           =>  $data['return_service']
                        ,'declared_value'           =>  $data['declared_value']
                        ,'saturday_delivery'        =>  $saturday
                        ,'number_boxes'             =>  $i.' of '.$boxes
                        ,'total_charge'             =>  (float)$row['total_charge']/$boxes
                        ,'length'                   => $data['length']
                        ,'width'                    => $data['width']
                        ,'height'                   => $data['height']
						,'dimensional_weight'       => round($calc_weight)
						,'service_type_id'			=> "(SELECT id FROM ups_service_types WHERE service_code = '{$data['service']}' LIMIT 1)"
					);

					if ($newBox) {
						$ship_data['package_type_id'] = $data['package'];
					}
					else {
						$ship_data['packagetype'] = $data['package'];
					}

					$this->db_insert('ups_shipments', $ship_data);

					if ($data['ref2']) {
						$orderNumber = $data['ref2'];
						$trackingNumber = $row['tracking'];
						$sql = "INSERT IGNORE INTO `ecomm_open_order_tracking_numbers`(`open_order_id`, `tracking_number`) VALUES ((SELECT `id` FROM `ecomm_open_orders` WHERE `order_id`='$orderNumber'),'$trackingNumber');";
						$this->db_query($sql, 'insert');
					}

                    //return tracking #
                    $return .= '<strong>Tracking # '.$i.': <a href="'.CONTROLLER.'?m=worldship_detail&tracking_no='.$row['tracking'].'">'.$row['tracking'].'</a></strong> | <a href="'.CONTROLLER.'?m=view_shipping_label&trackingNumber='.$row['tracking'].'" target="_blank">View Label</a><br />';

                }else{

                    //return error
                    $return .= $addrStr.'<strong><font color="red">'.$row['error'].'</font></strong><br />';

                    $this->db_insert('ups_errors', array('request_data' => serialize($data), 'error_text' => serialize($row)), false);

                }

                $i++;

			}
			if ($channel && $orderNumber && count($trackingNumbers) > 0) {
				$this->insertPendingOrderData($channel, $orderNumber, $trackingNumbers);
				if ($printEcomm) {
					require_once(HTML_FOLDER . "classes/class_packingslips.php");
					$packingSlips = new PackingSlips;
					$packingSlips->printPackingSlips($orderNumber, $channel, false, false);
				}
			}


        }else{

            $returndata = $data;

            //flip from and to addresses
            $from['company'] = $returndata['company'];
            $from['phone'] = $returndata['phone'];
            $from['address1'] = $returndata['address1'];
            $from['city'] = $returndata['city'];
            $from['state'] = $returndata['state'];
            $from['zip'] = $returndata['zip'];

            $returndata['company'] = $ups_ship_from[$data['ship_from']]['company'];
            $returndata['phone'] = $ups_ship_from[$data['ship_from']]['phone'];
            $returndata['address1'] = $ups_ship_from[$data['ship_from']]['address1'];
            $returndata['city'] = $ups_ship_from[$data['ship_from']]['city'];
            $returndata['state'] = $ups_ship_from[$data['ship_from']]['state'];
            $returndata['zip'] = $ups_ship_from[$data['ship_from']]['zip'];
            $returndata['address2'] = '';
            $returndata['address3'] = '';
            $returndata['name'] = '';

            //create return shipment (we do this first because if it fails we don't want an out shipment).
            $response = $upsObj->ship_worldship('Worldship',$from,$returndata,$returndata['service'],$returndata['weight'],$returndata['return_service'],$returndata['delvery_confirmation'],false,$saturday,$returndata['declared_value'],$returndata['add_boxes'],$returndata['ref1'],$returndata['ref2'],$print,0,$package_type,$package_description);

            $boxes = count($response);

            $i = 1;

            foreach($response as $row){

                //write record to ship log
                if ($row['status'] == 'Success'){
					array_push($trackingNumbers, $row['tracking']);

                    $ship_data = array(
                        'tracking_no'               =>  $row['tracking']
                        ,'ship_from'                =>  $from['company']
                        ,'ship_to'                  =>  $returndata['company']
                        ,'attention'                =>  $returndata['name']
                        ,'address1'                 =>  $returndata['address1']
                        ,'address2'                 =>  $returndata['address2']
                        ,'address3'                 =>  $returndata['address3']
                        ,'city'                     =>  $returndata['city']
                        ,'state'                    =>  $returndata['state']
                        ,'zip'                      =>  $returndata['zip']
                        ,'phone'                    =>  $returndata['phone']
                        ,'email'                    =>  $returndata['email']
                        ,'service'                  =>  $returndata['service']
                        ,'bill_to'                  =>  $returndata['bill_to']
                        // ,'packagetype'              =>  $returndata['package']
                        ,'weight'                   =>  $scale_weight
                        ,'ref1'                     =>  $returndata['ref1']
                        ,'ref2'                     =>  $returndata['ref2']
                        ,'delivery_confirmation'    =>  $returndata['delivery_confirmation']
                        ,'return_service'           =>  $returndata['return_service']
                        ,'declared_value'           =>  $returndata['declared_value']
                        ,'saturday_delivery'        =>  $saturday
                        ,'number_boxes'             =>  $i.' of '.$boxes
                        ,'total_charge'             =>  (float)$row['total_charge']/$boxes
                        ,'length'                   => $data['length']
                        ,'width'                    => $data['width']
                        ,'height'                   => $data['height']
                        ,'dimensional_weight'       => round($calc_weight)
						,'service_type_id'			=> "(SELECT id FROM ups_service_types WHERE service_code = '{$data['service']}' LIMIT 1)"
                    );

					if ($newBox) {
						$ship_data['package_type_id'] = $data['package'];
					}
					else {
						$ship_data['packagetype'] = $data['package'];
					}

                    $this->db_insert('ups_shipments', $ship_data);

                    //return tracking #
                    $in .= '<strong>Return Tracking # '.$i.': <a href="'.CONTROLLER.'?m=worldship_detail&tracking_no='.$row['tracking'].'">'.$row['tracking'].'</a></strong> | <a href="'.CONTROLLER.'?m=view_shipping_label&trackingNumber='.$row['tracking'].'" target="_blank">View Label</a><br />';

                }else{

                    //return error
                    $in .=  '<strong><font color="red">'.$row.'</font></strong><br />';

                    echo $in;
                    exit;

                }

                $i++;

            }

            $from = $ups_ship_from[$data['ship_from']];

            //create out shipment
            $response = $upsObj->ship_worldship('Worldship',$from,$data,$data['service'],$data['weight'],'',$data['delvery_confirmation'],false,$saturday,$data['declared_value'],$data['add_boxes'],$data['ref1'],$data['ref2'],$print,0,$package_type,$package_description);

            $boxes = count($response);

            $i = 1;

            foreach($response as $row){

                //write record to ship log
                if ($row['status'] == 'Success'){
					array_push($trackingNumbers, $row['tracking']);

                    $ship_data = array(
                        'tracking_no'               =>  $row['tracking']
                        ,'ship_from'                =>  $data['ship_from']
                        ,'ship_to'                  =>  $data['company']
                        ,'attention'                =>  $data['name']
                        ,'address1'                 =>  $data['address1']
                        ,'address2'                 =>  $data['address2']
                        ,'address3'                 =>  $data['address3']
                        ,'city'                     =>  $data['city']
                        ,'state'                    =>  $data['state']
                        ,'zip'                      =>  $data['zip']
                        ,'phone'                    =>  $data['phone']
                        ,'email'                    =>  $data['email']
                        ,'service'                  =>  $data['service']
                        ,'bill_to'                  =>  $data['bill_to']
                        // ,'packagetype'              =>  $data['package']
                        ,'weight'                   =>  $scale_weight
                        ,'ref1'                     =>  $data['ref1']
                        ,'ref2'                     =>  $data['ref2']
                        ,'delivery_confirmation'    =>  $data['delivery_confirmation']
                        ,'return_service'           =>  $data['return_service']
                        ,'declared_value'           =>  $data['declared_value']
                        ,'saturday_delivery'        =>  $saturday
                        ,'number_boxes'             =>  $i.' of '.$boxes
                        ,'total_charge'             =>  (float)$row['total_charge']/$boxes
                        ,'length'                   => $data['length']
                        ,'width'                    => $data['width']
                        ,'height'                   => $data['height']
                        ,'dimensional_weight'       => round($calc_weight)
						,'service_type_id'			=> "(SELECT id FROM ups_service_types WHERE service_code = '{$data['service']}' LIMIT 1)"
                    );

					if ($newBox) {
						$ship_data['package_type_id'] = $data['package'];
					}
					else {
						$ship_data['packagetype'] = $data['package'];
					}

                    $this->db_insert('ups_shipments', $ship_data);

                    //return tracking #
                    $out .= '<strong>Out Tracking # '.$i.': <a href="'.CONTROLLER.'?m=worldship_detail&tracking_no='.$row['tracking'].'">'.$row['tracking'].'</a></strong> | <a href="'.CONTROLLER.'?m=view_shipping_label&trackingNumber='.$row['tracking'].'" target="_blank">View Label</a><br />';

                }else{

                    //return error
                    $out .=  '<strong><font color="red">'.$row['error'].'</font></strong><br />';

                    echo $out;
                    exit;

                }

                $i++;

            }

            $return = $out.$in;

        }

		$_SESSION['large_printer_id'] = $temp_large_printer;
		if ($data['return_service'] == '99') {
			echo $return;
		} else {
			echo $addrStr.$return;
			if (count($trackingNumbers) > 0) {
				$trackingNumberString = implode(' ', $trackingNumbers);
				echo "<input id='trackingList' hidden value='$trackingNumberString' />";
				echo "<button type='button' onclick='copyAllTrackingNumsToClipboard(this)'>Copy Tracking Numbers To Clipboard</button>";
			}
		}

	}

	function insertPendingOrderData($channel, $orderNumber, $trackingNumberArray) {
		$sql = "UPDATE `ecomm_open_orders` SET `shipping_label_generated`='1' WHERE `order_id`='$orderNumber';";
		$this->db_query($sql, 'update');
		$sql = "INSERT IGNORE INTO ups_pending_orders(order_number) VALUES ('$orderNumber');";
		$this->db_query($sql, 'insert', true);
		$this->insertPendingOrderTrackingNumbers($orderNumber, $trackingNumberArray);
		$this->insertPendingOrderExpectedItems($channel, $orderNumber);
	}

	private function insertPendingOrderTrackingNumbers($orderNumber, $trackingNumberArray) {
		$sql = "SELECT id FROM ecomm_open_orders WHERE order_id='$orderNumber';";
		$result = $this->db_query($sql, 'select-single');
		$openOrderId = $result['id'];
		$sql = "SELECT id FROM ups_pending_orders WHERE order_number = '$orderNumber';";
		$result = $this->db_query($sql, 'select-single', true);
		$pendingOrderId = $result['id'];
		$trackingNumberInsertValues = "";
		for ($i = 0; $i < count($trackingNumberArray); $i++) {
			if ($i) {
				$trackingNumberInsertValues .= ", ";
				$openOrderInsertValues .= ", ";
			}
			$num = $trackingNumberArray[$i];
			$trackingNumberInsertValues .= "($pendingOrderId, '$num')";
			$openOrderInsertValues .= "($openOrderId, '$num')";
		}
		$sql = "INSERT IGNORE INTO ecomm_open_order_tracking_numbers VALUES $openOrderInsertValues;";
		$this->db_query($sql, 'insert', true);
		$sql = "INSERT IGNORE INTO ups_pending_tracking_numbers VALUES $trackingNumberInsertValues;";
		$this->db_query($sql, 'insert', true);
	}

	private function insertPendingOrderExpectedItems($channel, $orderNumber) {
		global $backmarketObj, $ebayApiObj, $neweggApiObj;
		$sql = "SELECT id FROM ups_pending_orders WHERE order_number = '$orderNumber';";
		$result = $this->db_query($sql, 'select-single', true);
		$orderId = $result['id'];
		$isInternalSku = 0;

		if ($channel == 'backmarket') {
			$orderData = $backmarketObj->getOrder($orderNumber);
			if (!$orderData) {
				return false;
			}
			$decodedData = json_decode($orderData);
			foreach ($decodedData->orderlines as $orderline) {
				$listingId = $orderline->listing_id;
				$sku = $orderline->listing;
				$quantity = $orderline->quantity;
				$description = mb_convert_encoding($orderline->product, "ISO-8859-1");
				$sql = "SELECT mon.`order_number` FROM machine_order_number AS mon LEFT JOIN `machine_ecomm_ids` AS mei ON mon.`order_number_id` = mei.`order_number_id` WHERE mei.`listing_id` = '$listingId' AND mei.`channel_identifier` = 'backmarket';";
				$result = $this->db_query($sql, 'select-single', true);
				if ($result['order_number']) {
					$isInternalSku = 1;
					$sku = $result['order_number'];
				}
				$sql = "INSERT IGNORE INTO ups_pending_order_expected_items(order_number_id, sku, quantity, is_internal_sku, `description`) VALUES ($orderId, '$sku', $quantity, $isInternalSku, '$description');";
				$this->db_query($sql, 'insert', true);
			}
		}
		else if ($this->startsWith($channel, 'ebay')) {
			$order = json_decode($ebayApiObj->getOrder($orderId));
			if (!$order) {
				return false;
			}
			foreach ($order->lineItems as $lineItem) {
				$sku = $lineItem->sku;
				$legacyItemId = $lineItem->legacyItemId;
				$quantity = $lineItem->quantity;
				$description = mb_convert_encoding($lineItem->title, "ISO-8859-1");
				$sql = "SELECT mon.`order_number` FROM machine_order_number AS mon LEFT JOIN `machine_ecomm_ids` AS mei ON mon.`order_number_id` = mei.`order_number_id` WHERE mei.`listing_id` = '$listingId' AND mei.`channel_identifier` = 'ebay';";
				$result = $this->db_query($sql, 'select-single', true);
				if ($result['order_number']) {
					$isInternalSku = 1;
					$sku = $result['order_number'];
				}
				$sql = "INSERT IGNORE INTO ups_pending_order_expected_items(order_number_id, sku, quantity, is_internal_sku, `description`) VALUES ($orderId, '$sku', $quantity, $isInternalSku, '$description');";
				$this->db_query($sql, 'insert', true);
			}
		}
		else if ($channel == 'newegg') {

			$orderData = json_decode($neweggApiObj->getOrder($orderId));
			if (!$orderData) {
				return false;
			}
			$orderInfo = $orderData->ResponseBody->OrderInfoList[0];
			// Get items and perform insertions
			foreach ($orderInfo->ItemInfoList as $itemInfo) {
				$sku = $itemInfo->SellerPartNumber;
				$listingId = $itemInfo->NeweggItemNumber;
				$quantity = $itemInfo->OrderedQty;
				$description = mb_convert_encoding($itemInfo->Description, "ISO-8859-1");
				$sql = "SELECT mon.`order_number` FROM machine_order_number AS mon LEFT JOIN `machine_ecomm_ids` AS mei ON mon.`order_number_id` = mei.`order_number_id` WHERE mei.`listing_id` = '$listingId' AND mei.`channel_identifier` = 'ebay';";
				$result = $this->db_query($sql, 'select-single', true);
				if ($result['order_number']) {
					$isInternalSku = 1;
					$sku = $result['order_number'];
				}
				$sql = "INSERT IGNORE INTO ups_pending_order_expected_items(order_number_id, sku, quantity, is_internal_sku, `description`) VALUES ($orderId, '$sku', $quantity, $isInternalSku, '$description');";
				$this->db_query($sql, 'insert', true);
			}
		}
		return true;

	}

    function ups_reprint_label($tracking_no){

        $imageFileBase = UPS_LABEL_PATH . $tracking_no;

        $large_printer_id = $_SESSION['large_printer_id'];

        $large_printer = $this->db_select_single('large_printers', '*', array('large_printer_id' => $large_printer_id));

        $this->send_printer(constant($large_printer['large_printer_queue']), $imageFileBase . '.gif');

    }

    function mass_serial_lookup($data){

        global $gsxObj, $searchObj;

        if ($data['serialNumbers']){//get serial numbers and display

            $machineArray = explode("\n",$data['serialNumbers']);

            $mass_serial_lookup = $gsxObj->mass_serial_lookup($machineArray);

            echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_serial_lookup($mass_serial_lookup)));

        }elseif($data['serialNumber']){//sort by column

            //get column to sort on
            $sortArray = $data[$_GET['sort']];

            //sort column
            if ($_GET['order'] == 'desc'){
                arsort($sortArray);
                $order = 'asc';
            }else{
                asort($sortArray);
                $order = 'desc';
            }

            //build array based on sort column
            foreach (array_keys($sortArray) as $k){
                $mass_serial_lookup[] = array(
                    'serialNumber' => $data['serialNumber'][$k]
                    ,'productDescription'   =>  $data['productDescription'][$k]
                    ,'configDescription'    =>  $data['configDescription'][$k]
                    ,'warrantyStatus'       =>  $data['warrantyStatus'][$k]
                    ,'coverageStartDate'    =>  $data['coverageStartDate'][$k]
                    ,'coverageEndDate'      =>  $data['coverageEndDate'][$k]
                    ,'daysRemaining'        =>  $data['daysRemaining'][$k]
                );
            }

            echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_serial_lookup($mass_serial_lookup,$_GET['sort'],$order)));

        }else{//display initial form
            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(MASS_SERIAL_LOOKUP,array())));
        }


    }

    function serial_lookup_export($data){

        $sortArray = $data['serialNumber'];

        //build array to write to csv
        foreach (array_keys($sortArray) as $k){
            $mass_serial_lookup[] = array(
                'serialNumber' => $data['serialNumber'][$k]
                ,'productDescription'   =>  $data['productDescription'][$k]
                ,'configDescription'    =>  $data['configDescription'][$k]
                ,'warrantyStatus'       =>  $data['warrantyStatus'][$k]
                ,'coverageStartDate'    =>  $data['coverageStartDate'][$k]
                ,'coverageEndDate'      =>  $data['coverageEndDate'][$k]
                ,'daysRemaining'        =>  $data['daysRemaining'][$k]
            );
        }

        //write headers
        $output = '"Serial Number","Machine Type","Config Description","Warranty Status","Coverage Start Date","Coverage End Date","Days Remaining"';

        //write rows
        foreach ($mass_serial_lookup as $row){
            $output .= "\n";
            $output .= '"'.$row['serialNumber'].'",';
            $output .= '"'.$row['productDescription'].'",';
            $output .= '"'.$row['configDescription'].'",';
            $output .= '"'.$row['warrantyStatus'].'",';
            $output .= '"'.$row['coverageStartDate'].'",';
            $output .= '"'.$row['coverageEndDate'].'",';
            $output .= '"'.$row['daysRemaining'].'",';
        }

        $this->send_file_to_browser($output, 'mass_serial_lookup.csv');
        exit;
    }

    function worldship_log(){

        global $searchObj;

        $filter = '';

        if ($_POST['searchtext']){
            $filter = $_POST['searchtext'];
        }elseif ($_GET['searchtext']){
            $filter = $_GET['searchtext'];
        }

        if ($_GET['sort']){
            $sort = $_GET['sort'];
        }else{
            $sort = 'ship_date';
        }

        if ($_GET['order']){
            $order = $_GET['order'];
        }else{
            $order = 'desc';
        }

        echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->worldship_log($filter,$sort,$order)));

    }

    function worldship_detail($tracking_no){

        global $upsObj;

        $error = '';

        if ($_POST['tracking_no']){


            $response = $upsObj->void_tracking('Worldship',$_POST['tracking_no']);

            if ($response === true){
                $this->db_update('ups_shipments', 'tracking_no', $_POST['tracking_no'], array('void' => '1'));
            }else{
                $error = '<script language="javascript">function displayMessage(){alert("'.$response.'");}</script>';

            }



        }

        $join = array(
            'ups_service on ups_service.ups_service_code = ups_shipments.service'
            ,'ups_package_type on ups_package_type.ups_package_type_id = ups_shipments.packagetype'
        );

        $data = $this->db_select_single(
            'ups_shipments'
            ,'ups_shipments.*, ups_service.internal_description service_desc, ups_package_type.internal_description package_type'
            ,array('tracking_no' => $tracking_no)
            ,''
            ,$join
		);

		$sql = "SELECT
				us.ups_shipment_id,
				us.tracking_no,
				us.ship_from,
				us.ship_to,
				us.attention,
				us.address1,
				us.address2,
				us.address3,
				us.city,
				us.state,
				us.zip,
				us.phone,
				us.email,
				us.service,
				us.ref1,
				us.ref2,
				us.bill_to,
				us.length,
				us.width,
				us.height,
				us.weight,
				us.dimensional_weight,
				us.delivery_confirmation,
				us.return_service,
				us.declared_value,
				us.saturday_delivery,
				us.number_boxes,
				us.total_charge,
				us.ship_date,
				us.void,
				us.packagetype,
				us.service,
				ust.service_code,
				ust.description AS service_description,
				sb.height AS box_height,
				sb.`length` AS box_length,
				sb.width AS box_width,
				uptc.type_code AS ups_package_type_code,
				uptc.description AS ups_package_description
			FROM ups_shipments AS us
			LEFT JOIN ups_service_types AS ust ON ust.id = us.service_type_id
			LEFT JOIN shipping_boxes AS sb ON sb.id = us.package_type_id
			LEFT JOIN ups_package_type_codes AS uptc ON sb.ups_type_code_id = uptc.id
			WHERE us.tracking_no='$tracking_no';";

		$data = $this->db_query($sql, 'select-single');

        switch ($data['delivery_confirmation']){
            case '0':$delivery_conf = 'None';
                break;
            case '1':$delivery_conf = 'No Signature Required';
                break;
            case '2':$delivery_conf = 'Signature Required';
                break;
            case '3':$delivery_conf = 'Adult Signature Required';
                break;
        };

        if ($data['return_service'] == 0){
            $return_service = 'None';
        }else{
            $return_data = $this->db_select_single('ups_return_service', 'internal_description', array('ups_return_service_code' => $data['return_service']));
            $return_service = $return_data['internal_description'];
        }

        if ($data['void'] != '1'){
            if (!$tracking = $upsObj->track($tracking_no)){
                $tracking = '<strong><font color="red">No tracking data currently available</font></strong>';
            }
        }else{
            $tracking = '<strong><font color="red">Shipment canceled</font></strong>';
        }

        $parse = array(
            'TRACKING_NO'    =>  $tracking_no
            ,'SHIP_DATE'            => $this->format_date('templ_full',strtotime($data['ship_date']))
            ,'SHIP_FROM' =>  $data['ship_from']
            ,'SHIP_TO'   =>  $data['ship_to']
            ,'ATTENTION'    =>  $data['attention']
            ,'ADDRESS1'     =>  $data['address1']
            ,'ADDRESS2'     =>  $data['address2']
            ,'ADDRESS3'     =>  $data['address3']
            ,'CITY'         =>  $data['city']
            ,'STATE'        =>  $data['state']
            ,'ZIP'          =>  $data['zip']
            ,'PHONE'        =>  $data['phone']
            ,'EMAIL'        =>  $data['email']
            ,'SERVICE'      =>  $data['service_desc']
            ,'BILL_TO'      =>  $data['bill_to']
            ,'PACKAGE_TYPE' =>  $data['package_type']
            ,'WEIGHT'       =>  $data['weight']
            ,'LENGTH'       =>  $data['length']
            ,'WIDTH'        =>  $data['width']
            ,'HEIGHT'       =>  $data['height']
            ,'DIMENSIONAL_WEIGHT'   =>  $data['dimensional_weight']
            ,'REF1'         =>  $data['ref1']
            ,'REF2'         =>  $data['ref2']
            ,'DELIVERY_CONF'    =>  $delivery_conf
            ,'RETURN_SERVICE'   =>  $return_service
            ,'DECLARED_VALUE'   =>  '$'.$data['declared_value']
            ,'SATURDAY_DELIVERY'    =>  ($data['saturday_delivery'] == 1 ? 'Yes' : 'No')
            ,'ADD_BOXES'            =>  $data['number_boxes']
            ,'TOTAL_CHARGE'         =>  '$'.$data['total_charge']
            ,'SEARCHTEXT'           =>  $_GET['searchtext']
            ,'TRACKING'             =>  $tracking
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(WORLDSHIP_DETAIL,$parse).$error));

    }

    function repair_lookup(){

        global $searchObj;

        if ($_GET['sort']){
            $sort = $_GET['sort'];
        }else{
            $sort = 'repairConfirmationNumber';
        }

        if ($_GET['order']){
            $order = $_GET['order'];
        }else{
            $order = 'asc';
        }

        echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_repair_lookup($sort,$order)));

    }

    function edit_users(){

        global $searchObj;

        //if not a super user redirect to own edit form
        if (!$this->is_super()){
            $this->goToURL(CONTROLLER.'?m=user_detail');
        }

        echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_users()));


    }

    function user_detail($aString=''){

        //check if super user
        if ($this->is_super()){
            if ($aString != ''){

                //get user record
                $data = $this->db_select_single('ds_admins', '*', array('aString' => $aString));

				$dd_printers .= $this->buildPrinterList($data['printer_id']);

                $large_printers = $this->db_select_multiple('large_printers', 'large_printer_id, large_printer_name',array(),'order by large_printer_name');

                foreach ($large_printers as $large_printer){
                    if ($large_printer['large_printer_id'] == $data['large_printer_id']){
                        $dd_large_printers .= '<option value="'.$large_printer['large_printer_id'].'" selected>'.$large_printer['large_printer_name'].'</option>';
                    }else{
                        $dd_large_printers .= '<option value="'.$large_printer['large_printer_id'].'">'.$large_printer['large_printer_name'].'</option>';
                    }
                }

                $modules = $this->db_select_multiple('module', '*',array(),'order by module_section_id, sequence');
                $ds_admin_modules = $this->db_select_multiple('ds_admin_modules', 'module_id',array('aID' => $data['aID']));

                foreach ($ds_admin_modules as $dam){
                    $mod_array[] = $dam['module_id'];
				}

				$query = "SELECT module_id, module_name
					FROM module
					ORDER BY module_name;";

				$dsAdminModules = $this->db_query($query, 'select-multiple', true);

				$defaultPages = '';
				foreach ($dsAdminModules as $module) {
					if ($module['module_id'] == $data['default_module_id']) {
						$defaultPages .= "<option selected value='{$module['module_id']}'>{$module['module_name']}</option>";
					} else {
						$defaultPages .= "<option value='{$module['module_id']}'>{$module['module_name']}</option>";
					}
				}

                foreach ($modules as $module){
                    $module_checks .= '<tr>';
                    $module_checks .= '<td>'.$module['module_name'].'</td>';
                    $module_checks .= '<td><input type="checkbox" name="module['.$module['module_id'].']" id="module['.$module['module_id'].']"';
                    if (in_array($module['module_id'],$mod_array)){
						$module_checks .= ' checked ';
                    }
                    $module_checks .= '></td>';
                    $module_checks .= '</tr>';
				}

				$sql = "SELECT `salesRegionPermissions` FROM `ds_admins` WHERE `aString`='$aString';";
				$result = $this->db_query($sql, 'select-single', true);
				$regionPermissions = explode(',', $result['salesRegionPermissions']);

				// $regions = array(
				// 	'West' => 'west',
				// 	'North' => 'north',
				// 	'South' => 'south'
				// );

				$regions = Region::getAllRegions(false, false);

				$salesMetricsRegionOptions .= "";
				foreach ($regions as $region) {
					$regionName = $region->getName();
					$regionIdentifier = $region->getIdentifier();
					$checked = '';
					if (in_array($regionIdentifier, $regionPermissions)) {
						$checked = 'checked';
					}
					$salesMetricsRegionOptions .= "<tr>";
					$salesMetricsRegionOptions .= "<td><label for='sales-region-permission-$regionIdentifier'>$regionName</td>";
					$salesMetricsRegionOptions .= "<td><input type='checkbox' $checked id='sales-region-permission-$regionIdentifier' name='$regionIdentifier-regionpermission' /></td>";
					$salesMetricsRegionOptions .= "</tr>";
				}

				$parse = array(
					'ASTRING'	=>	$data['aString']
					,'AUSER'	=>	$data['aUser']
					,'AFNAME'	=>	$data['aFname']
					,'ALNAME'	=>	$data['aLname']
					,'AEMAIL'	=>	$data['aEmail']
					,'SUPERUSER'	=>	($data['aPermType'] == 'S' ? 'checked' : '')
					,'PAYFLOW'	=>	($data['aReports'] == 'Y' ? 'checked' : '')
					,'TIMESHEET'	=>	($data['aTimesheet'] == 'Y' ? 'checked' : '')
					,'PAYROLL'	=>	($data['aPayroll'] == 'Y' ? 'checked' : '')
					,'AUDIT'	=>	($data['aAuditOnly'] == 'Y' ? 'checked' : '')
					,'PRINTERS'	=>	$dd_printers
					,'LARGE_PRINTERS'	=>	$dd_large_printers
					,'DEFAULT_PAGES'	=>	$defaultPages
					,'MODULES'	=>	$module_checks
					,'SALES_METRICS_REGIONS' => $salesMetricsRegionOptions
					,'DELETE'	=>	($data['aString'] == $_COOKIE['xdigiSHOPadmin'] ? 'style="display:none;"' : '')
				);

                echo $this->parse(TEMPLATE, array('BODY' => $this->parse(SUPER_EDIT_USER, $parse)));
            }
        }else{

            //if not super user get record of logged in user
            $data = $this->db_select_single('ds_admins', '*', array('aString' => $_COOKIE['xdigiSHOPadmin']));

			$dd_printers .= $this->buildPrinterList($data['printer_id']);


			$query = "SELECT dsam.module_id, mod.module_name
				FROM ds_admin_modules AS dsam
				LEFT JOIN `module` AS `mod` ON mod.module_id = dsam.module_id
				WHERE dsam.aID = {$data['aID']}
				ORDER BY module_name;";

			$dsAdminModules = $this->db_query($query, 'select-multiple', true);

			$defaultPages = '';

			foreach ($dsAdminModules as $module) {
				if ($module['module_id'] == $data['default_module_id']) {
					$defaultPages .= "<option selected value='{$module['module_id']}'>{$module['module_name']}</option>";
				} else {
					$defaultPages .= "<option value='{$module['module_id']}'>{$module['module_name']}</option>";
				}
			}

            $parse = array(
                'ASTRING'       =>  $data['aString']
                ,'AUSER'        =>  $data['aUser']
                ,'AFNAME'       =>  $data['aFname']
                ,'ALNAME'       =>  $data['aLname']
				,'AEMAIL'       =>  $data['aEmail']
				,'DEFAULT_PAGES'	=>	$defaultPages
                ,'PRINTERS'     =>  $dd_printers
            );

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(EDIT_USER, $parse)));

        }
    }

    function add_user($data,$error=''){

		$dd_printers .= $this->buildPrinterList();

        $modules = $this->db_select_multiple('module', '*',array(),'order by module_section_id, sequence');
        $ds_admin_modules = $this->db_select_multiple('ds_admin_modules', 'module_id',array('aID' => $data['aID']));

        foreach ($ds_admin_modules as $dam){
            $mod_array[] = $dam['module_id'];
        }

        foreach ($modules as $module){
            $module_checks .= '<tr>';
            $module_checks .= '<td>'.$module['module_name'].'</td>';
            $module_checks .= '<td><input type="checkbox" name="module['.$module['module_id'].']" id="module['.$module['module_id'].']"';
            if (in_array($module['module_id'],$mod_array)){
                $module_checks .= ' checked ';
            }
            $module_checks .= '></td>';
            $module_checks .= '</tr>';
        }

		// $regions = array(
		// 	'West' => 'west',
		// 	'North' => 'north',
		// 	'South' => 'south'
		// );
		$regions = Region::getAllRegions(false, false);
		$salesMetricsRegionOptions .= "";
		foreach ($regions as $region) {
			$regionName = $region->getName();
			$regionIdentifier = $region->getIdentifier();
			$salesMetricsRegionOptions .= "<tr>";
			$salesMetricsRegionOptions .= "<td><label for='sales-region-permission-$regionIdentifier'>$regionName</td>";
			$salesMetricsRegionOptions .= "<td><input type='checkbox' id='sales-region-permission-$regionIdentifier' name='$regionIdentifier-regionpermission' /></td>";
			$salesMetricsRegionOptions .= "</tr>";
		}

        //create add user form
        $parse = array(
            'AUSER'        =>  $data['aUser']
            ,'AFNAME'       =>  $data['aFname']
            ,'ALNAME'       =>  $data['aLname']
            ,'AEMAIL'       =>  $data['aEmail']
            ,'PASSWORD'     =>  $data['new_password']
            ,'CHECK_PASSWORD'   =>  $data['check_password']
            ,'SUPERUSER'    =>  ($data['aPermType'] == 'on' ? 'checked' : '')
            ,'PAYFLOW'      =>  ($data['aReports'] == 'on' ? 'checked' : '')
            ,'TIMESHEET'    =>  ($data['aTimesheet'] == 'Y' ? 'checked' : '')
            ,'PAYROLL'      =>  ($data['aPayroll'] == 'Y' ? 'checked' : '')
            ,'AUDIT'      =>  ($data['aAuditOnly'] == 'Y' ? 'checked' : '')
            ,'PRINTERS'     => $dd_printers
			,'SALES_METRICS_REGIONS' => $salesMetricsRegionOptions
            ,'MODULES'      =>  $module_checks
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(ADD_USER, $parse).$error));

    }

    function save_user($data){

		//check if saving user
		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		// exit;
        if ($data['save']){
			$regionPermissions = array();
			$regionPermissionsString = 'none';
			foreach ($_POST as $key => $value) {
				if (strpos($key, "-regionpermission") !== FALSE) {
					$regionIdentifier = substr($key, 0, strpos($key, "-regionpermission"));
					if ($value == "on") {
						array_push($regionPermissions, $regionIdentifier);
					}
				}
			}
			// if ($_POST['west'] && $_POST['west'] == 'on') {
			// 	array_push($regionPermissions, 'west');
			// }
			// if ($_POST['north'] && $_POST['north'] == 'on') {
			// 	array_push($regionPermissions, 'north');
			// }
			// if ($_POST['south'] && $_POST['south'] == 'on') {
			// 	array_push($regionPermissions, 'south');
			// }
			if (count($regionPermissions) > 0) {
				$regionPermissionsString = implode(',', $regionPermissions);
			}
			// print_r($_POST);
			// echo $regionPermissionsString;
			// exit;

            //existing user
            if ($data['aString']){

                if ($data['edit_own']){
                    $values = array(
                        'aEmail'        =>  $data['aEmail']
                        ,'aFname'       =>  $data['aFname']
                        ,'aLname'       =>  $data['aLname']
						,'printer_id'   =>  $data['printer']
						,'default_module_id'	=> $data['default_page']
                    );
                }else{
                    $values = array(
                        'aEmail'        =>  $data['aEmail']
                        ,'aFname'       =>  $data['aFname']
                        ,'aLname'       =>  $data['aLname']
                        ,'aPermType'    =>  ($data['super_user'] ? 'S' : '')
                        ,'aReports'     =>  ($data['payflow'] ? 'Y' : '')
                        ,'aTimesheet'   =>  ($data['timesheet'] ? 'Y' : '')
                        ,'aPayroll'     =>  ($data['payroll'] ? 'Y' : '')
                        ,'aAuditOnly'     =>  ($data['audit'] ? 'Y' : '')
                        ,'printer_id'   => $data['printer']
                        ,'large_printer_id'   => $data['large_printer']
						,'default_module_id'	=> $data['default_page']
						,'salesRegionPermissions' => $regionPermissionsString
                    );
                }

                $this->db_update('ds_admins', 'aString', $data['aString'], $values);

                //if password changed update
                if ($data['new_password'] != ''){
                    $this->db_query('update ds_admins set aPass = encode("'.$data['new_password'].'","'.PASS_SALT.'") where aString = "'.$data['aString'].'"','update');
                }

                if (!$data['edit_own']){

                    $ds_admin = $this->db_select_single('ds_admins', '*', array('aString' => $data['aString']));

                    $this->db_delete('ds_admin_modules', 'aID', $ds_admin['aID']);

                    foreach ($data['module'] as $k => $v){
                        $this->db_insert('ds_admin_modules', array('module_id' => $k,'aID' => $ds_admin['aID']));
                    }

                }

            }else{
                //check if username already exists
                if ($check = $this->db_select_single('ds_admins', 'aID', array('aUser' => $data['aUser']))){
                    $error = '<script language="javascript">function displayMessage(){alert("Username '.$data['aUser'].' already exists");}</script>';
                    $this->add_user($data,$error);
                    exit;
                }

                //create new user
                $aPermType = $data['super_user'] ? 'S' : '';
                $aReports = $data['payflow'] ? 'Y' : '';

                $sql = 'insert into ds_admins (aString, aEmail, aFname, aLname, aUser, aPass, aPermType, aOrders, aReports, printer_id, large_printer_id, salesRegionPermissions)
                    values(md5(concat("'.$data['aUser'].'",current_timestamp)),"'.$data['aEmail'].'","'.$data['aFname'].'","'.$data['aLname'].'","'.$data['aUser'].'",encode("'.$data['new_password'].'", "'.PASS_SALT.'"),"'.$aPermType.'","Y","'.$aReports.'","'.$data['printer'].'","'.$data['large_printer'].'", "'.$regionPermissionsString.'")';

                $this->db_query(
                        $sql,
                        'insert'
                    );

                $ds_admin = $this->db_select_single('ds_admins', '*', array('aUser' => $data['aUser']));

                foreach ($data['module'] as $k => $v){
                    $this->db_insert('ds_admin_modules', array('module_id' => $k,'aID' => $ds_admin['aID']));
                }
            }


        //delete user
        }elseif ($data['delete']) {

            $this->db_delete('ds_admins', 'aString', $data['aString']);
        }

        //redirect to main form
        $this->goToURL(CONTROLLER.'?m=edit_users');

    }

    function edit_po_numbers(){

        global $searchObj;

        echo $this->parse(TEMPLATE, array('BODY' => $searchObj->display_po_numbers()));


    }

    function delete_po_number($po_number_id){

        global $searchObj;

        $this->db_delete('po_numbers', 'po_number_id', $po_number_id);

        echo $this->parse(TEMPLATE, array('BODY' => $searchObj->display_po_numbers()));

    }

    function add_po_number($po_number){

        global $searchObj;

        $this->db_delete('po_numbers', 'po_number_id', $po_number_id);
        $this->db_insert('po_numbers', array('po_number' => $po_number));

        echo $this->parse(TEMPLATE, array('BODY' => $searchObj->display_po_numbers()));

    }

    function machine_database(){
		global $machineDbObj;
		$machineDbObj->machine_database();
    }

    function machine_detail($machine_id){
		global $machineDbObj;
		$machineDbObj->machine_detail($machine_id);
    }

    function machine_edit($machine_id){
		global $machineDbObj;
		$machineDbObj->machine_edit($machine_id);
    }

    function machine_image(){

        $imagesrc = $_GET['image'];
        $machine_id = $_GET['machine_id'];

        if ($_POST['submit']) {

            $machine_id = $_POST['machine_id'];

            $allowedExts = array("jpg", "jpeg", "gif", "png");
            $extension = end(explode(".", $_FILES["file"]["name"]));
            if ((($_FILES["file"]["type"] == "image/gif")
                    || ($_FILES["file"]["type"] == "image/jpeg")
                    || ($_FILES["file"]["type"] == "image/png")
                    || ($_FILES["file"]["type"] == "image/pjpeg"))
                    && ($_FILES["file"]["size"] < 20000)
                    && in_array($extension, $allowedExts)) {
                if ($_FILES["file"]["error"] > 0) {
                    $error = "Return Code: " . $_FILES["file"]["error"];
                } else {

                    move_uploaded_file($_FILES["file"]["tmp_name"], HTML_FOLDER.'images/machine_images/'.$machine_id.'.'.$extension);
                    $imagesrc = SITE_SURL.'images/machine_images/'.$machine_id.'.'.$extension;
                    $this->db_update('machine_lookup', 'machine_id', $machine_id, array('image_file' => $machine_id.'.'.$extension));
                }
            } else {
                $error = "Invalid file, files must be jpg, jpeg, gif, png max. 20KB.";
            }
        }

        $parse = array(
            'MACHINE_ID'    =>  $machine_id
            ,'ERROR'         =>  $error
            ,'IMAGESRC'     =>  $imagesrc
        );

        echo $this->parse(MACHINE_IMAGE, $parse);

    }

    function pay_periods(){

        global $searchObj;

        $ds_admins = $this->db_select_single('ds_admins', 'aID, aPayroll', array('aUser' => $_SESSION['aUser']));

        if ($ds_admins['aPayroll'] == 'Y'){

            echo $this->parse(TEMPLATE, array('BODY' => $header.$searchObj->display_pay_periods()));
            exit;

        }else{
            $this->goToURL(CONTROLLER);
        }
    }

    function pay_period_edit($period_id){

        //if period exists, we're editing
        if ($period_id){

            $pay_period = $this->db_select_single('ts_pay_period', '*', array('period_id' => $period_id));

            $parse = array(
                'PERIOD_ID'     =>  $pay_period['period_id']
                ,'NAME'         =>  $pay_period['period_name']
                ,'START_DATE'   =>  $this->format_date('templ_date',strtotime($pay_period['period_start_date']))
                ,'END_DATE'     =>  $this->format_date('templ_date',strtotime($pay_period['period_end_date']))
                ,'PAY_DATE'     =>  $this->format_date('templ_date',strtotime($pay_period['period_pay_date']))
                ,'DELETE'       =>  ''
            );

        }else{//blank form for new

            $delete = 'style="display:none;"';

            $parse = array(
                'PERIOD_ID'     =>  ''
                ,'NAME'         =>  ''
                ,'START_DATE'   =>  ''
                ,'END_DATE'     =>  ''
                ,'PAY_DATE'     =>  ''
                ,'DELETE'       =>  $delete
            );
        }

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PAY_PERIOD_EDIT, $parse)));

    }

    function pay_period_save($data){

        global $timesheetObj;

        $delete = 'style="display:none;"';

        //deleting
        if ($data['delete']){

            //if successful, return to main grid
            if ($timesheetObj->delete_pay_period($data['period_id'])){

                $this->goToURL(CONTROLLER.'?m=pay_periods');

            }else{//return to page and show error message

                $delete = '';

                $parse = array(
                    'PERIOD_ID'     =>  $data['period_id']
                    ,'NAME'         =>  $data['period_name']
                    ,'START_DATE'   =>  $data['period_start_date']
                    ,'END_DATE'     =>  $data['period_end_date']
                    ,'PAY_DATE'     =>  $data['period_pay_date']
                    ,'DELETE'       =>  $delete
                );

                $error = '<script type="text/javascript">function displayMessage(){ alert("Pay period cannot be deleted."); }</script>';

                echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PAY_PERIOD_EDIT, $parse).$error));


            }

            exit;

        }

        //calculate dates
        $period_start_date = $this->format_date('db_date',strtotime($data['period_start_date']));
        $period_end_date = $this->format_date('db_date',strtotime($data['period_end_date']));
        $period_pay_date = $this->format_date('db_date',strtotime($data['period_pay_date']));

        //new pay period
        if ($data['period_id'] == ''){

            $extra = 'where period_start_date between "'.$period_start_date.'" and "'.$period_end_date
                    .'" or period_end_date between "'.$period_start_date.'" and "'.$period_end_date
                    .'"';

            $delete = 'style="display:none;"';

        }else{//existing period

            $extra = 'where period_id != "'.$data['period_id']
                    .'" and (period_start_date between "'.$period_start_date.'" and "'.$period_end_date
                    .'" or period_end_date between "'.$period_start_date.'" and "'.$period_end_date
                    .'")';

            $delete = '';

        }

        //check if dates already in existing period
        $pay_period = $this->db_select_multiple('ts_pay_period', '*', array(), $extra);

        if ($pay_period){

            $parse = array(
                'PERIOD_ID'     =>  $data['period_id']
                ,'NAME'         =>  $data['period_name']
                ,'START_DATE'   =>  $data['period_start_date']
                ,'END_DATE'     =>  $data['period_end_date']
                ,'PAY_DATE'     =>  $data['period_pay_date']
                ,'DELETE'       =>  $delete
            );

            $error = '<script type="text/javascript">function displayMessage(){ alert("Invalid dates, already contained in existing pay period."); }</script>';

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PAY_PERIOD_EDIT, $parse).$error));
            exit;

        }

        $pay_period = array(
            'period_name'           =>  $data['period_name']
            ,'period_start_date'    =>  $period_start_date
            ,'period_end_date'      =>  $period_end_date
            ,'period_pay_date'      =>  $period_pay_date
        );

        //save data
        if ($data['period_id'] == ''){
            $timesheetObj->add_pay_period($pay_period);
        }else{
            if(!$timesheetObj->update_pay_period($data['period_id'],$pay_period)){

                $parse = array(
                'PERIOD_ID'     =>  $data['period_id']
                ,'NAME'         =>  $data['period_name']
                ,'START_DATE'   =>  $data['period_start_date']
                ,'END_DATE'     =>  $data['period_end_date']
                ,'PAY_DATE'     =>  $data['period_pay_date']
                ,'DELETE'       =>  $delete
            );

            $error = '<script type="text/javascript">function displayMessage(){ alert("Records exist for this pay period, it cannot be edited."); }</script>';

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PAY_PERIOD_EDIT, $parse).$error));
            exit;

            }
        }


        $this->goToURL(CONTROLLER.'?m=pay_periods');


    }

    function timesheet(){

        global $timesheetObj;

        //set user dropdown to invisible
        $user_display = 'style="display:none;"';

        //get admin record
        $ds_admins = $this->db_select_single('ds_admins', 'aID, aTimesheet, aPayroll', array('aUser' => $_SESSION['aUser']));

        //if payroll user, generate dropdown
        if ($ds_admins['aPayroll'] == 'Y'){
            $payroll = true;

            $admins = $this->db_select_multiple('ds_admins', 'aID, aUser', array('aTimesheet' => 'Y'),'order by aUser');

            if ($_GET['aid']){
                $dd_admins = $this->arrayToHtmlSelectOptions($admins,false,$_GET['aid']);
            }else{
                $dd_admins = $this->arrayToHtmlSelectOptions($admins,false,$ds_admins['aID']);
            }

            $user_display = '';
        }else{
            $payroll = false;
        }

        //set user id based on user type
        if ($ds_admins['aTimesheet'] != 'Y' && !$payroll){
            $this->goToURL(CONTROLLER);
            exit;
        }elseif($ds_admins['aTimesheet'] == 'Y' && !$payroll){
            $aid = $ds_admins['aID'];
        }elseif($ds_admins['aTimesheet'] == 'Y' && $payroll){
            $aid = $ds_admins['aID'];
        }else{
            $aid = $admins[0]['aID'];
        }

        //if returning from user dropdown set to that user if payroll user
        if ($_GET['aid'] && $payroll){
            $aid = $_GET['aid'];
        }

        //get current date
        $curdate = $this->format_date('db_date');

        //get period id if not from GET
        if (!$period_id = $_GET['period_id']){
            //check for current pay period
            if (!$pay_period = $this->db_select_single('ts_pay_period', '*', array(), 'where period_start_date <= "'.$curdate.'" and period_end_date >= "'.$curdate.'"')){
                $pay_period = $this->db_select_single('ts_pay_period', '*', array(), 'order by period_id desc limit 0,1');
            }

            $period_id = $pay_period['period_id'];

        }else{
            $pay_period = $this->db_select_single('ts_pay_period', '*', array('period_id' => $period_id));
        }

        $timesheet_name = $pay_period['period_name'];

        //see if timesheet exists and if not, create one
        if ($timesheet = $this->db_select_single(
                'ts_timesheet', 'timesheet_id, timesheet_submitted',
                array('timesheet_aid' => $aid,
                'period_id' => $period_id))
                ){

            $timesheet_id = $timesheet['timesheet_id'];
            $submitted = (boolean)$timesheet['timesheet_submitted'];

        }else{

            $timesheet_id = $timesheetObj->create_timesheet($aid,$period_id);
            $submitted = false;

        }

        //create pay period drop down
        $dd_pay_periods = $this->db_select_multiple(
                'ts_timesheet ts',
                'ts.period_id, pp.period_name',
                array('timesheet_aid' => $aid),
                'order by pp.period_start_date desc limit 0,50',
                array('ts_pay_period pp on pp.period_id = ts.period_id')
                );

        $dd_array = array();

        foreach ($dd_pay_periods as $row){
            $dd_array[] = $row;
        }

        $timesheet_select = $this->arrayToHtmlSelectOptions($dd_array,false,$period_id);

        //get timesheet data
        $timesheet_detail = $this->db_select_multiple(
                'ts_timesheet_detail',
                '*,date_format(timesheet_detail_date,"%W") dow,date_format(timesheet_detail_start_time,"%H:%i") start_time, date_format(timesheet_detail_end_time,"%H:%i") end_time',
                array('timesheet_id' => $timesheet_id)
                );

        //check if submitted and make readonly unless payroll user
        if ($submitted && !$payroll){
            $readonly = 'readonly';
            $display_buttons = 'style="display:none;"';
        }else{
            $readonly = '';
            $display_buttons = '';
        }

        if ($payroll){
            $display_unlock = '';
        }else{
            $display_unlock = 'style="display:none;"';
        }

        //build grid
        foreach ($timesheet_detail as $row){

            if ($row['dow'] == 'Saturday' || $row[dow] == 'Sunday'){
                $bgcolor = 'LightGray';
            }else{
                $bgcolor = 'White';
            }
            $output .= '<tr>';
            $output .= '<td>'.$row['dow'].'</td>';
            $output .= '<td>'.$this->format_date('templ_date',strtotime($row['timesheet_detail_date'])).'<input type="hidden" id="date['.$row['timesheet_detail_id'].']" name="date['.$row['timesheet_detail_id'].']" value="'.$row['timesheet_detail_date'].'" /></td>';
            $output .= '<td><input style="background-color:'.$bgcolor.';" type="text" '.$readonly.' onchange="formatTime(this);" id="start_time['.$row['timesheet_detail_id'].']" name="start_time['.$row['timesheet_detail_id'].']" value="'.($row['start_time'] == '00:00' ? '' : $row['start_time']).'" /></td>';
            $output .= '<td><input style="background-color:'.$bgcolor.';" type="text" '.$readonly.' onchange="formatTime(this);" id="end_time['.$row['timesheet_detail_id'].']" name="end_time['.$row['timesheet_detail_id'].']" value="'.($row['end_time'] == '00:00' ? '' : $row['end_time']).'" /></td>';
            $output .= '<td><input style="background-color:'.$bgcolor.';" type="text" '.$readonly.' id="hours['.$row['timesheet_detail_id'].']" name="hours['.$row['timesheet_detail_id'].']" value="'.($row['timesheet_detail_hours'] == '0' ? '' : $row['timesheet_detail_hours']).'" /></td>';
            $output .= '<td><input style="background-color:'.$bgcolor.';" type="text" '.$readonly.' id="overtime['.$row['timesheet_detail_id'].']" name="overtime['.$row['timesheet_detail_id'].']" value="'.($row['timesheet_detail_overtime'] == '0' ? '' : $row['timesheet_detail_overtime']).'" /></td>';
            $output .= '<td><input style="background-color:'.$bgcolor.';" type="text" '.$readonly.' id="pto['.$row['timesheet_detail_id'].']" name="pto['.$row['timesheet_detail_id'].']" value="'.($row['timesheet_detail_pto'] == '0' ? '' : $row['timesheet_detail_pto']).'" /></td>';
            $output .= '</tr>';
        }

        //add totals and pto info if submitted
        if ($submitted){

            $totals = $this->db_select_single(
                    'ts_timesheet_detail',
                    'sum(timesheet_detail_hours) hours, sum(timesheet_detail_overtime) overtime, sum(timesheet_detail_pto) pto ',
                    array('timesheet_id' => $timesheet_id)
                    );

            $output .= '<tr>';
            $output .= '<td><strong>Totals</strong></td>';
            $output .= '<td colspan="3"></td>';
            $output .= '<td><input style="font-weight:900;" type="text" readonly value="'.$totals['hours'].'" /></td>';
            $output .= '<td><input style="font-weight:900;" type="text" readonly value="'.$totals['overtime'].'" /></td>';
            $output .= '<td><input style="font-weight:900;" type="text" readonly value="'.$totals['pto'].'" /></td>';
            $output .= '</tr>';

            $pto = $this->db_select_single('ts_timesheet', 'timesheet_pto_total pto', array('timesheet_id' => $timesheet_id));

            $output .= '<tr>';
            $output .= '<td colspan="2"><strong>Accumulated PTO</strong></td>';
            $output .= '<td colspan="4"></td>';
            if ($payroll){
                $output .= '<td><input style="font-weight:900;" type="text" id="pto_accumulated" name="pto_accumulated" value="'.$pto['pto'].'" /></td>';
            }else{
                $output .= '<td><input style="font-weight:900;" type="text" readonly value="'.$pto['pto'].'" /></td>';
            }
            $output .= '</tr>';
        }

        //build form
        $parse = array(
            'TIMESHEET'     =>  $output
            ,'TIMESHEET_ID'         =>  $timesheet_id
            ,'PAY_PERIODS'  =>  $timesheet_select
            ,'DISPLAY_BUTTONS'  =>  $display_buttons
            ,'DISPLAY_UNLOCK'   => $display_unlock
            ,'USERS'            => $dd_admins
            ,'USER_DISPLAY'     => $user_display
            );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(TIMESHEET, $parse)));
        exit;

    }

    function save_timesheet($data){

        global $timesheetObj;

        foreach ($data['date'] as $k => $v){

            $record[$k]['timesheet_detail_date'] = $v;
        }

        foreach ($data['start_time'] as $k => $v){

            $record[$k]['timesheet_detail_start_time'] = $v;
        }

        foreach ($data['end_time'] as $k => $v){

            $record[$k]['timesheet_detail_end_time'] = $v;
        }

        foreach ($data['hours'] as $k => $v){

            $record[$k]['timesheet_detail_hours'] = $v;
        }

        foreach ($data['overtime'] as $k => $v){

            $record[$k]['timesheet_detail_overtime'] = $v;
        }

        foreach ($data['pto'] as $k => $v){

            $record[$k]['timesheet_detail_pto'] = $v;
        }

        foreach ($record as $k => $v){

            $timesheetObj->update_timesheet($k,$v);
        }

        if ($_POST['pto_accumulated']){
            $this->db_update('ts_timesheet', 'timesheet_id', $_POST['timesheet_id'], array('timesheet_pto_total' => $_POST['pto_accumulated']));
        }

        if ($_POST['unlock']){
            $this->db_update('ts_timesheet', 'timesheet_id', $_POST['timesheet_id'], array('timesheet_submitted' => 0,'timesheet_pto_total' => 0));
        }

        if ($_POST['submit']){
            $timesheetObj->submit_timesheet($_POST['timesheet_id']);
        }

        $this->goToURL(CONTROLLER.'?m=timesheet');

    }

    function view_timesheets(){

        global $timesheetObj;

        //get admin record
        $ds_admins = $this->db_select_single('ds_admins', 'aID, aTimesheet, aPayroll', array('aUser' => $_SESSION['aUser']));

        //only view if payroll user
        if ($ds_admins['aPayroll'] != 'Y'){
            $this->goToURL(CONTROLLER);
        }

        //get current date
        $curr_date = $this->format_date('db_date');

        //get pay periods for drop down
        $pay_periods = $this->db_select_multiple('ts_pay_period', 'period_id, period_name', array(), 'order by period_start_date desc limit 0,50');

        //determine period_id
        if ($_POST['pay_period']){
            $period_id = $_POST['pay_period'];
        }else{
            if ($cur_period = $this->db_select_single('ts_pay_period', 'period_id', array(), 'where period_end_date < "'.$curr_date.'" order by period_end_date desc limit 0,1')){
                $period_id = $cur_period['period_id'];
            }else{
                $pay_periods[count($pay_periods)-1]['period_id'];
            }
        }

        //generate pay period drop down
        $dd_pay_periods = $this->arrayToHtmlSelectOptions($pay_periods,false,$period_id);

        $output = $timesheetObj->generate_spreadsheet($period_id);

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(VIEW_TIMESHEET, array('PAY_PERIODS' => $dd_pay_periods,'TIMESHEET' => $output))));

    }

    function find_machine($serialNumber){
		global $machineDbObj;
		$machineDbObj->find_machine($serialNumber);
    }

    function purchase_orders_v2() {
        global $zohoObj, $zoho_auth_tokens;
        $parse = array();
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PURCHASE_ORDERS_DASHBOARD, $parse)));
    }

    function purchase_orders() {

        global $zohoObj, $zoho_auth_tokens;

        //if submitted, save record
        if ($_POST['submit']){

			$data = $_POST;

			$accountZohoId = '';
			$invoiceZohoId = '';

            if ($data['MTSInvoices'] == 1){
                $account_name = $data['account_name'];
            }else{
                $account_name = $data['hdnAccountName'];
				$accountZohoId = $data['hdnAccountZohoId'];
				$invoiceZohoId = $data['hdnInvoiceZohoId'];
            }

			if ($invoiceZohoId) {
				$zohoData = $zohoObj->getInvoiceAccountAndContactDetails($invoiceZohoId);
			}
			if ($zohoData->account) {
				$newAccount = $zohoData->account;
				$newAccount->save();
			}

            //check if account exists and create if not
            $account = $this->db_select_single('po_accounts', '*', array('account_name' => $account_name));



			if ($accountZohoId) {
				$orderAccount = Account::fetchByZohoId($accountZohoId);
				if ($orderAccount) {
					$orderAccountId = $orderAccount->getDbId();
					if ($account['order_account_id'] != $orderAccountId) {
						$escapedName = mysql_real_escape_string($account_name);
						$sql = "UPDATE `po_accounts` SET `order_account_id`='$orderAccountId' WHERE `account_name`='$escapedName';";
						$this->db_query($sql, 'update');
					}
				}
				else {
					$orderAccountId = null;
				}
			}
			else {
				$orderAccount = null;
				$orderAccountId = null;
			}

            if ($account){
                $account_id = $account['account_id'];
                if ($data['MTSInvoices'] == 1){
                    $order_number = $data['po_number'];
                }else{
                    $order_number = $data['MTSInvoices'];
                }
            }else{
                if ($data['MTSInvoices'] == 1){
                    $accountArray = array(
                        'account_name'  => $data['account_name'],
                        'state' => $data['state'],
                        'street'    => $data['street'],
                        'city'  => $data['city'],
                        'zip'   => $data['zip'],
                        'first_name'    => $data['first_name'],
                        'last_name' => $data['last_name'],
                        'email' => $data['email'],
                        'phone' => $data['phone']
                    );
                    $order_number = $data['po_number'];
                }else{
					if ($zohoData && $zohoData->contact) {
						$contact = $zohoData->contact;
						$street = $contact->getAddressStreet();
						$city = $contact->getAddressCity();
						$zip = $contact->getAddressCode();
						$firstName = $contact->getFirstName();
						$lastName = $contact->getLastName();
						$email = $contact->getEmail();
						$phone = $contact->getPhoneNumber();
					}
					else {
						$contact = $zohoObj->getSearchRecords_Contacts($_POST['hdnAccountName']);
						$street = $contact['street'];
						$city = $contact['city'];
						$zip = $contact['zip'];
						$firstName = $contact['first_name'];
						$lastName = $contact['last_name'];
						$email = $contact['email'];
						$phone = $contact['phone'];
					}
                    $accountArray = array(
                        'account_name' => $data['hdnAccountName'],
                        'state' => $data['hdnState'],
                        'street'    => $street,
                        'city'  => $city,
                        'zip'   => $zip,
                        'first_name'    => $firstName,
                        'last_name' => $lastName,
                        'email' => $email,
                        'phone' => $phone
                    );
					if ($orderAccountId) {
						$accountArray['order_account_id'] = $orderAccountId;
					}
                    $order_number = $data['MTSInvoices'];
                }
                $account_id = $this->db_insert('po_accounts', $accountArray);
            }

            //create new order

            $order_data = array(
                'order_number' => $order_number,
                'account_id' => $account_id,
                'notes' => $data['notes'],
                'status_id' => 1,
                'expected_ship_date' => $this->format_date('db_date',strtotime($data['expected_ship_date'])),
                'carrier_id' => $data['carrier_id'],
				'pallets' => $data['pallets'],
				'payment_term' => $data['payment_term']
            );
            $order_id = $this->db_insert('po_orders', $order_data);

            //create order items
            for ($i=0;$i<count($data['machine']);$i++){

                if ($data['machine'][$i] != '0'){

                    $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id, machine_id', array(),' WHERE order_number LIKE "'.$data['machine'][$i].'%"');

                    $item_data = array(
                        'order_id' => $order_id
                        ,'machine_id'   => $machine_order_number['machine_id']
                        ,'order_number_id'   => $machine_order_number['order_number_id']
                        ,'order_number'   => $data['machine'][$i]
                        ,'quantity'     => $data['quantity'][$i]
                        ,'price_a'      => $data['price_a'][$i]
                        ,'price_b'      => $data['price_b'][$i]
                        ,'price_c'      => $data['price_c'][$i]
                        ,'price_d'      => $data['price_d'][$i]
                        ,'price_f'      => $data['price_f'][$i]
                    );

                    $this->db_insert('po_items', $item_data);

                }
            }

            //create deduction items
            $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1), 'order by sequence');

            foreach ($po_deductions_lookups as $lookup){
                $this->db_insert('po_deductions', array('order_id' => $order_id,'deduction_id' => $lookup['deduction_id'],'price' => $data['deduction_'.$lookup['deduction_id']]));
            }

        }

                /* Bilal: Old code block comment out
        $parameters = array(
            'scope'     =>  'crmapi'
            ,'selectColumns'    =>  'All'//columns to select
            ,'fromIndex'        =>  1//start record
            ,'toIndex'          =>  200//end record
            ,'criteria'  =>  '((Status:BB - 1)OR(Status:BB - 2)OR(Status:BB - 3)OR(Status:BB - 4)OR(Status:BB - 5))'//filter
        );

        //retrieve records for all users
        foreach($zoho_auth_tokens as $row){
            $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
            $numberOfRecords = count($result->result->Invoices->row);
            for ($i = 0; $i < $numberOfRecords; $i++) {
                $count = count($result->result->Invoices->row[$i]->FL);
                for ($j = 0; $j < $count; $j++){
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'MTS Quote Number'){
                        $invoice_no = $result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Account Name'){
                        $account_name = (string)$result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Status'){
                        $status = (string)$result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Subject'){
                        $subject = (string)$result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Billing State'){
                        $state = (string)$result->result->Invoices->row[$i]->FL[$j];
                    }
                }



                $account['name'] = $account_name;
                $account['state'] = $state;

                $po_orders = $this->db_select_single('po_orders', '*', array('order_number' => $invoice_no));

                if (!$po_orders){
                    $invoice_nums[(string)$invoice_no] = $account;
                }
            }

        }
                    *
                    */


                $invoices = $zohoObj->getSearchRecords_BB("((Status:starts_with:BB - 1.) OR (Status:starts_with:BB - 2) OR (Status:starts_with:BB - 3) OR (Status:starts_with:BB - 4) OR (Status:starts_with:BB - 5))");
                foreach($invoices as $invoice)
                {
					$invoiceId = $invoice['Invoice_Id'];
                    $invoice_no = $invoice['MTS_Quote_Number'];
					$accountZohoId = $invoice['ACCOUNTID'];
                    $account_name = $invoice['Account_Name'];
                    $status = $invoice['Status'];
                    $subject = $invoice['Subject'];
                    $state = $invoice['Billing_State'];

					$account['accountZohoId'] = $accountZohoId;
					$account['invoiceZohoId'] = $invoiceId;
                    $account['name'] = $account_name;
                    $account['state'] = $state;

                    $po_orders = $this->db_select_single('po_orders', '*', array('order_number' => $invoice_no));

                    if (!$po_orders){
                        $invoice_nums[(string)$invoice_no] = $account;
                    }

                }

        //sort array by mts invoice number
        //array_multisort($invoice_nums,SORT_STRING);
        ksort($invoice_nums);

        $zoho_select = '<option value="0">Select</option>';

        $zoho_select .= '<option value="1">Create New</option>';

        foreach($invoice_nums as $k => $v){
            $zoho_select .= '<option value="'.$k.'" invoice_zoho_id="'.$v['invoiceZohoId'].'" account_zoho_id="'.$v['accountZohoId'].'" account_name="'.$v['name'].'" state="'.$v['state'].'">'.$k.' - '.$v['name'].'</option>';
        }

        //get machine data
        //$machines = $this->db_select_multiple('machine_lookup', 'machine_id, order_number, machine_description',array(),'ORDER BY order_number');
        //$machines = $this->db_select_multiple('machine_order_number', 'machine_lookup.machine_id, machine_order_number.order_number, machine_lookup.machine_description',array(),'ORDER BY order_number',array('machine_lookup ON machine_order_number.machine_id = machine_lookup.machine_id'));
        $machines = $this->db_query("select DISTINCT machine_lookup.machine_id, machine_order_number.order_number, machine_lookup.machine_description from machine_order_number join machine_lookup ON machine_order_number.machine_id = machine_lookup.machine_id ", 'select-multiple');

        $machine_select = '<option value="0">Select</option>';

        foreach ($machines as $machine){
            if ($machine['machine_description'] != '' && $machine['order_number'] != ''){
                $machine_select .= '<option description="'.$machine['machine_description'].'">'.substr($machine['order_number'],0,9).'</option>';
            }
        }

        //get deductions
        $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1), 'order by sequence');

        $deduction_count = count($po_deductions_lookups);

        $row_count = round($deduction_count/2);

        $counter = 0;

        $deduction_table = '<table><tr><td colspan="2"><strong>Deduction Values</strong></td></tr><tr><td><table>';

        foreach ($po_deductions_lookups as $lookup){

            $counter++;

            $deduction_table .= '<tr><td>'.$lookup['deduction_name'].'<td><input type="tel" name="deduction_'.$lookup['deduction_id'].'" id="deduction_'.$lookup['deduction_id'].'" style="width:30px;" maxlength="6" /></td></tr>';

            if ($counter == $row_count){

                $deduction_table .= '</table></td><td><table>';

            }

        }

        if ($counter < $row_count*2){
            $deduction_table .= '<tr><td colspan="2">&nbsp;</td></tr>';
        }

        $deduction_table .= '</td></tr></table></td></tr></table>';

        $po_carriers = $this->db_select_multiple('po_carriers', '*');

        $carriers = '<option>Select</option>';

        foreach ($po_carriers as $carrier){
            $carriers .= '<option value="'.$carrier['carrier_id'].'">'.$carrier['carrier_name'].'</option>';
        }

        //parse form
        $parse = array(
                'STAFF'			=> $this->arrayToHtmlSelectOptions($dd,false,$default)
                ,'MTS_INVOICES'         => $zoho_select
                ,'MACHINES'             => $machine_select
                ,'DEDUCTIONS'           => $deduction_table
                ,'CARRIERS'             => $carriers
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PURCHASE_ORDERS, $parse)));

    }

    function purchase_order_edit($order_id) {

        if ($_POST['cancel']){
            $this->bb_detail($_POST['order_id']);
            exit;
        }

        if ($_POST['submit_action'] == 'Add'){

            $sql = 'SELECT DISTINCT dso.asset, COUNT(dso.oID) AS quantity
            FROM ds_orders dso
            WHERE dso.poNumber = "'.$_POST['poNumber'].'"
            AND asset NOT IN
            (SELECT DISTINCT poi.order_number
            FROM po_items poi
            LEFT JOIN po_orders po ON po.order_id = poi.order_id
            WHERE po.order_number = "'.$_POST['poNumber'].'")
            AND dso.asset != ""
            GROUP BY dso.asset';

        $unexpected_items = $this->db_query($sql, 'select-multiple');

        foreach ($unexpected_items as $item){
			$asset = $item['asset'];
			$realAsset = $asset;
			if (preg_match('/(-\d{1,3}\/\d{2,4})/', $asset)) { // Look for special skus
				$dividerPosition = strpos($asset, '-');
				$realAsset = substr($asset, 0, $dividerPosition);
			}
			$item['asset'] = $realAsset;

            $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id, machine_id', array('order_number' => $item['asset']));

            if ($machine_order_number){
                $order_number_id = $machine_order_number['order_number_id'];
                $machine_id = $machine_order_number['machine_id'];

                $update = array(
                    'order_id'  => $order_id,
                    'machine_id'    => $machine_id,
                    'order_number_id'   => $order_number_id,
                    'order_number'  => $item['asset'],
                    'quantity'  => $item['quantity'],
                    'price_a'   => 0,
                    'price_b'   => 0,
                    'price_c'   => 0,
                    'price_d'   => 0,
                    'price_f'   => 0
                );

                $this->db_insert('po_items', $update, false);
            }

        }


        }

        //if submitted, save record
        if ($_POST['submit'] && $_POST['submit'] == 'Save'){

            $data = $_POST;

            $this->db_delete('po_items', 'order_id', $data['order_id']);
            //create order items
            for ($i=0;$i<count($data['machine']);$i++){

                if ($data['machine'][$i] != '0' && $data['machine'][$i] != '-1'){

                    $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id, machine_id, order_number', array(),' WHERE order_number_id = "'.$data['machine'][$i].'"');

                    $item_data = array(
                        'order_id' => $data['order_id']
                        ,'machine_id'   => $machine_order_number['machine_id']
                        ,'order_number_id'   => $machine_order_number['order_number_id']
                        ,'order_number'   => $machine_order_number['order_number']
                        ,'quantity'     => $data['quantity'][$i]
                        ,'price_a'      => $data['price_a'][$i]
                        ,'price_b'      => $data['price_b'][$i]
                        ,'price_c'      => $data['price_c'][$i]
                        ,'price_d'      => $data['price_d'][$i]
                        ,'price_f'      => $data['price_f'][$i]
                    );

                    $this->db_insert('po_items', $item_data);
                }
            }

            $this->db_delete('po_deductions', 'order_id', $data['order_id']);

            //create deduction items
            $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1), 'order by sequence');

            foreach ($po_deductions_lookups as $lookup){
                $this->db_insert('po_deductions', array('order_id' => $order_id,'deduction_id' => $lookup['deduction_id'],'price' => $data['deduction_'.$lookup['deduction_id']]));
            }

            $_POST['submit'] = false;

            $this->bb_detail($_POST['order_id']);
            exit;

        }

        $order = $this->db_select_single('po_orders', 'order_id, order_number, notes, account_name', array('order_id' => $order_id), '', array('po_accounts ON po_accounts.account_id = po_orders.account_id'));

        $order_items = $this->db_select_multiple('po_items', '*', array('order_id' => $order_id),'ORDER BY item_id');

        //get machine data

		$sql = "SELECT mon.order_number_id, mon.order_number, ml.machine_description FROM machine_order_number AS mon JOIN machine_lookup AS ml ON mon.machine_id = ml.machine_id ORDER BY mon.order_number ASC;";
        $machines = $this->db_query($sql, 'select-multiple');

        $i = 1;

        $machine_select = '';
        $price_table = '';

        foreach ($order_items as $order_item){

			$orderItemId = $order_item['order_number_id'];

            $machine_description = '';

            $machine_select .= '<tr id="machine_row_'.$i.'">
                                <td><select name="machine[]" onchange="getDescription(this);">';

            $machine_select .= '<option value="0">Select To Delete</option>';

            foreach ($machines as $machine){
				$machineId = $machine['order_number_id'];
				$escapedMachineDescription = trim(addslashes($machine['machine_description']));
				$escapedSku = trim(addslashes($machine['order_number']));

				if ($escapedMachineDescription != '' && $escapedSku != '') {
					$selected = '';
					if ($machineId == $orderItemId) {
						$selected = 'selected';
						$machine_description = $machine['machine_description'];
					}
					$machine_select .= "<option value='$machineId' description='$escapedMachineDescription' $selected>$escapedSku</option>";
				}
            }

            $machine_select .= '</select></td><td style="width:300px;">'.$machine_description.'</td>
                                <td><input type="tel" name="quantity[]" style="width:30px;" value="'.$order_item['quantity'].'"/></td>
                            </tr>';

            $price_table .= '<tr id="price_row_'.$i.'">
                                <td><input type="tel" name="price_a[]" style="width:30px;" maxlength="6" value="'.$order_item['price_a'].'" /></td>
                                <td><input type="tel" name="price_b[]" style="width:30px;" maxlength="6" value="'.$order_item['price_b'].'" /></td>
                                <td><input type="tel" name="price_c[]" style="width:30px;" maxlength="6" value="'.$order_item['price_c'].'"/></td>
                                <td><input type="tel" name="price_d[]" style="width:30px;" maxlength="6" value="'.$order_item['price_d'].'"/></td>
                                <td><input type="tel" name="price_f[]" style="width:30px;" maxlength="6" value="'.$order_item['price_f'].'"/></td>
                            </tr>';

            $i++;

        }

        //get deductions
        $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1), 'order by sequence');

        $po_deductions = $this->db_select_multiple('po_deductions', '*', array('order_id' => $order_id));

        $deduction_count = count($po_deductions_lookups);

        $row_count = round($deduction_count/2);

        $counter = 0;

        $deduction_table = '<table><tr><td colspan="2"><strong>Deduction Values</strong></td></tr><tr><td><table>';

        foreach ($po_deductions_lookups as $lookup){

            $price = '';

            foreach ($po_deductions as $deduction){
                if ($deduction['deduction_id'] == $lookup['deduction_id']){
                    $price = $deduction['price'];
                }
            }

            $counter++;

            $deduction_table .= '<tr><td>'.$lookup['deduction_name'].'<td><input type="tel" name="deduction_'.$lookup['deduction_id'].'" id="deduction_'.$lookup['deduction_id'].'" style="width:30px;" maxlength="6" value="'.$price.'" /></td></tr>';

            if ($counter == $row_count){

                $deduction_table .= '</table></td><td><table>';

            }

        }

        if ($counter < $row_count*2){
            $deduction_table .= '<tr><td colspan="2">&nbsp;</td></tr>';
        }

        $deduction_table .= '</td></tr></table></td></tr></table>';


        //parse form
        $parse = array(
                'ORDER_ID'              => $order_id
                ,'ORDER_NUMBER_NAME'    => $order['order_number'].' '.$order['account_name']
                ,'MACHINES'             => $machine_select
                ,'PRICE_TABLE'          => $price_table
                ,'DEDUCTIONS'           => $deduction_table
                ,'NOTES'             => $order['notes']
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(PURCHASE_ORDER_EDIT, $parse)));

    }

    function bb_receiving() {

        //if submitted, save record
        if ($_POST && !$_POST['submit']){

            $data = $_POST;

            for ($i=0;$i<count($data['qty_ipad']);$i++){

                $rack_data = array(
                    'qty_ipad'  =>  $data['qty_ipad'][$i],
                    'qty_macbook'   =>  $data['qty_macbook'][$i],
                    'qty_macbook_pro'   =>  $data['qty_macbook_pro'][$i],
                    'qty_macbook_air'   =>  $data['qty_macbook_air'][$i],
                    'qty_imac'  =>  $data['qty_imac'][$i],
                    'qty_mac_mini'  =>  $data['qty_mac_mini'][$i],
                    'qty_other' =>  $data['qty_other'][$i]
                );

                $tmp_rack = array_filter($rack_data);

                if (count($tmp_rack) > 0){
                    $po_received = $this->db_select_single('po_received', 'received_id', array('order_id' => $data['order_id'],'rack_no' => $i+1));

                    if ($po_received){
                        $this->db_update('po_received', 'received_id', $po_received['received_id'], $rack_data);
                    }else{
                        $rack_data['order_id'] = $data['order_id'];
                        $rack_data['rack_no'] = $i+1;
                        $this->db_insert('po_received', $rack_data);
                    }
                }
            }

            for ($i=0;$i<count($data['qty_accessory']);$i++){

                if ($data['weight_accessory'][$i] > 0){
                    $po_deductopn_lookup = $this->db_select_single('po_deductions_lookup', 'weight', array('deduction_id' => $data['deduction_id'][$i]));
                    $data['qty_accessory'][$i] = round((float)$data['weight_accessory'][$i]/(float)$po_deductopn_lookup['weight']);
                }

                $accessory_data = array(
                    'quantity'  =>  $data['qty_accessory'][$i],
                    'quantity_3rd'  =>  $data['qty_accessory_3rd'][$i],
                    'weight'   =>  $data['weight_accessory'][$i]
                    );

                $tmp_accessory = array_filter($accessory_data);

                if (count($tmp_accessory) > 0 || $data['hdnZeroAccessories'] == 'true'){

                    $po_accessories_received = $this->db_select_single('po_accessories_received', 'accessories_received_id', array('order_id' => $data['order_id'],'deduction_id' => $data['deduction_id'][$i]));

                    if ($po_accessories_received){
                        $this->db_update('po_accessories_received', 'order_id', $data['order_id'], $accessory_data,'deduction_id',$data['deduction_id'][$i]);
                    }else{
                        $accessory_data['order_id'] = $data['order_id'];
                        $accessory_data['deduction_id'] = $data['deduction_id'][$i];
                        $this->db_insert('po_accessories_received', $accessory_data);
                    }
                }
            }


            echo 'Data saved';


        }else{

            if ($_POST['submit']){

                global $zohoObj, $zoho_auth_tokens;

                $data = $_POST;

                $order = $this->db_select_single('po_orders', 'order_number', array('order_id' => $data['MTSInvoices']));

                /* Bilal: Old code block comment out
                $parameters = array(
                    'scope'     =>  'crmapi'
                    ,'selectColumns'    =>  'All'//columns to select
                    ,'fromIndex'        =>  1//start record
                    ,'toIndex'          =>  200//end record
                    ,'criteria'  =>  '(MTS Quote Number:'.$order['order_number'].')'//filter
                );

                //retrieve records for all users
                foreach($zoho_auth_tokens as $row){
                    $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
                    $numberOfRecords = count($result->result->Invoices->row);
                    for ($i = 0; $i < $numberOfRecords; $i++) {
                        $zoho_id = (string)$result->result->Invoices->row[$i]->FL[0];
                        $authtoken = $row['authtoken'];
                        $count = count($result->result->Invoices->row[$i]->FL);
                        for ($j = 0; $j < $count; $j++){
                            if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Notes'){
                                $notes = $result->result->Invoices->row[$i]->FL[$j];
                                break;
                            }
                        }
                    }
                }

                $notes .= ' Arrival Date: '. $this->format_date('templ_date');

                $zoho_data = array('Status' => 'BB - 5. Arrived - Initial Count Complete','Notes' => $notes);

                $zohoObj->updateInvoice($authtoken,$zoho_id,$zoho_data);
                    *
                    */

                /* Bilal Modifications */
                $zohoObj->update_record_admin_2($order['order_number'],"BB - 5. Arrived - Initial Count Complete",$this->format_date('templ_date'));

                $this->db_update('po_orders', 'order_id', $data['MTSInvoices'], array('date_received' => $this->format_date('db_date'),'zoho_status' => 'BB - 5. Arrived - Initial Count Complete'));

                for ($i=0;$i<count($data['qty_ipad']);$i++){

                    $rack_data = array(
                        'qty_ipad'  =>  $data['qty_ipad'][$i],
                        'qty_macbook'   =>  $data['qty_macbook'][$i],
                        'qty_macbook_pro'   =>  $data['qty_macbook_pro'][$i],
                        'qty_macbook_air'   =>  $data['qty_macbook_air'][$i],
                        'qty_imac'  =>  $data['qty_imac'][$i],
                        'qty_mac_mini'  =>  $data['qty_mac_mini'][$i],
                        'qty_other' =>  $data['qty_other'][$i]
                    );

                    $tmp_rack = array_filter($rack_data);

                    if (count($tmp_rack) > 0){

                        $po_received = $this->db_select_single('po_received', 'received_id', array('order_id' => $data['MTSInvoices'],'rack_no' => $i+1));

                        if ($po_received){
                            $this->db_update('po_received', 'received_id', $po_received['received_id'], $rack_data);
                        }else{
                            $rack_data['order_id'] = $data['order_id'];
                            $rack_data['rack_no'] = $i+1;
                            $this->db_insert('po_received', $rack_data);
                        }
                    }
                }

                foreach ($data['qty_accessory'] as $k => $v){

                    $accessory_data = array(
                        'quantity'  =>  $v,
                        'quantity_3rd'   =>  $data['quantity_accessory_3rd'][$k],
                        'weight'   =>  $data['weight_accessory'][$k]
                        );

                    $tmp_accessory = array_filter($accessory_data);

                    if (count($tmp_accessory) > 0 || $data['hdnZeroAccessories'] == 'true'){

                        $po_accessories_received = $this->db_select_single('po_accessories_received', 'accessories_received_id', array('order_id' => $data['MTSInvoices'],'deduction_id' => $k));

                        if ($po_accessories_received){
                            $this->db_update('po_accessories_received', 'order_id', $data['order_id'], $accessory_data,'deduction_id',$k);
                        }else{
                            $accessory_data['order_id'] = $data['MTSInvoices'];
                            $accessory_data['deduction_id'] = $k;
                            $this->db_insert('po_accessories_received', $accessory_data);
                        }
                    }
                }

                $this->db_update('po_orders', 'order_id', $data['MTSInvoices'], array('status_id' => 2));

            }

            $po_orders = $this->db_select_multiple('po_orders', 'po_orders.order_id, po_orders.order_number, po_accounts.account_name', array('status_id' =>1), 'ORDER BY po_orders.order_number', array('po_accounts ON po_orders.account_id = po_accounts.account_id'));

            $po_select = '<option value="0">Select</option>';

            foreach($po_orders as $po_order){
                $po_select .= '<option value="'.$po_order['order_id'].'">'.$po_order['order_number'].' - '.$po_order['account_name'].'</option>';
            }

            //get deductions
            $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1,'accessory' => 1), 'order by sequence');

            $deduction_count = count($po_deductions_lookups);

            $row_count = round($deduction_count/2);

            $counter = 0;

            $deduction_table = '<table><tr><td colspan="2"><strong>Quantity of Accessories Received</strong></td></tr><tr><td><table>';
            $deduction_table .= '<tr><td></td><td colspan="4"><strong>QTY or 3rd Party or Weight (KG)</strong></td></tr>';

            $accessory_rows = array();

            foreach ($po_deductions_lookups as $lookup){

                $counter++;

                $deduction_table .= '<tr><td>'.$lookup['deduction_name'].'</td>'
                        . '<td><input type="tel" deduction_id="'.$lookup['deduction_id'].'" name="qty_accessory['.$lookup['deduction_id'].']" id="qty_accessory_'.$lookup['deduction_id'].'" style="width:40px;" maxlength="6" /></td>'
                        . '<td><input type="tel" deduction_id="'.$lookup['deduction_id'].'" name="qty_accessory_3rd['.$lookup['deduction_id'].']" id="qty_accessory_3rd_'.$lookup['deduction_id'].'" style="width:40px;" maxlength="6" /></td>'
                        . '<td><input type="tel" name="weight_accessory['.$lookup['deduction_id'].']" id="weight_accessory_'.$lookup['deduction_id'].'" style="width:40px;" maxlength="6" /></td>'
                        . '<td><input type="button" id="accessory_'.$lookup['deduction_id'].'" deduction_id="'.$lookup['deduction_id'].'" value="Upload" onclick="getAccessoryFile(this)" /><input type="file" id="upload_accessory_'.$lookup['deduction_id'].'" deduction_id="'.$lookup['deduction_id'].'" style="display: none;" accept="image/*" capture="camera" onchange="uploadAccessory(this);" /></td>'
                        . '<td id="tick_accessory_'.$lookup['deduction_id'].'">&nbsp;</td></tr>';

                if ($counter == $row_count){

                    $deduction_table .= '</table></td><td><table><tr><td></td><td colspan="4"><strong>QTY or 3rd Party or Weight (KG)</strong></td></tr>';

                }

                $accessory_rows[] = $lookup['deduction_id'];

            }

            if ($counter < $row_count*2){
                $deduction_table .= '<tr><td colspan="2">&nbsp;</td></tr>';
            }

            $deduction_table .= '</td></tr></table></td></tr></table>';

            //parse form
            $parse = array(
                    'STAFF'			=> $this->arrayToHtmlSelectOptions($dd,false,$default)
                    ,'MTS_INVOICES'         => $po_select
                    ,'ACCESSORIES'           => $deduction_table
                    //,'ACCESSORY_ROWS'        => $deduction_count
                    ,'ACCESSORY_ROWS'        => json_encode($accessory_rows)
            );

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(BB_RECEIVING, $parse)));

        }

    }

    function bb_print_rack_tag(){

        $data = $_POST;

        $po_received = $this->db_select_single('po_received', '*', array('order_id' => $data['order_id'],'rack_no' => $data['racknum']));

        $racks = $this->db_select_multiple('po_received', '*', array('order_id' => $data['order_id']));

        $count = count($racks);

        $po_order = $this->db_select_single('po_orders', 'order_number, account_id', array('order_id' => $data['order_id']));

        $po_account = $this->db_select_single('po_accounts', 'account_name', array('account_id' => $po_order['account_id']));

        $printdata = $po_received;

        $printdata['account_name'] = $po_account['account_name'];
        $printdata['order_number'] = $po_order['order_number'];
        $printdata['rack_no'] = $data['racknum'];
        $printdata['rack_count'] = $count;
        $printdata['date_received'] = $this->format_date('templ_date');

        $this->print_rack_tag($printdata);

        echo 'Rack tag printed';

    }

    function bb_status(){

        $sql = "SELECT poo.order_id, poo.order_number, poa.account_name, poo.notes, DATE_FORMAT(poo.date_received,'%m/%d/%Y') AS date_received,
            SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other) AS devices_received,
            (SELECT SUM(quantity) FROM po_accessories_received WHERE order_id = poo.order_id) AS accessories_received,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus NOT IN('Refurb - Imaged', 'Void')) AS devices_audited,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus = 'Refurb - Imaged' AND is_ipad = 1) AS ipads_imaged,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus = 'Refurb - Imaged' AND (is_ipad = 0 OR is_ipad IS NULL)) AS others_imaged,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus NOT IN('Refurb - Imaged', 'Void'))/(SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other)) AS progress
            FROM po_orders poo
            LEFT JOIN po_accounts poa ON poo.account_id = poa.account_id
            LEFT JOIN po_received por ON por.order_id = poo.order_id
            WHERE poo.status_id = 2
            GROUP BY poo.order_id
            ORDER BY poo.date_received DESC;";

        $active_orders = $this->db_query($sql, 'select-multiple');

        if ($active_orders){

            $active_count = 0;
            $complete_count = 0;

            $active_table = '<tr>'
                    . '<td align="center"><strong>Active - In Process</strong></td>'
                    . '</tr>'
                    . '<tr><td>'
                    . '<table cellpadding="4">'
                    . '<tr>'
                    . '<td><strong>School Name</strong></td>'
                    . '<td><strong>MTS Number</strong></td>'
                    . '<td><strong>Date Received</strong></td>'
                    . '<td><strong>Devices Received</strong></td>'
                    . '<td><strong>Accessories Received</strong></td>'
                    . '<td><strong>iPads Imaged</strong></td>'
                    . '<td><strong>Macs Imaged</strong></td>'
                    . '<td><strong>Devices Audited</strong></td>'
                    . '<td><strong>Progress</strong></td>'
                    . '<td><strong>Notes</strong></td>'
                    . '</tr>';

            $complete_table = '<tr>'
                    . '<td align="center"><strong>Audit Complete - Not Paid</strong></td>'
                    . '</tr>'
                    . '<tr><td>'
                    . '<table cellpadding="4">'
                    . '<tr>'
                    . '<td><strong>School Name</strong></td>'
                    . '<td><strong>MTS Number</strong></td>'
                    . '<td><strong>Date Received</strong></td>'
                    . '<td><strong>Devices Received</strong></td>'
                    . '<td><strong>Accessories Received</strong></td>'
                    . '<td><strong>iPads Imaged</strong></td>'
                    . '<td><strong>Macs Imaged</strong></td>'
                    . '<td><strong>Devices Audited</strong></td>'
                    . '<td><strong>Progress</strong></td>'
                    . '<td><strong>Notes</strong></td>'
                    . '</tr>';

            foreach ($active_orders as $order){
                if ($order['progress'] >= 1){
                    $complete_count ++;
                    $complete_table .= '<tr>'
                        . '<td><a href="'.CONTROLLER.'?m=bb_detail&order_id='.$order['order_id'].'">'.$order['account_name'].'</a></td>'
                        . '<td>'.$order['order_number'].'</td>'
                        . '<td>'.$order['date_received'].'</td>'
                        . '<td>'.$order['devices_received'].'</td>'
                        . '<td>'.$order['accessories_received'].'</td>'
                        . '<td>'.$order['ipads_imaged'].'</td>'
                        . '<td>'.$order['others_imaged'].'</td>'
                        . '<td>'.$order['devices_audited'].'</td>'
                        . '<td>'.floor($order['progress']*100).'%</td>'
                        . '<td>'.$order['notes'].'</td>'
                        . '</tr>';
                }else{
                    $active_count ++;
                    $active_table .= '<tr>'
                        . '<td><a href="'.CONTROLLER.'?m=bb_detail&order_id='.$order['order_id'].'">'.$order['account_name'].'</a></td>'
                        . '<td>'.$order['order_number'].'</td>'
                        . '<td>'.$order['date_received'].'</td>'
                        . '<td>'.$order['devices_received'].'</td>'
                        . '<td>'.$order['accessories_received'].'</td>'
                        . '<td>'.$order['ipads_imaged'].'</td>'
                        . '<td>'.$order['others_imaged'].'</td>'
                        . '<td>'.$order['devices_audited'].'</td>'
                        . '<td>'.floor($order['progress']*100).'%</td>'
                        . '<td>'.$order['notes'].'</td>'
                        . '</tr>';

                }
            }

            $active_table .= '</table></td></tr>';
            $complete_table .= '</table></td></tr>';

        }else{
            $complete_table = '';
            $active_table = '';
        }

        if ($active_count == 0){
            $active_table = '';
        }

        if ($complete_count == 0){
            $complete_table = '';
        }

        $sql = 'SELECT poo.order_id, poa.account_name, poo.order_number, poo.expected_ship_date, poc.carrier_name, poo.pallets, poo.notes,
            (SELECT SUM(quantity) FROM po_items WHERE order_id = poo.order_id) AS devices_expected
            FROM po_orders poo
            LEFT JOIN po_accounts poa ON poa.account_id = poo.account_id
            LEFT JOIN po_carriers poc ON poc.carrier_id = poo.carrier_id
            WHERE poo.status_id = 1
            ORDER BY poo.expected_ship_date DESC';

        $inbound_orders = $this->db_query($sql, 'select-multiple');

        if ($inbound_orders){

            $inbound_table = '<tr>'
                    . '<td align="center"><strong>Inbound</strong></td>'
                    . '</tr>'
                    . '<tr><td>'
                    . '<table cellpadding="4">'
                    . '<tr>'
                    . '<td><strong>School Name</strong></td>'
                    . '<td><strong>MTS Number</strong></td>'
                    . '<td><strong>Devices Expected</strong></td>'
                    . '<td><strong>Expected Ship Date</strong></td>'
                    . '<td><strong>Carrier</strong></td>'
                    . '<td><strong>Boxes/Pallets</strong></td>'
                    . '<td><strong>Notes</strong></td>'
                    . '</tr>';

            foreach ($inbound_orders as $order){
                $inbound_table .= '<tr>'
                        . '<td><a href="'.CONTROLLER.'?m=bb_detail&order_id='.$order['order_id'].'">'.$order['account_name'].'</a></td>'
                        . '<td>'.$order['order_number'].'</td>'
                        . '<td>'.$order['devices_expected'].'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['expected_ship_date'])).'</td>'
                        . '<td>'.$order['carrier_name'].'</td>'
                        . '<td>'.$order['pallets'].'</td>'
                        . '<td>'.$order['notes'].'</td>'
                        . '</tr>';
            }

            $inbound_table .= '</table></td></tr>';

        }else{

            $inbound_table = '';

        }

        $sql = 'SELECT poo.order_id, poa.account_name, poo.order_number, poo.notes,
            poo.date_received, poo.payment_sent_date, date_add(poo.date_received,INTERVAL 60 DAY) AS payment_due,
            datediff(poo.payment_sent_date,poo.date_received) AS days_to_payment,
            (SELECT MAX(DATE(dol.`time`)) AS max_date FROM ds_order_logs dol
                LEFT JOIN ds_orders dso ON dso.oNum = dol.oNum
                WHERE dso.poNumber = poo.order_number AND dol.details LIKE "%Audited%") AS audit_complete
            FROM po_orders poo
            LEFT JOIN po_accounts poa ON poa.account_id = poo.account_id
            WHERE poo.status_id = 3 and poo.payment_sent_date IS NOT NULL
            ORDER BY poo.date_received DESC';

        $complete_paid = $this->db_query($sql, 'select-multiple');

        if ($complete_paid){

            $complete_paid_table = '<tr>'
                    . '<td align="center"><strong>Complete Paid</strong></td>'
                    . '</tr>'
                    . '<tr><td>'
                    . '<table cellpadding="4">'
                    . '<tr>'
                    . '<td><strong>School Name</strong></td>'
                    . '<td><strong>MTS Number</strong></td>'
                    . '<td><strong>Date Received</strong></td>'
                    . '<td><strong>Audit Complete</strong></td>'
                    . '<td><strong>Payment Due</strong></td>'
                    . '<td><strong>Payment Sent</strong></td>'
                    . '<td><strong>Days to Payment</strong></td>'
                    . '<td><strong>Notes</strong></td>'
                    . '</tr>';

            foreach ($complete_paid as $order){
                $complete_paid_table .= '<tr>'
                        . '<td><a href="'.CONTROLLER.'?m=bb_detail&order_id='.$order['order_id'].'">'.$order['account_name'].'</a></td>'
                        . '<td>'.$order['order_number'].'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['date_received'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['audit_complete'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['payment_due'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['payment_sent_date'])).'</td>'
                        . '<td>'.$order['days_to_payment'].'</td>'
                        . '<td>'.$order['notes'].'</td>'
                        . '</tr>';
            }

            $complete_paid_table .= '</table></td></tr>';

        }else{

            $complete_paid_table = '';

        }

        $sql = 'SELECT poo.order_id, poa.account_name, poo.order_number, poo.notes,
            poo.date_received, poo.payment_sent_date, date_add(poo.date_received,INTERVAL 60 DAY) AS payment_due,
            datediff(poo.payment_sent_date,poo.date_received) AS days_to_payment,
            (SELECT MAX(DATE(dol.`time`)) AS max_date FROM ds_order_logs dol
                LEFT JOIN ds_orders dso ON dso.oNum = dol.oNum
                WHERE dso.poNumber = poo.order_number AND dol.details LIKE "%Audited%") AS audit_complete
            FROM po_orders poo
            LEFT JOIN po_accounts poa ON poa.account_id = poo.account_id
            WHERE poo.status_id = 3 and poo.payment_sent_date IS NULL
            ORDER BY poo.date_received DESC';

        $audit_complete = $this->db_query($sql, 'select-multiple');

        if ($audit_complete){

            $audit_complete_table = '<tr>'
                    . '<td align="center"><strong>Audit Complete</strong></td>'
                    . '</tr>'
                    . '<tr><td>'
                    . '<table cellpadding="4">'
                    . '<tr>'
                    . '<td><strong>School Name</strong></td>'
                    . '<td><strong>MTS Number</strong></td>'
                    . '<td><strong>Date Received</strong></td>'
                    . '<td><strong>Audit Complete</strong></td>'
                    . '<td><strong>Payment Due</strong></td>'
                    . '<td><strong>Payment Sent</strong></td>'
                    . '<td><strong>Days to Payment</strong></td>'
                    . '<td><strong>Notes</strong></td>'
                    . '</tr>';

            foreach ($audit_complete as $order){
                $audit_complete_table .= '<tr>'
                        . '<td><a href="'.CONTROLLER.'?m=bb_detail&order_id='.$order['order_id'].'">'.$order['account_name'].'</a></td>'
                        . '<td>'.$order['order_number'].'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['date_received'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['audit_complete'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['payment_due'])).'</td>'
                        . '<td>'. $this->format_date('templ_date',strtotime($order['payment_sent_date'])).'</td>'
                        . '<td>'.$order['days_to_payment'].'</td>'
                        . '<td>'.$order['notes'].'</td>'
                        . '</tr>';
            }

            $audit_complete_table .= '</table></td></tr>';

        }else{

            $audit_complete_table = '';

        }

        $parse = array(
            'ACTIVE' => $active_table,
            'COMPLETE_NOT_PAID' => $complete_table,
            'INBOUND' => $inbound_table,
            'AUDIT_COMPLETE'  => $audit_complete_table,
            'COMPLETE_PAID'  => $complete_paid_table
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(BB_STATUS, $parse)));

    }

    function bb_report(){

        $sql = 'SELECT pa.account_name, po.order_number AS po_number, DATE_FORMAT(po.date_received,"%m/%d/%Y") AS date_received, pi.order_number, pi.quantity, ps.status_description, DATE_FORMAT(po.expected_ship_date,"%m/%d/%Y") AS expected_ship_date
                FROM po_orders po
                LEFT JOIN po_accounts pa ON pa.account_id = po.account_id
                LEFT JOIN po_items pi ON pi.order_id = po.order_id
                LEFT JOIN po_status ps ON ps.status_id = po.status_id
                WHERE po.status_id IN (1,2) AND po.payment_sent_date IS NULL
                ORDER BY po.order_number';

        $bb_report = $this->db_query($sql, 'select-multiple');

        $report_table = '<table class="sortable">';

        $report_table .= '<tr>'
                . '<td><strong>School Name</strong></td>'
                . '<td><strong>MTS Number</strong></td>'
                . '<td align="right"><strong>Date Received</strong></td>'
                . '<td><strong>SKU</strong></td>'
                . '<td align="right"><strong>Quantity</strong></td>'
                . '<td><strong>Status</strong></td>'
                . '<td align="right"><strong>Expected Ship Date</strong></td>'
                . '</tr>';

        foreach ($bb_report as $report){

            $report_table .= '<tr>'
                    . '<td>'.$report['account_name'].'</td>'
                    . '<td>'.$report['po_number'].'</td>'
                    . '<td align="right">'.$report['date_received'].'</td>'
                    . '<td>'.$report['order_number'].'</td>'
                    . '<td align="right">'.$report['quantity'].'</td>'
                    . '<td>'.$report['status_description'].'</td>'
                    . '<td align="right">'.$report['expected_ship_date'].'</td>'
                    . '</tr>';
        }

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(BB_REPORT, array('REPORT' => $report_table))));

    }

    function bb_inventory(){

        $sql = 'SELECT pa.account_name, po.order_number AS po_number, DATE_FORMAT(po.date_received,"%m/%d/%Y") AS date_received, pi.order_number, pi.quantity, ps.status_description, DATE_FORMAT(po.expected_ship_date,"%m/%d/%Y") AS expected_ship_date
                FROM po_orders po
                LEFT JOIN po_accounts pa ON pa.account_id = po.account_id
                LEFT JOIN po_items pi ON pi.order_id = po.order_id
                LEFT JOIN po_status ps ON ps.status_id = po.status_id
                WHERE po.status_id = 2 OR (po.status_id = 3 AND po.payment_sent_date IS NULL)
                ORDER BY po.order_number';

        $bb_report = $this->db_query($sql, 'select-multiple');

        $report_table = '<table class="sortable">';

        $report_table .= '<tr>'
                . '<td><strong>School Name</strong></td>'
                . '<td><strong>MTS Number</strong></td>'
                . '<td align="right"><strong>Date Received</strong></td>'
                . '<td><strong>SKU</strong></td>'
                . '<td align="right"><strong>Quantity</strong></td>'
                . '<td><strong>Status</strong></td>'
                . '<td align="right"><strong>Expected Ship Date</strong></td>'
                . '</tr>';

        foreach ($bb_report as $report){

            $report_table .= '<tr>'
                    . '<td>'.$report['account_name'].'</td>'
                    . '<td>'.$report['po_number'].'</td>'
                    . '<td align="right">'.$report['date_received'].'</td>'
                    . '<td>'.$report['order_number'].'</td>'
                    . '<td align="right">'.$report['quantity'].'</td>'
                    . '<td>'.$report['status_description'].'</td>'
                    . '<td align="right">'.$report['expected_ship_date'].'</td>'
                    . '</tr>';
        }

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(BB_INVENTORY, array('INVENTORY' => $report_table))));

    }

    function bb_delete_image(){

        global $dropbox_token;

        require_once 'class_dropbox.php';

        $dropboxObj = new Dropbox($dropbox_token);

        $data = $_POST;

        if ($data['picnum'] == 1){
            $cond = array('order_id' => $data['order_id'],'pic_1_file' => $data['filename']);
        }else{
            $cond = array('order_id' => $data['order_id'],'pic_2_file' => $data['filename']);
        }

        $po_received = $this->db_select_single('po_received', '*', $cond);

        if ($data['picnum'] == 1){
            $dropboxObj->delete($po_received['pic_1_file']);
            $dropboxObj->delete($po_received['pic_1_thumb_file']);
            $sql = 'UPDATE po_received SET pic_1_file = "", pic_1_url = "", pic_1_thumb_file = "", pic_1_thumb_url = "" WHERE received_id = '.$po_received['received_id'];
        }else{
            $dropboxObj->delete($po_received['pic_2_file']);
            $dropboxObj->delete($po_received['pic_2_thumb_file']);
            $sql = 'UPDATE po_received SET pic_2_file = "", pic_2_url = "", pic_2_thumb_file = "", pic_2_thumb_url = "" WHERE received_id = '.$po_received['received_id'];
        }

        $this->db_query($sql, 'update');

    }

    function keep_zeroes($var){
        if ($var === false){
            return false;
        }else{
            return true;
        }
    }

    function bb_detail($order_id){
		// global $buybackObj;
		// return $buybackObj->bb_detail($order_id);


        if ($_POST['submit']){
            $data = $_POST;

			$po_order = $this->db_select_single('po_orders', '*', array('order_id' => $order_id));

            if ($data['status_id'] == 3){
                if ($po_order['zoho_status'] != 'BB - 10. Payment Sent - Complete'){

                    global $zohoObj, $zoho_auth_tokens;

                    /* Bilal: Old code block comment out
                    $parameters = array(
                        'scope'     =>  'crmapi'
                        ,'selectColumns'    =>  'All'//columns to select
                        ,'fromIndex'        =>  1//start record
                        ,'toIndex'          =>  200//end record
                        ,'criteria'  =>  '(MTS Quote Number:'.$po_order['order_number'].')'//filter
                    );

                    //retrieve records for all users
                    foreach($zoho_auth_tokens as $row){
                        $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
                        $numberOfRecords = count($result->result->Invoices->row);
                        for ($i = 0; $i < $numberOfRecords; $i++) {
                            $zoho_id = (string)$result->result->Invoices->row[$i]->FL[0];
                            $authtoken = $row['authtoken'];
                        }
                    }

                    $zoho_data = array('Status' => 'BB - 10. Payment Sent - Complete','Final Buy Price' => $data['net_payout']);

                    $zohoObj->updateInvoice($authtoken,$zoho_id,$zoho_data);
                        *
                        */

                    /* Bilal Modifications */
                    $zoho_data = array('Status' => 'BB - 10. Payment Sent - Complete','Final_Buy_Price' => $data['net_payout']);
                    $zohoObj->update_record_admin_3($po_order['order_number'],$zoho_data);

                    $this->db_update('po_orders', 'order_id', $data['MTSInvoices'], array('date_received' => $this->format_date('db_date'),'zoho_status' => 'BB - 10. Payment Sent - Complete'));

                }
            }
			elseif ($data['status_id'] == 2) {
				if ($data['order_id'] && !$po_order['date_received']) {
					global $zohoObj, $zoho_auth_tokens;

					// Update zoho record
					$zohoObj->update_record_admin_2($po_order['order_number'],"BB - 5. Arrived - Initial Count Complete",$this->format_date('templ_date'));

					// Build value strings
					$dateReceived = $this->format_date('db_date');
					$orderId = $data['order_id'];
					$zohoStatus = mysql_real_escape_string('BB - 5. Arrived - Initial Count Complete');
					// Build query
					$sql = "UPDATE `po_orders` SET `date_received`='$dateReceived', `zoho_status`='$zohoStatus' WHERE `order_id`='$orderId';";
					$this->db_query($sql, 'update', true); // Perform update
				}

			}

			if ($data['imaging_notes'] != $po_order['imaging_notes']) {
				$imagingNotes = mysql_real_escape_string(trim($data['imaging_notes']));
				$sql = "UPDATE po_orders SET `imaging_notes`='$imagingNotes' WHERE `order_id`='$order_id';";
				$this->db_query($sql, 'update');
			}

			if ($data['imaging_complete'] == 'on') {
				$imagingComplete = true;
				if ($data['date_imaging_complete']) {
					$dateImagingComplete = $data['date_imaging_complete'];
				}
				else {
					$dateImagingComplete = date('Y-m-d');
				}

				$imagingCompleteExisting = (bool)$po_order['imaging_complete'];
				$dateImagingCompleteExisting = $po_order['date_imaging_complete'];
				$imagingCompleteEmailAlreadySent = (bool)$po_order['imaging_complete_email_sent'];

				$updateClauses = array();

				if ($imagingCompleteExisting != $imagingComplete) {
					$clause = "`imaging_complete`='$imagingComplete'";
					array_push($updateClauses, $clause);
				}
				if ($dateImagingCompleteExisting != $dateImagingComplete) {
					$clause = "`date_imaging_complete`='$dateImagingComplete'";
					array_push($updateClauses, $clause);
				}
				if (!$imagingCompleteEmailAlreadySent) {
					$po_order['imaging_complete'] = $imagingComplete;
					$po_order['date_imaging_complete'] = $dateImagingComplete;
					$emailSent = $this->sendImagingCompleteEmail($order_id);
				}

				if (count($updateClauses) > 0) {
					$updateClauseString = implode(", ", $updateClauses);
					$sql = "UPDATE `po_orders` SET $updateClauseString WHERE `order_id`='$order_id';";
					echo "<p>$sql</p>";
					$this->db_query($sql, 'update', true);
				}
			}
			else {
				// placeholder for if not complete. do nothing?
			}
			// exit;

			if ($data['payment_sent_date']) {
				$paymentSentDate = $this->format_date('db_date', strtotime($data['payment_sent_date']));
			}
			else {
				$paymentSentDate = null;
			}

            $orderdata = array(
                'status_id' => $data['status_id'],
                'expected_ship_date'    => $this->format_date('db_date',strtotime($data['expected_ship_date'])),
                'carrier_id'    => $data['carrier_id'],
                'pallets'   => $data['pallets'],
                'payment_sent_date' => $paymentSentDate,
                'notes' => $data['notes'],
                'firmware_password' => $data['firmware_password'],
				'firmware_lock_audit' => $data['firmware_lock_audit'],
				'payment_term' => $data['payment_term']
            );

            $this->db_update('po_orders', 'order_id', $data['order_id'], $orderdata);

			if (!$paymentSentDate) {
				$orderId = $data['order_id'];
				$sql = "UPDATE `po_orders` SET `payment_sent_date`=NULL WHERE `order_id`='$orderId';";
				$this->db_query($sql, 'update');
			}

            for ($i=0;$i<count($data['qty_ipad']);$i++){

                $rack_data = array(
                    'qty_ipad'  =>  $data['qty_ipad'][$i],
                    'qty_macbook'   =>  $data['qty_macbook'][$i],
                    'qty_macbook_pro'   =>  $data['qty_macbook_pro'][$i],
                    'qty_macbook_air'   =>  $data['qty_macbook_air'][$i],
                    'qty_imac'  =>  $data['qty_imac'][$i],
                    'qty_mac_mini'  =>  $data['qty_mac_mini'][$i],
                    'qty_other' =>  $data['qty_other'][$i]
                );

                $tmp_rack = array_filter($rack_data,'self::keep_zeroes');

                if (count($tmp_rack) > 0){

                    $po_received = $this->db_select_single('po_received', 'received_id', array('order_id' => $data['order_id'],'rack_no' => $i+1));

                    if ($po_received){
                        $this->db_update('po_received', 'received_id', $po_received['received_id'], $rack_data);
                    }else{
                        $rack_data['order_id'] = $data['order_id'];
                        $rack_data['rack_no'] = $i+1;
                        $this->db_insert('po_received', $rack_data);
                    }
                }
            }

            foreach ($data['qty_accessory'] as $k => $v){

                $accessory_data = array(
                    'quantity'  =>  $v,
                    'quantity_3rd'  => $data['qty_accessory_3rd'][$k],
                    'quantity_bad'  => $data['qty_accessory_bad'][$k],
                    'weight'   =>  $data['weight_accessory'][$k]
                    );

                $tmp_accessory = array_filter($accessory_data,'self::keep_zeroes');

                if (count($tmp_accessory) > 0){

                    $po_accessories_received = $this->db_select_single('po_accessories_received', 'accessories_received_id', array('order_id' => $data['order_id'],'deduction_id' => $k));

                    if ($po_accessories_received){
                        $this->db_update('po_accessories_received', 'order_id', $data['order_id'], $accessory_data,'deduction_id',$k);
                    }else{
                        $accessory_data['order_id'] = $data['order_id'];
                        $accessory_data['deduction_id'] = $k;
                        $this->db_insert('po_accessories_received', $accessory_data);
                    }
                }
            }
			header('Location: '. CONTROLLER . '?m=bb_detail&order_id=' . $order_id);
        }

        if (!$order_id){
            $order_id = $_POST['order_id'];
        }

        $po_order = $this->db_select_single('po_orders', '*', array('order_id' => $order_id));

        // $po_account = $this->db_select_single('po_accounts', '*', array('account_id' => $po_order['account_id']));

        $po_received = $this->db_select_multiple('po_received', '*', array('order_id' => $po_order['order_id']),'ORDER BY rack_no');

        //$po_items = $this->db_select_multiple('po_items', 'order_number, quantity', array('order_id' => $order_id),'ORDER BY order_number');

        $sql = 'SELECT DISTINCT poi.order_number, poi.quantity,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND asset LIKE  CONCAT(poi.order_number, "%")) AS received_quantity
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                WHERE poi.order_id = "'.$po_order['order_id'].'"
                ORDER BY poi.order_number';

        $po_items = $this->db_query($sql, 'select-multiple');

        $expected = '';

        foreach ($po_items as $po_item){
            $expected .= '<tr><td><strong>'.$po_item['order_number'].'</strong></td><td><strong>'.$po_item['quantity'].'</strong></td>';
            $expected .= '<td><strong>'.$po_item['order_number'].'</strong></td><td><strong>'.$po_item['received_quantity'].'</strong></td></tr>';
		}

		// Get expected skus
		$sql =
			"SELECT DISTINCT CONCAT(poi.order_number, '%') AS poNumber
			FROM po_items poi
			LEFT JOIN po_orders po ON po.order_id = poi.order_id
			WHERE po.order_number = '{$po_order['order_number']}';";

		$expected_skus = $this->db_query($sql, 'select-multiple');

		// Build expected sku search clause
		$skuSearchClause = '(';
		$i = 0;
		foreach ($expected_skus as $sku) {
			if ($i) {
				$skuSearchClause .= " AND ";
			}
			$num = $sku['poNumber'];
			$skuSearchClause .= "asset NOT LIKE '$num'";
			$i++;
		}
		$skuSearchClause .= ')';
		$sql =
			"SELECT DISTINCT dso.asset, COUNT(dso.oID) AS quantity
			FROM ds_orders dso
			WHERE dso.poNumber = '{$po_order['order_number']}'
			AND dso.asset != ''
			AND $skuSearchClause
			GROUP BY dso.asset;";


        // $sql = 'SELECT DISTINCT dso.asset, COUNT(dso.oID) AS quantity
        //     FROM ds_orders dso
        //     WHERE dso.poNumber = "'.$po_order['order_number'].'"
        //     AND asset NOT IN
        //     (SELECT DISTINCT poi.order_number
        //     FROM po_items poi
        //     LEFT JOIN po_orders po ON po.order_id = poi.order_id
        //     WHERE po.order_number = "'.$po_order['order_number'].'")
        //     AND dso.asset != ""
        //     GROUP BY dso.asset';

        $unexpected_items = $this->db_query($sql, 'select-multiple');

		foreach ($unexpected_items as $item) {
			$asset = $item['asset'];
			$realAsset = $asset;
			if (preg_match('/(-\d{1,3}\/\d{2,4})/', $asset)) { // Look for special skus
				$dividerPosition = strpos($asset, '-');
				$realAsset = substr($asset, 0, $dividerPosition);
			}
			$item['asset'] = $realAsset;
		}

        if ($unexpected_items){

            $unexpected = '<tr><td colspan="2"></td><td colspan="2"><strong>Unexpected Devices</strong></td></tr>';

            foreach ($unexpected_items as $item){
                $unexpected .= '<tr><td colspan="2"></td><td><strong>'.$item['asset'].'</strong></td><td><strong>'.$item['quantity'].'</strong></td></tr>';
            }

            $unexpected .= '<tr>
                            <td colspan="2"></td><td><input type="submit" id="submit_action" name="submit_action" value="Add" /></td>
                        </tr>';

        }

        $devices_received = 0;

        $racktable = '';

        if ($po_received){
			if ($_GET['debug'] == 'yes') {
				echo "<pre>";
				print_r($po_received);
				echo "</pre>";
			}
            foreach ($po_received as $rack){

                $picurl[$rack['pic_1_thumb_url']] = $rack['pic_1_url'];
                $picurl[$rack['pic_2_thumb_url']] = $rack['pic_2_url'];

                $devices_received += (int)($rack['qty_ipad']+$rack['qty_macbook']+$rack['qty_macbook_pro']+$rack['qty_macbook_air']+$rack['qty_imac']+$rack['qty_mac_mini']+$rack['qty_other']);

                $racktable .= '<tr>
                    <td><strong>Rack '.$rack['rack_no'].'</strong></td>
                    <td><input type="tel" name="qty_ipad[]" id="qty_ipad_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_ipad']>0?$rack['qty_ipad']:'').'" /></td>
                    <td><input type="tel" name="qty_macbook[]" id="qty_macbook_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_macbook']>0?$rack['qty_macbook']:'').'" /></td>
                    <td><input type="tel" name="qty_macbook_pro[]" id="qty_macbook_pro_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_macbook_pro']>0?$rack['qty_macbook_pro']:'').'" /></td>
                    <td><input type="tel" name="qty_macbook_air[]" id="qty_macbook_air_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_macbook_air']>0?$rack['qty_macbook_air']:'').'" /></td>
                    <td><input type="tel" name="qty_imac[]" id="qty_imac_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_imac']>0?$rack['qty_imac']:'').'" /></td>
                    <td><input type="tel" name="qty_mac_mini[]" id="qty_mac_mini_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_mac_mini']>0?$rack['qty_mac_mini']:'').'" /></td>
                    <td><input type="tel" name="qty_other[]" id="qty_other_'.$rack['rack_no'].'" style="width:40px;" value="'.($rack['qty_other']>0?$rack['qty_other']:'').'" /></td>';

                if ($rack['pic_1_thumb_url']){
                    $racktable .= '<td><img id="pic1_'.$rack['rack_no'].'" src="'.$rack['pic_1_thumb_url'].'" width="24" height="32" onclick="showBig(this);" /></td><td></td>';
                    $racktable .= '<td><input type="button" value="Delete" onclick="deleteImage(\''.$rack['pic_1_file'].'\',\''.$rack['pic_1_thumb_file'].'\',\''."pic1_".$rack['rack_no'].'\',1)" /></td>';
                }else{
                    $racktable .= '<td><input type="button" id="rack'.$rack['rack_no'].'_pic1" value="Upload" racknum="'.$rack['rack_no'].'" picnum="1" onclick="getFile(this)" /><input type="file" id="uploadrack_'.$rack['rack_no'].'_pic_1" name="uploadrack_'.$rack['rack_no'].'_pic_1"  racknum="'.$rack['rack_no'].'" picnum="1" style="display: none;" accept="image/*" capture="camera" onchange="uploadRack(this);" /></td><td id="tick_rack_'.$rack['rack_no'].'_pic_1">&nbsp;</td>';
                    $racktable .= '<td></td>';
                }

                if ($rack['pic_2_thumb_url']){
                    $racktable .= '<td><img id="pic2_'.$rack['rack_no'].'" src="'.$rack['pic_2_thumb_url'].'" width="24" height="32" onclick="showBig(this);" /></td><td></td>';
                    $racktable .= '<td><input type="button" value="Delete" onclick="deleteImage(\''.$rack['pic_2_file'].'\',\''.$rack['pic_2_thumb_file'].'\',\''."pic2_".$rack['rack_no'].'\',2)" /></td>';
                }else{
                    $racktable .= '<td><input type="button" id="rack'.$rack['rack_no'].'_pic2" value="Upload" racknum="'.$rack['rack_no'].'" picnum="2" onclick="getFile(this)" /><input type="file" id="uploadrack_'.$rack['rack_no'].'_pic_2" name="uploadrack_'.$rack['rack_no'].'_pic_2"  racknum="'.$rack['rack_no'].'" picnum="2" style="display: none;" accept="image/*" capture="camera" onchange="uploadRack(this);" /></td><td id="tick_rack_'.$rack['rack_no'].'_pic_2">&nbsp;</td>';
                    $racktable .= '<td></td>';
                }

                $racktable .= '<td><input type="button" id="rack'.$rack['rack_no'].'"_print" value="Print" racknum="'.$rack['rack_no'].'"" onclick="printTag(this)" /></td></tr>';

            }
        }else{
            for ($i=0;$i<8;$i++){

                $racktable .= '<tr>
                    <td><strong>Rack '.($i+1).'</strong></td>
                    <td><input type="tel" name="qty_ipad[]" id="qty_ipad_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_macbook[]" id="qty_macbook_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_macbook_pro[]" id="qty_macbook_pro_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_macbook_air[]" id="qty_macbook_air_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_imac[]" id="qty_imac_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_mac_mini[]" id="qty_mac_mini_'.($i+1).'" style="width:40px;" /></td>
                    <td><input type="tel" name="qty_other[]" id="qty_other_'.($i+1).'" style="width:40px;" /></td>';

                $racktable .= '<td><input type="button" id="rack'.($i+1).'_pic1" value="Upload" racknum="'.($i+1).'" picnum="2" onclick="getFile(this)" /><input type="file" id="uploadrack_'.($i+1).'_pic_1" name="uploadrack_'.($i+1).'_pic_1"  racknum="'.($i+1).'" picnum="2" style="display: none;" accept="image/*" capture="camera" onchange="uploadRack(this);" /></td><td id="tick_rack_'.($i+1).'_pic_1">&nbsp;</td>';

                $racktable .= '<td><input type="button" id="rack'.($i+1).'_pic2" value="Upload" racknum="'.($i+1).'" picnum="2" onclick="getFile(this)" /><input type="file" id="uploadrack_'.($i+1).'_pic_2" name="uploadrack_'.($i+1).'_pic_2"  racknum="'.($i+1).'" picnum="2" style="display: none;" accept="image/*" capture="camera" onchange="uploadRack(this);" /></td><td id="tick_rack_'.($i+1).'_pic_2">&nbsp;</td>';

                $racktable .= '<td><input type="button" id="rack'.($i+1).'"_print" value="Print" racknum="'.($i+1).'"" onclick="printTag(this)" /></td></tr>';

            }

        }

        $po_accessories_received = $this->db_select_multiple('po_accessories_received', 'deduction_id, quantity, quantity_3rd, quantity_bad, pic_thumb_url, pic_url', array('order_id' => $order_id));

        //get deductions
        $po_deductions_lookups = $this->db_select_multiple('po_deductions_lookup', '*', array('active' => 1,'accessory' => 1), 'order by sequence');

        $deduction_count = count($po_deductions_lookups);

        $row_count = round($deduction_count/2);

        $counter = 0;

        $deduction_table = '<table><tr><td colspan="3"><strong>Accessory Details</strong></td></tr><tr><td><table>';

        $deduction_table .= "<tr><td></td><td><strong>Received</strong></td><td><strong>3rd Party</strong></td><td><strong>Bad</strong></td></tr>";

        foreach ($po_deductions_lookups as $lookup){

            $counter++;

            $valuestr = '';
            $value_badstr = '';
            $value_3rdstr = '';
            $thumb_url = false;
            $url = false;

            foreach ($po_accessories_received as $accessory){
                if ($accessory['deduction_id'] == $lookup['deduction_id']){
                    $valuestr = ' value="'.$accessory['quantity'].'"';
                    $value_badstr = ' value="'.$accessory['quantity_bad'].'"';
                    $value_3rdstr = ' value="'.$accessory['quantity_3rd'].'"';
                    if ($accessory['pic_thumb_url']){
                        $thumb_url = $accessory['pic_thumb_url'];
                        $url = $accessory['pic_url'];
                        $picurl[$thumb_url] = $url;
                    }
                }
            }


            $deduction_table .= '<tr><td>'.$lookup['deduction_name'].'</td><td><input type="tel" deduction_id="'
                    .$lookup['deduction_id'].'" name="qty_accessory['.$lookup['deduction_id'].']" id="qty_accessory_'.$lookup['deduction_id']
                    .'" style="width:40px;" maxlength="6"'.$valuestr.' /></td><td><input type="tel" deduction_id="'
                    .$lookup['deduction_id'].'" name="qty_accessory_3rd['.$lookup['deduction_id'].']" id="qty_accessory_3rd_'.$lookup['deduction_id']
                    .'" style="width:40px;" maxlength="6"'.$value_3rdstr.' /></td><td><input type="tel" deduction_id="'.$lookup['deduction_id']
                    .'" name="qty_accessory_bad['.$lookup['deduction_id'].']" id="qty_accessory_bad_'.$lookup['deduction_id']
                    .'" style="width:40px;" maxlength="6"'.$value_badstr.' /></td>';

            if (!$thumb_url){
                $deduction_table .=  '<td><input type="button" id="accessory_'.$lookup['deduction_id'].'" deduction_id="'.$lookup['deduction_id'].'" value="Upload" onclick="getAccessoryFile(this)" /><input type="file" id="upload_accessory_'.$lookup['deduction_id'].'" deduction_id="'.$lookup['deduction_id'].'" style="display: none;" accept="image/*" capture="camera" onchange="uploadAccessory(this);" /></td>';
            }else{

                $deduction_table .= '<td><img src="'.$thumb_url.'" width="24" height="32"  onclick="showBig(this);"/></td>';
            }

            $deduction_table .= '<td id="tick_accessory_'.$lookup['deduction_id'].'">&nbsp;</td></tr>';

            if ($counter == $row_count){

                $deduction_table .= '</table></td><td><table><tr><td></td><td><strong>Received</strong></td><td><strong>3rd Party</strong></td><td><strong>Bad</strong></td></tr>';

            }

        }

        $picjson = json_encode($picurl);

        if ($counter < $row_count*2){
            $deduction_table .= '<tr><td colspan="2">&nbsp;</td></tr>';
        }

        $deduction_table .= '</td></tr></table></td></tr></table>';

        if ($po_received){
            $rack_rows = count($po_received);
        }else{
            $rack_rows = 8;
        }

        $po_status = $this->db_select_multiple('po_status', '*');

        $status_option = '';

        foreach ($po_status as $status){
            if ($status['status_id'] == $po_order['status_id']){
                $status_option .= '<option value="'.$status['status_id'].'" selected>'.$status['status_description'].'</option>';
            }else{
                $status_option .= '<option value="'.$status['status_id'].'">'.$status['status_description'].'</option>';
            }
		}

        $sql = "SELECT poo.order_id, poo.order_number, poa.account_name, poo.notes, DATE_FORMAT(poo.date_received,'%m/%d/%Y') AS date_received,
            SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other) AS devices_received,
            (SELECT SUM(quantity) FROM po_accessories_received WHERE order_id = poo.order_id) AS accessories_received,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus NOT IN('Refurb - Imaged', 'Void')) AS devices_audited,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus = 'Refurb - Imaged' AND is_ipad = 1) AS ipads_imaged,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus = 'Refurb - Imaged' AND (is_ipad = 0 OR is_ipad IS NULL)) AS others_imaged,
            (SELECT COUNT(oID) FROM ds_orders WHERE poNumber = poo.order_number AND cStatus NOT IN('Refurb - Imaged', 'Void'))/(SUM(por.qty_ipad) + SUM(por.qty_macbook) + SUM(por.qty_macbook_pro) + SUM(por.qty_macbook_air) + SUM(por.qty_imac) + SUM(por.qty_mac_mini) + SUM(por.qty_other)) AS progress
            FROM po_orders poo
            LEFT JOIN po_accounts poa ON poo.account_id = poa.account_id
            LEFT JOIN po_received por ON por.order_id = poo.order_id
            WHERE poo.order_id = $order_id
            GROUP BY poo.order_id
            ORDER BY poo.date_received DESC;";

		$bbData = $this->db_query($sql, 'select-single');

		// echo print_r($bbData);

        $po_carriers = $this->db_select_multiple('po_carriers', '*');

        $carrier_option = '';

        foreach ($po_carriers as $carrier){
            if ($carrier['carrier_id'] == $po_order['carrier_id']){
                $carrier_option .= '<option value="'.$carrier['carrier_id'].'" selected>'.$carrier['carrier_name'].'</option>';
            }else{
                $carrier_option .= '<option value="'.$carrier['carrier_id'].'">'.$carrier['carrier_name'].'</option>';
            }
        }

        // $accessories_received = $this->db_select_single('po_accessories_received', 'SUM(quantity) AS total',array('order_id' => $order_id));


        // $ipads_imaged = $this->db_select_single('ds_orders', 'COUNT(oID) AS total', array('poNumber' => $po_order['order_number'],'cStatus' => 'Refurb - Imaged'));

        // $sql = "SELECT COUNT(oID) AS total FROM ds_orders WHERE cStatus NOT IN('Refurb - Imaged', 'Void') AND poNumber = '".$po_order['order_number']."'";

        // $devices_audited = $this->db_query($sql, 'select-single');

		//$orders_complete = $this->db_select_single('ds_orders', 'COUNT(oID) AS total', array('poNumber' => $po_order['order_number']));


		if ($bbData['devices_audited'] >= $bbData['devices_received'] && $bbData['devices_received'] > 0) {
			$sql = 'SELECT MAX(DATE(dol.`time`)) AS max_date FROM ds_order_logs dol
				LEFT JOIN ds_orders dso ON dso.oNum = dol.oNum
				WHERE dso.poNumber = "'.$po_order['order_number'].'" AND dol.details LIKE "%Audited%"';

			$audit_complete = $this->db_query($sql, 'select-single');
			$audit_date = $this->format_date('templ_date', strtotime($audit_complete['max_date']));
		} else {
			$audit_date = '';
		}

        if (strtotime($audit_complete['max_date']) && strtotime($po_order['date_received'])){
            $days_to_audit = round((strtotime($audit_complete['max_date']) - strtotime($po_order['date_received']))/(60*60*24));
        }else{
            $days_to_audit = '';
        }

        if ($po_order['date_received'] && $po_order['payment_sent_date']){
            $days_to_payment = round((strtotime($po_order['payment_sent_date'])-strtotime($po_order['date_received']))/(60*60*24));
        }else{
            $days_to_payment = '';
        }

        $sql = 'SELECT "mdm_lock" AS lock_type, COUNT(dso.mdm_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND dso.mdm_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "activation_lock" AS lock_type, COUNT(dso.activation_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND dso.activation_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "audit_mdm_lock" AS lock_type, COUNT(dso.audit_mdm_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND dso.audit_mdm_lock = 1 AND pod.deduction_id = 12
            UNION
            SELECT "audit_activation_lock" AS lock_type, COUNT(dso.audit_activation_lock) AS total
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_deductions pod ON pod.order_id = poo.order_id
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND dso.audit_activation_lock = 1 AND pod.deduction_id = 12';

        $locks = $this->db_query($sql, 'select-multiple');

        $mdm_lock = 0;
        $activation_lock = 0;
        $audit_mdm_lock = 0;
        $audit_activation_lock = 0;

        foreach ($locks as $lock){
            if ($lock['lock_type'] == 'mdm_lock'){
                $mdm_lock = $lock['total'];
            }
            if ($lock['lock_type'] == 'activation_lock'){
                $activation_lock = $lock['total'];
            }
            if ($lock['lock_type'] == 'audit_mdm_lock'){
                $audit_mdm_lock = $lock['total'];
            }
            if ($lock['lock_type'] == 'audit_activation_lock'){
                $audit_activation_lock = $lock['total'];
            }
        }


        $sql = 'SELECT dso.asset, dso.grade_at_audit, ml.machine_description, COUNT(dso.grade_at_audit) AS machine_count,
            (SELECT
            CASE
                WHEN dso.grade_at_audit = "A" THEN poi.price_a
                WHEN dso.grade_at_audit = "B" THEN poi.price_b
                WHEN dso.grade_at_audit = "C" THEN poi.price_c
                WHEN dso.grade_at_audit LIKE "D%" THEN poi.price_d
                WHEN dso.grade_at_audit = "F" THEN poi.price_f
                ELSE NULL
            END
            ) AS price,
            (SELECT
            CASE
                WHEN dso.grade_at_audit = "A" THEN poi.price_a
                WHEN dso.grade_at_audit = "B" THEN poi.price_b
                WHEN dso.grade_at_audit = "C" THEN poi.price_c
                WHEN dso.grade_at_audit LIKE "D%" THEN poi.price_d
                WHEN dso.grade_at_audit = "F" THEN poi.price_f
                ELSE NULL
            END
            ) * COUNT(dso.grade_at_audit) AS total
            FROM ds_orders dso
            LEFT JOIN po_items poi ON dso.asset = poi.order_number
            LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND poi.order_id = '.$order_id.'
            GROUP BY dso.asset, dso.grade_at_audit, ml.machine_description';


        $order_summary = $this->db_query($sql, 'select-multiple');

        $machine_count = array();

        //$total = 0;

        foreach ($order_summary as $summary){
            $sql = 'SELECT DISTINCT pod.price, pod.deduction_id
                    FROM po_deductions pod
                    LEFT JOIN machine_order_number_accessories mona ON mona.deduction_id = pod.deduction_id
                    LEFT JOIN machine_order_number mon ON mon.order_number_id = mona.order_number_id
                    WHERE pod.order_id = '.$order_id.' AND mon.order_number = "'.$summary['asset'].'"';

            $accessory_price = 0;

            $accessory_prices = $this->db_query($sql, 'select-multiple');

            foreach ($accessory_prices as $price){
                $accessory_price = $accessory_price + (float)$price['price'];
            }

            //echo $summary['machine_count'].' '.$accessory_price.' '.$summary['price']."<br />";

            if ($summary['grade'] != 'F' && $accessory_price < $summary['price']){

                $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id', array('order_number' => $summary['asset']));

                $machine_count[$machine_order_number['order_number_id']]['count'] = $machine_count[$machine_order_number['order_number_id']]['count'] + $summary['machine_count'];
            }else{
                $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id', array('order_number' => $summary['asset']));

                $machine_count[$machine_order_number['order_number_id']]['count'] = $machine_count[$machine_order_number['order_number_id']]['count'] + 0;
            }

            $total = $total + (float)$summary['total'];

        }

        // $sql = 'SELECT poi.order_number, poi.price_a AS price, ml.machine_description, "A" AS grade,
        //         (SELECT COUNT(oID)
        //         FROM ds_orders
        //         WHERE poNumber = poo.order_number AND asset = poi.order_number AND grade_at_audit = "A") AS received
        //         FROM po_items poi
        //         LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
        //         LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //         WHERE poi.order_id = "'.$order_id.'"
        //         UNION
        //         SELECT poi.order_number, poi.price_b AS price, ml.machine_description, "B" AS grade,
        //         (SELECT COUNT(oID)
        //         FROM ds_orders
        //         WHERE poNumber = poo.order_number AND asset = poi.order_number AND grade_at_audit = "B") AS received
        //         FROM po_items poi
        //         LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
        //         LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //         WHERE poi.order_id = "'.$order_id.'"
        //         UNION
        //         SELECT poi.order_number, poi.price_c AS price, ml.machine_description, "C" AS grade,
        //         (SELECT COUNT(oID)
        //         FROM ds_orders
        //         WHERE poNumber = poo.order_number AND asset = poi.order_number AND grade_at_audit = "C") AS received
        //         FROM po_items poi
        //         LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
        //         LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //         WHERE poi.order_id = "'.$order_id.'"
        //         UNION
        //         SELECT poi.order_number, poi.price_d AS price, ml.machine_description, "D" AS grade,
        //         (SELECT COUNT(oID)
        //         FROM ds_orders
        //         WHERE poNumber = poo.order_number AND asset = poi.order_number AND grade_at_audit LIKE "%D%") AS received
        //         FROM po_items poi
        //         LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
        //         LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //         WHERE poi.order_id = "'.$order_id.'"
        //         UNION
        //         SELECT poi.order_number, poi.price_f AS price, ml.machine_description, "F" AS grade,
        //         (SELECT COUNT(oID)
        //         FROM ds_orders
        //         WHERE poNumber = poo.order_number AND asset = poi.order_number AND grade_at_audit = "F") AS received
        //         FROM po_items poi
        //         LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
        //         LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //         WHERE poi.order_id = "'.$order_id.'"
		// 		ORDER BY order_number, grade';

		$sql =
			"SELECT poi.order_number, poi.price_a AS price, ml.machine_description, 'A' AS grade,
			(SELECT COUNT(oID)
			FROM ds_orders
			WHERE poNumber = poo.order_number AND asset LIKE CONCAT(poi.order_number, '%') AND grade_at_audit = 'A') AS received
			FROM po_items poi
			LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
			LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
			WHERE poi.order_id = $order_id
			UNION
			SELECT poi.order_number, poi.price_b AS price, ml.machine_description, 'B' AS grade,
			(SELECT COUNT(oID)
			FROM ds_orders
			WHERE poNumber = poo.order_number AND asset LIKE CONCAT(poi.order_number, '%') AND grade_at_audit = 'B') AS received
			FROM po_items poi
			LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
			LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
			WHERE poi.order_id = $order_id
			UNION
			SELECT poi.order_number, poi.price_c AS price, ml.machine_description, 'C' AS grade,
			(SELECT COUNT(oID)
			FROM ds_orders
			WHERE poNumber = poo.order_number AND asset LIKE CONCAT(poi.order_number, '%') AND grade_at_audit = 'C') AS received
			FROM po_items poi
			LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
			LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
			WHERE poi.order_id = $order_id
			UNION
			SELECT poi.order_number, poi.price_d AS price, ml.machine_description, 'D' AS grade,
			(SELECT COUNT(oID)
			FROM ds_orders
			WHERE poNumber = poo.order_number AND asset LIKE CONCAT(poi.order_number, '%') AND grade_at_audit LIKE '%D%') AS received
			FROM po_items poi
			LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
			LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
			WHERE poi.order_id = $order_id
			UNION
			SELECT poi.order_number, poi.price_f AS price, ml.machine_description, 'F' AS grade,
			(SELECT COUNT(oID)
			FROM ds_orders
			WHERE poNumber = poo.order_number AND asset LIKE CONCAT(poi.order_number, '%') AND grade_at_audit = 'F') AS received
			FROM po_items poi
			LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
			LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
			WHERE poi.order_id = $order_id
			ORDER BY order_number, grade;";

        $order_overview = $this->db_query($sql, 'select-multiple');

        $total = 0;

        foreach ($order_overview as $overview_line){
            if ($overview_line['received'] > 0){
                $total += ($overview_line['price']*$overview_line['received']);
            }
        }

        $deduction_array = array();

        //Build deduction array
        foreach ($machine_count as $k => $v){

            $sql = 'SELECT DISTINCT mona.deduction_id, pd.price, pdl.deduction_name, pdl.deduction_size, pdl.deduction_type,
                (SELECT quantity FROM po_accessories_received WHERE order_id = '.$order_id.' AND deduction_id = mona.deduction_id) AS quantity,
                (SELECT quantity_bad FROM po_accessories_received WHERE order_id = '.$order_id.' AND deduction_id = mona.deduction_id) AS quantity_bad
                FROM machine_order_number mon
                LEFT JOIN machine_order_number_accessories mona ON mona.order_number_id = mon.order_number_id
                LEFT JOIN po_deductions pd ON pd.deduction_id = mona.deduction_id
                LEFT JOIN po_deductions_lookup pdl ON pdl.deduction_id = pd.deduction_id
                WHERE mon.order_number_id = '.$k.' AND pd.order_id = '.$order_id;

            $deductions = $this->db_query($sql, 'select-multiple');

            foreach ($deductions as $deduction){
                $deduction_array[$deduction['deduction_id']]['deduction_name'] = $deduction['deduction_name'];
                $deduction_array[$deduction['deduction_id']]['deduction_type'] = $deduction['deduction_type'];
                $deduction_array[$deduction['deduction_id']]['deduction_size'] = $deduction['deduction_size'];
                $deduction_array[$deduction['deduction_id']]['price'] = $deduction['price'];
                $deduction_array[$deduction['deduction_id']]['quantity_received'] = $deduction['quantity'];
                $deduction_array[$deduction['deduction_id']]['quantity_bad'] = $deduction['quantity_bad'];
                $deduction_array[$deduction['deduction_id']]['quantity_expected'] += $v['count'];
            }

        }

        $adapter_array = array();

        foreach ($deduction_array as $k => $v){
            if (($v['quantity_expected'] < ($v['quantity_received']+$v['quantity_bad'])) && $v['deduction_type'] == 'adapter'){
                $adapter_array[$k]['quantity'] = $v['quantity_received']-$v['quantity_bad']-$v['quantity_expected'];
                $adapter_array[$k]['size'] = $v['deduction_size'];
            }
        }

        $magsafe_array = array();

        foreach ($deduction_array as $k => $v){
            if (($v['quantity_expected'] < ($v['quantity_received']+$v['quantity_bad'])) && $v['deduction_type'] == 'magsafe'){
                $magsafe_array[$k]['quantity'] = $v['quantity_received']-$v['quantity_bad']-$v['quantity_expected'];
                $magsafe_array[$k]['size'] = $v['deduction_size'];
            }
        }

        $adapter_count = 0;

        foreach ($adapter_array as $k => $v){
            $adapter_count = $v['quantity'];
            foreach ($deduction_array as $k1 => $v1){
                if ($v1['deduction_type'] == 'adapter' && $v1['quantity_received'] < $v1['quantity_expected'] && $v1['deduction_size'] < $v['size'] && $adapter_count > 0){
                    if ($v1['quantity_bad'] > 0){
                        $deduction_array[$k1]['quantity_bad'] = $v1['quantity_bad']-$v['quantity'];
                        $adapter_count = 0;
                        if ($deduction_array[$k1]['quantity_bad'] < 0){
                            $adapter_count = 0 - $deduction_array[$k1]['quantity_bad'];
                        }
                    }else{
                        $deduction_array[$k1]['quantity_received'] += $v['quantity'];
                        $adapter_count = 0;
                        if ($deduction_array[$k1]['quantity_received'] > $deduction_array[$k1]['quantity_expected']){
                            $adapter_count = $deduction_array[$k1]['quantity_expected'] - $deduction_array[$k1]['quantity_expected'];
                            $deduction_array[$k1]['quantity_received'] = $deduction_array[$k1]['quantity_expected'];
                        }
                    }
                }
                $adapter_count = 0;
            }
        }

        $magsafe_count = 0;

        foreach ($magsafe_array as $k => $v){
            $magsafe_count = $v['quantity'];
            foreach ($deduction_array as $k1 => $v1){
                if ($v1['deduction_type'] == 'magsafe' && $v1['quantity_received'] < $v1['quantity_expected'] && $v1['deduction_size'] < $v['size'] && $magsafe_count > 0){
                    if ($v1['quantity_bad'] > 0){
                        $deduction_array[$k1]['quantity_bad'] = $v1['quantity_bad']-$v['quantity'];
                        $magsafe_count = 0;
                        if ($deduction_array[$k1]['quantity_bad'] < 0){
                            $magsafe_count = 0 - $deduction_array[$k1]['quantity_bad'];
                        }
                    }else{
                        $deduction_array[$k1]['quantity_received'] += $v['quantity'];
                        $magsafe_count = 0;
                        if ($deduction_array[$k1]['quantity_received'] > $deduction_array[$k1]['quantity_expected']){
                            $magsafe_count = $deduction_array[$k1]['quantity_expected'] - $deduction_array[$k1]['quantity_expected'];
                            $deduction_array[$k1]['quantity_received'] = $deduction_array[$k1]['quantity_expected'];
                        }
                    }
                }
                $magsafe_count = 0;
            }
        }

        $deduction_value = 0;

        /*foreach ($deduction_array as $deduction_item){
            $deduction_value += ($deduction_item['quantity_expected']-($deduction_item['quantity_received']-$deduction_item['quantity_bad']))*$deduction_item['price'];
        }

        if ($deduction_value < 0){
            $deduction_value = 0;
        }*/

        /*$sql = 'SELECT COUNT(dso.oID) AS order_count
            FROM ds_orders dso
            WHERE dso.poNumber = "'.$po_order['order_number'].'" AND (dso.mdm_lock = 1 OR dso.activation_lock = 1)';

        $locks = $this->db_query($sql, 'select-single');

        if ($locks['order_count'] > 0){

            $lock_price = $this->db_select_single('po_deductions', 'price', array('order_id' => $order_id,'deduction_id' => 12));
            //$deduction_value += $locks['order_count']*$lock_price['price'];
        }*/

        foreach ($deduction_array as $deduction_item){
            if ($deduction_item['quantity_expected']-$deduction_item['quantity_received'] > 0){
                $deduction_value += ($deduction_item['quantity_expected']-$deduction_item['quantity_received'])*$deduction_item['price'];
            }
            if ($deduction_item['quantity_bad'] > 0){
                if ($deduction_item['quantity_received'] <= $deduction_item['quantity_expected']){
                    $deduction_value += $deduction_item['quantity_bad']*$deduction_item['price'];
                }else{
                    $deduction_value += ($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected']))*$deduction_item['price'];

                }
            }
        }

        if ($locks['order_count'] > 0){
            $deduction_value += $locks['order_count']*$lock_price['price'];
        }

        $engraved = $this->db_select_single('ds_orders', 'COUNT(oID) AS engraved', array('poNumber' => $po_order['order_number'],'marking' => 1));

        if ($engraved['engraved'] > 0){
            $engraved_price = $this->db_select_single('po_deductions', 'price',array('deduction_id' => 11,'order_id' => $order_id));
            $deduction_value += $engraved['engraved']*$engraved_price['price'];
        }

        $firmware_locked_audit = $this->db_select_single('po_orders', 'firmware_lock_audit', array('order_id' => $order_id));

        if ($firmware_locked_audit['firmware_lock_audit'] > 0){
            $deduction_value += $firmware_locked_audit['firmware_lock_audit']*2;
        }

        /*foreach ($machine_count as $k => $v){

            $sql = 'SELECT DISTINCT mona.deduction_id, pd.price, pdl.deduction_name,
                (SELECT quantity FROM po_accessories_received WHERE order_id = '.$order_id.' AND deduction_id = mona.deduction_id) AS quantity,
                (SELECT quantity_bad FROM po_accessories_received WHERE order_id = '.$order_id.' AND deduction_id = mona.deduction_id) AS quantity_bad
                FROM machine_order_number mon
                LEFT JOIN machine_order_number_accessories mona ON mona.order_number_id = mon.order_number_id
                LEFT JOIN po_deductions pd ON pd.deduction_id = mona.deduction_id
                LEFT JOIN po_deductions_lookup pdl ON pdl.deduction_id = pd.deduction_id
                WHERE mon.order_number_id = '.$k.' AND pd.order_id = '.$order_id;

            //echo $sql.'<br />';

            $deductions = $this->db_query($sql, 'select-multiple');

            foreach ($deductions as $deduction){
                $deduction_array[$deduction['deduction_id']]['deduction_name'] = $deduction['deduction_name'];
                $deduction_array[$deduction['deduction_id']]['price'] = $deduction['price'];
                $deduction_array[$deduction['deduction_id']]['quantity_received'] = $deduction['quantity'];
                $deduction_array[$deduction['deduction_id']]['quantity_bad'] = $deduction['quantity_bad'];
                $deduction_array[$deduction['deduction_id']]['quantity_expected'] += $v['count'];
            }

        }


        $engraved = $this->db_select_single('ds_orders', 'COUNT(oID) AS engraved', array('poNumber' => $po_order['order_number'],'marking' => 1));

        $deduction_value = 0;

        foreach ($deduction_array as $deduction_item){
            $deduction_value += ($deduction_item['quantity_expected']-($deduction_item['quantity_received']-$deduction_item['quantity_bad']))*$deduction_item['price'];
        }

        if ($engraved['engraved'] > 0){
            $engraved_price = $this->db_select_single('po_deductions', 'price',array('deduction_id' => 11,'order_id' => $order_id));
            $deduction_value += $engraved['engraved']*$engraved_price['price'];
        }

        if ($po_order['firmware_lock_audit'] > 0){
            $deduction_value += $po_order['firmware_lock_audit']*2;
        }

        if ($deduction_value < 0){
            $deduction_value = 0;
        }*/

		if ($po_order['payment_term'] === 0 || $po_order['payment_term'] == '0') {
			$paymentTerm = 0;
		} elseif (!$po_order['payment_term']) {
			$paymentTerm = 60;
		} else {
			$paymentTerm = (int)$po_order['payment_term'];
		}
		if ($po_order['date_received']) {
			$dueDate = strtotime($po_order['date_received'])+($paymentTerm*60*60*24);
			$paymentDue = $this->format_date('templ_date', $dueDate);
			if (!$po_order['payment_sent_date']) {
				$daysRemaining = round(($dueDate-time()) /(60*60*24));
				if ($daysRemaining >= 0) {
					$paymentDue .= " ($daysRemaining days remaining)";
				}
				else {
					$daysRemaining = abs($daysRemaining);
					$paymentDue .= " ($daysRemaining days overdue)";
				}
			}
			$dateReceived = $this->format_date('templ_date', strtotime($po_order['date_received']));
		} else {
			$paymentDue = '';
			$dateReceived = '';
		}


		$sql = "SELECT poa.* FROM po_orders AS po LEFT JOIN po_accounts AS poa ON po.account_id = poa.account_id WHERE po.order_id = '$order_id';";
		$result = $this->db_query($sql, 'select-single', true);
		if ($result['order_account_id']) {
			$orderAccountId = $result['order_account_id'];
			$orderAccount = Account::fetch($orderAccountId);
		}

		$contactName = $result['first_name'] . " " . $result['last_name'];
		$contactEmail = $result['email'];
		$contactPhone = $result['phone'];

		// Handle addresses
		if ($orderAccount) {
			$shippingName = $orderAccount->getName();
			$billingName = $orderAccount->getName();

			$hasFullBillingAddress = $orderAccount->getHasFullBillingAddress();
			$hasFullShippingAddress = $orderAccount->getHasFullShippingAddress();

			if ($hasFullBillingAddress && $hasFullShippingAddress) {
				$billingStreet = $orderAccount->getBillingStreet();
				$billingCity = $orderAccount->getBillingCity();
				$billingState = $orderAccount->getBillingState();
				$billingCode = $orderAccount->getBillingCode();

				$shippingStreet = $orderAccount->getShippingStreet();
				$shippingCity = $orderAccount->getShippingCity();
				$shippingState = $orderAccount->getShippingState();
				$shippingCode = $orderAccount->getShippingCode();
			}
			else if ($hasFullBillingAddress) {
				$billingStreet = $orderAccount->getBillingStreet();
				$billingCity = $orderAccount->getBillingCity();
				$billingState = $orderAccount->getBillingState();
				$billingCode = $orderAccount->getBillingCode();

				$shippingStreet = $orderAccount->getBillingStreet();
				$shippingCity = $orderAccount->getBillingCity();
				$shippingState = $orderAccount->getBillingState();
				$shippingCode = $orderAccount->getBillingCode();
			}
			else if ($hasFullShippingAddress) {
				$billingStreet = $orderAccount->getShippingStreet();
				$billingCity = $orderAccount->getShippingCity();
				$billingState = $orderAccount->getShippingState();
				$billingCode = $orderAccount->getShippingCode();

				$shippingStreet = $orderAccount->getShippingStreet();
				$shippingCity = $orderAccount->getShippingCity();
				$shippingState = $orderAccount->getShippingState();
				$shippingCode = $orderAccount->getShippingCode();
			}
			else {
				$billingStreet = $result['street'];
				$billingCity = $result['city'];
				$billingState = $result['state'];
				$billingCode = $result['zip'];

				$shippingStreet = $result['street'];
				$shippingCity = $result['city'];
				$shippingState = $result['state'];
				$shippingCode = $result['zip'];
			}
		}
		else {
			$shippingName = $result['account_name'];
			$billingName = $result['account_name'];

			$billingStreet = $result['street'];
			$billingCity = $result['city'];
			$billingState = $result['state'];
			$billingCode = $result['zip'];

			$shippingStreet = $result['street'];
			$shippingCity = $result['city'];
			$shippingState = $result['state'];
			$shippingCode = $result['zip'];
		}

		$imagingComplete = '';
		$dateImagingComplete = '';
		$imagingNotes = '';
		if ((bool)$po_order['imaging_complete']) {
			$imagingComplete = 'checked';
			$dateImagingComplete = $po_order['date_imaging_complete'];
		}
		if ($po_order['imaging_notes']) {
			$imagingNotes = $po_order['imaging_notes'];
		}

        $parse = array(
			'IMAGING_COMPLETE' => $imagingComplete,
			'IMAGING_NOTES' => $imagingNotes,
			'DATE_IMAGING_COMPLETE' => $dateImagingComplete,
			'CONTACT_NAME' => $contactName,
			'CONTACT_EMAIL' => $contactEmail,
			'CONTACT_PHONE' => $contactPhone,
			'BILLING_NAME' => $billingName,
			'BILLING_STREET' => $billingStreet,
			'BILLING_CITY' => $billingCity,
			'BILLING_STATE' => $billingState,
			'BILLING_CODE' => $billingCode,
			'SHIPPING_NAME' => $shippingName,
			'SHIPPING_STREET' => $shippingStreet,
			'SHIPPING_CITY' => $shippingCity,
			'SHIPPING_STATE' => $shippingState,
			'SHIPPING_CODE' => $shippingCode,
            'ORDER_ID'  => $order_id,
            'ORDER_NUMBER'  => $po_order['order_number'].' '.$bbData['account_name'],
            'PO_NUMBER'  => $po_order['order_number'],
            'RACKS' => $racktable,
            'RACK_ROWS' => $rack_rows,
            'ACCESSORIES'   => $deduction_table,
            'ACCESSORY_ROWS'    => $counter,
            'STATUS'    => $status_option,
            'EXPECTED_SHIP_DATE'    => $this->format_date('db_date',strtotime($po_order['expected_ship_date'])),
            'CARRIER'   => $carrier_option,
            'PALLETS'   => $po_order['pallets'],
            'DEVICES_RECEIVED'  => $bbData['devices_received'], // $devices_received,
            'ACCESSORIES_RECEIVED'  => $bbData['accessories_received'], // $accessories_received['total'],
            'DEVICES_AUDITED'   => $bbData['devices_audited'], // $devices_audited['total'],
			'IPADS_IMAGED'  => $bbData['ipads_imaged'], // $ipads_imaged['total'],
			'OTHERS_IMAGED' => $bbData['others_imaged'],
            'PERCENTAGE_COMPLETE' => floor($bbData['devices_audited']/$bbData['devices_received']*100),
            'DATE_RECEIVED' => $bbData['date_received'], // $dateReceived,
            'AUDIT_COMPLETE' => $audit_date,
			'DAYS_TO_AUDIT' => $days_to_audit,
			'PAYMENT_TERM'	=> $paymentTerm,
            'PAYMENT_DUE'   => $paymentDue . " " . $daysReminingStr,
            'PAYMENT_SENT_DATE' => $po_order['payment_sent_date']?$this->format_date('db_date', strtotime($po_order['payment_sent_date'])):'',
            'DAYS_TO_PAYMENT'   => $days_to_payment,
            'NOTES' => $po_order['notes'],
            'MDM_LOCK'  => $mdm_lock,
            'ACTIVATION_LOCK'   => $activation_lock,
            'AUDIT_MDM_LOCK'  => $audit_mdm_lock,
            'AUDIT_ACTIVATION_LOCK'   => $audit_activation_lock,
            'ENGRAVED' => $engraved['engraved'],
            'FIRMWARE_PASSWORD' => $po_order['firmware_password'],
            'FIRMWARE_LOCK_AUDIT' => $po_order['firmware_lock_audit'],
            'DEVICE_PAYOUT' => $total,
            'DEDUCTIONS'    => $deduction_value,
            'NET_PAYOUT'    => $total - $deduction_value,
            'ACCOUNT_NAME'  => $bbData['account_name'],
            'EXPECTED'      => $expected,
            'UNEXPECTED'      => $unexpected,
            'PICJSON'       => $picjson
        );

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(BB_DETAIL, $parse)));

    }

	function sendImagingCompleteEmail($orderId) {
		$cronQueueCommand = mysql_real_escape_string("php56 /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com imagingcompleteemail $orderId");
		$sql = "INSERT INTO cron_queue(`cron_queue_command`, `delay`) VALUES ('$cronQueueCommand', '10');";
		return $this->db_query($sql, 'insert');
	}

    function bb_customer_audit_report(){

        global $zohoObj, $zoho_auth_tokens, $buyback_users;

        $po_account = $this->db_select_single('po_accounts', '*', array('account_name' => $_POST['account_name']));

        if ($po_account['street']){
            $contact = $po_account;
        }else{

                /* Bilal: Old code block comment out
            $parameters = array(
                'scope'     =>  'crmapi'
                ,'selectColumns'    =>  'All'//columns to select
                ,'fromIndex'        =>  1//start record
                ,'toIndex'          =>  200//end record
                ,'criteria'  =>  '(Account Name:'.$_POST['account_name'].')'//filter
            );

            //retrieve records for all users
            foreach($zoho_auth_tokens as $row){

                $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Contacts');

                $count = count($result->result->Contacts->row[0]->FL);
                for ($j = 0; $j < $count; $j++){
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'First Name'){
                        $contact['first_name'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Last Name'){
                        $contact['last_name'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Email'){
                        $contact['email'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Phone'){
                        $contact['phone'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Mailing Street'){
                        $contact['street'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Mailing City'){
                        $contact['city'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Mailing State'){
                        $contact['state'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                    if ((string)$result->result->Contacts->row[0]->FL[$j]->attributes()->val == 'Mailing Zip'){
                        $contact['zip'] = (string)$result->result->Contacts->row[0]->FL[$j];
                    }
                }

            }
                    *
                    */

                    $contact = $zohoObj->getSearchRecords_Contacts($_POST['account_name']);
        }

		//Get the order details
		$sqlPoNum = $_POST['poNumber'];
		$sqlOrderId = $_POST['order_id'];
        // $sql = "SELECT DISTINCT dso.serialNumber, dso.asset, dso.audit_summary, dso.grade_at_audit,
        //     CASE
        //         WHEN LENGTH(dso.audit_summary) > 140 THEN CONCAT(SUBSTRING(dso.audit_summary,1,160),'...')
        //         ELSE dso.audit_summary
        //     END AS summary,
        //     CASE
        //         WHEN dso.machineType LIKE '%iPad%' THEN 'N/A'
        //         ELSE CONCAT(CONVERT(CONVERT(dso.ram_1, UNSIGNED INTEGER)+CONVERT(dso.ram_2, UNSIGNED INTEGER)+CONVERT(dso.ram_3, UNSIGNED INTEGER)+CONVERT(dso.ram_4, UNSIGNED INTEGER), CHAR(50)),'GB')
        //     END AS ram,
        //     CASE
        //         WHEN dso.machineType LIKE '%iPad%' THEN capacity
        //         ELSE CONCAT(CONVERT(CONVERT(dso.hd_1, UNSIGNED INTEGER)+CONVERT(dso.hd_2, UNSIGNED INTEGER), CHAR(50)),'GB')
        //     END AS capacity,
        //     (SELECT
        //     CASE
        //         WHEN dso.grade_at_audit = 'A' THEN poi.price_a
        //         WHEN dso.grade_at_audit = 'B' THEN poi.price_b
        //         WHEN dso.grade_at_audit = 'C' THEN poi.price_c
        //         WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
        //         WHEN dso.grade_at_audit = 'F' THEN poi.price_f
        //         ELSE NULL
        //     END
        //     ) AS price
        //     FROM ds_orders dso
        //     LEFT JOIN po_items poi ON dso.asset = poi.order_number
		// 	WHERE poNumber = '$sqlPoNum' AND poi.order_id = $sqlOrderId ORDER BY dso.asset, dso.grade_at_audit;";

		$sql =
			"SELECT DISTINCT dso.serialNumber, IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) AS asset, dso.audit_summary, dso.grade_at_audit,
			CASE
				WHEN LENGTH(dso.audit_summary) > 140 THEN CONCAT(SUBSTRING(dso.audit_summary,1,160),'...')
				ELSE dso.audit_summary
			END AS summary,
			CASE
				WHEN dso.machineType LIKE '%iPad%' THEN 'N/A'
				ELSE CONCAT(CONVERT(CONVERT(dso.ram_1, UNSIGNED INTEGER)+CONVERT(dso.ram_2, UNSIGNED INTEGER)+CONVERT(dso.ram_3, UNSIGNED INTEGER)+CONVERT(dso.ram_4, UNSIGNED INTEGER), CHAR(50)),'GB')
			END AS ram,
			CASE
				WHEN dso.machineType LIKE '%iPad%' THEN capacity
				ELSE CONCAT(CONVERT(CONVERT(dso.hd_1, UNSIGNED INTEGER)+CONVERT(dso.hd_2, UNSIGNED INTEGER), CHAR(50)),'GB')
			END AS capacity,
			(SELECT
			CASE
				WHEN dso.grade_at_audit = 'A' THEN poi.price_a
				WHEN dso.grade_at_audit = 'B' THEN poi.price_b
				WHEN dso.grade_at_audit = 'C' THEN poi.price_c
				WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
				WHEN dso.grade_at_audit = 'F' THEN poi.price_f
				ELSE NULL
			END
			) AS price
			FROM ds_orders dso
			LEFT JOIN po_items poi ON IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) = poi.order_number
			WHERE poNumber = '$sqlPoNum' AND poi.order_id = $sqlOrderId ORDER BY asset, dso.grade_at_audit;";

        $order = $this->db_query($sql, 'select-multiple');

        //Get summary of order
        // $sql = 'SELECT dso.asset, dso.grade_at_audit, ml.machine_description, COUNT(dso.grade_at_audit) AS machine_count,
        //     (SELECT
        //     CASE
        //         WHEN dso.grade_at_audit = "A" THEN poi.price_a
        //         WHEN dso.grade_at_audit = "B" THEN poi.price_b
        //         WHEN dso.grade_at_audit = "C" THEN poi.price_c
        //         WHEN dso.grade_at_audit LIKE "%D%" THEN poi.price_d
        //         WHEN dso.grade_at_audit = "F" THEN poi.price_f
        //         ELSE NULL
        //     END
        //     ) AS price,
        //     (SELECT
        //     CASE
        //         WHEN dso.grade_at_audit = "A" THEN poi.price_a
        //         WHEN dso.grade_at_audit = "B" THEN poi.price_b
        //         WHEN dso.grade_at_audit = "C" THEN poi.price_c
        //         WHEN dso.grade_at_audit LIKE "%D%" THEN poi.price_d
        //         WHEN dso.grade_at_audit = "F" THEN poi.price_f
        //         ELSE NULL
        //     END
        //     ) * COUNT(dso.grade_at_audit) AS total
        //     FROM ds_orders dso
        //     LEFT JOIN po_items poi ON dso.asset = poi.order_number
        //     LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
        //     WHERE dso.poNumber = "'.$_POST['poNumber'].'" AND poi.order_id = '.$_POST['order_id'].'
		// 	GROUP BY dso.asset, dso.grade_at_audit, ml.machine_description';

		$sql = "SELECT IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) AS normalized_asset, dso.grade_at_audit, ml.machine_description, COUNT(dso.grade_at_audit) AS machine_count,
		(SELECT
		CASE
			WHEN dso.grade_at_audit = 'A' THEN poi.price_a
			WHEN dso.grade_at_audit = 'B' THEN poi.price_b
			WHEN dso.grade_at_audit = 'C' THEN poi.price_c
			WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
			WHEN dso.grade_at_audit = 'F' THEN poi.price_f
			ELSE NULL
		END
		) AS price,
		(SELECT
		CASE
			WHEN dso.grade_at_audit = 'A' THEN poi.price_a
			WHEN dso.grade_at_audit = 'B' THEN poi.price_b
			WHEN dso.grade_at_audit = 'C' THEN poi.price_c
			WHEN dso.grade_at_audit LIKE '%D%' THEN poi.price_d
			WHEN dso.grade_at_audit = 'F' THEN poi.price_f
			ELSE NULL
		END
		) * COUNT(dso.grade_at_audit) AS total
		FROM ds_orders dso
		LEFT JOIN po_items poi ON IF(dso.asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(dso.asset, '-', 1), dso.asset) = poi.order_number
		LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
		WHERE dso.poNumber = '$sqlPoNum' AND poi.order_id = $sqlOrderId
		GROUP BY normalized_asset, dso.grade_at_audit, ml.machine_description;";

        $order_summary = $this->db_query($sql, 'select-multiple');

        $machine_count = array();

        $total = 0;

        //Build array of deductions
        foreach ($order_summary as $summary){
			$summary['asset'] = $summary['normalized_asset'];
            $sql = 'SELECT DISTINCT pod.price, pod.deduction_id
                    FROM po_deductions pod
                    LEFT JOIN machine_order_number_accessories mona ON mona.deduction_id = pod.deduction_id
                    LEFT JOIN machine_order_number mon ON mon.order_number_id = mona.order_number_id
                    WHERE pod.order_id = '.$_POST['order_id'].' AND mon.order_number = "'.$summary['asset'].'"';

            $accessory_price = 0;

            $accessory_prices = $this->db_query($sql, 'select-multiple');

            foreach ($accessory_prices as $price){
                $accessory_price = $accessory_price + (float)$price['price'];
            }

            //Add deduction if not F and total of deductions doesn't exceed value of device
            if ($summary['grade_at_audit'] != 'F' && $accessory_price < $summary['price']){

                $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id', array('order_number' => $summary['asset']));

                $machine_count[$machine_order_number['order_number_id']]['count'] = $machine_count[$machine_order_number['order_number_id']]['count'] + $summary['machine_count'];
            }else{
                $machine_order_number = $this->db_select_single('machine_order_number', 'order_number_id', array('order_number' => $summary['asset']));

                $machine_count[$machine_order_number['order_number_id']]['count'] = $machine_count[$machine_order_number['order_number_id']]['count'] + 0;
            }

            $total = $total + (float)$summary['total'];

        }

        //Get product lines for grades display
        $sql = 'SELECT DISTINCT product_line
            FROM machine_lookup ml
            LEFT JOIN machine_order_number mon ON mon.machine_id = ml.machine_id
            LEFT JOIN ds_orders dso ON dso.asset = mon.order_number
            WHERE dso.poNumber = "'.$_POST['poNumber'].'"';

        $product_lines = $this->db_query($sql, 'select-multiple');

        foreach ($buyback_users as $user){
            if ($user['aID'] == $_SESSION['aID']){
                $prepared_by = $user;
            }
        }

        //get values for report header
        /*$sql = 'SELECT
            (SELECT COUNT(oID)
            FROM ds_orders
            WHERE poNumber = poo.order_number AND asset = poi.order_number) AS received_quantity,
            poi.order_number, ml.machine_description, poi.price_a, poi.price_b, poi.price_c, poi.price_d
            FROM po_items poi
            LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
            LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
            WHERE poi.order_id = "'.$_POST['order_id'].'"
            ORDER BY poi.order_number';*/

        /*$sql = 'SELECT COUNT(oID) AS received, poi.order_number, ml.machine_description,
            CASE
                WHEN dso.grade LIKE "%D%" THEN "D"
                ELSE dso.grade
            END AS grade,
            CASE
                WHEN dso.grade = "A" THEN poi.price_a
                WHEN dso.grade = "B" THEN poi.price_b
                WHEN dso.grade = "C" THEN poi.price_c
                WHEN dso.grade LIKE "%D%" THEN poi.price_d
                WHEN dso.grade = "F" THEN poi.price_f
                ELSE NULL
            END AS price,
            CASE
                WHEN dso.grade = "A" THEN (COUNT(dso.oID)*poi.price_a)
                WHEN dso.grade = "B" THEN (COUNT(dso.oID)*poi.price_b)
                WHEN dso.grade = "C" THEN (COUNT(dso.oID)*poi.price_c)
                WHEN dso.grade LIKE "%D%" THEN (COUNT(dso.oID)*poi.price_d)
                WHEN dso.grade = "F" THEN (COUNT(dso.oID)*poi.price_f)
                ELSE NULL
            END AS totalprice
            FROM ds_orders dso
            LEFT JOIN po_orders poo ON poo.order_number = dso.poNumber
            LEFT JOIN po_items poi ON poi.order_id = poo.order_id
            LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
            WHERE poo.order_id = "'.$_POST['order_id'].'"
            GROUP BY dso.grade
            ORDER BY dso.grade';*/

		$orderId = $_POST['order_id'];
        $sql = "SELECT poi.order_number, poi.price_a AS price, ml.machine_description, 'A' AS grade,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND IF(asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(asset, '-', 1), asset) = poi.order_number AND grade_at_audit = 'A') AS received
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
                WHERE poi.order_id = $orderId
                UNION
                SELECT poi.order_number, poi.price_b AS price, ml.machine_description, 'B' AS grade,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND IF(asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(asset, '-', 1), asset) = poi.order_number AND grade_at_audit = 'B') AS received
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
                WHERE poi.order_id = $orderId
                UNION
                SELECT poi.order_number, poi.price_c AS price, ml.machine_description, 'C' AS grade,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND IF(asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(asset, '-', 1), asset) = poi.order_number AND grade_at_audit = 'C') AS received
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
                WHERE poi.order_id = $orderId
                UNION
                SELECT poi.order_number, poi.price_d AS price, ml.machine_description, 'D' AS grade,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND IF(asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(asset, '-', 1), asset) = poi.order_number AND grade_at_audit LIKE '%D%') AS received
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
                WHERE poi.order_id = $orderId
                UNION
                SELECT poi.order_number, poi.price_f AS price, ml.machine_description, 'F' AS grade,
                (SELECT COUNT(oID)
                FROM ds_orders
                WHERE poNumber = poo.order_number AND IF(asset REGEXP '(-[0-9]{1,4}\/[0-9]{1,6})$', SUBSTRING_INDEX(asset, '-', 1), asset) = poi.order_number AND grade_at_audit = 'F') AS received
                FROM po_items poi
                LEFT JOIN po_orders poo ON poo.order_id = poi.order_id
                LEFT JOIN machine_lookup ml ON ml.machine_id = poi.machine_id
                WHERE poi.order_id = $orderId
                ORDER BY order_number, grade;";

        $order_overview = $this->db_query($sql, 'select-multiple');

        $sourceplusRGB = array("R" => 0,"G" => 146,"B" => 219);
        $techtoschoolRGB = array("R" => 0,"G" => 150,"B" => 42);

        if ($_POST['company'] == 'sourceplus'){
            $R = $sourceplusRGB["R"];
            $G = $sourceplusRGB["G"];
            $B = $sourceplusRGB["B"];
            $logo = HTML_FOLDER.'img/SPLogo.png';
            $email = $prepared_by['sourceplus_email'];
        }else{
            $R = $techtoschoolRGB["R"];
            $G = $techtoschoolRGB["G"];
            $B = $techtoschoolRGB["B"];
            $logo = HTML_FOLDER.'img/TTSLogo2018big3.jpg';
            $email = $prepared_by['techtoschool_email'];
        }

		// Handle addresses
		$manualAddressInput = (bool)$_POST['manual_input_active'];
		if ($manualAddressInput) {
			$contactName = $_POST['contact_name'];
			$contactEmail = $_POST['contact_email'];
			$contactPhone = $_POST['contact_phone'];

			$billingName = $_POST['billing_name'];
			$billingStreet = $_POST['billing_street'];
			$billingCity = $_POST['billing_city'];
			$billingState = $_POST['billing_state'];
			$billingCode = $_POST['billing_zip'];

			$shippingName = $_POST['shipping_name'];
			$shippingStreet = $_POST['shipping_street'];
			$shippingCity = $_POST['shipping_city'];
			$shippingState = $_POST['shipping_state'];
			$shippingCode = $_POST['shipping_zip'];
		}
		else {
			$contactName = $contact['first_name'].' '.$contact['last_name'];
			$contactEmail = $contact['email'];
			$contactPhone = $contact['phone'];

			$shippingName = $_POST['account_name'];
			$billingName = $_POST['account_name'];

			if ($po_account['order_account_id']) {
				$orderAccountId = $po_account['order_account_id'];
				$orderAccount = Account::fetch($orderAccountId);
			}
			if ($orderAccount) {
				$hasFullBillingAddress = $orderAccount->getHasFullBillingAddress();
				$hasFullShippingAddress = $orderAccount->getHasFullShippingAddress();

				if ($hasFullBillingAddress && $hasFullShippingAddress) {
					$billingStreet = $orderAccount->getBillingStreet();
					$billingCity = $orderAccount->getBillingCity();
					$billingState = $orderAccount->getBillingState();
					$billingCode = $orderAccount->getBillingCode();

					$shippingStreet = $orderAccount->getShippingStreet();
					$shippingCity = $orderAccount->getShippingCity();
					$shippingState = $orderAccount->getShippingState();
					$shippingCode = $orderAccount->getShippingCode();
				}
				else if ($hasFullBillingAddress) {
					$billingStreet = $orderAccount->getBillingStreet();
					$billingCity = $orderAccount->getBillingCity();
					$billingState = $orderAccount->getBillingState();
					$billingCode = $orderAccount->getBillingCode();

					$shippingStreet = $orderAccount->getBillingStreet();
					$shippingCity = $orderAccount->getBillingCity();
					$shippingState = $orderAccount->getBillingState();
					$shippingCode = $orderAccount->getBillingCode();
				}
				else if ($hasFullShippingAddress) {
					$billingStreet = $orderAccount->getShippingStreet();
					$billingCity = $orderAccount->getShippingCity();
					$billingState = $orderAccount->getShippingState();
					$billingCode = $orderAccount->getShippingCode();

					$shippingStreet = $orderAccount->getShippingStreet();
					$shippingCity = $orderAccount->getShippingCity();
					$shippingState = $orderAccount->getShippingState();
					$shippingCode = $orderAccount->getShippingCode();
				}
				else {
					$billingStreet = $contact['street'];
					$billingCity = $contact['city'];
					$billingState = $contact['state'];
					$billingCode = $contact['zip'];

					$shippingStreet = $contact['street'];
					$shippingCity = $contact['city'];
					$shippingState = $contact['state'];
					$shippingCode = $contact['zip'];
				}
			}
			else {
				$billingStreet = $contact['street'];
				$billingCity = $contact['city'];
				$billingState = $contact['state'];
				$billingCode = $contact['zip'];

				$shippingStreet = $contact['street'];
				$shippingCity = $contact['city'];
				$shippingState = $contact['state'];
				$shippingCode = $contact['zip'];
			}
		}

        //Initialise PDF document
        $pdfObj = new pdf();

        $pdfObj->imgHeader = $logo;
        $pdfObj->rightHeader = 'Buyback Audit';
        $pdfObj->orderNumber = $_POST['poNumber'];
        $pdfObj->date = $this->format_date('templ_date');
        $pdfObj->R = $R;
        $pdfObj->G = $G;
        $pdfObj->B = $B;
        $pdfObj->AddPage('L','Letter');
        $pdfObj->SetFont('Arial','',6);

        $pdfObj->leftFooter = 'MyService Solutions, Inc DBA Tech to School';
        $pdfObj->rightFooter = '1530 Montague Expressway San Jose, CA 95131';

        $pdfObj->Cell(120,3,'Prepared for:');
        $pdfObj->Cell(20,3,'Prepared by:');
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->Cell(120,2,$contactName);
        $pdfObj->Cell(20,2,$prepared_by['name']);
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,$contactEmail);
        $pdfObj->Cell(20,3,$email);
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,'Phone: '.$contactPhone);
        $pdfObj->Cell(20,3,'Phone: '.$prepared_by['phone']);
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,'');
        $pdfObj->Cell(20,3,'Fax: '.$prepared_by['fax']);

        $pdfObj->Line(10,$pdfObj->GetY()+5,252,$pdfObj->GetY()+5);

        $pdfObj->SetY($pdfObj->GetY()+7);

        $pdfObj->Cell(120,3,'Buyback from:');
        $pdfObj->Cell(20,3,'Payment to:');
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,$shippingName);
        $pdfObj->Cell(20,3,$billingName);
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,$shippingStreet);
        $pdfObj->Cell(20,3,$billingStreet);
        $pdfObj->Ln();
        $pdfObj->Cell(120,3,$shippingCity.', '.$shippingState.', '.$shippingCode);
        $pdfObj->Cell(20,3,$billingCity.', '.$billingState.', '.$billingCode);

        $pdfObj->Line(10,$pdfObj->GetY()+5,252,$pdfObj->GetY()+5);

        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->Cell(240,4,'Actual Devices Received');
        $pdfObj->Ln();


        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(20,4,'Qty',0,0,'',true);
        $pdfObj->Cell(20,4,'Grade',0,0,'',true);
        $pdfObj->Cell(160,4,'Description',0,0,'',true);
        $pdfObj->Cell(20,4,'Grade Price',0,0,'R',true);
        $pdfObj->Cell(20,4,'Total Per Grade',0,0,'R',true);
        $pdfObj->Ln();

        $pdfObj->SetFillColor(240);

        $fill = false;
        $total_inventory_value = 0;

        //Write device lines
        foreach ($order_overview as $overview_line){
            if ($overview_line['received'] > 0){
                $pdfObj->Cell(20,4,$overview_line['received'],0,0,'L',$fill);
                $pdfObj->Cell(20,4,$overview_line['grade'],0,0,'L',$fill);
                $pdfObj->Cell(20,4,$overview_line['order_number'],0,0,'L',$fill);
                $pdfObj->Cell(140,4,$overview_line['machine_description'],0,0,'L',$fill);
                $pdfObj->Cell(20,4,'$'.$overview_line['price'],0,0,'R',$fill);
                $pdfObj->Cell(20,4,'$'.$overview_line['price']*$overview_line['received'],0,0,'R',$fill);
                $pdfObj->Ln();
                $fill=!$fill;
                $total_inventory_value += ($overview_line['price']*$overview_line['received']);
            }
        }

        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(220,4,'Total Inventory Value',0,0,'R',true);
        $pdfObj->Cell(20,4,'$'.$total_inventory_value,0,0,'R',true);

        $pdfObj->AddPage('L','Letter');


        $pdfObj->Cell(252,3,'DH - Display Housing   TC - Top Case   BC - Bottom Case',0,0,'C');

        $pdfObj->SetY($pdfObj->GetY()+3);

        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(20,4,'Serial Number',0,0,'',true);
        $pdfObj->Cell(20,4,'Model',0,0,'',true);
        $pdfObj->Cell(160,4,'Audit Comments',0,0,'',true);
        $pdfObj->Cell(12,4,'Hard Drive',0,0,'',true);
        $pdfObj->Cell(10,4,'RAM',0,0,'',true);
        $pdfObj->Cell(10,4,'Grade',0,0,'',true);
        $pdfObj->Cell(10,4,'Price',0,0,'R',true);
        $pdfObj->Ln();

        $pdfObj->SetFillColor(240);
        $fill = false;

        $inventory_value = 0;

        //Write device lines
        foreach ($order as $line){
            $pdfObj->Cell(20,4,$line['serialNumber'],0,0,'',$fill);
            $pdfObj->Cell(20,4,$line['asset'],0,0,'',$fill);
            $pdfObj->Cell(160,4,$line['grade_at_audit']=='A'?'No physical or functional issues found.':$line['summary'],0,0,'',$fill);
            $pdfObj->Cell(12,4,$line['capacity'],0,0,'',$fill);
            $pdfObj->Cell(10,4,$line['ram'],0,0,'',$fill);
            if (strpos($line['grade_at_audit'],'D') !== false){
                $pdfObj->Cell(10,4,'D',0,0,'',$fill);
            }elseif (strpos($line['grade_at_audit'],'F') !== false) {
                $pdfObj->Cell(10,4,'F',0,0,'',$fill);
            }else{
                $pdfObj->Cell(10,4,substr($line['grade_at_audit'],0,1),0,0,'',$fill);
            }
            if ($line['price'] != ''){
                $pdfObj->Cell(10,4,'$'.$line['price'],0,0,'R',$fill);
            }else{
                $pdfObj->Cell(10,4,'N/A',0,0,'R',$fill);
            }
            $pdfObj->Ln();
            $fill=!$fill;
            $inventory_value += (float)$line['price'];

        }

        $deduction_array = array();

        //Build deduction array
        foreach ($machine_count as $k => $v){

            $sql = 'SELECT DISTINCT mona.deduction_id, pd.price, pdl.deduction_name, pdl.deduction_size, pdl.deduction_type,
                (SELECT quantity FROM po_accessories_received WHERE order_id = '.$_POST['order_id'].' AND deduction_id = mona.deduction_id) AS quantity,
                (SELECT quantity_bad FROM po_accessories_received WHERE order_id = '.$_POST['order_id'].' AND deduction_id = mona.deduction_id) AS quantity_bad
                FROM machine_order_number mon
                LEFT JOIN machine_order_number_accessories mona ON mona.order_number_id = mon.order_number_id
                LEFT JOIN po_deductions pd ON pd.deduction_id = mona.deduction_id
                LEFT JOIN po_deductions_lookup pdl ON pdl.deduction_id = pd.deduction_id
                WHERE mon.order_number_id = '.$k.' AND pd.order_id = '.$_POST['order_id'];

            $deductions = $this->db_query($sql, 'select-multiple');

            foreach ($deductions as $deduction){
                $deduction_array[$deduction['deduction_id']]['deduction_name'] = $deduction['deduction_name'];
                $deduction_array[$deduction['deduction_id']]['deduction_type'] = $deduction['deduction_type'];
                $deduction_array[$deduction['deduction_id']]['deduction_size'] = $deduction['deduction_size'];
                $deduction_array[$deduction['deduction_id']]['price'] = $deduction['price'];
                $deduction_array[$deduction['deduction_id']]['quantity_received'] = $deduction['quantity'];
                $deduction_array[$deduction['deduction_id']]['quantity_bad'] = $deduction['quantity_bad'];
                $deduction_array[$deduction['deduction_id']]['quantity_expected'] += $v['count'];
            }

        }

        $adapter_array = array();

        foreach ($deduction_array as $k => $v){
            if (($v['quantity_expected'] < ($v['quantity_received']+$v['quantity_bad'])) && $v['deduction_type'] == 'adapter'){
                $adapter_array[$k]['quantity'] = $v['quantity_received']-$v['quantity_bad']-$v['quantity_expected'];
                $adapter_array[$k]['size'] = $v['deduction_size'];
            }
        }

        $magsafe_array = array();

        foreach ($deduction_array as $k => $v){
            if (($v['quantity_expected'] < ($v['quantity_received']+$v['quantity_bad'])) && $v['deduction_type'] == 'magsafe'){
                $magsafe_array[$k]['quantity'] = $v['quantity_received']-$v['quantity_bad']-$v['quantity_expected'];
                $magsafe_array[$k]['size'] = $v['deduction_size'];
            }
        }

        $adapter_count = 0;

        foreach ($adapter_array as $k => $v){
            $adapter_count = $v['quantity'];
            foreach ($deduction_array as $k1 => $v1){
                if ($v1['deduction_type'] == 'adapter' && $v1['quantity_received'] < $v1['quantity_expected'] && $v1['deduction_size'] < $v['size'] && $adapter_count > 0){
                    if ($v1['quantity_bad'] > 0){
                        $deduction_array[$k1]['quantity_bad'] = $v1['quantity_bad']-$v['quantity'];
                        $adapter_count = 0;
                        if ($deduction_array[$k1]['quantity_bad'] < 0){
                            $adapter_count = 0 - $deduction_array[$k1]['quantity_bad'];
                        }
                    }else{
                        $deduction_array[$k1]['quantity_received'] += $v['quantity'];
                        $adapter_count = 0;
                        if ($deduction_array[$k1]['quantity_received'] > $deduction_array[$k1]['quantity_expected']){
                            $adapter_count = $deduction_array[$k1]['quantity_expected'] - $deduction_array[$k1]['quantity_expected'];
                            $deduction_array[$k1]['quantity_received'] = $deduction_array[$k1]['quantity_expected'];
                        }
                    }
                }
                $adapter_count = 0;
            }
        }

        $magsafe_count = 0;

        foreach ($magsafe_array as $k => $v){
            $magsafe_count = $v['quantity'];
            foreach ($deduction_array as $k1 => $v1){
                if ($v1['deduction_type'] == 'magsafe' && $v1['quantity_received'] < $v1['quantity_expected'] && $v1['deduction_size'] < $v['size'] && $magsafe_count > 0){
                    if ($v1['quantity_bad'] > 0){
                        $deduction_array[$k1]['quantity_bad'] = $v1['quantity_bad']-$v['quantity'];
                        $magsafe_count = 0;
                        if ($deduction_array[$k1]['quantity_bad'] < 0){
                            $magsafe_count = 0 - $deduction_array[$k1]['quantity_bad'];
                        }
                    }else{
                        $deduction_array[$k1]['quantity_received'] += $v['quantity'];
                        $magsafe_count = 0;
                        if ($deduction_array[$k1]['quantity_received'] > $deduction_array[$k1]['quantity_expected']){
                            $magsafe_count = $deduction_array[$k1]['quantity_expected'] - $deduction_array[$k1]['quantity_expected'];
                            $deduction_array[$k1]['quantity_received'] = $deduction_array[$k1]['quantity_expected'];
                        }
                    }
                }
                $magsafe_count = 0;
            }
        }

        $deduction_value = 0;

        /*foreach ($deduction_array as $deduction_item){
            $deduction_value += ($deduction_item['quantity_expected']-($deduction_item['quantity_received']-$deduction_item['quantity_bad']))*$deduction_item['price'];
        }

        if ($deduction_value < 0){
            $deduction_value = 0;
        }*/

        $sql = 'SELECT COUNT(dso.oID) AS order_count
            FROM ds_orders dso
            WHERE dso.poNumber = "'.$_POST['poNumber'].'" AND (dso.mdm_lock = 1 OR dso.activation_lock = 1 OR dso.audit_mdm_lock = 1 OR dso.audit_activation_lock = 1)';

        $locks = $this->db_query($sql, 'select-single');

        if ($locks['order_count'] > 0){

            $lock_price = $this->db_select_single('po_deductions', 'price', array('order_id' => $_POST['order_id'],'deduction_id' => 12));
            //$deduction_value += $locks['order_count']*$lock_price['price'];
        }

        if ($pdfObj->GetY()>145){
            $pdfObj->AddPage('L','Letter');
        }

        //Write deduction table
        $pdfObj->Ln();
        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(242,4,'Accessory Deductions:',0,0,'',true);
        $pdfObj->Ln();

        $pdfObj->Cell(30,4);
        $pdfObj->Cell(20,4,'Count',0,0,'R');
        $pdfObj->Cell(20,4,'Cost',0,0,'R');
        $pdfObj->Cell(20,4,'Total',0,0,'R');
        $pdfObj->Ln();

        foreach ($deduction_array as $deduction_item){
            $pdfObj->Cell(30,4,'Missing '.$deduction_item['deduction_name']);
            if ($deduction_item['quantity_expected']-$deduction_item['quantity_received'] > 0){
                $pdfObj->Cell(20,4,$deduction_item['quantity_expected']-$deduction_item['quantity_received'],0,0,'R');
                $pdfObj->Cell(20,4,'$'.$deduction_item['price'],0,0,'R');
                $pdfObj->Cell(20,4,'$'.($deduction_item['quantity_expected']-$deduction_item['quantity_received'])*$deduction_item['price'],0,0,'R');
                $deduction_value += ($deduction_item['quantity_expected']-$deduction_item['quantity_received'])*$deduction_item['price'];
            }else{
                $pdfObj->Cell(20,4,'0',0,0,'R');
            }
            $pdfObj->Ln();
            $pdfObj->Cell(30,4,'Bad '.$deduction_item['deduction_name']);
            if ($deduction_item['quantity_bad'] > 0){
                if ($deduction_item['quantity_received'] <= $deduction_item['quantity_expected']){
                    $pdfObj->Cell(20,4,$deduction_item['quantity_bad'],0,0,'R');
                }elseif(($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected'])) < 0){
                    $pdfObj->Cell(20,4,'0',0,0,'R');
                }else{
                    $pdfObj->Cell(20,4,($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected'])),0,0,'R');
                }
                $pdfObj->Cell(20,4,'$'.$deduction_item['price'],0,0,'R');
                if ($deduction_item['quantity_received'] <= $deduction_item['quantity_expected']){
                    $pdfObj->Cell(20,4,'$'.$deduction_item['quantity_bad']*$deduction_item['price'],0,0,'R');
                    $deduction_value += $deduction_item['quantity_bad']*$deduction_item['price'];
                }elseif(($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected'])) < 0){
                    $pdfObj->Cell(20,4,'$0',0,0,'R');
                }else{
                    $pdfObj->Cell(20,4,'$'.($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected']))*$deduction_item['price'],0,0,'R');
                    $deduction_value += ($deduction_item['quantity_bad']-($deduction_item['quantity_received']-$deduction_item['quantity_expected']))*$deduction_item['price'];

                }
            }else{
                $pdfObj->Cell(20,4,'0',0,0,'R');
            }
            $pdfObj->Ln();
        }

        if ($locks['order_count'] > 0){
            $pdfObj->Cell(30,4,'Locked Devices');
            $pdfObj->Cell(20,4,$locks['order_count'],0,0,'R');
            $pdfObj->Cell(20,4,'$'.$lock_price['price'],0,0,'R');
            $pdfObj->Cell(20,4,'$'.$locks['order_count']*$lock_price['price'],0,0,'R');
            $pdfObj->Ln();
            $deduction_value += $locks['order_count']*$lock_price['price'];
        }

        $engraved = $this->db_select_single('ds_orders', 'COUNT(oID) AS engraved', array('poNumber' => $_POST['poNumber'],'marking' => 1));

        if ($engraved['engraved'] > 0){
            $engraved_price = $this->db_select_single('po_deductions', 'price',array('deduction_id' => 11,'order_id' => $_POST['order_id']));
            $pdfObj->Cell(30,4,'Engraved Devices');
            $pdfObj->Cell(20,4,$engraved['engraved'],0,0,'R');
            $pdfObj->Cell(20,4,'$'.$engraved_price['price'],0,0,'R');
            $pdfObj->Cell(20,4,'$'.$engraved['engraved']*$engraved_price['price'],0,0,'R');
            $pdfObj->Ln();
            $deduction_value += $engraved['engraved']*$engraved_price['price'];
        }

        $firmware_locked_audit = $this->db_select_single('po_orders', 'firmware_lock_audit', array('order_id' => $_POST['order_id']));

        if ($firmware_locked_audit['firmware_lock_audit'] > 0){
            $pdfObj->Cell(30,4,'Firmware Locked at Audit');
            $pdfObj->Cell(20,4,$firmware_locked_audit['firmware_lock_audit'],0,0,'R');
            $pdfObj->Cell(20,4,'$2.00',0,0,'R');
            $pdfObj->Cell(20,4,'$'.$firmware_locked_audit['firmware_lock_audit']*2,0,0,'R');
            $pdfObj->Ln();
            $deduction_value += $firmware_locked_audit['firmware_lock_audit']*2;
        }

        //Write totals
        $pdfObj->Line(10,$pdfObj->GetY()+5,252,$pdfObj->GetY()+5);
        $pdfObj->SetXY(200,$pdfObj->GetY()+5);
        $pdfObj->Cell(20,4,'Total Inventory Value:',0,0,'R');
        $pdfObj->Cell(20,4,'$'.number_format($total_inventory_value,2),0,0,'R');
        $pdfObj->Ln();
        $pdfObj->SetX(200);
        $pdfObj->Cell(20,4,'Total Deductions:',0,0,'R');
        $pdfObj->Cell(20,4,'$'.number_format($deduction_value,2),0,0,'R');
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->SetX(200);
        $pdfObj->Cell(20,4,'Amount to be Paid:',0,0,'R');
        $pdfObj->Cell(20,4,'$'.number_format(($total_inventory_value-$deduction_value),2),0,0,'R');
        $pdfObj->Ln();
        $pdfObj->Line(10,$pdfObj->GetY()+5,252,$pdfObj->GetY()+5);

        $pdfObj->AddPage('L','Letter');
        $pdfObj->SetFont('Arial','',6);

        //Write grades tables for devices in buyback
        foreach ($product_lines as $product){

            $deduction_array = array();

            $sql = 'SELECT DISTINCT mona.deduction_id, pdl.deduction_name, pd.price
                        FROM machine_order_number_accessories mona
                        LEFT JOIN machine_order_number mon ON mon.order_number_id = mona.order_number_id
                        LEFT JOIN machine_lookup ml ON ml.machine_id = mon.machine_id
                        LEFT JOIN po_deductions_lookup pdl ON pdl.deduction_id = mona.deduction_id
                        LEFT JOIN po_deductions pd ON pd.deduction_id = pdl.deduction_id
                        WHERE ml.product_line = "'.$product['product_line'].'" AND pd.order_id = '.$_POST['order_id'];

            $product_deductions = $this->db_query($sql, 'select-multiple');

            foreach ($product_deductions as $pd){
                $deduction_array[] = ' '.$pd['deduction_name'].' $'.$pd['price'];
            }

            $deduction_text = implode(',', $deduction_array);

            switch (strtoupper($product['product_line'])){
                case 'MACBOOK AIR':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'MacBook Air',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or keyboard marks on the display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Shows normal signs of everyday use. Minor scratches or scuffs on the exterior casing. LCD has no marks.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Fair. Has moderate scratches on the exterior casing. Top case or display bezel are chipped. Minor keyboard marks or scratches on the screen.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Cracks or major dents on casing, broken or damaged plastic around ports,  white spots or heavy scratches on LCD; functional issue(s).',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for MacBook Air are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'IMAC':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'iMac',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or marks on the display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Shows normal signs of everyday use. Minor scratches or scuffs on the exterior casing. No dents or dings. No damage to glass.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Moderate scratches on exterior casing. Minor dings or dents on sufaces other than corners. No damage to glass.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Corners dented or misshapen, glass cracked. Bent stand. Functional issue(s).',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for iMac are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'MACBOOK PRO':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'MacBook Pro',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or keyboard marks on the display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Shows normal signs of everyday use. Minor scratches or scuffs on the exterior casing. LCD has no marks.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Fair. Has moderate scratches on the exterior casing. Top case or display bezel are chipped. Minor keyboard marks or scratches on the screen.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Cracks or major dents on casing, broken or damaged plastic around ports,  white spots or heavy scratches on LCD; functional issue(s).',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for MacBook Pro are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'MACBOOK':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'MacBook',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or keyboard marks on the display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Shows normal signs of everyday use. Minor scratches or scuffs on the exterior casing. LCD has no marks.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Fair. Has moderate scratches on the exterior casing. Top case or display bezel are chipped. Minor keyboard marks or scratches on the screen.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Cracks or major dents on casing, broken or damaged plastic around ports,  white spots or heavy scratches on LCD; functional issue(s).',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for MacBook are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'IPAD':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'iPad',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or marks on the front glass display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'No scratches or scuffs on front glass display, minor scratches or scuffs on rear housing. No dings or dents.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Minor surface scratches or scuffs on glass. Minor cosmetic scratches, dings or dents on rear housing.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Buttons faulty. Case corners dented, or causing digitizer to not sit properly. LCD or digitizer has heavy scratch(s) or cracked.',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for iPad are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'MAC MINI' OR 'APPLE TV':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'Mac Mini / Apple TV',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Minor scratches or scuffs, no dents.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Moderate scratches or dents on exterior case.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Rear ports damaged or missing.',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for Mac Mini / Apple TV are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

                case 'IPOD':
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(100,4,'Grade',0,0,'',true);
                    $pdfObj->Cell(142,4,'iPad',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->SetFillColor(240);
                    $pdfObj->Cell(20,4,'A',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Works perfectly. No noticeable flaws, or looks like new. No scratches or wear on exterior casing. No scratches, scuffs or marks on the front glass display.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'B',0,0,'C',true);
                    $pdfObj->Cell(222,4,'No scratches or scuffs on front glass display, minor scratches or scuffs on rear housing. No dings or dents.',0,0,'',true);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'C',0,0,'C',false);
                    $pdfObj->Cell(222,4,'Minor surface scratches or scuffs on glass. Minor cosmetic scratches, dings or dents on rear housing.',0,0,'',false);
                    $pdfObj->Ln();

                    $pdfObj->Cell(20,4,'D',0,0,'C',true);
                    $pdfObj->Cell(222,4,'Major cosmetic damage. Buttons faulty. Case corners dented, or causing digitizer to not sit properly. LCD or digitizer has heavy scratch(s) or cracked.',0,0,'',true);
                    if ($deduction_text != ''){
                        $pdfObj->Ln();

                        $pdfObj->Cell(20,4,'',0,0,'C',false);
                        $pdfObj->Cell(222,4,'Deductions for iPod are as follows -'.$deduction_text,0,0,'',false);
                    }
                    break;

            }

            $pdfObj->SetY($pdfObj->GetY()+15);

        }

        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(100,4,'Grade',0,0,'',true);
        $pdfObj->Cell(142,4,'All Machines',0,0,'',true);
        $pdfObj->Ln();

        $pdfObj->SetFillColor(240);
        $pdfObj->Cell(20,4,'F',0,0,'C',false);
        $pdfObj->Cell(222,4,'Inoperable. These do not carry any value, but can be recycled free of charge.',0,0,'',false);
        $pdfObj->Ln();

        if ($_POST['company'] == 'sourceplus'){
            $company_header = 'SourcePlus';
            $company = 'Source+';
        }else{
            $company_header = 'Tech to School';
            $company = 'Tech to School';
        }

        $pdfObj->AddPage('L','Letter');
        $pdfObj->SetFont('Arial','',10);
        $pdfObj->Cell(242,6,$company_header.' Audit Process and Transfer of Ownership',0,0,'C',false);
        $pdfObj->Ln();
        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(242,6,'Equipment Condition',0,0,'',true);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"The buyback quote amount is determined by equipment condition (i.e. Grade A - D), equipment quantity and configuration matching quoted models,",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"included accessories (Apple power adapters, keyboards, etc.) and timeframe of shipment. Deductions will be made for permanent asset tags and for",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"firmware passwords not removed. The quote amount may be modified if any of the above do not match the quote. All devices must be removed from",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"iCloud accounts and/or disowned from the Device Enrollment Program prior to shipping. Deductions may apply to locked devices.",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"$company does not have the ability to deactivate accounts on Apple devices.",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(242,6,'Data Destruction',0,0,'',true);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"All data is removed from equipment received by $company. Proof of data destruction available upon request.",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,'Payment',0,0,'',true);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"Full payment will be sent via check within 60 days of receipt of equipment unless otherwise specified.",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Ln();
        $pdfObj->SetFillColor($R,$G,$B);
        $pdfObj->Cell(242,6,'Title and Finality',0,0,'',true);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"This document represents Transfer of Ownership of the devices (listed by serial number) associated with the attached Audit Report. The sale is final and",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"title to the listed devices has transferred to $company upon equipment pickup. $company may immediately resell equipment following pickup.",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"If parties later disagree on equipment grade pricing adjustments after audit, such disagreements shall be resolved through arbitration to be conducted",0,0,'',false);
        $pdfObj->Ln();
        $pdfObj->Cell(242,6,"before JAMS. In no event will equipment be returned following pickup.",0,0,'',false);

        //The following helps to debug the logic
        $debug = false;

        if ($debug){
            $pdfObj->AddPage('L','Letter');
            $pdfObj->SetFont('Arial','',6);

            $pdfObj->SetFillColor(240);
            $fill = false;

            $order_number = '';
            //$total = 0;

            foreach ($order_summary as $summary){

                if ($summary['asset'] != $order_number){
                    $pdfObj->SetFillColor($R,$G,$B);
                    $pdfObj->Cell(20,4,$summary['asset'],0,0,'',true);
                    $pdfObj->Cell(224,4,$summary['machine_description'],0,0,'',true);
                    $pdfObj->Ln();
                    $order_number = $summary['asset'];
                    $pdfObj->SetFillColor(240);
                    $fill = false;
                }
                $pdfObj->Cell(20,4,$summary['grade_at_audit'],0,0,'',$fill);
                $pdfObj->Cell(20,4,$summary['machine_count'],0,0,'R',$fill);
                $pdfObj->Cell(20,4,$summary['price'],0,0,'R',$fill);
                $pdfObj->Cell(184,4,$summary['total'],0,0,'R',$fill);
                $pdfObj->Ln();
                $fill=!$fill;
                //$total = $total + (float)$summary['total'];
            }
            $pdfObj->Cell(60,4,'Total',0,0,'',$fill);
            $pdfObj->Cell(20,4,$total,0,0,'R',$fill);
            $pdfObj->Cell(164,4,'',0,0,'',$fill);
        }
        //end of debug code

        //Output PDF document
        $pdfObj->Output($_POST['poNumber'].' Audit.pdf','D');
    }

    function parse_checkout_form() {
        global $zohoObj, $zoho_auth_tokens;

        //set parameters to retrieve invoice numbers for drop down
        /*$parameters = array(
            'scope'     =>  'crmapi'
            ,'selectColumns'    =>  'All'//columns to select
            ,'fromIndex'        =>  1//start record
            ,'toIndex'          =>  200//end record
            ,'sortColumnString' =>  'MTS Quote Number'//sort column
            ,'searchCondition'  =>  '(Status|contains|*PO*)'//filter
        );*/

            /* Bilal: Old code block comment out
        $parameters = array(
            'scope'     =>  'crmapi'
            ,'selectColumns'    =>  'All'//columns to select
            ,'fromIndex'        =>  1//start record
            ,'toIndex'          =>  200//end record
            //,'sortColumnString' =>  'MTS Quote Number'//sort column
            ,'criteria'  =>  '((Status:PO)OR(Status:Wire Received - Waiting for Shipping))'//filter
        );

        //retrieve records for all users
        foreach($zoho_auth_tokens as $row){
            //$result = $zohoObj->getSearchRecords($row['authtoken'], $parameters,'Invoices');
            $result = $zohoObj->searchRecords($row['authtoken'], $parameters,'Invoices');
            $numberOfRecords = count($result->result->Invoices->row);
            for ($i = 0; $i < $numberOfRecords; $i++) {
                $count = count($result->result->Invoices->row[$i]->FL);
                for ($j = 0; $j < $count; $j++){
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'MTS Quote Number'){
                        $invoice_no = $result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Account Name'){
                        $account_name = $result->result->Invoices->row[$i]->FL[$j];
                    }
                    if ((string)$result->result->Invoices->row[$i]->FL[$j]->attributes()->val == 'Status'){
                        $status = $result->result->Invoices->row[$i]->FL[$j];
                    }
                }
                if ($invoice_no != '' && strpos($status, 'BB') === false){
                    $invoice_nums[$row['prefix'].$result->result->Invoices->row[$i]->FL[0]] = $invoice_no.' - '.$account_name;
                }
            }

        }
        *
        */

        $invoices = $zohoObj->getSearchRecords_BB("((Status:equals:PO) OR (Status:equals:PO received) OR (Status:equals:Wire Received - Waiting for Shipping))");
        foreach ($invoices as $invoice) {
            $invoice_no = $invoice['MTS_Quote_Number'];
            $account_name = $invoice['Account_Name'];
            $status = $invoice['Status'];
            if ($invoice_no != '' && strpos($status, 'BB') === false){
                $invoice_nums["a".$invoice['Invoice_Id']] = $invoice_no.' - '.$account_name;
            }

        }

        //sort array by mts invoice number
        array_multisort($invoice_nums,SORT_STRING);

        $zoho_select = '<option value="0">Select</option>';
        $zoho_hidden = '';

        //build mts invoice drop down
        foreach($invoice_nums as $k => $v){
            $zoho_select .= '<option value="'.$k.'">'.$v.'</option>';
            $zoho_hidden .= '<input type="hidden" name="'.$k.'" id="'.$k.'" value="'.$v.'" />'."\n";
        }

        //parse form
        $parse = array(
            'STAFF'			       => $this->arrayToHtmlSelectOptions($dd,false,$default),
            'MTS_INVOICES'         => $zoho_select,
            'ZOHO_HIDDEN'          => $zoho_hidden
        );
        return $this->parse(CHECKOUT, $parse);
    }

    function get_tracking_no($invoiceId){

        //db_select($table, $get, $cond, $extra, $join, $type, $show_error=true);

        //echo '$invoiceId<pre>'.print_r($invoiceId,true).'</pre>' ;

        $trackings = $this->db_select('ups_shipments', 'tracking_no', array('ref1' => $invoiceId),null,null,'multiple');
        /* echo 'Data<pre>'.print_r($trackings,true).'</pre>' ; */
        $trackingIds=[];
        foreach($trackings as $value){
            $trackingIds[] = $value['tracking_no'];
        }

        return implode("\n",$trackingIds);
    }

    function checkout_submit(){

        global $zohoObj, $zoho_auth_tokens, $orderObj;

        $order_numbers = explode("\n", $_POST['orderNumbers']);

        $assets = array();

        //update database and build note content
        foreach ($order_numbers as $order_number){
            $this->db_update('ds_orders', 'oNum', trim($order_number), array('cStatus' => 'Refurb - Complete'));

                $data = array(
                    'oNum'  =>  trim($order_number)
                    ,'time' => $this->format_date('db_full')
                    ,'details'  =>  'Order Status Changed to '.STATUS_REFURB_COMPLETE
                    ,'type' =>  'order_status_changed'
                    ,'userName' => $_SESSION['aUser']
                );

                $this->db_insert('ds_order_logs',$data);

                $orderObj->insert_log(trim($order_number),'','Sold to '.$_POST[$_POST['MTSInvoices']]);

                $order = $this->db_select_single('ds_orders', 'oNum,serialNumber,asset,grade', array('oNum' => trim($order_number)));

                $this->db_update('ds_orders', 'oNum', $order['oNum'], array('mts_number' => substr($_POST[$_POST['MTSInvoices']],0,8)));

                //$note_content .= $order['serialNumber']."\n";
                $serial_numbers_new[] = $order['serialNumber'];

                //create array of assets for email
                $newasset = true;
                $i = 0;

                foreach($assets as $asset){

                    //if asset exists in array, increment count
                    if ($asset['asset'] == $order['asset'] && $asset['grade'] == $order['grade']){
                        $assets[$i]['count'] = (int)$assets[$i]['count'] + 1;
                        $newasset = false;
                    }

                    $i++;

                }

                //add new asset to array
                if ($newasset){

                    $row['count'] = 1;
                    $row['asset'] = $order['asset'];
                    $row['grade'] = $order['grade'];
                    $assets[] = $row;
                }

                $ds_carts = $this->db_select_multiple('ds_carts', 'pNum', array('oNum' => $order_number));

                if ($ds_carts){

                    //create array of parts for email
                    $newasset = true;
                    $i = 0;

                    foreach($assets as $asset){

                        //if asset exists in array, increment count
                        if ($asset['asset'] == $ds_carts['pNum'] && $asset['grade'] == $order['grade']){
                            $assets[$i]['count'] = (int)$assets[$i]['count'] + 1;
                            $newasset = false;
                        }

                        $i++;

                    }

                    //add new asset to array
                    if ($newasset){

                        $row['count'] = 1;
                        $row['asset'] = $ds_carts['pNum'];
                        $row['grade'] = $order['grade'];
                        $assets[] = $row;
                    }

                }

        }

        //get user prefix

        $prefix = substr($_POST['MTSInvoices'], 0,1);

        //get zoho record id
        $zoho_id = substr($_POST['MTSInvoices'], 1);

        //determine user prefix and retrieve correct authtoken
        foreach ($zoho_auth_tokens as $k => $v){

            if ($v['prefix'] == $prefix){
                $authtoken = $v['authtoken'];
            }
        }

        //set status to shipped

        /* Bilal Modifications */
        //            $zohoObj->updateInvoice($authtoken,$zoho_id,array('Status' => 'Shipped'));
        $zohoObj->update_record_admin_4($zoho_id,array('Status' => 'Shipped'));
        //add ship date
        $ShipDate = $this->format_date('db_date',  strtotime($_POST['ShipDate']));
        //            $zohoObj->updateInvoice($authtoken,$zoho_id,array('Ship Date' => $ShipDate));
        $zohoObj->update_record_admin_4($zoho_id,array('Ship_Date' => $ShipDate));

        //insert ship method
        //            $zohoObj->updateInvoice($authtoken,$zoho_id,array('Ship Method' => $_POST['ShipMethod']));
        $zohoObj->update_record_admin_4($zoho_id,array('Ship_Method' => $_POST['ShipMethod']));

        $trackingNumbersArray = array_map('trim', $_POST['trackingNumbers']);
        $trackingNumbersArray_new = array_map('trim', explode("\n",$_POST['trackingNumbers']));

        //$trackingNumbers = implode(' ', $trackingNumbersArray);

        //update tracking numbers
        //            $zohoObj->updateInvoice($authtoken,$zoho_id,array('Tracking Number 1' => $trackingNumbers));

        //$zohoObj->update_record_admin_4($zoho_id,array('Tracking_Number_1' => $trackingNumbersArray));
        foreach($trackingNumbersArray_new as $key => $value){
            $index=$key+1;
            $zohoObj->update_record_admin_4($zoho_id,array('Tracking_Number_'.$index => $value));
        }

        //insert serial numbers
        if ($invoice[10]['value'] != 'null'){
            $serial_numbers_old = explode(' ',$invoice[10]['value']);
        }

        if (is_array($serial_numbers_old)){
            $serial_numbers = array_merge($serial_numbers_old,$serial_numbers_new);
        }else{
            $serial_numbers = $serial_numbers_new;
        }

        array_multisort($serial_numbers,SORT_STRING);

        $serial_numbers_string = implode(' ',$serial_numbers);

        //            $zohoObj->updateInvoice($authtoken,$zoho_id,array('Serial Number' => $serial_numbers_string));
        $zohoObj->update_record_admin_4($zoho_id,array('Serial_Number' => $serial_numbers_string));

        $assetout = array();

        foreach ($assets as $asset){
            if (array_key_exists($asset['asset'],$assetout)){
                if ($asset['asset'] == 'A' || $asset['asset'] == 'B' || $asset['asset'] == 'C'){
                    $assetout[$asset['asset']]['A-C']['count']+=$asset['count'];
                }else{
                    $assetout[$asset['asset']]['D']['count']+=$asset['count'];
                }
            }else{
                if ($asset['asset'] == 'A' || $asset['asset'] == 'B' || $asset['asset'] == 'C'){
                    $assetout[$asset['asset']]['A-C']['count']=$asset['count'];
                }else{
                    $assetout[$asset['asset']]['D']['count']=$asset['count'];
                }
            }
        }

        //create email body
        $body = '<table>';

        /*foreach ($assets as $asset){
            $body .= '<tr><td>'.$asset['count'].' qty'.'</td><td>'.$asset['asset'].'</td><td>'.$asset['grade'].'</td></tr>';
        }*/

        foreach ($assetout as $k => $v){
            if (array_key_exists('A-C', $v)){
                $body .= '<tr><td>'.$v['A-C']['count'].' qty'.'</td><td>'.$k.'</td></tr>';
            }
            if (array_key_exists('D', $v)){
                $body .= '<tr><td>'.$v['D']['count'].' qty'.'</td><td>'.$k.'-D</td></tr>';
            }
        }

        $body .= '</table>';

        $invoice_id = $_POST['MTSInvoices'];
        $mts_str = $_POST[$invoice_id];

        $subject = substr($mts_str,0,8).' Shipped Items';

        //send email
        $this->send_email(TERRY_EMAIL, INFO_FROM, $subject, $body,'text/html',array(),JUSTIN_EMAIL.','.MCNIFF_EMAIL);

        //return new check out form
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse_checkout_form()));

    }

    function parse_ms_checkout_form() {
		return $this->parse(MS_CHECKOUT, array());
	}

    function ms_checkout_submit(){

        $order_numbers = $_POST['ms1'];

        //update database and build note content
        foreach ($order_numbers as $order_number){

            $data = array(
                'oNum'  =>  trim($order_number)
                ,'time' => $this->format_date('db_full')
                ,'details'  =>  'Order Checked Out'
                ,'type' =>  'order_status_changed'
                ,'userName' => $_POST['cboUser']
            );

            $this->db_insert('ds_order_logs',$data);

        }

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(MS_CHECKOUT, array())));

    }


    private function update_order_detail($order_numbers, $field, $value){

        foreach ($order_numbers as $order_number){

            $this->db_update('ds_orders', 'oNum', trim($order_number), array($field => $value));
        }

	}

	private function update_order_detail_new($inputNumbers, $ipadData, $macData) {
		$serialNums = array();
		$oNums = array();
		$this->divideSPAndSerialNums($inputNumbers, $oNums, $serialNums);
		$serialInClause = $this->build_in_clause($serialNums);
		if (count($serialNums) < 1) {
			$serialInClause = "('NOSERIALSFOUND')";
		}
		$oNumInClause = $this->build_in_clause($oNums);
		if (count($oNums) < 1) {
			$oNumInClause = "('NOONUMSFOUND')";
		}
		if (count($ipadData) > 0) {
			$ipadSetClause = $this->build_update_set_clause($ipadData);
			$ipadQuery = "UPDATE ds_orders SET $ipadSetClause WHERE is_ipad = 1 AND (oNum IN $oNumInClause OR serialNumber IN $serialInClause);";
			$ipadLinesAffected = $this->db_query($ipadQuery, 'update', true);
		}
		if (count($macData) > 0) {
			$macSetClause = $this->build_update_set_clause($macData);
			$macQuery = "UPDATE ds_orders SET $macSetClause WHERE (is_ipad IS NULL OR is_ipad != 1) AND (oNum IN $oNumInClause OR serialNumber IN $serialInClause);";
			$macLinesAffected = $this->db_query($macQuery, 'update', true);
		}
	}

    private function update_audit_summary($order_numbers){

        global $orderObj;

        foreach ($order_numbers as $order_number){

            $order = $orderObj->get_data(trim($order_number));

            $audit_summary = '';

            if ($order['keyboard'] == 'fail'){
                $audit_summary .= 'Keyboard - fail. ';
            }
            if ($order['trackpad'] == 'fail'){
                $audit_summary .= 'Trackpad - fail. ';
            }
            if ($order['optical'] == 'fail'){
                $audit_summary .= 'Optical - fail. ';
            }
            if ($order['lcd'] == 'fail'){
                $audit_summary .= 'Screen - fail. ';
            }
            if ($order['glass'] == 'fail'){
                $audit_summary .= 'Glass - fail. ';
            }
            if ($order['ports'] == 'fail'){
                $audit_summary .= 'Ports - fail. ';
            }
            if ($order['wifi'] == 'fail'){
                $audit_summary .= 'Wifi - fail. ';
            }
            if ($order['speakers'] == 'fail'){
                $audit_summary .= 'Speakers - fail. ';
            }
            if ($order['isight'] == 'fail'){
                $audit_summary .= 'iSight - fail. ';
            }
            if ($order['enet'] == 'fail'){
                $audit_summary .= 'Ethernet port - fail. ';
            }
            if ($order['battery'] == 'fail'){
                $audit_summary .= 'Battery - fail. ';
            }
            if ($order['home_button'] == 'fail'){
                $audit_summary .= 'Home button - fail. ';
            }
            if ($order['volume'] == 'fail'){
                $audit_summary .= 'Volume up/down - fail. ';
            }
            if ($order['sleep_wake'] == 'fail'){
                $audit_summary .= 'Sleep/wake - fail. ';
            }
            if ($order['silent_rot'] == 'fail'){
                $audit_summary .= 'Silent switch - fail. ';
            }
            if ($order['headphone'] == 'fail'){
                $audit_summary .= 'Headphone jack - fail. ';
            }
            if ($order['front_camera'] == 'fail'){
                $audit_summary .= 'Front camera - fail. ';
            }
            if ($order['rear_camera'] == 'fail'){
                $audit_summary .= 'Rear camera - fail. ';
            }
            if ($order['speaker'] == 'fail'){
                $audit_summary .= 'Speaker - fail. ';
            }
            if ($order['mic'] == 'fail'){
                $audit_summary .= 'Microphone - fail. ';
            }
            if ($order['charge'] == 'fail'){
                $audit_summary .= 'Charge - fail. ';
            }
            if ($order['wifi_ipad'] == 'fail'){
                $audit_summary .= 'Wifi - fail. ';
            }
            if ($order['case_scratches'] != ''){
                $audit_summary .= 'Case scratches - '.$order['case_scratches'].'. ';
            }
            if ($order['case_cdents'] != ''){
                $audit_summary .= 'Corner dents - '.$order['case_cdents'].'. ';
            }
            if ($order['case_sdents'] != ''){
                $audit_summary .= 'Surface dents - '.$order['case_sdents'].'. ';
            }
            if ($order['case_scratches2'] != ''){
                $audit_summary .= 'Case scratches - '.$order['case_scratches2'].'. ';
            }
            if ($order['case_cdents2'] != ''){
                $audit_summary .= 'Corner dents - '.$order['case_cdents2'].'. ';
            }
            if ($order['case_sdents2'] != ''){
                $audit_summary .= 'Surface dents - '.$order['case_sdents2'].'. ';
            }
            if ($order['case_edents'] != ''){
                $audit_summary .= 'Edge dents - '.$order['case_edents'].'. ';
            }
            if ($order['case_cracks'] != ''){
                $audit_summary .= 'Case cracks - '.$order['case_cracks'].'. ';
            }
            if ($order['LCD_scratches'] != ''){
                $audit_summary .= 'Screen scratches - '.$order['LCD_scratches'].'. ';
            }
            if ($order['lcd_dust'] != ''){
                $audit_summary .= 'Dust/Dirt under glass - '.$order['lcd_dust'].'. ';
            }
            if ($order['lcd_white'] != ''){
                $audit_summary .= 'White spots - '.$order['lcd_white'].'. ';
            }
            if ($order['case_keymarks'] != ''){
                $audit_summary .= 'Keyboard marks - '.$order['case_keymarks'].'. ';
            }
            if ($order['digi_scratches'] != ''){
                $audit_summary .= 'Screen scratches - '.$order['digi_scratches'].'. ';
            }
            if ($order['digi_dust'] == 1){
                $audit_summary .= 'Dust/Dirt under digitizer. ';
            }
            if ($order['digi_white'] == 1){
                $audit_summary .= 'White spots on screen. ';
            }
            if ($order['hinge'] == 1){
                $audit_summary .= 'Loose hinge. ';
            }
            if ($order['refurb_keys'] == 1){
                $audit_summary .= 'Missing keys. ';
            }
            if ($order['case_track'] == 1){
                $audit_summary .= 'Trackpad misaligned. ';
            }
            if ($order['digi_lines'] == 1){
                $audit_summary .= 'Lines on screen. ';
            }
            if ($order['digi_un'] == 1){
                $audit_summary .= 'Touchscreen unresponsive. ';
            }
            if ($order['digi_dis'] == 1){
                $audit_summary .= 'Screen discolored. ';
            }
            if ($order['digi_sep'] == 1){
                $audit_summary .= 'Digitizer separation. ';
            }
            if ($order['digi_touch'] == 1){
                $audit_summary .= 'LCD/Digi touching. ';
            }
            if ($order['digi_video'] == 1){
                $audit_summary .= 'Video issue. ';
            }
            if ($order['digitizer_crack'] == 1){
                $audit_summary .= 'Cracked screen. ';
            }
            if ($order['marking'] == 1){
                $audit_summary .= 'Engraving/Permanent Markings. ';
            }
            if ($order['boot_failure'] == 1){
                $audit_summary .= 'Logic Failure. ';
            }
            if ($order['hd_failure'] == 1){
                $audit_summary .= 'HD Failure. ';
            }

            if ($order['refurb_notes'] != ''){
                $audit_summary .= $order['refurb_notes'].'.';
            }

            $this->db_update('ds_orders', 'oNum', trim($order_number), array('audit_summary' => $audit_summary));

        }

    }

	private function update_audit_summary_new($order_numbers, $ipadData, $macData) { // TODO - currently not called anywhere
		$serialNums = array();
		$oNums = array();
		$this->divideSPAndSerialNums($inputNumbers, $oNums, $serialNums);
		$serialInClause = $this->build_in_clause($serialNums);
		if (count($serialNums) < 1) {
			$serialInClause = "('NOSERIALSFOUND')";
		}
		$oNumInClause = $this->build_in_clause($oNums);
		if (count($oNums) < 1) {
			$oNumInClause = "('NOONUMSFOUND')";
		}
	}

    function mass_order_update(){

        global $dd_data, $hdvolumes, $ramvolumes, $ipadcapacities, $ios_versions, $osx_versions;

        if ($_POST['save']){
			$useOldCode = false; // Switch this to true to use the old, slower code, in case of issues
			$order_numbers = explode("\n", $_POST['txtOrderNumbers']);

			$submitted = $_POST;

			if ($useOldCode) {
				$this->update_multiple_status($order_numbers, $_POST['cboStatus'], $_POST['txtNote']);

				$update_order = true;

				foreach ($submitted as $k => $v){

					if ($v != '' && $k != 'cboStatus' && $k != 'save' && $k != 'txtOrderNumbers' && $k != 'txtNote' && $k != 'reprint_tags'){
						if ($v == 'on'){
							$v = 1;
						}

						if ($k == 'ios_version'){
							$k = 'os_version';
						}

						if ($k == 'logic_failure_osx' || $k == 'logic_failure_ipad'){
							$k = 'boot_failure';
						}

						if ($k == 'activation_lock'){
							if ($v == 'No Change'){
								$update_order = false;
							}
							if ($v == 'On'){
								$v = 1;
							}
							if ($v == 'Off'){
								$v = 0;
							}
						}

						if ($k == 'mdm_lock'){
							if ($v == 'No Change'){
								$update_order = false;
							}
							if ($v == 'On'){
								$v = 1;
							}
							if ($v == 'Off'){
								$v = 0;
							}
						}

						if ($update_order){
							$this->update_order_detail($order_numbers, $k, $v);
						}

					}

					$update_order = true;

				}
			} else {
				if ($_POST['cboStatus'] && $_POST['cboStatus'] != '') {
					$this->update_multiple_status_new($order_numbers, $_POST['cboStatus'], $_POST['txtNote']);
				}
				$ipadData = array();
				$macData = array();
				foreach ($submitted as $k => $v) {
					if ($v != '') {
						if ($this->is_ipad_field($k)) {
							$ipadData[$this->correct_field_name($k)] = $this->correct_field_value($v);
						}
						if ($this->is_mac_field($k)) { // Not elseif, because there is overlap, so all need to be evaluated
							$macData[$this->correct_field_name($k)] = $this->correct_field_value($v);
						}
						if ($this->is_activation_status_field($k)) {
							if ($v != 'No Change') {
								$ipadData[$k] = $this->correct_field_value($v);
								$macData[$k] = $this->correct_field_value($v);
							}
						}
					}
				}
				$this->update_order_detail_new($order_numbers, $ipadData, $macData);
				if ($_POST['unable_to_unlock'] == 'on') {
					foreach ($order_numbers as $orderNum) {
						$orderNum = trim($orderNum);
						$sql = "UPDATE `ds_orders` SET `refurb_notes` = CASE WHEN `refurb_notes` IS NULL OR `refurb_notes` = '' THEN 'Unable to unlock.' ELSE CONCAT_WS('. ', `refurb_notes`, 'Unable to unlock.') END WHERE (`oNum`='$orderNum' OR `serialNumber`='$orderNum') AND `refurb_notes` NOT LIKE '%Unable to unlock%';";
						$this->db_query($sql, 'update', true);
					}
				}
			}

            $this->update_audit_summary($order_numbers);

            /*if ($_POST['grade'] != ''){
                $this->update_($order_numbers, 'grade', $_POST['grade']);
            }

            if ($_POST['machine'] != ''){
                $this->update_order_detail($order_numbers, 'machineType', $_POST['machine']);
            }

            if ($_POST['asset'] != ''){
                $this->update_order_detail($order_numbers, 'asset', $_POST['asset']);
            }

            if ($_POST['ponumber'] != ''){
                $this->update_order_detail($order_numbers, 'poNumber', $_POST['ponumber']);
            }

            if ($_POST['hd_1'] != ''){
                $this->update_order_detail($order_numbers, 'hd_1', $_POST['hd_1']);
            }

            if ($_POST['hd_2'] != ''){
                $this->update_order_detail($order_numbers, 'hd_2', $_POST['hd_2']);
            }

            if ($_POST['ram_1'] != ''){
                $this->update_order_detail($order_numbers, 'ram_1', $_POST['ram_1']);
            }

            if ($_POST['ram_2'] != ''){
                $this->update_order_detail($order_numbers, 'ram_2', $_POST['ram_2']);
            }

            if ($_POST['ram_3'] != ''){
                $this->update_order_detail($order_numbers, 'ram_3', $_POST['ram_3']);
            }

            if ($_POST['ram_4'] != ''){
                $this->update_order_detail($order_numbers, 'ram_4', $_POST['ram_4']);
            }*/

            if ($_POST['reprint_tags']){
                foreach ($order_numbers as $order_number){
                    $this->reprint_refurb_label(trim($order_number));
                }
            }

        }

        if ($_POST['export']){

            global $searchObj;

            $order_numbers = explode("\n", $_POST['txtOrderNumbers']);

            foreach ($order_numbers as $order_number){
                if (strlen(trim($order_number)) > 8){
                    $order = $this->db_select_single('ds_orders', 'oNum', array('serialNumber' => trim($order_number)));
                    $order_number = $order['oNum'];
                }
                $output_orders[] = trim(substr($order_number, 2));
            }

            $searchObj->export_details($output_orders);

		}

		if ($_POST['audit_export']) {
			global $searchObj;
			$orderNumbers = explode("\n", $_POST['txtOrderNumbers']);

			$searchObj->massOrderAuditExport($orderNumbers, false);
		}

        if ($_POST['reprint']){

            $order_numbers = explode("\n", $_POST['txtOrderNumbers']);

            foreach ($order_numbers as $order_number){
                if (strlen(trim($order_number)) > 8){
                    $order = $this->db_select_single('ds_orders', 'oNum', array('serialNumber' => trim($order_number)));
                    $order_number = $order['oNum'];
                }
                $this->reprint_refurb_label(trim($order_number));
            }

        }

        $capacities = '<option></option>';

        foreach ($ipadcapacities as $capacity){
            if ($capacity == $data['capacity']){
                $capacities .= '<option selected>'.$capacity.'</option>';
            }else{
                $capacities .= '<option>'.$capacity.'</option>';
            }
        }

        $ios = '<option></option>';

        foreach ($ios_versions as $os){

            $ios .= '<option>'.$os.'</option>';
            }

            $oss = '<option></option>';

        foreach ($osx_versions as $os){

            $oss .= '<option>'.$os.'</option>';

        }

        $scratches = array('Minor','Moderate','Major');
        $scratches2 = array('Minor','Major');

        $scratches_opt = '<option></option>';
        foreach ($scratches as $scratch){

            $scratches_opt .= '<option>'.$scratch.'</option>';
            }

        $scratches_2_opt = '<option></option>';
        foreach ($scratches2 as $scratch){

            $scratches_2_opt .= '<option>'.$scratch.'</option>';

        }

        $hds = '<option></option>';

        foreach ($hdvolumes as $k => $v){
            $hds .= '<option>'.$k.'</option>';
        }

        $rams = '<option></option>';

        foreach ($ramvolumes as $k => $v){
            $rams .= '<option>'.$k.'</option>';
        }

        $machines = $this->db_select_multiple('machine_lookup', 'machine_description', array(), 'order by machine_description');

        foreach($machines as $machine){
            if ($machine['machine_description'] != ''){
                $dd_machine .= '<option>'.$machine['machine_description'].'</option>';
            }
        }

        $parse = array(
            'STATII'    => $dd_data['STATII']
            ,'RAM'      => $rams
            ,'HD'       => $hds
            ,'MACHINE'  => $dd_machine
            ,'CASE_SCRATCHES'    => $scratches_2_opt
            ,'CASE_CDENTS'    => $scratches_opt
            ,'CASE_SDENTS'    => $scratches_2_opt
            ,'CASE_SCRATCHES2'    => $scratches_2_opt
            ,'CASE_CDENTS2'    => $scratches_opt
            ,'CASE_SDENTS2'    => $scratches_opt
            ,'CASE_EDENTS'    => $scratches_opt
            ,'CASE_CRACKS'    => $scratches_opt
            ,'LCD_SCRATCHES'    => $scratches_opt
            ,'LCD_DUST'    => $scratches_2_opt
            ,'LCD_WHITE'    => $scratches_2_opt
            ,'CASE_KEYMARKS'    => $scratches_opt
            ,'DIGI_SCRATCHES'   => $scratches_opt
            ,'CAPACITY' => $capacities
            ,'IOS'  => $ios
            ,'OS'   => $oss
        );

        echo $this->parse(TEMPLATE,array('BODY' => $this->parse(MASS_ORDER_UPDATE,$parse), "TITLE" => "Mass Order Update"));

	}

	function update_multiple_status_new($data,$newStatus,$note='') {
		global $orderObj;
		$oNumArray = array();
		foreach ($data as $oNum) {
			array_push($oNumArray, $oNum);
		}
		$orderObj->bulk_update_status($oNumArray, $newStatus, $note);


		// foreach ($data as $oNum){
		// 	if (strlen($oNum) > 8){
		// 		$order = $this->db_select_single('ds_orders', 'oNum', array('serialNumber' => $oNum));
		// 		$oNum = $order['oNum'];
		// 	}
		// 	if ($new_status != ''){
		// 		$orderObj->update_status(trim($oNum),$new_status);
		// 	}
		// 	if ($note != ''){
		// 		$this->db_update('ds_orders', 'oNum', trim($oNum), array('cShipInstruct' => "concat(cShipInstruct, '\n" . mysql_real_escape_string($note) . '\')'));
		// 	}
		// }
	}

    function ebay_shipping(){

        if ($_POST){

            global $upsObj, $ebayObj, $ups_ship_from;

            $dataset = $_POST['data'];

            $from = $ups_ship_from['SourcePlus'];

            $output = '';

            foreach ($dataset as $data){
                if ($data['ship'] && $data['sku'] != '' && $data['weight'] != ''){

                    $result = $upsObj->ship_worldship('Worldship',$from,$data,'03',$data['weight'],'','',false,false,0,0,$data['ref1'],$data['ref2']);

                    if (!$result[0]['tracking']){
                        $validate_data = array(
                            'name'      =>  $data['name'],
                            'cShipAddress1' =>  $data['address1'],
                            'cShipAddress2' =>  $data['address2'],
                            'cShipCity'     =>  $data['city'],
                            'cShipZip'      =>  $data['zip'],
                            'cShipCountry'  =>  'US'
                        );

                        $valid_address = $upsObj->verify_address($validate_data, true);

                        if ($valid_address){
                            $data['city'] = $valid_address->Address->City;
                            $data['state'] = $valid_address->Address->StateProvinceCode;

                            $result = $upsObj->ship_worldship('Worldship',$from,$data,'03',$data['weight'],'','',false,false,0,0,$data['ref1'],$data['ref2']);
                        }

                    }

                    $trackingno = (string)$result[0]['tracking'];

                    if ($trackingno != ''){
                        if (MODE != 'DEV'){
                            $response = $ebayObj->AddTrackingInfo($data['OrderID'],$trackingno,'UPS');
                        }

                        $db_data = array(
                            'order_id'  =>  $data['OrderID']
                            ,'user_id'  =>  $data['UserID']
                            ,'email'    =>  $data['email']
                            ,'user_name'     =>  $data['name']
                            ,'street1'      =>  $data['address1']
                            ,'street2'      =>  $data['address2']
                            ,'city'         =>  $data['city']
                            ,'state'        =>  $data['state']
                            ,'zip'          =>  $data['zip']
                            ,'item'         =>  $data['item']
                            ,'quantity'     =>  $data['quantity']
                            ,'total_value'  =>  $data['total']
                            ,'weight'       =>  $data['weight']
                            ,'tracking_number'  =>  $trackingno
                            ,'ship_date'    => $this->format_date('db_date')
                            ,'ebay_response'    => (string)$response->Ack
                            ,'sku'          => $data['sku']
                            ,'price'        => $data['price']
                            ,'fee'          => $data['fee']
                            ,'phone'        => $data['phone']
                            ,'tax'          => $data['tax']
                            ,'record_number'    => $data['record_number']
                            ,'payment_date' => substr($data['payment_date'],0,10)
                        );

                        $this->db_insert('ebay_orders', $db_data);

                        $output .= '<tr>'
                            .'<td class="small" valign="top">'.substr($data['OrderID'],0,12).'</td>'
                            .'<td class="small" valign="top">'.$data['UserID'].'</td>'
                            .'<td class="small" valign="top">'.$data['email'].'</td>'
                            .'<td class="small" valign="top">'.$data['name'].'</td>'
                            .'<td class="small" valign="top">'.$trackingno.'</td>';

                    }else{

                        $output .= '<tr>'
                            .'<td class="small" valign="top">'.substr($data['OrderID'],0,12).'</td>'
                            .'<td class="small" valign="top">'.$data['UserID'].'</td>'
                            .'<td class="small" valign="top">'.$data['email'].'</td>'
                            .'<td class="small" valign="top">'.$data['name'].'</td>'
                            .'<td class="small" valign="top">Invalid address, not shipped.</td>';
                    }

                }
            }

            if ($output != ''){

                $header = '

                                <table width="95%" align="center" cellpadding="0" cellspacing="5">

                                        <tr>
                                                <td class="subheading1">Item Number</td>
                                                <td class="subheading1">User ID</td>
                                                <td class="subheading1">Buyer Email</td>
                                                <td class="subheading1">Buyer Full Name</td>
                                                <td class="subheading1">Tracking Number</td>
                                        </tr>
                        ';

                $footer = '</table>';

                $parse = $header.$output.$footer;
            }else{
                $parse = 'No items shipped.';
            }

            echo $this->parse(TEMPLATE, array('BODY' => $parse));
            exit;

        }

        $header = '
            <form method="post" name="ebay_shipping" id="ebay_shipping" action="admin_controller.php?m=ebay_shipping">

            <table width="95%" align="center" cellpadding="0" cellspacing="5">

                    <tr>
                            <td colspan="14" align="right"><input type="submit" value="ship"/></td>
                    </tr>

                    <tr>
                            <td class="subheading1">Item Number</td>
                            <td class="subheading1">User ID</td>
                            <td class="subheading1">Buyer Email</td>
                            <td class="subheading1">Buyer Full Name</td>
                            <td class="subheading1">Buyer Address</td>
                            <td class="subheading1">City</td>
                            <td class="subheading1">State</td>
                            <td class="subheading1">ZIP</td>
                            <td class="subheading1">Phone Number</td>
                            <td class="subheading1">Item Name</td>
                            <td class="subheading1" align="right">Quantity</td>
                            <td class="subheading1" align="right">Total</td>
                            <td class="subheading1">SKU</td>
                            <td class="subheading1" align="right">Weight</td>
                            <td class="subheading1">Ship UPS</td>
                    </tr>
                ';

        $output = '';
        $hidden = '';
        $rows = 0;

        $this->get_ebay_orders($output,$hidden,$rows);

        $footer = '</table>';

        $end = '</form>';

        echo $this->parse(TEMPLATE, array('BODY' => $header.$output.$footer.$hidden.$end));

    }

    private function get_ebay_orders(&$output,&$hidden,&$rows,$page = false){

        global $ebayObj;

        if (!$page){
            $eBayOrders = $ebayObj->GetOrders(14);
        }else{
            $eBayOrders = $ebayObj->GetOrders(14,$page);
        }

        foreach ($eBayOrders->OrderArray->Order as $eBayOrder){

            if (!$eBayOrder->ShippedTime && $eBayOrder->CheckoutStatus->PaymentMethod == 'PayPal' && $eBayOrder->CheckoutStatus->Status == 'Complete'){
                $output .= '<tr>'
                        .'<td class="small" valign="top">'.substr($eBayOrder->OrderID,0,12).'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->BuyerUserID.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->TransactionArray->Transaction->Buyer->Email.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->Name.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->Street1.' '.$eBayOrder->ShippingAddress->Street2.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->CityName.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->StateOrProvince.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->PostalCode.'</td>'
                        .'<td class="small" valign="top">'.$eBayOrder->ShippingAddress->Phone.'</td>'
                        .'<td class="small" valign="top">'.html_entity_decode($eBayOrder->TransactionArray->Transaction->Item->Title).'</td>'
                        .'<td class="small" valign="top" align="right">'.$eBayOrder->TransactionArray->Transaction->QuantityPurchased.'</td>'
                        .'<td class="small" valign="top" align="right">$'.number_format((float)$eBayOrder->Total,2).'</td>'
                        .'<td class="small" valign="top" align="right"><input type="textbox" class="borderless" name="data['.$rows.'][sku]" /></td>'
                        .'<td class="small" valign="top" align="right"><input type="textbox" class="borderless" style="width:50px;" name="data['.$rows.'][weight]" /></td>'
                        .'<td class="small" valign="top" align="right"><input type="checkbox" id="ship" name="data['.$rows.'][ship]" /></td>'
                        .'</tr>';
                $hidden .= '<input type="hidden" name="data['.$rows.'][OrderID]" value="'.$eBayOrder->OrderID.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][UserID]" value="'.$eBayOrder->BuyerUserID.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][company]" value="'.$eBayOrder->ShippingAddress->Name.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][name]" value="'.$eBayOrder->ShippingAddress->Name.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][address1]" value="'.$eBayOrder->ShippingAddress->Street1.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][address2]" value="'.$eBayOrder->ShippingAddress->Street2.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][city]" value="'.$eBayOrder->ShippingAddress->CityName.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][state]" value="'.$eBayOrder->ShippingAddress->StateOrProvince.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][zip]" value="'.$eBayOrder->ShippingAddress->PostalCode.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][phone]" value="'.$eBayOrder->ShippingAddress->Phone.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][email]" value="'.$eBayOrder->TransactionArray->Transaction->Buyer->Email.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][item]" value="'.$eBayOrder->TransactionArray->Transaction->Item->Title.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][quantity]" value="'.$eBayOrder->TransactionArray->Transaction->QuantityPurchased.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][price]" value="'.number_format((float)$eBayOrder->TransactionArray->Transaction->TransactionPrice,2).'"/>'
                        .'<input type="hidden" name="data['.$rows.'][total]" value="'.number_format((float)$eBayOrder->Total,2).'"/>'
                        .'<input type="hidden" name="data['.$rows.'][fee]" value="'.number_format((float)$eBayOrder->MonetaryDetails->Payments->Payment->FeeOrCreditAmount,2).'"/>'
                        .'<input type="hidden" name="data['.$rows.'][ref1]" value="'.substr($eBayOrder->OrderID,0,12).'"/>'
                        .'<input type="hidden" name="data['.$rows.'][ref2]" value="'.$eBayOrder->BuyerUserID.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][tax]" value="'.$eBayOrder->ShippingDetails->SalesTax->SalesTaxAmount.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][record_number]" value="'.$eBayOrder->ShippingDetails->SellingManagerSalesRecordNumber.'"/>'
                        .'<input type="hidden" name="data['.$rows.'][payment_date]" value="'.$eBayOrder->MonetaryDetails->Payments->Payment->PaymentTime.'"/>';
                $rows++;
            }
        }

        if (!$page){
            $totalPages = (int)$eBayOrders->PaginationResult->TotalNumberOfPages;

            if ($totalPages > 1){
                for($i=2;$i<=$totalPages;$i++){
                    $this->get_ebay_orders($output,$hidden,$rows,$i);
                }
            }
        }

    }

    function file_exports(){

        if ($_POST['submit']){

            $datefrom = strtotime($_POST['txtdatefrom']);
            $dateto = strtotime($_POST['txtdateto']);

            $day = $datefrom;

            while ($day <= $dateto){
                $datearray[] = date('Y-m-d',$day);
                $day = $day + (60*60*24);
            }

            foreach ($datearray as $date){


                if ($_POST['chkorder_customers']){

                    /*$execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));*/

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexport customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));
                }

                if ($_POST['chkorder_orders']){

                    /*$execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));*/

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));


                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));


                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders1 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '30'));
                }

                if ($_POST['chkorder_nopo']){

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports nopo '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports nopo '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders2 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '30'));
                }

                if ($_POST['chkorder_hardware']){

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexports nosku '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders3 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '30'));
                }

                if ($_POST['chkorder_hardware_nopo']){


                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports nopohardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports nopohardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders4 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '30'));
                }

                if ($_POST['chkebay_paypal']){

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexport paypal '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));
                }

                if ($_POST['chk_all']){
        //                        echo "coming here" . $date;
                    /*$execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));*/

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexport customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports customers '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    /*$execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '60'));*/

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));


                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));


                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports orders '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders1 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '60'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports nopo '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports nopo '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders2 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '60'));

                    /*$execstr = 'php /var/www/vhosts/macservice.com/httpdocs/store/cron.php shop_hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));*/

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com ebayorderexports nosku '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports hardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders3 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '60'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com orderexports nopohardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com zohoorderexports nopohardware '.$date;
                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '10'));

                    $execstr = 'php /var/www/vhosts/macservice.com/httpdocs/service_controller.php macservice.com mergeexports orders4 '.$date;

                    $this->db_insert('cron_queue', array('cron_queue_command' => $execstr,'delay' => '30'));

                }

            }

        }

        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(FILE_EXPORTS,array())));

    }

    function keyboard_test(){

        if ($_GET['type'] == 'small'){

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(KEYBOARD_SMALL,array())));

        }else{

            echo $this->parse(TEMPLATE, array('BODY' => $this->parse(KEYBOARD_LARGE,array())));

        }

    }

    function serial_number_lookup($data){

        if ($data['update']){

            $i = 0;

            foreach ($data['order_number_insert'] as $order_number){

                if ($order_number != ''){
                    //create machine_order_number record
                    $order_number_id = (int)$this->db_insert('machine_order_number',array('order_number' => $order_number,'machine_id' => $data['machine_id'][$i],'enabled' => 1));

                    $product_model = $this->db_select_single('product_model', 'product_model_id',array('configCode' => $data['config_code_insert'][$i],'machine_id' => $data['machine_id'][$i]));

                    if ($product_model){
                        //update product_model record
                        $this->db_update('product_model', 'product_model_id', $product_model['product_model_id'], array('order_number_id' => $order_number_id));
                    }else{
                        //create product_model record
                        $product_model = $this->db_insert('product_model', array('configCode' => $data['config_code_insert'][$i],'machine_id' => $data['machine_id'][$i],'order_number_id' => $order_number_id));
                    }

                }

                $i++;
            }

        }

        //check if this is an add
        if ($data["add"]){

            $i = 0;

            foreach ($data['model_number'] as $model_number){

                $machine_order_number = $this->db_select_single('machine_order_number', '*', array('order_number' => $data['order_number'][$i]));
                $machine_lookup = $this->db_select_single('machine_lookup', '*', array('model_number' => $model_number,'machine_description' => $data['machine_description'][$i]));

                //check for machine_lookup record and create if not exist
                if ($machine_lookup){
                    $machine_id = (int)$machine_lookup['machine_id'];
                }else{
                    $machine_id = (int)$this->db_insert('machine_lookup', array('model_number' => $model_number,'machine_description' => $data['machine_description'][$i],'enabled' => 1));
                }

                //check for machine_order_number and create if not exist
                if ($machine_order_number){
                    $order_number_id = (int)$machine_order_number['order_number_id'];
                }else{
                    $order_number_id = (int)$this->db_insert('machine_order_number',array('order_number' => $data['order_number'][$i],'machine_id' => $machine_id,'enabled' => 1));
                }

                //create product_model record
                $product_model = $this->db_insert('product_model', array('configCode' => $data['config_code'][$i],'machine_id' => $machine_id,'order_number_id' => $order_number_id));

                $i++;
            }

        }

        //check if this is a submit
        if ($data['submit'] || $data['add'] || $data['export'] || $data['update']){

			// Check to handle if it's space delimited rather than newline delimited
			$data['serialNumbers'] = str_replace(' ', PHP_EOL, $data['serialNumbers']);
            //create array of serial numbers
            $serialNumbers = explode(PHP_EOL,$data['serialNumbers']);

            $configCodes = array();

            //step through the serial numbers and create the array of config codes and counts
            foreach ($serialNumbers as $serialNumber){
                if (strlen(trim($serialNumber)) < 13){
                    $configCode = substr(trim($serialNumber),8);
                    if (array_key_exists($configCode, $configCodes)){
                        $configCodes[$configCode]['count'] = $configCodes[$configCode]['count'] + 1;
                    }else{
                        $configCodes[$configCode]['count'] = 1;
                    }
                }else{
                    $configCode = substr(trim($serialNumber),9);
                    if (array_key_exists($configCode, $configCodes)){
                        $configCodes[$configCode]['count'] = $configCodes[$configCode]['count'] + 1;
                    }else{
                        $configCodes[$configCode]['count'] = 1;
                    }
                }
                //add serial numbers to array
                $configCodes[$configCode]['serialNumbers'][] = trim($serialNumber);
            }

            //sort the array
            arsort($configCodes);

            $errors = '';
            $i = 0;

            //retrieve machine info, if in database
            foreach ($configCodes as $k => $v){

                $sql = 'SELECT ml.machine_id, ml.machine_description, ml.model_number, mon.order_number, mon.order_number_id
                    FROM product_model pm
                    left join machine_order_number mon on mon.order_number_id = pm.order_number_id
                    left join machine_lookup ml on pm.machine_id = ml.machine_id
                    where configCode = "'.$k.'"';

                $result = $this->db_query($sql, 'select-single');

                if ($result){

                    $configCodes[$k]['machine_id'] = $result['machine_id'];
                    $configCodes[$k]['order_number_id'] = $result['order_number_id'];
                    $configCodes[$k]['machine_description'] = $result['machine_description'];
                    $configCodes[$k]['model_number'] = $result['model_number'];
                    $configCodes[$k]['order_number'] = $result['order_number'];

                    //check if this matches another record in array and merge count if it does
                    foreach ($configCodes as $key => $value){

                        if (($configCodes[$key]['machine_description'] == $configCodes[$k]['machine_description']
                            && $configCodes[$key]['model_number'] == $configCodes[$k]['model_number']
                            && $configCodes[$key]['order_number'] == $configCodes[$k]['order_number'])
                            && $key != $k){
                            $configCodes[$key]['count'] = $configCodes[$key]['count'] + $configCodes[$k]['count'];
                            unset($configCodes[$k]);
                        }
                    }

                    arsort($configCodes);

                }else{

                    //if no machine info, add lines to error table
                    foreach($configCodes[$k]['serialNumbers'] as $sn){

                        if (strlen(trim($sn)) < 13){
                            $configCode = substr(trim($sn),8);
                        }else{
                            $configCode = substr(trim($sn),9);
                        }

                        $errors .= '<tr>';
                        $errors .= '<td><a href="http://www.everymac.com/ultimate-mac-lookup/?search_keywords='.$sn.'" target="_blank">'.$sn.'</a></td>';
                        $errors .= '<td><input type="text" name="model_number['.$i.']" class="borderless" /></td>';
                        $errors .= '<td><input type="text" name="order_number['.$i.']" class="borderless" /></td>';
                        $errors .= '<td><input type="text" name="machine_description['.$i.']" class="borderless" /><input type="hidden" name="config_code['.$i.']" value="'.$configCode.'" /></td>';
                        $errors .= '</tr>';
                        $i++;

                    }

                }

            }

            $table = '';
            $export = '';
            $sum = 0;

            //create result table
            foreach ($configCodes as $k => $configCode){

                if ($configCode['model_number']){
                    $table .= '<tr>';
                    $table .= '<td style="padding:0px 10px 0px 5px"><a href="'.CONTROLLER.'?m=machine_detail&machine_id='.$configCode['machine_id'].'" target="_blank">'.$configCode['model_number'].'</a></td>';
                    $table .= '<td style="padding:0px 10px 0px 5px">'.$configCode['count'].'</td>';
                    if ($configCode['order_number'] != ''){
                        $table .= '<td style="padding:0px 10px 0px 5px"><a href="'.CONTROLLER.'?m=order_number_edit&order_number_id='.$configCode['order_number_id'].'" target="_blank">'.$configCode['order_number'].'</a></td>';
                    }else{
                        $table .= '<td style="padding:0px 10px 0px 5px"><input type="text" name="order_number_insert[]" class="borderless" style="width:100px;" />'
                                .'<input type="hidden" name="machine_id[]" value="'.$configCode['machine_id'].'" /></td>'
                                .'<input type="hidden" name="config_code_insert[]" value="'.$k.'" /></td>';
                    }
                    $table .= '<td style="padding:0px 10px 0px 5px">'.$configCode['machine_description'].'</td>';
                    $table .= '</tr>';
                }

                if ($data['export'] && $configCode['model_number']){
                    $export .= $configCode['model_number'].','.$configCode['count'].','.$configCode['order_number'].','.$configCode['machine_description'].",,,,,,,,,,\n";
                    $sum += (int)$configCode['count'];
                }
            }

            $table .= '<tr><td colspan="3"></td><td align="right"><input type="submit" id="update" name="update" value="Update" /><input type="submit" id="export" name="export" value="Export" /></td></tr>';

            if ($data['export']){

                $export = "Model,QTY,SKU,Description,A,B,C,D,Fixed Price,Expected Buy,Total Buy,SELL,EXT SELL,GP\n"
                        .$export
                        .",,,,,,,,,,,,,\n,,,,,,,,,,,,,\n"
                        .",$sum,,,,,,,,,,,,";

                $this->send_file_to_browser($export, 'serial_number_export.csv');

            }

            //add header to error table
            if ($errors != ''){
                $errors = '<tr><td colspan="4" style="color:red;"><strong>The following serial numbers do not have a configuration in the database</td></tr>'
                        .'<tr><td></td><td>Model</td><td>SKU</td><td>Description</td></tr>'.$errors
                        .'<tr><td colspan="3"></td><td align="right"><input type="submit" id="add" name="add" value="Add"</td></tr>';
            }

            $parse = array(
                'SERIAL_NUMBERS'    => $data['serialNumbers']
                ,'RESULT_TABLE'     => $table
                ,'ERRORS'           => $errors
            );

        }else{
            $parse = array(
                'SERIAL_NUMBERS'    => ''
                ,'RESULT_TABLE'     => ''
                ,'ERRORS'           => ''
            );
        }


        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(SERIAL_NUMBER_LOOKUP,$parse)));
    }

	/**
	 * Generates the template for the imaging control page.
	 */
    function imaging_control(){
		global $imagingObj;
		$imagingObj->imaging_control();
    }

    function audit_grade_update($data){

        //Initialise variables
        $grade = '';
        $a_count = 0;

        switch ($data['device']){
            case 'ipad':

                //Grade arrays
                $grade_a = array(
                    'home_button'  => array('pass','na')
                    ,'volume'   => array('pass','na')
                    ,'sleep_wake'   => array('pass','na')
                    ,'silent_rot'   => array('pass','na')
                    ,'headphone'    => array('pass','na')
                    ,'front_camera' => array('pass','na')
                    ,'rear_camera'  => array('pass','na')
                    ,'speaker'  => array('pass','na')
                    ,'mic'  => array('pass','na')
                    ,'charge'   => array('pass','na')
                    ,'wifi_ipad'    => array('pass','na')
                    ,'case_scratches2' => array(null,'Minor')
                );

                $grade_b = array(
                    'case_scratches'   => 'Minor'
                    ,'case_cdents'  => 'Minor'
                    ,'case_sdents' => 'Minor'
                    ,'case_edents'  => 'Minor'
                    ,'digi_scratches'   => 'Minor'
                );

                $grade_c = array(
                    'case_scratches'   => 'Major'
                    ,'case_cdents'  => 'Major'
                    ,'case_sdents' => 'Major'
                    ,'case_edents'  => 'Major'
					,'digi_scratches'   => array('Moderate', 'Major')
                    ,'lcd_white'    => 'Minor'
                    ,'lcd_dust' => 'Minor'
                );

                $grade_d = array(
					'lcd_white' => 'Major'
					// ,'digi_scratches' => 'Major'
                    ,'lcd_dust' => 'Major'
                    ,'digitizer_crack'  => 1
                    ,'digi_dis'  => 1
                    ,'digi_sep'  => 1
                    ,'digi_un'  => 1
                    ,'digi_lines'  => 1
                    ,'digi_touch'  => 1
                    ,'digi_video'  => 1
                    ,'home_button'  => 'fail'
                    ,'volume'   => 'fail'
                    ,'sleep_wake'   => 'fail'
                    ,'silent_rot'   => 'fail'
                    ,'headphone'    => 'fail'
                    ,'front_camera' => 'fail'
                    ,'rear_camera'  => 'fail'
                    ,'speaker'  => 'fail'
                    ,'mic'  => 'fail'
                    ,'charge'   => 'fail'
                    ,'wifi_ipad'    => 'fail'
                );

                $grade_f = array(
                    'boot_failure_ipad' => 1
                );

                break;

            case 'macbook':

                //Grade arrays
                $grade_a = array(
                    'keyboard'  => array('pass','na')
                    ,'trackpad'   => array('pass','na')
                    ,'optical'   => array('pass','na')
                    ,'lcd'   => array('pass','na')
                    ,'glass'    => array('pass','na')
                    ,'enet' => array('pass','na')
                    ,'ports'  => array('pass','na')
                    ,'wifi'  => array('pass','na')
                    ,'speakers'  => array('pass','na')
                    ,'isight'   => array('pass','na')
                    ,'battery'    => array('pass','na')
                    ,'case_scratches2' => array(null,'Minor')
                );

                $grade_b = array(
                    'case_scratches2'   => 'Minor'
                    ,'case_cracks'  => 'Minor'
                    ,'case_sdents2' => 'Minor'
                    ,'case_cdents2'  => 'Minor'
                    ,'LCD_scratches'   => 'Minor'
                    ,'case_keymarks'   => 'Minor'
                );

                $grade_c = array(
                    'case_scratches2'   => 'Major'
                    ,'case_cracks'  => 'Major'
                    ,'case_sdents2' => 'Major'
                    ,'case_cdents2'  => 'Major'
                    ,'case_keymarks'   => 'Major'
                    ,'digi_white'  => 1
                );

                $grade_d = array(
                    'LCD_scratches'   => 'Major'
					,'case_keymarks'    => 'Major'
					,'hinge' => 1
					,'refurb_keys' => 1
					,'case_track' => 1
					,'missing_feet' => 1
                    ,'broken_hinge'  => 1
                    ,'digi_dis'  => 1
                    ,'digitizer_crack'  => 1
                    ,'digi_lines'  => 1
                    ,'digi_video'  => 1
                    ,'hd_failure_osx'  => 1
                    ,'keyboard'  => 'fail'
                    ,'trackpad'   => 'fail'
                    ,'optical'   => 'fail'
                    ,'lcd'   => 'fail'
                    ,'glass'    => 'fail'
                    ,'enet' => 'fail'
                    ,'ports'  => 'fail'
                    ,'wifi'  => 'fail'
                    ,'speakers'  => 'fail'
                    ,'isight'   => 'fail'
                    ,'battery'    => 'fail'
                );

                $grade_f = array(
                    'boot_failure_osx' => 1
                );

                break;

            case 'imac':

                //Grade arrays
                $grade_a = array(
                    'optical'   => array('pass','na')
                    ,'lcd'   => array('pass','na')
                    ,'glass'    => array('pass','na')
                    ,'enet' => array('pass','na')
                    ,'ports'  => array('pass','na')
                    ,'wifi'  => array('pass','na')
                    ,'speakers'  => array('pass','na')
                    ,'isight'   => array('pass','na')
                    ,'case_scratches2' => array(null,'Minor')
                );

                $grade_b = array(
                    'case_scratches2'   => 'Minor'
                    ,'case_cracks'  => 'Minor'
                    ,'case_sdents2' => 'Minor'
                    ,'case_cdents2'  => 'Minor'
                    ,'LCD_scratches'   => 'Minor'
                );

                $grade_c = array(
                    'case_scratches2'   => 'Major'
                    ,'case_cracks'  => 'Major'
                    ,'case_sdents2' => 'Major'
                    ,'case_cdents2'  => 'Major'
                    ,'digi_white'  => 1
                );

                $grade_d = array(
                    'LCD_scratches'   => 'Major'
                    ,'digi_dis'  => 1
                    ,'digitizer_crack'  => 1
                    ,'digi_lines'  => 1
                    ,'digi_video'  => 1
                    ,'hd_failure_osx'  => 1
                    ,'optical'   => 'fail'
                    ,'lcd'   => 'fail'
                    ,'glass'    => 'fail'
                    ,'enet' => 'fail'
                    ,'ports'  => 'fail'
                    ,'wifi'  => 'fail'
                    ,'speakers'  => 'fail'
                    ,'isight'   => 'fail'
                );

                $grade_f = array(
                    'boot_failure_osx' => 1
                );

                break;
        }

        //Set to lowest grade sequentially
        foreach ($grade_a as $k => $v){
            if (is_array($v)){
                if (in_array($data[$k], $v)){
                    $a_count ++;
                }
            }else{
                if ($data[$k] == $v){
                    $a_count ++;
                }
            }
        }

        if ($a_count == count($grade_a)){
            $grade = 'A';
        }

        foreach ($grade_b as $k => $v){
			if (is_array($v)) {
				if (in_array($data[$k], $v)) {
					$grade = 'B';
					break;
				}
			} else {
				if ($data[$k] == $v){
					$grade = 'B';
					break;
				}
			}
        }

        foreach ($grade_c as $k => $v){
			if (is_array($v)) {
				if (in_array($data[$k], $v)) {
					$grade = 'C';
					break;
				}
			} else {
				if ($data[$k] == $v){
					$grade = 'C';
					break;
				}
			}
        }

        foreach ($grade_d as $k => $v){
            if ($data[$k] == $v){
                $grade = $grade.'D';
                //$dc = true;
                break;
            }
        }

        foreach ($grade_f as $k => $v){
            if ($data[$k] == $v){
                $grade = 'F';
            }
        }

        //Return grade
        echo $grade;

    }

    function device_repair(){

        global $orderObj;

        if ($_POST['submit']){

            $post = $_POST;

            $x = 0;

            foreach ($post['sp'] as $sp){
                if ($sp != ''){
                    $order = $this->db_select_single('ds_orders', 'oNum, oID',array('oNum' => $sp));
                    if ($post['noparts'][$x] != 'on'){
                        $part = $this->db_select_single('ds_products', '*',array('pNum' => $post['part'][$x]));
                        $part_array = array(
                            'pID' => $part['pID']
                            , 'pQty' => 1
                            , 'cSession' => $order['oID']
                            , 'oNum' => $order['oNum']
                            , 'taxable' => ''
                            , 'pName' => $part['pName']
                            , 'pNum' => $part['pNum']
                            , 'pPrice' => 0
                        );
                        $this->db_insert('ds_carts', $part_array);
                    }

                    $this->db_update('ds_orders', 'oID', $order['oID'], array('cStatus' => STATUS_REFURB_REPAIRED));

                    $log = 'Order status changed to '.STATUS_REFURB_REPAIRED;
                    $orderObj->insert_log($order['oNum'],'',$log);

                    $this->reprint_refurb_label($sp,'D');

                }
                $x++;
            }

            if ($post['hardware_only'] != ''){
                $hardware_only = explode("\n", $post['hardware_only']);

                foreach ($hardware_only as $hardware){

                    $this->db_update('ds_orders', 'oNum', trim($hardware), array('cStatus' => STATUS_REFURB_REPAIRED));

                    $log = 'Order status changed to '.STATUS_REFURB_REPAIRED;
                    $orderObj->insert_log(trim($hardware),'',$log);
                }
            }
        }
        echo $this->parse(TEMPLATE, array('BODY' => $this->parse(DEVICE_REPAIR,array())));
	}

	function getPrinters() {
        return $this->db_select_multiple('printers', 'printer_id, printer_queue, printer_name, printer_location' ,array(),'order by printer_name asc');
	}

	function buildPrinterList($selectedPrinter='', $valueField='printer_id') {
		$allPrinters = $this->getPrinters();
		$printers = array(
			'other' => array()
		);
		foreach ($allPrinters as $printer) {
			if ($printer['printer_location']) {
				if (!array_key_exists($printer['printer_location'], $printers)) {
					$printers[$printer['printer_location']] = array();
				}
				array_push($printers[$printer['printer_location']], $printer);
			} else {
				array_push($printers['other'], $printer);
			}
		}
		ksort($printers);
		$outString = '';
		foreach($printers as $location => $values) {
			$outString .= $this->buildPrinterCategory($this->getCategoryName($location), $values, $selectedPrinter, $valueField);
		}
		return $outString;
	}
	function buildPrinterCategory($categoryName, $printers, $selectedPrinter, $valueField='printer_id') {
		$outString = '';
		if (count($printers) > 0) {
			$outString .= "<option disabled>----$categoryName----</option>";
			foreach ($printers as $printer) {
				if ($printer['printer_id'] == $selectedPrinter){
					$outString .= '<option value="'.$printer[$valueField].'" selected>'.$printer['printer_name'].'</option>';
				}else{
					$outString .= '<option value="'.$printer[$valueField].'">'.$printer['printer_name'].'</option>';
				}
			}
		}
		return $outString;
	}
	function getCategoryName($category) {
		$name = ucwords(str_replace("_", " ", $category));
		return $name;
	}

	function checkAdminHasPagePermission($pageMethod, $adminString=null) {
		if (!$adminString) {
			$adminString = $this->getAdminString();
		}
		$sql = "SELECT dam.`ds_admin_modules_id`
				FROM `ds_admin_modules` AS dam
				LEFT JOIN `module` ON module.`module_id` = dam.`module_id`
				LEFT JOIN `ds_admins` AS dsa ON dam.`aID` = dsa.`aID`
				WHERE dsa.`aString`='$adminString'
				AND module.`module_method`='$pageMethod';";
		$result = $this->db_query($sql, 'select-single', true);
		if ($result['ds_admin_modules_id']) {
			return true;
		}
		else {
			return false;
		}
	}

	function getAdminString() {
		return $_SESSION['xdigiSHOPadmin'];
	}
}
?>
