<?php

class Shopify extends Database {
	/**
	 * Sets store name.
	 */
	private $storeName = 'tech-to-school';
	/**
	 * Sets current API version.
	 */
	private $apiVersion = '2020-07';
	/**
	 * Sets API key.
	 */
	private $apiKey = '62a0bddfc41ecc00f5ce8ad21e2e4050';
	/**
	 * Sets API password.
	 */
	private $password = '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';
	/**
	 * Sets API method.
	 */
	private $method = 'https';
	/**
	 * Sets base URL.
	 */
	private $baseUrl = '.myshopify.com/admin/api/';

	private $locationId = 17134092384;
	function getProductVariantsList() {
		$url = $this->getUrl() . "products.json?limit=250";
		// echo "<p>$url</p>";
		$data = json_decode($this->curl_get($url), true);
		$str = '';
		// echo print_r($data);
		echo count($data['products']);
		foreach ($data['products'] as $product) {
			// echo "hello";
			// "https://tech-to-school.myshopify.com/admin/products/4444908421216"
			$str .= "<ul><li><a href='https://tech-to-school.myshopify.com/admin/products/{$product['id']}' target='_blank'>{$product['title']}</a> - {$product['id']}</li><ul>";
			foreach ($product['variants'] as $variant) {
				$str .= "<li>SKU: {$variant['sku']}</li><ul><li>ID: {$variant['id']}</li><li>Inventory Item ID: {$variant['inventory_item_id']}</li><li>Option 1: {$variant['option1']}</li><li>Option 2: {$variant['option2']}</li><li>Option 3: {$variant['option3']}</li></ul>";
			}
			$str .= "</ul></ul><hr/>";
		}
		echo $str;
	}
	function getProduct() {
		$productId = trim($_GET['p'], " \t\n\r\0\x0B'\"");
		if ($_GET['v']) {
			$variantId = trim($_GET['v'], " \t\n\r\0\x0B'\"");
			return $this->getVariant($productId, $variantId);
		}
		$fields = '';
		if($fieldInput && is_array($fieldInput)) {
			$fields = '?fields=' . implode(',', $fieldInput);
		} elseif($fieldInput && !is_array($fieldInput)) {
			$fields = "?fields=$fieldInput";
		}

		$url = $this->getUrl() . "products/$productId.json$fields";
		echo "<p>$url</p>";
		$data = $this->curl_get($url, '');
		echo $data;
		$decoded = json_decode($data, true);
		return $decoded;
	}

	function getProductVariants($productId) {
		$productId = trim($productId, " \t\n\r\0\x0B'\"");
		$url = $this->getUrl() . "products/$productId/variants.json";
		$data = json_decode($this->curl_get($url), true);
		return $data;
	}

	function getVariant($variantId) {
		$variantId = trim($variantId, " \t\n\r\0\x0B'\"");
		if ($this->startsWith($variantId, "'")) {
			$variantId = substr($variantId, 1);
		}
		if ($this->endsWith($variantId, "'")) {
			$variantId = substr($variantId, 0, strlen($variantId - 1));
		}
		$url = $this->getUrl() . "variants/$variantId.json";
		$data = json_decode($this->curl_get($url), true);
		return $data;
	}

	function updateVariant($variantId, $data) {
		$url = $this->getUrl() . "variants/$variantId.json";
		$data['id'] = (int)$variantId;
		$putData = array(
			'variant' => $data
		);
		$response = $this->curl_put($url, $putData);
		return $response;
	}

	function updateInventoryLevel($data) {
		$url = $this->getUrl() . "inventory_levels/set.json";
		$data['location_id'] = $this->getLocationId();
		$headers = $this->getHeaders();
		return $this->curl_post_2($url, $data, $headers);
	}

	private function getHeaders() {
		return array(
			"Content-Type: application/json"
		);
	}

	function getAPIVersion() {
		return $this->apiVersion;
	}

	private function getAPIKey() {
		return $this->apiKey;
	}

	private function getAPIPassword() {
		return $this->password;
	}

	private function getLocationId() {
		return $this->locationId;
	}

	private function getAPIMethod() {
		return $this->method;
	}

	private function getBaseUrl() {
		return $this->baseUrl;
	}

	private function getStoreName() {
		return $this->storeName;
	}

	private function getUrl() {
		return $this->getAPIMethod() . '://' . $this->getAPIKey() .":" . $this->getAPIPassword() . "@" . $this->getStoreName() . $this->getBaseUrl() . $this->getAPIVersion() . "/";
	}
}

?>
