<?php

class ShopifyApi {
	private static $storeIdentifiers = array('tts', 'sp');
	/**
	 * Sets store name.
	 */
	private static $storeNames = array('tts' => 'tech-to-school', 'sp' => 'source-plus-store');
	/**
	 * Sets current API version.
	 */
	private static $apiVersion = '2020-07';
	/**
	 * Sets API key.
	 */
	private static $apiKey = '62a0bddfc41ecc00f5ce8ad21e2e4050';
	/**
	 * Sets API password.
	 */
	private static $password = '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';
	/**
	 * Sets API method.
	 */
	private static $method = 'https';
	/**
	 * Sets base URL.
	 */
	private static $baseUrl = '.myshopify.com/admin/api/';

	private static $locationId = 17134092384;

	public static function getProductVariantsList($store='tts') {
		$url = self::getUrl($store) . "products.json?limit=250";
		// echo "<p>$url</p>";
		$data = json_decode(Curl::get($url), true);
		$str = '';
		// echo print_r($data);
		// echo count($data['products']);
		foreach ($data['products'] as $product) {
			// echo "hello";
			// "https://tech-to-school.myshopify.com/admin/products/4444908421216"
			$str .= "<ul><li><a href='https://tech-to-school.myshopify.com/admin/products/{$product['id']}' target='_blank'>{$product['title']}</a> - {$product['id']}</li><ul>";
			foreach ($product['variants'] as $variant) {
				$str .= "<li>SKU: {$variant['sku']}</li><ul><li>ID: {$variant['id']}</li><li>Inventory Item ID: {$variant['inventory_item_id']}</li><li>Option 1: {$variant['option1']}</li><li>Option 2: {$variant['option2']}</li><li>Option 3: {$variant['option3']}</li></ul>";
			}
			$str .= "</ul></ul><hr/>";
		}
		echo $str;
	}

	public static function getProduct($productId, $variantId) {
		$productId = trim($_GET['p'], " \t\n\r\0\x0B'\"");
		if ($_GET['v']) {
			$variantId = trim($_GET['v'], " \t\n\r\0\x0B'\"");
			return self::getVariant($productId, $variantId);
		}
		$fields = '';
		if($fieldInput && is_array($fieldInput)) {
			$fields = '?fields=' . implode(',', $fieldInput);
		} elseif($fieldInput && !is_array($fieldInput)) {
			$fields = "?fields=$fieldInput";
		}

		$url = self::getUrl() . "products/$productId.json$fields";
		echo "<p>$url</p>";
		$data = Curl::get($url, '');
		echo $data;
		$decoded = json_decode($data, true);
		return $decoded;
	}

	public static function getProductVariants($productId) {
		$productId = trim($productId, " \t\n\r\0\x0B'\"");
		$url = self::getUrl() . "products/$productId/variants.json";
		$data = json_decode(Curl::get($url), true);
		return $data;
	}

	public static function getVariant($variantId) {
		$variantId = trim($variantId, " \t\n\r\0\x0B'\"");
		if (Utility::startsWith($variantId, "'")) {
			$variantId = substr($variantId, 1);
		}
		if (Utility::endsWith($variantId, "'")) {
			$variantId = substr($variantId, 0, strlen($variantId - 1));
		}
		$url = self::getUrl() . "variants/$variantId.json";
		$data = json_decode(Curl::get($url), true);

		return $data;
	}

	public static function updateVariant($variantId, $data) {
		$url = self::getUrl() . "variants/$variantId.json";
		$data['id'] = (int)$variantId;
		$putData = array(
			'variant' => $data
		);
		$response = Curl::put($url, $putData);
		return $response;
	}

	public static function updateInventoryLevel($data) {
		$url = self::getUrl() . "inventory_levels/set.json";
		$data['location_id'] = self::getLocationId();
		$headers = self::getHeaders();
		return Curl::post($url, $data, $headers);
	}

	private static function getHeaders() {
		return array(
			"Content-Type: application/json"
		);
	}

	private static function getAPIVersion() {
		return self::$apiVersion;
	}

	private static function getAPIKey() {
		return self::$apiKey;
	}

	private static function getAPIPassword() {
		return self::$password;
	}

	private static function getLocationId() {
		return self::$locationId;
	}

	private static function getAPIMethod() {
		return self::$method;
	}

	private static function getBaseUrl() {
		return self::$baseUrl;
	}

	private static function getStoreName($store) {
		$storeNames = self::getStoreNames();
		return $storeNames[$store];
	}

	private static function getUrl($store) {
		$storeIdentifiers = self::getStoreIdentifiers();
		if (in_array($store, $storeIdentifiers)) {
			return self::getAPIMethod() . '://' . self::getAPIKey() .":" . self::getAPIPassword() . "@" . self::getStoreName($store) . self::getBaseUrl() . self::getAPIVersion() . "/";
		}
		else {
			return null;
		}
	}

	private static function getStoreIdentifiers() {
		return self::$storeIdentifiers;
	}

	private static function getStoreNames() {
		return self::$storeNames;
	}
}

?>
