<?php
class NeweggAPI extends Database {
	private $sellerId = 'AMC3';
	private $version = '307';
	private $keyPath = '';
	private $apiKey = '';
	private $secretKey = '';
	private $urlBase = 'https://api.newegg.com/marketplace/';

	public function __construct() {
		$this->keyPath = HTML_FOLDER . "apis/newegg/keys/"; // For php 5.4 CLI compatibility
		$this->apiKey = $this->getApiKey();
		$this->secretKey = $this->getSecretKey();
	}

	public function apiTest() {
		$data = $this->getOrders();
		$decoded = json_decode($data);
		echo "<pre>$data</pre>";
		echo "<pre>";
		print_r($decoded);
		echo "</pre>";
	}

	public function shipOrder($orderNumber, $trackingNumber, $shipCarrier, $shipService, $sellerPartNumber, $shippedQty) {
		$url = $this->urlBase . "ordermgmt/orderstatus/orders/$orderNumber?sellerid={$this->sellerId}";
		$headers = array(
			"Authorization: {$this->apiKey}",
			"SecretKey: {$this->secretKey}",
			"Content-Type: application/json",
			"Accept: application/json"
		);

		$package = new stdClass;
		$package->TrackingNumber = $trackingNumber;
		$package->ShipCarrier = $shipCarrier;
		$package->ShipService = $shipService;
		$package->ItemList = new stdClass;
		$package->ItemList->Item = new stdClass;
		$package->ItemList->Item->SellerPartNumber = $sellerPartNumber;
		$package->ItemList->Item->ShippedQty = $shippedQty;

		$requestData = new stdClass;
		$requestData->Action = "2";
		$requestData->Value = new stdClass;
		$requestData->Value->Shipment = new stdClass;
		$requestData->Value->Shipment->Header = new stdClass;
		$requestData->Value->Shipment->Header->SellerID = $this->sellerId;
		$requestData->Value->Shipment->Header->SONumber = $orderNumber;

		$requestData->Value->Shipment->PackageList = new stdClass;
		$requestData->Value->Shipment->PackageList->Package = array($package);

		$response = $this->curl_put_2($url, $requestData, $headers);

		return $response;
	}

	public function getOrder($orderNumber) {
		$url = $this->urlBase . "ordermgmt/order/orderinfo?sellerid={$this->sellerId}";
		$headers = array(
			"Authorization: {$this->apiKey}",
			"SecretKey: {$this->secretKey}",
			"Content-Type: application/json",
			"Accept: application/json"
		);
		$requestData = new stdClass;
		$requestData->OperationType = "GetOrderInfoRequest";
		$requestData->RequestBody = new stdClass;
		$requestData->RequestBody->RequestCriteria = new stdClass;
		$requestData->RequestBody->RequestCriteria->OrderNumberList = new stdClass;
		$requestData->RequestBody->RequestCriteria->OrderNumberList->OrderNumber = array($orderNumber);
		$response = $this->curl_put_2($url, $requestData, $headers);
		return $response;
	}

	public function getOrders($pageIndex="1",$pageSize="100", $status="0") {
		$url = $this->urlBase . "ordermgmt/order/orderinfo?sellerid={$this->sellerId}&version={$this->version}";
		$headers = array(
			"Authorization: {$this->apiKey}",
			"SecretKey: {$this->secretKey}",
			"Content-Type: application/json",
			"Accept: application/json"
		);
		$requestData = new stdClass;
		$requestData->OperationType = "GetOrderInfoRequest";
		$requestData->RequestBody = new stdClass;
		$requestData->RequestBody->PageIndex = $pageIndex;
		$requestData->RequestBody->PageSize = $pageSize;
		$requestData->RequestBody->RequestCriteria = new stdClass;
		if ($status != '') {
			$requestData->RequestBody->RequestCriteria->Status = $status;
		}

		$response = $this->curl_put_2($url, $requestData, $headers);
		return $response;
	}

	public function getOrderHistory() {
		$firstResponse = json_decode($this->getOrders("1", "100", "3"));
		$orders = $firstResponse->ResponseBody->OrderInfoList;
		$pages = (int)$firstResponse->ResponseBody->PageInfo->TotalPageCount;
		for ($i = 2; $i <= $pages; $i++) {
			$response = json_decode($this->getOrders($i, 100, "3"));
			$newOrders = $response->ResponseBody->OrderInfoList;
			$orders = array_merge($orders, $newOrders);
		}
		return $orders;
	}

	public function getRMAInformation($pageIndex="1", $pageSize="100") {
		$version = '320';
		$url = $this->urlBase . "servicemgmt/rma/rmainfo?sellerid={$this->sellerId}&version=$version";
		$headers = array(
			"Authorization: {$this->apiKey}",
			"SecretKey: {$this->secretKey}",
			"Content-Type: application/json",
			"Accept: application/json"
		);
		$requestData = new stdClass;
		$requestData->OperationType = "GetRMAInfoRequest";
		$requestData->RequestBody = new stdClass;
		$requestData->RequestBody->PageInfo = new stdClass;
		$requestData->RequestBody->PageInfo->PageIndex = $pageIndex;
		$requestData->RequestBody->PageInfo->PageSize = $pageSize;
		$response = $this->curl_put_2($url, $requestData, $headers);
		return json_decode($response);
	}

	public function getRefundHistory() {
		$channelId = $this->getChannelId();
		$response = $this->getRMAInformation();
		$returns = $response->NeweggAPIResponse->ResponseBody->RMAInfoList->RMAInfo;
		foreach ($returns as $return) {
			if ($return->RMAType == '2' && $return->RMAStatus == '5') { // If it is a completed refund, proceed; else ignore.
				$orderId = $return->OrderNumber;
				$orderDate = DateTime::createFromFormat('m/d/Y H:i:s', $return->OrderDate)->format("Y-m-d H:i:s");
				$returnDate = DateTime::createFromFormat('m/d/Y H:i:s', $return->RMADate)->format("Y-m-d H:i:s");
				$orderAmount = $return->OrderAmount;
				$priorRefund = (float)$return->PriorRefundAmount;
				if ($return->RMATransactionList->RMATransaction) {
					$returnQuantity = (int)$return->RMATransactionList->RMATransaction->ReturnQuantity;
					$returnUnitPrice = (float)$return->RMATransactionList->RMATransaction->ReturnUnitPrice;
				}
				else {
					$returnQuantity = 0;
					$returnUnitPrice = 0;
				}
				$rmaStatus = $return->RMAStatus;
				$rmaStatusDescription = $return->RMAStatusDescription;
				$refundAmount = $priorRefund + ($returnQuantity * $returnUnitPrice);

				$ecommId = $this->getEcommId($orderId, $channelId);

				$sql = "INSERT IGNORE INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$refundAmount') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$refundAmount';";

				$this->db_query($sql, 'insert', true);
			}
		}
	}

	private function getApiKey() {
		return trim(file_get_contents($this->keyPath . 'api_key.txt'));
	}

	private function getSecretKey() {
		return trim(file_get_contents($this->keyPath . 'secret_key.txt'));
	}

	public function getChannelId() {
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='newegg' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}

	private function getEcommId($orderId, $channelId = null) {
		if (!$channelId) {
			$channelId = $this->getChannelId();
		}
		$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
		$response = $this->db_query($sql, 'select-single', true);
		return $response['id'];
	}
}
